# oommfc
Marijan Beg<sup>1,2</sup>, Ryan A. Pepper<sup>1</sup>, Thomas Kluyver<sup>2</sup>, and Hans Fangohr<sup>1,2</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*  
<sup>2</sup> *European XFEL GmbH, Holzkoppel 4, 22869 Schenefeld, Germany*  

| Description | Badge |
| --- | --- |
| Releases | [![PyPI version](https://badge.fury.io/py/oommfc.svg)](https://badge.fury.io/py/oommfc) |
|          | [![Anaconda-Server Badge](https://anaconda.org/conda-forge/oommfc/badges/version.svg)](https://anaconda.org/conda-forge/oommfc) |
| Builds | [![Build Status](https://travis-ci.org/ubermag/oommfc.svg?branch=master)](https://travis-ci.org/ubermag/oommfc) |
|        | [![Build status](https://ci.appveyor.com/api/projects/status/dsbae0ntj4coa9hl?svg=true)](https://ci.appveyor.com/project/marijanbeg/oommfc) |
| Coverage | [![codecov](https://codecov.io/gh/ubermag/oommfc/branch/master/graph/badge.svg)](https://codecov.io/gh/ubermag/oommfc) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/oommfc/badge/?version=latest)](https://oommfc.readthedocs.io/en/latest/?badge=latest) |
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/ubermag/oommfc/master?urlpath=lab/tree/docs/ipynb/index.ipynb) |
| Platforms | [![Platforms](https://anaconda.org/conda-forge/oommfc/badges/platforms.svg)](https://anaconda.org/conda-forge/oommfc) |
| Downloads | [![Downloads](https://anaconda.org/conda-forge/oommfc/badges/downloads.svg)](https://anaconda.org/conda-forge/oommfc) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3539494.svg)](https://doi.org/10.5281/zenodo.3539494) |

## About

`oommfc` is a Python package that provides:

- An Object Oriented MicroMagnetic Framework [OOMMF](https://math.nist.gov/oommf/) calculator for micromagnetic systems defined using `micromagneticmodel`.

It is available on Windows, MacOS, and Linux. It requires Python 3.6+.

## Documentation

APIs and tutorials are available in documentation. To access them, use the documentation badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the Binder badge in the table above.

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in [ubermag/help](https://github.com/ubermag/help) repository.

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

If you use this package, please cite it as:

1. M. Beg, R. A. Pepper, and H. Fangohr. User interfaces for computational science: A domain specific language for OOMMF embedded in Python. [*AIP Advances* **7**, 56025 (2017)](http://aip.scitation.org/doi/10.1063/1.4977225).

2. M. Beg, R. A. Pepper, T. Kluyver, and H. Fangohr. ubermag/oommfc: Python interface to OOMMF integrated into Jupyter notebook. Zenodo. DOI: [10.5281/zenodo.3539494](http://doi.org/10.5281/zenodo.3539494) (2020).

## Acknowledgements

- [OpenDreamKit](http://opendreamkit.org/) – Horizon 2020 European Research Infrastructure project (676541)

- EPSRC Programme grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1).
