# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/base/reflection/v2alpha1/reflection.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class AppDescriptor(betterproto.Message):
    """AppDescriptor describes a cosmos-sdk based application"""

    # AuthnDescriptor provides information on how to authenticate transactions on
    # the application NOTE: experimental and subject to change in future
    # releases.
    authn: "AuthnDescriptor" = betterproto.message_field(1)
    # chain provides the chain descriptor
    chain: "ChainDescriptor" = betterproto.message_field(2)
    # codec provides metadata information regarding codec related types
    codec: "CodecDescriptor" = betterproto.message_field(3)
    # configuration provides metadata information regarding the sdk.Config type
    configuration: "ConfigurationDescriptor" = betterproto.message_field(4)
    # query_services provides metadata information regarding the available
    # queriable endpoints
    query_services: "QueryServicesDescriptor" = betterproto.message_field(5)
    # tx provides metadata information regarding how to send transactions to the
    # given application
    tx: "TxDescriptor" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class TxDescriptor(betterproto.Message):
    """TxDescriptor describes the accepted transaction type"""

    # fullname is the protobuf fullname of the raw transaction type (for instance
    # the tx.Tx type) it is not meant to support polymorphism of transaction
    # types, it is supposed to be used by reflection clients to understand if
    # they can handle a specific transaction type in an application.
    fullname: str = betterproto.string_field(1)
    # msgs lists the accepted application messages (sdk.Msg)
    msgs: List["MsgDescriptor"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class AuthnDescriptor(betterproto.Message):
    """
    AuthnDescriptor provides information on how to sign transactions without
    relying on the online RPCs GetTxMetadata and CombineUnsignedTxAndSignatures
    """

    # sign_modes defines the supported signature algorithm
    sign_modes: List["SigningModeDescriptor"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SigningModeDescriptor(betterproto.Message):
    """
    SigningModeDescriptor provides information on a signing flow of the
    application NOTE(fdymylja): here we could go as far as providing an entire
    flow on how to sign a message given a SigningModeDescriptor, but it's
    better to think about this another time
    """

    # name defines the unique name of the signing mode
    name: str = betterproto.string_field(1)
    # number is the unique int32 identifier for the sign_mode enum
    number: int = betterproto.int32_field(2)
    # authn_info_provider_method_fullname defines the fullname of the method to
    # call to get the metadata required to authenticate using the provided
    # sign_modes
    authn_info_provider_method_fullname: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ChainDescriptor(betterproto.Message):
    """ChainDescriptor describes chain information of the application"""

    # id is the chain id
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CodecDescriptor(betterproto.Message):
    """
    CodecDescriptor describes the registered interfaces and provides metadata
    information on the types
    """

    # interfaces is a list of the registerted interfaces descriptors
    interfaces: List["InterfaceDescriptor"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class InterfaceDescriptor(betterproto.Message):
    """InterfaceDescriptor describes the implementation of an interface"""

    # fullname is the name of the interface
    fullname: str = betterproto.string_field(1)
    # interface_accepting_messages contains information regarding the proto
    # messages which contain the interface as google.protobuf.Any field
    interface_accepting_messages: List[
        "InterfaceAcceptingMessageDescriptor"
    ] = betterproto.message_field(2)
    # interface_implementers is a list of the descriptors of the interface
    # implementers
    interface_implementers: List[
        "InterfaceImplementerDescriptor"
    ] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class InterfaceImplementerDescriptor(betterproto.Message):
    """InterfaceImplementerDescriptor describes an interface implementer"""

    # fullname is the protobuf queryable name of the interface implementer
    fullname: str = betterproto.string_field(1)
    # type_url defines the type URL used when marshalling the type as any this is
    # required so we can provide type safe google.protobuf.Any marshalling and
    # unmarshalling, making sure that we don't accept just 'any' type in our
    # interface fields
    type_url: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class InterfaceAcceptingMessageDescriptor(betterproto.Message):
    """
    InterfaceAcceptingMessageDescriptor describes a protobuf message which
    contains an interface represented as a google.protobuf.Any
    """

    # fullname is the protobuf fullname of the type containing the interface
    fullname: str = betterproto.string_field(1)
    # field_descriptor_names is a list of the protobuf name (not fullname) of the
    # field which contains the interface as google.protobuf.Any (the interface is
    # the same, but it can be in multiple fields of the same proto message)
    field_descriptor_names: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ConfigurationDescriptor(betterproto.Message):
    """
    ConfigurationDescriptor contains metadata information on the sdk.Config
    """

    # bech32_account_address_prefix is the account address prefix
    bech32_account_address_prefix: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgDescriptor(betterproto.Message):
    """
    MsgDescriptor describes a cosmos-sdk message that can be delivered with a
    transaction
    """

    # msg_type_url contains the TypeURL of a sdk.Msg.
    msg_type_url: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetAuthnDescriptorRequest(betterproto.Message):
    """
    GetAuthnDescriptorRequest is the request used for the GetAuthnDescriptor
    RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetAuthnDescriptorResponse(betterproto.Message):
    """
    GetAuthnDescriptorResponse is the response returned by the
    GetAuthnDescriptor RPC
    """

    # authn describes how to authenticate to the application when sending
    # transactions
    authn: "AuthnDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetChainDescriptorRequest(betterproto.Message):
    """
    GetChainDescriptorRequest is the request used for the GetChainDescriptor
    RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetChainDescriptorResponse(betterproto.Message):
    """
    GetChainDescriptorResponse is the response returned by the
    GetChainDescriptor RPC
    """

    # chain describes application chain information
    chain: "ChainDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetCodecDescriptorRequest(betterproto.Message):
    """
    GetCodecDescriptorRequest is the request used for the GetCodecDescriptor
    RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetCodecDescriptorResponse(betterproto.Message):
    """
    GetCodecDescriptorResponse is the response returned by the
    GetCodecDescriptor RPC
    """

    # codec describes the application codec such as registered interfaces and
    # implementations
    codec: "CodecDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetConfigurationDescriptorRequest(betterproto.Message):
    """
    GetConfigurationDescriptorRequest is the request used for the
    GetConfigurationDescriptor RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetConfigurationDescriptorResponse(betterproto.Message):
    """
    GetConfigurationDescriptorResponse is the response returned by the
    GetConfigurationDescriptor RPC
    """

    # config describes the application's sdk.Config
    config: "ConfigurationDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetQueryServicesDescriptorRequest(betterproto.Message):
    """
    GetQueryServicesDescriptorRequest is the request used for the
    GetQueryServicesDescriptor RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetQueryServicesDescriptorResponse(betterproto.Message):
    """
    GetQueryServicesDescriptorResponse is the response returned by the
    GetQueryServicesDescriptor RPC
    """

    # queries provides information on the available queryable services
    queries: "QueryServicesDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetTxDescriptorRequest(betterproto.Message):
    """
    GetTxDescriptorRequest is the request used for the GetTxDescriptor RPC
    """

    pass


@dataclass(eq=False, repr=False)
class GetTxDescriptorResponse(betterproto.Message):
    """
    GetTxDescriptorResponse is the response returned by the GetTxDescriptor RPC
    """

    # tx provides information on msgs that can be forwarded to the application
    # alongside the accepted transaction protobuf type
    tx: "TxDescriptor" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryServicesDescriptor(betterproto.Message):
    """
    QueryServicesDescriptor contains the list of cosmos-sdk queriable services
    """

    # query_services is a list of cosmos-sdk QueryServiceDescriptor
    query_services: List["QueryServiceDescriptor"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryServiceDescriptor(betterproto.Message):
    """QueryServiceDescriptor describes a cosmos-sdk queryable service"""

    # fullname is the protobuf fullname of the service descriptor
    fullname: str = betterproto.string_field(1)
    # is_module describes if this service is actually exposed by an application's
    # module
    is_module: bool = betterproto.bool_field(2)
    # methods provides a list of query service methods
    methods: List["QueryMethodDescriptor"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class QueryMethodDescriptor(betterproto.Message):
    """
    QueryMethodDescriptor describes a queryable method of a query service no
    other info is provided beside method name and tendermint queryable path
    because it would be redundant with the grpc reflection service
    """

    # name is the protobuf name (not fullname) of the method
    name: str = betterproto.string_field(1)
    # full_query_path is the path that can be used to query this method via
    # tendermint abci.Query
    full_query_path: str = betterproto.string_field(2)


class ReflectionServiceStub(betterproto.ServiceStub):
    async def get_authn_descriptor(self) -> "GetAuthnDescriptorResponse":

        request = GetAuthnDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetAuthnDescriptor",
            request,
            GetAuthnDescriptorResponse,
        )

    async def get_chain_descriptor(self) -> "GetChainDescriptorResponse":

        request = GetChainDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetChainDescriptor",
            request,
            GetChainDescriptorResponse,
        )

    async def get_codec_descriptor(self) -> "GetCodecDescriptorResponse":

        request = GetCodecDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetCodecDescriptor",
            request,
            GetCodecDescriptorResponse,
        )

    async def get_configuration_descriptor(
        self,
    ) -> "GetConfigurationDescriptorResponse":

        request = GetConfigurationDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetConfigurationDescriptor",
            request,
            GetConfigurationDescriptorResponse,
        )

    async def get_query_services_descriptor(
        self,
    ) -> "GetQueryServicesDescriptorResponse":

        request = GetQueryServicesDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetQueryServicesDescriptor",
            request,
            GetQueryServicesDescriptorResponse,
        )

    async def get_tx_descriptor(self) -> "GetTxDescriptorResponse":

        request = GetTxDescriptorRequest()

        return await self._unary_unary(
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetTxDescriptor",
            request,
            GetTxDescriptorResponse,
        )


class ReflectionServiceBase(ServiceBase):
    async def get_authn_descriptor(self) -> "GetAuthnDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_chain_descriptor(self) -> "GetChainDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_codec_descriptor(self) -> "GetCodecDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_configuration_descriptor(
        self,
    ) -> "GetConfigurationDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_query_services_descriptor(
        self,
    ) -> "GetQueryServicesDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_tx_descriptor(self) -> "GetTxDescriptorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_authn_descriptor(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_authn_descriptor(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_chain_descriptor(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_chain_descriptor(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_codec_descriptor(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_codec_descriptor(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_configuration_descriptor(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_configuration_descriptor(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_query_services_descriptor(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_query_services_descriptor(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_tx_descriptor(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_tx_descriptor(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetAuthnDescriptor": grpclib.const.Handler(
                self.__rpc_get_authn_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetAuthnDescriptorRequest,
                GetAuthnDescriptorResponse,
            ),
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetChainDescriptor": grpclib.const.Handler(
                self.__rpc_get_chain_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetChainDescriptorRequest,
                GetChainDescriptorResponse,
            ),
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetCodecDescriptor": grpclib.const.Handler(
                self.__rpc_get_codec_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetCodecDescriptorRequest,
                GetCodecDescriptorResponse,
            ),
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetConfigurationDescriptor": grpclib.const.Handler(
                self.__rpc_get_configuration_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetConfigurationDescriptorRequest,
                GetConfigurationDescriptorResponse,
            ),
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetQueryServicesDescriptor": grpclib.const.Handler(
                self.__rpc_get_query_services_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetQueryServicesDescriptorRequest,
                GetQueryServicesDescriptorResponse,
            ),
            "/cosmos.base.reflection.v2alpha1.ReflectionService/GetTxDescriptor": grpclib.const.Handler(
                self.__rpc_get_tx_descriptor,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTxDescriptorRequest,
                GetTxDescriptorResponse,
            ),
        }
