# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.


import os.path
import sys

sys.path.insert(0, os.path.abspath("../.."))
sys.path.insert(0, ".")

from datetime import date

import sphinx_simplify_typehints  # @UnresolvedImport @UnusedImport

# -- Project information -----------------------------------------------------

project = "py-pde"
module_name = "pde"
author = "David Zwicker"
copyright = f"{date.today().year}, {author}"  # @ReservedAssignment

# Determine the version from the actual package
import pde

version = pde.__version__.split("-")[0]
release = pde.__version__


# -- Pre-processing ---------------------------------------------------
# from parse_examples import main
# main()


# -- General configuration ---------------------------------------------------

# Sphinx extension modules
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.intersphinx",
    "sphinx.ext.coverage",
    #     'sphinx.ext.mathjax',
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    #     'sphinx_autodoc_annotation',
    "sphinx_simplify_typehints",
    "sphinx.ext.inheritance_diagram",
    "sphinx_gallery.gen_gallery",
]

templates_path = ["_templates"]
source_suffix = ".rst"

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = False

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

modindex_common_prefix = [f"{module_name}."]


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    # Toc options
    "collapse_navigation": False,
    "sticky_navigation": True,
    "navigation_depth": 4,
    #     'includehidden': True,
    #     'titles_only': False
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

html_css_files = [
    "custom.css",
]

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = f"{project}-doc"


# -- Options for LaTeX output ------------------------------------------------

latex_engine = "xelatex"

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        f"{project}.tex",
        f"{project} Documentation",
        "David Zwicker",
        "manual",
    ),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, project, f"{project} Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        project,
        f"{project} Documentation",
        author,
        project,
        "One line description of project.",
        "Miscellaneous",
    ),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]


# -- Extension configuration -------------------------------------------------

autoclass_content = "both"  # include __init__ docstring in class description

napoleon_google_docstring = True
napoleon_numpy_docstring = False
napoleon_include_init_with_doc = False
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = False
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = True
napoleon_use_rtype = True
napoleon_use_keyword = True
napoleon_custom_sections = None

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "https://docs.python.org/3/": None,
    "https://numpy.org/doc/stable": None,
    "https://docs.scipy.org/doc/scipy/reference": None,
    "https://docs.sympy.org/latest/": None,
    "https://matplotlib.org": None,
    "https://docs.h5py.org/en/latest": None,
    "https://napari.org/docs/dev": None,
}


# -- Options for sphinx-gallery extension ---------------------------------------

# filter toctree, inspired by https://stackoverflow.com/a/46600038/932593
sys.path.append(os.path.abspath("../sphinx_ext/"))
extensions.append("toctree_filter")
extensions.append("package_config")
if tags.has("exclude_gallery"):
    # exclude gallery from toc when creating a latex document
    print("Example gallery will be excluded...")
    toc_filter_exclude = ["gallery"]
else:
    print("NORMAL DOC")
    toc_filter_exclude = []


sphinx_gallery_conf = {
    "examples_dirs": "../../examples",
    "gallery_dirs": "examples_gallery",
    "filename_pattern": "/",
    "ignore_pattern": r".*movie.*|.*interactive.*",
    "capture_repr": (),
    "show_signature": False,
}

# run autodoc
from run_autodoc import main

main()
