"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISCARD = exports.Errors = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Predefined error strings Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html.
 *
 * @stability stable
 */
class Errors {
}
exports.Errors = Errors;
_a = JSII_RTTI_SYMBOL_1;
Errors[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Errors", version: "1.119.0" };
/**
 * Matches any Error.
 *
 * @stability stable
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 *
 * @stability stable
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 *
 * @stability stable
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute the specified code.
 *
 * @stability stable
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 *
 * @stability stable
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose name ends in “.$” using a Path failed.
 *
 * @stability stable
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 *
 * @stability stable
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted from its input.
 *
 * @stability stable
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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