from __future__ import absolute_import

from enum import IntEnum
from array import array

from jpype import *
from jpype.types import *
from jpype import imports

from com.aspose.cells.wrapper import StreamBuffer
@JImplementationFor("com.aspose.cells.wrapper.StreamBuffer")
class _StreamBuffer(object):
    @JOverride(sticky=False)
    def write(self, chunk):
        if chunk == None:
            raise Exception("chunk is required")
        elif chunk.__class__.__name__ != 'bytes':
            raise TypeError("a bytes-like object is required")
        elif len(chunk) <= 0:
            raise ValueError("no content")
        self.writeStream(chunk, 0, len(chunk))

class AccessCacheOptions(IntEnum):
    ALL = -1,
    CALCULATE_FORMULA = 8388617,
    CELL_DISPLAY = 1048710,
    CELLS_DATA = 9,
    CONDITIONAL_FORMATTING = 16777225,
    GET_FORMULA = 2097152,
    NONE = 0,
    POSITION_AND_SIZE = 3,
    SET_FORMULA = 4194304,
    VALIDATION = 33554441,
class AutoFillType(IntEnum):
    COPY = 1,
    DEFAULT = 0,
    FORMATS = 3,
    SERIES = 2,
    VALUES = 4,
class AutoFitMergedCellsType(IntEnum):
    EACH_LINE = 3,
    FIRST_LINE = 1,
    LAST_LINE = 2,
    NONE = 0,
class AutoFitWrappedTextType(IntEnum):
    DEFAULT = 0,
    PARAGRAPH = 1,
class AutoShapeType(IntEnum):
    ARC = 19,
    BACK_PREVIOUS_ACTION_BUTTON = 194,
    BALLOON = 17,
    BEGINNING_ACTION_BUTTON = 196,
    BENT_ARROW = 91,
    BENT_CONNECTOR_2 = 33,
    BENT_CONNECTOR_4 = 35,
    BENT_CONNECTOR_5 = 36,
    BENT_UP_ARROW = 90,
    BEVEL = 84,
    BLANK_ACTION_BUTTON = 189,
    BLOCK_ARC = 95,
    CAN = 22,
    CHART_PLUS = 2105,
    CHART_STAR = 2104,
    CHART_X = 2103,
    CHEVRON = 55,
    CHORD = 2069,
    CIRCULAR_ARROW = 99,
    CLOUD = 2070,
    CLOUD_CALLOUT = 106,
    CORNER_TABS = 2100,
    CROSS = 11,
    CUBE = 16,
    CURVED_CONNECTOR = 38,
    CURVED_CONNECTOR_2 = 37,
    CURVED_CONNECTOR_4 = 39,
    CURVED_CONNECTOR_5 = 40,
    CURVED_DOWN_ARROW = 105,
    CURVED_DOWN_RIBBON = 107,
    CURVED_LEFT_ARROW = 103,
    CURVED_RIGHT_ARROW = 102,
    CURVED_UP_ARROW = 104,
    CURVED_UP_RIBBON = 108,
    DECAGON = 2050,
    DIAGONAL_STRIPE = 2068,
    DIAMOND = 4,
    DOCUMENT_ACTION_BUTTON = 198,
    DODECAGON = 2051,
    DONUT = 23,
    DOUBLE_BRACE = 186,
    DOUBLE_BRACKET = 185,
    DOUBLE_WAVE = 188,
    DOWN_ARROW = 67,
    DOWN_ARROW_CALLOUT = 80,
    DOWN_RIBBON = 53,
    ELBOW_CONNECTOR = 34,
    END_ACTION_BUTTON = 195,
    EXPLOSION_1 = 71,
    EXPLOSION_2 = 72,
    FLOW_CHART_ALTERNATE_PROCESS = 176,
    FLOW_CHART_CARD = 121,
    FLOW_CHART_COLLATE = 125,
    FLOW_CHART_CONNECTOR = 120,
    FLOW_CHART_DATA = 111,
    FLOW_CHART_DECISION = 110,
    FLOW_CHART_DELAY = 135,
    FLOW_CHART_DIRECT_ACCESS_STORAGE = 133,
    FLOW_CHART_DISPLAY = 134,
    FLOW_CHART_DOCUMENT = 114,
    FLOW_CHART_EXTRACT = 127,
    FLOW_CHART_INTERNAL_STORAGE = 113,
    FLOW_CHART_MAGNETIC_DISK = 132,
    FLOW_CHART_MANUAL_INPUT = 118,
    FLOW_CHART_MANUAL_OPERATION = 119,
    FLOW_CHART_MERGE = 128,
    FLOW_CHART_MULTIDOCUMENT = 115,
    FLOW_CHART_OFFLINE_STORAGE = 129,
    FLOW_CHART_OFFPAGE_CONNECTOR = 177,
    FLOW_CHART_OR = 124,
    FLOW_CHART_PREDEFINED_PROCESS = 112,
    FLOW_CHART_PREPARATION = 117,
    FLOW_CHART_PROCESS = 109,
    FLOW_CHART_PUNCHED_TAPE = 122,
    FLOW_CHART_SEQUENTIAL_ACCESS_STORAGE = 131,
    FLOW_CHART_SORT = 126,
    FLOW_CHART_STORED_DATA = 130,
    FLOW_CHART_SUMMING_JUNCTION = 123,
    FLOW_CHART_TERMINATOR = 116,
    FOLDED_CORNER = 65,
    FORWARD_NEXT_ACTION_BUTTON = 193,
    FRAME = 2106,
    FUNNEL = 2099,
    GEAR_6 = 2097,
    GEAR_9 = 2098,
    HALF_FRAME = 2066,
    HEART = 74,
    HELP_ACTION_BUTTON = 191,
    HEPTAGON = 2049,
    HEXAGON = 9,
    HOME_ACTION_BUTTON = 190,
    HOME_PLATE = 15,
    HORIZONTAL_SCROLL = 98,
    HOST_CONTROL = 201,
    INFORMATION_ACTION_BUTTON = 192,
    ISOSCELES_TRIANGLE = 5,
    L_SHAPE = 2067,
    LEFT_ARROW = 66,
    LEFT_ARROW_CALLOUT = 77,
    LEFT_BRACE = 87,
    LEFT_BRACKET = 85,
    LEFT_CIRCULAR_ARROW = 2080,
    LEFT_RIGHT_ARROW = 69,
    LEFT_RIGHT_ARROW_CALLOUT = 81,
    LEFT_RIGHT_CIRCULAR_ARROW = 2081,
    LEFT_RIGHT_RIBBON = 2083,
    LEFT_RIGHT_UP_ARROW = 182,
    LEFT_UP_ARROW = 89,
    LIGHTNING_BOLT = 73,
    LINE = 20,
    LINE_CALLOUT_NO_BORDER_1 = 178,
    LINE_CALLOUT_NO_BORDER_2 = 41,
    LINE_CALLOUT_NO_BORDER_3 = 42,
    LINE_CALLOUT_NO_BORDER_4 = 43,
    LINE_CALLOUT_WITH_ACCENT_BAR_1 = 179,
    LINE_CALLOUT_WITH_ACCENT_BAR_2 = 44,
    LINE_CALLOUT_WITH_ACCENT_BAR_3 = 45,
    LINE_CALLOUT_WITH_ACCENT_BAR_4 = 46,
    LINE_CALLOUT_WITH_BORDER_1 = 180,
    LINE_CALLOUT_WITH_BORDER_2 = 47,
    LINE_CALLOUT_WITH_BORDER_3 = 48,
    LINE_CALLOUT_WITH_BORDER_4 = 49,
    LINE_CALLOUT_WITH_BORDER_AND_ACCENT_BAR_1 = 181,
    LINE_CALLOUT_WITH_BORDER_AND_ACCENT_BAR_2 = 50,
    LINE_CALLOUT_WITH_BORDER_AND_ACCENT_BAR_3 = 51,
    LINE_CALLOUT_WITH_BORDER_AND_ACCENT_BAR_4 = 52,
    LINE_INV = 2077,
    MATH_DIVIDE = 2074,
    MATH_EQUAL = 2075,
    MATH_MINUS = 2072,
    MATH_MULTIPLY = 2073,
    MATH_NOT_EQUAL = 2076,
    MATH_PLUS = 2071,
    MODEL_3_D = 2107,
    MOON = 184,
    MOVIE_ACTION_BUTTON = 200,
    MSOSPT_TEXT_ON_RING = 31,
    NO_SYMBOL = 57,
    NON_ISOSCELES_TRAPEZOID = 2078,
    NOT_PRIMITIVE = 0,
    NOTCHED_CIRCULAR_ARROW = 100,
    NOTCHED_RIGHT_ARROW = 94,
    OCTAGON = 10,
    OVAL = 3,
    OVAL_CALLOUT = 63,
    PARALLELOGRAM = 7,
    PICTURE_FRAME = 75,
    PIE = 2064,
    PIE_WEDGE = 2079,
    PLAQUE = 21,
    PLAQUE_TABS = 2102,
    QUAD_ARROW = 76,
    QUAD_ARROW_CALLOUT = 83,
    RECTANGLE = 1,
    RECTANGULAR_CALLOUT = 61,
    REGULAR_PENTAGON = 56,
    RETURN_ACTION_BUTTON = 197,
    RIGHT_ARROW = 13,
    RIGHT_ARROW_CALLOUT = 78,
    RIGHT_BRACE = 88,
    RIGHT_BRACKET = 86,
    RIGHT_TRIANGLE = 6,
    ROUND_CALLOUT = 2108,
    ROUND_DIAGONAL_CORNER_RECTANGLE = 2058,
    ROUND_SAME_SIDE_CORNER_RECTANGLE = 2057,
    ROUND_SINGLE_CORNER_RECTANGLE = 2056,
    ROUNDED_RECTANGLE = 2,
    ROUNDED_RECTANGULAR_CALLOUT = 62,
    SEAL = 18,
    SMILEY_FACE = 96,
    SNIP_DIAGONAL_CORNER_RECTANGLE = 2062,
    SNIP_ROUND_SINGLE_CORNER_RECTANGLE = 2059,
    SNIP_SAME_SIDE_CORNER_RECTANGLE = 2061,
    SNIP_SINGLE_CORNER_RECTANGLE = 2060,
    SOUND_ACTION_BUTTON = 199,
    SQUARE_TABS = 2101,
    STAR_10 = 2054,
    STAR_12 = 2055,
    STAR_16 = 59,
    STAR_24 = 92,
    STAR_32 = 60,
    STAR_4 = 187,
    STAR_5 = 12,
    STAR_6 = 2052,
    STAR_7 = 2053,
    STAR_8 = 58,
    STRAIGHT_CONNECTOR = 32,
    STRIPED_RIGHT_ARROW = 93,
    SUN = 183,
    SWOOSH_ARROW = 2082,
    TEARDROP = 2063,
    TEXT_ARCH_DOWN_CURVE = 145,
    TEXT_ARCH_DOWN_POUR = 149,
    TEXT_ARCH_LEFT_CURVE = 2111,
    TEXT_ARCH_LEFT_POUR = 2109,
    TEXT_ARCH_RIGHT_CURVE = 2112,
    TEXT_ARCH_RIGHT_POUR = 2110,
    TEXT_ARCH_UP_CURVE = 144,
    TEXT_ARCH_UP_POUR = 148,
    TEXT_BOX = 202,
    TEXT_BUTTON_CURVE = 147,
    TEXT_BUTTON_POUR = 151,
    TEXT_CAN_DOWN = 175,
    TEXT_CAN_UP = 174,
    TEXT_CASCADE_DOWN = 155,
    TEXT_CASCADE_UP = 154,
    TEXT_CHEVRON = 140,
    TEXT_CHEVRON_INVERTED = 141,
    TEXT_CIRCLE_CURVE = 146,
    TEXT_CIRCLE_POUR = 150,
    TEXT_CURVE = 27,
    TEXT_CURVE_DOWN = 153,
    TEXT_CURVE_UP = 152,
    TEXT_DEFLATE = 161,
    TEXT_DEFLATE_BOTTOM = 163,
    TEXT_DEFLATE_INFLATE = 166,
    TEXT_DEFLATE_INFLATE_DEFLATE = 167,
    TEXT_DEFLATE_TOP = 165,
    TEXT_DOUBLE_WAVE_1 = 158,
    TEXT_DOUBLE_WAVE_2 = 159,
    TEXT_FADE_DOWN = 171,
    TEXT_FADE_LEFT = 169,
    TEXT_FADE_RIGHT = 168,
    TEXT_FADE_UP = 170,
    TEXT_HEXAGON = 26,
    TEXT_INFLATE = 160,
    TEXT_INFLATE_BOTTOM = 162,
    TEXT_INFLATE_TOP = 164,
    TEXT_NO_SHAPE = 2084,
    TEXT_OCTAGON = 25,
    TEXT_ON_CURVE = 30,
    TEXT_PLAIN_TEXT = 136,
    TEXT_RING = 29,
    TEXT_RING_INSIDE = 142,
    TEXT_RING_OUTSIDE = 143,
    TEXT_SIMPLE = 24,
    TEXT_SLANT_DOWN = 173,
    TEXT_SLANT_UP = 172,
    TEXT_STOP = 137,
    TEXT_TRIANGLE = 138,
    TEXT_TRIANGLE_INVERTED = 139,
    TEXT_WAVE = 28,
    TEXT_WAVE_1 = 156,
    TEXT_WAVE_2 = 157,
    TEXT_WAVE_3 = 158,
    TEXT_WAVE_4 = 159,
    TRAPEZOID = 8,
    U_TURN_ARROW = 101,
    UNKNOWN = 4095,
    UP_ARROW = 68,
    UP_ARROW_CALLOUT = 79,
    UP_DOWN_ARROW = 70,
    UP_DOWN_ARROW_CALLOUT = 82,
    UP_RIBBON = 54,
    VERTICAL_SCROLL = 97,
    WAVE = 64,
class AxisType(IntEnum):
    CATEGORY = 0,
    SERIES = 2,
    VALUE = 1,
class BackgroundMode(IntEnum):
    AUTOMATIC = 0,
    OPAQUE = 1,
    TRANSPARENT = 2,
class BackgroundType(IntEnum):
    DIAGONAL_CROSSHATCH = 9,
    DIAGONAL_STRIPE = 8,
    GRAY_12 = 17,
    GRAY_25 = 4,
    GRAY_50 = 2,
    GRAY_6 = 18,
    GRAY_75 = 3,
    HORIZONTAL_STRIPE = 5,
    NONE = 0,
    REVERSE_DIAGONAL_STRIPE = 7,
    SOLID = 1,
    THICK_DIAGONAL_CROSSHATCH = 10,
    THIN_DIAGONAL_CROSSHATCH = 16,
    THIN_DIAGONAL_STRIPE = 14,
    THIN_HORIZONTAL_CROSSHATCH = 15,
    THIN_HORIZONTAL_STRIPE = 11,
    THIN_REVERSE_DIAGONAL_STRIPE = 13,
    THIN_VERTICAL_STRIPE = 12,
    VERTICAL_STRIPE = 6,
class Bar3DShapeType(IntEnum):
    BOX = 0,
    CONE_TO_MAX = 5,
    CONE_TO_POINT = 4,
    CYLINDER = 3,
    PYRAMID_TO_MAX = 2,
    PYRAMID_TO_POINT = 1,
class BevelPresetType(IntEnum):
    ANGLE = 1,
    ART_DECO = 2,
    CIRCLE = 3,
    CONVEX = 4,
    COOL_SLANT = 5,
    CROSS = 6,
    DIVOT = 7,
    HARD_EDGE = 8,
    NONE = 0,
    RELAXED_INSET = 9,
    RIBLET = 10,
    SLOPE = 11,
    SOFT_ROUND = 12,
class BevelType(IntEnum):
    ANGLE = 1,
    ART_DECO = 2,
    CIRCLE = 3,
    CONVEX = 4,
    COOL_SLANT = 5,
    CROSS = 6,
    DIVOT = 7,
    HARD_EDGE = 8,
    NONE = 0,
    RELAXED_INSET = 9,
    RIBLET = 10,
    SLOPE = 11,
    SOFT_ROUND = 12,
class BorderType(IntEnum):
    BOTTOM_BORDER = 8,
    DIAGONAL_DOWN = 16,
    DIAGONAL_UP = 32,
    HORIZONTAL = 128,
    LEFT_BORDER = 1,
    RIGHT_BORDER = 2,
    TOP_BORDER = 4,
    VERTICAL = 64,
class BubbleSizeRepresents(IntEnum):
    SIZE_IS_AREA = 0,
    SIZE_IS_WIDTH = 1,
class BuiltinStyleType(IntEnum):
    ACCENT_1 = 29,
    ACCENT_2 = 33,
    ACCENT_3 = 37,
    ACCENT_4 = 41,
    ACCENT_5 = 45,
    ACCENT_6 = 49,
    BAD = 27,
    CALCULATION = 22,
    CHECK_CELL = 23,
    COLUMN_LEVEL = 2,
    COMMA = 3,
    COMMA_1 = 6,
    CURRENCY = 4,
    CURRENCY_1 = 7,
    EXPLANATORY_TEXT = 53,
    FOLLOWED_HYPERLINK = 9,
    FORTY_PERCENT_ACCENT_1 = 31,
    FORTY_PERCENT_ACCENT_2 = 35,
    FORTY_PERCENT_ACCENT_3 = 39,
    FORTY_PERCENT_ACCENT_4 = 43,
    FORTY_PERCENT_ACCENT_5 = 47,
    FORTY_PERCENT_ACCENT_6 = 51,
    GOOD = 26,
    HEADER_1 = 16,
    HEADER_2 = 17,
    HEADER_3 = 18,
    HEADER_4 = 19,
    HYPERLINK = 8,
    INPUT = 20,
    LINKED_CELL = 24,
    NEUTRAL = 28,
    NORMAL = 0,
    NOTE = 10,
    OUTPUT = 21,
    PERCENT = 5,
    ROW_LEVEL = 1,
    SIXTY_PERCENT_ACCENT_1 = 32,
    SIXTY_PERCENT_ACCENT_2 = 36,
    SIXTY_PERCENT_ACCENT_3 = 40,
    SIXTY_PERCENT_ACCENT_4 = 44,
    SIXTY_PERCENT_ACCENT_5 = 48,
    SIXTY_PERCENT_ACCENT_6 = 52,
    TITLE = 15,
    TOTAL = 25,
    TWENTY_PERCENT_ACCENT_1 = 30,
    TWENTY_PERCENT_ACCENT_2 = 34,
    TWENTY_PERCENT_ACCENT_3 = 38,
    TWENTY_PERCENT_ACCENT_4 = 42,
    TWENTY_PERCENT_ACCENT_5 = 46,
    TWENTY_PERCENT_ACCENT_6 = 50,
    WARNING_TEXT = 11,
class BulletType(IntEnum):
    AUTO_NUMBERED = 3,
    CHARACTER = 1,
    NONE = 0,
    PICTURE = 2,
class CalcModeType(IntEnum):
    AUTOMATIC = 0,
    AUTOMATIC_EXCEPT_TABLE = 1,
    MANUAL = 2,
class CalculationPrecisionStrategy(IntEnum):
    DECIMAL = 2,
    NONE = 0,
    ROUND = 1,
class CategoryType(IntEnum):
    AUTOMATIC_SCALE = 0,
    CATEGORY_SCALE = 1,
    TIME_SCALE = 2,
class CellBorderType(IntEnum):
    DASH_DOT = 9,
    DASH_DOT_DOT = 11,
    DASHED = 3,
    DOTTED = 4,
    DOUBLE = 6,
    HAIR = 7,
    MEDIUM = 2,
    MEDIUM_DASH_DOT = 10,
    MEDIUM_DASH_DOT_DOT = 12,
    MEDIUM_DASHED = 8,
    NONE = 0,
    SLANTED_DASH_DOT = 13,
    THICK = 5,
    THIN = 1,
class CellValueFormatStrategy(IntEnum):
    CELL_STYLE = 1,
    DISPLAY_STRING = 3,
    DISPLAY_STYLE = 2,
    NONE = 0,
class CellValueType(IntEnum):
    IS_BOOL = 0,
    IS_DATE_TIME = 1,
    IS_ERROR = 2,
    IS_NULL = 3,
    IS_NUMERIC = 4,
    IS_STRING = 5,
    IS_UNKNOWN = 6,
class ChartLineFormattingType(IntEnum):
    AUTOMATIC = 0,
    GRADIENT = 3,
    NONE = 2,
    SOLID = 1,
class ChartMarkerType(IntEnum):
    AUTOMATIC = 0,
    CIRCLE = 1,
    DASH = 2,
    DIAMOND = 3,
    DOT = 4,
    NONE = 5,
    PICTURE = 11,
    SQUARE = 7,
    SQUARE_PLUS = 6,
    SQUARE_STAR = 8,
    SQUARE_X = 10,
    TRIANGLE = 9,
class ChartSplitType(IntEnum):
    AUTO = 4,
    CUSTOM = 3,
    PERCENT_VALUE = 2,
    POSITION = 0,
    VALUE = 1,
class ChartTextDirectionType(IntEnum):
    HORIZONTAL = 0,
    ROTATE_270 = 3,
    ROTATE_90 = 2,
    STACKED = 4,
    VERTICAL = 1,
class ChartType(IntEnum):
    AREA = 0,
    AREA_100_PERCENT_STACKED = 2,
    AREA_3_D = 3,
    AREA_3_D_100_PERCENT_STACKED = 5,
    AREA_3_D_STACKED = 4,
    AREA_STACKED = 1,
    BAR = 6,
    BAR_100_PERCENT_STACKED = 8,
    BAR_3_D_100_PERCENT_STACKED = 11,
    BAR_3_D_CLUSTERED = 9,
    BAR_3_D_STACKED = 10,
    BAR_STACKED = 7,
    BOX_WHISKER = 73,
    BUBBLE = 12,
    BUBBLE_3_D = 13,
    COLUMN = 14,
    COLUMN_100_PERCENT_STACKED = 16,
    COLUMN_3_D = 17,
    COLUMN_3_D_100_PERCENT_STACKED = 20,
    COLUMN_3_D_CLUSTERED = 18,
    COLUMN_3_D_STACKED = 19,
    COLUMN_STACKED = 15,
    CONE = 21,
    CONE_100_PERCENT_STACKED = 23,
    CONE_STACKED = 22,
    CONICAL_BAR = 24,
    CONICAL_BAR_100_PERCENT_STACKED = 26,
    CONICAL_BAR_STACKED = 25,
    CONICAL_COLUMN_3_D = 27,
    CYLINDER = 28,
    CYLINDER_100_PERCENT_STACKED = 30,
    CYLINDER_STACKED = 29,
    CYLINDRICAL_BAR = 31,
    CYLINDRICAL_BAR_100_PERCENT_STACKED = 33,
    CYLINDRICAL_BAR_STACKED = 32,
    CYLINDRICAL_COLUMN_3_D = 34,
    DOUGHNUT = 35,
    DOUGHNUT_EXPLODED = 36,
    FUNNEL = 74,
    HISTOGRAM = 79,
    LINE = 37,
    LINE_100_PERCENT_STACKED = 39,
    LINE_100_PERCENT_STACKED_WITH_DATA_MARKERS = 42,
    LINE_3_D = 43,
    LINE_STACKED = 38,
    LINE_STACKED_WITH_DATA_MARKERS = 41,
    LINE_WITH_DATA_MARKERS = 40,
    MAP = 80,
    PARETO_LINE = 75,
    PIE = 44,
    PIE_3_D = 45,
    PIE_3_D_EXPLODED = 48,
    PIE_BAR = 49,
    PIE_EXPLODED = 47,
    PIE_PIE = 46,
    PYRAMID = 50,
    PYRAMID_100_PERCENT_STACKED = 52,
    PYRAMID_BAR = 53,
    PYRAMID_BAR_100_PERCENT_STACKED = 55,
    PYRAMID_BAR_STACKED = 54,
    PYRAMID_COLUMN_3_D = 56,
    PYRAMID_STACKED = 51,
    RADAR = 57,
    RADAR_FILLED = 59,
    RADAR_WITH_DATA_MARKERS = 58,
    RADIAL_HISTOGRAM = 81,
    SCATTER = 60,
    SCATTER_CONNECTED_BY_CURVES_WITH_DATA_MARKER = 61,
    SCATTER_CONNECTED_BY_CURVES_WITHOUT_DATA_MARKER = 62,
    SCATTER_CONNECTED_BY_LINES_WITH_DATA_MARKER = 63,
    SCATTER_CONNECTED_BY_LINES_WITHOUT_DATA_MARKER = 64,
    STOCK_HIGH_LOW_CLOSE = 65,
    STOCK_OPEN_HIGH_LOW_CLOSE = 66,
    STOCK_VOLUME_HIGH_LOW_CLOSE = 67,
    STOCK_VOLUME_OPEN_HIGH_LOW_CLOSE = 68,
    SUNBURST = 76,
    SURFACE_3_D = 69,
    SURFACE_CONTOUR = 71,
    SURFACE_CONTOUR_WIREFRAME = 72,
    SURFACE_WIREFRAME_3_D = 70,
    TREEMAP = 77,
    WATERFALL = 78,
class CheckValueType(IntEnum):
    CHECKED = 1,
    MIXED = 2,
    UN_CHECKED = 0,
class ColorDepth(IntEnum):
    DEFAULT = 0,
    FORMAT_1_BPP = 1,
    FORMAT_24_BPP = 24,
    FORMAT_32_BPP = 32,
    FORMAT_4_BPP = 4,
    FORMAT_8_BPP = 8,
class ColorType(IntEnum):
    AUTOMATIC = 0,
    AUTOMATIC_INDEX = 1,
    INDEXED_COLOR = 3,
    RGB = 2,
    THEME = 4,
class CommentTitleType(IntEnum):
    CELL = 0,
    COMMENT = 1,
class ConsolidationFunction(IntEnum):
    AVERAGE = 2,
    COUNT = 1,
    COUNT_NUMS = 6,
    DISTINCT_COUNT = 11,
    MAX = 3,
    MIN = 4,
    PRODUCT = 5,
    STD_DEV = 7,
    STD_DEVP = 8,
    SUM = 0,
    VAR = 9,
    VARP = 10,
class ControlBorderType(IntEnum):
    NONE = 0,
    SINGLE = 1,
class ControlCaptionAlignmentType(IntEnum):
    LEFT = 0,
    RIGHT = 1,
class ControlListStyle(IntEnum):
    OPTION = 1,
    PLAIN = 0,
class ControlMatchEntryType(IntEnum):
    COMPLETE = 1,
    FIRST_LETTER = 0,
    NONE = 2,
class ControlMousePointerType(IntEnum):
    APP_STARTING = 13,
    ARROW = 1,
    CROSS = 2,
    CUSTOM = 99,
    DEFAULT = 0,
    HELP = 14,
    HOUR_GLASS = 11,
    I_BEAM = 3,
    NO_DROP = 12,
    SIZE_ALL = 15,
    SIZE_NESW = 6,
    SIZE_NS = 7,
    SIZE_NWSE = 8,
    SIZE_WE = 9,
    UP_ARROW = 10,
class ControlPictureAlignmentType(IntEnum):
    BOTTOM_LEFT = 3,
    BOTTOM_RIGHT = 4,
    CENTER = 2,
    TOP_LEFT = 0,
    TOP_RIGHT = 1,
class ControlPicturePositionType(IntEnum):
    ABOVE_CENTER = 458753,
    ABOVE_LEFT = 393216,
    ABOVE_RIGHT = 524290,
    BELOW_CENTER = 65543,
    BELOW_LEFT = 6,
    BELOW_RIGHT = 131080,
    CENTER = 262148,
    LEFT_BOTTOM = 524294,
    LEFT_CENTER = 327683,
    LEFT_TOP = 131072,
    RIGHT_BOTTOM = 393224,
    RIGHT_CENTER = 196613,
    RIGHT_TOP = 2,
class ControlPictureSizeMode(IntEnum):
    CLIP = 0,
    STRETCH = 1,
    ZOOM = 3,
class ControlScrollBarType(IntEnum):
    BARS_BOTH = 3,
    BARS_VERTICAL = 2,
    HORIZONTAL = 1,
    NONE = 0,
class ControlScrollOrientation(IntEnum):
    AUTO = 3,
    HORIZONTAL = 1,
    VERTICAL = 0,
class ControlSpecialEffectType(IntEnum):
    BUMP = 6,
    ETCHED = 3,
    FLAT = 0,
    RAISED = 1,
    SUNKEN = 2,
class ControlType(IntEnum):
    CHECK_BOX = 2,
    COMBO_BOX = 1,
    COMMAND_BUTTON = 0,
    IMAGE = 8,
    LABEL = 7,
    LIST_BOX = 3,
    RADIO_BUTTON = 6,
    SCROLL_BAR = 10,
    SPIN_BUTTON = 5,
    TEXT_BOX = 4,
    TOGGLE_BUTTON = 9,
    UNKNOWN = 11,
class CopyFormatType(IntEnum):
    CLEAR = 2,
    SAME_AS_ABOVE = 0,
    SAME_AS_BELOW = 1,
class CountryCode(IntEnum):
    ALGERIA = 213,
    AUSTRALIA = 61,
    AUSTRIA = 43,
    BELGIUM = 32,
    BRAZIL = 55,
    CANADA = 2,
    CHINA = 86,
    CZECH = 420,
    DEFAULT = 0,
    DENMARK = 45,
    EGYPT = 20,
    FINLAND = 358,
    FRANCE = 33,
    GERMANY = 49,
    GREECE = 30,
    HUNGARY = 36,
    ICELAND = 354,
    INDIA = 91,
    IRAN = 981,
    IRAQ = 964,
    ISRAEL = 972,
    ITALY = 39,
    JAPAN = 81,
    JORDAN = 962,
    KUWAIT = 965,
    LATIN_AMERIC = 3,
    LEBANON = 961,
    LIBYA = 218,
    MEXICO = 52,
    MOROCCO = 216,
    NETHERLANDS = 31,
    NEW_ZEALAND = 64,
    NORWAY = 47,
    POLAND = 48,
    PORTUGAL = 351,
    QATAR = 974,
    RUSSIA = 7,
    SAUDI = 966,
    SOUTH_KOREA = 82,
    SPAIN = 34,
    SWEDEN = 46,
    SWITZERLAND = 41,
    SYRIA = 963,
    TAIWAN = 886,
    THAILAND = 66,
    TURKEY = 90,
    UNITED_ARAB_EMIRATES = 971,
    UNITED_KINGDOM = 44,
    USA = 1,
    VIET_NAM = 84,
class CredentialsMethodType(IntEnum):
    INTEGRATED = 0,
    NONE = 1,
    PROMPT = 2,
    STORED = 3,
class CrossType(IntEnum):
    AUTOMATIC = 0,
    CUSTOM = 3,
    MAXIMUM = 1,
    MINIMUM = 2,
class DataBarAxisPosition(IntEnum):
    AUTOMATIC = 0,
    MIDPOINT = 1,
    NONE = 2,
class DataBarBorderType(IntEnum):
    NONE = 0,
    SOLID = 1,
class DataBarFillType(IntEnum):
    GRADIENT = 1,
    SOLID = 0,
class DataBarNegativeColorType(IntEnum):
    COLOR = 0,
    SAME_AS_POSITIVE = 1,
class DataLabelShapeType(IntEnum):
    BENT_LINE_CALLOUT = 11,
    BENT_LINE_WITH_ACCENT_BAR_CALLOUT = 13,
    DOWN_ARROW_CALLOUT = 4,
    ELLIPSE = 2,
    LEFT_ARROW_CALLOUT = 5,
    LINE_CALLOUT = 10,
    LINE_WITH_ACCENT_BAR_CALLOUT = 12,
    RECT = 0,
    RIGHT_ARROW_CALLOUT = 3,
    ROUND_RECT = 1,
    UP_ARROW_CALLOUT = 6,
    WEDGE_ELLIPSE_CALLOUT = 9,
    WEDGE_RECT_CALLOUT = 7,
    WEDGE_ROUND_RECT_CALLOUT = 8,
class DataLabelsSeparatorType(IntEnum):
    AUTO = 0,
    COMMA = 2,
    CUSTOM = 6,
    NEW_LINE = 5,
    PERIOD = 4,
    SEMICOLON = 3,
    SPACE = 1,
class DataLablesSeparatorType(IntEnum):
    AUTO = 0,
    COMMA = 2,
    CUSTOM = 6,
    NEW_LINE = 5,
    PERIOD = 4,
    SEMICOLON = 3,
    SPACE = 1,
class DateTimeGroupingType(IntEnum):
    DAY = 0,
    HOUR = 1,
    MINUTE = 2,
    MONTH = 3,
    SECOND = 4,
    YEAR = 5,
class DefaultEditLanguage(IntEnum):
    AUTO = 0,
    CJK = 2,
    ENGLISH = 1,
class DirectoryType(IntEnum):
    DOWN_DIRECTORY = 2,
    SAME_VOLUME = 1,
    UP_DIRECTORY = 3,
    VOLUME = 0,
class DisplayDrawingObjects(IntEnum):
    DISPLAY_SHAPES = 0,
    HIDE = 2,
    PLACEHOLDERS = 1,
class DisplayUnitType(IntEnum):
    BILLIONS = 8,
    CUST = 11,
    HUNDRED_MILLIONS = 7,
    HUNDRED_THOUSANDS = 4,
    HUNDREDS = 1,
    MILLIONS = 5,
    NONE = 0,
    PERCENTAGE = 10,
    TEN_MILLIONS = 6,
    TEN_THOUSANDS = 3,
    THOUSANDS = 2,
    TRILLIONS = 9,
class DropButtonStyle(IntEnum):
    ARROW = 1,
    ELLIPSIS = 2,
    PLAIN = 0,
    REDUCE = 3,
class DynamicFilterType(IntEnum):
    ABOVE_AVERAGE = 0,
    APRIL = 12,
    AUGUST = 16,
    BELOW_AVERAGE = 1,
    DECEMBER = 9,
    FEBRUARY = 10,
    JANUARY = 6,
    JULY = 15,
    JUNE = 14,
    LAST_MONTH = 2,
    LAST_QUARTER = 3,
    LAST_WEEK = 4,
    LAST_YEAR = 5,
    MARCH = 11,
    MAY = 13,
    NEXT_MONTH = 18,
    NEXT_QUARTER = 19,
    NEXT_WEEK = 20,
    NEXT_YEAR = 21,
    NONE = 22,
    NOVEMBER = 8,
    OCTOBER = 7,
    QUARTER_1 = 23,
    QUARTER_2 = 24,
    QUARTER_3 = 25,
    QUARTER_4 = 26,
    SEPTEMBER = 17,
    THIS_MONTH = 27,
    THIS_QUARTER = 28,
    THIS_WEEK = 29,
    THIS_YEAR = 30,
    TODAY = 31,
    TOMORROW = 32,
    YEAR_TO_DATE = 33,
    YESTERDAY = 34,
class EmfRenderSetting(IntEnum):
    EMF_ONLY = 0,
    EMF_PLUS_PREFER = 1,
class EncryptionType(IntEnum):
    COMPATIBLE = 1,
    ENHANCED_CRYPTOGRAPHIC_PROVIDER_V_1 = 2,
    STRONG_CRYPTOGRAPHIC_PROVIDER = 3,
    XOR = 0,
class ErrorBarDisplayType(IntEnum):
    BOTH = 0,
    MINUS = 1,
    NONE = 2,
    PLUS = 3,
class ErrorBarType(IntEnum):
    CUSTOM = 0,
    FIXED_VALUE = 1,
    PERCENT = 2,
    ST_DEV = 3,
    ST_ERROR = 4,
class ErrorCheckType(IntEnum):
    CALC = 1,
    CALCULATED_COLUMN = 129,
    EMPTY_CELL_REF = 2,
    INCONSIST_FORMULA = 16,
    INCONSIST_RANGE = 8,
    TEXT_DATE = 32,
    TEXT_NUMBER = 4,
    UNPROCTED_FORMULA = 64,
    VALIDATION = 128,
class ExceptionType(IntEnum):
    CHART = 0,
    CONDITIONAL_FORMATTING = 3,
    DATA_TYPE = 1,
    DATA_VALIDATION = 2,
    FILE_CORRUPTED = 23,
    FILE_FORMAT = 4,
    FORMULA = 5,
    INCORRECT_PASSWORD = 8,
    INTERRUPTED = 17,
    INVALID_DATA = 6,
    INVALID_OPERATOR = 7,
    IO = 18,
    LICENSE = 9,
    LIMITATION = 10,
    PAGE_SETUP = 11,
    PERMISSION = 19,
    PIVOT_TABLE = 12,
    SHAPE = 13,
    SHEET_NAME = 15,
    SHEET_TYPE = 16,
    SPARKLINE = 14,
    UNDISCLOSED_INFORMATION = 22,
    UNSUPPORTED_FEATURE = 20,
    UNSUPPORTED_STREAM = 21,
class ExternalLinkType(IntEnum):
    DDE_LINK = 0,
    EXTERNAL = 1,
class FileFormatType(IntEnum):
    BMP = 54,
    CSV = 1,
    DIF = 30,
    DOC = 31,
    DOCM = 38,
    DOCX = 27,
    DOTM = 40,
    DOTX = 39,
    EMF = 258,
    EXCEL_2 = 25,
    EXCEL_2003_XML = 15,
    EXCEL_3 = 24,
    EXCEL_4 = 23,
    EXCEL_95 = 22,
    EXCEL_97_TO_2003 = 5,
    FODS = 59,
    GIF = 322,
    GRAPH_CHART = 58,
    HTML = 12,
    JPG = 261,
    JSON = 513,
    M_HTML = 17,
    MAPI_MESSAGE = 33,
    MARKDOWN = 57,
    MS_EQUATION = 34,
    NUMBERS = 56,
    NUMBERS_09 = 56,
    NUMBERS_35 = 62,
    ODF = 49,
    ODG = 50,
    ODP = 48,
    ODS = 14,
    ODT = 47,
    OLE_10_NATIVE = 35,
    OOXML = 46,
    OTP = 61,
    OTS = 55,
    OTT = 53,
    PDF = 13,
    PNG = 262,
    POTM = 43,
    POTX = 42,
    PPSM = 45,
    PPSX = 44,
    PPT = 32,
    PPTM = 41,
    PPTX = 26,
    SPREADSHEET_ML = 15,
    SQL_SCRIPT = 514,
    SVG = 28,
    SXC = 60,
    TAB_DELIMITED = 11,
    TIFF = 21,
    TSV = 11,
    UNKNOWN = 255,
    VSD = 36,
    VSDX = 37,
    WMF = 259,
    XLAM = 10,
    XLSB = 16,
    XLSM = 7,
    XLSX = 6,
    XLT = 52,
    XLTM = 9,
    XLTX = 8,
    XML = 51,
    XPS = 20,
class FillPattern(IntEnum):
    DARK_DOWNWARD_DIAGONAL = 16,
    DARK_HORIZONTAL = 25,
    DARK_UPWARD_DIAGONAL = 17,
    DARK_VERTICAL = 24,
    DASHED_DOWNWARD_DIAGONAL = 26,
    DASHED_HORIZONTAL = 29,
    DASHED_UPWARD_DIAGONAL = 27,
    DASHED_VERTICAL = 28,
    DIAGONAL_BRICK = 34,
    DIVOT = 38,
    DOTTED_DIAMOND = 40,
    DOTTED_GRID = 39,
    GRAY_10 = 3,
    GRAY_20 = 4,
    GRAY_25 = 13,
    GRAY_30 = 5,
    GRAY_40 = 6,
    GRAY_5 = 2,
    GRAY_50 = 7,
    GRAY_60 = 8,
    GRAY_70 = 9,
    GRAY_75 = 10,
    GRAY_80 = 11,
    GRAY_90 = 12,
    HORIZONTAL_BRICK = 35,
    LARGE_CHECKER_BOARD = 47,
    LARGE_CONFETTI = 31,
    LARGE_GRID = 45,
    LIGHT_DOWNWARD_DIAGONAL = 14,
    LIGHT_HORIZONTAL = 21,
    LIGHT_UPWARD_DIAGONAL = 15,
    LIGHT_VERTICAL = 20,
    NARROW_HORIZONTAL = 23,
    NARROW_VERTICAL = 22,
    NONE = 0,
    OUTLINED_DIAMOND = 48,
    PLAID = 37,
    SHINGLE = 41,
    SMALL_CHECKER_BOARD = 46,
    SMALL_CONFETTI = 30,
    SMALL_GRID = 44,
    SOLID = 1,
    SOLID_DIAMOND = 49,
    SPHERE = 43,
    TRELLIS = 42,
    UNKNOWN = 50,
    WAVE = 33,
    WEAVE = 36,
    WIDE_DOWNWARD_DIAGONAL = 18,
    WIDE_UPWARD_DIAGONAL = 19,
    ZIG_ZAG = 32,
class FillPictureType(IntEnum):
    STACK = 1,
    STACK_AND_SCALE = 2,
    STRETCH = 0,
class FillType(IntEnum):
    AUTOMATIC = 0,
    GRADIENT = 3,
    GROUP = 6,
    NONE = 1,
    PATTERN = 5,
    SOLID = 2,
    TEXTURE = 4,
class FilterOperatorType(IntEnum):
    BEGINS_WITH = 7,
    CONTAINS = 9,
    ENDS_WITH = 8,
    EQUAL = 2,
    GREATER_OR_EQUAL = 5,
    GREATER_THAN = 3,
    LESS_OR_EQUAL = 0,
    LESS_THAN = 1,
    NONE = 6,
    NOT_CONTAINS = 10,
    NOT_EQUAL = 4,
class FilterType(IntEnum):
    COLOR_FILTER = 0,
    CUSTOM_FILTERS = 1,
    DYNAMIC_FILTER = 2,
    ICON_FILTER = 4,
    MULTIPLE_FILTERS = 3,
    NONE = 6,
    TOP_10 = 5,
class FontSchemeType(IntEnum):
    MAJOR = 1,
    MINOR = 2,
    NONE = 0,
class FontSourceType(IntEnum):
    FONT_FILE = 0,
    FONTS_FOLDER = 1,
    MEMORY_FONT = 2,
class FontUnderlineType(IntEnum):
    ACCOUNTING = 3,
    DASH = 5,
    DASH_DOT_DOT_HEAVY = 6,
    DASH_DOT_HEAVY = 7,
    DASH_LONG = 9,
    DASH_LONG_HEAVY = 10,
    DASHED_HEAVY = 8,
    DOT_DASH = 11,
    DOT_DOT_DASH = 12,
    DOTTED = 13,
    DOTTED_HEAVY = 14,
    DOUBLE = 2,
    DOUBLE_ACCOUNTING = 4,
    HEAVY = 15,
    NONE = 0,
    SINGLE = 1,
    WAVE = 16,
    WAVY_DOUBLE = 17,
    WAVY_HEAVY = 18,
    WORDS = 19,
class FormatConditionType(IntEnum):
    ABOVE_AVERAGE = 17,
    BEGINS_WITH = 10,
    CELL_VALUE = 0,
    COLOR_SCALE = 2,
    CONTAINS_BLANKS = 12,
    CONTAINS_ERRORS = 14,
    CONTAINS_TEXT = 8,
    DATA_BAR = 3,
    DUPLICATE_VALUES = 7,
    ENDS_WITH = 11,
    EXPRESSION = 1,
    ICON_SET = 4,
    NOT_CONTAINS_BLANKS = 13,
    NOT_CONTAINS_ERRORS = 15,
    NOT_CONTAINS_TEXT = 9,
    TIME_PERIOD = 16,
    TOP_10 = 5,
    UNIQUE_VALUES = 6,
class FormatConditionValueType(IntEnum):
    AUTOMATIC_MAX = 6,
    AUTOMATIC_MIN = 7,
    FORMULA = 0,
    MAX = 1,
    MIN = 2,
    NUMBER = 3,
    PERCENT = 4,
    PERCENTILE = 5,
class FormatSetType(IntEnum):
    IS_GRADIENT_SET = 1,
    IS_PATTERN_SET = 3,
    IS_TEXTURE_SET = 2,
    NONE = 0,
class FormattingType(IntEnum):
    AUTOMATIC = 0,
    CUSTOM = 2,
    NONE = 1,
class FormulaType(IntEnum):
    ARRAY = 1,
    FORMULA_TYPE_ARRAY = 1,
    FORMULA_TYPE_NONE = -1,
    FORMULA_TYPE_NORMAL = 0,
    FORMULA_TYPE_SHARED = 2,
    FORMULA_TYPE_TABLE = 3,
    NONE = -1,
    NORMAL = 0,
    SHARED = 2,
    TABLE = 3,
class GradientColorType(IntEnum):
    NONE = 0,
    ONE_COLOR = 1,
    PRESET_COLORS = 2,
    TWO_COLORS = 3,
class GradientDirectionType(IntEnum):
    FROM_CENTER = 4,
    FROM_LOWER_LEFT_CORNER = 2,
    FROM_LOWER_RIGHT_CORNER = 3,
    FROM_UPPER_LEFT_CORNER = 0,
    FROM_UPPER_RIGHT_CORNER = 1,
    UNKNOWN = 5,
class GradientFillType(IntEnum):
    LINEAR = 0,
    PATH = 3,
    RADIAL = 1,
    RECTANGLE = 2,
class GradientPresetType(IntEnum):
    BRASS = 0,
    CALM_WATER = 1,
    CHROME = 2,
    CHROME_II = 3,
    DAYBREAK = 4,
    DESERT = 5,
    EARLY_SUNSET = 6,
    FIRE = 7,
    FOG = 8,
    GOLD = 9,
    GOLD_II = 10,
    HORIZON = 11,
    LATE_SUNSET = 12,
    MAHOGANY = 13,
    MOSS = 14,
    NIGHTFALL = 15,
    OCEAN = 16,
    PARCHMENT = 17,
    PEACOCK = 18,
    RAINBOW = 19,
    RAINBOW_II = 20,
    SAPPHIRE = 21,
    SILVER = 22,
    UNKNOWN = 24,
    WHEAT = 23,
class GradientStyleType(IntEnum):
    DIAGONAL_DOWN = 0,
    DIAGONAL_UP = 1,
    FROM_CENTER = 2,
    FROM_CORNER = 3,
    HORIZONTAL = 4,
    UNKNOWN = 6,
    VERTICAL = 5,
class GridlineType(IntEnum):
    DOTTED = 0,
    HAIR = 1,
class HeaderFooterCommandType(IntEnum):
    CURRENT_DATE = 3,
    CURRENT_PAGE = 1,
    CURRENT_TIME = 4,
    FILE_NAME = 6,
    FILE_PATH = 7,
    PAGECOUNT = 2,
    PICTURE = 8,
    SHEET_NAME = 5,
    TEXT = 0,
class HtmlCrossType(IntEnum):
    CROSS = 2,
    CROSS_HIDE_RIGHT = 3,
    DEFAULT = 0,
    FIT_TO_CELL = 4,
    MS_EXPORT = 1,
class HtmlExportDataOptions(IntEnum):
    ALL = 255,
    TABLE = 1,
class HtmlFormatHandlingType(IntEnum):
    ALL = 0,
    NONE = 1,
    RTF = 2,
class HtmlHiddenColDisplayType(IntEnum):
    HIDDEN = 0,
    REMOVE = 1,
class HtmlHiddenRowDisplayType(IntEnum):
    HIDDEN = 0,
    REMOVE = 1,
class HtmlLinkTargetType(IntEnum):
    BLANK = 0,
    PARENT = 1,
    SELF = 2,
    TOP = 3,
class IconSetType(IntEnum):
    ARROWS_3 = 0,
    ARROWS_4 = 8,
    ARROWS_5 = 13,
    ARROWS_GRAY_3 = 1,
    ARROWS_GRAY_4 = 9,
    ARROWS_GRAY_5 = 14,
    BOXES_5 = 18,
    COLOR_SMILIES_3 = 23,
    CUSTOM_SET = 21,
    FLAGS_3 = 2,
    NONE = 20,
    QUARTERS_5 = 15,
    RATING_4 = 10,
    RATING_5 = 16,
    RED_TO_BLACK_4 = 11,
    SIGNS_3 = 3,
    SMILIES_3 = 22,
    STARS_3 = 17,
    SYMBOLS_3 = 4,
    SYMBOLS_32 = 5,
    TRAFFIC_LIGHTS_31 = 6,
    TRAFFIC_LIGHTS_32 = 7,
    TRAFFIC_LIGHTS_4 = 12,
    TRIANGLES_3 = 19,
class ImageType(IntEnum):
    BMP = 7,
    EMF = 2,
    GIF = 66,
    GLTF = 70,
    JPEG = 5,
    OFFICE_COMPATIBLE_EMF = 71,
    PICT = 4,
    PNG = 6,
    SVG = 68,
    SVM = 69,
    TIFF = 67,
    UNKNOWN = 0,
    WEB_P = 72,
    WMF = 3,
class InputMethodEditorMode(IntEnum):
    ALPHA = 8,
    ALPHA_FULL = 7,
    DISABLE = 3,
    HANGUL = 10,
    HANGUL_FULL = 9,
    HANZI = 12,
    HANZI_FULL = 11,
    HIRAGANA = 4,
    KATAKANA = 5,
    KATAKANA_HALF = 6,
    NO_CONTROL = 0,
    OFF = 2,
    ON = 1,
class LabelPositionType(IntEnum):
    ABOVE = 4,
    BELOW = 5,
    BEST_FIT = 8,
    CENTER = 0,
    INSIDE_BASE = 1,
    INSIDE_END = 2,
    LEFT = 6,
    MOVED = 9,
    OUTSIDE_END = 3,
    RIGHT = 7,
class LegendPositionType(IntEnum):
    BOTTOM = 0,
    CORNER = 1,
    LEFT = 4,
    NOT_DOCKED = 7,
    RIGHT = 3,
    TOP = 2,
class LightRigDirectionType(IntEnum):
    BOTTOM = 0,
    BOTTOM_LEFT = 1,
    BOTTOM_RIGHT = 2,
    LEFT = 3,
    RIGHT = 4,
    TOP = 5,
    TOP_LEFT = 6,
    TOP_RIGHT = 7,
class LightRigType(IntEnum):
    BALANCED = 0,
    BRIGHT_ROOM = 1,
    CHILLY = 2,
    CONTRASTING = 3,
    FLAT = 4,
    FLOOD = 5,
    FREEZING = 6,
    GLOW = 7,
    HARSH = 8,
    LEGACY_FLAT_1 = 9,
    LEGACY_FLAT_2 = 10,
    LEGACY_FLAT_3 = 11,
    LEGACY_FLAT_4 = 12,
    LEGACY_HARSH_1 = 13,
    LEGACY_HARSH_2 = 14,
    LEGACY_HARSH_3 = 15,
    LEGACY_HARSH_4 = 16,
    LEGACY_NORMAL_1 = 17,
    LEGACY_NORMAL_2 = 18,
    LEGACY_NORMAL_3 = 19,
    LEGACY_NORMAL_4 = 20,
    MORNING = 21,
    NONE = 27,
    SOFT = 22,
    SUNRISE = 23,
    SUNSET = 24,
    THREE_POINT = 25,
    TWO_POINT = 26,
class LineCapType(IntEnum):
    FLAT = 2,
    NONE = 3,
    ROUND = 1,
    SQUARE = 0,
class LineJoinType(IntEnum):
    BEVEL = 1,
    MITER = 2,
    NONE = 3,
    ROUND = 0,
class LineSpaceSizeType(IntEnum):
    PERCENTAGE = 0,
    POINTS = 1,
class LineType(IntEnum):
    DARK_GRAY = 6,
    DASH = 1,
    DASH_DOT = 3,
    DASH_DOT_DOT = 4,
    DOT = 2,
    LIGHT_GRAY = 8,
    MEDIUM_GRAY = 7,
    SOLID = 0,
class LoadDataFilterOptions(IntEnum):
    ALL = 2147483647,
    BOOK_SETTINGS = 1048576,
    CELL_BLANK = 1,
    CELL_BOOL = 16,
    CELL_DATA = 67108927,
    CELL_ERROR = 8,
    CELL_NUMERIC = 4,
    CELL_STRING = 2,
    CELL_VALUE = 31,
    CHART = 256,
    CONDITIONAL_FORMATTING = 2048,
    DATA_VALIDATION = 4096,
    DEFINED_NAMES = 16777216,
    DOCUMENT_PROPERTIES = 8388608,
    DRAWING = 402653952,
    FORMULA = 32,
    HYPERLINKS = 32768,
    MERGED_AREA = 1024,
    NONE = 0,
    OLE_OBJECT = 268435456,
    PICTURE = 134217728,
    PIVOT_TABLE = 8192,
    REVISION = 536870912,
    SETTINGS = 1114112,
    SHAPE = 402653696,
    SHEET_DATA = 403701759,
    SHEET_SETTINGS = 65536,
    STRUCTURE = 4194304,
    STYLE = 67108864,
    TABLE = 16384,
    VBA = 33554432,
    XML_MAP = 2097152,
class LoadFormat(IntEnum):
    AUTO = 0,
    CSV = 1,
    EXCEL_97_TO_2003 = 5,
    FODS = 59,
    HTML = 12,
    IMAGE = 254,
    JSON = 513,
    M_HTML = 13,
    NUMBERS = 56,
    ODS = 14,
    OTS = 31,
    SPREADSHEET_ML = 15,
    SXC = 60,
    TAB_DELIMITED = 11,
    TSV = 11,
    UNKNOWN = 255,
    XLSB = 16,
    XLSX = 6,
    XML = 51,
class LoadNumbersTableType(IntEnum):
    ONE_TABLE_PER_SHEET = 1,
    OVERRIDE_OTHER_TABLES = 2,
    TILE_TABLES = 4,
class LookAtType(IntEnum):
    CONTAINS = 0,
    END_WITH = 2,
    ENTIRE_CONTENT = 3,
    START_WITH = 1,
class LookInType(IntEnum):
    COMMENTS = 3,
    FORMULAS = 0,
    ONLY_FORMULAS = 4,
    ORIGINAL_VALUES = 5,
    VALUES = 1,
    VALUES_EXCLUDE_FORMULA_CELL = 2,
class MapChartLabelLayout(IntEnum):
    BEST_FIT_ONLY = 0,
    NONE = 2,
    SHOW_ALL = 1,
class MapChartProjectionType(IntEnum):
    ALBERS = 3,
    AUTOMATIC = 0,
    MERCATOR = 1,
    MILLER = 2,
class MapChartRegionType(IntEnum):
    AUTOMATIC = 0,
    COUNTRY_REGION_LIST = 2,
    DATA_ONLY = 1,
    WORLD = 3,
class MemorySetting(IntEnum):
    MEMORY_PREFERENCE = 1,
    NORMAL = 0,
class MetadataType(IntEnum):
    DECRYPTION = 2,
    DOCUMENT_PROPERTIES = 4,
    ENCRYPTION = 1,
class MirrorType(IntEnum):
    BOTH = 3,
    HORIZONAL = 1,
    NONE = 0,
    VERTICAL = 2,
class MsoArrowheadLength(IntEnum):
    LONG = 2,
    MEDIUM = 1,
    SHORT = 0,
class MsoArrowheadStyle(IntEnum):
    ARROW = 1,
    ARROW_DIAMOND = 3,
    ARROW_OPEN = 5,
    ARROW_OVAL = 4,
    ARROW_STEALTH = 2,
    NONE = 0,
class MsoArrowheadWidth(IntEnum):
    MEDIUM = 1,
    NARROW = 0,
    WIDE = 2,
class MsoDrawingType(IntEnum):
    ARC = 4,
    BUTTON = 7,
    CELLS_DRAWING = 30,
    CHART = 5,
    CHECK_BOX = 11,
    COMBO_BOX = 20,
    COMMENT = 25,
    CUSTOM_XML = 34,
    DIALOG_BOX = 15,
    GROUP = 0,
    GROUP_BOX = 19,
    LABEL = 14,
    LINE = 1,
    LIST_BOX = 18,
    MODEL_3_D = 36,
    OLE_OBJECT = 24,
    OVAL = 3,
    PICTURE = 8,
    POLYGON = 9,
    RADIO_BUTTON = 12,
    RECTANGLE = 2,
    SCROLL_BAR = 17,
    SLICER = 31,
    SMART_ART = 33,
    SPINNER = 16,
    TEXT_BOX = 6,
    TIMELINE = 35,
    UNKNOWN = 29,
    WEB_EXTENSION = 32,
class MsoLineDashStyle(IntEnum):
    CUSTOM = 8,
    DASH = 0,
    DASH_DOT = 1,
    DASH_DOT_DOT = 2,
    DASH_LONG_DASH = 3,
    DASH_LONG_DASH_DOT = 4,
    ROUND_DOT = 5,
    SOLID = 6,
    SQUARE_DOT = 7,
class MsoLineStyle(IntEnum):
    SINGLE = 0,
    THICK_BETWEEN_THIN = 1,
    THICK_THIN = 3,
    THIN_THICK = 2,
    THIN_THIN = 4,
class MsoPresetTextEffect(IntEnum):
    TEXT_EFFECT_1 = 0,
    TEXT_EFFECT_10 = 9,
    TEXT_EFFECT_11 = 10,
    TEXT_EFFECT_12 = 11,
    TEXT_EFFECT_13 = 12,
    TEXT_EFFECT_14 = 13,
    TEXT_EFFECT_15 = 14,
    TEXT_EFFECT_16 = 15,
    TEXT_EFFECT_17 = 16,
    TEXT_EFFECT_18 = 17,
    TEXT_EFFECT_19 = 18,
    TEXT_EFFECT_2 = 1,
    TEXT_EFFECT_20 = 19,
    TEXT_EFFECT_21 = 20,
    TEXT_EFFECT_22 = 21,
    TEXT_EFFECT_23 = 22,
    TEXT_EFFECT_24 = 23,
    TEXT_EFFECT_25 = 24,
    TEXT_EFFECT_26 = 25,
    TEXT_EFFECT_27 = 26,
    TEXT_EFFECT_28 = 27,
    TEXT_EFFECT_29 = 28,
    TEXT_EFFECT_3 = 2,
    TEXT_EFFECT_30 = 29,
    TEXT_EFFECT_4 = 3,
    TEXT_EFFECT_5 = 4,
    TEXT_EFFECT_6 = 5,
    TEXT_EFFECT_7 = 6,
    TEXT_EFFECT_8 = 7,
    TEXT_EFFECT_9 = 8,
class MsoPresetTextEffectShape(IntEnum):
    ARCH_DOWN_CURVE = 145,
    ARCH_DOWN_POUR = 149,
    ARCH_UP_CURVE = 144,
    ARCH_UP_POUR = 148,
    BUTTON_CURVE = 147,
    BUTTON_POUR = 151,
    CAN_DOWN = 175,
    CAN_UP = 174,
    CASCADE_DOWN = 155,
    CASCADE_UP = 154,
    CHEVRON_DOWN = 141,
    CHEVRON_UP = 140,
    CIRCLE_CURVE = 146,
    CIRCLE_POUR = 150,
    CURVE_DOWN = 153,
    CURVE_UP = 152,
    DEFLATE = 161,
    DEFLATE_BOTTOM = 163,
    DEFLATE_INFLATE = 166,
    DEFLATE_INFLATE_DEFLATE = 167,
    DEFLATE_TOP = 165,
    DOUBLE_WAVE_1 = 158,
    DOUBLE_WAVE_2 = 159,
    FADE_DOWN = 171,
    FADE_LEFT = 169,
    FADE_RIGHT = 168,
    FADE_UP = 170,
    INFLATE = 160,
    INFLATE_BOTTOM = 162,
    INFLATE_TOP = 164,
    MIXED = 255,
    PLAIN_TEXT = 136,
    RING_INSIDE = 142,
    RING_OUTSIDE = 143,
    SLANT_DOWN = 173,
    SLANT_UP = 172,
    STOP = 137,
    TRIANGLE_DOWN = 139,
    TRIANGLE_UP = 138,
    WAVE_1 = 156,
    WAVE_2 = 157,
class NameScopeType(IntEnum):
    ALL = 0,
    WORKBOOK = 1,
    WORKSHEET = 2,
class NumberCategoryType(IntEnum):
    DATE = 3,
    FRACTION = 5,
    GENERAL = 0,
    NUMBER = 2,
    SCIENTIFIC = 6,
    TEXT = 1,
    TIME = 4,
class OdsCellFieldType(IntEnum):
    DATE = 0,
    SHEET_NAME = 1,
    TITLE = 2,
class OdsGeneratorType(IntEnum):
    LIBRE_OFFICE = 0,
    OPEN_OFFICE = 1,
class OdsPageBackgroundGraphicPositionType(IntEnum):
    BOTTOM_CENTER = 7,
    BOTTOM_LEFT = 6,
    BOTTOM_RIGHT = 8,
    CENTER_CENTER = 4,
    CENTER_LEFT = 3,
    CENTER_RIGHT = 5,
    TOP_CENTER = 1,
    TOP_LEFT = 0,
    TOP_RIGHT = 2,
class OdsPageBackgroundGraphicType(IntEnum):
    AREA = 1,
    POSITION = 0,
    TILE = 2,
class OdsPageBackgroundType(IntEnum):
    COLOR = 1,
    GRAPHIC = 2,
    NONE = 0,
class OLEDBCommandType(IntEnum):
    CUBE_NAME = 1,
    DEFAULT_INFORMATION = 4,
    NONE = 0,
    SQL_STATEMENT = 2,
    TABLE_NAME = 3,
    WEB_BASED_LIST = 5,
class OoxmlCompliance(IntEnum):
    ECMA_376_2006 = 0,
    ISO_29500_2008_STRICT = 1,
class OoxmlCompressionType(IntEnum):
    LEVEL_1 = 1,
    LEVEL_2 = 2,
    LEVEL_3 = 3,
    LEVEL_4 = 4,
    LEVEL_5 = 5,
    LEVEL_6 = 6,
    LEVEL_7 = 7,
    LEVEL_8 = 8,
    LEVEL_9 = 9,
class OperatorType(IntEnum):
    BETWEEN = 0,
    EQUAL = 1,
    GREATER_OR_EQUAL = 3,
    GREATER_THAN = 2,
    LESS_OR_EQUAL = 5,
    LESS_THAN = 4,
    NONE = 6,
    NOT_BETWEEN = 7,
    NOT_EQUAL = 8,
class PageLayoutAlignmentType(IntEnum):
    BOTTOM = 0,
    CENTER = 1,
    LEFT = 2,
    RIGHT = 3,
    TOP = 4,
class PageOrientationType(IntEnum):
    LANDSCAPE = 0,
    PORTRAIT = 1,
class PaneStateType(IntEnum):
    FROZEN = 0,
    FROZEN_SPLIT = 1,
    NORMAL = 3,
    SPLIT = 2,
class PaperSizeType(IntEnum):
    CUSTOM = 0,
    PAPER_10_X_11 = 45,
    PAPER_10_X_14 = 16,
    PAPER_11_X_17 = 17,
    PAPER_12_X_11 = 90,
    PAPER_15_X_11 = 46,
    PAPER_9_X_11 = 44,
    PAPER_A_2 = 66,
    PAPER_A_3 = 8,
    PAPER_A_3_EXTRA = 63,
    PAPER_A_3_EXTRA_TRANSVERSE = 68,
    PAPER_A_3_ROTATED = 76,
    PAPER_A_3_TRANSVERSE = 67,
    PAPER_A_4 = 9,
    PAPER_A_4_EXTRA = 53,
    PAPER_A_4_PLUS = 60,
    PAPER_A_4_ROTATED = 77,
    PAPER_A_4_SMALL = 10,
    PAPER_A_4_TRANSVERSE = 55,
    PAPER_A_5 = 11,
    PAPER_A_5_EXTRA = 64,
    PAPER_A_5_ROTATED = 78,
    PAPER_A_5_TRANSVERSE = 61,
    PAPER_A_6 = 70,
    PAPER_A_6_ROTATED = 83,
    PAPER_B_3 = 300,
    PAPER_B_4 = 12,
    PAPER_B_5 = 13,
    PAPER_BUSINESS_CARD = 301,
    PAPER_C_SHEET = 24,
    PAPER_D_SHEET = 25,
    PAPER_E_SHEET = 26,
    PAPER_ENVELOPE_10 = 20,
    PAPER_ENVELOPE_11 = 21,
    PAPER_ENVELOPE_12 = 22,
    PAPER_ENVELOPE_14 = 23,
    PAPER_ENVELOPE_9 = 19,
    PAPER_ENVELOPE_B_4 = 33,
    PAPER_ENVELOPE_B_5 = 34,
    PAPER_ENVELOPE_B_6 = 35,
    PAPER_ENVELOPE_C_3 = 29,
    PAPER_ENVELOPE_C_4 = 30,
    PAPER_ENVELOPE_C_5 = 28,
    PAPER_ENVELOPE_C_6 = 31,
    PAPER_ENVELOPE_C_65 = 32,
    PAPER_ENVELOPE_DL = 27,
    PAPER_ENVELOPE_INVITE = 47,
    PAPER_ENVELOPE_ITALY = 36,
    PAPER_ENVELOPE_MONARCH = 37,
    PAPER_ENVELOPE_PERSONAL = 38,
    PAPER_EXECUTIVE = 7,
    PAPER_FANFOLD_LEGAL_GERMAN = 41,
    PAPER_FANFOLD_STD_GERMAN = 40,
    PAPER_FANFOLD_US = 39,
    PAPER_FOLIO = 14,
    PAPER_ISOB_4 = 42,
    PAPER_ISOB_5_EXTRA = 65,
    PAPER_JAPANESE_DOUBLE_POSTCARD = 69,
    PAPER_JAPANESE_DOUBLE_POSTCARD_ROTATED = 82,
    PAPER_JAPANESE_ENVELOPE_CHOU_3 = 73,
    PAPER_JAPANESE_ENVELOPE_CHOU_3_ROTATED = 86,
    PAPER_JAPANESE_ENVELOPE_CHOU_4 = 74,
    PAPER_JAPANESE_ENVELOPE_CHOU_4_ROTATED = 87,
    PAPER_JAPANESE_ENVELOPE_KAKU_2 = 71,
    PAPER_JAPANESE_ENVELOPE_KAKU_2_ROTATED = 84,
    PAPER_JAPANESE_ENVELOPE_KAKU_3 = 72,
    PAPER_JAPANESE_ENVELOPE_KAKU_3_ROTATED = 85,
    PAPER_JAPANESE_ENVELOPE_YOU_4 = 91,
    PAPER_JAPANESE_ENVELOPE_YOU_4_ROTATED = 92,
    PAPER_JAPANESE_POSTCARD = 43,
    PAPER_JAPANESE_POSTCARD_ROTATED = 81,
    PAPER_JISB_4_ROTATED = 79,
    PAPER_JISB_5_ROTATED = 80,
    PAPER_JISB_5_TRANSVERSE = 62,
    PAPER_JISB_6 = 88,
    PAPER_JISB_6_ROTATED = 89,
    PAPER_LEDGER = 4,
    PAPER_LEGAL = 5,
    PAPER_LEGAL_EXTRA = 51,
    PAPER_LETTER = 1,
    PAPER_LETTER_EXTRA = 50,
    PAPER_LETTER_EXTRA_TRANSVERSE = 56,
    PAPER_LETTER_PLUS = 59,
    PAPER_LETTER_ROTATED = 75,
    PAPER_LETTER_SMALL = 2,
    PAPER_LETTER_TRANSVERSE = 54,
    PAPER_NOTE = 18,
    PAPER_PRC_16_K = 93,
    PAPER_PRC_16_K_ROTATED = 106,
    PAPER_PRC_32_K = 94,
    PAPER_PRC_32_K_ROTATED = 107,
    PAPER_PRC_BIG_32_K = 95,
    PAPER_PRC_BIG_32_K_ROTATED = 108,
    PAPER_PRC_ENVELOPE_1 = 96,
    PAPER_PRC_ENVELOPE_10 = 105,
    PAPER_PRC_ENVELOPE_10_ROTATED = 118,
    PAPER_PRC_ENVELOPE_1_ROTATED = 109,
    PAPER_PRC_ENVELOPE_2 = 97,
    PAPER_PRC_ENVELOPE_2_ROTATED = 110,
    PAPER_PRC_ENVELOPE_3 = 98,
    PAPER_PRC_ENVELOPE_3_ROTATED = 111,
    PAPER_PRC_ENVELOPE_4 = 99,
    PAPER_PRC_ENVELOPE_4_ROTATED = 112,
    PAPER_PRC_ENVELOPE_5 = 100,
    PAPER_PRC_ENVELOPE_5_ROTATED = 113,
    PAPER_PRC_ENVELOPE_6 = 101,
    PAPER_PRC_ENVELOPE_6_ROTATED = 114,
    PAPER_PRC_ENVELOPE_7 = 102,
    PAPER_PRC_ENVELOPE_7_ROTATED = 115,
    PAPER_PRC_ENVELOPE_8 = 103,
    PAPER_PRC_ENVELOPE_8_ROTATED = 116,
    PAPER_PRC_ENVELOPE_9 = 104,
    PAPER_PRC_ENVELOPE_9_ROTATED = 117,
    PAPER_QUARTO = 15,
    PAPER_STATEMENT = 6,
    PAPER_SUPER_A = 57,
    PAPER_SUPER_B = 58,
    PAPER_TABLOID = 3,
    PAPER_TABLOID_EXTRA = 52,
    PAPER_THERMAL = 302,
class ParameterType(IntEnum):
    ARRAY = 2,
    REFERENCE = 0,
    VALUE = 1,
class PasteOperationType(IntEnum):
    ADD = 1,
    DIVIDE = 4,
    MULTIPLY = 3,
    NONE = 0,
    SUBTRACT = 2,
class PasteType(IntEnum):
    ALL = 0,
    ALL_EXCEPT_BORDERS = 2,
    COLUMN_WIDTHS = 4,
    COMMENTS = 6,
    DEFAULT = 1,
    DEFAULT_EXCEPT_BORDERS = 3,
    FORMATS = 7,
    FORMULAS = 8,
    FORMULAS_AND_NUMBER_FORMATS = 9,
    ROW_HEIGHTS = 5,
    VALIDATION = 10,
    VALUES = 11,
    VALUES_AND_FORMATS = 12,
    VALUES_AND_NUMBER_FORMATS = 13,
class PdfCompliance(IntEnum):
    NONE = 0,
    PDF_A_1_A = 2,
    PDF_A_1_B = 1,
class PdfCompressionCore(IntEnum):
    FLATE = 3,
    LZW = 2,
    NONE = 0,
    RLE = 1,
class PdfCustomPropertiesExport(IntEnum):
    NONE = 0,
    STANDARD = 1,
class PdfFontEncoding(IntEnum):
    ANSI_PREFER = 1,
    IDENTITY = 0,
class PdfOptimizationType(IntEnum):
    MINIMUM_SIZE = 1,
    STANDARD = 0,
class PivotConditionFormatRuleType(IntEnum):
    ALL = 1,
    COLUMN = 3,
    NONE = 0,
    ROW = 2,
class PivotConditionFormatScopeType(IntEnum):
    DATA = 0,
    FIELD = 1,
    SELECTION = 2,
class PivotFieldDataDisplayFormat(IntEnum):
    DIFFERENCE_FROM = 1,
    INDEX = 8,
    NORMAL = 0,
    PERCENTAGE_DIFFERENCE_FROM = 3,
    PERCENTAGE_OF = 2,
    PERCENTAGE_OF_COLUMN = 6,
    PERCENTAGE_OF_PARENT_COLUMN_TOTAL = 10,
    PERCENTAGE_OF_PARENT_ROW_TOTAL = 9,
    PERCENTAGE_OF_PARENT_TOTAL = 11,
    PERCENTAGE_OF_ROW = 5,
    PERCENTAGE_OF_RUNNING_TOTAL_IN = 12,
    PERCENTAGE_OF_TOTAL = 7,
    RANK_LARGEST_TO_SMALLEST = 14,
    RANK_SMALLEST_TO_LARGEST = 13,
    RUNNING_TOTAL_IN = 4,
class PivotFieldSubtotalType(IntEnum):
    AUTOMATIC = 1,
    AVERAGE = 8,
    COUNT = 4,
    COUNT_NUMS = 128,
    MAX = 16,
    MIN = 32,
    NONE = 0,
    PRODUCT = 64,
    STDEV = 256,
    STDEVP = 512,
    SUM = 2,
    VAR = 1024,
    VARP = 2048,
class PivotFieldType(IntEnum):
    COLUMN = 2,
    DATA = 8,
    PAGE = 4,
    ROW = 1,
    UNDEFINED = 0,
class PivotFilterType(IntEnum):
    CAPTION_BEGINS_WITH = 0,
    CAPTION_BETWEEN = 1,
    CAPTION_CONTAINS = 2,
    CAPTION_ENDS_WITH = 3,
    CAPTION_EQUAL = 4,
    CAPTION_GREATER_THAN = 5,
    CAPTION_GREATER_THAN_OR_EQUAL = 6,
    CAPTION_LESS_THAN = 7,
    CAPTION_LESS_THAN_OR_EQUAL = 8,
    CAPTION_NOT_BEGINS_WITH = 9,
    CAPTION_NOT_BETWEEN = 10,
    CAPTION_NOT_CONTAINS = 11,
    CAPTION_NOT_ENDS_WITH = 12,
    CAPTION_NOT_EQUAL = 13,
    COUNT = 14,
    DATE_BETWEEN = 15,
    DATE_EQUAL = 16,
    DATE_NEWER_THAN = 17,
    DATE_NEWER_THAN_OR_EQUAL = 18,
    DATE_NOT_BETWEEN = 19,
    DATE_NOT_EQUAL = 20,
    DATE_OLDER_THAN = 21,
    DATE_OLDER_THAN_OR_EQUAL = 22,
    LAST_MONTH = 23,
    LAST_QUARTER = 24,
    LAST_WEEK = 25,
    LAST_YEAR = 26,
    M_1 = 27,
    M_10 = 36,
    M_11 = 37,
    M_12 = 38,
    M_2 = 28,
    M_3 = 29,
    M_4 = 30,
    M_5 = 31,
    M_6 = 32,
    M_7 = 33,
    M_8 = 34,
    M_9 = 35,
    NEXT_MONTH = 39,
    NEXT_QUARTER = 40,
    NEXT_WEEK = 41,
    NEXT_YEAR = 42,
    PERCENT = 43,
    Q_1 = 44,
    Q_2 = 45,
    Q_3 = 46,
    Q_4 = 47,
    SUM = 48,
    THIS_MONTH = 49,
    THIS_QUARTER = 50,
    THIS_WEEK = 51,
    THIS_YEAR = 52,
    TODAY = 53,
    TOMORROW = 54,
    UNKNOWN = 55,
    VALUE_BETWEEN = 56,
    VALUE_EQUAL = 57,
    VALUE_GREATER_THAN = 58,
    VALUE_GREATER_THAN_OR_EQUAL = 59,
    VALUE_LESS_THAN = 60,
    VALUE_LESS_THAN_OR_EQUAL = 61,
    VALUE_NOT_BETWEEN = 62,
    VALUE_NOT_EQUAL = 63,
    YEAR_TO_DATE = 64,
    YESTERDAY = 65,
class PivotGroupByType(IntEnum):
    DAYS = 4,
    HOURS = 3,
    MINUTES = 2,
    MONTHS = 5,
    QUARTERS = 6,
    RANGE_OF_VALUES = 0,
    SECONDS = 1,
    YEARS = 7,
class PivotItemPosition(IntEnum):
    CUSTOM = 2,
    NEXT = 1,
    PREVIOUS = 0,
class PivotMissingItemLimitType(IntEnum):
    AUTOMATIC = 0,
    MAX = 1,
    NONE = 2,
class PivotTableAutoFormatType(IntEnum):
    CLASSIC = 1,
    NONE = 0,
    REPORT_1 = 2,
    REPORT_10 = 11,
    REPORT_2 = 3,
    REPORT_3 = 4,
    REPORT_4 = 5,
    REPORT_5 = 6,
    REPORT_6 = 7,
    REPORT_7 = 8,
    REPORT_8 = 9,
    REPORT_9 = 10,
    TABLE_1 = 12,
    TABLE_10 = 21,
    TABLE_2 = 13,
    TABLE_3 = 14,
    TABLE_4 = 15,
    TABLE_5 = 16,
    TABLE_6 = 17,
    TABLE_7 = 18,
    TABLE_8 = 19,
    TABLE_9 = 20,
class PivotTableStyleType(IntEnum):
    CUSTOM = 85,
    NONE = 0,
    PIVOT_TABLE_STYLE_DARK_1 = 57,
    PIVOT_TABLE_STYLE_DARK_10 = 66,
    PIVOT_TABLE_STYLE_DARK_11 = 67,
    PIVOT_TABLE_STYLE_DARK_12 = 68,
    PIVOT_TABLE_STYLE_DARK_13 = 69,
    PIVOT_TABLE_STYLE_DARK_14 = 70,
    PIVOT_TABLE_STYLE_DARK_15 = 71,
    PIVOT_TABLE_STYLE_DARK_16 = 72,
    PIVOT_TABLE_STYLE_DARK_17 = 73,
    PIVOT_TABLE_STYLE_DARK_18 = 74,
    PIVOT_TABLE_STYLE_DARK_19 = 75,
    PIVOT_TABLE_STYLE_DARK_2 = 58,
    PIVOT_TABLE_STYLE_DARK_20 = 76,
    PIVOT_TABLE_STYLE_DARK_21 = 77,
    PIVOT_TABLE_STYLE_DARK_22 = 78,
    PIVOT_TABLE_STYLE_DARK_23 = 79,
    PIVOT_TABLE_STYLE_DARK_24 = 80,
    PIVOT_TABLE_STYLE_DARK_25 = 81,
    PIVOT_TABLE_STYLE_DARK_26 = 82,
    PIVOT_TABLE_STYLE_DARK_27 = 83,
    PIVOT_TABLE_STYLE_DARK_28 = 84,
    PIVOT_TABLE_STYLE_DARK_3 = 59,
    PIVOT_TABLE_STYLE_DARK_4 = 60,
    PIVOT_TABLE_STYLE_DARK_5 = 61,
    PIVOT_TABLE_STYLE_DARK_6 = 62,
    PIVOT_TABLE_STYLE_DARK_7 = 63,
    PIVOT_TABLE_STYLE_DARK_8 = 64,
    PIVOT_TABLE_STYLE_DARK_9 = 65,
    PIVOT_TABLE_STYLE_LIGHT_1 = 1,
    PIVOT_TABLE_STYLE_LIGHT_10 = 10,
    PIVOT_TABLE_STYLE_LIGHT_11 = 11,
    PIVOT_TABLE_STYLE_LIGHT_12 = 12,
    PIVOT_TABLE_STYLE_LIGHT_13 = 13,
    PIVOT_TABLE_STYLE_LIGHT_14 = 14,
    PIVOT_TABLE_STYLE_LIGHT_15 = 15,
    PIVOT_TABLE_STYLE_LIGHT_16 = 16,
    PIVOT_TABLE_STYLE_LIGHT_17 = 17,
    PIVOT_TABLE_STYLE_LIGHT_18 = 18,
    PIVOT_TABLE_STYLE_LIGHT_19 = 19,
    PIVOT_TABLE_STYLE_LIGHT_2 = 2,
    PIVOT_TABLE_STYLE_LIGHT_20 = 20,
    PIVOT_TABLE_STYLE_LIGHT_21 = 21,
    PIVOT_TABLE_STYLE_LIGHT_22 = 22,
    PIVOT_TABLE_STYLE_LIGHT_23 = 23,
    PIVOT_TABLE_STYLE_LIGHT_24 = 24,
    PIVOT_TABLE_STYLE_LIGHT_25 = 25,
    PIVOT_TABLE_STYLE_LIGHT_26 = 26,
    PIVOT_TABLE_STYLE_LIGHT_27 = 27,
    PIVOT_TABLE_STYLE_LIGHT_28 = 28,
    PIVOT_TABLE_STYLE_LIGHT_3 = 3,
    PIVOT_TABLE_STYLE_LIGHT_4 = 4,
    PIVOT_TABLE_STYLE_LIGHT_5 = 5,
    PIVOT_TABLE_STYLE_LIGHT_6 = 6,
    PIVOT_TABLE_STYLE_LIGHT_7 = 7,
    PIVOT_TABLE_STYLE_LIGHT_8 = 8,
    PIVOT_TABLE_STYLE_LIGHT_9 = 9,
    PIVOT_TABLE_STYLE_MEDIUM_1 = 29,
    PIVOT_TABLE_STYLE_MEDIUM_10 = 38,
    PIVOT_TABLE_STYLE_MEDIUM_11 = 39,
    PIVOT_TABLE_STYLE_MEDIUM_12 = 40,
    PIVOT_TABLE_STYLE_MEDIUM_13 = 41,
    PIVOT_TABLE_STYLE_MEDIUM_14 = 42,
    PIVOT_TABLE_STYLE_MEDIUM_15 = 43,
    PIVOT_TABLE_STYLE_MEDIUM_16 = 44,
    PIVOT_TABLE_STYLE_MEDIUM_17 = 45,
    PIVOT_TABLE_STYLE_MEDIUM_18 = 46,
    PIVOT_TABLE_STYLE_MEDIUM_19 = 47,
    PIVOT_TABLE_STYLE_MEDIUM_2 = 30,
    PIVOT_TABLE_STYLE_MEDIUM_20 = 48,
    PIVOT_TABLE_STYLE_MEDIUM_21 = 49,
    PIVOT_TABLE_STYLE_MEDIUM_22 = 50,
    PIVOT_TABLE_STYLE_MEDIUM_23 = 51,
    PIVOT_TABLE_STYLE_MEDIUM_24 = 52,
    PIVOT_TABLE_STYLE_MEDIUM_25 = 53,
    PIVOT_TABLE_STYLE_MEDIUM_26 = 54,
    PIVOT_TABLE_STYLE_MEDIUM_27 = 55,
    PIVOT_TABLE_STYLE_MEDIUM_28 = 56,
    PIVOT_TABLE_STYLE_MEDIUM_3 = 31,
    PIVOT_TABLE_STYLE_MEDIUM_4 = 32,
    PIVOT_TABLE_STYLE_MEDIUM_5 = 33,
    PIVOT_TABLE_STYLE_MEDIUM_6 = 34,
    PIVOT_TABLE_STYLE_MEDIUM_7 = 35,
    PIVOT_TABLE_STYLE_MEDIUM_8 = 36,
    PIVOT_TABLE_STYLE_MEDIUM_9 = 37,
class PlacementType(IntEnum):
    FREE_FLOATING = 0,
    MOVE = 1,
    MOVE_AND_SIZE = 2,
class PlotDataByType(IntEnum):
    COLUMN = 1,
    ROW = 0,
class PlotEmptyCellsType(IntEnum):
    INTERPOLATED = 2,
    NOT_PLOTTED = 0,
    ZERO = 1,
class PresetCameraType(IntEnum):
    ISOMETRIC_BOTTOM_DOWN = 0,
    ISOMETRIC_BOTTOM_UP = 1,
    ISOMETRIC_LEFT_DOWN = 2,
    ISOMETRIC_LEFT_UP = 3,
    ISOMETRIC_OFF_AXIS_1_LEFT = 4,
    ISOMETRIC_OFF_AXIS_1_RIGHT = 5,
    ISOMETRIC_OFF_AXIS_1_TOP = 6,
    ISOMETRIC_OFF_AXIS_2_LEFT = 7,
    ISOMETRIC_OFF_AXIS_2_RIGHT = 8,
    ISOMETRIC_OFF_AXIS_2_TOP = 9,
    ISOMETRIC_OFF_AXIS_3_BOTTOM = 10,
    ISOMETRIC_OFF_AXIS_3_LEFT = 11,
    ISOMETRIC_OFF_AXIS_3_RIGHT = 12,
    ISOMETRIC_OFF_AXIS_4_BOTTOM = 13,
    ISOMETRIC_OFF_AXIS_4_LEFT = 14,
    ISOMETRIC_OFF_AXIS_4_RIGHT = 15,
    ISOMETRIC_RIGHT_DOWN = 16,
    ISOMETRIC_RIGHT_UP = 17,
    ISOMETRIC_TOP_DOWN = 18,
    ISOMETRIC_TOP_UP = 19,
    LEGACY_OBLIQUE_BOTTOM = 20,
    LEGACY_OBLIQUE_BOTTOM_LEFT = 21,
    LEGACY_OBLIQUE_BOTTOM_RIGHT = 22,
    LEGACY_OBLIQUE_FRONT = 23,
    LEGACY_OBLIQUE_LEFT = 24,
    LEGACY_OBLIQUE_RIGHT = 25,
    LEGACY_OBLIQUE_TOP = 26,
    LEGACY_OBLIQUE_TOP_LEFT = 27,
    LEGACY_OBLIQUE_TOP_RIGHT = 28,
    LEGACY_PERSPECTIVE_BOTTOM = 29,
    LEGACY_PERSPECTIVE_BOTTOM_LEFT = 30,
    LEGACY_PERSPECTIVE_BOTTOM_RIGHT = 31,
    LEGACY_PERSPECTIVE_FRONT = 32,
    LEGACY_PERSPECTIVE_LEFT = 33,
    LEGACY_PERSPECTIVE_RIGHT = 34,
    LEGACY_PERSPECTIVE_TOP = 35,
    LEGACY_PERSPECTIVE_TOP_LEFT = 36,
    LEGACY_PERSPECTIVE_TOP_RIGHT = 37,
    OBLIQUE_BOTTOM = 38,
    OBLIQUE_BOTTOM_LEFT = 39,
    OBLIQUE_BOTTOM_RIGHT = 40,
    OBLIQUE_LEFT = 41,
    OBLIQUE_RIGHT = 42,
    OBLIQUE_TOP = 43,
    OBLIQUE_TOP_LEFT = 44,
    OBLIQUE_TOP_RIGHT = 45,
    ORTHOGRAPHIC_FRONT = 46,
    PERSPECTIVE_ABOVE = 47,
    PERSPECTIVE_ABOVE_LEFT_FACING = 48,
    PERSPECTIVE_ABOVE_RIGHT_FACING = 49,
    PERSPECTIVE_BELOW = 50,
    PERSPECTIVE_CONTRASTING_LEFT_FACING = 51,
    PERSPECTIVE_CONTRASTING_RIGHT_FACING = 52,
    PERSPECTIVE_FRONT = 53,
    PERSPECTIVE_HEROIC_EXTREME_LEFT_FACING = 54,
    PERSPECTIVE_HEROIC_EXTREME_RIGHT_FACING = 55,
    PERSPECTIVE_HEROIC_LEFT_FACING = 56,
    PERSPECTIVE_HEROIC_RIGHT_FACING = 57,
    PERSPECTIVE_LEFT = 58,
    PERSPECTIVE_RELAXED = 59,
    PERSPECTIVE_RELAXED_MODERATELY = 60,
    PERSPECTIVE_RIGHT = 61,
class PresetMaterialType(IntEnum):
    CLEAR = 0,
    DARK_EDGE = 1,
    FLAT = 2,
    LEGACY_MATTE = 3,
    LEGACY_METAL = 4,
    LEGACY_PLASTIC = 5,
    LEGACY_WIREFRAME = 6,
    MATTE = 7,
    METAL = 8,
    PLASTIC = 9,
    POWDER = 10,
    SOFT_EDGE = 11,
    SOFT_METAL = 12,
    TRANSLUCENT_POWDER = 13,
    WARM_MATTE = 14,
class PresetShadowType(IntEnum):
    BELOW = 22,
    CUSTOM = 1,
    INSIDE_BOTTOM = 18,
    INSIDE_CENTER = 15,
    INSIDE_DIAGONAL_BOTTOM_LEFT = 17,
    INSIDE_DIAGONAL_BOTTOM_RIGHT = 19,
    INSIDE_DIAGONAL_TOP_LEFT = 11,
    INSIDE_DIAGONAL_TOP_RIGHT = 13,
    INSIDE_LEFT = 14,
    INSIDE_RIGHT = 16,
    INSIDE_TOP = 12,
    NO_SHADOW = 0,
    OFFSET_BOTTOM = 3,
    OFFSET_CENTER = 6,
    OFFSET_DIAGONAL_BOTTOM_LEFT = 4,
    OFFSET_DIAGONAL_BOTTOM_RIGHT = 2,
    OFFSET_DIAGONAL_TOP_LEFT = 10,
    OFFSET_DIAGONAL_TOP_RIGHT = 8,
    OFFSET_LEFT = 7,
    OFFSET_RIGHT = 5,
    OFFSET_TOP = 9,
    PERSPECTIVE_DIAGONAL_LOWER_LEFT = 23,
    PERSPECTIVE_DIAGONAL_LOWER_RIGHT = 24,
    PERSPECTIVE_DIAGONAL_UPPER_LEFT = 20,
    PERSPECTIVE_DIAGONAL_UPPER_RIGHT = 21,
class PresetThemeGradientType(IntEnum):
    BOTTOM_SPOTLIGHT = 3,
    LIGHT_GRADIENT = 0,
    MEDIUM_GRADIENT = 2,
    RADIAL_GRADIENT = 4,
    TOP_SPOTLIGHT = 1,
class PresetWordArtStyle(IntEnum):
    WORD_ART_STYLE_1 = 1,
    WORD_ART_STYLE_10 = 10,
    WORD_ART_STYLE_11 = 11,
    WORD_ART_STYLE_12 = 12,
    WORD_ART_STYLE_13 = 13,
    WORD_ART_STYLE_14 = 14,
    WORD_ART_STYLE_15 = 15,
    WORD_ART_STYLE_16 = 16,
    WORD_ART_STYLE_17 = 17,
    WORD_ART_STYLE_18 = 18,
    WORD_ART_STYLE_19 = 19,
    WORD_ART_STYLE_2 = 2,
    WORD_ART_STYLE_20 = 20,
    WORD_ART_STYLE_3 = 3,
    WORD_ART_STYLE_4 = 4,
    WORD_ART_STYLE_5 = 5,
    WORD_ART_STYLE_6 = 6,
    WORD_ART_STYLE_7 = 7,
    WORD_ART_STYLE_8 = 8,
    WORD_ART_STYLE_9 = 9,
class PrintCommentsType(IntEnum):
    PRINT_IN_PLACE = 0,
    PRINT_NO_COMMENTS = 1,
    PRINT_SHEET_END = 2,
class PrintErrorsType(IntEnum):
    PRINT_ERRORS_BLANK = 0,
    PRINT_ERRORS_DASH = 1,
    PRINT_ERRORS_DISPLAYED = 2,
    PRINT_ERRORS_NA = 3,
class PrintingPageType(IntEnum):
    DEFAULT = 0,
    IGNORE_BLANK = 1,
    IGNORE_STYLE = 2,
class PrintOrderType(IntEnum):
    DOWN_THEN_OVER = 0,
    OVER_THEN_DOWN = 1,
class PrintSizeType(IntEnum):
    CUSTOM = 2,
    FIT = 1,
    FULL = 0,
class PropertyType(IntEnum):
    BLOB = 5,
    BOOLEAN = 0,
    DATE_TIME = 1,
    DOUBLE = 2,
    NUMBER = 3,
    STRING = 4,
class ProtectionType(IntEnum):
    ALL = 0,
    CONTENTS = 1,
    NONE = 6,
    OBJECTS = 2,
    SCENARIOS = 3,
    STRUCTURE = 4,
    WINDOWS = 5,
class QuartileCalculationType(IntEnum):
    EXCLUSIVE = 0,
    INCLUSIVE = 1,
class ReConnectionMethodType(IntEnum):
    ALWAYS = 2,
    NEVER = 3,
    REQUIRED = 1,
class RectangleAlignmentType(IntEnum):
    BOTTOM = 0,
    BOTTOM_LEFT = 1,
    BOTTOM_RIGHT = 2,
    CENTER = 3,
    LEFT = 4,
    RIGHT = 5,
    TOP = 6,
    TOP_LEFT = 7,
    TOP_RIGHT = 8,
class ReflectionEffectType(IntEnum):
    CUSTOM = 1,
    FULL_REFLECTION_4_PT_OFFSET = 7,
    FULL_REFLECTION_8_PT_OFFSET = 10,
    FULL_REFLECTION_TOUCHING = 4,
    HALF_REFLECTION_4_PT_OFFSET = 6,
    HALF_REFLECTION_8_PT_OFFSET = 9,
    HALF_REFLECTION_TOUCHING = 3,
    NONE = 0,
    TIGHT_REFLECTION_4_PT_OFFSET = 5,
    TIGHT_REFLECTION_8_PT_OFFSET = 8,
    TIGHT_REFLECTION_TOUCHING = 2,
class RenameStrategy(IntEnum):
    DIGIT = 1,
    EXCEPTION = 0,
    LETTER = 2,
class ResourceLoadingType(IntEnum):
    DEFAULT = 0,
    SKIP = 1,
    USER_PROVIDED = 2,
class RevisionActionType(IntEnum):
    ADD = 0,
    DELETE = 1,
    DELETE_COLUMN = 2,
    DELETE_ROW = 3,
    INSERT_COLUMN = 4,
    INSERT_ROW = 5,
class RevisionType(IntEnum):
    AUTO_FORMAT = 3,
    CHANGE_CELLS = 2,
    COMMENT = 5,
    CUSTOM_VIEW = 0,
    DEFINED_NAME = 1,
    FORMAT = 6,
    INSERT_DELETE = 11,
    INSERT_SHEET = 7,
    MERGE_CONFLICT = 4,
    MOVE_CELLS = 8,
    QUERY_TABLE = 10,
    RENAME_SHEET = 12,
    UNDO = 9,
    UNKNOWN = 13,
class SaveFormat(IntEnum):
    AUTO = 0,
    BMP = 263,
    CSV = 1,
    DIF = 30,
    DOCX = 62,
    EMF = 258,
    EXCEL_97_TO_2003 = 5,
    FODS = 59,
    GIF = 322,
    HTML = 12,
    JPG = 261,
    JSON = 513,
    M_HTML = 17,
    MARKDOWN = 57,
    NUMBERS = 56,
    ODS = 14,
    OTS = 31,
    PDF = 13,
    PNG = 262,
    PPTX = 61,
    SPREADSHEET_ML = 15,
    SQL_SCRIPT = 514,
    SVG = 28,
    SXC = 60,
    TAB_DELIMITED = 11,
    TIFF = 21,
    TSV = 11,
    UNKNOWN = 255,
    XLAM = 10,
    XLSB = 16,
    XLSM = 7,
    XLSX = 6,
    XLT = 32,
    XLTM = 9,
    XLTX = 8,
    XML = 51,
    XPS = 20,
class SelectionType(IntEnum):
    EXTEND = 2,
    MULTI = 1,
    SINGLE = 0,
class ShapeAnchorType(IntEnum):
    ONE_CELL_ANCHOR = 1,
    TWO_CELL_ANCHOR = 0,
class ShapeLockType(IntEnum):
    ADJUST_HANDLES = 1,
    ARROWHEAD = 12,
    ASPECT_RATIO = 7,
    CROP = 4,
    GROUP = 0,
    MOVE = 6,
    POINTS = 3,
    RESIZE = 10,
    ROTATION = 8,
    SELECTION = 5,
    SHAPE_TYPE = 11,
    TEXT = 2,
    UNGROUP = 9,
class ShapePathType(IntEnum):
    ARC_TO = 6,
    CLOSE = 3,
    CUBIC_BEZIER_CURVE_TO = 1,
    END = 4,
    ESCAPE = 5,
    LINE_TO = 0,
    MOVE_TO = 2,
    UNKNOWN = 7,
class SheetType(IntEnum):
    BIFF_4_MACRO = 3,
    CHART = 2,
    DIALOG = 6,
    INTERNATIONAL_MACRO = 4,
    OTHER = 5,
    VB = 0,
    WORKSHEET = 1,
class ShiftType(IntEnum):
    DOWN = 0,
    LEFT = 1,
    NONE = 2,
    RIGHT = 3,
    UP = 4,
class ShowDropButtonType(IntEnum):
    ALWAYS = 2,
    FOCUS = 1,
    NEVER = 0,
class SlicerCacheCrossFilterType(IntEnum):
    NONE = 0,
    SHOW_ITEMS_WITH_DATA_AT_TOP = 1,
    SHOW_ITEMS_WITH_NO_DATA = 2,
class SlicerCacheItemSortType(IntEnum):
    ASCENDING = 0,
    DESCENDING = 1,
class SlicerStyleType(IntEnum):
    CUSTOM = 14,
    SLICER_STYLE_DARK_1 = 8,
    SLICER_STYLE_DARK_2 = 9,
    SLICER_STYLE_DARK_3 = 10,
    SLICER_STYLE_DARK_4 = 11,
    SLICER_STYLE_DARK_5 = 12,
    SLICER_STYLE_DARK_6 = 13,
    SLICER_STYLE_LIGHT_1 = 0,
    SLICER_STYLE_LIGHT_2 = 1,
    SLICER_STYLE_LIGHT_3 = 2,
    SLICER_STYLE_LIGHT_4 = 3,
    SLICER_STYLE_LIGHT_5 = 4,
    SLICER_STYLE_LIGHT_6 = 5,
    SLICER_STYLE_OTHER_1 = 6,
    SLICER_STYLE_OTHER_2 = 7,
class SmartTagShowType(IntEnum):
    ALL = 0,
    NO_SMART_TAG_INDICATOR = 1,
    NONE = 2,
class SortOnType(IntEnum):
    CELL_COLOR = 1,
    FONT_COLOR = 2,
    ICON = 3,
    VALUE = 0,
class SortOrder(IntEnum):
    ASCENDING = 0,
    DESCENDING = 1,
class SparklineAxisMinMaxType(IntEnum):
    AUTO_INDIVIDUAL = 0,
    CUSTOM = 2,
    GROUP = 1,
class SparklinePresetStyleType(IntEnum):
    CUSTOM = 36,
    STYLE_1 = 0,
    STYLE_10 = 9,
    STYLE_11 = 10,
    STYLE_12 = 11,
    STYLE_13 = 12,
    STYLE_14 = 13,
    STYLE_15 = 14,
    STYLE_16 = 15,
    STYLE_17 = 16,
    STYLE_18 = 17,
    STYLE_19 = 18,
    STYLE_2 = 1,
    STYLE_20 = 19,
    STYLE_21 = 20,
    STYLE_22 = 21,
    STYLE_23 = 22,
    STYLE_24 = 23,
    STYLE_25 = 24,
    STYLE_26 = 25,
    STYLE_27 = 26,
    STYLE_28 = 27,
    STYLE_29 = 28,
    STYLE_3 = 2,
    STYLE_30 = 29,
    STYLE_31 = 30,
    STYLE_32 = 31,
    STYLE_33 = 32,
    STYLE_34 = 33,
    STYLE_35 = 34,
    STYLE_36 = 35,
    STYLE_4 = 3,
    STYLE_5 = 4,
    STYLE_6 = 5,
    STYLE_7 = 6,
    STYLE_8 = 7,
    STYLE_9 = 8,
class SparklineType(IntEnum):
    COLUMN = 1,
    LINE = 0,
    STACKED = 2,
class SqlDataType(IntEnum):
    SQL_BIG_INT = -5,
    SQL_BINARY = -2,
    SQL_BIT = -7,
    SQL_CHAR = 1,
    SQL_DECIMAL = 3,
    SQL_DOUBLE = 8,
    SQL_FLOAT = 6,
    SQL_GUID = -11,
    SQL_INTEGER = 4,
    SQL_INTERVAL_DAY = 103,
    SQL_INTERVAL_DAY_TO_HOUR = 108,
    SQL_INTERVAL_DAY_TO_MINUTE = 109,
    SQL_INTERVAL_DAY_TO_SECOND = 110,
    SQL_INTERVAL_HOUR = 104,
    SQL_INTERVAL_HOUR_TO_MINUTE = 111,
    SQL_INTERVAL_HOUR_TO_SECOND = 112,
    SQL_INTERVAL_MINUTE = 105,
    SQL_INTERVAL_MINUTE_TO_SECOND = 113,
    SQL_INTERVAL_MONTH = 102,
    SQL_INTERVAL_SECOND = 106,
    SQL_INTERVAL_YEAR = 101,
    SQL_INTERVAL_YEAR_TO_MONTH = 107,
    SQL_LONG_VAR_BINARY = -4,
    SQL_LONG_VAR_CHAR = -1,
    SQL_NUMERIC = 2,
    SQL_REAL = 7,
    SQL_SIGNED_OFFSET = -20,
    SQL_SMALL_INT = 5,
    SQL_TINY_INT = -6,
    SQL_TYPE_DATE = 9,
    SQL_TYPE_TIME = 10,
    SQL_TYPE_TIMESTAMP = 11,
    SQL_UNKNOWN_TYPE = 0,
    SQL_UNSIGNED_OFFSET = -22,
    SQL_VAR_BINARY = -3,
    SQL_VAR_CHAR = 12,
    SQL_W_CHAR = -8,
    SQL_W_LONG_VARCHAR = -10,
    SQL_W_VARCHAR = -9,
class SqlScriptOperatorType(IntEnum):
    DELETE = 2,
    INSERT = 0,
    UPDATE = 1,
class StyleModifyFlag(IntEnum):
    ALIGNMENT_SETTINGS = 4161664,
    ALL = 234881011,
    BACKGROUND_COLOR = 16777216,
    BORDERS = 16224,
    BOTTOM_BORDER = 2048,
    CELL_SHADING = 29360128,
    DIAGONAL = 12288,
    DIAGONAL_DOWN_BORDER = 4096,
    DIAGONAL_UP_BORDER = 8192,
    FONT = 19,
    FONT_CAP = 18,
    FONT_CHARSET = 10,
    FONT_COLOR = 3,
    FONT_DIRTY = 12,
    FONT_EQUALIZE = 17,
    FONT_FAMILY = 9,
    FONT_ITALIC = 5,
    FONT_KERNING = 16,
    FONT_NAME = 2,
    FONT_SCHEME = 11,
    FONT_SCRIPT = 8,
    FONT_SIZE = 1,
    FONT_SPACING = 15,
    FONT_SPELLING_ERROR = 13,
    FONT_STRIKE = 7,
    FONT_U_FILL_TX = 14,
    FONT_UNDERLINE = 6,
    FONT_WEIGHT = 4,
    FOREGROUND_COLOR = 8388608,
    HIDE_FORMULA = 134217728,
    HORIZONTAL_ALIGNMENT = 32768,
    HORIZONTAL_BORDER = 32,
    INDENT = 131072,
    LEFT_BORDER = 256,
    LOCKED = 67108864,
    NUMBER_FORMAT = 16384,
    PATTERN = 4194304,
    PROTECTION_SETTINGS = 201326592,
    RELATIVE_INDENT = 128,
    RIGHT_BORDER = 512,
    ROTATION = 262144,
    SHRINK_TO_FIT = 1048576,
    TEXT_DIRECTION = 2097152,
    TOP_BORDER = 1024,
    VERTICAL_ALIGNMENT = 65536,
    VERTICAL_BORDER = 64,
    WRAP_TEXT = 524288,
class TableDataSourceType(IntEnum):
    QUERY_TABLE = 3,
    SHARE_POINT = 1,
    WORKSHEET = 0,
    XML = 2,
class TableStyleElementType(IntEnum):
    BLANK_ROW = 18,
    FIRST_COLUMN = 8,
    FIRST_COLUMN_STRIPE = 3,
    FIRST_COLUMN_SUBHEADING = 22,
    FIRST_HEADER_CELL = 11,
    FIRST_ROW_STRIPE = 5,
    FIRST_ROW_SUBHEADING = 25,
    FIRST_SUBTOTAL_COLUMN = 15,
    FIRST_SUBTOTAL_ROW = 19,
    FIRST_TOTAL_CELL = 13,
    GRAND_TOTAL_COLUMN = 28,
    GRAND_TOTAL_ROW = 29,
    HEADER_ROW = 9,
    LAST_COLUMN = 7,
    LAST_HEADER_CELL = 12,
    LAST_TOTAL_CELL = 14,
    PAGE_FIELD_LABELS = 1,
    PAGE_FIELD_VALUES = 2,
    SECOND_COLUMN_STRIPE = 4,
    SECOND_COLUMN_SUBHEADING = 23,
    SECOND_ROW_STRIPE = 6,
    SECOND_ROW_SUBHEADING = 26,
    SECOND_SUBTOTAL_COLUMN = 16,
    SECOND_SUBTOTAL_ROW = 20,
    THIRD_COLUMN_SUBHEADING = 24,
    THIRD_ROW_SUBHEADING = 27,
    THIRD_SUBTOTAL_COLUMN = 17,
    THIRD_SUBTOTAL_ROW = 21,
    TOTAL_ROW = 10,
    WHOLE_TABLE = 0,
class TableStyleType(IntEnum):
    CUSTOM = 61,
    NONE = 0,
    TABLE_STYLE_DARK_1 = 50,
    TABLE_STYLE_DARK_10 = 59,
    TABLE_STYLE_DARK_11 = 60,
    TABLE_STYLE_DARK_2 = 51,
    TABLE_STYLE_DARK_3 = 52,
    TABLE_STYLE_DARK_4 = 53,
    TABLE_STYLE_DARK_5 = 54,
    TABLE_STYLE_DARK_6 = 55,
    TABLE_STYLE_DARK_7 = 56,
    TABLE_STYLE_DARK_8 = 57,
    TABLE_STYLE_DARK_9 = 58,
    TABLE_STYLE_LIGHT_1 = 1,
    TABLE_STYLE_LIGHT_10 = 10,
    TABLE_STYLE_LIGHT_11 = 11,
    TABLE_STYLE_LIGHT_12 = 12,
    TABLE_STYLE_LIGHT_13 = 13,
    TABLE_STYLE_LIGHT_14 = 14,
    TABLE_STYLE_LIGHT_15 = 15,
    TABLE_STYLE_LIGHT_16 = 16,
    TABLE_STYLE_LIGHT_17 = 17,
    TABLE_STYLE_LIGHT_18 = 18,
    TABLE_STYLE_LIGHT_19 = 19,
    TABLE_STYLE_LIGHT_2 = 2,
    TABLE_STYLE_LIGHT_20 = 20,
    TABLE_STYLE_LIGHT_21 = 21,
    TABLE_STYLE_LIGHT_3 = 3,
    TABLE_STYLE_LIGHT_4 = 4,
    TABLE_STYLE_LIGHT_5 = 5,
    TABLE_STYLE_LIGHT_6 = 6,
    TABLE_STYLE_LIGHT_7 = 7,
    TABLE_STYLE_LIGHT_8 = 8,
    TABLE_STYLE_LIGHT_9 = 9,
    TABLE_STYLE_MEDIUM_1 = 22,
    TABLE_STYLE_MEDIUM_10 = 31,
    TABLE_STYLE_MEDIUM_11 = 32,
    TABLE_STYLE_MEDIUM_12 = 33,
    TABLE_STYLE_MEDIUM_13 = 34,
    TABLE_STYLE_MEDIUM_14 = 35,
    TABLE_STYLE_MEDIUM_15 = 36,
    TABLE_STYLE_MEDIUM_16 = 37,
    TABLE_STYLE_MEDIUM_17 = 38,
    TABLE_STYLE_MEDIUM_18 = 39,
    TABLE_STYLE_MEDIUM_19 = 40,
    TABLE_STYLE_MEDIUM_2 = 23,
    TABLE_STYLE_MEDIUM_20 = 41,
    TABLE_STYLE_MEDIUM_21 = 42,
    TABLE_STYLE_MEDIUM_22 = 43,
    TABLE_STYLE_MEDIUM_23 = 44,
    TABLE_STYLE_MEDIUM_24 = 45,
    TABLE_STYLE_MEDIUM_25 = 46,
    TABLE_STYLE_MEDIUM_26 = 47,
    TABLE_STYLE_MEDIUM_27 = 48,
    TABLE_STYLE_MEDIUM_28 = 49,
    TABLE_STYLE_MEDIUM_3 = 24,
    TABLE_STYLE_MEDIUM_4 = 25,
    TABLE_STYLE_MEDIUM_5 = 26,
    TABLE_STYLE_MEDIUM_6 = 27,
    TABLE_STYLE_MEDIUM_7 = 28,
    TABLE_STYLE_MEDIUM_8 = 29,
    TABLE_STYLE_MEDIUM_9 = 30,
class TargetModeType(IntEnum):
    CELL_REFERENCE = 3,
    EMAIL = 2,
    EXTERNAL = 0,
    FILE_PATH = 1,
class TextAlignmentType(IntEnum):
    BOTTOM = 528,
    CENTER = 1802,
    CENTER_ACROSS = 1286,
    DISTRIBUTED = 807,
    FILL = 1284,
    GENERAL = 1792,
    JUSTIFIED_LOW = 832,
    JUSTIFY = 1821,
    LEFT = 257,
    RIGHT = 259,
    THAI_DISTRIBUTED = 896,
    TOP = 512,
class TextAutonumberScheme(IntEnum):
    ALPHA_LC_PAREN_BOTH = 1,
    ALPHA_LC_PAREN_R = 2,
    ALPHA_LC_PERIOD = 3,
    ALPHA_UC_PAREN_BOTH = 4,
    ALPHA_UC_PAREN_R = 5,
    ALPHA_UC_PERIOD = 6,
    ARABIC_1_MINUS = 7,
    ARABIC_2_MINUS = 8,
    ARABIC_DB_PERIOD = 9,
    ARABIC_DB_PLAIN = 10,
    ARABIC_PAREN_BOTH = 11,
    ARABIC_PAREN_R = 12,
    ARABIC_PERIOD = 13,
    ARABIC_PLAIN = 14,
    CIRCLE_NUM_DB_PLAIN = 15,
    CIRCLE_NUM_WD_BLACK_PLAIN = 16,
    CIRCLE_NUM_WD_WHITE_PLAIN = 17,
    EA_1_CHS_PERIOD = 18,
    EA_1_CHS_PLAIN = 19,
    EA_1_CHT_PERIOD = 20,
    EA_1_CHT_PLAIN = 21,
    EA_1_JPN_CHS_DB_PERIOD = 22,
    EA_1_JPN_KOR_PERIOD = 23,
    EA_1_JPN_KOR_PLAIN = 24,
    HEBREW_2_MINUS = 25,
    HINDI_ALPHA_1_PERIOD = 26,
    HINDI_ALPHA_PERIOD = 27,
    HINDI_NUM_PAREN_R = 28,
    HINDI_NUM_PERIOD = 29,
    NONE = 0,
    ROMAN_LC_PAREN_BOTH = 30,
    ROMAN_LC_PAREN_R = 31,
    ROMAN_LC_PERIOD = 32,
    ROMAN_UC_PAREN_BOTH = 33,
    ROMAN_UC_PAREN_R = 34,
    ROMAN_UC_PERIOD = 35,
    THAI_ALPHA_PAREN_BOTH = 36,
    THAI_ALPHA_PAREN_R = 37,
    THAI_ALPHA_PERIOD = 38,
    THAI_NUM_PAREN_BOTH = 39,
    THAI_NUM_PAREN_R = 40,
    THAI_NUM_PERIOD = 41,
class TextCapsType(IntEnum):
    ALL = 1,
    NONE = 0,
    SMALL = 2,
class TextCrossType(IntEnum):
    CROSS_KEEP = 2,
    CROSS_OVERRIDE = 3,
    DEFAULT = 1,
    STRICT_IN_CELL = 4,
class TextDirectionType(IntEnum):
    CONTEXT = 0,
    LEFT_TO_RIGHT = 1,
    RIGHT_TO_LEFT = 2,
class TextFontAlignType(IntEnum):
    AUTOMATIC = 0,
    BASELINE = 2,
    BOTTOM = 1,
    CENTER = 3,
    TOP = 4,
class TextNodeType(IntEnum):
    EQUATION = 2,
    TEXT_PARAGRAPH = 1,
    TEXT_RUN = 0,
class TextOrientationType(IntEnum):
    CLOCK_WISE = 0,
    COUNTER_CLOCK_WISE = 1,
    NO_ROTATION = 2,
    TOP_TO_BOTTOM = 3,
class TextOverflowType(IntEnum):
    CLIP = 0,
    ELLIPSIS = 1,
    OVERFLOW = 2,
class TextStrikeType(IntEnum):
    DOUBLE = 1,
    NONE = 2,
    SINGLE = 0,
class TextTabAlignmentType(IntEnum):
    CENTER = 0,
    DECIMAL = 1,
    LEFT = 2,
    RIGHT = 3,
class TextureType(IntEnum):
    BLUE_TISSUE_PAPER = 0,
    BOUQUET = 1,
    BROWN_MARBLE = 2,
    CANVAS = 3,
    CORK = 4,
    DENIM = 5,
    FISH_FOSSIL = 6,
    GRANITE = 7,
    GREEN_MARBLE = 8,
    MEDIUM_WOOD = 9,
    NEWSPRINT = 10,
    OAK = 11,
    PAPER_BAG = 12,
    PAPYRUS = 13,
    PARCHMENT = 14,
    PINK_TISSUE_PAPER = 15,
    PURPLE_MESH = 16,
    RECYCLED_PAPER = 17,
    SAND = 18,
    STATIONERY = 19,
    UNKNOWN = 24,
    WALNUT = 20,
    WATER_DROPLETS = 21,
    WHITE_MARBLE = 22,
    WOVEN_MAT = 23,
class TextVerticalType(IntEnum):
    HORIZONTAL = 1,
    STACKED = 5,
    STACKED_RIGHT_TO_LEFT = 6,
    VERTICAL = 0,
    VERTICAL_270 = 4,
    VERTICAL_90 = 3,
    VERTICAL_LEFT_TO_RIGHT = 2,
class ThemeColorType(IntEnum):
    ACCENT_1 = 4,
    ACCENT_2 = 5,
    ACCENT_3 = 6,
    ACCENT_4 = 7,
    ACCENT_5 = 8,
    ACCENT_6 = 9,
    BACKGROUND_1 = 0,
    BACKGROUND_2 = 2,
    FOLLOWED_HYPERLINK = 11,
    HYPERLINK = 10,
    STYLE_COLOR = 12,
    TEXT_1 = 1,
    TEXT_2 = 3,
class TickLabelPositionType(IntEnum):
    HIGH = 0,
    LOW = 1,
    NEXT_TO_AXIS = 2,
    NONE = 3,
class TickMarkType(IntEnum):
    CROSS = 0,
    INSIDE = 1,
    NONE = 2,
    OUTSIDE = 3,
class TiffCompression(IntEnum):
    COMPRESSION_CCITT_3 = 3,
    COMPRESSION_CCITT_4 = 4,
    COMPRESSION_LZW = 2,
    COMPRESSION_NONE = 0,
    COMPRESSION_RLE = 1,
class TiffPhotometricInterpretation(IntEnum):
    BLACKISZERO = 1,
    WHITEISZERO = 0,
class TimePeriodType(IntEnum):
    LAST_7_DAYS = 3,
    LAST_MONTH = 5,
    LAST_WEEK = 8,
    LAST_YEAR = 11,
    NEXT_MONTH = 6,
    NEXT_WEEK = 9,
    NEXT_YEAR = 12,
    THIS_MONTH = 4,
    THIS_WEEK = 7,
    THIS_YEAR = 10,
    TODAY = 0,
    TOMORROW = 2,
    YESTERDAY = 1,
class TimeUnit(IntEnum):
    DAYS = 0,
    MONTHS = 1,
    YEARS = 2,
class TotalsCalculation(IntEnum):
    AVERAGE = 1,
    COUNT = 2,
    COUNT_NUMS = 3,
    CUSTOM = 9,
    MAX = 4,
    MIN = 5,
    NONE = 0,
    STD_DEV = 7,
    SUM = 6,
    VAR = 8,
class TrendlineType(IntEnum):
    EXPONENTIAL = 0,
    LINEAR = 1,
    LOGARITHMIC = 2,
    MOVING_AVERAGE = 3,
    POLYNOMIAL = 4,
    POWER = 5,
class TxtLoadStyleStrategy(IntEnum):
    BUILT_IN = 1,
    EXACT_FORMAT = 2,
    NONE = 0,
class TxtValueQuoteType(IntEnum):
    ALWAYS = 1,
    MINIMUM = 2,
    NEVER = 3,
    NORMAL = 0,
class UpdateLinksType(IntEnum):
    ALWAYS = 2,
    NEVER = 1,
    USER_SET = 0,
class ValidationAlertType(IntEnum):
    INFORMATION = 0,
    STOP = 1,
    WARNING = 2,
class ValidationType(IntEnum):
    ANY_VALUE = 0,
    CUSTOM = 7,
    DATE = 4,
    DECIMAL = 2,
    LIST = 3,
    TEXT_LENGTH = 6,
    TIME = 5,
    WHOLE_NUMBER = 1,
class VbaModuleType(IntEnum):
    CLASS = 2,
    DESIGNER = 3,
    DOCUMENT = 1,
    PROCEDURAL = 0,
class VbaProjectReferenceType(IntEnum):
    CONTROL = 1,
    PROJECT = 2,
    REGISTERED = 0,
class ViewType(IntEnum):
    NORMAL_VIEW = 0,
    PAGE_BREAK_PREVIEW = 1,
    PAGE_LAYOUT_VIEW = 2,
class VisibilityType(IntEnum):
    HIDDEN = 1,
    VERY_HIDDEN = 2,
    VISIBLE = 0,
class WebExtensionStoreType(IntEnum):
    EX_CATALOG = 6,
    EXCHANGE = 3,
    FILE_SYSTEM = 4,
    OMEX = 0,
    REGISTRY = 5,
    SP_APP = 2,
    SP_CATALOG = 1,
class WeightType(IntEnum):
    HAIR_LINE = -1,
    MEDIUM_LINE = 1,
    SINGLE_LINE = 0,
    WIDE_LINE = 2,
class XAdESType(IntEnum):
    NONE = 0,
    X_AD_ES = 1,

from com.aspose.cells import AboveAverage
from com.aspose.cells import AutoFitterOptions
from com.aspose.cells import AutoNumberedBulletValue
from com.aspose.cells import AxisBins
from com.aspose.cells import CalculationOptions
from com.aspose.cells import CellArea
from com.aspose.cells import CellsFactory
from com.aspose.cells import CellWatch
from com.aspose.cells import CellWatchCollection
from com.aspose.cells import CharacterBulletValue
from com.aspose.cells import ChartGlobalizationSettings
from com.aspose.cells import Color
from com.aspose.cells import CopyOptions
from com.aspose.cells import CustomFilterCollection
from com.aspose.cells import CustomProperty
from com.aspose.cells import DataSorterKeyCollection
from com.aspose.cells import DateTime
from com.aspose.cells import DateTimeGroupItem
from com.aspose.cells import DeleteOptions
from com.aspose.cells import DifSaveOptions
from com.aspose.cells import DigitalSignature
from com.aspose.cells import DigitalSignatureCollection
from com.aspose.cells import DocxSaveOptions
from com.aspose.cells import ExportRangeToJsonOptions
from com.aspose.cells import FileFontSource
from com.aspose.cells import FileFormatInfo
from com.aspose.cells import FindOptions
from com.aspose.cells import FolderFontSource
from com.aspose.cells import FontConfigs
from com.aspose.cells import FontSetting
from com.aspose.cells import FormulaParseOptions
from com.aspose.cells import GlobalizationSettings
from com.aspose.cells import HtmlLoadOptions
from com.aspose.cells import HtmlSaveOptions
from com.aspose.cells import ImageOrPrintOptions
from com.aspose.cells import ImageSaveOptions
from com.aspose.cells import IndividualFontConfigs
from com.aspose.cells import InsertOptions
from com.aspose.cells import JsonLayoutOptions
from com.aspose.cells import JsonLoadOptions
from com.aspose.cells import JsonSaveOptions
from com.aspose.cells import JsonUtility
from com.aspose.cells import License
from com.aspose.cells import LoadFilter
from com.aspose.cells import LoadOptions
from com.aspose.cells import MarkdownSaveOptions
from com.aspose.cells import MemoryFontSource
from com.aspose.cells import MetadataOptions
from com.aspose.cells import Metered
from com.aspose.cells import MultipleFilterCollection
from com.aspose.cells import NoneBulletValue
from com.aspose.cells import NumbersLoadOptions
from com.aspose.cells import OdsLoadOptions
from com.aspose.cells import OdsPageBackground
from com.aspose.cells import OdsSaveOptions
from com.aspose.cells import OoxmlSaveOptions
from com.aspose.cells import PasteOptions
from com.aspose.cells import PdfBookmarkEntry
from com.aspose.cells import PdfSaveOptions
from com.aspose.cells import PdfSecurityOptions
from com.aspose.cells import PicFormatOption
from com.aspose.cells import PictureBulletValue
from com.aspose.cells import PivotPageFields
from com.aspose.cells import PowerQueryFormulaParameter
from com.aspose.cells import PowerQueryFormulaParameterCollection
from com.aspose.cells import PptxSaveOptions
from com.aspose.cells import ReplaceOptions
from com.aspose.cells import SeriesLayoutProperties
from com.aspose.cells import ShapeGuideCollection
from com.aspose.cells import ShapePath
from com.aspose.cells import ShapePathPointCollection
from com.aspose.cells import ShapeSegmentPathCollection
from com.aspose.cells import SheetPrintingPreview
from com.aspose.cells import SheetRender
from com.aspose.cells import SheetSet
from com.aspose.cells import SignatureLine
from com.aspose.cells import SmartTagOptions
from com.aspose.cells import SmartTagPropertyCollection
from com.aspose.cells import SpreadsheetML2003SaveOptions
from com.aspose.cells import SqlScriptColumnTypeMap
from com.aspose.cells import SqlScriptSaveOptions
from com.aspose.cells import Style
from com.aspose.cells import StyleFlag
from com.aspose.cells import SvgSaveOptions
from com.aspose.cells import TableToRangeOptions
from com.aspose.cells import TextTabStopCollection
from com.aspose.cells import ThemeColor
from com.aspose.cells import ThreadedCommentAuthorCollection
from com.aspose.cells import TilePicOption
from com.aspose.cells import Top10
from com.aspose.cells import TxtLoadOptions
from com.aspose.cells import TxtSaveOptions
from com.aspose.cells import WebExtensionBinding
from com.aspose.cells import WebExtensionBindingCollection
from com.aspose.cells import WebExtensionPropertyCollection
from com.aspose.cells import WebExtensionReferenceCollection
from com.aspose.cells import Workbook
from com.aspose.cells import WorkbookDesigner
from com.aspose.cells import WorkbookMetadata
from com.aspose.cells import WorkbookPrintingPreview
from com.aspose.cells import WorkbookRender
from com.aspose.cells import WriteProtection
from com.aspose.cells import XlsbSaveOptions
from com.aspose.cells import XlsSaveOptions
from com.aspose.cells import XmlColumnProperty
from com.aspose.cells import XmlLoadOptions
from com.aspose.cells import XmlSaveOptions
from com.aspose.cells import XpsSaveOptions

from com.aspose.cells import CellsHelper
from com.aspose.cells import ColorHelper
from com.aspose.cells import ConditionalFormattingIcon
from com.aspose.cells import Encoding
from com.aspose.cells import FileFormatUtil
from com.aspose.cells import ImageFormat


@JImplementationFor("com.aspose.cells.License")
class _License(object):
    @JOverride(sticky=False)
    def setLicense(self, arg):
        if arg == None:
            raise Exception("an argument is required")
        elif arg.__class__.__name__ != 'bytes' and arg.__class__.__name__ != 'str':
            raise TypeError("a bytes-like or string object is required")
        elif len(arg) <= 0:
            raise ValueError("no content")
        
        if arg.__class__.__name__ == 'str':
            self._setLicense(arg)
            return

        if arg.__class__.__name__ == 'bytes':
            sb = StreamBuffer()
            sb.write(arg)
            self._setLicense(sb.toInputStream())
        return

@JImplementationFor("com.aspose.cells.Workbook")
class _Workbook(object):

    @staticmethod
    def createWorkbookFromBytes(byte_array, **kwargs):
        sb = StreamBuffer()
        sb.write(byte_array)
        loadOptions = kwargs.get("loadOptions")
        if loadOptions == None:
            return Workbook(sb.toInputStream())
        else:
            return Workbook(sb.toInputStream(), loadOptions)
    
    def saveToBytes(self, arg):
        sb = StreamBuffer()
        self.save(sb, arg)
        buf = sb.toByteArray()
        if buf != None and buf.length > 0:
            return array("b", buf).tobytes()
        else:
            return b''

from com.aspose.cells import PictureCollection
@JImplementationFor("com.aspose.cells.PictureCollection")
class _PictureCollection(object):

    def addPictureFromBytes(self, upperLeftRow, upperLeftColumn, **kwargs):

        byte_array = kwargs.get("byte_array")
        lowerRightRow = kwargs.get("lowerRightRow")
        lowerRightColumn = kwargs.get("lowerRightColumn")
        widthScale = kwargs.get("widthScale")
        heightScale = kwargs.get("heightScale")

        if byte_array == None or byte_array.__class__.__name__ != 'bytes':
            raise TypeError("a bytes-like object is required")

        if lowerRightRow == None and lowerRightColumn == None and widthScale == None and heightScale == None:
            sb = StreamBuffer()
            sb.write(byte_array)
            return self.add(upperLeftRow, upperLeftColumn, sb.toInputStream())

        if lowerRightRow != None and lowerRightColumn != None and widthScale == None and heightScale == None:
            sb = StreamBuffer()
            sb.write(byte_array)
            return self.add(upperLeftRow, upperLeftColumn, lowerRightRow, lowerRightColumn, sb.toInputStream())

        if lowerRightRow == None and lowerRightColumn == None and widthScale != None and heightScale != None:
            sb = StreamBuffer()
            sb.write(byte_array)
            return self.add(upperLeftRow, upperLeftColumn, sb.toInputStream(), widthScale, heightScale)

        raise ValueError("Invalid arguments")

from com.aspose.cells import ShapeCollection
@JImplementationFor("com.aspose.cells.ShapeCollection")
class _ShapeCollection(object):

    def addPictureFromBytes(self, upperLeftRow, upperLeftColumn, **kwargs):

        byte_array = kwargs.get("byte_array")
        lowerRightRow = kwargs.get("lowerRightRow")
        lowerRightColumn = kwargs.get("lowerRightColumn")
        widthScale = kwargs.get("widthScale")
        heightScale = kwargs.get("heightScale")

        if byte_array == None or byte_array.__class__.__name__ != 'bytes':
            raise TypeError("a bytes-like object is required")

        if lowerRightRow != None and lowerRightColumn != None and widthScale == None and heightScale == None:
            sb = StreamBuffer()
            sb.write(byte_array)
            return self.addPicture(upperLeftRow, upperLeftColumn, lowerRightRow, lowerRightColumn, sb.toInputStream())

        if lowerRightRow == None and lowerRightColumn == None and widthScale != None and heightScale != None:
            sb = StreamBuffer()
            sb.write(byte_array)
            return self.addPicture(upperLeftRow, upperLeftColumn, sb.toInputStream(), widthScale, heightScale)

        raise ValueError("Invalid arguments")

    def addPictureInChartFromBytes(self, top, left, byte_array, widthScale, heightScale):

        if byte_array == None or byte_array.__class__.__name__ != 'bytes':
            raise TypeError("a bytes-like object is required")

        sb = StreamBuffer()
        sb.write(byte_array)
        return self.addPictureInChart(top, left, sb.toInputStream(), widthScale, heightScale)

from com.aspose.cells import Cells
@JImplementationFor("com.aspose.cells.Cells")
class _Cells(object):

    def importCSVFromBytes(self, byte_array, firstRow, firstColumn, options=None, spliter=None, convertNumericData=None):

        if byte_array == None or byte_array.__class__.__name__ != 'bytes':
            raise TypeError("a bytes-like object is required")

        if options != None and spliter == None and convertNumericData == None:
            sb = StreamBuffer()
            sb.write(byte_array)
            self.importCSV(sb.toInputStream(), options, firstRow, firstColumn)
            return

        if options == None and spliter != None and convertNumericData != None:
            sb = StreamBuffer()
            sb.write(byte_array)
            self.importCSV(sb.toInputStream(), spliter, convertNumericData, firstRow, firstColumn)
            return

        raise ValueError("Invalid arguments")

@JImplementationFor("com.aspose.cells.WorksheetCollection")
class _WorksheetCollection(object):
    @JOverride(sticky=False)
    def add(self, *args):
        if len(args) == 1 and isinstance(args[0], int):
            return self._add(JInt(args[0]))
        else:
            return self._add(*args)
        raise ValueError("Invalid arguments")

@JImplementationFor("com.aspose.cells.TrendlineCollection")
class _TrendlineCollection(object):
    @JOverride(sticky=False)
    def add(self, *args):
        if len(args) == 1 and isinstance(args[0], int):
            return self._add(JInt(args[0]))
        else:
            return self._add(*args)
        raise ValueError("Invalid arguments")

@JImplementationFor("com.aspose.cells.Cell")
class _Cell(object):
    @JOverride(sticky=False)
    def putValue(self, *args):
        if len(args) == 1 and isinstance(args[0], int):
            self._putValue(JInt(args[0]))
        elif len(args) == 1 and type(args[0]).__name__ == "java.lang.Double":
            self._putValue(JDouble(args[0]))
        else:
            self._putValue(*args)
            
@JImplementationFor("com.aspose.cells.VerticalPageBreakCollection")
class _VerticalPageBreakCollection(object):
    @JOverride(sticky=False)
    def add(self, *args):
        if len(args) == 1 and isinstance(args[0], int):
            return self._add(JInt(args[0]))
        else:
            return self._add(*args)
        raise ValueError("Invalid arguments")

@JImplementationFor("com.aspose.cells.HorizontalPageBreakCollection")
class _HorizontalPageBreakCollection(object):
    @JOverride(sticky=False)
    def add(self, *args):
        if len(args) == 1 and isinstance(args[0], int):
            return self._add(JInt(args[0]))
        else:
            return self._add(*args)
        raise ValueError("Invalid arguments")

@JImplementationFor("com.aspose.cells.SheetRender")
class _SheetRender(object):

    def toImageBytes(self, pageIndex):

        sb = StreamBuffer()
        self.toImage(pageIndex, sb)
        buf = sb.toByteArray()
        return array("b", buf).tobytes()

@JImplementationFor("com.aspose.cells.FileFormatUtil")
class _FileFormatUtil(object):

    @staticmethod
    def detectFileFormatFromBytes(file_bytes):

        sb = StreamBuffer()
        sb.write(file_bytes)
        return FileFormatUtil.detectFileFormat(sb.toInputStream())

from com.aspose.cells import Chart
@JImplementationFor("com.aspose.cells.Chart")
class _Chart(object):

    def toImageBytes(self, options):

        sb = StreamBuffer()
        self.toImage(sb, options)
        buf = sb.toByteArray()
        return array("b", buf).tobytes()

    def toPdfBytes(self, *args):

        if len(args) == 0:
            sb = StreamBuffer()
            self.toPdf(sb)
            buf = sb.toByteArray()
            return array("b", buf).tobytes()
        elif len(args) == 4:
            sb = StreamBuffer()
            self.toPdf(sb, *args)
            buf = sb.toByteArray()
            return array("b", buf).tobytes()

from com.aspose.cells import Shape
@JImplementationFor("com.aspose.cells.Shape")
class _Shape(object):

    def toImageBytes(self, imageFormat=None, options=None):

        if imageFormat != None and options == None:
            sb = StreamBuffer()
            self.toImage(sb, imageFormat)
            buf = sb.toByteArray()
            return array("b", buf).tobytes()

        if imageFormat == None and options != None:
            sb = StreamBuffer()
            self.toImage(sb, options)
            buf = sb.toByteArray()
            return array("b", buf).tobytes()

        raise ValueError("Invalid arguments")

from com.aspose.cells import Sparkline
@JImplementationFor("com.aspose.cells.Sparkline")
class _Sparkline(object):

    def toImageBytes(self, options):

        sb = StreamBuffer()
        self.toImage(sb, options)
        buf = sb.toByteArray()
        return array("b", buf).tobytes()

@JImplementationFor("com.aspose.cells.WorkbookRender")
class _WorkbookRender(object):

    def toImageBytes(self):

        sb = StreamBuffer()
        self.toImage(sb)
        buf = sb.toByteArray()
        return array("b", buf).tobytes()
