/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cells;

import com.aspose.cells.a.a.z5h;
import com.aspose.cells.a.c.u;
import com.aspose.cells.b.a.f.d9o;
import com.aspose.cells.b.a.f.f;
import com.aspose.cells.b.a.f.o4r;
import com.aspose.cells.b.a.f.x4o;
import com.aspose.cells.h46;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class Encoding {
    private int b;
    private String c;
    private String d;
    private Charset e = null;
    private ThreadLocal<CharsetDecoder> f = new h46(this);
    private CharsetEncoder g = null;

    public static Encoding getASCII() {
        return new Encoding(20127, "US-ASCII", "us-ascii");
    }

    public static Encoding getUTF7() {
        return new Encoding(65000, "UTF-7", "utf-7");
    }

    public static Encoding getUTF8() {
        return new o4r(true);
    }

    public static Encoding getUTF8NoBOM() {
        return new o4r(false);
    }

    public static Encoding getUnicode() {
        return new Encoding(1200, "UTF-16LE", "utf-16");
    }

    public static Encoding getBigEndianUnicode() {
        return new Encoding(1201, "UTF-16BE", "unicodeFFFE");
    }

    protected Encoding(int codePage, String charsetName, String headerName) {
        this.b = codePage;
        this.c = charsetName;
        this.d = headerName;
    }

    public static Encoding a(boolean bl, boolean bl2) {
        if (bl) {
            return Encoding.getBigEndianUnicode();
        }
        return Encoding.getUnicode();
    }

    public static Encoding getDefault() {
        return Encoding.getEncoding(Charset.defaultCharset().name());
    }

    public static Encoding b(boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("UTF32 Encoding not supported in java version.");
    }

    public static Encoding getEncoding(int codePage) {
        for (f f10 : com.aspose.cells.b.a.f.f.a()) {
            if (f10.T != codePage) continue;
            return new Encoding(codePage, f10.U, f10.V);
        }
        return Encoding.getUTF8();
    }

    public static Encoding getEncoding(String charsetName) {
        Charset charset;
        u.b(charsetName, "charsetName");
        for (f f10 : com.aspose.cells.b.a.f.f.a()) {
            if (!charsetName.equalsIgnoreCase(f10.U)) continue;
            return new Encoding(f10.T, f10.U, f10.V);
        }
        Object var1_2 = null;
        try {
            charset = Charset.forName(charsetName);
        }
        catch (Exception exception) {
            if (z5h.a()) {
                z5h.a("GetEncoding(" + charsetName + ")-" + z5h.a(exception));
            }
            return Encoding.getUTF8();
        }
        Encoding encoding = new Encoding(0, charsetName, charsetName.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public static Encoding getEncoding(Charset charset) {
        String string = charset.displayName();
        for (f f10 : com.aspose.cells.b.a.f.f.a()) {
            if (!string.equalsIgnoreCase(f10.U)) continue;
            return new Encoding(f10.T, f10.U, f10.V);
        }
        Encoding encoding = new Encoding(0, string, string.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public String a() {
        return this.d;
    }

    public String b() {
        return this.c;
    }

    public x4o c() {
        return new x4o(this.h());
    }

    CharsetDecoder d() {
        return this.f.get();
    }

    public d9o e() throws Exception {
        return new d9o(this.h());
    }

    CharsetEncoder f() throws Exception {
        if (this.g == null) {
            this.g = this.h().newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.g;
    }

    public int a(int n10) throws Exception {
        return (int)((float)n10 * this.f().maxBytesPerChar());
    }

    public byte[] g() {
        switch (this.b) {
            case 65001: {
                return new byte[]{-17, -69, -65};
            }
            case 1200: {
                return new byte[]{-1, -2};
            }
            case 1201: {
                return new byte[]{-2, -1};
            }
        }
        return new byte[0];
    }

    public int a(String string, int n10, int n12, byte[] byArray, int n14) {
        ByteBuffer byteBuffer = this.h().encode(CharBuffer.wrap(string, n10, n10 + n12));
        int n15 = byteBuffer.remaining();
        byteBuffer.get(byArray, n14, n15);
        return n15;
    }

    public int a(char[] cArray, int n10, int n12, byte[] byArray, int n14) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n10, n12);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        int n15 = byteBuffer.remaining();
        byteBuffer.get(byArray, n14, n15);
        return n15;
    }

    public byte[] a(String string) {
        ByteBuffer byteBuffer = this.h().encode(string);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray, int n10, int n12) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n10, n12);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public int b(String string) {
        byte[] byArray = this.a(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    private byte[] a(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        int n10 = byteBuffer.remaining();
        if (n10 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n10];
        System.arraycopy(byArray, 0, byArray2, 0, n10);
        return byArray2;
    }

    public String a(byte[] byArray, int n10, int n12) {
        com.aspose.cells.a.c.x4o.a(byArray, n10, n12);
        if (n12 == 0) {
            return "";
        }
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray, n10, n12));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    private void a(Exception exception) {
        throw new IllegalStateException("Invalid encoding: " + exception.getMessage(), exception);
    }

    public String a(byte[] byArray) {
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    public Charset h() {
        if (this.e != null) {
            return this.e;
        }
        try {
            this.e = Charset.forName(this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        return this.e;
    }

    public boolean equals(Object o10) {
        return o10 instanceof Encoding && this.equals((Encoding)o10);
    }

    public boolean equals(Encoding other) {
        return this.c.equalsIgnoreCase(other.c);
    }

    public int i() {
        return this.b;
    }
}

