"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the Kinesis Data stream.
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_KinesisPutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisPutRecordAction);
            }
            throw error;
        }
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.KinesisPutRecordAction = KinesisPutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.KinesisPutRecordAction", version: "2.66.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1wdXQtcmVjb3JkLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImtpbmVzaXMtcHV0LXJlY29yZC1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsMkNBQTJDO0FBSTNDLHlDQUFxRDtBQW9CckQ7O0dBRUc7QUFDSCxNQUFhLHNCQUFzQjtJQUlqQzs7O09BR0c7SUFDSCxZQUE2QixNQUF1QixFQUFFLEtBQWtDO1FBQTNELFdBQU0sR0FBTixNQUFNLENBQWlCOzs7Ozs7K0NBUnpDLHNCQUFzQjs7OztRQVMvQixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO0tBQ3hCO0lBRUQ7O09BRUc7SUFDSSxLQUFLLENBQUMsSUFBb0I7UUFDL0IsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLElBQUksSUFBSSwwQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwRCxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ2hELE9BQU8sRUFBRSxDQUFDLG1CQUFtQixDQUFDO1lBQzlCLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDO1NBQ25DLENBQUMsQ0FBQyxDQUFDO1FBRUosT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixPQUFPLEVBQUU7b0JBQ1AsVUFBVSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVTtvQkFDbEMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZLElBQUksU0FBUztvQkFDNUMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO2lCQUN0QjthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQWhDSCx3REFpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBpb3QgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdC1hbHBoYSc7XG5pbXBvcnQgKiBhcyBraW5lc2lzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1raW5lc2lzJztcbmltcG9ydCB7IENvbW1vbkFjdGlvblByb3BzIH0gZnJvbSAnLi9jb21tb24tYWN0aW9uLXByb3BzJztcbmltcG9ydCB7IHNpbmdsZXRvbkFjdGlvblJvbGUgfSBmcm9tICcuL3ByaXZhdGUvcm9sZSc7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGFjdGlvbiBmb3IgdGhlIEtpbmVzaXMgRGF0YSBzdHJlYW0uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgS2luZXNpc1B1dFJlY29yZEFjdGlvblByb3BzIGV4dGVuZHMgQ29tbW9uQWN0aW9uUHJvcHMge1xuICAvKipcbiAgICogVGhlIHBhcnRpdGlvbiBrZXkgdXNlZCB0byBkZXRlcm1pbmUgdG8gd2hpY2ggc2hhcmQgdGhlIGRhdGEgaXMgd3JpdHRlbi5cbiAgICogVGhlIHBhcnRpdGlvbiBrZXkgaXMgdXN1YWxseSBjb21wb3NlZCBvZiBhbiBleHByZXNzaW9uIChmb3IgZXhhbXBsZSwgJHt0b3BpYygpfSBvciAke3RpbWVzdGFtcCgpfSkuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90LXN1YnN0aXR1dGlvbi10ZW1wbGF0ZXMuaHRtbFxuICAgKlxuICAgKiBZb3UgY2FuIHVzZSB0aGUgZXhwcmVzc2lvbiAnJHtuZXd1dWlkKCl9JyBpZiB5b3VyIHBheWxvYWQgZG9lcyBub3QgaGF2ZSBhIGhpZ2ggY2FyZGluYXJpdHkgcHJvcGVydHkuXG4gICAqIElmIHlvdSB1c2UgZW1wdHkgc3RyaW5nLCB0aGlzIGFjdGlvbiB1c2Ugbm8gcGFydGl0aW9uIGtleSBhbmQgYWxsIHJlY29yZHMgd2lsbCBwdXQgc2FtZSBvbmUgc2hhcmQuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2tpbmVzaXMvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUHV0UmVjb3JkLmh0bWwjQVBJX1B1dFJlY29yZF9SZXF1ZXN0UGFyYW1ldGVyc1xuICAgKi9cbiAgcmVhZG9ubHkgcGFydGl0aW9uS2V5OiBzdHJpbmc7XG59XG5cbi8qKlxuICogVGhlIGFjdGlvbiB0byBwdXQgdGhlIHJlY29yZCBmcm9tIGFuIE1RVFQgbWVzc2FnZSB0byB0aGUgS2luZXNpcyBEYXRhIHN0cmVhbS5cbiAqL1xuZXhwb3J0IGNsYXNzIEtpbmVzaXNQdXRSZWNvcmRBY3Rpb24gaW1wbGVtZW50cyBpb3QuSUFjdGlvbiB7XG4gIHByaXZhdGUgcmVhZG9ubHkgcGFydGl0aW9uS2V5Pzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IHJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIEBwYXJhbSBzdHJlYW0gVGhlIEtpbmVzaXMgRGF0YSBzdHJlYW0gdG8gd2hpY2ggdG8gcHV0IHJlY29yZHMuXG4gICAqIEBwYXJhbSBwcm9wcyBPcHRpb25hbCBwcm9wZXJ0aWVzIHRvIG5vdCB1c2UgZGVmYXVsdFxuICAgKi9cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBzdHJlYW06IGtpbmVzaXMuSVN0cmVhbSwgcHJvcHM6IEtpbmVzaXNQdXRSZWNvcmRBY3Rpb25Qcm9wcykge1xuICAgIHRoaXMucGFydGl0aW9uS2V5ID0gcHJvcHMucGFydGl0aW9uS2V5O1xuICAgIHRoaXMucm9sZSA9IHByb3BzLnJvbGU7XG4gIH1cblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwdWJsaWMgX2JpbmQocnVsZTogaW90LklUb3BpY1J1bGUpOiBpb3QuQWN0aW9uQ29uZmlnIHtcbiAgICBjb25zdCByb2xlID0gdGhpcy5yb2xlID8/IHNpbmdsZXRvbkFjdGlvblJvbGUocnVsZSk7XG4gICAgcm9sZS5hZGRUb1ByaW5jaXBhbFBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ2tpbmVzaXM6UHV0UmVjb3JkJ10sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLnN0cmVhbS5zdHJlYW1Bcm5dLFxuICAgIH0pKTtcblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGtpbmVzaXM6IHtcbiAgICAgICAgICBzdHJlYW1OYW1lOiB0aGlzLnN0cmVhbS5zdHJlYW1OYW1lLFxuICAgICAgICAgIHBhcnRpdGlvbktleTogdGhpcy5wYXJ0aXRpb25LZXkgfHwgdW5kZWZpbmVkLFxuICAgICAgICAgIHJvbGVBcm46IHJvbGUucm9sZUFybixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19