from cvsvc_apirisk.score.base import ScoreNode, check_remed


class SpecSecSecurityAttr06(ScoreNode):

    def __init__(self, qspec, target_obj=None, attr_wt=9):
        """
        Description

        Params
        ------
        p1 : float
            Param description
        p2 : int, optional
            Param description

        Returns
        -------
        result: int
            Result desc
        """
        super().__init__()

        self.fix_template = \
            '[CVSPS006] [%s]: "securityDefinitions" field is not defined '\
            'or is empty.'

        self.qspec = qspec
        self.target_obj = target_obj
        self.attr_wt = attr_wt

        return

    def __repr__(self):
        """
        Description

        Params
        ------
        p1 : float
            Param description
        p2 : int, optional
            Param description

        Returns
        -------
        result: int
            Result desc
        """
        return 'sps-sec-attr06'

    def compute_openapiv2(self):
        """
        Description

        Params
        ------
        p1 : float
            Param description
        p2 : int, optional
            Param description

        Returns
        -------
        result: int
            Result desc
        """
        score = 0
        remed_clues = []

        secdefn_node = '%s -> securityDefinitions' % self.qspec.ROOT_NODE
        if ((not self.qspec.G.has_node(secdefn_node)) or
                (self.qspec.G.out_degree(secdefn_node) == 0)):
            score = 1
            remed_clues.append(self.fix_template % secdefn_node)

        self.score = self.attr_wt*score
        if self.score > 0:
            self.remed_clue = remed_clues
            self.meta = [(self.attr_wt, x) for x in remed_clues]

        return

    @check_remed
    def compute(self):
        """
        Description

        Params
        ------
        p1 : float
            Param description
        p2 : int, optional
            Param description

        Returns
        -------
        result: int
            Result desc
        """
        self.compute_openapiv2()
        return
