from py_viptela.query_builder import Builder
from py_viptela import HttpMethods

def getList(vmanage, deviceId):
    """
    Get device reboot history
    
    Parameters:
    deviceId	 (string):	Device IP
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"https://{vmanage.host}:{vmanage.port}/dataservice/device/reboothistory?deviceId={deviceId}"
    response = vmanage.client.apiCall(HttpMethods.GET, endpoint)
    return response
def getDetails(vmanage):
    """
    Get detailed reboot history list
    
    Parameters:
            
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"https://{vmanage.host}:{vmanage.port}/dataservice/device/reboothistory/details"
    response = vmanage.client.apiCall(HttpMethods.GET, endpoint)
    return response
def getSyncedList(vmanage, deviceId):
    """
    Get device reboot history synchronously
    
    Parameters:
    deviceId	 (string):	Device IP
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"https://{vmanage.host}:{vmanage.port}/dataservice/device/reboothistory/synced?deviceId={deviceId}"
    response = vmanage.client.apiCall(HttpMethods.GET, endpoint)
    return response
