/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.utils;

import com.github.takezoe.scaladoc.Scaladoc;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@Scaladoc(value="/** This is a helper class predominantly used by the FileSpout, file based Sinks and example Runners to simplify file handling and downloading of remote datasets.\n  * It is included for users creating their own examples or alternative file handling spouts/sinks.\n  */")
public final class FileUtils$ {
    public static final FileUtils$ MODULE$ = new FileUtils$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileUtils$ fileUtils$ = this;
        synchronized (fileUtils$) {
            if (!bitmap$0) {
                logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
                bitmap$0 = true;
            }
        }
        return logger;
    }

    private Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    /*
     * WARNING - void declaration
     */
    public File createOrCleanDirectory(String path, boolean clean) {
        void var3_3;
        Object object;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Creating temp folder '{}'.", (Object)path);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        File tempDirectory = new File(path);
        if (tempDirectory.exists()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Temporary directory '{}' already exists.", (Object)tempDirectory);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            object = clean ? BoxesRunTime.boxToBoolean((boolean)tempDirectory.delete()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        try {
            BoxedUnit boxedUnit3;
            boolean created = tempDirectory.mkdirs();
            if (created) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Temporary directory '{}' successfully created.", (Object)tempDirectory);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
        }
        catch (Exception ex) {
            BoxedUnit boxedUnit4;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to create temporary directory '{}', error: {}.", new Object[]{tempDirectory, ex.getMessage()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw ex;
        }
        return var3_3;
    }

    public boolean createOrCleanDirectory$default$2() {
        return true;
    }

    public boolean validatePath(String path) {
        BoxedUnit boxedUnit;
        try {
            if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                throw new FileNotFoundException(new StringBuilder(23).append("File '").append(path).append("' does not exist.").toString());
            }
            if (!Files.isReadable(Paths.get(path, new String[0]))) {
                throw new IllegalStateException(new StringBuilder(25).append("File '").append(path).append("' is not readable.'").toString());
            }
        }
        catch (Exception ex) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("File validation failed, error: {}.", (Object)ex.getMessage());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw ex;
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("File '{}' passed all validation checks.", (Object)path);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    public List<File> getMatchingFiles(String path, Regex regex, boolean recurse) {
        List list;
        File file2 = new File(path);
        if (file2.isFile()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Found single file {} matching criteria.", (Object)file2.getPath());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{file2}));
        } else if (file2.isDirectory()) {
            File[] matchingFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.$anonfun$getMatchingFiles$1(regex, file)));
            if (recurse) {
                matchingFiles = (File[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])matchingFiles), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))), (Function1 & Serializable)f -> MODULE$.getMatchingFiles(f.getPath(), regex, recurse), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class));
            }
            list = Predef$.MODULE$.wrapRefArray((Object[])matchingFiles).toList();
        } else {
            throw new IllegalStateException(new StringBuilder(61).append("Failed to retrieve files. ").append(file2).append(" is neither a directory nor a file.").toString());
        }
        return list;
    }

    public boolean deleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (Exception ex) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to unlink the file, error: {}", (Object)ex.getMessage());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw ex;
        }
        return true;
    }

    public Object curlFile(String path, String url) {
        Object object;
        if (!new File(path).exists()) {
            try {
                object = scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(12).append("curl -L -o ").append(path).append(" ").append(url).toString()).$bang$bang();
            }
            catch (Exception ex) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(28).append("Failed to download ").append(path).append(" due to ").append(ex.getMessage()).append(".").toString(), (Throwable)ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Files.deleteIfExists(Paths.get(path, new String[0]));
                throw ex;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$getMatchingFiles$1(Regex regex$1, File file) {
        return file.isFile() && regex$1.findFirstIn((CharSequence)file.getName()).isDefined();
    }

    private FileUtils$() {
    }
}

