/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.pojograph;

import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.MutableBoolean;
import com.raphtory.api.input.MutableDouble;
import com.raphtory.api.input.MutableFloat;
import com.raphtory.api.input.MutableInteger;
import com.raphtory.api.input.MutableLong;
import com.raphtory.api.input.MutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Type;
import com.raphtory.internals.graph.GraphPartition;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.storage.pojograph.PojoGraphLens;
import com.raphtory.internals.storage.pojograph.entities.external.vertex.PojoExVertex;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoEdge;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoEntity;
import com.raphtory.internals.storage.pojograph.entities.internal.PojoVertex;
import com.raphtory.internals.storage.pojograph.entities.internal.SplitEdge;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.collection.parallel.mutable.ParMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055f!B\n\u0015\u0001iq\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\u0011\u0006\u0001)A\u0005\u0017\"91\u000b\u0001b\u0001\n\u0013!\u0006B\u0002-\u0001A\u0003%Q\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\r9\u0004\u0001\u0015!\u0003\\\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002@\u0001!I!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u000b\u0003A\u0011IAD\u0005I\u0001vN[8CCN,G\rU1si&$\u0018n\u001c8\u000b\u0005U1\u0012!\u00039pU><'/\u00199i\u0015\t9\u0002$A\u0004ti>\u0014\u0018mZ3\u000b\u0005eQ\u0012!C5oi\u0016\u0014h.\u00197t\u0015\tYB$\u0001\u0005sCBDGo\u001c:z\u0015\u0005i\u0012aA2p[N\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0003Ea\tQa\u001a:ba\"L!\u0001J\u0011\u0003\u001d\u001d\u0013\u0018\r\u001d5QCJ$\u0018\u000e^5p]\u00069qM]1qQ&#5\u0001\u0001\t\u0003QEr!!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u000512\u0013A\u0002\u001fs_>$hHC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001T&\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019.\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u00027o5\tQ&\u0003\u00029[\t\u0019\u0011J\u001c;\u0002\t\r|gN\u001a\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\naaY8oM&<'BA \u001d\u0003!!\u0018\u0010]3tC\u001a,\u0017BA!=\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"B\u0001\u0012$H\u0011B\u0011Q\tA\u0007\u0002)!)Q\u0005\u0002a\u0001O!)A\u0007\u0002a\u0001k!)\u0011\b\u0002a\u0001u\u0005\u0001\u0002.Y:EK2,G/[8ogB\u000bG\u000f[\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0005Y\u0006twMC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ij\u0015!\u00055bg\u0012+G.\u001a;j_:\u001c\b+\u0019;iA\u0005a\u0001.Y:EK2,G/[8ogV\tQ\u000b\u0005\u00027-&\u0011q+\f\u0002\b\u0005>|G.Z1o\u00035A\u0017m\u001d#fY\u0016$\u0018n\u001c8tA\u0005Aa/\u001a:uS\u000e,7/F\u0001\\!\u0011a\u0016m\u00194\u000e\u0003uS!AX0\u0002\u000f5,H/\u00192mK*\u0011\u0001-L\u0001\u000bG>dG.Z2uS>t\u0017B\u00012^\u0005\ri\u0015\r\u001d\t\u0003m\u0011L!!Z\u0017\u0003\t1{gn\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003WR\t\u0001\"\u001a8uSRLWm]\u0005\u0003[\"\u0014!\u0002U8k_Z+'\u000f^3y\u0003%1XM\u001d;jG\u0016\u001c\b%A\u0007bI\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0006cR4\b0 \t\u0003mIL!a]\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006k.\u0001\raY\u0001\b[N<G+[7f\u0011\u001598\u00021\u0001d\u0003\u0015Ig\u000eZ3y\u0011\u0015I8\u00021\u0001{\u0003\u0019)g\u000e^5usB\u0011qm_\u0005\u0003y\"\u0014!\u0002U8k_\u0016sG/\u001b;z\u0011\u0015q8\u00021\u0001\u0000\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0015Ig\u000e];u\u0015\r\tIAG\u0001\u0004CBL\u0017\u0002BA\u0007\u0003\u0007\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%\tG\r\u001a,feR,\u0007\u0010F\u0007r\u0003'\t9\"!\u0007\u0002\u001c\u0005}\u0011\u0011\u0005\u0005\u0007\u0003+a\u0001\u0019A2\u0002\u0011M|WO]2f\u0013\u0012CQ!\u001e\u0007A\u0002\rDQa\u001e\u0007A\u0002\rDa!!\b\r\u0001\u0004\u0019\u0017!B:sG&#\u0007\"\u0002@\r\u0001\u0004y\bbBA\u0012\u0019\u0001\u0007\u0011QE\u0001\u000bm\u0016\u0014H/\u001a=UsB,\u0007#\u0002\u001c\u0002(\u0005-\u0012bAA\u0015[\t1q\n\u001d;j_:\u0004B!!\u0001\u0002.%!\u0011qFA\u0002\u0005\u0011!\u0016\u0010]3\u0002#\u0005$GMV3si\u0016D\u0018J\u001c;fe:\fG\u000eF\u0006g\u0003k\t9$!\u000f\u0002<\u0005u\u0002\"B;\u000e\u0001\u0004\u0019\u0007\"B<\u000e\u0001\u0004\u0019\u0007BBA\u000f\u001b\u0001\u00071\rC\u0003\u007f\u001b\u0001\u0007q\u0010C\u0004\u0002$5\u0001\r!!\n\u0002-\u001d,GOV3si\u0016DxJ\u001d)mC\u000e,\u0007n\u001c7eKJ$rAZA\"\u0003\u000b\n9\u0005C\u0003v\u001d\u0001\u00071\rC\u0003x\u001d\u0001\u00071\r\u0003\u0004\u0002J9\u0001\raY\u0001\u0003S\u0012\fA\"\u00193e\u0019>\u001c\u0017\r\\#eO\u0016$r\"]A(\u0003#\n\u0019&!\u0016\u0002X\u0005m\u0013Q\f\u0005\u0007\u0003+y\u0001\u0019A2\t\u000bU|\u0001\u0019A2\t\u000b]|\u0001\u0019A2\t\r\u0005uq\u00021\u0001d\u0011\u0019\tIf\u0004a\u0001G\u0006)Am\u001d;JI\")ap\u0004a\u0001\u007f\"9\u0011qL\bA\u0002\u0005\u0015\u0012\u0001C3eO\u0016$\u0016\u0010]3\u0002\u001f\u0005$GmT;uO>LgnZ#eO\u0016$r\"]A3\u0003O\nI'a\u001b\u0002n\u0005=\u0014\u0011\u000f\u0005\u0007\u0003+\u0001\u0002\u0019A2\t\u000bU\u0004\u0002\u0019A2\t\u000b]\u0004\u0002\u0019A2\t\r\u0005u\u0001\u00031\u0001d\u0011\u0019\tI\u0006\u0005a\u0001G\")a\u0010\u0005a\u0001\u007f\"9\u0011q\f\tA\u0002\u0005\u0015\u0012aD1eI&s7m\\7j]\u001e,EmZ3\u0015\u001fE\f9(!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007Ca!!\u0006\u0012\u0001\u0004\u0019\u0007\"B;\u0012\u0001\u0004\u0019\u0007\"B<\u0012\u0001\u0004\u0019\u0007BBA\u000f#\u0001\u00071\r\u0003\u0004\u0002ZE\u0001\ra\u0019\u0005\u0006}F\u0001\ra \u0005\b\u0003?\n\u0002\u0019AA\u0013\u0003-9W\r\u001e,feRL7-Z:\u0015\u0011\u0005%\u00151TAS\u0003S\u0003R\u0001X1d\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0004wKJ$X\r\u001f\u0006\u0004\u0003+S\u0017\u0001C3yi\u0016\u0014h.\u00197\n\t\u0005e\u0015q\u0012\u0002\r!>Tw.\u0012=WKJ$X\r\u001f\u0005\b\u0003;\u0013\u0002\u0019AAP\u0003\u0011aWM\\:\u0011\u0007\u0001\n\t+C\u0002\u0002$\u0006\u0012Q\u0002T3og&sG/\u001a:gC\u000e,\u0007BBAT%\u0001\u00071-A\u0003ti\u0006\u0014H\u000f\u0003\u0004\u0002,J\u0001\raY\u0001\u0004K:$\u0007")
public class PojoBasedPartition
extends GraphPartition {
    private final int partition;
    private final String hasDeletionsPath;
    private final boolean hasDeletions;
    private final Map<Object, PojoVertex> vertices;

    private String hasDeletionsPath() {
        return this.hasDeletionsPath;
    }

    private boolean hasDeletions() {
        return this.hasDeletions;
    }

    private Map<Object, PojoVertex> vertices() {
        return this.vertices;
    }

    public void addProperties(long msgTime, long index, PojoEntity entity, Properties properties) {
        properties.properties().foreach((Function1 & Serializable)x0$1 -> {
            PojoBasedPartition.$anonfun$addProperties$1(entity, msgTime, index, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void addVertex(long sourceID, long msgTime, long index, long srcId, Properties properties, Option<Type> vertexType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            this.addVertexInternal(msgTime, index, srcId, properties, vertexType);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Added vertex {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public PojoVertex addVertexInternal(long msgTime, long index, long srcId, Properties properties, Option<Type> vertexType) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        PojoVertex pojoVertex;
        Option option = this.vertices().get((Object)BoxesRunTime.boxToLong((long)srcId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit3;
            Some some = (Some)option;
            PojoVertex v = (PojoVertex)some.value();
            v.revive(msgTime, index);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("History point added to vertex: {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            pojoVertex = v;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit4;
            PojoVertex v = new PojoVertex(msgTime, index, srcId, true);
            this.vertices().$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)srcId), (Object)v));
            v.setType((Option<String>)vertexType.map((Function1 & Serializable)x$1 -> x$1.name()));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("New vertex created {}", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            pojoVertex = v;
        } else {
            throw new MatchError((Object)option);
        }
        PojoVertex vertex = pojoVertex;
        this.addProperties(msgTime, index, vertex, properties);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Properties added: {}", (Object)properties);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Vertex returned: {}", (Object)BoxesRunTime.boxToLong((long)vertex.vertexId()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return vertex;
    }

    private PojoVertex getVertexOrPlaceholder(long msgTime, long index, long id) {
        PojoVertex pojoVertex;
        Option option = this.vertices().get((Object)BoxesRunTime.boxToLong((long)id));
        if (option instanceof Some) {
            PojoVertex vertex;
            Some some = (Some)option;
            pojoVertex = vertex = (PojoVertex)some.value();
        } else if (None$.MODULE$.equals(option)) {
            PojoVertex vertex = new PojoVertex(msgTime, index, id, true);
            this.vertices().put((Object)BoxesRunTime.boxToLong((long)id), (Object)vertex);
            vertex.wipe();
            pojoVertex = vertex;
        } else {
            throw new MatchError((Object)option);
        }
        return pojoVertex;
    }

    @Override
    public void addLocalEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            PojoVertex srcVertex = this.addVertexInternal(msgTime, index, srcId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Src ID: {} created and revived", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            PojoVertex dstVertex = srcId != dstId ? this.addVertexInternal(msgTime, index, dstId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$) : srcVertex;
            Option<PojoEdge> option = srcVertex.getOutgoingEdge(dstId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Edge {} - {} revived", new Object[]{BoxesRunTime.boxToLong((long)edge.getSrcId()), BoxesRunTime.boxToLong((long)edge.getDstId())});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, edge, properties);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                PojoEdge newEdge = new PojoEdge(msgTime, index, srcId, dstId, true);
                newEdge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$2 -> x$2.name()));
                srcVertex.addOutgoingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Added edge {} to vertex {}", new Object[]{newEdge, srcVertex});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                dstVertex.addIncomingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("added {} to {}", new Object[]{newEdge, dstVertex});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, newEdge, properties);
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    @Override
    public void addOutgoingEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            PojoVertex srcVertex = this.addVertexInternal(msgTime, index, srcId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Src ID: {} created and revived", (Object)BoxesRunTime.boxToLong((long)srcId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<PojoEdge> option = srcVertex.getOutgoingEdge(dstId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                this.addProperties(msgTime, index, edge, properties);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Edge {} - {} revived", new Object[]{BoxesRunTime.boxToLong((long)edge.getSrcId()), BoxesRunTime.boxToLong((long)edge.getDstId())});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit4;
                BoxedUnit boxedUnit5;
                SplitEdge newEdge = new SplitEdge(msgTime, index, srcId, dstId, true);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Split edge {} - {} between partitions created", new Object[]{BoxesRunTime.boxToLong((long)srcId), BoxesRunTime.boxToLong((long)dstId)});
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                newEdge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$3 -> x$3.name()));
                srcVertex.addOutgoingEdge(newEdge);
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("Added edge {} to vertex {}", new Object[]{newEdge, srcVertex});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                this.addProperties(msgTime, index, newEdge, properties);
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    @Override
    public void addIncomingEdge(long sourceID, long msgTime, long index, long srcId, long dstId, Properties properties, Option<Type> edgeType) {
        Map<Object, PojoVertex> map = this.vertices();
        synchronized (map) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            PojoEdge pojoEdge;
            BoxedUnit boxedUnit3;
            PojoVertex dstVertex = this.addVertexInternal(msgTime, index, dstId, new Properties((Seq<Property>)Nil$.MODULE$), (Option<Type>)None$.MODULE$);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("created and revived destination vertex: {}", (Object)BoxesRunTime.boxToLong((long)dstId));
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            Option<PojoEdge> option = dstVertex.getIncomingEdge(srcId);
            if (option instanceof Some) {
                BoxedUnit boxedUnit4;
                Some some = (Some)option;
                PojoEdge edge = (PojoEdge)some.value();
                edge.revive(msgTime, index);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Edge {} {} already existed in partition {} for syncNewEdgeAdd", new Object[]{BoxesRunTime.boxToLong((long)srcId), BoxesRunTime.boxToLong((long)dstId), BoxesRunTime.boxToInteger((int)this.partition)});
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                pojoEdge = edge;
            } else if (None$.MODULE$.equals(option)) {
                SplitEdge e = new SplitEdge(msgTime, index, srcId, dstId, true);
                dstVertex.addIncomingEdge(e);
                pojoEdge = e;
            } else {
                throw new MatchError(option);
            }
            PojoEdge edge = pojoEdge;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("added {} to {}", new Object[]{edge, dstVertex});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.addProperties(msgTime, index, edge, properties);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Added properties {}", (Object)properties);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            edge.setType((Option<String>)edgeType.map((Function1 & Serializable)x$4 -> x$4.name()));
        }
    }

    @Override
    public Map<Object, PojoExVertex> getVertices(LensInterface lens, long start, long end) {
        Map map;
        Map<Object, PojoVertex> map2 = this.vertices();
        synchronized (map2) {
            PojoGraphLens lenz = (PojoGraphLens)lens;
            map = ((ParMap)CollectionConverters.MutableMapIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.MutableMapIsParallelizable(this.vertices())).collect((PartialFunction)new Serializable(null, start, end, lenz){
                private static final long serialVersionUID = 0L;
                private final long start$1;
                private final long end$1;
                private final PojoGraphLens lenz$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Object, PojoVertex>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        long id = A1._1$mcJ$sp();
                        PojoVertex vertex = (PojoVertex)A1._2();
                        if (vertex.aliveBetween(this.start$1, this.end$1)) {
                            object = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)vertex.viewBetween(this.start$1, this.end$1, this.lenz$1));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Object, PojoVertex> x1) {
                    PojoVertex vertex;
                    Tuple2<Object, PojoVertex> tuple2 = x1;
                    boolean bl = tuple2 != null && (vertex = (PojoVertex)tuple2._2()).aliveBetween(this.start$1, this.end$1);
                    return bl;
                }
                {
                    this.start$1 = start$1;
                    this.end$1 = end$1;
                    this.lenz$1 = lenz$1;
                }
            })).seq();
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$addProperties$1(PojoEntity entity$1, long msgTime$1, long index$1, Property x0$1) {
        Property property = x0$1;
        if (property instanceof MutableString) {
            MutableString mutableString = (MutableString)property;
            String key = mutableString.key();
            String value = mutableString.value();
            entity$1.$plus(msgTime$1, index$1, false, key, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableLong) {
            MutableLong mutableLong = (MutableLong)property;
            String key = mutableLong.key();
            long value = mutableLong.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToLong((long)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableDouble) {
            MutableDouble mutableDouble = (MutableDouble)property;
            String key = mutableDouble.key();
            double value = mutableDouble.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToDouble((double)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableFloat) {
            MutableFloat mutableFloat = (MutableFloat)property;
            String key = mutableFloat.key();
            float value = mutableFloat.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToFloat((float)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableBoolean) {
            MutableBoolean mutableBoolean = (MutableBoolean)property;
            String key = mutableBoolean.key();
            boolean value = mutableBoolean.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToBoolean((boolean)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof MutableInteger) {
            MutableInteger mutableInteger = (MutableInteger)property;
            String key = mutableInteger.key();
            int value = mutableInteger.value();
            entity$1.$plus(msgTime$1, index$1, false, key, BoxesRunTime.boxToInteger((int)value));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (property instanceof ImmutableString) {
            ImmutableString immutableString = (ImmutableString)property;
            String key = immutableString.key();
            String value = immutableString.value();
            entity$1.$plus(msgTime$1, index$1, true, key, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)property);
        }
    }

    public PojoBasedPartition(String graphID, int partition, Config conf) {
        BoxedUnit boxedUnit;
        this.partition = partition;
        super(graphID, partition, conf);
        this.hasDeletionsPath = "raphtory.data.containsDeletions";
        this.hasDeletions = conf.getBoolean(this.hasDeletionsPath());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(0).append("Config indicates that the data contains 'delete' events. ").append(new StringBuilder(49).append("To change this modify '").append(this.hasDeletionsPath()).append("' in the application conf.").toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.vertices = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

