/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.graph;

import cats.Functor;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.graph.UnsafeGraphCallback$;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** This class implements Graph interface by putting updates into a provided array buffer\n  * so we can get updates out of it to be sent to the partitions\n  */")
@ScalaSignature(bytes="\u0006\u0005\t\re\u0001\u0002\u0013&\u0001:B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B,\t\u0011m\u0003!Q3A\u0005\u0002qC\u0001\"\u001a\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\tM\u0002\u0011)\u001a!C\u0001O\"Aq\u0010\u0001B\tB\u0003%\u0001\u000e\u0003\u0006\u0002\u0002\u0001\u0011\u0019\u0011)A\u0006\u0003\u0007Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002B\u0001!\t&a\u0011\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA8\u0001E\u0005I\u0011AA9\u0011%\ty\tAI\u0001\n\u0003\t\t\nC\u0005\u0002\u001a\u0002\t\n\u0011\"\u0001\u0002\u001c\"I\u0011q\u0015\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003oC\u0011\"a1\u0001\u0003\u0003%\t%!2\t\u0011\u0005U\u0007!!A\u0005\u00029C\u0011\"a6\u0001\u0003\u0003%\t!!7\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\b\"CAv\u0001\u0005\u0005I\u0011AAw\u0011%\t9\u0010AA\u0001\n\u0003\nI\u0010C\u0005\u0002~\u0002\t\t\u0011\"\u0011\u0002\u0000\"I!\u0011\u0001\u0001\u0002\u0002\u0013\u0005#1\u0001\u0005\n\u0005\u000b\u0001\u0011\u0011!C!\u0005\u000f9\u0011Ba\n&\u0003\u0003E\tA!\u000b\u0007\u0011\u0011*\u0013\u0011!E\u0001\u0005WAq!a\u000b\u001f\t\u0003\u00119\u0004C\u0005\u0003\u0002y\t\t\u0011\"\u0012\u0003\u0004!I!\u0011\b\u0010\u0002\u0002\u0013\u0005%1\b\u0005\n\u00053r\u0012\u0011!CA\u00057B\u0011B!\u001f\u001f\u0003\u0003%IAa\u001f\u0003'Us7/\u00194f\u000fJ\f\u0007\u000f[\"bY2\u0014\u0017mY6\u000b\u0005\u0019:\u0013!B4sCBD'B\u0001\u0015*\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002+W\u0005A!/\u00199ii>\u0014\u0018PC\u0001-\u0003\r\u0019w.\\\u0002\u0001+\ry\u00131C\n\u0006\u0001A2d(\u0011\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014!B5oaV$(BA\u001e*\u0003\r\t\u0007/[\u0005\u0003{a\u0012Qa\u0012:ba\"\u0004\"!M \n\u0005\u0001\u0013$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005*s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019k\u0013A\u0002\u001fs_>$h(C\u00014\u0013\tI%'A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'BA%3\u0003=!x\u000e^1m!\u0006\u0014H/\u001b;j_:\u001cX#A(\u0011\u0005E\u0002\u0016BA)3\u0005\rIe\u000e^\u0001\u0011i>$\u0018\r\u001c)beRLG/[8og\u0002\n\u0001b]8ve\u000e,\u0017\nR\u0001\ng>,(oY3J\t\u0002\nQ!\u001b8eKb,\u0012a\u0016\t\u0003caK!!\u0017\u001a\u0003\t1{gnZ\u0001\u0007S:$W\r\u001f\u0011\u0002\u000f\u001d\u0014\u0018\r\u001d5J\tV\tQ\f\u0005\u0002_E:\u0011q\f\u0019\t\u0003\tJJ!!\u0019\u001a\u0002\rA\u0013X\rZ3g\u0013\t\u0019GM\u0001\u0004TiJLgn\u001a\u0006\u0003CJ\n\u0001b\u001a:ba\"LE\tI\u0001\u0002EV\t\u0001\u000eE\u0002j]Bl\u0011A\u001b\u0006\u0003W2\fq!\\;uC\ndWM\u0003\u0002ne\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=T'aC!se\u0006L()\u001e4gKJ\u0004\"!\u001d?\u000f\u0005IThBA:z\u001d\t!\bP\u0004\u0002vo:\u0011AI^\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005m,\u0013aD$sCBD\u0017\t\u001c;fe\u0006$\u0018n\u001c8\n\u0005ut(aC$sCBDW\u000b\u001d3bi\u0016T!a_\u0013\u0002\u0005\t\u0004\u0013AC3wS\u0012,gnY3%cA1\u0011QAA\u0006\u0003\u001fi!!a\u0002\u000b\u0005\u0005%\u0011\u0001B2biNLA!!\u0004\u0002\b\t9a)\u001e8di>\u0014\b\u0003BA\t\u0003'a\u0001\u0001B\u0004\u0002\u0016\u0001\u0011\r!a\u0006\u0003\u0003\u0019+B!!\u0007\u0002(E!\u00111DA\u0011!\r\t\u0014QD\u0005\u0004\u0003?\u0011$a\u0002(pi\"Lgn\u001a\t\u0004c\u0005\r\u0012bAA\u0013e\t\u0019\u0011I\\=\u0005\u0011\u0005%\u00121\u0003b\u0001\u00033\u0011Aa\u0018\u0013%e\u00051A(\u001b8jiz\"B\"a\f\u00028\u0005e\u00121HA\u001f\u0003\u007f!B!!\r\u00026A)\u00111\u0007\u0001\u0002\u00105\tQ\u0005C\u0004\u0002\u00021\u0001\u001d!a\u0001\t\u000b5c\u0001\u0019A(\t\u000bMc\u0001\u0019A(\t\u000bUc\u0001\u0019A,\t\u000bmc\u0001\u0019A/\t\u000b\u0019d\u0001\u0019\u00015\u0002#!\fg\u000e\u001a7f\u000fJ\f\u0007\u000f[+qI\u0006$X\r\u0006\u0003\u0002F\u0005-\u0003cA\u0019\u0002H%\u0019\u0011\u0011\n\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001bj\u0001\u0019\u00019\u0002\rU\u0004H-\u0019;f\u0003\u0011\u0019w\u000e]=\u0016\t\u0005M\u00131\f\u000b\r\u0003+\n)'a\u001a\u0002j\u0005-\u0014Q\u000e\u000b\u0005\u0003/\n\t\u0007E\u0003\u00024\u0001\tI\u0006\u0005\u0003\u0002\u0012\u0005mCaBA\u000b\u001d\t\u0007\u0011QL\u000b\u0005\u00033\ty\u0006\u0002\u0005\u0002*\u0005m#\u0019AA\r\u0011\u001d\t\tA\u0004a\u0002\u0003G\u0002b!!\u0002\u0002\f\u0005e\u0003bB'\u000f!\u0003\u0005\ra\u0014\u0005\b':\u0001\n\u00111\u0001P\u0011\u001d)f\u0002%AA\u0002]Cqa\u0017\b\u0011\u0002\u0003\u0007Q\fC\u0004g\u001dA\u0005\t\u0019\u00015\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u00111OAE+\t\t)HK\u0002P\u0003oZ#!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\u0013\u0014AC1o]>$\u0018\r^5p]&!\u0011qQA?\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0003+y!\u0019AAF+\u0011\tI\"!$\u0005\u0011\u0005%\u0012\u0011\u0012b\u0001\u00033\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0002t\u0005MEaBA\u000b!\t\u0007\u0011QS\u000b\u0005\u00033\t9\n\u0002\u0005\u0002*\u0005M%\u0019AA\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*B!!(\u0002\"V\u0011\u0011q\u0014\u0016\u0004/\u0006]DaBA\u000b#\t\u0007\u00111U\u000b\u0005\u00033\t)\u000b\u0002\u0005\u0002*\u0005\u0005&\u0019AA\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*B!a+\u00020V\u0011\u0011Q\u0016\u0016\u0004;\u0006]DaBA\u000b%\t\u0007\u0011\u0011W\u000b\u0005\u00033\t\u0019\f\u0002\u0005\u0002*\u0005=&\u0019AA\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*B!!/\u0002>V\u0011\u00111\u0018\u0016\u0004Q\u0006]DaBA\u000b'\t\u0007\u0011qX\u000b\u0005\u00033\t\t\r\u0002\u0005\u0002*\u0005u&\u0019AA\r\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0019\t\u0005\u0003\u0013\f\u0019.\u0004\u0002\u0002L*!\u0011QZAh\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0017\u0001\u00026bm\u0006L1aYAf\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\t\u0002\\\"A\u0011Q\u001c\f\u0002\u0002\u0003\u0007q*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0004b!!:\u0002h\u0006\u0005R\"\u00017\n\u0007\u0005%HN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0003k\u00042!MAy\u0013\r\t\u0019P\r\u0002\b\u0005>|G.Z1o\u0011%\ti\u000eGA\u0001\u0002\u0004\t\t#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAd\u0003wD\u0001\"!8\u001a\u0003\u0003\u0005\raT\u0001\tQ\u0006\u001c\bnQ8eKR\tq*\u0001\u0005u_N#(/\u001b8h)\t\t9-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003_\u0014I\u0001C\u0005\u0002^r\t\t\u00111\u0001\u0002\"!:\u0001A!\u0004\u0003\"\t\r\u0002\u0003\u0002B\b\u0005;i!A!\u0005\u000b\t\tM!QC\u0001\tg\u000e\fG.\u00193pG*!!q\u0003B\r\u0003\u001d!\u0018m[3{_\u0016T1Aa\u0007,\u0003\u00199\u0017\u000e\u001e5vE&!!q\u0004B\t\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017E\u0001B\u0013\u0003\u0005}rF\u000b\u0016!)\"L7\u000fI2mCN\u001c\b%[7qY\u0016lWM\u001c;tA\u001d\u0013\u0018\r\u001d5!S:$XM\u001d4bG\u0016\u0004#-\u001f\u0011qkR$\u0018N\\4!kB$\u0017\r^3tA%tGo\u001c\u0011bAA\u0014xN^5eK\u0012\u0004\u0013M\u001d:bs\u0002\u0012WO\u001a4fe*\u0001\u0003E\u000b\u0011t_\u0002:X\rI2b]\u0002:W\r\u001e\u0011va\u0012\fG/Z:!_V$\be\u001c4!SR\u0004Co\u001c\u0011cK\u0002\u001aXM\u001c;!i>\u0004C\u000f[3!a\u0006\u0014H/\u001b;j_:\u001c(\u0002\t\u0011+_\u0005\u0019RK\\:bM\u0016<%/\u00199i\u0007\u0006dGNY1dWB\u0019\u00111\u0007\u0010\u0014\ty\u0001$Q\u0006\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)!!1GAh\u0003\tIw.C\u0002L\u0005c!\"A!\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\tu\"Q\t\u000b\r\u0005\u007f\u0011yE!\u0015\u0003T\tU#q\u000b\u000b\u0005\u0005\u0003\u0012Y\u0005E\u0003\u00024\u0001\u0011\u0019\u0005\u0005\u0003\u0002\u0012\t\u0015CaBA\u000bC\t\u0007!qI\u000b\u0005\u00033\u0011I\u0005\u0002\u0005\u0002*\t\u0015#\u0019AA\r\u0011\u001d\t\t!\ta\u0002\u0005\u001b\u0002b!!\u0002\u0002\f\t\r\u0003\"B'\"\u0001\u0004y\u0005\"B*\"\u0001\u0004y\u0005\"B+\"\u0001\u00049\u0006\"B.\"\u0001\u0004i\u0006\"\u00024\"\u0001\u0004A\u0017aB;oCB\u0004H._\u000b\u0005\u0005;\u0012\u0019\b\u0006\u0003\u0003`\t-\u0004#B\u0019\u0003b\t\u0015\u0014b\u0001B2e\t1q\n\u001d;j_:\u0004\u0002\"\rB4\u001f>;V\f[\u0005\u0004\u0005S\u0012$A\u0002+va2,W\u0007C\u0005\u0003n\t\n\t\u00111\u0001\u0003p\u0005\u0019\u0001\u0010\n\u0019\u0011\u000b\u0005M\u0002A!\u001d\u0011\t\u0005E!1\u000f\u0003\b\u0003+\u0011#\u0019\u0001B;+\u0011\tIBa\u001e\u0005\u0011\u0005%\"1\u000fb\u0001\u00033\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A! \u0011\t\u0005%'qP\u0005\u0005\u0005\u0003\u000bYM\u0001\u0004PE*,7\r\u001e")
public class UnsafeGraphCallback<F>
implements Graph,
Product,
Serializable {
    private final int totalPartitions;
    private final int sourceID;
    private final long index;
    private final String graphID;
    private final ArrayBuffer<GraphAlteration.GraphUpdate> b;

    public static <F> Option<Tuple5<Object, Object, Object, String, ArrayBuffer<GraphAlteration.GraphUpdate>>> unapply(UnsafeGraphCallback<F> x$0) {
        return UnsafeGraphCallback$.MODULE$.unapply(x$0);
    }

    public static <F> UnsafeGraphCallback<F> apply(int totalPartitions, int sourceID, long index, String graphID, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        return UnsafeGraphCallback$.MODULE$.apply(totalPartitions, sourceID, index, graphID, b, evidence$1);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        Graph.addVertex$(this, updateTime, srcId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        Graph.addVertex$(this, updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        Graph.addEdge$(this, updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        Graph.addEdge$(this, updateTime, srcId, dstId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    public long assignID(String uniqueChars) {
        return Graph.assignID$(this, uniqueChars);
    }

    @Override
    public int getPartitionForId(long id) {
        return Graph.getPartitionForId$(this, id);
    }

    @Override
    public Properties addVertex$default$3() {
        return Graph.addVertex$default$3$(this);
    }

    @Override
    public MaybeType addVertex$default$4() {
        return Graph.addVertex$default$4$(this);
    }

    @Override
    public long addVertex$default$5() {
        return Graph.addVertex$default$5$(this);
    }

    @Override
    public Properties addEdge$default$4() {
        return Graph.addEdge$default$4$(this);
    }

    @Override
    public MaybeType addEdge$default$5() {
        return Graph.addEdge$default$5$(this);
    }

    @Override
    public long addEdge$default$6() {
        return Graph.addEdge$default$6$(this);
    }

    @Override
    public int totalPartitions() {
        return this.totalPartitions;
    }

    @Override
    public int sourceID() {
        return this.sourceID;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public String graphID() {
        return this.graphID;
    }

    public ArrayBuffer<GraphAlteration.GraphUpdate> b() {
        return this.b;
    }

    @Override
    public void handleGraphUpdate(GraphAlteration.GraphUpdate update) {
        this.b().$plus$eq((Object)update);
    }

    public <F> UnsafeGraphCallback<F> copy(int totalPartitions, int sourceID, long index, String graphID, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        return new UnsafeGraphCallback<F>(totalPartitions, sourceID, index, graphID, b, evidence$1);
    }

    public <F> int copy$default$1() {
        return this.totalPartitions();
    }

    public <F> int copy$default$2() {
        return this.sourceID();
    }

    public <F> long copy$default$3() {
        return this.index();
    }

    public <F> String copy$default$4() {
        return this.graphID();
    }

    public <F> ArrayBuffer<GraphAlteration.GraphUpdate> copy$default$5() {
        return this.b();
    }

    public String productPrefix() {
        return "UnsafeGraphCallback";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.totalPartitions());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.sourceID());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.index());
                break;
            }
            case 3: {
                object = this.graphID();
                break;
            }
            case 4: {
                object = this.b();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnsafeGraphCallback;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "totalPartitions";
                break;
            }
            case 1: {
                string = "sourceID";
                break;
            }
            case 2: {
                string = "index";
                break;
            }
            case 3: {
                string = "graphID";
                break;
            }
            case 4: {
                string = "b";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.totalPartitions());
        n = Statics.mix((int)n, (int)this.sourceID());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.index()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.graphID()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.b()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnsafeGraphCallback)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnsafeGraphCallback unsafeGraphCallback = (UnsafeGraphCallback)x$1;
        if (this.totalPartitions() != unsafeGraphCallback.totalPartitions()) return false;
        if (this.sourceID() != unsafeGraphCallback.sourceID()) return false;
        if (this.index() != unsafeGraphCallback.index()) return false;
        String string = this.graphID();
        String string2 = unsafeGraphCallback.graphID();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ArrayBuffer<GraphAlteration.GraphUpdate> arrayBuffer = this.b();
        ArrayBuffer<GraphAlteration.GraphUpdate> arrayBuffer2 = unsafeGraphCallback.b();
        if (arrayBuffer == null) {
            if (arrayBuffer2 != null) {
                return false;
            }
        } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
        if (!unsafeGraphCallback.canEqual(this)) return false;
        return true;
    }

    public UnsafeGraphCallback(int totalPartitions, int sourceID, long index, String graphID, ArrayBuffer<GraphAlteration.GraphUpdate> b, Functor<F> evidence$1) {
        this.totalPartitions = totalPartitions;
        this.sourceID = sourceID;
        this.index = index;
        this.graphID = graphID;
        this.b = b;
        Graph.$init$(this);
        Product.$init$((Product)this);
    }
}

