/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.output.sink;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.time.Perspective;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import org.slf4j.LoggerFactory;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for sink executors.\n  *\n  * Concrete implementations need to override the `setupPerspective`, `writeRow`, `closePerspective`, and `close`\n  * methods.\n  *\n  *  @see [[com.raphtory.api.analysis.table.Row Row]], [[com.raphtory.api.time.Perspective Perspective]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00154q\u0001C\u0005\u0011\u0002\u0007\u0005A\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0019\u0005\u0011\u0005C\u00039\u0001\u0019E\u0011\bC\u0003H\u0001\u0019\u0005A\u0004C\u0003L\u0001\u0019\u0005A\u0004C\u0003P\u0001\u0011\u0005\u0001\u000b\u0003\u0005V\u0001!\u0015\r\u0011\"\u0005W\u00051\u0019\u0016N\\6Fq\u0016\u001cW\u000f^8s\u0015\tQ1\"\u0001\u0003tS:\\'B\u0001\u0007\u000e\u0003\u0019yW\u000f\u001e9vi*\u0011abD\u0001\u0004CBL'B\u0001\t\u0012\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002;A\u0011aCH\u0005\u0003?]\u0011A!\u00168ji\u0006\u00012/\u001a;vaB+'o\u001d9fGRLg/\u001a\u000b\u0003;\tBQa\t\u0002A\u0002\u0011\n1\u0002]3sgB,7\r^5wKB\u0011Q\u0005K\u0007\u0002M)\u0011q%D\u0001\u0005i&lW-\u0003\u0002*M\tY\u0001+\u001a:ta\u0016\u001cG/\u001b<fQ\u0011\u00111&\u000e\u001c\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013\u0001C:dC2\fGm\\2\u000b\u0005A\n\u0014a\u0002;bW\u0016Tx.\u001a\u0006\u0003eE\taaZ5uQV\u0014\u0017B\u0001\u001b.\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A\u001c\u0002\u0005\u000by#F\u000b\u0011TKR\u001c\b%\u001e9!i\",\u0007\u0005]3sgB,7\r^5wK\u0002\"x\u000e\t2fA]\u0014\u0018\u000e\u001e;f]\u0002zW\u000f\u001e\u0018\u000bA\u0001\u0002\u0003E\u000b\u0011UQ&\u001c\b%\\3uQ>$\u0007eZ3ug\u0002\u001a\u0017\r\u001c7fI\u0002*g/\u001a:zAQLW.\u001a\u0011bA9,w\u000fI4sCBD\u0007\u0005]3sgB,7\r^5wK\u0002J7\u000fI4pS:<\u0007\u0005^8!E\u0016\u0004sO]5ui\u0016t\u0007e\\;uAM|\u0007\u0005\u001e5jg\u0002\u00027+\u001b8l\u000bb,7-\u001e;pe\u0002\u00043-\u00198\u000bA\u0001\u0002\u0003E\u000b\u0011iC:$G.\u001a\u0011ji\u0002Jg\r\t8fK\u0012,GM\f\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t9feN\u0004Xm\u0019;jm\u0016\u0004C\u000f[3!a\u0016\u00148\u000f]3di&4X\r\t;pA\t,\u0007e\u001e:jiR,g\u000eI8vi*\u0001\u0003\u0005\t\u0011+_\u0005AqO]5uKJ{w\u000f\u0006\u0002\u001eu!)1h\u0001a\u0001y\u0005\u0019!o\\<\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015!\u0002;bE2,'BA!\u000e\u0003!\tg.\u00197zg&\u001c\u0018BA\"?\u0005\r\u0011vn\u001e\u0015\u0005\u0007-*T)I\u0001G\u0003\u0005mvF\u000b\u0016!/JLG/Z:!_V$\be\u001c8fAI|wO\f\u0006!A\u0001\u0002#\u0006\t+iK\u0002JW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004sN\u001a\u0011uQ&\u001c\b%\\3uQ>$\u0007\u0005Z8fg:<C\u000f\t8fK\u0012\u0004Co\u001c\u0011cK\u0002\"\bN]3bI6\u001a\u0018MZ3!CN\u0004\u0013\u000e\u001e\u0011jg\u0002:(/\u00199qK\u0012\u0004#-\u001f\u0011ai\"\u0014X-\u00193TC\u001a,wK]5uKJ{w\u000f\u0019\u0011u_*\u0001\u0003\u0005\t\u0011+A!\fg\u000e\u001a7fAMLhn\u00195s_:L'0\u0019;j_:t#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004#o\\<!i\",\u0007E]8xA=4\u0007\u0005Z1uC\u0002\"x\u000eI<sSR,\u0007e\\;u\u0015\u0001\u0002\u0003\u0005\t\u00160\u0003A\u0019Gn\\:f!\u0016\u00148\u000f]3di&4X\r\u000b\u0003\u0005WUJ\u0015%\u0001&\u0002\u0003'|#F\u000b\u0011DY>\u001cXm\u001d\u0011uQ\u0016\u0004sO]5uS:<\u0007e\u001c4!i\",\u0007eY;se\u0016tG\u000fI4sCBD\u0007\u0005]3sgB,7\r^5wK:R\u0001\u0005\t\u0011!U\u0001\"\u0006.[:![\u0016$\bn\u001c3!O\u0016$8\u000fI2bY2,G\rI3wKJL\b\u0005^5nK\u0002\nG\u000e\u001c\u0011uQ\u0016\u0004#o\\<tA\u0019\u0014x.\u001c\u0011p]\u0016\u0004sM]1qQ\u0002\u0002XM]:qK\u000e$\u0018N^3!Q\u00064X\r\t2fK:\u00043/^2dKN\u001ch-\u001e7ms\u0002:(/\u001b;uK:\u0004s.\u001e;!g>T\u0001\u0005\t\u0011!U\u0001\"\b.[:!ANKgn[#yK\u000e,Ho\u001c:aA\r\fg\u000e\t5b]\u0012dW\rI5uA%4\u0007E\\3fI\u0016$gF\u0003\u0011!A\u0001Rs&A\u0003dY>\u001cX\r\u000b\u0003\u0006WUj\u0015%\u0001(\u0002\u0003#y#F\u000b\u0011DY>\u001cXm\u001d\u0011uQ&\u001c\b\u0005Y*j].,\u00050Z2vi>\u0014\b\rI1gi\u0016\u0014\be\u001e:ji&tw\r\t;iK\u0002\u001aw.\u001c9mKR,\u0007\u0005^1cY\u0016t#\u0002\t\u0011!A)R\u0001\u0005\t\u0011!U\u0001\"\u0006.[:![\u0016$\bn\u001c3!g\"|W\u000f\u001c3!MJ,W\rI;qA\u0005dG\u000e\t;iK\u0002\u0012Xm]8ve\u000e,7\u000fI5oAU\u001cXM\f\u0006!A\u0001\u0002#fL\u0001\u0013i\"\u0014X-\u00193TC\u001a,wK]5uKJ{w\u000f\u0006\u0002\u001e#\")1H\u0002a\u0001y!\"aaK\u001bTC\u0005!\u0016!a\u00170U)\u0002C\u000b\u001b:fC\u0012\u00043/\u00194fAY,'o]5p]\u0002zg\r\t1xe&$XMU8xA\u0002*8/\u001a3!S:$XM\u001d8bY2L\bEY=!%\u0006\u0004\b\u000e^8ss\u0002\"x\u000eI<sSR,\u0007%\u0019\u0011ae><\bM\f\u0006!A\u0001\u0002#\u0006I(wKJ\u0014\u0018\u000eZ3!i\"L7\u000fI7fi\"|G\r\t;pAA\u0014xN^5eK\u0002\n\u0007%\\8sK\u0002*gMZ5dS\u0016tG\u000f\t;ie\u0016\fG-L:bM\u0016\u0004\u0013.\u001c9mK6,g\u000e^1uS>tgF\u0003\u0011!A\u0001Rs&\u0001\u0004m_\u001e<WM]\u000b\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00039F\t\u0001\u0002^=qKN\fg-Z\u0005\u0003=f\u0013a\u0001T8hO\u0016\u0014\b\u0006B\u0004,k\u0001\f\u0013!Y\u00012_)R\u0003\u0005T8hO\u0016\u0014\b%\u001b8ti\u0006t7-\u001a\u0011g_J\u0004sO]5uS:<\u0007\u0005Z3ck\u001e\u0004S.Z:tC\u001e,7\u000f\t\u00160Q\u0011\u00011&N2\"\u0003\u0011\f!qF\u0018+U\u0001\u0012\u0015m]3!iJ\f\u0017\u000e\u001e\u0011g_J\u00043/\u001b8lA\u0015DXmY;u_J\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011D_:\u001c'/\u001a;fA%l\u0007\u000f\\3nK:$\u0018\r^5p]N\u0004c.Z3eAQ|\u0007e\u001c<feJLG-\u001a\u0011uQ\u0016\u0004\u0003m]3ukB\u0004VM]:qK\u000e$\u0018N^3aY\u0001\u0002wO]5uKJ{w\u000f\u0019\u0017!A\u000edwn]3QKJ\u001c\b/Z2uSZ,\u0007\r\f\u0011b]\u0012\u0004\u0003m\u00197pg\u0016\u0004'\u0002\t\u0011+A5,G\u000f[8eg:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t!tK\u0016\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]\u0005t\u0017\r\\=tSNtC/\u00192mK:\u0012vn\u001e\u0011S_^lV\f\f\u0011\\7\u000e|WN\f:ba\"$xN]=/CBLg\u0006^5nK:\u0002VM]:qK\u000e$\u0018N^3!!\u0016\u00148\u000f]3di&4X-X/\u000bA\u0001Rs\u0006")
public interface SinkExecutor {
    public static /* synthetic */ Logger logger$(SinkExecutor $this) {
        return $this.logger();
    }

    default public Logger logger() {
        return Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
    }

    @Scaladoc(value="/** Sets up the perspective to be written out.\n    * This method gets called every time a new graph perspective is going to be written out so this `SinkExecutor` can\n    * handle it if needed.\n    * @param perspective the perspective to be written out\n    */")
    public void setupPerspective(Perspective var1);

    @Scaladoc(value="/** Writes out one row.\n    * The implementation of this method doesn't need to be thread-safe as it is wrapped by `threadSafeWriteRow` to\n    * handle synchronization.\n    * @param row the row of data to write out\n    */")
    public void writeRow(Row var1);

    @Scaladoc(value="/** Closes the writing of the current graph perspective.\n    * This method gets called every time all the rows from one graph perspective have been successfully written out so\n    * this `SinkExecutor` can handle it if needed.\n    */")
    public void closePerspective();

    @Scaladoc(value="/** Closes this `SinkExecutor` after writing the complete table.\n    *\n    * This method should free up all the resources in use.\n    */")
    public void close();

    public static /* synthetic */ void threadSafeWriteRow$(SinkExecutor $this, Row row) {
        $this.threadSafeWriteRow(row);
    }

    @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
    default public void threadSafeWriteRow(Row row) {
        SinkExecutor sinkExecutor = this;
        synchronized (sinkExecutor) {
            this.writeRow(row);
        }
    }

    public static void $init$(SinkExecutor $this) {
    }
}

