/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.algorithm;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.MultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base class for writing graph algorithms that return reduced views.\n  *\n  * A `GenericReduction` maps any graph view to a reduced graph view. For reduction algorithms that require the\n  * input graph to be multilayer use [[MultilayerReduction]] instead.\n  *\n  * @define chainBody The new algorithm's `apply` method first applies this algorithm and then the `other`,\n  *                   clearing all messages in-between. The `tabularise` method of the chained algorithm calls only\n  *                   the `tabularise` method of `other`.\n  */")
@ScalaSignature(bytes="\u0006\u0005}3qa\u0002\u0005\u0011\u0002\u0007\u00051\u0003C\u0003\u001f\u0001\u0011\u0005q$\u0002\u0003$\u0001\u0001\"\u0003\"\u0002\u0016\u0001\t\u0003Y\u0003\"\u0002#\u0001\t\u0003)\u0005\"\u0002#\u0001\t\u0003y\u0005\"\u0002#\u0001\t\u0003!&\u0001E$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o\u0015\tI!\"A\u0005bY\u001e|'/\u001b;i[*\u00111\u0002D\u0001\tC:\fG._:jg*\u0011QBD\u0001\u0004CBL'BA\b\u0011\u0003!\u0011\u0018\r\u001d5u_JL(\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VM\u001a\t\u00037qi\u0011\u0001C\u0005\u0003;!\u0011QcR3oKJL7-\u00197ms\u0006\u0003\b\u000f\\5dC\ndW-\u0001\u0004%S:LG\u000f\n\u000b\u0002AA\u0011Q#I\u0005\u0003EY\u0011A!\u00168ji\n\u0019q*\u001e;\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dR\u0011!C4sCBDg/[3x\u0013\tIcEA\fSK\u0012,8-\u001a3He\u0006\u0004\b\u000eU3sgB,7\r^5wK\u0006)\u0011\r\u001d9msR\u0011Af\f\t\u0003[Qr!AL\u0018\r\u0001!)\u0001g\u0001a\u0001c\u0005)qM]1qQB\u0011QEM\u0005\u0003g\u0019\u0012\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005U\u0012$\u0001\u0004*fIV\u001cW\rZ$sCBD\u0007\u0006B\u00028\u0003\n\u0003\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!\u0001P\u001f\u0002\u000fQ\f7.\u001a>pK*\u0011a\bE\u0001\u0007O&$\b.\u001e2\n\u0005\u0001K$\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003\r\u000b\u0011qX\u0018+U\u0001j\u0015-\u001b8!C2<wN]5uQ6T\u0001\u0005\t\u0011!U)\u0001\u0003\u0005\t\u0011+A\u0011+g-Y;mi\u0002JW\u000e\u001d7f[\u0016tG/\u0019;j_:\u00043-\u00197mg\u0002\u0002wM]1qQ:\u0012X\rZ;dK\u00124\u0016.Z<a]\u0001\"\u0006.[:!g\"|W\u000f\u001c3!E\u0016\u0004sN^3se&$G-\u001a8!Ef\u00043/\u001e2dY\u0006\u001c8/Z:!i>\u0004C-\u001a4j]\u0016\u0004C\u000f[3!C\u000e$X/\u00197\u000bA\u0001\u0002\u0003E\u000b\u0011bY\u001e|'/\u001b;i[\u0002\u001aH/\u001a9t])\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!OJ\f\u0007\u000f\u001b\u0011he\u0006\u0004\b\u000e\t;pAI,h\u000e\t4v]\u000e$\u0018n\u001c8!kB|gN\u0003\u0011!A\u0001Rs&\u0001\b%[&tWo\u001d\u0013he\u0016\fG/\u001a:\u0015\u0005\u0019;\u0005CA\u000e\u0001\u0011\u0015AE\u00011\u0001J\u0003\u0015yG\u000f[3s!\tY\"*\u0003\u0002L\u0011\t9q)\u001a8fe&\u001c\u0007\u0006\u0002\u00038\u00036\u000b\u0013AT\u0001\u0002\u0012=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u000f\u0016tWM]5d;v\u0003\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005J2iC&t'i\u001c3z\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!_RDWM\u001d\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b%\u00194uKJ\u0004C\u000f[5tA=tWM\u0003\u0011!A\u0001Rs\u0006\u0006\u0002G!\")\u0001*\u0002a\u0001\r\"\"QaN!SC\u0005\u0019\u0016!a\t0U)\u00023\t[1j]\u0002\"\b.[:!C2<wN]5uQ6\u0004s/\u001b;iA\u0005\u00043lW$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o;v\u0003\u0013\r\\4pe&$\b.\u001c\u0006!A\u0001\u0002#F\u0003\u0011!A\u0001R\u0003\u0005J2iC&t'i\u001c3z\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!_RDWM\u001d\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b%\u00194uKJ\u0004C\u000f[5tA=tWM\u0003\u0011!A\u0001Rs\u0006\u0006\u0002V1B\u00111DV\u0005\u0003/\"\u0011A#T;mi&d\u0017-_3s!J|'.Z2uS>t\u0007\"\u0002%\u0007\u0001\u0004)\u0006\u0006\u0002\u00048\u0003j\u000b\u0013aW\u0001\u0002,=R#\u0006I\"iC&t\u0007\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI<ji\"\u0004\u0013\rI.\\\u001bVdG/\u001b7bs\u0016\u0014\bK]8kK\u000e$\u0018n\u001c8^;\u0002\nGnZ8sSRDWN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002Ce\u00195bS:\u0014u\u000eZ=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011pi\",'\u000fI!mO>\u0014\u0018\u000e\u001e5nAQ|\u0007%\u00199qYf\u0004\u0013M\u001a;fe\u0002\"\b.[:!_:,'\u0002\t\u0011!A)z\u0003\u0006\u0002\u00018\u0003v\u000b\u0013AX\u0001\u0005H=R#\u0006\t\"bg\u0016\u00043\r\\1tg\u00022wN\u001d\u0011xe&$\u0018N\\4!OJ\f\u0007\u000f\u001b\u0011bY\u001e|'/\u001b;i[N\u0004C\u000f[1uAI,G/\u001e:oAI,G-^2fI\u00022\u0018.Z<t])\u0001\u0003E\u000b\u0006!A)\u0002\u0013\t\t1HK:,'/[2SK\u0012,8\r^5p]\u0002\u0004S.\u00199tA\u0005t\u0017\u0010I4sCBD\u0007E^5fo\u0002\"x\u000eI1!e\u0016$WoY3eA\u001d\u0014\u0018\r\u001d5!m&,wO\f\u0011G_J\u0004#/\u001a3vGRLwN\u001c\u0011bY\u001e|'/\u001b;i[N\u0004C\u000f[1uAI,\u0017/^5sK\u0002\"\b.\u001a\u0006!A)\u0002\u0013N\u001c9vi\u0002:'/\u00199iAQ|\u0007EY3![VdG/\u001b7bs\u0016\u0014\b%^:fAm[V*\u001e7uS2\f\u00170\u001a:SK\u0012,8\r^5p]vk\u0006%\u001b8ti\u0016\fGM\f\u0006!A)R\u0001\u0005\t\u0016!\u0001\u0012,g-\u001b8fA\rD\u0017-\u001b8C_\u0012L\b\u0005\u00165fA9,w\u000fI1mO>\u0014\u0018\u000e\u001e5nOM\u0004\u0003-\u00199qYf\u0004\u0007%\\3uQ>$\u0007EZ5sgR\u0004\u0013\r\u001d9mS\u0016\u001c\b\u0005\u001e5jg\u0002\nGnZ8sSRDW\u000eI1oI\u0002\"\b.\u001a8!i\",\u0007\u0005Y8uQ\u0016\u0014\b\r\f\u0006!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!G2,\u0017M]5oO\u0002\nG\u000e\u001c\u0011nKN\u001c\u0018mZ3tA%tWFY3uo\u0016,gN\f\u0011UQ\u0016\u0004\u0003\r^1ck2\f'/[:fA\u0002jW\r\u001e5pI\u0002zg\r\t;iK\u0002\u001a\u0007.Y5oK\u0012\u0004\u0013\r\\4pe&$\b.\u001c\u0011dC2d7\u000fI8oYfT\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e5fA\u0001$\u0018MY;mCJL7/\u001a1![\u0016$\bn\u001c3!_\u001a\u0004\u0003m\u001c;iKJ\u0004gF\u0003\u0011!U=\u0002")
public interface GenericReduction
extends GenericallyApplicable {
    public static /* synthetic */ ConcreteReducedGraphPerspective apply$(GenericReduction $this, GraphPerspective graph) {
        return $this.apply(graph);
    }

    @Override
    @Scaladoc(value="/** Main algorithm\n    *\n    * Default implementation calls `graph.reducedView`. This should be overridden by subclasses to define the actual\n    * algorithm steps.\n    *\n    * @param graph graph to run function upon\n    */")
    default public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return graph.reducedView();
    }

    public static /* synthetic */ GenericReduction $minus$greater$(GenericReduction $this, Generic other) {
        return $this.$minus$greater(other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public GenericReduction $minus$greater(Generic other) {
        return new GenericReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(Generic other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
                return (ConcreteReducedGraphPerspective)((Generic)this.second()).apply(((GenericReduction)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                GenericReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ GenericReduction $minus$greater$(GenericReduction $this, GenericReduction other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public GenericReduction $minus$greater(GenericReduction other) {
        return new GenericReduction(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(Generic other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return GenericReduction.$minus$greater$((GenericReduction)this, other);
            }

            public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
                return ((GenericReduction)this.second()).apply(((GenericReduction)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(ReducedGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                GenericReduction.$init$(this);
            }
        };
    }

    public static /* synthetic */ MultilayerProjection $minus$greater$(GenericReduction $this, MultilayerProjection other) {
        return $this.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    default public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return new MultilayerProjection(this, other){

            @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Generic other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(GenericReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[Multilayer]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(Multilayer other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public MultilayerProjection $minus$greater(MultilayerProjection other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            @Scaladoc(value="/** Chain this algorithm with a [[MultilayerReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
            public GenericReduction $minus$greater(MultilayerReduction other) {
                return MultilayerProjection.$minus$greater$((MultilayerProjection)this, other);
            }

            public ConcreteMultilayerGraphPerspective apply(GraphPerspective graph) {
                return ((MultilayerProjection)this.second()).apply(((GenericReduction)this.first()).apply(graph).clearMessages());
            }

            public Table tabularise(MultilayerGraphPerspective graph) {
                return this.second().tabularise(graph);
            }
            {
                MultilayerProjection.$init$(this);
            }
        };
    }

    public static void $init$(GenericReduction $this) {
    }
}

