/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.motif.GlobalTriangleCount$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`GlobalTriangleCount()`\n  *  : Returns the total number of undirected triangles in the graph.\n  *\n  * ## States\n  *\n  *  {s}`triangles: Int`\n  *    : three times the number of triangles (but returned in output without the factor of three).\n  *\n  * ## Returns\n  *\n  *  | total triangles      |\n  *  | -------------------- |\n  *  | {s}`triangles: Int`  |\n  *\n  * ```{note}\n  *  Edges here are treated as undirected, so if the underlying network is directed here,\n  * 'neighbours' refers to the union of in-neighbours and out-neighbours.\n  * ``\n  */")
@ScalaSignature(bytes="\u0006\u0005e;QAB\u0004\t\u0002I1Q\u0001F\u0004\t\u0002UAQAJ\u0001\u0005\u0002\u001dBQ\u0001K\u0001\u0005B%BQaN\u0001\u0005BaBq\u0001Q\u0001\u0002\u0002\u0013%\u0011)A\nHY>\u0014\u0017\r\u001c+sS\u0006tw\r\\3D_VtGO\u0003\u0002\t\u0013\u0005)Qn\u001c;jM*\u0011!bC\u0001\bO\u0016tWM]5d\u0015\taQ\"\u0001\u0006bY\u001e|'/\u001b;i[NT!AD\b\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011\u0001E\u0001\u0004G>l7\u0001\u0001\t\u0003'\u0005i\u0011a\u0002\u0002\u0014\u000f2|'-\u00197Ue&\fgn\u001a7f\u0007>,h\u000e^\n\u0004\u0003Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003C\t\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003G5\t1!\u00199j\u0013\t)cDA\u0004HK:,'/[2\u0002\rqJg.\u001b;?)\u0005\u0011\u0012!B1qa2LHC\u0001\u0016.!\tYSG\u0004\u0002-[1\u0001\u0001\"\u0002\u0018\u0004\u0001\u0004y\u0013!B4sCBD\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a!\u0003%9'/\u00199im&,w/\u0003\u00025c\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003mM\u0012Qa\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\tIt\b\u0005\u0002;{5\t1H\u0003\u0002=A\u0005)A/\u00192mK&\u0011ah\u000f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006]\u0011\u0001\raL\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u0017V3\u0006C\u0001'T\u001b\u0005i%B\u0001(P\u0003!\u00198-\u00197bI>\u001c'B\u0001)R\u0003\u001d!\u0018m[3{_\u0016T!AU\b\u0002\r\u001dLG\u000f[;c\u0013\t!VJ\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u00059\u0016\u0001b\u00170U)R\u0001\u0005\t\u0016!wNl\bm\u00127pE\u0006dGK]5b]\u001edWmQ8v]RD\u0013\u0006\u0019\u0006!A)\u0002\u0003E\u000f\u0011SKR,(O\\:!i\",\u0007\u0005^8uC2\u0004c.^7cKJ\u0004sN\u001a\u0011v]\u0012L'/Z2uK\u0012\u0004CO]5b]\u001edWm\u001d\u0011j]\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$(/[1oO2,7O\u000f\u0011J]R\u0004'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011uQJ,W\r\t;j[\u0016\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007\u0005\u001e:jC:<G.Z:!Q\t,H\u000f\t:fiV\u0014h.\u001a3!S:\u0004s.\u001e;qkR\u0004s/\u001b;i_V$\b\u0005\u001e5fA\u0019\f7\r^8sA=4\u0007\u0005\u001e5sK\u0016LcF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!i>$\u0018\r\u001c\u0011ue&\fgn\u001a7fg\u0002\u0002\u0003\u0005\t\u0011!y*\u0001\u0003E\u000b\u0011!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b(\u0002\t\u0011+A\u0001b\be_:~AR\u0014\u0018.\u00198hY\u0016\u001c(\bI%oi\u0002\u0004\u0003\u0005 \u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047P\\8uKvT\u0001\u0005\t\u0016!A\u0015#w-Z:!Q\u0016\u0014X\rI1sK\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011v]\u0012L'/Z2uK\u0012d\u0003e]8!S\u001a\u0004C\u000f[3!k:$WM\u001d7zS:<\u0007E\\3uo>\u00148\u000eI5tA\u0011L'/Z2uK\u0012\u0004\u0003.\u001a:fY)\u0001\u0003E\u000b\u0011(]\u0016Lw\r\u001b2pkJ\u001cx\u0005\t:fM\u0016\u00148\u000f\t;pAQDW\rI;oS>t\u0007e\u001c4!S:lc.Z5hQ\n|WO]:!C:$\u0007e\\;u[9,\u0017n\u001a5c_V\u00148O\f\u0006!A)\u0002\u0003\r\u0019\u0006!A)z\u0003\u0006\u0002\u0001L+Z\u0003")
public final class GlobalTriangleCount {
    public static Table tabularise(GraphPerspective graph) {
        return GlobalTriangleCount$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return GlobalTriangleCount$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return GlobalTriangleCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return GlobalTriangleCount$.MODULE$.name();
    }

    public static Logger logger() {
        return GlobalTriangleCount$.MODULE$.logger();
    }
}

