/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.community;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.community.LPA$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;
import scala.util.Random$;

@Scaladoc(value="/**\n  * {s}`LPA(weight:String = \"\", maxIter:Int = 500, seed:Long = -1)`\n  *    : run synchronous label propagation based community detection\n  *\n  *   LPA returns the communities of the constructed graph as detected by synchronous label propagation.\n  *   Every vertex is assigned an initial label at random. Looking at the labels of its neighbours, a probability is assigned\n  *   to observed labels following an increasing function then the vertex\u2019s label is updated with the label with the highest\n  *   probability. If the new label is the same as the current label, the vertex votes to halt. This process iterates until\n  *   all vertex labels have converged. The algorithm is synchronous since every vertex updates its label at the same time.\n  *\n  * ## Parameters\n  *\n  *   {s}`weight: String = \"\"`\n  *    : Edge weight property. To be specified in case of weighted graph.\n  *\n  *   {s}`tieBreaker: TieBreaker = MinTieBreak`\n  *    : rule for breaking ties between equally weighted neighbourhood labels. Default is to pick the minimum valued label.\n  *\n  *   {s}`maxIter: Int = 500`\n  *    : Maximum iterations for algorithm to run.\n  *\n  *   {s}`seed: Long`\n  *    : Value used for the random selection, can be set to ensure same result is returned per run.\n  *      If not specified, it will generate a random seed.\n  *\n  *    {s}`stickinessProb: Float`\n  *    : Probability that regardless of the tiebreak algorithm used, a vertex will just keep its previous label.\n  *\n  * ## States\n  *\n  *    {s}`community: Long`\n  *      : The ID of the community the vertex belongs to\n  *\n  * ## Returns\n  *\n  *  | vertex name       | community label      |\n  *  | ----------------- | -------------------- |\n  *  | {s}`name: String` | {s}`community: Long` |\n  *\n  * ```{note}\n  *   This implementation of LPA incorporates probabilistic elements which makes it\n  *   non-deterministic; The returned communities may differ on multiple executions.\n  *   Which is why you may want to set the seed if testing.\n  * ```\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.community.SLPA), [](com.raphtory.algorithms.temporal.community.MultilayerLPA)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\rMg\u0001B0a\u0001-D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\n\u007f\u0002\u0011\t\u0011)A\u0005\u0003\u0003A!Ba \u0001\u0005\u0003\u0005\u000b\u0011\u0002BA\u0011)\u0011I\t\u0001B\u0001B\u0003%!1\u0001\u0005\u000b\u0005\u001b\u0003!\u0011!Q\u0001\n\u0005\r\u0005BCB5\u0001\t\r\t\u0015a\u0003\u0004l!9\u0011\u0011\b\u0001\u0005\u0002\rE\u0004\"\u0003Bw\u0001\t\u0007I\u0011BBB\u0011!\u0019)\t\u0001Q\u0001\n\t=\b\"\u0003Br\u0001\t\u0007I\u0011BBD\u0011!\u0019I\t\u0001Q\u0001\n\t\u0005\u0005bBA\u001f\u0001\u0011\u000531\u0012\u0005\b\u0007K\u0003A\u0011IBT\u000f\u001d\tI\u0002\u0019E\u0001\u000371aa\u00181\t\u0002\u0005}\u0001bBA\u001d\u001f\u0011\u0005\u00111\b\u0005\b\u0003{yA\u0011AA \u0011%\u0011yiDI\u0001\n\u0003\u0011\t\nC\u0005\u0003\u001a>\t\n\u0011\"\u0001\u0003\u001c\"I!1U\b\u0012\u0002\u0013\u0005!Q\u0015\u0005\n\u0005[{\u0011\u0013!C\u0001\u0005_C\u0011Ba.\u0010#\u0003%\tA!/\t\u000f\t\u0005w\u0002\"\u0001\u0003D\u001aI\u00111P\b\u0011\u0002G\u0005\u0012Q\u0010\u0005\b\u0003\u007fBb\u0011AAA\r\u0019\u0011yf\u0004!\u0003b!9\u0011\u0011\b\u000e\u0005\u0002\t\r\u0004bBA@5\u0011\u0005#q\r\u0005\n\u0003'T\u0012\u0011!C\u0001\u0005GB\u0011\"!=\u001b\u0003\u0003%\t%a=\t\u0013\u0005}($!A\u0005\u0002\t\u0005\u0001\"\u0003B\u00055\u0005\u0005I\u0011\u0001B7\u0011%\u0011\tBGA\u0001\n\u0003\u0012\u0019\u0002C\u0005\u0003\"i\t\t\u0011\"\u0001\u0003r!I!Q\u0006\u000e\u0002\u0002\u0013\u0005#Q\u000f\u0005\n\u0005gQ\u0012\u0011!C!\u0005kA\u0011Ba\u000e\u001b\u0003\u0003%\tE!\u000f\t\u0013\tm\"$!A\u0005B\tet!\u0003B~\u001f\u0005\u0005\t\u0012\u0001B\u007f\r%\u0011yfDA\u0001\u0012\u0003\u0011y\u0010C\u0004\u0002:!\"\ta!\u0004\t\u0013\t]\u0002&!A\u0005F\te\u0002\"CA\u001fQ\u0005\u0005I\u0011\u0011B2\u0011%\u0019y\u0001KA\u0001\n\u0003\u001b\t\u0002C\u0005\u0004\u0018!\n\t\u0011\"\u0003\u0004\u001a\u00191!\u0011I\bA\u0005\u0007Bq!!\u000f/\t\u0003\u0011)\u0005C\u0004\u0002\u00009\"\tE!\u0013\t\u0013\u0005Mg&!A\u0005\u0002\t\u0015\u0003\"CAy]\u0005\u0005I\u0011IAz\u0011%\tyPLA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\n9\n\t\u0011\"\u0001\u0003P!I!\u0011\u0003\u0018\u0002\u0002\u0013\u0005#1\u0003\u0005\n\u0005Cq\u0013\u0011!C\u0001\u0005'B\u0011B!\f/\u0003\u0003%\tEa\u0016\t\u0013\tMb&!A\u0005B\tU\u0002\"\u0003B\u001c]\u0005\u0005I\u0011\tB\u001d\u0011%\u0011YDLA\u0001\n\u0003\u0012YfB\u0005\u0004\"=\t\t\u0011#\u0001\u0004$\u0019I!\u0011I\b\u0002\u0002#\u00051Q\u0005\u0005\b\u0003saD\u0011AB\u0015\u0011%\u00119\u0004PA\u0001\n\u000b\u0012I\u0004C\u0005\u0002>q\n\t\u0011\"!\u0003F!I1q\u0002\u001f\u0002\u0002\u0013\u000551\u0006\u0005\n\u0007/a\u0014\u0011!C\u0005\u000731a!!,\u0010\u0001\u0006=\u0006BCA^\u0005\nU\r\u0011\"\u0001\u0002>\"Q\u0011Q\u0019\"\u0003\u0012\u0003\u0006I!a0\t\u000f\u0005e\"\t\"\u0001\u0002H\"9\u0011q\u0010\"\u0005B\u00055\u0007\"CAj\u0005\u0006\u0005I\u0011AAk\u0011%\tINQI\u0001\n\u0003\tY\u000eC\u0005\u0002r\n\u000b\t\u0011\"\u0011\u0002t\"I\u0011q \"\u0002\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005\u0013\u0011\u0015\u0011!C\u0001\u0005\u0017A\u0011B!\u0005C\u0003\u0003%\tEa\u0005\t\u0013\t\u0005\")!A\u0005\u0002\t\r\u0002\"\u0003B\u0017\u0005\u0006\u0005I\u0011\tB\u0018\u0011%\u0011\u0019DQA\u0001\n\u0003\u0012)\u0004C\u0005\u00038\t\u000b\t\u0011\"\u0011\u0003:!I!1\b\"\u0002\u0002\u0013\u0005#QH\u0004\n\u0007_y\u0011\u0011!E\u0001\u0007c1\u0011\"!,\u0010\u0003\u0003E\taa\r\t\u000f\u0005e2\u000b\"\u0001\u0004<!I!qG*\u0002\u0002\u0013\u0015#\u0011\b\u0005\n\u0003{\u0019\u0016\u0011!CA\u0007{A\u0011ba\u0004T\u0003\u0003%\ti!\u0011\t\u0013\r]1+!A\u0005\n\re\u0001\"CB&\u001fE\u0005I\u0011AB'\u0011%\u0019\tfDI\u0001\n\u0003\u0019\u0019\u0006C\u0005\u0004X=\t\n\u0011\"\u0001\u0004Z!I1QL\b\u0012\u0002\u0013\u00051q\f\u0005\n\u0007Gz\u0011\u0013!C\u0001\u0007KB\u0011ba\u0006\u0010\u0003\u0003%Ia!\u0007\u0003\u00071\u0003\u0016I\u0003\u0002bE\u0006I1m\\7nk:LG/\u001f\u0006\u0003G\u0012\fqaZ3oKJL7M\u0003\u0002fM\u0006Q\u0011\r\\4pe&$\b.\\:\u000b\u0005\u001dD\u0017\u0001\u0003:ba\"$xN]=\u000b\u0003%\f1aY8n\u0007\u0001)2\u0001\\B8'\t\u0001Q\u000e\u0005\u0002o_6\t!-\u0003\u0002qE\nAaj\u001c3f\u0019&\u001cH/\u0001\u0004xK&<\u0007\u000e\u001e\t\u0003grt!\u0001\u001e>\u0011\u0005UDX\"\u0001<\u000b\u0005]T\u0017A\u0002\u001fs_>$hHC\u0001z\u0003\u0015\u00198-\u00197b\u0013\tY\b0\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>y\u0003)!\u0018.\u001a\"sK\u0006\\WM\u001d\t\u0004\u0003\u0007AbbAA\u0003\u001d9!\u0011qAA\f\u001d\u0011\tI!!\u0006\u000f\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\t\tBD\u0002v\u0003\u001fI\u0011![\u0005\u0003O\"L!!\u001a4\n\u0005\r$\u0017BA1c\u0003\ra\u0005+\u0011\t\u0004\u0003;yQ\"\u00011\u0014\u000b=\t\t#!\u000b\u0011\t\u0005\r\u0012QE\u0007\u0002q&\u0019\u0011q\u0005=\u0003\r\u0005s\u0017PU3g!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t!![8\u000b\u0005\u0005M\u0012\u0001\u00026bm\u0006LA!a\u000e\u0002.\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\"!a\u0007\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005\u0005\u00131\n\u000b\r\u0003\u0007\n\u0019(!\u001e\u0003~\t\u001d%1\u0012\u000b\u0005\u0003\u000b\ni\u0006E\u0003\u0002\u001e\u0001\t9\u0005\u0005\u0003\u0002J\u0005-C\u0002\u0001\u0003\b\u0003\u001b\n\"\u0019AA(\u0005\u0005!\u0016\u0003BA)\u0003/\u0002B!a\t\u0002T%\u0019\u0011Q\u000b=\u0003\u000f9{G\u000f[5oOB!\u00111EA-\u0013\r\tY\u0006\u001f\u0002\u0004\u0003:L\b\"CA0#\u0005\u0005\t9AA1\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0003G\ni'a\u0012\u000f\t\u0005\u0015\u0014\u0011\u000e\b\u0004k\u0006\u001d\u0014\"A=\n\u0007\u0005-\u00040A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0014\u0011\u000f\u0002\b\u001dVlWM]5d\u0015\r\tY\u0007\u001f\u0005\bcF\u0001\n\u00111\u0001s\u0011!y\u0018\u0003%AA\u0002\u0005]\u0004cAA=15\tqB\u0001\u0006US\u0016\u0014%/Z1lKJ\u001c2\u0001GA\u0011\u0003-\u0019\u0007n\\8tK2\u000b'-\u001a7\u0015\r\u0005\r\u0015\u0011RAJ!\u0011\t\u0019#!\"\n\u0007\u0005\u001d\u0005P\u0001\u0003M_:<\u0007bBAF3\u0001\u0007\u0011QR\u0001\u000ba>\u001c8\u000fT1cK2\u001c\bCBA2\u0003\u001f\u000b\u0019)\u0003\u0003\u0002\u0012\u0006E$\u0001\u0002'jgRDq!!&\u001a\u0001\u0004\t9*\u0001\u0004wKJ$X\r\u001f\t\u0005\u00033\u000b9+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u001d1\u0018n]5u_JTA!!)\u0002$\u0006A\u0011M\\1msNL7OC\u0002\u0002&\u001a\f1!\u00199j\u0013\u0011\tI+a'\u0003\rY+'\u000f^3yS\u0011A\"I\f\u000e\u0003\u001d\r+8\u000f^8n)&,'I]3bWNI!)!\t\u0002x\u0005E\u0016q\u0017\t\u0005\u0003G\t\u0019,C\u0002\u00026b\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002d\u0005e\u0016\u0002BA\u001c\u0003c\n\u0011AZ\u000b\u0003\u0003\u007f\u0003\"\"a\t\u0002B\u00065\u0015qSAB\u0013\r\t\u0019\r\u001f\u0002\n\rVt7\r^5p]J\n!A\u001a\u0011\u0015\t\u0005%\u00171\u001a\t\u0004\u0003s\u0012\u0005bBA^\u000b\u0002\u0007\u0011q\u0018\u000b\u0007\u0003\u0007\u000by-!5\t\u000f\u0005-e\t1\u0001\u0002\u000e\"9\u0011Q\u0013$A\u0002\u0005]\u0015\u0001B2paf$B!!3\u0002X\"I\u00111X$\u0011\u0002\u0003\u0007\u0011qX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiN\u000b\u0003\u0002@\u0006}7FAAq!\u0011\t\u0019/!<\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\b0\u0001\u0006b]:|G/\u0019;j_:LA!a<\u0002f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0010\u0005\u0003\u0002x\u0006uXBAA}\u0015\u0011\tY0!\r\u0002\t1\fgnZ\u0005\u0004{\u0006e\u0018\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0002!\u0011\t\u0019C!\u0002\n\u0007\t\u001d\u0001PA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002X\t5\u0001\"\u0003B\b\u0017\u0006\u0005\t\u0019\u0001B\u0002\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0003\t\u0007\u0005/\u0011i\"a\u0016\u000e\u0005\te!b\u0001B\u000eq\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}!\u0011\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003&\t-\u0002\u0003BA\u0012\u0005OI1A!\u000by\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u0004N\u0003\u0003\u0005\r!a\u0016\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003k\u0014\t\u0004C\u0005\u0003\u00109\u000b\t\u00111\u0001\u0003\u0004\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003\u0004\u0005AAo\\*ue&tw\r\u0006\u0002\u0002v\u00061Q-];bYN$BA!\n\u0003@!I!qB)\u0002\u0002\u0003\u0007\u0011q\u000b\u0002\f\u001b&tG+[3Ce\u0016\f7nE\u0005/\u0003C\t9(!-\u00028R\u0011!q\t\t\u0004\u0003srCCBAB\u0005\u0017\u0012i\u0005C\u0004\u0002\fB\u0002\r!!$\t\u000f\u0005U\u0005\u00071\u0001\u0002\u0018R!\u0011q\u000bB)\u0011%\u0011y\u0001NA\u0001\u0002\u0004\u0011\u0019\u0001\u0006\u0003\u0003&\tU\u0003\"\u0003B\bm\u0005\u0005\t\u0019AA,)\u0011\t)P!\u0017\t\u0013\t=q'!AA\u0002\t\rA\u0003\u0002B\u0013\u0005;B\u0011Ba\u0004;\u0003\u0003\u0005\r!a\u0016\u0003\u001dI\u000bg\u000eZ8n)&,'I]3bWNI!$!\t\u0002x\u0005E\u0016q\u0017\u000b\u0003\u0005K\u00022!!\u001f\u001b)\u0019\t\u0019I!\u001b\u0003l!9\u00111\u0012\u000fA\u0002\u00055\u0005bBAK9\u0001\u0007\u0011q\u0013\u000b\u0005\u0003/\u0012y\u0007C\u0005\u0003\u0010\u0001\n\t\u00111\u0001\u0003\u0004Q!!Q\u0005B:\u0011%\u0011yAIA\u0001\u0002\u0004\t9\u0006\u0006\u0003\u0002v\n]\u0004\"\u0003B\bG\u0005\u0005\t\u0019\u0001B\u0002)\u0011\u0011)Ca\u001f\t\u0013\t=a%!AA\u0002\u0005]\u0003\"\u0003B@#A\u0005\t\u0019\u0001BA\u00039\u0019H/[2lS:,7o\u001d)s_\n\u0004B!a\t\u0003\u0004&\u0019!Q\u0011=\u0003\u000b\u0019cw.\u0019;\t\u0013\t%\u0015\u0003%AA\u0002\t\r\u0011aB7bq&#XM\u001d\u0005\n\u0005\u001b\u000b\u0002\u0013!a\u0001\u0003\u0007\u000bAa]3fI\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003\u0014\n]UC\u0001BKU\r\u0011\u0018q\u001c\u0003\b\u0003\u001b\u0012\"\u0019AA(\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002BO\u0005C+\"Aa(+\t\u0005]\u0014q\u001c\u0003\b\u0003\u001b\u001a\"\u0019AA(\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002BT\u0005W+\"A!++\t\t\u0005\u0015q\u001c\u0003\b\u0003\u001b\"\"\u0019AA(\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"T\u0003\u0002BY\u0005k+\"Aa-+\t\t\r\u0011q\u001c\u0003\b\u0003\u001b*\"\u0019AA(\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*T\u0003\u0002B^\u0005\u007f+\"A!0+\t\u0005\r\u0015q\u001c\u0003\b\u0003\u001b2\"\u0019AA(\u0003\ra\u0007/Y\u000b\u0005\u0005\u000b\u00149\u000e\u0006\u0007\u0003H\ne'1\u001cBo\u0005C\u0014Y\u000f\u0006\u0003\u0003J\n=\u0007\u0003BA\u0012\u0005\u0017L1A!4y\u0005\u0011)f.\u001b;\t\u000f\tEw\u0003q\u0001\u0003T\u00069a.^7fe&\u001c\u0007CBA2\u0003[\u0012)\u000e\u0005\u0003\u0002J\t]GaBA'/\t\u0007\u0011q\n\u0005\b\u0003+;\u0002\u0019AAL\u0011\u0015\tx\u00031\u0001s\u0011\u001d\u0011yn\u0006a\u0001\u0003o\n\u0001\u0002^5f\u0005J,\u0017m\u001b\u0005\b\u0005G<\u0002\u0019\u0001Bs\u0003\t\u0019\u0006\u000b\u0005\u0003\u0002$\t\u001d\u0018b\u0001Buq\n1Ai\\;cY\u0016DqA!<\u0018\u0001\u0004\u0011y/A\u0002s]\u0012\u0004BA!=\u0003x6\u0011!1\u001f\u0006\u0004\u0005kD\u0018\u0001B;uS2LAA!?\u0003t\n1!+\u00198e_6\faBU1oI>lG+[3Ce\u0016\f7\u000eE\u0002\u0002z!\u001aR\u0001KB\u0001\u0003S\u0001baa\u0001\u0004\n\t\u0015TBAB\u0003\u0015\r\u00199\u0001_\u0001\beVtG/[7f\u0013\u0011\u0019Ya!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0007\u0007\u0006\u0002\u0003~\u00069QO\\1qa2LH\u0003\u0002B\u0013\u0007'A\u0011b!\u0006-\u0003\u0003\u0005\rA!\u001a\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004\u001cA!\u0011q_B\u000f\u0013\u0011\u0019y\"!?\u0003\r=\u0013'.Z2u\u0003-i\u0015N\u001c+jK\n\u0013X-Y6\u0011\u0007\u0005eDhE\u0003=\u0007O\tI\u0003\u0005\u0004\u0004\u0004\r%!q\t\u000b\u0003\u0007G!BA!\n\u0004.!I1Q\u0003!\u0002\u0002\u0003\u0007!qI\u0001\u000f\u0007V\u001cHo\\7US\u0016\u0014%/Z1l!\r\tIhU\n\u0006'\u000eU\u0012\u0011\u0006\t\t\u0007\u0007\u00199$a0\u0002J&!1\u0011HB\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0007c!B!!3\u0004@!9\u00111\u0018,A\u0002\u0005}F\u0003BB\"\u0007\u0013\u0002b!a\t\u0004F\u0005}\u0016bAB$q\n1q\n\u001d;j_:D\u0011b!\u0006X\u0003\u0003\u0005\r!!3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0011\u0011\u0019ja\u0014\u0005\u000f\u00055\u0013L1\u0001\u0002P\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*BA!(\u0004V\u00119\u0011Q\n.C\u0002\u0005=\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0003\u0003(\u000emCaBA'7\n\u0007\u0011qJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\tE6\u0011\r\u0003\b\u0003\u001bb&\u0019AA(\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU!!1XB4\t\u001d\ti%\u0018b\u0001\u0003\u001f\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\t\u0019'!\u001c\u0004nA!\u0011\u0011JB8\t\u001d\ti\u0005\u0001b\u0001\u0003\u001f\"Bba\u001d\u0004z\rm4QPB@\u0007\u0003#Ba!\u001e\u0004xA)\u0011Q\u0004\u0001\u0004n!91\u0011N\u0004A\u0004\r-\u0004bB9\b!\u0003\u0005\rA\u001d\u0005\t\u007f\u001e\u0001\n\u00111\u0001\u0002\u0002!I!qP\u0004\u0011\u0002\u0003\u0007!\u0011\u0011\u0005\n\u0005\u0013;\u0001\u0013!a\u0001\u0005\u0007A\u0011B!$\b!\u0003\u0005\r!a!\u0016\u0005\t=\u0018\u0001\u0002:oI\u0002*\"A!!\u0002\u0007M\u0003\u0006\u0005\u0006\u0003\u0004\u000e\u000eE\u0005\u0003BBH\u0007CsA!!\u0013\u0004\u0012\"911\u0013\u0007A\u0002\rU\u0015!B4sCBD\u0007\u0003BBL\u0007;k!a!'\u000b\t\rm\u0015qT\u0001\nOJ\f\u0007\u000f\u001b<jK^LAaa(\u0004\u001a\n\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0005\u0007G\u001biJA\u0003He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$Ba!+\u00046B!11VBY\u001b\t\u0019iK\u0003\u0003\u00040\u0006}\u0015!\u0002;bE2,\u0017\u0002BBZ\u0007[\u0013Q\u0001V1cY\u0016Dqaa%\u000e\u0001\u0004\u0019)\nK\u0004\u0001\u0007s\u001bima4\u0011\t\rm6\u0011Z\u0007\u0003\u0007{SAaa0\u0004B\u0006A1oY1mC\u0012|7M\u0003\u0003\u0004D\u000e\u0015\u0017a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0007\u000fD\u0017AB4ji\",(-\u0003\u0003\u0004L\u000eu&\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\rE\u0017\u0001e:0U)R\u0001\u0005\t\u0016!wNl\b\r\u0014)BQ],\u0017n\u001a5uuM#(/\u001b8hAu\u0002#E\t\u0017![\u0006D\u0018\n^3su%sG\u000fI\u001f!kA\u0002D\u0006I:fK\u0012TDj\u001c8hAu\u0002S&M\u0015a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002#/\u001e8!gft7\r\u001b:p]>,8\u000f\t7bE\u0016d\u0007\u0005\u001d:pa\u0006<\u0017\r^5p]\u0002\u0012\u0017m]3eA\r|W.\\;oSRL\b\u0005Z3uK\u000e$\u0018n\u001c8\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0002C\nU!!e\u0016$XO\u001d8tAQDW\rI2p[6,h.\u001b;jKN\u0004sN\u001a\u0011uQ\u0016\u00043m\u001c8tiJ,8\r^3eA\u001d\u0014\u0018\r\u001d5!CN\u0004C-\u001a;fGR,G\r\t2zAMLhn\u00195s_:|Wo\u001d\u0011mC\n,G\u000e\t9s_B\fw-\u0019;j_:t#\u0002\t\u0011+A\u0001\u0002SI^3ss\u00022XM\u001d;fq\u0002J7\u000fI1tg&<g.\u001a3!C:\u0004\u0013N\\5uS\u0006d\u0007\u0005\\1cK2\u0004\u0013\r\u001e\u0011sC:$w.\u001c\u0018!\u0019>|7.\u001b8hA\u0005$\b\u0005\u001e5fA1\f'-\u001a7tA=4\u0007%\u001b;tA9,\u0017n\u001a5c_V\u00148\u000f\f\u0011bAA\u0014xNY1cS2LG/\u001f\u0011jg\u0002\n7o]5h]\u0016$'\u0002\t\u0011+A\u0001\u0002Co\u001c\u0011pEN,'O^3eA1\f'-\u001a7tA\u0019|G\u000e\\8xS:<\u0007%\u00198!S:\u001c'/Z1tS:<\u0007EZ;oGRLwN\u001c\u0011uQ\u0016t\u0007\u0005\u001e5fAY,'\u000f^3yE\u0004M:\u000f\t7bE\u0016d\u0007%[:!kB$\u0017\r^3eA]LG\u000f\u001b\u0011uQ\u0016\u0004C.\u00192fY\u0002:\u0018\u000e\u001e5!i\",\u0007\u0005[5hQ\u0016\u001cHO\u0003\u0011!U\u0001\u0002\u0003\u0005\u001d:pE\u0006\u0014\u0017\u000e\\5us:\u0002\u0013J\u001a\u0011uQ\u0016\u0004c.Z<!Y\u0006\u0014W\r\u001c\u0011jg\u0002\"\b.\u001a\u0011tC6,\u0007%Y:!i\",\u0007eY;se\u0016tG\u000f\t7bE\u0016dG\u0006\t;iK\u00022XM\u001d;fq\u00022x\u000e^3tAQ|\u0007\u0005[1mi:\u0002C\u000b[5tAA\u0014xnY3tg\u0002JG/\u001a:bi\u0016\u001c\b%\u001e8uS2T\u0001\u0005\t\u0016!A\u0001\nG\u000e\u001c\u0011wKJ$X\r\u001f\u0011mC\n,Gn\u001d\u0011iCZ,\u0007eY8om\u0016\u0014x-\u001a3/AQCW\rI1mO>\u0014\u0018\u000e\u001e5nA%\u001c\be]=oG\"\u0014xN\\8vg\u0002\u001a\u0018N\\2fA\u00154XM]=!m\u0016\u0014H/\u001a=!kB$\u0017\r^3tA%$8\u000f\t7bE\u0016d\u0007%\u0019;!i\",\u0007e]1nK\u0002\"\u0018.\\3/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t)be\u0006lW\r^3sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I>t{\u0002<X-[4iij\u00023\u000b\u001e:j]\u001e\u0004S\b\t\u0012#A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004%\u00123hK\u0002:X-[4ii\u0002\u0002(o\u001c9feRLh\u0006\t+pA\t,\u0007e\u001d9fG&4\u0017.\u001a3!S:\u00043-Y:fA=4\u0007e^3jO\"$X\r\u001a\u0011he\u0006\u0004\bN\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1uS\u0016\u0014%/Z1lKJT\u0004\u0005V5f\u0005J,\u0017m[3sAu\u0002S*\u001b8US\u0016\u0014%/Z1lA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004E];mK\u00022wN\u001d\u0011ce\u0016\f7.\u001b8hAQLWm\u001d\u0011cKR<X-\u001a8!KF,\u0018\r\u001c7zA],\u0017n\u001a5uK\u0012\u0004c.Z5hQ\n|WO\u001d5p_\u0012\u0004C.\u00192fYNt\u0003\u0005R3gCVdG\u000fI5tAQ|\u0007\u0005]5dW\u0002\"\b.\u001a\u0011nS:LW.^7!m\u0006dW/\u001a3!Y\u0006\u0014W\r\u001c\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u00023p]?a[\u0006D\u0018\n^3su\u0001Je\u000e\u001e\u0011>AU\u0002\u0004\u0007\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A5\u000b\u00070[7v[\u0002JG/\u001a:bi&|gn\u001d\u0011g_J\u0004\u0013\r\\4pe&$\b.\u001c\u0011u_\u0002\u0012XO\u001c\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u00023p]?ag\u0016,GM\u000f\u0011M_:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!-\u0006dW/\u001a\u0011vg\u0016$\u0007EZ8sAQDW\r\t:b]\u0012|W\u000eI:fY\u0016\u001cG/[8oY\u0001\u001a\u0017M\u001c\u0011cK\u0002\u001aX\r\u001e\u0011u_\u0002*gn];sK\u0002\u001a\u0018-\\3!e\u0016\u001cX\u000f\u001c;!SN\u0004#/\u001a;ve:,G\r\t9fe\u0002\u0012XO\u001c\u0018\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001Je\r\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011ji\u0002:\u0018\u000e\u001c7!O\u0016tWM]1uK\u0002\n\u0007E]1oI>l\u0007e]3fI:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011!wNl\bm\u001d;jG.Lg.Z:t!J|'M\u000f\u0011GY>\fG\u000f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AA\u0013xNY1cS2LG/\u001f\u0011uQ\u0006$\bE]3hCJ$G.Z:tA=4\u0007\u0005\u001e5fAQLWM\u0019:fC.\u0004\u0013\r\\4pe&$\b.\u001c\u0011vg\u0016$G\u0006I1!m\u0016\u0014H/\u001a=!o&dG\u000e\t6vgR\u00043.Z3qA%$8\u000f\t9sKZLw.^:!Y\u0006\u0014W\r\u001c\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!Am\u001cX\u0010Y2p[6,h.\u001b;zu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0002#\b\t+iK\u0002JE\tI8gAQDW\rI2p[6,h.\u001b;zAQDW\r\t<feR,\u0007\u0010\t2fY>twm\u001d\u0011u_*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+A\u0001b\bE^3si\u0016D\bE\\1nK\u0002\u0002\u0003\u0005\t\u0011!Aq\u00043m\\7nk:LG/\u001f\u0011mC\n,G\u000e\t\u0011!A\u0001\u0002CP\u0003\u0011!U\u0001\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002\u001cw.\\7v]&$\u0018P\u000f\u0011M_:<\u0007\r\t?\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m\u001f8pi\u0016l(\u0002\t\u0011+A\u0001\u0002C\u000b[5tA%l\u0007\u000f\\3nK:$\u0018\r^5p]\u0002zg\r\t'Q\u0003\u0002JgnY8sa>\u0014\u0018\r^3tAA\u0014xNY1cS2L7\u000f^5dA\u0015dW-\\3oiN\u0004s\u000f[5dQ\u0002j\u0017m[3tA%$(\u0002\t\u0011+A\u0001\u0002cn\u001c8.I\u0016$XM]7j]&\u001cH/[2<AQCW\r\t:fiV\u0014h.\u001a3!G>lW.\u001e8ji&,7\u000fI7bs\u0002\"\u0017N\u001a4fe\u0002zg\u000eI7vYRL\u0007\u000f\\3!Kb,7-\u001e;j_:\u001chF\u0003\u0011!U\u0001\u0002\u0003e\u00165jG\"\u0004\u0013n\u001d\u0011xQf\u0004\u0013p\\;![\u0006L\be^1oi\u0002\"x\u000eI:fi\u0002\"\b.\u001a\u0011tK\u0016$\u0007%\u001b4!i\u0016\u001cH/\u001b8h])\u0001\u0003E\u000b\u0011aA\u0002T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191awN,W-\u00197t_vT\u0001\u0005\t\u0016!7vC3m\\7/e\u0006\u0004\b\u000e^8ss:\nGnZ8sSRDWn\u001d\u0018hK:,'/[2/G>lW.\u001e8jift3\u000b\u0014)BS1\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng:\"X-\u001c9pe\u0006dgfY8n[Vt\u0017\u000e^=/\u001bVdG/\u001b7bs\u0016\u0014H\nU!*\u0015\u0001\u0002#\u0006\t1aA*\u0001\u0003EK\u0018")
public class LPA<T>
extends NodeList {
    private final String weight;
    private final TieBreaker tieBreaker;
    private final int maxIter;
    private final Numeric<T> evidence$1;
    private final Random rnd;
    private final float SP;

    public static <T> long $lessinit$greater$default$5() {
        return LPA$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> int $lessinit$greater$default$4() {
        return LPA$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> float $lessinit$greater$default$3() {
        return LPA$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> TieBreaker $lessinit$greater$default$2() {
        return LPA$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> String $lessinit$greater$default$1() {
        return LPA$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> void lpa(Vertex vertex, String weight, TieBreaker tieBreak, double SP, Random rnd, Numeric<T> numeric) {
        LPA$.MODULE$.lpa(vertex, weight, tieBreak, SP, rnd, numeric);
    }

    public static <T> long apply$default$5() {
        return LPA$.MODULE$.apply$default$5();
    }

    public static <T> int apply$default$4() {
        return LPA$.MODULE$.apply$default$4();
    }

    public static <T> float apply$default$3() {
        return LPA$.MODULE$.apply$default$3();
    }

    public static <T> TieBreaker apply$default$2() {
        return LPA$.MODULE$.apply$default$2();
    }

    public static <T> String apply$default$1() {
        return LPA$.MODULE$.apply$default$1();
    }

    private Random rnd() {
        return this.rnd;
    }

    private float SP() {
        return this.SP;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            LPA.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            LPA$.MODULE$.lpa(vertex, this.weight, this.tieBreaker, this.SP(), this.rnd(), this.evidence$1);
            return BoxedUnit.UNIT;
        }, this.maxIter, false);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(vertex.name$default$1()), ((EntityVisitor)((Object)vertex)).getState("community", ((EntityVisitor)((Object)vertex)).getState$default$2())})));
    }

    public static final /* synthetic */ void $anonfun$apply$1(LPA $this, Vertex vertex) {
        long lab = $this.rnd().nextLong();
        ((EntityVisitor)((Object)vertex)).setState("community", BoxesRunTime.boxToLong((long)lab));
        vertex.messageAllNeighbours(new Tuple2(vertex.ID(), (Object)BoxesRunTime.boxToLong((long)lab)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
    }

    public LPA(String weight, TieBreaker tieBreaker, float stickinessProb, int maxIter, long seed, Numeric<T> evidence$1) {
        this.weight = weight;
        this.tieBreaker = tieBreaker;
        this.maxIter = maxIter;
        this.evidence$1 = evidence$1;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"community"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
        this.rnd = seed == -1L ? new Random() : new Random(seed);
        this.SP = stickinessProb;
    }

    public static class CustomTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        private final Function2<List<Object>, Vertex, Object> f;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function2<List<Object>, Vertex, Object> f() {
            return this.f;
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)this.f().apply(possLabels, (Object)vertex));
        }

        public CustomTieBreak copy(Function2<List<Object>, Vertex, Object> f) {
            return new CustomTieBreak(f);
        }

        public Function2<List<Object>, Vertex, Object> copy$default$1() {
            return this.f();
        }

        public String productPrefix() {
            return "CustomTieBreak";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.f();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CustomTieBreak;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "f";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CustomTieBreak)) return false;
            boolean bl = true;
            if (!bl) return false;
            CustomTieBreak customTieBreak = (CustomTieBreak)x$1;
            Function2<List<Object>, Vertex, Object> function2 = this.f();
            Function2<List<Object>, Vertex, Object> function22 = customTieBreak.f();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            if (!customTieBreak.canEqual(this)) return false;
            return true;
        }

        public CustomTieBreak(Function2<List<Object>, Vertex, Object> f) {
            this.f = f;
            Product.$init$((Product)this);
        }
    }

    public static class MinTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)possLabels.min((Ordering)Ordering.Long$.MODULE$));
        }

        public MinTieBreak copy() {
            return new MinTieBreak();
        }

        public String productPrefix() {
            return "MinTieBreak";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MinTieBreak;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof MinTieBreak;
            return bl && ((MinTieBreak)x$1).canEqual(this);
        }

        public MinTieBreak() {
            Product.$init$((Product)this);
        }
    }

    public static class RandomTieBreak
    implements TieBreaker,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public long chooseLabel(List<Object> possLabels, Vertex vertex) {
            return BoxesRunTime.unboxToLong((Object)possLabels.apply(Random$.MODULE$.nextInt(possLabels.length())));
        }

        public RandomTieBreak copy() {
            return new RandomTieBreak();
        }

        public String productPrefix() {
            return "RandomTieBreak";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            Object object = Statics.ioobe((int)x$1);
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RandomTieBreak;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            String string = (String)Statics.ioobe((int)x$1);
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            boolean bl = object instanceof RandomTieBreak;
            return bl && ((RandomTieBreak)x$1).canEqual(this);
        }

        public RandomTieBreak() {
            Product.$init$((Product)this);
        }
    }

    public static interface TieBreaker {
        public long chooseLabel(List<Object> var1, Vertex var2);
    }
}

