/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeEdgeCount$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`NodeEdgeCount`\n  *  Stores/returns the number of nodes and edges in the graph.\n  *\n  *  This counts the number of nodes and edges in the perspective and returns them. We count both the number of \"undirected\"\n  *  edges, treating the graph as a simple undirected graph, the number of directed edges, treating the graph as directed\n  *  and simple, and the number of temporal edges which includes duplicate directed edges between the same pair of nodes.\n  *\n  * ## States\n  *\n  *  {s}`directedEdges: Int`\n  *  : Number of directed edges in the perspective\n  *\n  *  {s}`undirectedEdges: Int`\n  *  : Number of undirected edges in the perspective\n  *\n  *  {s}`temporalEdges: Int`\n  *  : Number of directed edges with multiplicity in the perspective\n  *\n  *\n  *  ## Returns\n  *\n  *  | no nodes          | no directed edges       | no undirected edges       | no temporal edges |\n  *  | ----------------- | ----------------------- | ------------------------- | ----------------- |\n  *  | {s}`noNodes: Int` | {s}`directedEdges: Int` | {s}`undirectedEdges: Int` | {s}`temporalEdges: Int` |\n  *\n  */")
@ScalaSignature(bytes="\u0006\u0005i;QAB\u0004\t\u0002A1QAE\u0004\t\u0002MAQ\u0001J\u0001\u0005\u0002\u0015BQAJ\u0001\u0005B\u001dBQ!N\u0001\u0005BYBq!Q\u0001\u0002\u0002\u0013%!)A\u0007O_\u0012,W\tZ4f\u0007>,h\u000e\u001e\u0006\u0003\u0011%\tqaZ3oKJL7M\u0003\u0002\u000b\u0017\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u00051i\u0011\u0001\u0003:ba\"$xN]=\u000b\u00039\t1aY8n\u0007\u0001\u0001\"!E\u0001\u000e\u0003\u001d\u0011QBT8eK\u0016#w-Z\"pk:$8cA\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0013\u0005dwm\u001c:ji\"l'BA\u0010!\u0003!\tg.\u00197zg&\u001c(BA\u0011\f\u0003\r\t\u0007/[\u0005\u0003Gq\u0011\u0001cR3oKJL7MU3ek\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0005\u0001\u0012!B1qa2LHC\u0001\u0015,!\tI3G\u0004\u0002+W1\u0001\u0001\"\u0002\u0017\u0004\u0001\u0004i\u0013!B4sCBD\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001f\u0003%9'/\u00199im&,w/\u0003\u00023_\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003iE\u0012ABU3ek\u000e,Gm\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\t9T\b\u0005\u00029w5\t\u0011H\u0003\u0002;=\u0005)A/\u00192mK&\u0011A(\u000f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006Y\u0011\u0001\rA\u0010\t\u0003]}J!\u0001Q\u0018\u0003/I+G-^2fI\u001e\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017\u0001D<sSR,'+\u001a9mC\u000e,G#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n1qJ\u00196fGRDC!\u0001'W/B\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\tg\u000e\fG.\u00193pG*\u0011\u0011KU\u0001\bi\u0006\\WM_8f\u0015\t\u0019V\"\u0001\u0004hSRDWOY\u0005\u0003+:\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u00021\u0006AYj\f\u0016+\u0015\u0001\u0002#\u0006I>t{\u0002tu\u000eZ3FI\u001e,7i\\;oi\u0002T\u0001\u0005\t\u0016!AM#xN]3t_I,G/\u001e:og\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002rw\u000eZ3tA\u0005tG\rI3eO\u0016\u001c\b%\u001b8!i\",\u0007e\u001a:ba\"t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011UQ&\u001c\beY8v]R\u001c\b\u0005\u001e5fA9,XNY3sA=4\u0007E\\8eKN\u0004\u0013M\u001c3!K\u0012<Wm\u001d\u0011j]\u0002\"\b.\u001a\u0011qKJ\u001c\b/Z2uSZ,\u0007%\u00198eAI,G/\u001e:og\u0002\"\b.Z7/A]+\u0007eY8v]R\u0004#m\u001c;iAQDW\r\t8v[\n,'\u000fI8gA\t*h\u000eZ5sK\u000e$X\r\u001a\u0012\u000bA\u0001R\u0003\u0005I3eO\u0016\u001cH\u0006\t;sK\u0006$\u0018N\\4!i\",\u0007e\u001a:ba\"\u0004\u0013m\u001d\u0011bAMLW\u000e\u001d7fAUtG-\u001b:fGR,G\rI4sCBDG\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\r\t3je\u0016\u001cG/\u001a3!K\u0012<Wm\u001d\u0017!iJ,\u0017\r^5oO\u0002\"\b.\u001a\u0011he\u0006\u0004\b\u000eI1tA\u0011L'/Z2uK\u0012T\u0001\u0005\t\u0016!A\u0005tG\rI:j[BdW\r\f\u0011b]\u0012\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004C/Z7q_J\fG\u000eI3eO\u0016\u001c\be\u001e5jG\"\u0004\u0013N\\2mk\u0012,7\u000f\t3va2L7-\u0019;fA\u0011L'/Z2uK\u0012\u0004S\rZ4fg\u0002\u0012W\r^<fK:\u0004C\u000f[3!g\u0006lW\r\t9bSJ\u0004sN\u001a\u0011o_\u0012,7O\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$\u0017N]3di\u0016$W\tZ4fgj\u0002\u0013J\u001c;a\u0015\u0001\u0002#\u0006\t\u0011;A9+XNY3sA=4\u0007\u0005Z5sK\u000e$X\r\u001a\u0011fI\u001e,7\u000fI5oAQDW\r\t9feN\u0004Xm\u0019;jm\u0016T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002,h\u000eZ5sK\u000e$X\rZ#eO\u0016\u001c(\bI%oi\u0002T\u0001\u0005\t\u0016!Ai\u0002c*^7cKJ\u0004sN\u001a\u0011v]\u0012L'/Z2uK\u0012\u0004S\rZ4fg\u0002Jg\u000e\t;iK\u0002\u0002XM]:qK\u000e$\u0018N^3\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1uK6\u0004xN]1m\u000b\u0012<Wm\u001d\u001e!\u0013:$\bM\u0003\u0011!U\u0001\u0002#\b\t(v[\n,'\u000fI8gA\u0011L'/Z2uK\u0012\u0004S\rZ4fg\u0002:\u0018\u000e\u001e5![VdG/\u001b9mS\u000eLG/\u001f\u0011j]\u0002\"\b.\u001a\u0011qKJ\u001c\b/Z2uSZ,'\u0002\t\u0011+\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+A\u0001b\bE\\8!]>$Wm\u001d\u0011!A\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004cn\u001c\u0011eSJ,7\r^3eA\u0015$w-Z:!A\u0001\u0002\u0003\u0005\t\u0011}A9|\u0007%\u001e8eSJ,7\r^3eA\u0015$w-Z:!A\u0001\u0002\u0003\u0005\t\u0011}A9|\u0007\u0005^3na>\u0014\u0018\r\u001c\u0011fI\u001e,7\u000f\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!Aq\u00043p]?a]>tu\u000eZ3tu\u0001Je\u000e\u001e1!y\u0002Z8/ 1eSJ,7\r^3e\u000b\u0012<Wm\u001d\u001e!\u0013:$\b\r\t?!wNl\b-\u001e8eSJ,7\r^3e\u000b\u0012<Wm\u001d\u001e!\u0013:$\b\r\t?!wNl\b\r^3na>\u0014\u0018\r\\#eO\u0016\u001c(\bI%oi\u0002\u0004CP\u0003\u0011!U)\u0001\u0003EK\u0018)\t\u0001aek\u0016")
public final class NodeEdgeCount {
    public static Table tabularise(ReducedGraphPerspective graph) {
        return NodeEdgeCount$.MODULE$.tabularise(graph);
    }

    public static ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return NodeEdgeCount$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(Generic other) {
        return NodeEdgeCount$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return NodeEdgeCount$.MODULE$.name();
    }

    public static Logger logger() {
        return NodeEdgeCount$.MODULE$.logger();
    }
}

