/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.VersionedProperty;
import com.raphtory.arrowcore.implementation.VertexPartition;
import java.util.ArrayList;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexSnapshotStore {
    protected VectorSchemaRoot _root;
    protected int _maxRow = 0;
    protected int _nProperties;
    protected IntVector[] _snapPtrs;
    protected VertexPartition _p;
    protected BigIntVector _localIds;
    protected BitVector _initialValues;
    protected BigIntVector _times;
    protected IntVector _sortedVertexTimeIndices;

    public static ArrayList<Field> createSnapshotFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new Field("local_id", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("initial_value", new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null));
        arrayList.add(new Field("time", new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null));
        arrayList.add(new Field("sorted_vertex_time_index", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null));
        return arrayList;
    }

    public void init(VectorSchemaRoot vectorSchemaRoot, VertexPartition vertexPartition) {
        this._root = vectorSchemaRoot;
        this._p = vertexPartition;
        ArrayList<VersionedProperty> arrayList = vertexPartition._apm._raphtoryPartition._propertySchema.versionedVertexProperties();
        this._nProperties = arrayList.size();
        if (this._nProperties > 0) {
            this._snapPtrs = new IntVector[this._nProperties];
        }
        if (this._root == null) {
            this._localIds = null;
            this._initialValues = null;
            this._times = null;
            this._sortedVertexTimeIndices = null;
            for (int i = 0; i < this._nProperties; ++i) {
                this._snapPtrs[i] = null;
            }
        } else {
            this._localIds = (BigIntVector)vectorSchemaRoot.getVector("local_id");
            this._initialValues = (BitVector)vectorSchemaRoot.getVector("initial_value");
            this._times = (BigIntVector)vectorSchemaRoot.getVector("time");
            this._sortedVertexTimeIndices = (IntVector)vectorSchemaRoot.getVector("sorted_vertex_time_index");
            for (int i = 0; i < this._nProperties; ++i) {
                this._snapPtrs[i] = (IntVector)this._root.getVector("prop_prev_ptr_" + i);
            }
        }
    }

    public Schema createVertexSnapshotSchema() {
        ArrayList<VersionedProperty> arrayList = this._p._apm._raphtoryPartition._propertySchema.versionedVertexProperties();
        if (arrayList != null && arrayList.size() > 0) {
            return null;
        }
        ArrayList<Field> arrayList2 = VertexSnapshotStore.createSnapshotFields();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VersionedProperty versionedProperty = arrayList.get(i);
            Field field = new Field("prop_prev_ptr_" + i, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
            arrayList2.add(field);
        }
        return new Schema(arrayList2);
    }

    public int takeSnapshot(long l, int n, boolean bl, long l2, VertexPartition vertexPartition) {
        int n2 = this._maxRow++;
        this._localIds.setSafe(n2, l);
        this._initialValues.setSafe(n2, bl ? 1 : 0);
        this._times.setSafe(n2, l2);
        for (int i = 0; i < this._nProperties; ++i) {
            this._snapPtrs[i].setSafe(n2, vertexPartition.getPropertyPrevPtrByRow(i, n));
        }
        return n2;
    }
}

