/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.VertexEdgeIndexArrowStore;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.implementation.VertexPartitionManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class VertexEdgeIndexPartition {
    private static final ThreadLocal<IntArrayList> _tmpListTL = ThreadLocal.withInitial(IntArrayList::new);
    private static final ThreadLocal<VertexDstEdgeComparator> _vertexTimeCmpTL = ThreadLocal.withInitial(() -> new VertexDstEdgeComparator());
    private static final ThreadLocal<VertexDstEdgeWindowComparator> _timeVertexWindowComparatorTL = ThreadLocal.withInitial(VertexDstEdgeWindowComparator::new);
    private final int _partitionId;
    private final VertexPartition _avp;
    private final VertexPartitionManager _apm;
    private VertexEdgeIndexArrowStore _index;
    private VectorSchemaRoot _indexRO;
    private ArrowFileReader _indexReader;
    private boolean _modified = false;
    private boolean _sorted = false;

    public VertexEdgeIndexPartition(int n, VertexPartition vertexPartition) {
        this._partitionId = n;
        this._avp = vertexPartition;
        this._apm = vertexPartition._apm;
        this._index = new VertexEdgeIndexArrowStore();
    }

    public void initialize() {
        this._indexRO = VectorSchemaRoot.create((Schema)VertexEdgeIndexArrowStore.INDEX_SCHEMA, (BufferAllocator)this._apm.getAllocator());
        this._index.init(this._partitionId, this._indexRO);
    }

    public void addEdgeIndexRecord(int n, long l, long l2, boolean bl) {
        this._modified = true;
        this._sorted = false;
        this._index.addIndexRecord(n, l, l2, bl);
    }

    public int getVertexRowIdByIndexRowId(int n) {
        return this._index._sortedIndex.get(n);
    }

    public long getEdgeIdByRowId(int n) {
        return this._index._edgeIds.get(n);
    }

    public boolean getDstIsGlobalByRowId(int n) {
        return this._index._isGlobals.get(n) != 0;
    }

    public void close() {
        this.clearReader();
    }

    public void saveToFile() {
        try {
            if (!this._sorted) {
                this.sortVertexEdgeIndex();
            }
            if (this._modified) {
                this._indexRO.syncSchema();
                this._indexRO.setRowCount(this._index._maxRow);
                File file = this._apm.getEdgeIndexFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._indexRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            this._sorted = true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public boolean loadFromFile() {
        File file = this._apm.getEdgeIndexFile(this._partitionId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._indexReader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._apm.getAllocator(), this._apm.getCompressionFactory());
            this._indexReader.loadNextBatch();
            this._indexRO = this._indexReader.getVectorSchemaRoot();
            this._indexRO.syncSchema();
            this._index.init(this._partitionId, this._indexRO);
            this._index._maxRow = this._indexRO.getRowCount();
            this._modified = false;
            this._sorted = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._index != null) {
                this._index.init(-1, null);
            }
            if (this._indexRO != null) {
                this._indexRO.clear();
                this._indexRO.close();
                this._indexRO = null;
            }
            if (this._indexReader != null) {
                this._indexReader.close();
                this._indexReader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    protected void sortVertexEdgeIndex() {
        int n = this._index._maxRow;
        IntArrayList intArrayList = _tmpListTL.get();
        intArrayList.clear();
        intArrayList.ensureCapacity(n);
        intArrayList.size(n);
        int[] nArray = intArrayList.elements();
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        VertexDstEdgeComparator vertexDstEdgeComparator = _vertexTimeCmpTL.get();
        vertexDstEdgeComparator.init(this);
        intArrayList.sort((IntComparator)vertexDstEdgeComparator);
        IntVector intVector = this._index._sortedIndex;
        intVector.setValueCount(n);
        for (int i = 0; i < n; ++i) {
            intVector.set(i, nArray[i]);
        }
        this._sorted = true;
    }

    protected void findMatchingEdges(EdgeIterator.MatchingEdgesIterator matchingEdgesIterator) {
        if (this._indexRO == null) {
            matchingEdgesIterator._firstIndex = -1;
            matchingEdgesIterator._lastIndex = -1;
            return;
        }
        if (this._indexRO.getRowCount() != this._index._maxRow) {
            this._indexRO.setRowCount(this._index._maxRow);
        }
        if (!this._sorted) {
            this.sortVertexEdgeIndex();
        }
        VertexDstEdgeWindowComparator vertexDstEdgeWindowComparator = _timeVertexWindowComparatorTL.get();
        vertexDstEdgeWindowComparator.init(matchingEdgesIterator._vertexRowId, this._index._vertexRowIds, this._index._sortedIndex, this._index._dstVertexIds, matchingEdgesIterator._dstVertexId);
        int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._index._sortedIndex, (VectorValueComparator)vertexDstEdgeWindowComparator, null, (int)0);
        if (n < 0) {
            matchingEdgesIterator._firstIndex = -1;
            matchingEdgesIterator._lastIndex = -1;
        } else {
            int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._index._sortedIndex, (VectorValueComparator)vertexDstEdgeWindowComparator, null, (int)0);
            matchingEdgesIterator._firstIndex = n;
            matchingEdgesIterator._lastIndex = n2;
        }
    }

    protected static class VertexDstEdgeWindowComparator
    extends VectorValueComparator<IntVector> {
        private int _vertexRowId;
        private long _dstVertexId;
        private IntVector _vertexRowIds;
        private IntVector _sortedIndices;
        private BigIntVector _dstVertexIds;

        protected VertexDstEdgeWindowComparator() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l) {
            this._vertexRowId = n;
            this._vertexRowIds = intVector;
            this._sortedIndices = intVector2;
            this._dstVertexIds = bigIntVector;
            this._dstVertexId = l;
        }

        public int compare(int n, int n2) {
            return this.compareNotNull(n, n2);
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            int n4 = this._vertexRowIds.get(n3);
            if (this._vertexRowId != n4) {
                return this._vertexRowId < n4 ? -1 : 1;
            }
            long l = this._dstVertexIds.get(n3);
            if (l < this._dstVertexId) {
                return 1;
            }
            if (l > this._dstVertexId) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new VertexDstEdgeWindowComparator();
        }
    }

    private static class VertexDstEdgeComparator
    implements IntComparator {
        private VertexEdgeIndexPartition _veip;
        private IntVector _vertexRowIds;
        private BigIntVector _dstVertexIds;
        private BigIntVector _edgeIds;

        private VertexDstEdgeComparator() {
        }

        public void init(VertexEdgeIndexPartition vertexEdgeIndexPartition) {
            this._veip = vertexEdgeIndexPartition;
            this._vertexRowIds = vertexEdgeIndexPartition._index._vertexRowIds;
            this._dstVertexIds = vertexEdgeIndexPartition._index._dstVertexIds;
            this._edgeIds = vertexEdgeIndexPartition._index._edgeIds;
        }

        public int compare(int n, int n2) {
            long l;
            int n3;
            int n4 = this._vertexRowIds.get(n);
            int n5 = Integer.compare(n4, n3 = this._vertexRowIds.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l2 = this._dstVertexIds.get(n);
            n5 = Long.compare(l2, l = this._dstVertexIds.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l3 = this._edgeIds.get(n);
            long l4 = this._edgeIds.get(n2);
            return Long.compare(l3, l4);
        }
    }
}

