/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import org.apache.arrow.vector.holders.NullableVarCharHolder;

public class RaphtoryStringUtils {
    private static final ThreadLocal<NullableVarCharHolder> _vcHolderTL = ThreadLocal.withInitial(NullableVarCharHolder::new);
    private static final ThreadLocal<StringBuilder> _tmpSBTL = ThreadLocal.withInitial(StringBuilder::new);
    private static final ThreadLocal<byte[]> _tmpBytesTL = ThreadLocal.withInitial(() -> new byte[1024]);
    private static final ThreadLocal<char[]> _tmpCharsTL = ThreadLocal.withInitial(() -> new char[1024]);

    public static NullableVarCharHolder getTmpVarCharHolder() {
        return _vcHolderTL.get();
    }

    public static StringBuilder getTmpStringBuilder() {
        return _tmpSBTL.get();
    }

    public static byte[] copy(StringBuilder stringBuilder, NullableVarCharHolder nullableVarCharHolder) {
        int n = stringBuilder.length();
        byte[] byArray = _tmpBytesTL.get();
        char[] cArray = _tmpCharsTL.get();
        if (n > cArray.length) {
            cArray = new char[n + 16];
            _tmpCharsTL.set(cArray);
        }
        stringBuilder.getChars(0, n, cArray, 0);
        int n2 = RaphtoryStringUtils.getUTF8Length(cArray, 0, n);
        if (n2 > byArray.length) {
            byArray = new byte[n2 + 16];
            _tmpBytesTL.set(byArray);
        }
        RaphtoryStringUtils.copyUTF8(cArray, 0, n, byArray, 0);
        nullableVarCharHolder.start = 0;
        nullableVarCharHolder.end = n2;
        nullableVarCharHolder.buffer = null;
        nullableVarCharHolder.isSet = 1;
        return byArray;
    }

    public static void copy(NullableVarCharHolder nullableVarCharHolder, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        if (nullableVarCharHolder.isSet == 0) {
            return;
        }
        int n = nullableVarCharHolder.end - nullableVarCharHolder.start;
        byte[] byArray = _tmpBytesTL.get();
        if (n > byArray.length) {
            byArray = new byte[n + 16];
            _tmpBytesTL.set(byArray);
        }
        nullableVarCharHolder.buffer.getBytes((long)nullableVarCharHolder.start, byArray, 0, n);
        int n2 = RaphtoryStringUtils.getUTF8CharLength(byArray, 0, n);
        char[] cArray = _tmpCharsTL.get();
        if (n2 > cArray.length) {
            cArray = new char[n2 + 16];
            _tmpCharsTL.set(cArray);
        }
        RaphtoryStringUtils.utf8ToChars(byArray, 0, n, cArray);
        stringBuilder.append(cArray, 0, n2);
    }

    public static int getUTF8Length(char[] cArray, int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i + n];
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++n3;
                continue;
            }
            n3 += 2;
        }
        return n3;
    }

    public static int copyUTF8(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i + n];
            if (c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n3++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >>> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xE0 | c >>> 12 & 0xF);
            byArray[n3++] = (byte)(0x80 | c >>> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | c >>> 0 & 0x3F);
        }
        return n3;
    }

    public static int getUTF8CharLength(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            if (by > 0) {
                ++n3;
                continue;
            }
            int n4 = by & 0xE0;
            if (n4 == 192) {
                ++n3;
                ++i;
                continue;
            }
            if (n4 == 224) {
                ++n3;
                i += 2;
                continue;
            }
            throw new IllegalArgumentException("Invalid utf8 sequence: " + Integer.toHexString(n4));
        }
        return n3;
    }

    public static int utf8ToChars(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by;
            byte by2 = byArray[i];
            if (by2 > 0) {
                cArray[n3++] = (char)by2;
                continue;
            }
            int n4 = by2 & 0xE0;
            if (n4 == 192) {
                if (((by = byArray[++i]) & 0xC0) != 128) {
                    throw new IllegalArgumentException("UTF Format");
                }
                cArray[n3++] = (char)((by2 & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if (n4 == 224) {
                by = byArray[++i];
                byte by3 = byArray[++i];
                if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                    throw new IllegalArgumentException("UTF Format");
                }
                cArray[n3++] = (char)((by2 & 0xF) << 12 | (by & 0x3F) << 6 | by3 & 0x3F);
                continue;
            }
            throw new IllegalArgumentException("UTF Format");
        }
        return n3;
    }
}

