/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.io.File;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LocalEntityIdStore {
    private final int _nMaps;
    private final int _mapSize;
    private final Long2LongOpenHashMap[] _map;
    private final ReadWriteLock[] _locks;
    private final int _nMaps_mask;

    public LocalEntityIdStore(String string, int n, int n2) {
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                System.err.println("Exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }
        n = RaphtoryArrowPartition.roundUpToPowerOfTwo(n);
        n2 = RaphtoryArrowPartition.roundUpToPowerOfTwo(n2);
        this._nMaps = n;
        this._mapSize = n2;
        int n3 = Integer.numberOfTrailingZeros(n);
        int n4 = 1 << n3;
        this._nMaps_mask = n4 - 1;
        this._map = new Long2LongOpenHashMap[this._nMaps];
        this._locks = new ReentrantReadWriteLock[this._nMaps];
        for (int i = 0; i < this._nMaps; ++i) {
            this._map[i] = new Long2LongOpenHashMap(this._mapSize);
            this._map[i].defaultReturnValue(-1L);
            this._locks[i] = new ReentrantReadWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLocalNodeId(long l) {
        int n = (int)(l & (long)this._nMaps_mask);
        Long2LongOpenHashMap long2LongOpenHashMap = this._map[n];
        this._locks[n].readLock().lock();
        try {
            long l2 = long2LongOpenHashMap.get(l);
            if (l2 != -1L) {
                long l3 = l2;
                return l3;
            }
        }
        finally {
            this._locks[n].readLock().unlock();
        }
        return -1L;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setMapping(long l, long l2) {
        int n = (int)(l & (long)this._nMaps_mask);
        Long2LongOpenHashMap long2LongOpenHashMap = this._map[n];
        this._locks[n].writeLock().lock();
        try {
            long l3 = long2LongOpenHashMap.putIfAbsent(l, l2);
            return l3;
        }
        finally {
            this._locks[n].writeLock().unlock();
        }
    }
}

