/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgeHistoryIterator;
import com.raphtory.arrowcore.implementation.EdgeHistoryStore;
import com.raphtory.arrowcore.implementation.EdgeIterator;
import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;

public class EdgeHistoryPartition {
    private static final ThreadLocal<IntArrayList> _tmpListTL = ThreadLocal.withInitial(IntArrayList::new);
    private static final ThreadLocal<HistoryTimeComparatorIAL> _timeCmpTL = ThreadLocal.withInitial(() -> new HistoryTimeComparatorIAL());
    private static final ThreadLocal<HistoryEdgeTimeComparatorIAL> _edgeTimeCmpTL = ThreadLocal.withInitial(() -> new HistoryEdgeTimeComparatorIAL());
    private static final ThreadLocal<WindowComparator> _windowComparatorTL = ThreadLocal.withInitial(() -> new WindowComparator());
    private static final ThreadLocal<EdgeWindowComparator> _edgeWindowComparatorTL = ThreadLocal.withInitial(() -> new EdgeWindowComparator());
    private final int _partitionId;
    private final EdgePartition _aep;
    private final EdgePartitionManager _aepm;
    private final EdgeHistoryStore _history;
    private VectorSchemaRoot _historyRO;
    private ArrowFileReader _historyReader;
    private boolean _modified = false;
    private boolean _sorted = false;

    public EdgeHistoryPartition(int n, EdgePartition edgePartition) {
        this._partitionId = n;
        this._aep = edgePartition;
        this._aepm = edgePartition._aepm;
        this._history = new EdgeHistoryStore();
    }

    public void initialize() {
        this._historyRO = VectorSchemaRoot.create((Schema)EdgeHistoryStore.HISTORY_SCHEMA, (BufferAllocator)this._aepm.getAllocator());
        this._history.init(this._historyRO);
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public int addHistory(int n, long l, boolean bl, boolean bl2, int n2) {
        this._modified = true;
        this._sorted = false;
        int n3 = this._history.addHistory(n, l, bl, bl2, n2);
        return n3;
    }

    protected boolean getIsAliveByRowId(int n) {
        return this._history._states.get(n) != 0;
    }

    protected int getEdgeLocalRowIdByHistoryRowId(int n) {
        return this._history._edgeRowIds.get(n);
    }

    public void close() {
        this.clearReader();
    }

    public void saveToFile() {
        try {
            if (!this._sorted) {
                this.sortHistoryTimes();
            }
            if (this._modified) {
                this._historyRO.syncSchema();
                this._historyRO.setRowCount(this._history._maxRow);
                File file = this._aepm.getHistoryFile(this._partitionId);
                ArrowFileWriter arrowFileWriter = new ArrowFileWriter(this._historyRO, null, (WritableByteChannel)new FileOutputStream(file).getChannel());
                arrowFileWriter.start();
                arrowFileWriter.writeBatch();
                arrowFileWriter.end();
                arrowFileWriter.close();
            }
            this._modified = false;
            this._sorted = true;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public boolean loadFromFile() {
        File file = this._aepm.getHistoryFile(this._partitionId);
        if (!file.exists()) {
            return false;
        }
        try {
            this.clearReader();
            this._historyReader = new ArrowFileReader((SeekableByteChannel)new FileInputStream(file).getChannel(), this._aepm.getAllocator(), this._aepm.getCompressionFactory());
            this._historyReader.loadNextBatch();
            this._historyRO = this._historyReader.getVectorSchemaRoot();
            this._historyRO.syncSchema();
            this._history.init(this._historyRO);
            this._history._maxRow = this._historyRO.getRowCount();
            this._modified = false;
            this._sorted = true;
            return true;
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void clearReader() {
        try {
            if (this._history != null) {
                this._history.init(null);
            }
            if (this._historyRO != null) {
                this._historyRO.clear();
                this._historyRO.close();
                this._historyRO = null;
            }
            if (this._historyReader != null) {
                this._historyReader.close();
                this._historyReader = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    private void sortHistoryTimes() {
        int n;
        int n2 = this._history._maxRow;
        IntArrayList intArrayList = _tmpListTL.get();
        intArrayList.clear();
        intArrayList.ensureCapacity(n2);
        intArrayList.size(n2);
        int[] nArray = intArrayList.elements();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i;
        }
        HistoryEdgeTimeComparatorIAL historyEdgeTimeComparatorIAL = _edgeTimeCmpTL.get();
        historyEdgeTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyEdgeTimeComparatorIAL);
        IntVector intVector = this._history._sortedEdgeTimeIndices;
        intVector.setValueCount(n2);
        for (n = 0; n < n2; ++n) {
            intVector.set(n, nArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        HistoryTimeComparatorIAL historyTimeComparatorIAL = _timeCmpTL.get();
        historyTimeComparatorIAL.init(this);
        intArrayList.sort((IntComparator)historyTimeComparatorIAL);
        IntVector intVector2 = this._history._sortedTimeIndices;
        intVector2.setValueCount(n2);
        for (int i = 0; i < n2; ++i) {
            intVector2.set(i, nArray[i]);
        }
        this._sorted = true;
    }

    protected void isAliveAtWithWindowVector(EdgeIterator.WindowedEdgeIterator windowedEdgeIterator) {
        if (this._historyRO == null) {
            windowedEdgeIterator._firstIndex = -1;
            windowedEdgeIterator._lastIndex = -1;
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        WindowComparator windowComparator = _windowComparatorTL.get();
        windowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedEdgeIterator._minTime, windowedEdgeIterator._maxTime);
        int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
        if (n < 0) {
            windowedEdgeIterator._firstIndex = -1;
            windowedEdgeIterator._lastIndex = -1;
            return;
        }
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
        windowedEdgeIterator._firstIndex = n;
        windowedEdgeIterator._lastIndex = n2;
    }

    public int getHistoryRowIdBySortedIndex(int n) {
        int n2 = this._history._sortedTimeIndices.get(n);
        return n2;
    }

    public int getHistoryRowIdBySortedEdgeIndex(int n) {
        int n2 = this._history._sortedEdgeTimeIndices.get(n);
        return n2;
    }

    public long getLowestTime() {
        if (this._history._maxRow == 0) {
            return Long.MAX_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        int n = this._history._sortedTimeIndices.get(0);
        return this._history._times.get(n);
    }

    public long getHighestTime() {
        if (this._history._maxRow == 0) {
            return Long.MIN_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        int n = this._history._sortedTimeIndices.get(this._history._maxRow - 1);
        return this._history._times.get(n);
    }

    public long getNHistoryItems() {
        int n = this._history._maxRow;
        return n + 1;
    }

    public long getEdgeMinHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MIN_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
        edgeWindowComparator.init(n, this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedEdgeTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MIN_VALUE;
    }

    public long getEdgeMaxHistoryTime(int n) {
        if (this._historyRO == null) {
            return Long.MAX_VALUE;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
        edgeWindowComparator.init(n, this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, Long.MIN_VALUE, Long.MAX_VALUE);
        int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
        if (n2 >= 0) {
            int n3 = this._history._sortedEdgeTimeIndices.get(n2);
            return this._history._times.get(n3);
        }
        return Long.MAX_VALUE;
    }

    protected void findHistory(EdgeHistoryIterator.WindowedEdgeHistoryIterator windowedEdgeHistoryIterator) {
        if (this._historyRO == null) {
            windowedEdgeHistoryIterator._firstIndex = -1;
            windowedEdgeHistoryIterator._lastIndex = -1;
            return;
        }
        if (this._historyRO.getRowCount() != this._history._maxRow) {
            this._historyRO.setRowCount(this._history._maxRow);
        }
        if (!this._sorted) {
            this.sortHistoryTimes();
        }
        if (windowedEdgeHistoryIterator._edgeId == -1L) {
            WindowComparator windowComparator = _windowComparatorTL.get();
            windowComparator.init(this._history._sortedTimeIndices, this._history._times, windowedEdgeHistoryIterator._minTime, windowedEdgeHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
            if (n < 0) {
                windowedEdgeHistoryIterator._firstIndex = -1;
                windowedEdgeHistoryIterator._lastIndex = -1;
            } else {
                int n2 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedTimeIndices, (VectorValueComparator)windowComparator, null, (int)0);
                windowedEdgeHistoryIterator._firstIndex = n;
                windowedEdgeHistoryIterator._lastIndex = n2;
            }
        } else {
            EdgeWindowComparator edgeWindowComparator = _edgeWindowComparatorTL.get();
            edgeWindowComparator.init(this._aepm.getRowId(windowedEdgeHistoryIterator._edgeId), this._history._edgeRowIds, this._history._sortedEdgeTimeIndices, this._history._times, windowedEdgeHistoryIterator._minTime, windowedEdgeHistoryIterator._maxTime);
            int n = VectorRangeSearcher.getFirstMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
            if (n < 0) {
                windowedEdgeHistoryIterator._firstIndex = -1;
                windowedEdgeHistoryIterator._lastIndex = -1;
            } else {
                int n3 = VectorRangeSearcher.getLastMatch((ValueVector)this._history._sortedEdgeTimeIndices, (VectorValueComparator)edgeWindowComparator, null, (int)0);
                windowedEdgeHistoryIterator._firstIndex = n;
                windowedEdgeHistoryIterator._lastIndex = n3;
            }
        }
    }

    public EdgeHistoryStore getHistoryStore() {
        return this._history;
    }

    private static class EdgeWindowComparator
    extends VectorValueComparator<IntVector> {
        private int _edgeRowId;
        private long _minTime;
        private long _maxTime;
        private IntVector _rowIds;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private EdgeWindowComparator() {
        }

        public void init(int n, IntVector intVector, IntVector intVector2, BigIntVector bigIntVector, long l, long l2) {
            this._edgeRowId = n;
            this._rowIds = intVector;
            this._sortedIndices = intVector2;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            int n4 = this._rowIds.get(n3);
            if (this._edgeRowId != n4) {
                return this._edgeRowId < n4 ? -1 : 1;
            }
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new EdgeWindowComparator();
        }
    }

    private static class WindowComparator
    extends VectorValueComparator<IntVector> {
        private long _minTime;
        private long _maxTime;
        private IntVector _sortedIndices;
        private BigIntVector _creationTimes;

        private WindowComparator() {
        }

        public void init(IntVector intVector, BigIntVector bigIntVector, long l, long l2) {
            this._sortedIndices = intVector;
            this._creationTimes = bigIntVector;
            this._minTime = l;
            this._maxTime = l2;
        }

        public int compare(int n, int n2) {
            boolean bl = ((IntVector)this.vector2).isNull(n2);
            if (!bl) {
                return this.compareNotNull(n, n2);
            }
            return 1;
        }

        public int compareNotNull(int n, int n2) {
            int n3 = this._sortedIndices.get(n2);
            long l = this._creationTimes.get(n3);
            if (l < this._minTime) {
                return 1;
            }
            if (l > this._maxTime) {
                return -1;
            }
            return 0;
        }

        public VectorValueComparator<IntVector> createNew() {
            return new WindowComparator();
        }
    }

    private static class HistoryEdgeTimeComparatorIAL
    implements IntComparator {
        private EdgeHistoryPartition _aehpm;
        private BigIntVector _times;
        private IntVector _edgeRowIds;

        private HistoryEdgeTimeComparatorIAL() {
        }

        public void init(EdgeHistoryPartition edgeHistoryPartition) {
            this._aehpm = edgeHistoryPartition;
            this._times = edgeHistoryPartition._history._times;
            this._edgeRowIds = edgeHistoryPartition._history._edgeRowIds;
        }

        public int compare(int n, int n2) {
            int n3;
            int n4 = this._edgeRowIds.get(n);
            int n5 = Integer.compare(n4, n3 = this._edgeRowIds.get(n2));
            if (n5 != 0) {
                return n5;
            }
            long l = this._times.get(n);
            long l2 = this._times.get(n2);
            n5 = Long.compare(l, l2);
            return n5;
        }
    }

    private static class HistoryTimeComparatorIAL
    implements IntComparator {
        private EdgeHistoryPartition _aehpm;
        private BigIntVector _times;

        private HistoryTimeComparatorIAL() {
        }

        public void init(EdgeHistoryPartition edgeHistoryPartition) {
            this._aehpm = edgeHistoryPartition;
            this._times = edgeHistoryPartition._history._times;
        }

        public int compare(int n, int n2) {
            long l = this._times.get(n);
            long l2 = this._times.get(n2);
            int n3 = Long.compare(l, l2);
            return n3;
        }
    }
}

