"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return waf_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new waf_generated_1.RosInstance(this, id, {
            prefessionalService: props.prefessionalService,
            bigScreen: props.bigScreen,
            extDomainPackage: props.extDomainPackage,
            logTime: props.logTime,
            renewalStatus: props.renewalStatus,
            renewPeriod: props.renewPeriod,
            period: props.period,
            exclusiveIpPackage: props.exclusiveIpPackage,
            logStorage: props.logStorage,
            subscriptionType: props.subscriptionType,
            extBandwidth: props.extBandwidth,
            wafLog: props.wafLog,
            packageCode: props.packageCode,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrEndDate = rosInstance.attrEndDate;
        this.attrInDebt = rosInstance.attrInDebt;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrRemainDay = rosInstance.attrRemainDay;
        this.attrSubscriptionType = rosInstance.attrSubscriptionType;
        this.attrTrial = rosInstance.attrTrial;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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