# Getting Started
Define the ssh keys that the server should accept and start the container in
the foreground
```
cat ~/.ssh/id_*.pub > /tmp/rsync_authorized_keys
./bin/run
```

Sync some files
```
rsync -e "ssh -p 11101" -avzh ./ rsync@localhost:test/
```

Check it out
```
ls -la /tmp/stuff
```


# Using Android
I have an S7 phone, so I'll be using `s7` as a short name in the following code
blocks.

First, install Termux

- https://fossdroid.com/a/termux.html
- https://play.google.com/store/apps/details?id=com.termux

Then launch Termux to install rsync and openssh, generate an SSH key and run
rsync
```
pkg install openssh rsync
ssh-keygen -t ed25519 -N '' -C 's7' -f ~/.ssh/id_ed25519
cat ~/.ssh/id_ed25519
```

Configure ingress to accept key, e.g.
```
echo 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAII4H0QB57b5raAWYseLEVS+zCDYAAVuy5mEXrAzwV47n s7' >> /tmp/rsync_authorized_keys
```

Configure SSH client with a host alias called `r`
```
install -m 700 -d ~/.ssh/masters
cat <<'EOF' > ~/.ssh/config
Host r
  Hostname f
  User rsync
  Port 11101
EOF
```

Sync audio:
```
cat <<'EOF' > sync-audio
rsync -avzh /storage/3861-3433/audio/ r:audio/
EOF
chmod +x sync-audio
./sync-audio
```


# Design
The container must write data as the user given by `$RSYNC_USER`.

Volumes:

- `/tmp/data` contains the data
- `/tmp/save` contains
  - `ssh_host_ed25519_key` which is generated by the entrypoint
- `/tmp/authorized_keys` gets copied to `/home/rsync/.ssh/authorized_keys`

See `./bin/run` for details.
