"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EngineVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * OpenSearch version
 */
class EngineVersion {
    /**
     * @param version engine version identifier
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom ElasticSearch version
     * @param version custom version number
     */
    static elasticsearch(version) { return new EngineVersion(`Elasticsearch_${version}`); }
    /**
     * Custom OpenSearch version
     * @param version custom version number
     */
    static openSearch(version) { return new EngineVersion(`OpenSearch_${version}`); }
}
exports.EngineVersion = EngineVersion;
_a = JSII_RTTI_SYMBOL_1;
EngineVersion[_a] = { fqn: "@aws-cdk/aws-opensearchservice.EngineVersion", version: "1.193.0" };
/** AWS Elasticsearch 1.5 */
EngineVersion.ELASTICSEARCH_1_5 = EngineVersion.elasticsearch('1.5');
/** AWS Elasticsearch 2.3 */
EngineVersion.ELASTICSEARCH_2_3 = EngineVersion.elasticsearch('2.3');
/** AWS Elasticsearch 5.1 */
EngineVersion.ELASTICSEARCH_5_1 = EngineVersion.elasticsearch('5.1');
/** AWS Elasticsearch 5.3 */
EngineVersion.ELASTICSEARCH_5_3 = EngineVersion.elasticsearch('5.3');
/** AWS Elasticsearch 5.5 */
EngineVersion.ELASTICSEARCH_5_5 = EngineVersion.elasticsearch('5.5');
/** AWS Elasticsearch 5.6 */
EngineVersion.ELASTICSEARCH_5_6 = EngineVersion.elasticsearch('5.6');
/** AWS Elasticsearch 6.0 */
EngineVersion.ELASTICSEARCH_6_0 = EngineVersion.elasticsearch('6.0');
/** AWS Elasticsearch 6.2 */
EngineVersion.ELASTICSEARCH_6_2 = EngineVersion.elasticsearch('6.2');
/** AWS Elasticsearch 6.3 */
EngineVersion.ELASTICSEARCH_6_3 = EngineVersion.elasticsearch('6.3');
/** AWS Elasticsearch 6.4 */
EngineVersion.ELASTICSEARCH_6_4 = EngineVersion.elasticsearch('6.4');
/** AWS Elasticsearch 6.5 */
EngineVersion.ELASTICSEARCH_6_5 = EngineVersion.elasticsearch('6.5');
/** AWS Elasticsearch 6.7 */
EngineVersion.ELASTICSEARCH_6_7 = EngineVersion.elasticsearch('6.7');
/** AWS Elasticsearch 6.8 */
EngineVersion.ELASTICSEARCH_6_8 = EngineVersion.elasticsearch('6.8');
/** AWS Elasticsearch 7.1 */
EngineVersion.ELASTICSEARCH_7_1 = EngineVersion.elasticsearch('7.1');
/** AWS Elasticsearch 7.4 */
EngineVersion.ELASTICSEARCH_7_4 = EngineVersion.elasticsearch('7.4');
/** AWS Elasticsearch 7.7 */
EngineVersion.ELASTICSEARCH_7_7 = EngineVersion.elasticsearch('7.7');
/** AWS Elasticsearch 7.8 */
EngineVersion.ELASTICSEARCH_7_8 = EngineVersion.elasticsearch('7.8');
/** AWS Elasticsearch 7.9 */
EngineVersion.ELASTICSEARCH_7_9 = EngineVersion.elasticsearch('7.9');
/** AWS Elasticsearch 7.10 */
EngineVersion.ELASTICSEARCH_7_10 = EngineVersion.elasticsearch('7.10');
/** AWS OpenSearch 1.0 */
EngineVersion.OPENSEARCH_1_0 = EngineVersion.openSearch('1.0');
/** AWS OpenSearch 1.1 */
EngineVersion.OPENSEARCH_1_1 = EngineVersion.openSearch('1.1');
/** AWS OpenSearch 1.2 */
EngineVersion.OPENSEARCH_1_2 = EngineVersion.openSearch('1.2');
//# sourceMappingURL=data:application/json;base64,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