# Generated by Django 2.2.18 on 2021-03-24 09:54

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields
import djangoldp_community.permissions


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_community', '0004_auto_20210323_1121'),
    ]

    operations = [
        migrations.CreateModel(
            name='CommunityProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('shortDescription', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('description', models.TextField(blank=True, default='', null=True)),
                ('phone', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('email', models.EmailField(blank=True, default='', max_length=254, null=True)),
                ('website', models.URLField(blank=True, default='', null=True)),
                ('tweeter', models.URLField(blank=True, default='', null=True)),
                ('facebook', models.URLField(blank=True, default='', null=True)),
                ('linkedin', models.URLField(blank=True, default='', null=True)),
                ('instagram', models.URLField(blank=True, default='', null=True)),
                ('picture1', models.URLField(blank=True, default='', null=True)),
                ('picture2', models.URLField(blank=True, default='', null=True)),
                ('picture3', models.URLField(blank=True, default='', null=True)),
                ('community', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='profile', to='djangoldp_community.Community')),
            ],
            options={
                'verbose_name': 'community profile',
                'verbose_name_plural': 'communitie profiles',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:CommunityProfile',
                'container_path': 'community-profiles/',
                'permission_classes': [djangoldp_community.permissions.CommunityProfilePermissions],
                'serializer_fields': ['@id', 'community', 'shortDescription', 'description', 'phone', 'email', 'website', 'tweeterfacebook', 'linkedin', 'instagram', 'picture1', 'picture2', 'picture3'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'superuser_perms': ['view'],
            },
        ),
        migrations.CreateModel(
            name='CommunityAddress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('address', models.CharField(blank=True, default='', max_length=254, null=True)),
                ('lat', models.DecimalField(blank=True, decimal_places=12, max_digits=15, null=True, verbose_name='Latitude')),
                ('lon', models.DecimalField(blank=True, decimal_places=12, max_digits=15, null=True, verbose_name='Longitude')),
                ('community', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='addresses', to='djangoldp_community.Community')),
            ],
            options={
                'verbose_name': 'community address',
                'verbose_name_plural': 'communitie addresses',
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'rdf_type': 'sib:CommunityAddress',
                'container_path': 'community-addresses/',
                'permission_classes': [djangoldp_community.permissions.CommunityProfilePermissions],
                'serializer_fields': ['@id', 'community', 'address', 'lat', 'lon'],
                'depth': 0,
                'anonymous_perms': ['view'],
                'authenticated_perms': ['inherit'],
                'superuser_perms': ['view'],
            },
        ),
    ]
