# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SignHashDocument(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, data=None, document_id=None, format=None, name=None, remaining_signatures=None, revisions=None, signature_type=None):
        """
        SignHashDocument - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'data': 'str',
            'document_id': 'str',
            'format': 'str',
            'name': 'str',
            'remaining_signatures': 'str',
            'revisions': 'list[Revision]',
            'signature_type': 'str'
        }

        self.attribute_map = {
            'data': 'data',
            'document_id': 'documentId',
            'format': 'format',
            'name': 'name',
            'remaining_signatures': 'remainingSignatures',
            'revisions': 'revisions',
            'signature_type': 'signatureType'
        }

        self._data = data
        self._document_id = document_id
        self._format = format
        self._name = name
        self._remaining_signatures = remaining_signatures
        self._revisions = revisions
        self._signature_type = signature_type

    @property
    def data(self):
        """
        Gets the data of this SignHashDocument.
        

        :return: The data of this SignHashDocument.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this SignHashDocument.
        

        :param data: The data of this SignHashDocument.
        :type: str
        """

        self._data = data

    @property
    def document_id(self):
        """
        Gets the document_id of this SignHashDocument.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :return: The document_id of this SignHashDocument.
        :rtype: str
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """
        Sets the document_id of this SignHashDocument.
        Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.

        :param document_id: The document_id of this SignHashDocument.
        :type: str
        """

        self._document_id = document_id

    @property
    def format(self):
        """
        Gets the format of this SignHashDocument.
        

        :return: The format of this SignHashDocument.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """
        Sets the format of this SignHashDocument.
        

        :param format: The format of this SignHashDocument.
        :type: str
        """

        self._format = format

    @property
    def name(self):
        """
        Gets the name of this SignHashDocument.
        

        :return: The name of this SignHashDocument.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SignHashDocument.
        

        :param name: The name of this SignHashDocument.
        :type: str
        """

        self._name = name

    @property
    def remaining_signatures(self):
        """
        Gets the remaining_signatures of this SignHashDocument.
        

        :return: The remaining_signatures of this SignHashDocument.
        :rtype: str
        """
        return self._remaining_signatures

    @remaining_signatures.setter
    def remaining_signatures(self, remaining_signatures):
        """
        Sets the remaining_signatures of this SignHashDocument.
        

        :param remaining_signatures: The remaining_signatures of this SignHashDocument.
        :type: str
        """

        self._remaining_signatures = remaining_signatures

    @property
    def revisions(self):
        """
        Gets the revisions of this SignHashDocument.
        

        :return: The revisions of this SignHashDocument.
        :rtype: list[Revision]
        """
        return self._revisions

    @revisions.setter
    def revisions(self, revisions):
        """
        Sets the revisions of this SignHashDocument.
        

        :param revisions: The revisions of this SignHashDocument.
        :type: list[Revision]
        """

        self._revisions = revisions

    @property
    def signature_type(self):
        """
        Gets the signature_type of this SignHashDocument.
        

        :return: The signature_type of this SignHashDocument.
        :rtype: str
        """
        return self._signature_type

    @signature_type.setter
    def signature_type(self, signature_type):
        """
        Sets the signature_type of this SignHashDocument.
        

        :param signature_type: The signature_type of this SignHashDocument.
        :type: str
        """

        self._signature_type = signature_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
