# Copyright Contributors to the Packit project.
# SPDX-License-Identifier: MIT

# valid section names as defined in build/parseSpec.c in RPM source
SECTION_NAMES = {
    "package",
    "prep",
    "generate_buildrequires",
    "conf",
    "build",
    "install",
    "check",
    "clean",
    "preun",
    "postun",
    "pretrans",
    "posttrans",
    "pre",
    "post",
    "files",
    "changelog",
    "description",
    "triggerpostun",
    "triggerprein",
    "triggerun",
    "triggerin",
    "trigger",
    "verifyscript",
    "sepolicy",
    "filetriggerin",
    "filetrigger",
    "filetriggerun",
    "filetriggerpostun",
    "transfiletriggerin",
    "transfiletrigger",
    "transfiletriggerun",
    "transfiletriggerpostun",
    "end",
    "patchlist",
    "sourcelist",
}

SIMPLE_SCRIPT_SECTIONS = {
    "conf",
    "generate_buildrequires",
    "build",
    "install",
    "check",
    "clean",
}

SCRIPT_SECTIONS = {
    "pre",
    "post",
    "preun",
    "postun",
    "pretrans",
    "posttrans",
    "preuntrans",
    "postuntrans",
    "verifyscript",
    "triggerprein",
    "trigger",
    "triggerin",
    "triggerun",
    "triggerpostun",
    "filetrigger",
    "filetriggerin",
    "filetriggerun",
    "filetriggerpostun",
    "transfiletrigger",
    "transfiletriggerin",
    "transfiletriggerun",
    "transfiletriggerpostun",
}

# valid tag names as defined in build/parsePreamble.c in RPM source
TAG_NAMES = {
    "name",
    "version",
    "release",
    "epoch",
    "summary",
    "license",
    "distribution",
    "disturl",
    "vendor",
    "group",
    "packager",
    "url",
    "vcs",
    "source",
    "patch",
    "nosource",
    "nopatch",
    "excludearch",
    "exclusivearch",
    "excludeos",
    "exclusiveos",
    "icon",
    "provides",
    "requires",
    "recommends",
    "suggests",
    "supplements",
    "enhances",
    "prereq",
    "conflicts",
    "obsoletes",
    "prefixes",
    "prefix",
    "buildroot",
    "buildarchitectures",
    "buildarch",
    "buildconflicts",
    "buildprereq",
    "buildrequires",
    "autoreqprov",
    "autoreq",
    "autoprov",
    "docdir",
    "disttag",
    "bugurl",
    "translationurl",
    "upstreamreleases",
    "orderwithrequires",
    "removepathpostfixes",
    "modularitylabel",
}

# tags that can optionally have an argument (language or qualifier)
TAGS_WITH_ARG = {
    "summary",
    "group",
    "requires",
    "prereq",
    "orderwithrequires",
}

# canonical architecture names as defined in rpmrc.in in RPM source
ARCH_NAMES = {
    "aarch64",
    "alpha",
    "alphaev5",
    "alphaev56",
    "alphaev6",
    "alphaev67",
    "alphapca56",
    "amd64",
    "armv3l",
    "armv4b",
    "armv4l",
    "armv5tejl",
    "armv5tel",
    "armv5tl",
    "armv6hl",
    "armv6l",
    "armv7hl",
    "armv7hnl",
    "armv7l",
    "armv8hl",
    "armv8l",
    "atariclone",
    "atarist",
    "atariste",
    "ataritt",
    "athlon",
    "em64t",
    "falcon",
    "geode",
    "hades",
    "i370",
    "i386",
    "i486",
    "i586",
    "i686",
    "ia32e",
    "ia64",
    "IP",
    "loongarch64",
    "m68k",
    "m68kmint",
    "milan",
    "mips",
    "mips64",
    "mips64el",
    "mips64r6",
    "mips64r6el",
    "mipsel",
    "mipsr6",
    "mipsr6el",
    "pentium3",
    "pentium4",
    "ppc",
    "ppc32dy4",
    "ppc64",
    "ppc64iseries",
    "ppc64le",
    "ppc64p7",
    "ppc64pseries",
    "ppc8260",
    "ppc8560",
    "ppciseries",
    "ppcpseries",
    "riscv",
    "riscv64",
    "rs6000",
    "s390",
    "s390x",
    "sh",
    "sh3",
    "sh4",
    "sh4a",
    "sparc",
    "sparc64",
    "sparc64v",
    "sparcv8",
    "sparcv9",
    "sparcv9v",
    "sun4",
    "sun4c",
    "sun4d",
    "sun4m",
    "sun4u",
    "x86_64",
    "xtensa",
}
