/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.plotters;

import java.awt.Graphics2D;
import kg.apc.charting.ChartSettings;
import kg.apc.charting.plotters.AbstractRowPlotter;
import org.apache.jorphan.gui.NumberRenderer;

public class LineRowPlotter
extends AbstractRowPlotter {
    public LineRowPlotter(ChartSettings chartSettings, NumberRenderer labelRenderer) {
        super(chartSettings, labelRenderer);
        this.allowMarkers = true;
    }

    @Override
    protected void processPoint(Graphics2D g2d, int granulation) {
        if (this.chartSettings.getLineWidth() == 0.0f) {
            return;
        }
        boolean valid = this.isChartPointValid(this.x, this.y);
        if (this.mustDrawFirstZeroingLine && valid) {
            this.mustDrawFirstZeroingLine = false;
            this.prevX = this.x;
        }
        if (this.prevX >= 0 && valid) {
            if (this.prevY >= this.chartRect.y && this.y >= this.chartRect.y) {
                g2d.drawLine(this.prevX, this.prevY, this.x, this.y);
            } else if (this.prevY >= this.chartRect.y && this.y < this.chartRect.y) {
                int x1 = (this.x - this.prevX) * (this.chartRect.y - this.prevY) / (this.y - this.prevY) + this.prevX;
                g2d.drawLine(this.prevX, this.prevY, x1, this.chartRect.y);
            } else if (this.prevY < this.chartRect.y && this.y >= this.chartRect.y) {
                int x1 = (this.x - this.prevX) * (this.chartRect.y - this.prevY) / (this.y - this.prevY) + this.prevX;
                g2d.drawLine(x1, this.chartRect.y, this.x, this.y);
            }
        }
    }
}

