from dataclasses import dataclass
from typing import List, Optional
from edgescan.data.types.object import Object

import datetime


@dataclass(frozen=True)
class Vulnerability(Object):
    altered_score: bool
    asset_id: int
    asset_name: str
    confidence: int
    created_at: datetime.datetime
    updated_at: datetime.datetime
    cves: List[str]
    cvss_score: Optional[float]
    cvss_vector: Optional[str]
    cvss_version: Optional[str]
    cvss_v2_score: Optional[float]
    cvss_v2_vector: Optional[str]
    date_opened: datetime.datetime
    date_closed: datetime.datetime
    definition_id: int
    id: int
    label: Optional[str]
    last_pci_exception: Optional[str]
    layer: str
    location: str
    location_specifier_id: Optional[int]
    name: str
    pci_compliance_status: str
    risk: int
    severity: int
    status: str
    threat: int

    @property
    def create_time(self) -> datetime.datetime:
        return self.created_at

    @property
    def update_time(self) -> datetime.datetime:
        return self.updated_at

    @property
    def open_time(self) -> datetime.datetime:
        return self.date_opened

    @property
    def close_time(self) -> datetime.datetime:
        return self.date_closed

    def affects_pci_compliance(self) -> bool:
        return self.pci_compliance_status == 'fail'

    def is_network_layer_vulnerability(self) -> bool:
        return self.layer == 'network'

    def is_application_layer_vulnerability(self) -> bool:
        return self.layer == 'application'
