// Copyright (c) 2015-2016, Massachusetts Institute of Technology
// Copyright (c) 2016-2017 Sandia Corporation
// Copyright (c) 2017 NTESS, LLC.

// This file is part of the Compressed Continuous Computation (C3) Library
// Author: Alex A. Gorodetsky 
// Contact: alex@alexgorodetsky.com

// All rights reserved.

// Redistribution and use in source and binary forms, with or without modification, 
// are permitted provided that the following conditions are met:

// 1. Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer.

// 2. Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution.

// 3. Neither the name of the copyright holder nor the names of its contributors 
//    may be used to endorse or promote products derived from this software 
//    without specific prior written permission.

// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//Code



#include "legquadrules.h" 
#include <string.h> 
 
static const double w2[2] = {0.4999999999999999,0.4999999999999999};
static const double pts2[2] = {-0.5773502691896258,0.5773502691896258};

static const double w3[3] = {0.2777777777777777,0.4444444444444443,0.2777777777777778};
static const double pts3[3] = {-0.7745966692414835,0.0000000000000000,0.7745966692414834};

static const double w4[4] = {0.1739274225687271,0.3260725774312732,0.3260725774312730,0.1739274225687270};
static const double pts4[4] = {-0.8611363115940526,-0.3399810435848564,0.3399810435848562,0.8611363115940527};

static const double w5[5] = {0.1184634425280946,0.2393143352496834,0.2844444444444444,0.2393143352496834,0.1184634425280944};
static const double pts5[5] = {-0.9061798459386639,-0.5384693101056831,0.0000000000000000,0.5384693101056830,0.9061798459386639};

static const double w6[6] = {0.0856622461895853,0.1803807865240693,0.2339569672863452,0.2339569672863459,0.1803807865240693,0.0856622461895852};
static const double pts6[6] = {-0.9324695142031521,-0.6612093864662645,-0.2386191860831970,0.2386191860831970,0.6612093864662645,0.9324695142031523};

static const double w7[7] = {0.0647424830844348,0.1398526957446384,0.1909150252525594,0.2089795918367343,0.1909150252525595,0.1398526957446383,0.0647424830844349};
static const double pts7[7] = {-0.9491079123427584,-0.7415311855993945,-0.4058451513773971,-0.0000000000000001,0.4058451513773972,0.7415311855993946,0.9491079123427585};

static const double w8[8] = {0.0506142681451882,0.1111905172266873,0.1568533229389437,0.1813418916891811,0.1813418916891812,0.1568533229389436,0.1111905172266873,0.0506142681451883};
static const double pts8[8] = {-0.9602898564975362,-0.7966664774136267,-0.5255324099163288,-0.1834346424956498,0.1834346424956501,0.5255324099163288,0.7966664774136268,0.9602898564975361};

static const double w9[9] = {0.0406371941807873,0.0903240803474288,0.1303053482014676,0.1561735385200012,0.1651196775006297,0.1561735385200011,0.1303053482014678,0.0903240803474287,0.0406371941807873};
static const double pts9[9] = {-0.9681602395076260,-0.8360311073266355,-0.6133714327005904,-0.3242534234038089,0.0000000000000001,0.3242534234038087,0.6133714327005906,0.8360311073266357,0.9681602395076261};

static const double w10[10] = {0.0333356721543442,0.0747256745752904,0.1095431812579906,0.1346333596549982,0.1477621123573762,0.1477621123573765,0.1346333596549982,0.1095431812579911,0.0747256745752904,0.0333356721543442};
static const double pts10[10] = {-0.9739065285171714,-0.8650633666889846,-0.6794095682990245,-0.4333953941292472,-0.1488743389816313,0.1488743389816314,0.4333953941292471,0.6794095682990244,0.8650633666889844,0.9739065285171716};

static const double w11[11] = {0.0278342835580868,0.0627901847324523,0.0931451054638672,0.1165968822959954,0.1314022722551235,0.1364625433889503,0.1314022722551232,0.1165968822959957,0.0931451054638668,0.0627901847324522,0.0278342835580869};
static const double pts11[11] = {-0.9782286581460568,-0.8870625997680955,-0.7301520055740495,-0.5190961292068119,-0.2695431559523451,-0.0000000000000002,0.2695431559523450,0.5190961292068119,0.7301520055740494,0.8870625997680954,0.9782286581460571};

static const double w12[12] = {0.0235876681932558,0.0534696629976594,0.0800391642716730,0.1015837133615329,0.1167462682691773,0.1245735229067018,0.1245735229067015,0.1167462682691769,0.1015837133615330,0.0800391642716730,0.0534696629976593,0.0235876681932558};
static const double pts12[12] = {-0.9815606342467195,-0.9041172563704749,-0.7699026741943048,-0.5873179542866177,-0.3678314989981800,-0.1252334085114689,0.1252334085114689,0.3678314989981802,0.5873179542866174,0.7699026741943049,0.9041172563704750,0.9815606342467191};

static const double w13[13] = {0.0202420023826576,0.0460607499188645,0.0694367551098935,0.0890729903809729,0.1039080237684444,0.1131415901314486,0.1162757766154369,0.1131415901314481,0.1039080237684443,0.0890729903809731,0.0694367551098938,0.0460607499188642,0.0202420023826577};
static const double pts13[13] = {-0.9841830547185887,-0.9175983992229778,-0.8015780907333097,-0.6423493394403406,-0.4484927510364470,-0.2304583159551345,0.0000000000000001,0.2304583159551350,0.4484927510364468,0.6423493394403401,0.8015780907333099,0.9175983992229778,0.9841830547185885};

static const double w14[14] = {0.0175597301658761,0.0400790435798799,0.0607592853439519,0.0786015835790966,0.0927691987389688,0.1025992318606476,0.1076319267315791,0.1076319267315788,0.1025992318606479,0.0927691987389690,0.0786015835790969,0.0607592853439514,0.0400790435798807,0.0175597301658758};
static const double pts14[14] = {-0.9862838086968120,-0.9284348836635736,-0.8272013150697651,-0.6872929048116855,-0.5152486363581543,-0.3191123689278899,-0.1080549487073440,0.1080549487073438,0.3191123689278899,0.5152486363581543,0.6872929048116854,0.8272013150697650,0.9284348836635736,0.9862838086968125};

static const double w15[15] = {0.0153766209980584,0.0351830237440544,0.0535796102335859,0.0697853389630773,0.0831346029084970,0.0930805000077811,0.0992157426635560,0.1012891209627804,0.0992157426635557,0.0930805000077809,0.0831346029084974,0.0697853389630772,0.0535796102335862,0.0351830237440544,0.0153766209980584};
static const double pts15[15] = {-0.9879925180204855,-0.9372733924007061,-0.8482065834104273,-0.7244177313601702,-0.5709721726085388,-0.3941513470775633,-0.2011940939974347,-0.0000000000000001,0.2011940939974343,0.3941513470775630,0.5709721726085389,0.7244177313601704,0.8482065834104273,0.9372733924007057,0.9879925180204858};

static const double w16[16] = {0.0135762297058773,0.0311267619693235,0.0475792558412463,0.0623144856277671,0.0747979944082882,0.0845782596975014,0.0913017075224623,0.0947253052275341,0.0947253052275344,0.0913017075224619,0.0845782596975014,0.0747979944082887,0.0623144856277674,0.0475792558412462,0.0311267619693240,0.0135762297058772};
static const double pts16[16] = {-0.9894009349916495,-0.9445750230732327,-0.8656312023878319,-0.7554044083550033,-0.6178762444026443,-0.4580167776572275,-0.2816035507792588,-0.0950125098376372,0.0950125098376372,0.2816035507792590,0.4580167776572271,0.6178762444026440,0.7554044083550031,0.8656312023878318,0.9445750230732326,0.9894009349916498};

static const double w17[17] = {0.0120741514342740,0.0277297646869937,0.0425180741585895,0.0559419235967019,0.0675681842342630,0.0770228805384049,0.0840020510782251,0.0882813526834962,0.0897232351781032,0.0882813526834961,0.0840020510782252,0.0770228805384053,0.0675681842342623,0.0559419235967022,0.0425180741585899,0.0277297646869937,0.0120741514342739};
static const double pts17[17] = {-0.9905754753144171,-0.9506755217687678,-0.8802391537269858,-0.7815140038968015,-0.6576711592166908,-0.5126905370864770,-0.3512317634538764,-0.1784841814958480,-0.0000000000000002,0.1784841814958474,0.3512317634538763,0.5126905370864772,0.6576711592166911,0.7815140038968015,0.8802391537269861,0.9506755217687676,0.9905754753144173};

static const double w18[18] = {0.0108080067632417,0.0248572744474849,0.0382128651274447,0.0504710220531435,0.0612776033557392,0.0703214573353252,0.0773423375631326,0.0821382418729163,0.0845711914815718,0.0845711914815718,0.0821382418729163,0.0773423375631326,0.0703214573353255,0.0612776033557394,0.0504710220531432,0.0382128651274444,0.0248572744474851,0.0108080067632418};
static const double pts18[18] = {-0.9915651684209309,-0.9558239495713976,-0.8926024664975554,-0.8037049589725227,-0.6916870430603530,-0.5597708310739472,-0.4117511614628424,-0.2518862256915053,-0.0847750130417348,0.0847750130417355,0.2518862256915057,0.4117511614628421,0.5597708310739474,0.6916870430603529,0.8037049589725225,0.8926024664975556,0.9558239495713975,0.9915651684209305};

static const double w19[19] = {0.0097308941148634,0.0224071133828498,0.0345222713688204,0.0457450108112249,0.0557833227736673,0.0643769812696680,0.0713033510868030,0.0763830210329302,0.0794844216969770,0.0805272249243916,0.0794844216969771,0.0763830210329298,0.0713033510868033,0.0643769812696676,0.0557833227736671,0.0457450108112252,0.0345222713688210,0.0224071133828492,0.0097308941148632};
static const double pts19[19] = {-0.9924068438435842,-0.9602081521348296,-0.9031559036148177,-0.8227146565371428,-0.7209661773352295,-0.6005453046616810,-0.4645707413759610,-0.3165640999636299,-0.1603586456402254,-0.0000000000000001,0.1603586456402255,0.3165640999636300,0.4645707413759608,0.6005453046616810,0.7209661773352292,0.8227146565371426,0.9031559036148178,0.9602081521348299,0.9924068438435844};

static const double w20[20] = {0.0088070035695761,0.0203007149001932,0.0313360241670550,0.0416383707883523,0.0509650599086204,0.0590972659807592,0.0658443192245883,0.0710480546591912,0.0745864932363019,0.0763766935653628,0.0763766935653633,0.0745864932363020,0.0710480546591911,0.0658443192245881,0.0590972659807592,0.0509650599086208,0.0416383707883521,0.0313360241670543,0.0203007149001934,0.0088070035695762};
static const double pts20[20] = {-0.9931285991850950,-0.9639719272779141,-0.9122344282513262,-0.8391169718222189,-0.7463319064601507,-0.6360536807265150,-0.5108670019508273,-0.3737060887154193,-0.2277858511416449,-0.0765265211334970,0.0765265211334976,0.2277858511416457,0.3737060887154197,0.5108670019508270,0.6360536807265151,0.7463319064601507,0.8391169718222188,0.9122344282513259,0.9639719272779139,0.9931285991850950};

static const double w21[21] = {0.0080086141288873,0.0184768948854261,0.0285672127134281,0.0380500568141902,0.0467222117280171,0.0543986495835740,0.0609157080268645,0.0661344693166687,0.0699436973955365,0.0722622019949850,0.0730405668248452,0.0722622019949849,0.0699436973955368,0.0661344693166687,0.0609157080268644,0.0543986495835743,0.0467222117280170,0.0380500568141894,0.0285672127134291,0.0184768948854260,0.0080086141288873};
static const double pts21[21] = {-0.9937521706203895,-0.9672268385663063,-0.9200993341504012,-0.8533633645833174,-0.7684399634756779,-0.6671388041974121,-0.5516188358872202,-0.4243421202074387,-0.2880213168024012,-0.1455618541608955,-0.0000000000000001,0.1455618541608949,0.2880213168024014,0.4243421202074388,0.5516188358872199,0.6671388041974120,0.7684399634756781,0.8533633645833174,0.9200993341504008,0.9672268385663064,0.9937521706203897};

static const double w22[22] = {0.0073139976491362,0.0168874507924071,0.0261466675763415,0.0348982342122603,0.0429708031085335,0.0502070722214404,0.0564661480402697,0.0616261884052561,0.0655867523935311,0.0682707491730077,0.0696259364278158,0.0696259364278162,0.0682707491730074,0.0655867523935312,0.0616261884052566,0.0564661480402698,0.0502070722214399,0.0429708031085336,0.0348982342122604,0.0261466675763418,0.0168874507924073,0.0073139976491360};
static const double pts22[22] = {-0.9942945854823989,-0.9700604978354284,-0.9269567721871741,-0.8658125777203003,-0.7878168059792082,-0.6944872631866829,-0.5876404035069115,-0.4693558379867571,-0.3419358208920846,-0.2078604266882216,-0.0697392733197226,0.0697392733197219,0.2078604266882211,0.3419358208920846,0.4693558379867571,0.5876404035069118,0.6944872631866829,0.7878168059792083,0.8658125777203004,0.9269567721871741,0.9700604978354289,0.9942945854823991};

static const double w23[23] = {0.0067059297435710,0.0154940029284895,0.0240188358655424,0.0321162107042633,0.0396407058883594,0.0464578830300178,0.0524460457322704,0.0574983201112058,0.0615245421533647,0.0644528610940411,0.0662310197023482,0.0668272860930527,0.0662310197023482,0.0644528610940410,0.0615245421533648,0.0574983201112057,0.0524460457322708,0.0464578830300178,0.0396407058883596,0.0321162107042623,0.0240188358655428,0.0154940029284895,0.0067059297435708};
static const double pts23[23] = {-0.9947693349975520,-0.9725424712181151,-0.9329710868260164,-0.8767523582704415,-0.8048884016188400,-0.7186613631319498,-0.6196098757636460,-0.5095014778460073,-0.3903010380302909,-0.2641356809703448,-0.1332568242984663,-0.0000000000000002,0.1332568242984660,0.2641356809703449,0.3903010380302909,0.5095014778460076,0.6196098757636460,0.7186613631319502,0.8048884016188397,0.8767523582704415,0.9329710868260160,0.9725424712181150,0.9947693349975520};

static const double w24[24] = {0.0061706148999935,0.0142656943144669,0.0221387194087100,0.0296492924577182,0.0366732407055403,0.0430950807659767,0.0488093260520571,0.0537221350579827,0.0577528340268628,0.0608352364639017,0.0629187281734138,0.0639690976733762,0.0639690976733762,0.0629187281734140,0.0608352364639015,0.0577528340268631,0.0537221350579827,0.0488093260520571,0.0430950807659767,0.0366732407055400,0.0296492924577184,0.0221387194087102,0.0142656943144666,0.0061706148999939};
static const double pts24[24] = {-0.9951872199970215,-0.9747285559713099,-0.9382745520027330,-0.8864155270044012,-0.8200019859739028,-0.7401241915785545,-0.6480936519369753,-0.5454214713888395,-0.4337935076260454,-0.3150426796961637,-0.1911188674736164,-0.0640568928626056,0.0640568928626054,0.1911188674736169,0.3150426796961636,0.4337935076260452,0.5454214713888393,0.6480936519369753,0.7401241915785546,0.8200019859739028,0.8864155270044011,0.9382745520027326,0.9747285559713097,0.9951872199970212};

static const double w25[25] = {0.0056968992505132,0.0131774933075158,0.0204695783506536,0.0274523479879177,0.0340191669061787,0.0400703501675001,0.0455141309914818,0.0502679745335253,0.0542598122371319,0.0574291295728559,0.0597278817678920,0.0611212214951551,0.0615880268633577,0.0611212214951551,0.0597278817678924,0.0574291295728557,0.0542598122371320,0.0502679745335254,0.0455141309914818,0.0400703501675003,0.0340191669061786,0.0274523479879178,0.0204695783506530,0.0131774933075159,0.0056968992505131};
static const double pts25[25] = {-0.9955569697904982,-0.9766639214595177,-0.9429745712289743,-0.8949919978782752,-0.8334426287608336,-0.7592592630373574,-0.6735663684734684,-0.5776629302412231,-0.4730027314457153,-0.3611723058093878,-0.2438668837209886,-0.1228646926107102,-0.0000000000000000,0.1228646926107100,0.2438668837209885,0.3611723058093877,0.4730027314457150,0.5776629302412228,0.6735663684734681,0.7592592630373579,0.8334426287608342,0.8949919978782755,0.9429745712289740,0.9766639214595175,0.9955569697904981};

static const double w26[26] = {0.0052756863086714,0.0122089255463162,0.0189811916471810,0.0254879126485739,0.0316370231647874,0.0373420748828300,0.0425229471567425,0.0471069001779572,0.0510295805472128,0.0542359202642885,0.0566809082731598,0.0583302217426483,0.0591607076396313,0.0591607076396308,0.0583302217426484,0.0566809082731599,0.0542359202642879,0.0510295805472128,0.0471069001779575,0.0425229471567429,0.0373420748828296,0.0316370231647875,0.0254879126485742,0.0189811916471813,0.0122089255463157,0.0052756863086718};
static const double pts26[26] = {-0.9958857011456174,-0.9783854459564709,-0.9471590666617142,-0.9026378619843074,-0.8454459427884981,-0.7763859488206788,-0.6964272604199574,-0.6066922930176184,-0.5084407148245059,-0.4030517551234858,-0.2920048394859574,-0.1768588203568903,-0.0592300934293129,0.0592300934293135,0.1768588203568903,0.2920048394859569,0.4030517551234865,0.5084407148245064,0.6066922930176184,0.6964272604199572,0.7763859488206794,0.8454459427884983,0.9026378619843073,0.9471590666617141,0.9783854459564708,0.9958857011456168};

static const double w27[27] = {0.0048994980256472,0.0113431157980902,0.0176485268787101,0.0237247062603074,0.0294917684299168,0.0348744118831227,0.0398024338865288,0.0442115792718782,0.0480443636850146,0.0512508189088729,0.0537891428942666,0.0556262441784226,0.0567381730544825,0.0571104336894788,0.0567381730544826,0.0556262441784227,0.0537891428942669,0.0512508189088728,0.0480443636850144,0.0442115792718785,0.0398024338865285,0.0348744118831232,0.0294917684299166,0.0237247062603074,0.0176485268787097,0.0113431157980905,0.0048994980256472};
static const double pts27[27] = {-0.9961792628889885,-0.9799234759615018,-0.9509005578147048,-0.9094823206774915,-0.8562079080182945,-0.7917716390705084,-0.7170134737394238,-0.6329079719464952,-0.5405515645794573,-0.4411482517500268,-0.3359939036385089,-0.2264593654395370,-0.1139725856095301,-0.0000000000000000,0.1139725856095302,0.2264593654395368,0.3359939036385092,0.4411482517500269,0.5405515645794570,0.6329079719464951,0.7170134737394240,0.7917716390705084,0.8562079080182943,0.9094823206774914,0.9509005578147054,0.9799234759615016,0.9961792628889888};

static const double w28[28] = {0.0045621412965475,0.0105660562963857,0.0164507138911519,0.0221364673795018,0.0275536728378586,0.0326364619834997,0.0373231071172846,0.0415567086144505,0.0452858721965163,0.0484653289989655,0.0510564837890303,0.0530278829614232,0.0543555961291471,0.0550235065082374,0.0550235065082377,0.0543555961291468,0.0530278829614231,0.0510564837890300,0.0484653289989650,0.0452858721965160,0.0415567086144508,0.0373231071172845,0.0326364619834996,0.0275536728378584,0.0221364673795023,0.0164507138911522,0.0105660562963853,0.0045621412965473};
static const double pts28[28] = {-0.9964424975739538,-0.9813031653708723,-0.9542592806289378,-0.9156330263921325,-0.8658925225743954,-0.8056413709171796,-0.7356108780136320,-0.6566510940388652,-0.5697204718114018,-0.4758742249551187,-0.3762515160890789,-0.2720616276351782,-0.1645692821333809,-0.0550792898840342,0.0550792898840342,0.1645692821333806,0.2720616276351779,0.3762515160890784,0.4758742249551181,0.5697204718114021,0.6566510940388650,0.7356108780136317,0.8056413709171794,0.8658925225743955,0.9156330263921322,0.9542592806289385,0.9813031653708731,0.9964424975739550};

static const double w29[29] = {0.0042584519393730,0.0098660425280615,0.0153702461010466,0.0207010312593416,0.0257974134512492,0.0306015453285392,0.0350589666275258,0.0391191635678820,0.0427361286830863,0.0458688785696292,0.0484819170472046,0.0505456368799575,0.0520366550388646,0.0529380775486603,0.0532396908591571,0.0529380775486601,0.0520366550388645,0.0505456368799574,0.0484819170472041,0.0458688785696292,0.0427361286830863,0.0391191635678817,0.0350589666275258,0.0306015453285396,0.0257974134512492,0.0207010312593418,0.0153702461010468,0.0098660425280615,0.0042584519393732};
static const double pts29[29] = {-0.9966794422605966,-0.9825455052614132,-0.9572855957780876,-0.9211802329530584,-0.8746378049201027,-0.8181854876152527,-0.7524628517344772,-0.6782145376026866,-0.5962817971382277,-0.5075929551242275,-0.4131528881740090,-0.3140316378676396,-0.2113522861660016,-0.1062782301326796,0.0000000000000000,0.1062782301326790,0.2113522861660009,0.3140316378676399,0.4131528881740087,0.5075929551242276,0.5962817971382282,0.6782145376026867,0.7524628517344775,0.8181854876152528,0.8746378049201028,0.9211802329530586,0.9572855957780878,0.9825455052614133,0.9966794422605966};

static const double w30[30] = {0.0039840962480834,0.0092332341555453,0.0143923539416616,0.0193995962848137,0.0242013364152971,0.0287465781088094,0.0329871149410904,0.0368779873688524,0.0403779476147098,0.0434498936005418,0.0460612611188930,0.0481843685873223,0.0497967102933976,0.0508811948742026,0.0514263264467794,0.0514263264467788,0.0508811948742027,0.0497967102933980,0.0481843685873222,0.0460612611188930,0.0434498936005413,0.0403779476147101,0.0368779873688528,0.0329871149410900,0.0287465781088092,0.0242013364152973,0.0193995962848139,0.0143923539416618,0.0092332341555454,0.0039840962480834};
static const double pts30[30] = {-0.9968934840746494,-0.9836681232797473,-0.9600218649683073,-0.9262000474292742,-0.8825605357920530,-0.8295657623827684,-0.7677774321048264,-0.6978504947933157,-0.6205261829892433,-0.5366241481420203,-0.4470337695380895,-0.3527047255308783,-0.2546369261678896,-0.1538699136085835,-0.0514718425553175,0.0514718425553181,0.1538699136085838,0.2546369261678897,0.3527047255308783,0.4470337695380894,0.5366241481420200,0.6205261829892429,0.6978504947933158,0.7677774321048262,0.8295657623827685,0.8825605357920526,0.9262000474292740,0.9600218649683074,0.9836681232797471,0.9968934840746495};

static const double w31[31] = {0.0037354157896246,0.0086593103951554,0.0135045095924895,0.0182161369561931,0.0227468537636006,0.0270515412124583,0.0310873932805141,0.0348142916177050,0.0381951932993883,0.0411964958807945,0.0437883703042391,0.0459450569468207,0.0476451214561593,0.0488716676931645,0.0496125056133362,0.0498602723967134,0.0496125056133361,0.0488716676931643,0.0476451214561597,0.0459450569468209,0.0437883703042392,0.0411964958807941,0.0381951932993883,0.0348142916177053,0.0310873932805140,0.0270515412124586,0.0227468537636004,0.0182161369561927,0.0135045095924897,0.0086593103951555,0.0037354157896245};
static const double pts31[31] = {-0.9970874818194767,-0.9846859096651522,-0.9625039250929491,-0.9307569978966479,-0.8897600299482705,-0.8399203201462675,-0.7817331484166248,-0.7157767845868532,-0.6427067229242605,-0.5632491614071492,-0.4781937820449027,-0.3883859016082332,-0.2947180699817019,-0.1981211993355707,-0.0995553121523416,-0.0000000000000003,0.0995553121523412,0.1981211993355704,0.2947180699817018,0.3883859016082328,0.4781937820449025,0.5632491614071492,0.6427067229242601,0.7157767845868529,0.7817331484166247,0.8399203201462677,0.8897600299482711,0.9307569978966485,0.9625039250929499,0.9846859096651527,0.9970874818194772};

static const double w32[32] = {0.0035093050047350,0.0081371973654526,0.0126960326546313,0.0171369314565105,0.0214179490111137,0.0254990296311881,0.0293420467392677,0.0329111113881808,0.0361728970544243,0.0390969478935350,0.0416559621134735,0.0438260465022020,0.0455869393478822,0.0469221995404019,0.0478193600396371,0.0482700442573641,0.0482700442573635,0.0478193600396371,0.0469221995404022,0.0455869393478818,0.0438260465022020,0.0416559621134733,0.0390969478935358,0.0361728970544242,0.0329111113881806,0.0293420467392677,0.0254990296311881,0.0214179490111134,0.0171369314565111,0.0126960326546314,0.0081371973654531,0.0035093050047350};
static const double pts32[32] = {-0.9972638618494818,-0.9856115115452684,-0.9647622555875064,-0.9349060759377398,-0.8963211557660524,-0.8493676137325699,-0.7944837959679423,-0.7321821187402896,-0.6630442669302151,-0.5877157572407627,-0.5068999089322292,-0.4213512761306352,-0.3318686022821278,-0.2392873622521368,-0.1444719615827965,-0.0483076656877387,0.0483076656877381,0.1444719615827966,0.2392873622521369,0.3318686022821275,0.4213512761306356,0.5068999089322295,0.5877157572407626,0.6630442669302149,0.7321821187402898,0.7944837959679425,0.8493676137325703,0.8963211557660523,0.9349060759377397,0.9647622555875064,0.9856115115452680,0.9972638618494815};

static const double w33[33] = {0.0033031139237939,0.0076608507564672,0.0119577740508748,0.0161501793161646,0.0202007706658349,0.0240738714093559,0.0277354233158315,0.0311532412651587,0.0342972864093283,0.0371399274219777,0.0396561823974429,0.0418239380335193,0.0436241438094220,0.0450409793303195,0.0460619933216585,0.0466782130327978,0.0468842230801048,0.0466782130327982,0.0460619933216580,0.0450409793303191,0.0436241438094223,0.0418239380335196,0.0396561823974433,0.0371399274219773,0.0342972864093284,0.0311532412651590,0.0277354233158325,0.0240738714093556,0.0202007706658346,0.0161501793161644,0.0119577740508746,0.0076608507564670,0.0033031139237935};
static const double pts33[33] = {-0.9974246942464550,-0.9864557262306427,-0.9668229096899932,-0.9386943726111682,-0.9023167677434335,-0.8580096526765039,-0.8061623562741663,-0.7472304964495621,-0.6817319599697427,-0.6102423458363788,-0.5333899047863476,-0.4518500172724506,-0.3663392577480734,-0.2776090971524968,-0.1864392988279917,-0.0936310658547335,0.0000000000000001,0.0936310658547331,0.1864392988279915,0.2776090971524968,0.3663392577480734,0.4518500172724506,0.5333899047863475,0.6102423458363790,0.6817319599697430,0.7472304964495623,0.8061623562741663,0.8580096526765038,0.9023167677434336,0.9386943726111682,0.9668229096899927,0.9864557262306425,0.9974246942464552};

static const double w34[34] = {0.0031145702779543,0.0072250813742975,0.0112818609927476,0.0152456903192227,0.0190832968981938,0.0227628057616768,0.0262537072863392,0.0295270679137622,0.0325557607770380,0.0353146879071278,0.0377809873300162,0.0399342221698858,0.0417565498499229,0.0432328698735178,0.0443509489178472,0.0451015221853201,0.0454783701651296,0.0454783701651298,0.0451015221853202,0.0443509489178470,0.0432328698735180,0.0417565498499232,0.0399342221698857,0.0377809873300161,0.0353146879071279,0.0325557607770381,0.0295270679137620,0.0262537072863391,0.0227628057616767,0.0190832968981938,0.0152456903192233,0.0112818609927474,0.0072250813742979,0.0031145702779543};
static const double pts34[34] = {-0.9975717537908421,-0.9872278164063093,-0.9687082625333444,-0.9421623974051068,-0.9078096777183247,-0.8659346383345644,-0.8168842279009337,-0.7610648766298730,-0.6989391132162628,-0.6310217270805286,-0.5578755006697469,-0.4801065451903272,-0.3983592777586460,-0.3133110813394634,-0.2256666916164497,-0.1361523572591827,-0.0455098219531027,0.0455098219531026,0.1361523572591831,0.2256666916164493,0.3133110813394632,0.3983592777586456,0.4801065451903266,0.5578755006697467,0.6310217270805283,0.6989391132162628,0.7610648766298730,0.8168842279009340,0.8659346383345642,0.9078096777183248,0.9421623974051073,0.9687082625333441,0.9872278164063095,0.9975717537908420};

static const double w35[35] = {0.0029417167102220,0.0068254141741803,0.0106614899557417,0.0144146300544469,0.0180550579317321,0.0215542111630851,0.0248846852006767,0.0280204081061851,0.0309368359830399,0.0336111426345436,0.0360223973862800,0.0381517285777210,0.0399824711211623,0.0415002968644283,0.0426933266960495,0.0435522234985917,0.0440702652151380,0.0442433974535521,0.0440702652151373,0.0435522234985919,0.0426933266960494,0.0415002968644283,0.0399824711211621,0.0381517285777214,0.0360223973862799,0.0336111426345434,0.0309368359830402,0.0280204081061849,0.0248846852006767,0.0215542111630847,0.0180550579317318,0.0144146300544473,0.0106614899557414,0.0068254141741809,0.0029417167102216};
static const double pts35[35] = {-0.9977065690995999,-0.9879357644438514,-0.9704376160392298,-0.9453451482078276,-0.9128542613593175,-0.8732191250252223,-0.8267498990922252,-0.7738102522869125,-0.7148145015566288,-0.6502243646658904,-0.5805453447497647,-0.5063227732414884,-0.4281375415178144,-0.3466015544308134,-0.2623529412092962,-0.1760510611659900,-0.0883713432756593,-0.0000000000000002,0.0883713432756595,0.1760510611659901,0.2623529412092966,0.3466015544308146,0.4281375415178147,0.5063227732414888,0.5805453447497640,0.6502243646658904,0.7148145015566286,0.7738102522869125,0.8267498990922250,0.8732191250252223,0.9128542613593174,0.9453451482078274,0.9704376160392297,0.9879357644438513,0.9977065690996001};

static const double w36[36] = {0.0027828598321225,0.0064579736420328,0.0100907576488678,0.0136493107492847,0.0171069053851537,0.0204378754618220,0.0236175417451330,0.0266223569888802,0.0294300721226622,0.0320198986775080,0.0343726619178679,0.0364709425028268,0.0382992053229354,0.0398439144560359,0.0410936333521697,0.0420391094898309,0.0426733428696690,0.0429916378351973,0.0429916378351971,0.0426733428696697,0.0420391094898313,0.0410936333521696,0.0398439144560359,0.0382992053229351,0.0364709425028266,0.0343726619178681,0.0320198986775075,0.0294300721226623,0.0266223569888794,0.0236175417451330,0.0204378754618231,0.0171069053851537,0.0136493107492841,0.0100907576488677,0.0064579736420328,0.0027828598321224};
static const double pts36[36] = {-0.9978304624840861,-0.9885864789022125,-0.9720276910496980,-0.9482729843995074,-0.9174977745156591,-0.8799298008903972,-0.8358471669924752,-0.7855762301322066,-0.7294891715935563,-0.6680012365855209,-0.6015676581359805,-0.5306802859262451,-0.4558639444334198,-0.3776725471196891,-0.2966849953440287,-0.2135008923168655,-0.1287361038093848,-0.0430181984737083,0.0430181984737088,0.1287361038093848,0.2135008923168654,0.2966849953440281,0.3776725471196891,0.4558639444334200,0.5306802859262455,0.6015676581359806,0.6680012365855207,0.7294891715935565,0.7855762301322067,0.8358471669924756,0.8799298008903971,0.9174977745156589,0.9482729843995075,0.9720276910496978,0.9885864789022121,0.9978304624840859};

static const double w37[37] = {0.0026365286397492,0.0061193900501538,0.0095645222445418,0.0129430184952793,0.0162308199237608,0.0194048012509671,0.0224426823312189,0.0253231488274123,0.0280259939991372,0.0305322582616131,0.0328243614363756,0.0348862257778504,0.0367033886242439,0.0382631037852646,0.0395544309187649,0.0405683122542325,0.0412976361182185,0.0417372868129315,0.0418841804965694,0.0417372868129314,0.0412976361182185,0.0405683122542324,0.0395544309187651,0.0382631037852643,0.0367033886242444,0.0348862257778498,0.0328243614363760,0.0305322582616125,0.0280259939991377,0.0253231488274127,0.0224426823312185,0.0194048012509670,0.0162308199237614,0.0129430184952796,0.0095645222445420,0.0061193900501541,0.0026365286397487};
static const double pts37[37] = {-0.9979445824779136,-0.9891859632143191,-0.9734930300564864,-0.9509723432620951,-0.9217814374124637,-0.8861249621554863,-0.8442529873405559,-0.7964592005099020,-0.7430788339819653,-0.6844863091309596,-0.6210926084089244,-0.5533423918615820,-0.4817108778032057,-0.4067005093183262,-0.3288374298837073,-0.2486677927913654,-0.1667539302398521,-0.0836704089547700,0.0000000000000002,0.0836704089547698,0.1667539302398520,0.2486677927913658,0.3288374298837070,0.4067005093183262,0.4817108778032054,0.5533423918615819,0.6210926084089243,0.6844863091309600,0.7430788339819652,0.7964592005099025,0.8442529873405558,0.8861249621554864,0.9217814374124641,0.9509723432620947,0.9734930300564857,0.9891859632143193,0.9979445824779137};

static const double w38[38] = {0.0025014403748195,0.0058067223582345,0.0090782888548063,0.0122898698691165,0.0154197502725876,0.0184470407970123,0.0213515792523372,0.0241140309303797,0.0267160099551657,0.0291401995734988,0.0313704666960662,0.0333919689895702,0.0351912535334498,0.0367563462923718,0.0380768317742233,0.0391439223291054,0.0399505166217641,0.0404912468852983,0.0407625146401933,0.0407625146401925,0.0404912468852987,0.0399505166217643,0.0391439223291056,0.0380768317742227,0.0367563462923718,0.0351912535334490,0.0333919689895703,0.0313704666960667,0.0291401995734988,0.0267160099551666,0.0241140309303790,0.0213515792523373,0.0184470407970125,0.0154197502725876,0.0122898698691162,0.0090782888548068,0.0058067223582343,0.0025014403748196};
static const double pts38[38] = {-0.9980499305356881,-0.9897394542663855,-0.9748463285901539,-0.9534663309335299,-0.9257413320485843,-0.8918557390046324,-0.8520350219323622,-0.8065441676053169,-0.7556859037539707,-0.6997986803791842,-0.6392544158296818,-0.5744560210478072,-0.5058347179279311,-0.4338471694323771,-0.3589724404794346,-0.2817088097901650,-0.2025704538921165,-0.1220840253378675,-0.0407851479045784,0.0407851479045784,0.1220840253378676,0.2025704538921170,0.2817088097901652,0.3589724404794351,0.4338471694323766,0.5058347179279311,0.5744560210478070,0.6392544158296819,0.6997986803791846,0.7556859037539705,0.8065441676053172,0.8520350219323621,0.8918557390046323,0.9257413320485844,0.9534663309335297,0.9748463285901533,0.9897394542663857,0.9980499305356875};

static const double w39[39] = {0.0023764723458175,0.0055173944695822,0.0086281145468626,0.0116846924160897,0.0146674779919512,0.0175575557490657,0.0203366384239670,0.0229871505544585,0.0254923326460645,0.0278363451704581,0.0300043680442982,0.0319826940693413,0.0337588154831156,0.0353215029853043,0.0366608767071341,0.0377684686614179,0.0386372762723410,0.0392618066436855,0.0396381112841843,0.0397638110697213,0.0396381112841844,0.0392618066436853,0.0386372762723410,0.0377684686614184,0.0366608767071343,0.0353215029853046,0.0337588154831159,0.0319826940693410,0.0300043680442979,0.0278363451704579,0.0254923326460651,0.0229871505544587,0.0203366384239666,0.0175575557490654,0.0146674779919516,0.0116846924160889,0.0086281145468629,0.0055173944695820,0.0023764723458176};
static const double pts39[39] = {-0.9981473830664328,-0.9902515368546864,-0.9760987093334711,-0.9557752123246517,-0.9294091484867386,-0.8971671192929926,-0.8592529379999062,-0.8159062974301430,-0.7674012429310635,-0.7140444358945348,-0.6561732134320107,-0.5941534549572777,-0.5283772686604372,-0.4592605123091359,-0.3872401639715614,-0.3127715592481859,-0.2363255124618361,-0.1583853399978379,-0.0794438046087557,-0.0000000000000002,0.0794438046087557,0.1583853399978377,0.2363255124618357,0.3127715592481864,0.3872401639715616,0.4592605123091362,0.5283772686604371,0.5941534549572779,0.6561732134320110,0.7140444358945348,0.7674012429310635,0.8159062974301430,0.8592529379999054,0.8971671192929930,0.9294091484867383,0.9557752123246525,0.9760987093334710,0.9902515368546859,0.9981473830664329};

static const double w40[40] = {0.0022606385492665,0.0052491422655764,0.0082105291909537,0.0111229245970838,0.0139685034900116,0.0167300976412739,0.0193910839872363,0.0219354540928367,0.0243479038175362,0.0266139234919680,0.0287198845496959,0.0306531212464645,0.0324020067283005,0.0339560229076171,0.0353058236956435,0.0364432911979022,0.0373615845289842,0.0380551809503128,0.0385199090821241,0.0387529739892123,0.0387529739892124,0.0385199090821240,0.0380551809503131,0.0373615845289839,0.0364432911979020,0.0353058236956439,0.0339560229076168,0.0324020067283008,0.0306531212464645,0.0287198845496958,0.0266139234919681,0.0243479038175356,0.0219354540928366,0.0193910839872359,0.0167300976412741,0.0139685034900115,0.0111229245970833,0.0082105291909544,0.0052491422655766,0.0022606385492668};
static const double pts40[40] = {-0.9982377097105594,-0.9907262386994571,-0.9772599499837745,-0.9579168192137918,-0.9328128082786766,-0.9020988069688742,-0.8659595032122591,-0.8246122308333117,-0.7783056514265192,-0.7273182551899271,-0.6719566846141796,-0.6125538896679805,-0.5494671250951284,-0.4830758016861789,-0.4137792043716051,-0.3419940908257585,-0.2681521850072534,-0.1926975807013710,-0.1160840706752552,-0.0387724175060509,0.0387724175060506,0.1160840706752551,0.1926975807013714,0.2681521850072537,0.3419940908257588,0.4137792043716051,0.4830758016861789,0.5494671250951279,0.6125538896679802,0.6719566846141795,0.7273182551899272,0.7783056514265195,0.8246122308333117,0.8659595032122597,0.9020988069688743,0.9328128082786766,0.9579168192137920,0.9772599499837742,0.9907262386994569,0.9982377097105590};

static const double w41[41] = {0.0021530701790821,0.0049999693869529,0.0078224692039093,0.0106005316843898,0.0133179496035555,0.0159591058658494,0.0185088583517541,0.0209525975979550,0.0232763241845072,0.0254667271473088,0.0275112596212893,0.0293982104749358,0.0311167712904832,0.0326570982267636,0.0340103683804387,0.0351688303104087,0.0361258484305116,0.0368759410136116,0.0374148115881106,0.0377393735463577,0.0378477678236491,0.0377393735463581,0.0374148115881109,0.0368759410136117,0.0361258484305116,0.0351688303104091,0.0340103683804385,0.0326570982267635,0.0311167712904831,0.0293982104749363,0.0275112596212887,0.0254667271473085,0.0232763241845074,0.0209525975979552,0.0185088583517542,0.0159591058658502,0.0133179496035548,0.0106005316843898,0.0078224692039095,0.0049999693869528,0.0021530701790826};
static const double pts41[41] = {-0.9983215885747720,-0.9911671096990170,-0.9783386735610842,-0.9599068917303469,-0.9359769874978537,-0.9066859447581012,-0.8722015116924415,-0.8327212004013617,-0.7884711450474096,-0.7397048030699261,-0.6867015020349514,-0.6297648390721966,-0.5692209416102163,-0.5054165991994064,-0.4387172770514076,-0.3695050226404817,-0.2981762773418253,-0.2251396056334227,-0.1508133548639920,-0.0756232589891625,0.0000000000000002,0.0756232589891631,0.1508133548639922,0.2251396056334228,0.2981762773418247,0.3695050226404819,0.4387172770514073,0.5054165991994061,0.5692209416102163,0.6297648390721968,0.6867015020349514,0.7397048030699266,0.7884711450474098,0.8327212004013613,0.8722015116924418,0.9066859447581009,0.9359769874978540,0.9599068917303465,0.9783386735610835,0.9911671096990164,0.9983215885747715};

static const double w42[42] = {0.0020529993023245,0.0047681101508745,0.0074612218486786,0.0101139347845266,0.0127114797630563,0.0152396203498016,0.0176845355487961,0.0200328675903462,0.0222717888859828,0.0243890703964018,0.0263731478495870,0.0282131846790090,0.0298991311137935,0.0314217790225014,0.0327728121824545,0.0339448516882609,0.0349314962462970,0.0357273571325856,0.0363280876219019,0.0367304067267337,0.0369321171160866,0.0369321171160861,0.0367304067267339,0.0363280876219021,0.0357273571325857,0.0349314962462970,0.0339448516882607,0.0327728121824540,0.0314217790225012,0.0298991311137934,0.0282131846790096,0.0263731478495871,0.0243890703964011,0.0222717888859831,0.0200328675903462,0.0176845355487962,0.0152396203498021,0.0127114797630566,0.0101139347845264,0.0074612218486786,0.0047681101508741,0.0020529993023244};
static const double pts42[42] = {-0.9983996189900626,-0.9915772883408613,-0.9793425080637483,-0.9617593653382043,-0.9389235573549881,-0.9109597249041279,-0.8780205698121726,-0.8402859832618170,-0.7979620532554875,-0.7512799356894805,-0.7004945905561712,-0.6458833888692480,-0.5877445974851094,-0.5263957499311923,-0.4621719120704220,-0.3954238520429750,-0.3265161244654116,-0.2558250793428792,-0.1837368065648548,-0.1106450272085199,-0.0369489431653516,0.0369489431653522,0.1106450272085200,0.1837368065648550,0.2558250793428789,0.3265161244654117,0.3954238520429754,0.4621719120704221,0.5263957499311926,0.5877445974851095,0.6458833888692473,0.7004945905561709,0.7512799356894805,0.7979620532554875,0.8402859832618168,0.8780205698121724,0.9109597249041275,0.9389235573549880,0.9617593653382044,0.9793425080637479,0.9915772883408608,0.9983996189900621};

static const double w43[43] = {0.0019597451269218,0.0045519983187007,0.0071243782157883,0.0096599507118421,0.0121452283069193,0.0145672066307494,0.0169132460434305,0.0191711110970661,0.0213290285989912,0.0233757473771733,0.0253005963921953,0.0270935401594407,0.0287452309784556,0.0302470576249953,0.0315911902246981,0.0327706210631614,0.0337792011146827,0.0346116720968279,0.0352636938825428,0.0357318671262570,0.0360137509857108,0.0361078758468991,0.0360137509857109,0.0357318671262570,0.0352636938825424,0.0346116720968283,0.0337792011146825,0.0327706210631611,0.0315911902246982,0.0302470576249963,0.0287452309784558,0.0270935401594410,0.0253005963921949,0.0233757473771735,0.0213290285989910,0.0191711110970664,0.0169132460434302,0.0145672066307493,0.0121452283069194,0.0096599507118420,0.0071243782157881,0.0045519983187006,0.0019597451269219};
static const double pts43[43] = {-0.9984723322425082,-0.9919595575932447,-0.9802782209802555,-0.9634866130140800,-0.9416719568476383,-0.9149479072061386,-0.8834537652186172,-0.8473537162093148,-0.8068359641369385,-0.7621117471949551,-0.7134142352689564,-0.6609973137514978,-0.6051342596396005,-0.5461163166600843,-0.4842511767857344,-0.4198613760292693,-0.3532826128643041,-0.2848619980329135,-0.2149562448605182,-0.1439298095107128,-0.0721529908745858,0.0000000000000002,0.0721529908745861,0.1439298095107137,0.2149562448605185,0.2848619980329136,0.3532826128643041,0.4198613760292692,0.4842511767857350,0.5461163166600846,0.6051342596396007,0.6609973137514981,0.7134142352689571,0.7621117471949548,0.8068359641369386,0.8473537162093144,0.8834537652186167,0.9149479072061385,0.9416719568476378,0.9634866130140796,0.9802782209802551,0.9919595575932441,0.9984723322425074};

static const double w44[44] = {0.0018727024015565,0.0043502406837623,0.0068097933777898,0.0092357408684074,0.0116157409510096,0.0139378914106403,0.0161906114060353,0.0183626739069043,0.0204432561551732,0.0224219920409851,0.0242890232241758,0.0260350480458526,0.0276513677818642,0.0291299299387977,0.0304633683507810,0.0316450398666018,0.0326690574395909,0.0335303194531466,0.0342245351346834,0.0347482459307860,0.0350988427367795,0.0352745788946768,0.0352745788946771,0.0350988427367787,0.0347482459307865,0.0342245351346839,0.0335303194531471,0.0326690574395904,0.0316450398666016,0.0304633683507809,0.0291299299387975,0.0276513677818645,0.0260350480458522,0.0242890232241757,0.0224219920409845,0.0204432561551733,0.0183626739069043,0.0161906114060347,0.0139378914106410,0.0116157409510101,0.0092357408684073,0.0068097933777899,0.0043502406837622,0.0018727024015563};
static const double pts44[44] = {-0.9985402006367742,-0.9923163921385161,-0.9811518330779140,-0.9650996504224929,-0.9442395091181942,-0.9186752599841758,-0.8885342382860435,-0.8539665950047106,-0.8151445396451354,-0.7722614792487557,-0.7255310536607170,-0.6751860706661224,-0.6214773459035755,-0.5646724531854703,-0.5050543913882019,-0.4429201745254115,-0.3785793520147068,-0.3123524665027860,-0.2445694569282014,-0.1755680147755170,-0.1056919017086534,-0.0352892369641354,0.0352892369641355,0.1056919017086532,0.1755680147755168,0.2445694569282014,0.3123524665027860,0.3785793520147073,0.4429201745254120,0.5050543913882030,0.5646724531854707,0.6214773459035757,0.6751860706661219,0.7255310536607168,0.7722614792487559,0.8151445396451349,0.8539665950047103,0.8885342382860434,0.9186752599841758,0.9442395091181937,0.9650996504224930,0.9811518330779133,0.9923163921385155,0.9985402006367738};

static const double w45[45] = {0.0017913315776417,0.0041615946481093,0.0065155524957912,0.0088387676289691,0.0111199237752890,0.0133481069837890,0.0155126874672578,0.0176033461008042,0.0196101183646516,0.0215234403545824,0.0233341938591866,0.0250337496189761,0.0266140083656344,0.0280674393798933,0.0293871163594209,0.0305667504155334,0.0316007200369102,0.0324840978753617,0.0332126742249218,0.0337829770818035,0.0341922886893344,0.0344386584888309,0.0345209124146159,0.0344386584888305,0.0341922886893346,0.0337829770818038,0.0332126742249211,0.0324840978753618,0.0316007200369101,0.0305667504155329,0.0293871163594213,0.0280674393798935,0.0266140083656345,0.0250337496189764,0.0233341938591867,0.0215234403545828,0.0196101183646511,0.0176033461008045,0.0155126874672576,0.0133481069837890,0.0111199237752892,0.0088387676289687,0.0065155524957915,0.0041615946481089,0.0017913315776418};
static const double pts45[45] = {-0.9986036451819366,-0.9926499984472035,-0.9819687150345409,-0.9666083103968945,-0.9466416909956292,-0.9221639367190005,-0.8932916717532414,-0.8601624759606644,-0.8229342205020866,-0.7817843125939066,-0.7369088489454908,-0.6885216807712006,-0.6368533944532236,-0.5821502125693535,-0.5246728204629163,-0.4646951239196351,-0.4025029438585417,-0.3383926542506021,-0.2726697697523778,-0.2056474897832636,-0.1376452059832528,-0.0689869801631438,0.0000000000000001,0.0689869801631442,0.1376452059832529,0.2056474897832639,0.2726697697523777,0.3383926542506020,0.4025029438585416,0.4646951239196353,0.5246728204629162,0.5821502125693533,0.6368533944532228,0.6885216807712006,0.7369088489454904,0.7817843125939062,0.8229342205020864,0.8601624759606645,0.8932916717532420,0.9221639367190003,0.9466416909956292,0.9666083103968950,0.9819687150345406,0.9926499984472039,0.9986036451819369};

static const double w46[46] = {0.0017151504340533,0.0039849491148621,0.0062399418854946,0.0084667570039181,0.0106549993770681,0.0127946431985653,0.0148759147761012,0.0168893139995532,0.0188256526786933,0.0206760950548394,0.0224321976386590,0.0240859475508559,0.0256297990035715,0.0270567076929285,0.0283601629219956,0.0295342172977735,0.0305735138623250,0.0314733105321971,0.0322295017335695,0.0328386371338911,0.0332979373842271,0.0336053068003392,0.0337593429245179,0.0337593429245185,0.0336053068003387,0.0332979373842277,0.0328386371338907,0.0322295017335698,0.0314733105321976,0.0305735138623251,0.0295342172977729,0.0283601629219957,0.0270567076929286,0.0256297990035713,0.0240859475508566,0.0224321976386591,0.0206760950548396,0.0188256526786931,0.0168893139995533,0.0148759147761010,0.0127946431985647,0.0106549993770686,0.0084667570039183,0.0062399418854944,0.0039849491148620,0.0017151504340535};
static const double pts46[46] = {-0.9986630421338185,-0.9929623489061750,-0.9827336698041672,-0.9680213918539924,-0.9488923634460900,-0.9254337988067544,-0.8977527115339422,-0.8659753948668580,-0.8302468370660661,-0.7907300570752738,-0.7476053596156658,-0.7010695120204051,-0.6513348462019978,-0.5986282897127153,-0.5431903302618029,-0.4852739183881645,-0.4251433132828281,-0.3630728770209954,-0.2993458227018699,-0.2342529222062697,-0.1680911794671032,-0.1011624753055838,-0.0337721900160518,0.0337721900160520,0.1011624753055844,0.1680911794671032,0.2342529222062697,0.2993458227018701,0.3630728770209956,0.4251433132828286,0.4852739183881647,0.5431903302618026,0.5986282897127150,0.6513348462019977,0.7010695120204056,0.7476053596156659,0.7907300570752742,0.8302468370660658,0.8659753948668578,0.8977527115339420,0.9254337988067541,0.9488923634460898,0.9680213918539919,0.9827336698041668,0.9929623489061743,0.9986630421338180};

static const double w47[47] = {0.0016437269212642,0.0038193081479244,0.0059814242321564,0.0081176665732158,0.0102184690738345,0.0122746058298296,0.0142770753503214,0.0162171177575922,0.0180862482920878,0.0198762930612657,0.0215794243242400,0.0231881945432526,0.0246955688736807,0.0260949558900284,0.0273802363907652,0.0285457901466157,0.0295865204711694,0.0304978765043699,0.0312758731104611,0.0319171083028581,0.0324187781194728,0.0327786888832743,0.0329952667944054,0.0330675648118277,0.0329952667944050,0.0327786888832750,0.0324187781194728,0.0319171083028583,0.0312758731104612,0.0304978765043698,0.0295865204711698,0.0285457901466156,0.0273802363907655,0.0260949558900285,0.0246955688736804,0.0231881945432529,0.0215794243242397,0.0198762930612652,0.0180862482920873,0.0162171177575928,0.0142770753503216,0.0122746058298298,0.0102184690738342,0.0081176665732164,0.0059814242321568,0.0038193081479240,0.0016437269212641};
static const double pts47[47] = {-0.9987187285842120,-0.9932552109877686,-0.9834510030716235,-0.9693467873265647,-0.9510039692577082,-0.9285026930123610,-0.9019413294385256,-0.8714360157968962,-0.8371201398999016,-0.7991437541677419,-0.7576729184454383,-0.7128889734090643,-0.6649877473903326,-0.6141786999563735,-0.5606840059346645,-0.5047375838635779,-0.4465840731048553,-0.3864777640846668,-0.3246814863377359,-0.2614654592149742,-0.1971061102791118,-0.1318848665545153,-0.0660869239163559,-0.0000000000000003,0.0660869239163552,0.1318848665545147,0.1971061102791118,0.2614654592149749,0.3246814863377364,0.3864777640846672,0.4465840731048555,0.5047375838635778,0.5606840059346641,0.6141786999563734,0.6649877473903328,0.7128889734090641,0.7576729184454386,0.7991437541677420,0.8371201398999023,0.8714360157968962,0.9019413294385256,0.9285026930123609,0.9510039692577080,0.9693467873265647,0.9834510030716235,0.9932552109877686,0.9987187285842121};

static const double w48[48] = {0.0015766730261530,0.0036637769506383,0.0057386172896174,0.0077896578614718,0.0098080802286779,0.0117853804196619,0.0137132548541782,0.0155836139163990,0.0173886112823854,0.0191206755329152,0.0207725414717328,0.0223372804283468,0.0238083292462455,0.0251795177769272,0.0264450947425968,0.0275997518499920,0.0286386460502015,0.0295574198491977,0.0303522195829472,0.0310197115799462,0.0315570961431271,0.0319621192923244,0.0322330822179753,0.0323688484063419,0.0323688484063418,0.0322330822179753,0.0319621192923243,0.0315570961431266,0.0310197115799458,0.0303522195829470,0.0295574198491982,0.0286386460502015,0.0275997518499922,0.0264450947425972,0.0251795177769270,0.0238083292462455,0.0223372804283470,0.0207725414717325,0.0191206755329153,0.0173886112823849,0.0155836139163991,0.0137132548541785,0.0117853804196624,0.0098080802286777,0.0077896578614720,0.0057386172896170,0.0036637769506382,0.0015766730261526};
static const double pts48[48] = {-0.9987710072524256,-0.9935301722663504,-0.9841245837228260,-0.9705915925462471,-0.9529877031604301,-0.9313866907065540,-0.9058791367155696,-0.8765720202742477,-0.8435882616243932,-0.8070662040294426,-0.7671590325157405,-0.7240341309238147,-0.6778723796326640,-0.6288673967765133,-0.5772247260839724,-0.5231609747222329,-0.4669029047509581,-0.4086864819907169,-0.3487558862921609,-0.2873624873554553,-0.2247637903946891,-0.1612223560688917,-0.0970046992094628,-0.0323801709628695,0.0323801709628694,0.0970046992094629,0.1612223560688917,0.2247637903946892,0.2873624873554556,0.3487558862921611,0.4086864819907164,0.4669029047509585,0.5231609747222328,0.5772247260839727,0.6288673967765133,0.6778723796326639,0.7240341309238144,0.7671590325157402,0.8070662040294421,0.8435882616243933,0.8765720202742481,0.9058791367155694,0.9313866907065542,0.9529877031604304,0.9705915925462472,0.9841245837228265,0.9935301722663505,0.9987710072524260};

static const double w49[49] = {0.0015136394944613,0.0035175497950434,0.0055102755157965,0.0074810724678127,0.0094217979265445,0.0113246007937234,0.0131818094635334,0.0149859423102922,0.0167297333958108,0.0184061604815001,0.0200084728831867,0.0215302184906295,0.0229652696777979,0.0243078479439142,0.0255525471650725,0.0266943553541291,0.0277286748374021,0.0286513407650936,0.0294586378800138,0.0301473154765761,0.0307146004895965,0.0311582086600286,0.0314763537325976,0.0316677546482460,0.0317316407023959,0.0316677546482457,0.0314763537325976,0.0311582086600291,0.0307146004895965,0.0301473154765764,0.0294586378800137,0.0286513407650935,0.0277286748374019,0.0266943553541289,0.0255525471650727,0.0243078479439145,0.0229652696777979,0.0215302184906298,0.0200084728831865,0.0184061604815004,0.0167297333958107,0.0149859423102916,0.0131818094635328,0.0113246007937236,0.0094217979265444,0.0074810724678127,0.0055102755157968,0.0035175497950431,0.0015136394944616};
static const double pts49[49] = {-0.9988201506066356,-0.9937886619441677,-0.9847578959142129,-0.9717622009015555,-0.9548536586741369,-0.9341002947558104,-0.9095856558280732,-0.8814084455730088,-0.8496821198441655,-0.8145344273598550,-0.7761068943454464,-0.7345542542374025,-0.6900438244251325,-0.6427548324192379,-0.5928776941089006,-0.5406132469917260,-0.4861719414524917,-0.4297729933415765,-0.3716435012622844,-0.3120175321197483,-0.2511351786125771,-0.1892415924618135,-0.1265859972696724,-0.0634206849826870,-0.0000000000000007,0.0634206849826866,0.1265859972696718,0.1892415924618132,0.2511351786125769,0.3120175321197491,0.3716435012622850,0.4297729933415771,0.4861719414524924,0.5406132469917264,0.5928776941089007,0.6427548324192377,0.6900438244251320,0.7345542542374028,0.7761068943454466,0.8145344273598556,0.8496821198441658,0.8814084455730089,0.9095856558280734,0.9341002947558102,0.9548536586741374,0.9717622009015553,0.9847578959142131,0.9937886619441679,0.9988201506066354};

static const double w50[50] = {0.0014543112765774,0.0033798995978727,0.0052952741918256,0.0071904113807431,0.0090577803567447,0.0108901215850622,0.0126803367850063,0.0144214967902672,0.0161068641117892,0.0177299178075734,0.0192843783062937,0.0207642315450738,0.0221637521694014,0.0234775256519743,0.0247004692247334,0.0258278515347902,0.0268553109444981,0.0277788724031064,0.0285949628238640,0.0293004249066111,0.0298925293521331,0.0303689854208848,0.0307279497951584,0.0309680337103415,0.0310883083276738,0.0310883083276736,0.0309680337103419,0.0307279497951583,0.0303689854208850,0.0298925293521326,0.0293004249066109,0.0285949628238640,0.0277788724031058,0.0268553109444985,0.0258278515347908,0.0247004692247334,0.0234775256519741,0.0221637521694017,0.0207642315450741,0.0192843783062939,0.0177299178075729,0.0161068641117890,0.0144214967902677,0.0126803367850057,0.0108901215850621,0.0090577803567448,0.0071904113807429,0.0052952741918254,0.0033798995978728,0.0014543112765776};
static const double pts50[50] = {-0.9988664044200712,-0.9940319694320910,-0.9853540840480061,-0.9728643851066920,-0.9566109552428074,-0.9366566189448776,-0.9130785566557919,-0.8859679795236131,-0.8554297694299464,-0.8215820708593360,-0.7845558329003993,-0.7444943022260687,-0.7015524687068223,-0.6558964656854396,-0.6077029271849502,-0.5571583045146499,-0.5044581449074641,-0.4498063349740388,-0.3934143118975649,-0.3355002454194373,-0.2762881937795323,-0.2160072368760420,-0.1548905899981458,-0.0931747015600857,-0.0310983383271890,0.0310983383271890,0.0931747015600862,0.1548905899981459,0.2160072368760417,0.2762881937795316,0.3355002454194375,0.3934143118975648,0.4498063349740388,0.5044581449074641,0.5571583045146503,0.6077029271849501,0.6558964656854394,0.7015524687068222,0.7444943022260688,0.7845558329003991,0.8215820708593361,0.8554297694299461,0.8859679795236131,0.9130785566557916,0.9366566189448780,0.9566109552428081,0.9728643851066924,0.9853540840480058,0.9940319694320907,0.9988664044200710};

static const double w51[51] = {0.0013984035855449,0.0032501688916261,0.0050925956489109,0.0069163170032387,0.0087143573617006,0.0104799942008516,0.0122066502868906,0.0138878992970813,0.0155174856450799,0.0170893466020947,0.0185976344616300,0.0200367381427484,0.0214013039989401,0.0226862557038247,0.0238868131203118,0.0249985100750288,0.0260172109683483,0.0269391261565232,0.0277608260478695,0.0284792538601290,0.0290917369912960,0.0295959969614807,0.0299901578887517,0.0302727534673689,0.0304427324224286,0.0304994624206025,0.0304427324224284,0.0302727534673688,0.0299901578887519,0.0295959969614807,0.0290917369912963,0.0284792538601292,0.0277608260478697,0.0269391261565228,0.0260172109683486,0.0249985100750281,0.0238868131203115,0.0226862557038247,0.0214013039989405,0.0200367381427482,0.0185976344616304,0.0170893466020940,0.0155174856450795,0.0138878992970813,0.0122066502868906,0.0104799942008512,0.0087143573617007,0.0069163170032393,0.0050925956489113,0.0032501688916257,0.0013984035855453};
static const double pts51[51] = {-0.9989099908489039,-0.9942612604367530,-0.9859159917359035,-0.9739033680193239,-0.9582678486139088,-0.9390675440029626,-0.9163738623097805,-0.8902712180295274,-0.8608567111822927,-0.8282397638230650,-0.7925417120993811,-0.7538953544853757,-0.7124444575770363,-0.6683432211753700,-0.6217557046007232,-0.5728552163513041,-0.5218236693661858,-0.4688509042860411,-0.4141339832263035,-0.3578764566884093,-0.3002876063353320,-0.2415816664477986,-0.1819770269570775,-0.1216954210188889,-0.0609611001505787,0.0000000000000002,0.0609611001505785,0.1216954210188883,0.1819770269570773,0.2415816664477986,0.3002876063353319,0.3578764566884095,0.4141339832263037,0.4688509042860409,0.5218236693661857,0.5728552163513038,0.6217557046007235,0.6683432211753700,0.7124444575770363,0.7538953544853758,0.7925417120993814,0.8282397638230650,0.8608567111822926,0.8902712180295277,0.9163738623097807,0.9390675440029623,0.9582678486139086,0.9739033680193238,0.9859159917359033,0.9942612604367531,0.9989099908489038};

static const double w52[52] = {0.0013456584750235,0.0031277619814866,0.0049013172897314,0.0066575574911703,0.0083900116981507,0.0100924457539903,0.0117587567769922,0.0133829768732521,0.0149592905735723,0.0164820545448592,0.0179458174175486,0.0193453391552120,0.0206756097502801,0.0219318671295004,0.0231096141863926,0.0242046348720374,0.0252130092831712,0.0261311276919532,0.0269557034663791,0.0276837848346513,0.0283127654511844,0.0288403937262635,0.0292647808859070,0.0295844077330213,0.0297981300856240,0.0299051828726461,0.0299051828726457,0.0297981300856242,0.0295844077330214,0.0292647808859068,0.0288403937262634,0.0283127654511846,0.0276837848346518,0.0269557034663783,0.0261311276919529,0.0252130092831711,0.0242046348720376,0.0231096141863928,0.0219318671295002,0.0206756097502804,0.0193453391552121,0.0179458174175490,0.0164820545448592,0.0149592905735715,0.0133829768732518,0.0117587567769922,0.0100924457539908,0.0083900116981505,0.0066575574911706,0.0049013172897314,0.0031277619814866,0.0013456584750232};
static const double pts52[52] = {-0.9989511111039500,-0.9944775909292158,-0.9864461956515496,-0.9748838842217441,-0.9598318269330864,-0.9413438536413586,-0.9194861289164242,-0.8943368905344954,-0.8659861628460674,-0.8345354323267345,-0.8000972834304682,-0.7627949951937449,-0.7227620997499834,-0.6801419042271682,-0.6350869776952459,-0.5877586049795793,-0.5383262092858274,-0.4869667456980960,-0.4338640677187626,-0.3792082691160940,-0.3231950034348079,-0.2660247836050018,-0.2079022641563663,-0.1490355086069492,-0.0896352446489004,-0.0299141097973384,0.0299141097973390,0.0896352446489009,0.1490355086069493,0.2079022641563661,0.2660247836050019,0.3231950034348082,0.3792082691160938,0.4338640677187615,0.4869667456980963,0.5383262092858275,0.5877586049795791,0.6350869776952459,0.6801419042271675,0.7227620997499833,0.7627949951937449,0.8000972834304680,0.8345354323267345,0.8659861628460677,0.8943368905344953,0.9194861289164247,0.9413438536413589,0.9598318269330866,0.9748838842217443,0.9864461956515498,0.9944775909292159,0.9989511111039504};

static const double w53[53] = {0.0012958418602835,0.0030121381134744,0.0047206011424703,0.0064130130721199,0.0080833626283440,0.0097258605538182,0.0113348365285350,0.0129047412553789,0.0144301618089120,0.0159058392295099,0.0173266862917669,0.0186878049017417,0.0199845029217702,0.0212123103172598,0.0223669945518364,0.0234445751703748,0.0244413375163500,0.0253538455346463,0.0261789536149361,0.0269138174343658,0.0275559037619666,0.0281029991908698,0.0285532177681336,0.0289050074958566,0.0291571556811282,0.0293087931163600,0.0293593970755821,0.0293087931163600,0.0291571556811280,0.0289050074958565,0.0285532177681334,0.0281029991908698,0.0275559037619671,0.0269138174343655,0.0261789536149364,0.0253538455346468,0.0244413375163498,0.0234445751703750,0.0223669945518363,0.0212123103172600,0.0199845029217704,0.0186878049017413,0.0173266862917670,0.0159058392295095,0.0144301618089113,0.0129047412553789,0.0113348365285355,0.0097258605538184,0.0080833626283435,0.0064130130721205,0.0047206011424701,0.0030121381134742,0.0012958418602836};
static const double pts53[53] = {-0.9989899477763285,-0.9946819193080076,-0.9869470350233718,-0.9758102337149844,-0.9613096946231362,-0.9434953534644422,-0.9224286030428120,-0.8981820578754268,-0.8708392975582415,-0.8404945765458013,-0.8072524984168954,-0.7712276549255320,-0.7325442308075101,-0.6913355756013662,-0.6477437439165098,-0.6019190057137697,-0.5540193282770682,-0.5042098316571332,-0.4526622194618458,-0.3995541869539531,-0.3450688084957221,-0.2893939064516262,-0.2327214037242730,-0.1752466621553260,-0.1171678090719552,-0.0586850543002599,-0.0000000000000005,0.0586850543002590,0.1171678090719550,0.1752466621553258,0.2327214037242727,0.2893939064516264,0.3450688084957222,0.3995541869539532,0.4526622194618459,0.5042098316571337,0.5540193282770678,0.6019190057137694,0.6477437439165099,0.6913355756013668,0.7325442308075103,0.7712276549255322,0.8072524984168956,0.8404945765458012,0.8708392975582414,0.8981820578754269,0.9224286030428118,0.9434953534644419,0.9613096946231365,0.9758102337149849,0.9869470350233717,0.9946819193080071,0.9989899477763283};

static const double w54[54] = {0.0012487409178811,0.0029028055076202,0.0045496847277542,0.0061816640644236,0.0077931515179620,0.0093787638107349,0.0109332257114265,0.0124513707336044,0.0139281546552983,0.0153586712489353,0.0167381682321859,0.0180620629201919,0.0193259573910513,0.0205256530683226,0.0216571646547988,0.0227167333641383,0.0237008394032224,0.0246062136622646,0.0254298485730939,0.0261690080991494,0.0268212368237768,0.0273843681065291,0.0278565312802949,0.0282361578653131,0.0285219867793971,0.0287130685270559,0.0288087683535734,0.0288087683535735,0.0287130685270562,0.0285219867793972,0.0282361578653130,0.0278565312802950,0.0273843681065289,0.0268212368237767,0.0261690080991497,0.0254298485730939,0.0246062136622643,0.0237008394032224,0.0227167333641382,0.0216571646547983,0.0205256530683230,0.0193259573910517,0.0180620629201913,0.0167381682321860,0.0153586712489354,0.0139281546552982,0.0124513707336048,0.0109332257114261,0.0093787638107345,0.0077931515179620,0.0061816640644237,0.0045496847277547,0.0029028055076201,0.0012487409178807};
static const double pts54[54] = {-0.9990266668673407,-0.9948751170183381,-0.9874206373973433,-0.9766863288579036,-0.9627076457859240,-0.9455309751649960,-0.9252133598666518,-0.9018222862847016,-0.8754354540655689,-0.8461405159707728,-0.8140347859135674,-0.7792249153462544,-0.7418265388091845,-0.7019638897191732,-0.6597693876319832,-0.6153831983311274,-0.5689527681952093,-0.5206323343859330,-0.4705824124813823,-0.4189692632552047,-0.3659643403721914,-0.3117437208344682,-0.2564875200699977,-0.2003792936062140,-0.1436054273162563,-0.0863545182632482,-0.0288167481993416,0.0288167481993414,0.0863545182632481,0.1436054273162561,0.2003792936062139,0.2564875200699971,0.3117437208344683,0.3659643403721912,0.4189692632552042,0.4705824124813819,0.5206323343859328,0.5689527681952091,0.6153831983311273,0.6597693876319833,0.7019638897191727,0.7418265388091841,0.7792249153462538,0.8140347859135678,0.8461405159707729,0.8754354540655689,0.9018222862847017,0.9252133598666512,0.9455309751649961,0.9627076457859238,0.9766863288579033,0.9874206373973436,0.9948751170183388,0.9990266668673412};

static const double w55[55] = {0.0012041618099898,0.0027993161332806,0.0043878730535296,0.0059625803599239,0.0075182291667559,0.0090498072603646,0.0105524008340081,0.0120211940048624,0.0134514807281984,0.0148386788825806,0.0161783446130930,0.0174661864367953,0.0186980789339824,0.0198700759371686,0.0209784231588594,0.0220195702108030,0.0229901819731417,0.0238871492756009,0.0247075988557757,0.0254489025622469,0.0261086857728163,0.0266848350008030,0.0271755046649554,0.0275791230012542,0.0278943970976421,0.0281203170355423,0.0282561591248860,0.0283014882222801,0.0282561591248861,0.0281203170355423,0.0278943970976422,0.0275791230012543,0.0271755046649551,0.0266848350008028,0.0261086857728162,0.0254489025622469,0.0247075988557761,0.0238871492756000,0.0229901819731421,0.0220195702108025,0.0209784231588588,0.0198700759371690,0.0186980789339828,0.0174661864367955,0.0161783446130927,0.0148386788825810,0.0134514807281983,0.0120211940048629,0.0105524008340082,0.0090498072603643,0.0075182291667560,0.0059625803599244,0.0043878730535297,0.0027993161332802,0.0012041618099898};
static const double pts55[55] = {-0.9990614195648183,-0.9950579778474118,-0.9878689411988889,-0.9775157355039887,-0.9640313285931349,-0.9474588680412105,-0.9278514247207914,-0.9052718007440000,-0.8797923224198955,-0.8514946066171545,-0.8204692985593209,-0.7868157811276218,-0.7506418563480218,-0.7120633999866379,-0.6712039903198264,-0.6281945122499284,-0.5831727380260331,-0.5362828859083436,-0.4876751581874741,-0.4375052600371747,-0.3859339007409796,-0.3331262788900238,-0.2792515532008068,-0.2244823006478453,-0.1689939636468733,-0.1129642880593288,-0.0565727538183369,0.0000000000000002,0.0565727538183372,0.1129642880593296,0.1689939636468736,0.2244823006478457,0.2792515532008068,0.3331262788900239,0.3859339007409796,0.4375052600371747,0.4876751581874741,0.5362828859083432,0.5831727380260320,0.6281945122499282,0.6712039903198260,0.7120633999866379,0.7506418563480216,0.7868157811276223,0.8204692985593209,0.8514946066171543,0.8797923224198949,0.9052718007439997,0.9278514247207917,0.9474588680412107,0.9640313285931350,0.9775157355039892,0.9878689411988890,0.9950579778474117,0.9990614195648184};

static const double w56[56] = {0.0011619276878867,0.0027012611230080,0.0042345315816536,0.0057549121701917,0.0072575446390105,0.0087377564557004,0.0101909649412015,0.0116126757812828,0.0129984935291961,0.0143441342369112,0.0156454383736551,0.0168983835578061,0.0180990969361574,0.0192438671296238,0.0203291556923725,0.0213516080423334,0.0223080638263460,0.0231955666865009,0.0240113733968006,0.0247529623415236,0.0254180413088992,0.0260045545758711,0.0265106892620053,0.0269348809328573,0.0272758184354450,0.0275324479508811,0.0277039762516225,0.0277898731532567,0.0277898731532570,0.0277039762516226,0.0275324479508811,0.0272758184354442,0.0269348809328574,0.0265106892620058,0.0260045545758708,0.0254180413088994,0.0247529623415237,0.0240113733967998,0.0231955666865015,0.0223080638263459,0.0213516080423332,0.0203291556923726,0.0192438671296240,0.0180990969361578,0.0168983835578058,0.0156454383736552,0.0143441342369110,0.0129984935291961,0.0116126757812830,0.0101909649412008,0.0087377564557007,0.0072575446390113,0.0057549121701919,0.0042345315816541,0.0027012611230074,0.0011619276878865};
static const double pts56[56] = {-0.9990943438014657,-0.9952312260810693,-0.9882937155401611,-0.9783017091402564,-0.9652859019054904,-0.9492864795619629,-0.9303528802474965,-0.9085436204206557,-0.8839261083278274,-0.8565764337627483,-0.8265791321428818,-0.7940269228938663,-0.7590204227051290,-0.7216678344501880,-0.6820846126944700,-0.6403931068070069,-0.5967221827706632,-0.5512068248555345,-0.5039877183843815,-0.4552108148784593,-0.4050268809270914,-0.3535910321749548,-0.3010622538672209,-0.2476029094343373,-0.1933782386352754,-0.1385558468103764,-0.0833051868224356,-0.0277970352872756,0.0277970352872750,0.0833051868224351,0.1385558468103762,0.1933782386352751,0.2476029094343372,0.3010622538672203,0.3535910321749545,0.4050268809270915,0.4552108148784593,0.5039877183843821,0.5512068248555344,0.5967221827706632,0.6403931068070068,0.6820846126944705,0.7216678344501880,0.7590204227051287,0.7940269228938664,0.8265791321428816,0.8565764337627486,0.8839261083278277,0.9085436204206552,0.9303528802474964,0.9492864795619625,0.9652859019054904,0.9783017091402564,0.9882937155401614,0.9952312260810697,0.9990943438014656};

static const double w57[57] = {0.0011218769361257,0.0026082667373592,0.0040890800339103,0.0055578818661681,0.0070101353953765,0.0084414795117209,0.0098476353497445,0.0112244039453881,0.0125676754954589,0.0138734407010905,0.0151378024213468,0.0163569871831859,0.0175273563911562,0.0186454171622085,0.0197078327377402,0.0207114324354007,0.0216532211081076,0.0225303880806903,0.0233403155368209,0.0240805863308439,0.0247489912010099,0.0253435353624637,0.0258624444602587,0.0263041698645887,0.0266673932924097,0.0269510307416492,0.0271542357262490,0.0272764018023810,0.0273171643782916,0.0272764018023810,0.0271542357262496,0.0269510307416491,0.0266673932924097,0.0263041698645890,0.0258624444602587,0.0253435353624641,0.0247489912010100,0.0240805863308439,0.0233403155368211,0.0225303880806904,0.0216532211081077,0.0207114324354004,0.0197078327377399,0.0186454171622088,0.0175273563911564,0.0163569871831855,0.0151378024213470,0.0138734407010900,0.0125676754954590,0.0112244039453881,0.0098476353497443,0.0084414795117205,0.0070101353953768,0.0055578818661682,0.0040890800339107,0.0026082667373592,0.0011218769361254};
static const double pts57[57] = {-0.9991255656252626,-0.9953955236784300,-0.9886965776502221,-0.9790472267094688,-0.9664760851718871,-0.9510206264478769,-0.9327269610671014,-0.9116496785213910,-0.8878516788822212,-0.8614039832620470,-0.8323855211504388,-0.8008828945472178,-0.7669901193594503,-0.7308083447445232,-0.6924455511995176,-0.6520162282809771,-0.6096410329087153,-0.5654464292692366,-0.5195643113911876,-0.4721316095179759,-0.4232898814515645,-0.3731848900865942,-0.3219661683953782,-0.2697865731618390,-0.2168018287961240,-0.1631700625912642,-0.1090513328087881,-0.0546071510016473,-0.0000000000000002,0.0546071510016466,0.1090513328087879,0.1631700625912640,0.2168018287961243,0.2697865731618387,0.3219661683953786,0.3731848900865946,0.4232898814515638,0.4721316095179757,0.5195643113911875,0.5654464292692367,0.6096410329087151,0.6520162282809769,0.6924455511995177,0.7308083447445236,0.7669901193594497,0.8008828945472186,0.8323855211504391,0.8614039832620469,0.8878516788822212,0.9116496785213911,0.9327269610671017,0.9510206264478768,0.9664760851718867,0.9790472267094686,0.9886965776502221,0.9953955236784302,0.9991255656252627};

static const double w58[58] = {0.0010838616248137,0.0025199908063255,0.0039509869249990,0.0053707767664394,0.0067751185564946,0.0081599371174854,0.0095212327309469,0.0108550780700731,0.0121576263624819,0.0134251215909911,0.0146539090220800,0.0158404456269047,0.0169813102467080,0.0180732134335439,0.0191130069229293,0.0200976927049335,0.0210244316647915,0.0218905517668201,0.0226935557574092,0.0234311283645134,0.0241011429727089,0.0247016677544812,0.0252309712399768,0.0256875273091427,0.0260700195918350,0.0263773452631853,0.0266086182232892,0.0267631716520293,0.0268405599316671,0.0268405599316678,0.0267631716520291,0.0266086182232898,0.0263773452631854,0.0260700195918349,0.0256875273091430,0.0252309712399766,0.0247016677544815,0.0241011429727091,0.0234311283645131,0.0226935557574096,0.0218905517668200,0.0210244316647912,0.0200976927049332,0.0191130069229289,0.0180732134335434,0.0169813102467083,0.0158404456269041,0.0146539090220801,0.0134251215909911,0.0121576263624818,0.0108550780700735,0.0095212327309469,0.0081599371174858,0.0067751185564944,0.0053707767664396,0.0039509869249992,0.0025199908063255,0.0010838616248136};
static const double pts58[58] = {-0.9991552004073869,-0.9955514765972910,-0.9890790082484425,-0.9797550146943507,-0.9676062025029237,-0.9526675575188690,-0.9349821375882593,-0.9146009285643525,-0.8915826920220300,-0.8659937940748070,-0.8379080133393734,-0.8074063279130879,-0.7745766817496523,-0.7395137310200423,-0.7023185711539078,-0.6630984453321253,-0.6219664352630793,-0.5790411351302248,-0.5344463096488477,-0.4883105372167180,-0.4407668391868400,-0.3919522963307527,-0.3420076535979951,-0.2910769143111087,-0.2393069249661533,-0.1868469518357617,-0.1338482505954672,-0.0804636302141432,-0.0268470123659425,0.0268470123659419,0.0804636302141431,0.1338482505954668,0.1868469518357612,0.2393069249661534,0.2910769143111094,0.3420076535979951,0.3919522963307534,0.4407668391868394,0.4883105372167182,0.5344463096488475,0.5790411351302246,0.6219664352630788,0.6630984453321249,0.7023185711539083,0.7395137310200424,0.7745766817496523,0.8074063279130885,0.8379080133393733,0.8659937940748074,0.8915826920220302,0.9146009285643526,0.9349821375882592,0.9526675575188691,0.9676062025029241,0.9797550146943501,0.9890790082484429,0.9955514765972908,0.9991552004073864};

static const double w59[59] = {0.0010477461422705,0.0024361195841328,0.0038197647267438,0.0051929427504984,0.0065516831531726,0.0078921736565404,0.0092106713768049,0.0105034991442182,0.0117670526968567,0.0129978098656491,0.0141923401002678,0.0153473139180555,0.0164595121355227,0.0175258348182000,0.0185433099094355,0.0195091015080800,0.0204205177693437,0.0212750184055337,0.0220702217651482,0.0228039114702551,0.0234740425934812,0.0240787473573029,0.0246163403396814,0.0250853231714982,0.0254843887126967,0.0258124246954460,0.0260685168241883,0.0262519513239145,0.0263622169295637,0.0263990063109950,0.0263622169295636,0.0262519513239145,0.0260685168241874,0.0258124246954459,0.0254843887126971,0.0250853231714985,0.0246163403396816,0.0240787473573034,0.0234740425934808,0.0228039114702544,0.0220702217651491,0.0212750184055334,0.0204205177693429,0.0195091015080799,0.0185433099094354,0.0175258348182000,0.0164595121355225,0.0153473139180562,0.0141923401002671,0.0129978098656490,0.0117670526968570,0.0105034991442183,0.0092106713768047,0.0078921736565413,0.0065516831531726,0.0051929427504979,0.0038197647267440,0.0024361195841329,0.0010477461422704};
static const double pts59[59] = {-0.9991833539092946,-0.9956996403832458,-0.9894423651337305,-0.9804275739567153,-0.9686802216817813,-0.9542330093769508,-0.9371261903534532,-0.9174074387881553,-0.8951317117434722,-0.8703610942928820,-0.8431646258168726,-0.8136181072882118,-0.7818038898623610,-0.7478106452786406,-0.7117331186771978,-0.6736718645049375,-0.6337329662388504,-0.5920277407040299,-0.5486724278083961,-0.5037878665577180,-0.4574991582532669,-0.4099353178104191,-0.3612289141697951,-0.3115157008030137,-0.2609342373428117,-0.2096255033920366,-0.1577325055878578,-0.1053998790163441,-0.0527734840883096,0.0000000000000002,0.0527734840883104,0.1053998790163442,0.1577325055878579,0.2096255033920365,0.2609342373428116,0.3115157008030137,0.3612289141697945,0.4099353178104184,0.4574991582532664,0.5037878665577177,0.5486724278083964,0.5920277407040302,0.6337329662388498,0.6736718645049373,0.7117331186771977,0.7478106452786403,0.7818038898623609,0.8136181072882113,0.8431646258168723,0.8703610942928826,0.8951317117434721,0.9174074387881554,0.9371261903534541,0.9542330093769509,0.9686802216817817,0.9804275739567160,0.9894423651337306,0.9956996403832458,0.9991833539092948};

static const double w60[60] = {0.0010134059844364,0.0023563649634769,0.0036949655816732,0.0050237785911439,0.0063390832384082,0.0076373092983922,0.0089149505071036,0.0101685603647288,0.0113947584719989,0.0125902388107603,0.0137517783749627,0.0148762457503945,0.0159606095096484,0.0170019463624735,0.0179974490255419,0.0189444337846219,0.0198403477261904,0.0206827756177926,0.0214694464179674,0.0221982393978938,0.0228671898580571,0.0234744944244562,0.0240185159099853,0.0244977877278785,0.0249110178452747,0.0252570922662548,0.0255350780349282,0.0257442257504902,0.0258839715874548,0.0259539388156106,0.0259539388156103,0.0258839715874547,0.0257442257504909,0.0255350780349281,0.0252570922662548,0.0249110178452750,0.0244977877278786,0.0240185159099852,0.0234744944244557,0.0228671898580574,0.0221982393978939,0.0214694464179684,0.0206827756177923,0.0198403477261911,0.0189444337846217,0.0179974490255421,0.0170019463624730,0.0159606095096483,0.0148762457503944,0.0137517783749623,0.0125902388107605,0.0113947584719991,0.0101685603647286,0.0089149505071042,0.0076373092983926,0.0063390832384076,0.0050237785911441,0.0036949655816728,0.0023563649634766,0.0010134059844369};
static const double pts60[60] = {-0.9992101232274366,-0.9958405251188392,-0.9897878952222222,-0.9810672017525980,-0.9697017887650528,-0.9557222558399961,-0.9391662761164239,-0.9200784761776275,-0.8985103108100462,-0.8745199226468987,-0.8481719847859297,-0.8195375261621461,-0.7886937399322640,-0.7557237753065859,-0.7207165133557303,-0.6837663273813551,-0.6449728284894768,-0.6044405970485104,-0.5622789007539444,-0.5186014000585698,-0.4735258417617068,-0.4271737415830782,-0.3796700565767975,-0.3311428482684478,-0.2817229374232618,-0.2315435513760293,-0.1807399648734252,-0.1294491353969447,-0.0778093339495365,-0.0259597723012480,0.0259597723012479,0.0778093339495362,0.1294491353969445,0.1807399648734255,0.2315435513760295,0.2817229374232617,0.3311428482684480,0.3796700565767979,0.4271737415830784,0.4735258417617074,0.5186014000585698,0.5622789007539445,0.6044405970485102,0.6449728284894772,0.6837663273813552,0.7207165133557306,0.7557237753065857,0.7886937399322641,0.8195375261621459,0.8481719847859296,0.8745199226468984,0.8985103108100463,0.9200784761776278,0.9391662761164234,0.9557222558399959,0.9697017887650530,0.9810672017525982,0.9897878952222217,0.9958405251188385,0.9992101232274361};

static const double w61[61] = {0.0009807266808350,0.0022804620030059,0.0035761774958750,0.0048627309151779,0.0061366317539060,0.0073945329424693,0.0086331464938069,0.0098492388730506,0.0110396365741592,0.0122012335937720,0.0133309992620758,0.0144259860440913,0.0154833371841990,0.0165002941379536,0.0174742037582668,0.0184025252115771,0.0192828366035043,0.0201128412954994,0.0208903738954442,0.0216134059062477,0.0222800510175417,0.0228885700265732,0.0234373753754046,0.0239250352925478,0.0243502775282059,0.0247119926733677,0.0250092370540893,0.0252412351933984,0.0254073818344090,0.0255072435193483,0.0255405597203933,0.0255072435193485,0.0254073818344089,0.0252412351933986,0.0250092370540891,0.0247119926733678,0.0243502775282060,0.0239250352925480,0.0234373753754043,0.0228885700265730,0.0222800510175419,0.0216134059062485,0.0208903738954445,0.0201128412954989,0.0192828366035043,0.0184025252115772,0.0174742037582669,0.0165002941379531,0.0154833371841986,0.0144259860440918,0.0133309992620760,0.0122012335937722,0.0110396365741598,0.0098492388730509,0.0086331464938065,0.0073945329424687,0.0061366317539064,0.0048627309151778,0.0035761774958748,0.0022804620030060,0.0009807266808351};
static const double pts61[61] = {-0.9992355976313638,-0.9959745998151202,-0.9901167452325172,-0.9816760112840371,-0.9706742588331825,-0.9571401519129838,-0.9411089866813610,-0.9226225813829547,-0.9017291624740006,-0.8784832372148804,-0.8529454508476635,-0.8251824281086599,-0.7952665992823595,-0.7632760111723121,-0.7292941234494650,-0.6934095908944915,-0.6557160320950709,-0.6163117851979220,-0.5752996513508304,-0.5327866265029255,-0.4888836222622525,-0.4437051765385318,-0.3973691547257567,-0.3499964422040671,-0.3017106289630305,-0.2526376871690535,-0.2029056425180583,-0.1526442402308155,-0.1019846065622741,-0.0510589067079748,-0.0000000000000003,0.0510589067079738,0.1019846065622739,0.1526442402308149,0.2029056425180584,0.2526376871690537,0.3017106289630310,0.3499964422040669,0.3973691547257564,0.4437051765385317,0.4888836222622523,0.5327866265029252,0.5752996513508306,0.6163117851979217,0.6557160320950709,0.6934095908944917,0.7292941234494653,0.7632760111723121,0.7952665992823599,0.8251824281086599,0.8529454508476635,0.8784832372148811,0.9017291624740015,0.9226225813829549,0.9411089866813612,0.9571401519129844,0.9706742588331829,0.9816760112840373,0.9901167452325170,0.9959745998151202,0.9992355976313636};

static const double w62[62] = {0.0009496028397571,0.0022081667284653,0.0034630209509155,0.0047092897142102,0.0059436950585051,0.0071630959119035,0.0083644058950886,0.0095445883292862,0.0107006611388354,0.0118297036043414,0.0129288634770126,0.0139953640816569,0.0150265112869949,0.0160197002908123,0.0169724221897051,0.0178822703113841,0.0187469462911401,0.0195642658759815,0.0203321644412088,0.0210487022051924,0.0217120691290237,0.0223205894885621,0.0228727261072850,0.0233670842392080,0.0238024150920506,0.0241776189817388,0.0244917481102590,0.0247440089598496,0.0249337642974761,0.0250605347845215,0.0251240001876288,0.0251240001876277,0.0250605347845219,0.0249337642974758,0.0247440089598499,0.0244917481102591,0.0241776189817392,0.0238024150920501,0.0233670842392079,0.0228727261072849,0.0223205894885617,0.0217120691290237,0.0210487022051926,0.0203321644412087,0.0195642658759814,0.0187469462911396,0.0178822703113837,0.0169724221897058,0.0160197002908122,0.0150265112869949,0.0139953640816575,0.0129288634770123,0.0118297036043416,0.0107006611388349,0.0095445883292870,0.0083644058950885,0.0071630959119034,0.0059436950585053,0.0047092897142104,0.0034630209509157,0.0022081667284657,0.0009496028397567};
static const double pts62[62] = {-0.9992598593087766,-0.9961022963162669,-0.9904299711892905,-0.9822559490972367,-0.9716007233716513,-0.9584911729739268,-0.9429604013923284,-0.9250476356362043,-0.9047981225210936,-0.8822630128318972,-0.8574992315120707,-0.8305693336040052,-0.8015413461039765,-0.7704885960554193,-0.7374895252831569,-0.7026274922222974,-0.6659905613354793,-0.6276712806468853,-0.5877664479530872,-0.5463768663002512,-0.5036070893447558,-0.4595651572401137,-0.4143623237171266,-0.3681127750465649,-0.3209333415941942,-0.2729432026967267,-0.2242635856041656,-0.1750174592490158,-0.1253292236158969,-0.0753243954962345,-0.0251292914218208,0.0251292914218203,0.0753243954962344,0.1253292236158971,0.1750174592490161,0.2242635856041658,0.2729432026967269,0.3209333415941943,0.3681127750465649,0.4143623237171263,0.4595651572401140,0.5036070893447564,0.5463768663002514,0.5877664479530872,0.6276712806468853,0.6659905613354797,0.7026274922222973,0.7374895252831567,0.7704885960554194,0.8015413461039766,0.8305693336040045,0.8574992315120713,0.8822630128318970,0.9047981225210935,0.9250476356362037,0.9429604013923283,0.9584911729739268,0.9716007233716519,0.9822559490972367,0.9904299711892901,0.9961022963162672,0.9992598593087768};

static const double w63[63] = {0.0009199372977881,0.0021392541734322,0.0033551458829800,0.0045629843381633,0.0057596880384396,0.0069423063080585,0.0081079392051693,0.0092537322300804,0.0103768806290199,0.0114746355024446,0.0125443102766729,0.0135832871795487,0.0145890236041404,0.0155590583111099,0.0164910174418898,0.0173826203226780,0.0182316850427289,0.0190361337921745,0.0197939979457722,0.0205034228798330,0.0211626725104079,0.0217701335415140,0.0223243194129709,0.0228238739381462,0.0232675746226919,0.0236543356561342,0.0239832105689976,0.0242533945489420,0.0244642264102559,0.0246151902118740,0.0247059165199588,0.0247361833119660,0.0247059165199590,0.0246151902118737,0.0244642264102562,0.0242533945489417,0.0239832105689973,0.0236543356561344,0.0232675746226915,0.0228238739381463,0.0223243194129707,0.0217701335415134,0.0211626725104083,0.0205034228798330,0.0197939979457724,0.0190361337921753,0.0182316850427285,0.0173826203226780,0.0164910174418895,0.0155590583111100,0.0145890236041406,0.0135832871795491,0.0125443102766725,0.0114746355024450,0.0103768806290189,0.0092537322300805,0.0081079392051691,0.0069423063080576,0.0057596880384402,0.0045629843381638,0.0033551458829801,0.0021392541734316,0.0009199372977886};
static const double pts63[63] = {-0.9992829840291240,-0.9962240127779705,-0.9907285468921900,-0.9828088105937275,-0.9724840346975704,-0.9597794497589419,-0.9447261340410101,-0.9273609206218436,-0.9077263027785317,-0.8858703285078533,-0.8618464823641239,-0.8357135543195031,-0.8075354957734572,-0.7773812629903724,-0.7453246483178478,-0.7114440995848458,-0.6758225281149859,-0.6385471058213652,-0.5997090518776252,-0.5594034094862850,-0.5177288132900330,-0.4747872479948040,-0.4306837987951113,-0.3855263942122476,-0.3394255419745844,-0.2924940585862513,-0.2448467932459535,-0.1966003467915067,-0.1478727863578720,-0.0987833564469451,-0.0494521871161594,0.0000000000000000,0.0494521871161600,0.0987833564469454,0.1478727863578722,0.1966003467915067,0.2448467932459535,0.2924940585862514,0.3394255419745842,0.3855263942122477,0.4306837987951115,0.4747872479948045,0.5177288132900328,0.5594034094862851,0.5997090518776256,0.6385471058213651,0.6758225281149862,0.7114440995848457,0.7453246483178473,0.7773812629903727,0.8075354957734565,0.8357135543195029,0.8618464823641236,0.8858703285078534,0.9077263027785316,0.9273609206218436,0.9447261340410096,0.9597794497589420,0.9724840346975699,0.9828088105937275,0.9907285468921891,0.9962240127779700,0.9992829840291239};

static const double w64[64] = {0.0008916403608482,0.0020735166302810,0.0032522289844892,0.0044233799131818,0.0055840697300659,0.0067315239483592,0.0078630152380128,0.0089758578878485,0.0100674115767652,0.0111350869041915,0.0121763512843552,0.0131887348575273,0.0141698363071300,0.0151173285362012,0.0160289641774257,0.0169025809185707,0.0177361066284416,0.0185275642701199,0.0192750765893080,0.0199768705663598,0.0206312816213117,0.0212367575618271,0.0217918622646616,0.0222952790818784,0.0227458139637090,0.0231423982906573,0.0234840914081050,0.0237700828574148,0.0239996942982291,0.0241723811174013,0.0242877337207517,0.0243454785045703,0.0243454785045703,0.0242877337207515,0.0241723811174018,0.0239996942982290,0.0237700828574148,0.0234840914081047,0.0231423982906571,0.0227458139637090,0.0222952790818783,0.0217918622646619,0.0212367575618266,0.0206312816213125,0.0199768705663601,0.0192750765893080,0.0185275642701204,0.0177361066284411,0.0169025809185705,0.0160289641774254,0.0151173285362018,0.0141698363071295,0.0131887348575273,0.0121763512843554,0.0111350869041918,0.0100674115767650,0.0089758578878484,0.0078630152380122,0.0067315239483597,0.0055840697300661,0.0044233799131820,0.0032522289844891,0.0020735166302813,0.0008916403608482};
static const double pts64[64] = {-0.9993050417357725,-0.9963401167719553,-0.9910133714767446,-0.9833362538846262,-0.9733268277899109,-0.9610087996520535,-0.9464113748584028,-0.9295691721319393,-0.9105221370785024,-0.8893154459951134,-0.8659993981540924,-0.8406292962525806,-0.8132653151227978,-0.7839723589433417,-0.7528199072605319,-0.7198818501716112,-0.6852363130542332,-0.6489654712546575,-0.6111553551723929,-0.5718956462026329,-0.5312794640198942,-0.4894031457070531,-0.4463660172534640,-0.4022701579639916,-0.3572201583376681,-0.3113228719902108,-0.2646871622087671,-0.2174236437400070,-0.1696444204239930,-0.1214628192961204,-0.0729931217877989,-0.0243502926634244,0.0243502926634244,0.0729931217877992,0.1214628192961208,0.1696444204239932,0.2174236437400070,0.2646871622087676,0.3113228719902111,0.3572201583376680,0.4022701579639918,0.4463660172534640,0.4894031457070529,0.5312794640198945,0.5718956462026342,0.6111553551723933,0.6489654712546575,0.6852363130542333,0.7198818501716105,0.7528199072605322,0.7839723589433412,0.8132653151227974,0.8406292962525803,0.8659993981540931,0.8893154459951141,0.9105221370785025,0.9295691721319397,0.9464113748584028,0.9610087996520538,0.9733268277899106,0.9833362538846259,0.9910133714767441,0.9963401167719551,0.9993050417357719};

static const double w65[65] = {0.0008646291256502,0.0020107620860018,0.0031539712894858,0.0042900741334409,0.0054163393947989,0.0065301558199974,0.0076289560732241,0.0087102109988351,0.0097714329183752,0.0108101806424673,0.0118240648456431,0.0128107534690188,0.0137679770442253,0.0146935338946557,0.0155852951900943,0.0164412098381844,0.0172593091992743,0.0180377116127829,0.0187746267241285,0.0194683596020256,0.0201173146365030,0.0207199992086201,0.0212750271233780,0.0217811217979003,0.0222371191975416,0.0226419705131499,0.0229947445733257,0.0232946299861167,0.0235409370052276,0.0237330991164428,0.0238706743406203,0.0239533462502480,0.0239809246972335,0.0239533462502476,0.0238706743406205,0.0237330991164425,0.0235409370052272,0.0232946299861164,0.0229947445733259,0.0226419705131506,0.0222371191975417,0.0217811217979001,0.0212750271233776,0.0207199992086200,0.0201173146365028,0.0194683596020251,0.0187746267241291,0.0180377116127828,0.0172593091992747,0.0164412098381842,0.0155852951900941,0.0146935338946554,0.0137679770442254,0.0128107534690190,0.0118240648456437,0.0108101806424669,0.0097714329183752,0.0087102109988349,0.0076289560732242,0.0065301558199977,0.0054163393947985,0.0042900741334409,0.0031539712894859,0.0020107620860017,0.0008646291256502};
static const double pts65[65] = {-0.9993260970754128,-0.9964509480618489,-0.9912852761768016,-0.9838398121870348,-0.9741315398335512,-0.9621827547180551,-0.9480209281684076,-0.9316786282287494,-0.9131934405428459,-0.8926078805047384,-0.8699692949264064,-0.8453297528999300,-0.8187459259226515,-0.7902789574921217,-0.7599943224419996,-0.7279616763294245,-0.6942546952139916,-0.6589509061936247,-0.6221315090854002,-0.5838811896604873,-0.5442879248622271,-0.5034427804550067,-0.4614397015691447,-0.4183752966234084,-0.3743486151220654,-0.3294609198374857,-0.2838154539022484,-0.2375172033464168,-0.1906726556261429,-0.1433895546989753,-0.0957766532091979,-0.0479434623531725,0.0000000000000001,0.0479434623531719,0.0957766532091973,0.1433895546989749,0.1906726556261427,0.2375172033464170,0.2838154539022487,0.3294609198374861,0.3743486151220657,0.4183752966234090,0.4614397015691449,0.5034427804550070,0.5442879248622272,0.5838811896604872,0.6221315090854003,0.6589509061936248,0.6942546952139916,0.7279616763294244,0.7599943224419996,0.7902789574921218,0.8187459259226513,0.8453297528999301,0.8699692949264072,0.8926078805047387,0.9131934405428460,0.9316786282287490,0.9480209281684074,0.9621827547180549,0.9741315398335511,0.9838398121870349,0.9912852761768015,0.9964509480618486,0.9993260970754128};

static const double w66[66] = {0.0008388268720035,0.0019508128208722,0.0030600960092240,0.0041626943829956,0.0052560329938530,0.0063376519906307,0.0074051325013669,0.0084560907361226,0.0094881808613852,0.0104990995459327,0.0114865908676632,0.0124484512573789,0.0133825343771251,0.0142867558914657,0.0151590981094340,0.0159976144820234,0.0168004339430559,0.0175657650827366,0.0182919001440695,0.0189772188329708,0.0196201919334139,0.0202193847194776,0.0207734601566213,0.0212811818850276,0.0217414169783341,0.0221531384715766,0.0225154276527207,0.0228274761126363,0.0230885875489580,0.0232981793197924,0.0234557837438104,0.0235610491438227,0.0236137406314993,0.0236137406314991,0.0235610491438220,0.0234557837438101,0.0232981793197920,0.0230885875489581,0.0228274761126364,0.0225154276527210,0.0221531384715771,0.0217414169783338,0.0212811818850277,0.0207734601566210,0.0202193847194773,0.0196201919334146,0.0189772188329712,0.0182919001440699,0.0175657650827365,0.0168004339430555,0.0159976144820238,0.0151590981094344,0.0142867558914662,0.0133825343771251,0.0124484512573788,0.0114865908676628,0.0104990995459320,0.0094881808613859,0.0084560907361227,0.0074051325013668,0.0063376519906307,0.0052560329938524,0.0041626943829956,0.0030600960092241,0.0019508128208721,0.0008388268720036};
static const double pts66[66] = {-0.9993462098721779,-0.9965568210895530,-0.9915450303833757,-0.9843209049351401,-0.9749004277462860,-0.9633045868592576,-0.9495592462062356,-0.9336950725447919,-0.9157474629452069,-0.8957564644465642,-0.8737666841669446,-0.8498271895360164,-0.8239913986955878,-0.7963169612458245,-0.7668656295753198,-0.7357031210495130,-0.7028989713588742,-0.6685263793509680,-0.6326620436909639,-0.5953859917141382,-0.5567814008517231,-0.5169344130282321,-0.4759339424442373,-0.4338714771733710,-0.3908408750161836,-0.3469381540663375,-0.3022612784564354,-0.2569099397615301,-0.2109853345480789,-0.1645899385647145,-0.1178272780786759,-0.0708016988681415,-0.0236181333859244,0.0236181333859251,0.0708016988681417,0.1178272780786766,0.1645899385647147,0.2109853345480792,0.2569099397615303,0.3022612784564362,0.3469381540663378,0.3908408750161828,0.4338714771733704,0.4759339424442365,0.5169344130282314,0.5567814008517231,0.5953859917141385,0.6326620436909632,0.6685263793509679,0.7028989713588740,0.7357031210495131,0.7668656295753198,0.7963169612458246,0.8239913986955877,0.8498271895360158,0.8737666841669453,0.8957564644465642,0.9157474629452074,0.9336950725447928,0.9495592462062354,0.9633045868592575,0.9749004277462862,0.9843209049351402,0.9915450303833756,0.9965568210895529,0.9993462098721780};

static const double w67[67] = {0.0008141625176200,0.0018935041509128,0.0029703465887910,0.0040408951495115,0.0051027200170511,0.0061535019246441,0.0071909599136003,0.0082128453112655,0.0092169442284023,0.0102010816856719,0.0111631260982258,0.0121009938048369,0.0130126535431062,0.0138961308312187,0.0147495122354729,0.0155709495097361,0.0163586635957654,0.0171109484747684,0.0178261748613723,0.0185027937317465,0.0191393396780897,0.0197344340821542,0.0202867881008725,0.0207952054575994,0.0212585850329155,0.0216759232493497,0.0220463162448754,0.0223689618304450,0.0226431612273351,0.0228683205805318,0.0230439522448811,0.0231696758412075,0.0232452190801325,0.0232704183517814,0.0232452190801321,0.0231696758412077,0.0230439522448810,0.0228683205805316,0.0226431612273349,0.0223689618304449,0.0220463162448758,0.0216759232493498,0.0212585850329153,0.0207952054575993,0.0202867881008720,0.0197344340821548,0.0191393396780898,0.0185027937317463,0.0178261748613724,0.0171109484747682,0.0163586635957653,0.0155709495097361,0.0147495122354725,0.0138961308312186,0.0130126535431067,0.0121009938048368,0.0111631260982254,0.0102010816856715,0.0092169442284025,0.0082128453112659,0.0071909599136002,0.0061535019246441,0.0051027200170513,0.0040408951495111,0.0029703465887909,0.0018935041509130,0.0008141625176200};
static const double pts67[67] = {-0.9993654355529770,-0.9966580272061141,-0.9917933470823097,-0.9847808477559508,-0.9756355839229084,-0.9643773304277127,-0.9510304595401455,-0.9356238732707509,-0.9181909368127387,-0.8987694049613202,-0.8774013398316590,-0.8541330195370507,-0.8290148378533012,-0.8021011950216942,-0.7734503798999801,-0.7431244437043664,-0.7111890656100405,-0.6777134104982812,-0.6427699791566155,-0.6064344512555573,-0.5687855214414707,-0.5299047289002361,-0.4898762807606468,-0.4487868697198915,-0.4067254862860138,-0.3637832260439544,-0.3200530923625363,-0.2756297949696896,-0.2306095448321157,-0.1850898457836400,-0.1391692833535233,-0.0929473112520793,-0.0465240359760168,0.0000000000000001,0.0465240359760172,0.0929473112520807,0.1391692833535239,0.1850898457836398,0.2306095448321157,0.2756297949696894,0.3200530923625363,0.3637832260439544,0.4067254862860142,0.4487868697198908,0.4898762807606465,0.5299047289002361,0.5687855214414710,0.6064344512555575,0.6427699791566155,0.6777134104982806,0.7111890656100404,0.7431244437043663,0.7734503798999806,0.8021011950216942,0.8290148378533010,0.8541330195370505,0.8774013398316589,0.8987694049613203,0.9181909368127388,0.9356238732707506,0.9510304595401449,0.9643773304277126,0.9756355839229078,0.9847808477559509,0.9917933470823098,0.9966580272061135,0.9993654355529767};

static const double w68[68] = {0.0007905701281865,0.0018386832975056,0.0028844849593649,0.0039243556965890,0.0049560006257930,0.0059772311598843,0.0069858945872290,0.0079798679548070,0.0089570602289616,0.0099154160439776,0.0108529198051889,0.0117675998429382,0.0126575325225883,0.0135208462729519,0.0143557255137423,0.0151604144692768,0.0159332208584110,0.0166725194519903,0.0173767554898758,0.0180444479500899,0.0186741926630934,0.0192646652645535,0.0198146239803563,0.0203229122379770,0.0207884610987014,0.0212102915055712,0.0215875163423222,0.0219193422989781,0.0222050715401762,0.0224441031727132,0.0226359345092218,0.0227801621253243,0.0228764827080334,0.0229246936936254,0.0229246936936255,0.0228764827080342,0.0227801621253241,0.0226359345092222,0.0224441031727133,0.0222050715401758,0.0219193422989784,0.0215875163423222,0.0212102915055710,0.0207884610987012,0.0203229122379770,0.0198146239803561,0.0192646652645534,0.0186741926630932,0.0180444479500897,0.0173767554898757,0.0166725194519906,0.0159332208584107,0.0151604144692770,0.0143557255137424,0.0135208462729521,0.0126575325225881,0.0117675998429386,0.0108529198051894,0.0099154160439777,0.0089570602289613,0.0079798679548071,0.0069858945872287,0.0059772311598845,0.0049560006257930,0.0039243556965882,0.0028844849593649,0.0018386832975059,0.0007905701281865};
static const double pts68[68] = {-0.9993838255297044,-0.9967548366766643,-0.9920308877424482,-0.9852208614402447,-0.9763389504003569,-0.9654038025821998,-0.9524384044796027,-0.9374700183128013,-0.9205301208479184,-0.9016543359201078,-0.8808823590174563,-0.8582578735826598,-0.8338284590416712,-0.8076454906897087,-0.7797640316188977,-0.7502427169029169,-0.7191436302764732,-0.6865321735660126,-0.6524769291446768,-0.6170495156998835,-0.5803244376163508,-0.5423789282910033,-0.5032927877090848,-0.4631482146229390,-0.4220296336863135,-0.3800235179076742,-0.3372182067958809,-0.2937037205806388,-0.2495715708984165,-0.2049145683419392,-0.1598266272779790,-0.1144025683439108,-0.0687379190383771,-0.0229287128254223,0.0229287128254227,0.0687379190383773,0.1144025683439112,0.1598266272779792,0.2049145683419393,0.2495715708984171,0.2937037205806391,0.3372182067958810,0.3800235179076745,0.4220296336863138,0.4631482146229393,0.5032927877090847,0.5423789282910035,0.5803244376163503,0.6170495156998838,0.6524769291446768,0.6865321735660129,0.7191436302764728,0.7502427169029167,0.7797640316188977,0.8076454906897087,0.8338284590416709,0.8582578735826598,0.8808823590174557,0.9016543359201078,0.9205301208479183,0.9374700183128010,0.9524384044796020,0.9654038025821998,0.9763389504003571,0.9852208614402450,0.9920308877424486,0.9967548366766642,0.9993838255297046};

static const double w69[69] = {0.0007679884763960,0.0017862083696986,0.0028022899639357,0.0038127779656004,0.0048155030752076,0.0058083983053361,0.0067894303245378,0.0077565932717033,0.0087079106159849,0.0096414385644246,0.0105552698199362,0.0114475373953702,0.0123164183922710,0.0131601377084350,0.0139769716560935,0.0147652514789536,0.0155233667589456,0.0162497687048226,0.0169429733154161,0.0176015644108419,0.0182241965253503,0.0188095976558203,0.0193565718602464,0.0198640017008809,0.0203308505270307,0.0207561645928272,0.0211390750056401,0.0214787995011527,0.0217746440414634,0.0220260042329545,0.0222323665610230,0.0223933094391564,0.0225085040702002,0.0225777151180730,0.0226008011885396,0.0225777151180731,0.0225085040701995,0.0223933094391568,0.0222323665610237,0.0220260042329546,0.0217746440414636,0.0214787995011524,0.0211390750056404,0.0207561645928272,0.0203308505270306,0.0198640017008812,0.0193565718602466,0.0188095976558200,0.0182241965253502,0.0176015644108418,0.0169429733154158,0.0162497687048235,0.0155233667589452,0.0147652514789535,0.0139769716560939,0.0131601377084348,0.0123164183922712,0.0114475373953704,0.0105552698199364,0.0096414385644246,0.0087079106159850,0.0077565932717033,0.0067894303245377,0.0058083983053358,0.0048155030752079,0.0038127779656007,0.0028022899639356,0.0017862083696983,0.0007679884763960};
static const double pts69[69] = {-0.9994014275432448,-0.9968475004851949,-0.9922582667168528,-0.9856420800226374,-0.9770123316220943,-0.9663866216428599,-0.9537866478051817,-0.9392381470416081,-0.9227708391804446,-0.9044183649858271,-0.8842182169472522,-0.8622116624727438,-0.8384436594805040,-0.8129627645002955,-0.7858210334467604,-0.7570739152558380,-0.7267801385960082,-0.6950015918829284,-0.6618031968410785,-0.6272527758698496,-0.5914209134845559,-0.5543808121151323,-0.5162081425569339,-0.4769808893790460,-0.4367791916058446,-0.3956851789972443,-0.3537828042620662,-0.3111576715472807,-0.2678968615535036,-0.2240887536339989,-0.1798228452406429,-0.1351895690856831,-0.0902801083928285,-0.0451862106151014,0.0000000000000000,0.0451862106151018,0.0902801083928289,0.1351895690856831,0.1798228452406433,0.2240887536339992,0.2678968615535036,0.3111576715472814,0.3537828042620667,0.3956851789972447,0.4367791916058444,0.4769808893790454,0.5162081425569334,0.5543808121151321,0.5914209134845558,0.6272527758698491,0.6618031968410785,0.6950015918829280,0.7267801385960080,0.7570739152558376,0.7858210334467594,0.8129627645002953,0.8384436594805045,0.8622116624727443,0.8842182169472521,0.9044183649858272,0.9227708391804449,0.9392381470416082,0.9537866478051816,0.9663866216428606,0.9770123316220944,0.9856420800226374,0.9922582667168530,0.9968475004851949,0.9994014275432448};

static const double w70[70] = {0.0007463606444226,0.0017359474465390,0.0027235559371085,0.0037058846815946,0.0046808813848496,0.0056465923249658,0.0066010954073384,0.0075424939327217,0.0084689181881515,0.0093785285465666,0.0102695189121633,0.0111401202261283,0.0119886039445502,0.0128132854542342,0.0136125274093324,0.0143847429779041,0.0151283989900769,0.0158420189806542,0.0165241861196863,0.0171735460249532,0.0177888094506464,0.0183687548468362,0.0189122307846114,0.0194181582420367,0.0198855327463881,0.0203134263683949,0.0207009895645228,0.0210474528636420,0.0213521283947250,0.0216144112525342,0.0218337806986006,0.0220098011950917,0.0221421232695280,0.0222304842086230,0.0222747085798773,0.0222747085798771,0.0222304842086233,0.0221421232695271,0.0220098011950916,0.0218337806986010,0.0216144112525349,0.0213521283947241,0.0210474528636419,0.0207009895645232,0.0203134263683950,0.0198855327463882,0.0194181582420369,0.0189122307846114,0.0183687548468363,0.0177888094506462,0.0171735460249536,0.0165241861196859,0.0158420189806546,0.0151283989900769,0.0143847429779047,0.0136125274093317,0.0128132854542345,0.0119886039445505,0.0111401202261283,0.0102695189121629,0.0093785285465666,0.0084689181881521,0.0075424939327216,0.0066010954073378,0.0056465923249656,0.0046808813848497,0.0037058846815949,0.0027235559371085,0.0017359474465392,0.0007463606444222};
static const double pts70[70] = {-0.9994182859735755,-0.9969362519616793,-0.9924760552116897,-0.9860455580703987,-0.9776574059575928,-0.9673282236649863,-0.9550785091142928,-0.9409325790038156,-0.9249185168979354,-0.9070681162609233,-0.8874168168633479,-0.8660036342138587,-0.8428710819989802,-0.8180650876254407,-0.7916349010078929,-0.7636329967718992,-0.7341149700609426,-0.7031394261515284,-0.6707678640940771,-0.6370645546097778,-0.6020964124853553,-0.5659328637188079,-0.5286457076797111,-0.4903089745576366,-0.4509987783816480,-0.4107931659026305,-0.3697719616384621,-0.3280166093896430,-0.2856100105400383,-0.2426363594637408,-0.1991809763648577,-0.1553301378820701,-0.1111709057942989,-0.0667909541675515,-0.0222783952861406,0.0222783952861403,0.0667909541675515,0.1111709057942985,0.1553301378820700,0.1991809763648577,0.2426363594637407,0.2856100105400379,0.3280166093896431,0.3697719616384617,0.4107931659026308,0.4509987783816479,0.4903089745576368,0.5286457076797112,0.5659328637188087,0.6020964124853557,0.6370645546097780,0.6707678640940777,0.7031394261515289,0.7341149700609428,0.7636329967718998,0.7916349010078927,0.8180650876254413,0.8428710819989803,0.8660036342138587,0.8874168168633485,0.9070681162609233,0.9249185168979345,0.9409325790038152,0.9550785091142932,0.9673282236649864,0.9776574059575924,0.9860455580703992,0.9924760552116901,0.9969362519616803,0.9994182859735760};

static const double w71[71] = {0.0007256336650147,0.0016877777483653,0.0026480914220133,0.0036034176409154,0.0045518132309958,0.0054914300771496,0.0064204498340437,0.0073370776673060,0.0082395436037311,0.0091261053523393,0.0099950514661752,0.0108447045679927,0.0116734245546112,0.0124796117471571,0.0132617099710791,0.0140182095558710,0.0147476502468543,0.0154486240225450,0.0161197778117221,0.0167598161047273,0.0173675034538407,0.0179416668578244,0.0184811980259913,0.0189850555174155,0.0194522667511315,0.0198819298834286,0.0202732155486234,0.0206253684599334,0.0209377088673665,0.0212096338698123,0.0214406185787902,0.0216302171316204,0.0217780635520541,0.0218838724567008,0.0219474396058943,0.0219686422979263,0.0219474396058944,0.0218838724567014,0.0217780635520543,0.0216302171316201,0.0214406185787904,0.0212096338698127,0.0209377088673664,0.0206253684599328,0.0202732155486239,0.0198819298834289,0.0194522667511315,0.0189850555174153,0.0184811980259906,0.0179416668578244,0.0173675034538410,0.0167598161047273,0.0161197778117218,0.0154486240225458,0.0147476502468548,0.0140182095558704,0.0132617099710790,0.0124796117471570,0.0116734245546116,0.0108447045679928,0.0099950514661747,0.0091261053523393,0.0082395436037308,0.0073370776673059,0.0064204498340436,0.0054914300771492,0.0045518132309958,0.0036034176409157,0.0026480914220129,0.0016877777483654,0.0007256336650147};
static const double pts71[71] = {-0.9994344421197369,-0.9970213082512549,-0.9926847848706415,-0.9864322772682611,-0.9782757361136023,-0.9682308774263256,-0.9563170810410531,-0.9425573399222714,-0.9269782122508716,-0.9096097689845339,-0.8904855353552060,-0.8696424259563074,-0.8471206733918741,-0.8229637505675526,-0.7972182867493177,-0.7699339775410365,-0.7411634889493768,-0.7109623557185443,-0.6793888741296445,-0.6465039894707870,-0.6123711783946824,-0.5770563263905198,-0.5406276006064875,-0.5031553182682897,-0.4647118109475978,-0.4253712849423694,-0.3852096780385273,-0.3443045129294469,-0.3027347475761913,-0.2605806227973185,-0.2179235073824529,-0.1748457410285845,-0.1314304754022659,-0.0877615136345004,-0.0439231485581350,0.0000000000000001,0.0439231485581353,0.0877615136345006,0.1314304754022663,0.1748457410285850,0.2179235073824531,0.2605806227973184,0.3027347475761913,0.3443045129294473,0.3852096780385274,0.4253712849423696,0.4647118109475979,0.5031553182682900,0.5406276006064875,0.5770563263905197,0.6123711783946822,0.6465039894707877,0.6793888741296443,0.7109623557185440,0.7411634889493770,0.7699339775410362,0.7972182867493179,0.8229637505675523,0.8471206733918739,0.8696424259563074,0.8904855353552066,0.9096097689845342,0.9269782122508715,0.9425573399222708,0.9563170810410525,0.9682308774263253,0.9782757361136015,0.9864322772682612,0.9926847848706416,0.9970213082512552,0.9994344421197366};

static const double w72[72] = {0.0007057581969867,0.0016415848873337,0.0025757180093956,0.0035051361609312,0.0044279980368530,0.0053425540826757,0.0062470828099370,0.0071398845272768,0.0080192824751426,0.0088836253946003,0.0097312904316473,0.0105606861082201,0.0113702552775178,0.0121584780322096,0.0129238745503281,0.0136650078694753,0.0143804865823513,0.0150689674476878,0.0157291579112806,0.0163598185321466,0.0169597653091429,0.0175278719036088,0.0180630717538194,0.0185643600772515,0.0190307957569011,0.0194615031080848,0.0198556735224174,0.0202125669858669,0.0205315134680379,0.0208119141800693,0.0210532426987932,0.0212550459550287,0.0214169450841696,0.0215386361374573,0.0216198906526107,0.0216605560827435,0.0216605560827431,0.0216198906526111,0.0215386361374564,0.0214169450841699,0.0212550459550292,0.0210532426987932,0.0208119141800692,0.0205315134680376,0.0202125669858666,0.0198556735224172,0.0194615031080849,0.0190307957569011,0.0185643600772516,0.0180630717538190,0.0175278719036091,0.0169597653091436,0.0163598185321469,0.0157291579112812,0.0150689674476878,0.0143804865823505,0.0136650078694756,0.0129238745503280,0.0121584780322092,0.0113702552775180,0.0105606861082200,0.0097312904316465,0.0088836253946006,0.0080192824751425,0.0071398845272774,0.0062470828099366,0.0053425540826760,0.0044279980368531,0.0035051361609316,0.0025757180093954,0.0016415848873339,0.0007057581969866};
static const double pts72[72] = {-0.9994499344529626,-0.9971028716427287,-0.9928849510168020,-0.9868031523758305,-0.9788687785572338,-0.9690966979987805,-0.9575052475776983,-0.9441161852725379,-0.9289546458809184,-0.9120490926886712,-0.8934312635880912,-0.8731361112987788,-0.8512017376544377,-0.8276693220227542,-0.8025830439692918,-0.7759900002999829,-0.7479401166328323,-0.7184860536622349,-0.6876831082904675,-0.6555891098112011,-0.6222643113394682,-0.5877712766916562,-0.5521747629277145,-0.5155415987760036,-0.4779405591689406,-0.4394422361249611,-0.4001189062191619,-0.3600443948914193,-0.3192939378467126,-0.2779440398078478,-0.2360723308857599,-0.1937574208370260,-0.1510787514822106,-0.1081164475621031,-0.0649511663118570,-0.0216639460354235,0.0216639460354240,0.0649511663118568,0.1081164475621027,0.1510787514822099,0.1937574208370258,0.2360723308857599,0.2779440398078475,0.3192939378467122,0.3600443948914195,0.4001189062191612,0.4394422361249608,0.4779405591689403,0.5155415987760030,0.5521747629277146,0.5877712766916553,0.6222643113394680,0.6555891098112011,0.6876831082904679,0.7184860536622347,0.7479401166328323,0.7759900002999827,0.8025830439692920,0.8276693220227545,0.8512017376544380,0.8731361112987789,0.8934312635880914,0.9120490926886717,0.9289546458809185,0.9441161852725377,0.9575052475776989,0.9690966979987806,0.9788687785572342,0.9868031523758303,0.9928849510168021,0.9971028716427293,0.9994499344529628};

static const double w73[73] = {0.0006866882313796,0.0015972621886445,0.0025062692858035,0.0034108156745873,0.0043091552397661,0.0051996304975002,0.0060806104646408,0.0069504843941576,0.0078076627167956,0.0086505793812443,0.0094776945243350,0.0102874972101802,0.0110785081585205,0.0118492824321097,0.0125984120687691,0.0133245286493637,0.0140263057952861,0.0147024615900581,0.0153517609202169,0.0159730177309882,0.0165650971925218,0.0171269177726509,0.0176574532123645,0.0181557344003492,0.0186208511431747,0.0190519538278701,0.0194482549738483,0.0198090306713530,0.0201336219037800,0.0204214357514692,0.0206719464747631,0.0208846964743462,0.0210592971271272,0.0211954294961160,0.0212928449130094,0.0213513654324286,0.0213708841569614,0.0213513654324285,0.0212928449130095,0.0211954294961153,0.0210592971271278,0.0208846964743467,0.0206719464747626,0.0204214357514697,0.0201336219037797,0.0198090306713533,0.0194482549738480,0.0190519538278704,0.0186208511431745,0.0181557344003483,0.0176574532123638,0.0171269177726514,0.0165650971925219,0.0159730177309882,0.0153517609202170,0.0147024615900584,0.0140263057952864,0.0133245286493639,0.0125984120687697,0.0118492824321096,0.0110785081585196,0.0102874972101810,0.0094776945243359,0.0086505793812446,0.0078076627167955,0.0069504843941573,0.0060806104646401,0.0051996304975000,0.0043091552397661,0.0034108156745874,0.0025062692858030,0.0015972621886444,0.0006866882313800};
static const double pts73[73] = {-0.9994647988458811,-0.9971811307716120,-0.9930770155889452,-0.9871590366249321,-0.9794378920564835,-0.9699276590549857,-0.9586457006979743,-0.9456126216894835,-0.9308522273812241,-0.9143914791762562,-0.8962604448466911,-0.8764922434206520,-0.8551229845942994,-0.8321917027249095,-0.8077402855027361,-0.7818133974216449,-0.7544583981833235,-0.7257252561815598,-0.6956664572232626,-0.6643369086521966,-0.6317938390501185,-0.5980966936982710,-0.5633070259900168,-0.5274883849928710,-0.4907061993652522,-0.4530276578399455,-0.4145215864925755,-0.3752583230192520,-0.3353095882530222,-0.2947483551538367,-0.2536487155113017,-0.2120857446037311,-0.1701353640607015,-0.1278742031796143,-0.0853794589495960,-0.0427287550384142,0.0000000000000002,0.0427287550384142,0.0853794589495968,0.1278742031796143,0.1701353640607006,0.2120857446037306,0.2536487155113012,0.2947483551538365,0.3353095882530222,0.3752583230192516,0.4145215864925759,0.4530276578399452,0.4907061993652523,0.5274883849928714,0.5633070259900163,0.5980966936982712,0.6317938390501184,0.6643369086521964,0.6956664572232627,0.7257252561815597,0.7544583981833234,0.7818133974216449,0.8077402855027361,0.8321917027249099,0.8551229845942998,0.8764922434206518,0.8962604448466912,0.9143914791762567,0.9308522273812244,0.9456126216894837,0.9586457006979744,0.9699276590549857,0.9794378920564837,0.9871590366249324,0.9930770155889451,0.9971811307716116,0.9994647988458814};

static const double w74[74] = {0.0006683808250349,0.0015547100749482,0.0024395898792972,0.0033202464545571,0.0041950227169860,0.0050623472691432,0.0059206737737501,0.0067684747058932,0.0076042421217008,0.0084264897910125,0.0092337556544900,0.0100246043513977,0.0107976297408377,0.0115514573874580,0.0122847469979715,0.0129961948003618,0.0136845358598395,0.0143485463266350,0.0149870456112305,0.0155988984829578,0.0161830170881087,0.0167383628839144,0.0172639484849131,0.0177588394184007,0.0182221557858291,0.0186530738271972,0.0190508273856317,0.0194147092695690,0.0197440725100981,0.0200383315112382,0.0202969630910977,0.0205195074120637,0.0207055687983767,0.0208548164396203,0.0209669849788883,0.0210418749845788,0.0210793533049718,0.0210793533049715,0.0210418749845784,0.0209669849788885,0.0208548164396202,0.0207055687983768,0.0205195074120636,0.0202969630910970,0.0200383315112388,0.0197440725100985,0.0194147092695687,0.0190508273856315,0.0186530738271969,0.0182221557858296,0.0177588394184005,0.0172639484849135,0.0167383628839139,0.0161830170881084,0.0155988984829568,0.0149870456112309,0.0143485463266345,0.0136845358598402,0.0129961948003620,0.0122847469979718,0.0115514573874574,0.0107976297408382,0.0100246043513976,0.0092337556544902,0.0084264897910123,0.0076042421217012,0.0067684747058938,0.0059206737737494,0.0050623472691436,0.0041950227169859,0.0033202464545573,0.0024395898792975,0.0015547100749482,0.0006683808250348};
static const double pts74[74] = {-0.9994790687803299,-0.9972562617110170,-0.9932614098046453,-0.9875007266162388,-0.9799843454313001,-0.9707256040425187,-0.9597409554595289,-0.9470499264283853,-0.9326750794620547,-0.9166419716429067,-0.8989791087618960,-0.8797178944520885,-0.8588925742659840,-0.8365401747428158,-0.8127004375519740,-0.7874157488195754,-0.7607310637589945,-0.7326938267368805,-0.7033538869154423,-0.6727634096202478,-0.6409767835906922,-0.6080505242777801,-0.5740431733609941,-0.5390151946628173,-0.5030288666458846,-0.4661481716838813,-0.4284386823030033,-0.3899674445962499,-0.3508028590177974,-0.3110145587693907,-0.2706732859949801,-0.2298507660037169,-0.1886195797449191,-0.1470530347617533,-0.1052250348530711,-0.0632099486751165,-0.0210824775167483,0.0210824775167481,0.0632099486751162,0.1052250348530710,0.1470530347617535,0.1886195797449187,0.2298507660037170,0.2706732859949808,0.3110145587693908,0.3508028590177981,0.3899674445962507,0.4284386823030030,0.4661481716838812,0.5030288666458851,0.5390151946628169,0.5740431733609942,0.6080505242777798,0.6409767835906924,0.6727634096202481,0.7033538869154420,0.7326938267368807,0.7607310637589947,0.7874157488195757,0.8127004375519744,0.8365401747428155,0.8588925742659835,0.8797178944520888,0.8989791087618958,0.9166419716429065,0.9326750794620544,0.9470499264283849,0.9597409554595292,0.9707256040425186,0.9799843454313003,0.9875007266162383,0.9932614098046448,0.9972562617110163,0.9994790687803293};

static const double w75[75] = {0.0006507958586881,0.0015138355073029,0.0023755345925076,0.0032332324535188,0.0040853553536637,0.0049304124580572,0.0057669366641523,0.0065934783814125,0.0074086061449073,0.0082109085595122,0.0089989965628226,0.0097715057600640,0.0105270987561411,0.0112644674569333,0.0119823353268581,0.0126794595951081,0.0133546334050606,0.0140066879023899,0.0146344942578631,0.0152369656211074,0.0158130590018746,0.0163617770754674,0.0168821699091670,0.0173733366066652,0.0178344268676203,0.0182646424596452,0.0186632386001666,0.0190295252457566,0.0193628682867163,0.0196626906448173,0.0199284732723285,0.0201597560505707,0.0203561385864682,0.0205172809056959,0.0206429040412339,0.0207327905163090,0.0207867847208908,0.0208047931810710,0.0207867847208906,0.0207327905163097,0.0206429040412337,0.0205172809056962,0.0203561385864685,0.0201597560505709,0.0199284732723281,0.0196626906448176,0.0193628682867166,0.0190295252457567,0.0186632386001664,0.0182646424596453,0.0178344268676197,0.0173733366066649,0.0168821699091672,0.0163617770754670,0.0158130590018743,0.0152369656211075,0.0146344942578631,0.0140066879023905,0.0133546334050608,0.0126794595951078,0.0119823353268581,0.0112644674569330,0.0105270987561411,0.0097715057600636,0.0089989965628222,0.0082109085595124,0.0074086061449074,0.0065934783814120,0.0057669366641522,0.0049304124580567,0.0040853553536638,0.0032332324535192,0.0023755345925079,0.0015138355073030,0.0006507958586879};
static const double pts75[75] = {-0.9994927755360352,-0.9973284289622317,-0.9934385365788929,-0.9878289667675247,-0.9805093245974166,-0.9714922563430637,-0.9607933637418922,-0.9484311650792875,-0.9344270599641071,-0.9188052912283942,-0.9015929025484460,-0.8828196914478951,-0.8625181576268836,-0.8407234466549578,-0.8174732891035411,-0.7928079352135635,-0.7667700852066418,-0.7394048153580329,-0.7107594999580416,-0.6808837292962698,-0.6498292238102623,-0.6176497445469260,-0.5844010000915780,-0.5501405501256454,-0.5149277057799170,-0.4788234269558028,-0.4418902167923484,-0.4041920134616541,-0.3657940794800361,-0.3267628887265258,-0.2871660113642973,-0.2470719968642349,-0.2065502553331596,-0.1656709373521379,-0.1245048125329003,-0.0831231470026112,-0.0415975800290798,-0.0000000000000003,0.0415975800290795,0.0831231470026108,0.1245048125329001,0.1656709373521374,0.2065502553331597,0.2470719968642347,0.2871660113642974,0.3267628887265264,0.3657940794800357,0.4041920134616536,0.4418902167923477,0.4788234269558028,0.5149277057799168,0.5501405501256454,0.5844010000915781,0.6176497445469260,0.6498292238102626,0.6808837292962702,0.7107594999580419,0.7394048153580327,0.7667700852066419,0.7928079352135634,0.8174732891035411,0.8407234466549585,0.8625181576268840,0.8828196914478953,0.9015929025484467,0.9188052912283940,0.9344270599641070,0.9484311650792880,0.9607933637418922,0.9714922563430639,0.9805093245974170,0.9878289667675246,0.9934385365788927,0.9973284289622319,0.9994927755360355};

static const double w76[76] = {0.0006338958170426,0.0014745514768212,0.0023139676140187,0.0031495902486647,0.0039799237386202,0.0048035527073562,0.0056190842848338,0.0064251419237552,0.0072203658741385,0.0080034149561244,0.0087729686457369,0.0095277292335952,0.0102664239839541,0.0109878072672079,0.0116906626535061,0.0123738049603295,0.0130360822489928,0.0136763777659138,0.0142936118250274,0.0148867436279523,0.0154547730187459,0.0159967421702107,0.0165117371988957,0.0169988897060284,0.0174573782417757,0.0178864296903568,0.0182853205736649,0.0186533782711909,0.0189899821542026,0.0192945646322533,0.0195666121102595,0.0198056658545310,0.0200113227662983,0.0201832360614222,0.0203211158551476,0.0204247296509141,0.0204939027323966,0.0205285184581150,0.0205285184581146,0.0204939027323972,0.0204247296509142,0.0203211158551476,0.0201832360614221,0.0200113227662985,0.0198056658545307,0.0195666121102587,0.0192945646322534,0.0189899821542029,0.0186533782711910,0.0182853205736650,0.0178864296903569,0.0174573782417756,0.0169988897060279,0.0165117371988962,0.0159967421702112,0.0154547730187454,0.0148867436279520,0.0142936118250269,0.0136763777659133,0.0130360822489929,0.0123738049603295,0.0116906626535058,0.0109878072672078,0.0102664239839535,0.0095277292335955,0.0087729686457374,0.0080034149561245,0.0072203658741384,0.0064251419237550,0.0056190842848338,0.0048035527073572,0.0039799237386199,0.0031495902486643,0.0023139676140187,0.0014745514768214,0.0006338958170423};
static const double pts76[76] = {-0.9995059483621529,-0.9973977863553557,-0.9936087727235267,-0.9881444533598371,-0.9810139389756554,-0.9722292285203770,-0.9618051267587681,-0.9497592077108961,-0.9361117819348101,-0.9208858612521501,-0.9041071195455664,-0.8858038492920827,-0.8660069137719816,-0.8447496949833421,-0.8220680373289740,-0.7980001871611996,-0.7725867282818093,-0.7458705135036103,-0.7178965923877035,-0.6887121352776403,-0.6583663537581427,-0.6269104176722665,-0.5943973688367933,-0.5608820316012378,-0.5264209204012427,-0.4910721444621938,-0.4548953098137266,-0.4179514187803274,-0.3803027671175045,-0.3420128389669619,-0.3031461998079081,-0.2637683875849948,-0.2239458021964745,-0.1837455935289146,-0.1432355482272676,-0.1024839753912270,-0.0615595913906109,-0.0205314039939985,0.0205314039939985,0.0615595913906112,0.1024839753912268,0.1432355482272671,0.1837455935289142,0.2239458021964743,0.2637683875849945,0.3031461998079078,0.3420128389669621,0.3803027671175046,0.4179514187803272,0.4548953098137261,0.4910721444621937,0.5264209204012424,0.5608820316012375,0.5943973688367926,0.6269104176722666,0.6583663537581426,0.6887121352776404,0.7178965923877041,0.7458705135036104,0.7725867282818101,0.7980001871611999,0.8220680373289749,0.8447496949833424,0.8660069137719825,0.8858038492920829,0.9041071195455668,0.9208858612521500,0.9361117819348110,0.9497592077108964,0.9618051267587678,0.9722292285203771,0.9810139389756556,0.9881444533598376,0.9936087727235269,0.9973977863553550,0.9995059483621531};

static const double w77[77] = {0.0006176455885698,0.0014367765418263,0.0022547618001028,0.0030691480798784,0.0038785129750414,0.0046815118461931,0.0054768214269556,0.0062631336846137,0.0070391561700133,0.0078036136343744,0.0085552499532657,0.0092928301241708,0.0100151422671581,0.0107209996027278,0.0114092423950653,0.0120787398539776,0.0127283919908471,0.0133571314247790,0.0139639251356386,0.0145477761608848,0.0151077252333119,0.0156428523569523,0.0161522783185152,0.0166351661318493,0.0170907224130581,0.0175181986839896,0.0179168926019556,0.0182861491136635,0.0186253615314466,0.0189339725300442,0.0192114750622778,0.0194574131921167,0.0196713828437849,0.0198530324656449,0.0200020636077958,0.0201182314124257,0.0202013450161090,0.0202512678633938,0.0202679179311625,0.0202512678633939,0.0202013450161091,0.0201182314124254,0.0200020636077957,0.0198530324656446,0.0196713828437853,0.0194574131921170,0.0192114750622770,0.0189339725300447,0.0186253615314469,0.0182861491136637,0.0179168926019560,0.0175181986839892,0.0170907224130575,0.0166351661318493,0.0161522783185157,0.0156428523569524,0.0151077252333114,0.0145477761608841,0.0139639251356389,0.0133571314247788,0.0127283919908474,0.0120787398539779,0.0114092423950647,0.0107209996027280,0.0100151422671581,0.0092928301241708,0.0085552499532653,0.0078036136343749,0.0070391561700141,0.0062631336846139,0.0054768214269554,0.0046815118461933,0.0038785129750412,0.0030691480798783,0.0022547618001027,0.0014367765418267,0.0006176455885697};
static const double pts77[77] = {-0.9995186146334102,-0.9974644778692137,-0.9937724709498774,-0.9884478382225614,-0.9814992273311387,-0.9729380307491081,-0.9627783064677343,-0.9510367436005921,-0.9377326319590613,-0.9228878293594024,-0.9065267253212583,-0.8886762008255643,-0.8693655840677341,-0.8486266022296244,-0.8264933293290020,-0.8030021302229253,-0.7781916008525435,-0.7521025048252161,-0.7247777064369115,-0.6962621002442422,-0.6666025373014509,-0.6358477481833118,-0.6040482629202575,-0.5712563279771985,-0.5375258204123776,-0.5029121593572509,-0.4674722149628120,-0.4312642149619356,-0.3943476490012635,-0.3567831708997810,-0.3186324989946875,-0.2799583147382762,-0.2408241597124320,-0.2012943312299444,-0.1614337766941609,-0.1213079868905529,-0.0809828883855033,-0.0405247352091163,-0.0000000000000000,0.0405247352091159,0.0809828883855031,0.1213079868905523,0.1614337766941609,0.2012943312299441,0.2408241597124325,0.2799583147382761,0.3186324989946877,0.3567831708997811,0.3943476490012638,0.4312642149619356,0.4674722149628115,0.5029121593572515,0.5375258204123777,0.5712563279771981,0.6040482629202570,0.6358477481833126,0.6666025373014519,0.6962621002442420,0.7247777064369118,0.7521025048252153,0.7781916008525432,0.8030021302229250,0.8264933293290021,0.8486266022296244,0.8693655840677340,0.8886762008255641,0.9065267253212579,0.9228878293594025,0.9377326319590612,0.9510367436005919,0.9627783064677345,0.9729380307491081,0.9814992273311385,0.9884478382225613,0.9937724709498785,0.9974644778692141,0.9995186146334100};

static const double w78[78] = {0.0006020122830341,0.0014004344059194,0.0021977980197303,0.0029917449722200,0.0037809215947199,0.0045640496136275,0.0053398710787405,0.0061071422748949,0.0068646339600721,0.0076111328400893,0.0083454433446717,0.0090663894774912,0.0097728166716997,0.0104635936259391,0.0111376141095569,0.0117937987307287,0.0124310966631116,0.0130484873275541,0.0136449820258124,0.0142196255234485,0.0147714975793035,0.0152997144190066,0.0158034301501528,0.0162818381168442,0.0167341721914293,0.0171597080013446,0.0175577640891085,0.0179277030035958,0.0182689323208423,0.0185809055927489,0.0188631232221631,0.0191151332629249,0.0193365321436287,0.0195269653138866,0.0196861278121168,0.0198137647539056,0.0199096717401820,0.0199736951845441,0.0200057325592100,0.0200057325592106,0.0199736951845438,0.0199096717401817,0.0198137647539051,0.0196861278121166,0.0195269653138871,0.0193365321436287,0.0191151332629254,0.0188631232221622,0.0185809055927495,0.0182689323208423,0.0179277030035958,0.0175577640891080,0.0171597080013453,0.0167341721914296,0.0162818381168447,0.0158034301501523,0.0152997144190065,0.0147714975793032,0.0142196255234492,0.0136449820258114,0.0130484873275551,0.0124310966631110,0.0117937987307288,0.0111376141095572,0.0104635936259388,0.0097728166716997,0.0090663894774910,0.0083454433446718,0.0076111328400896,0.0068646339600720,0.0061071422748947,0.0053398710787408,0.0045640496136273,0.0037809215947199,0.0029917449722202,0.0021977980197300,0.0014004344059192,0.0006020122830338};
static const double pts78[78] = {-0.9995307999924232,-0.9975286383787236,-0.9939299616944882,-0.9887397320937169,-0.9819661630995502,-0.9736200785062362,-0.9637148359867556,-0.9522662946898630,-0.9392927869149461,-0.9248150877800636,-0.9088563815731883,-0.8914422244588187,-0.8726005034727244,-0.8523613918225574,-0.8307573005459111,-0.8078228265942013,-0.7835946974211430,-0.7581117121623155,-0.7314146794988305,-0.7035463523039239,-0.6745513591767510,-0.6444761329727929,-0.6133688364451847,-0.5812792851159521,-0.5482588675006126,-0.5143604628138643,-0.4796383562881070,-0.4441481522404089,-0.4079466850270982,-0.3710919280285961,-0.3336429008102111,-0.2956595746075801,-0.2572027762881124,-0.2183340909422120,-0.1791157632602892,-0.1396105978534837,-0.0998818586777283,-0.0599931677222178,-0.0200084031245178,0.0200084031245182,0.0599931677222177,0.0998818586777282,0.1396105978534835,0.1791157632602894,0.2183340909422123,0.2572027762881125,0.2956595746075798,0.3336429008102104,0.3710919280285961,0.4079466850270984,0.4441481522404085,0.4796383562881073,0.5143604628138639,0.5482588675006123,0.5812792851159515,0.6133688364451848,0.6444761329727922,0.6745513591767509,0.7035463523039235,0.7314146794988305,0.7581117121623152,0.7835946974211427,0.8078228265942015,0.8307573005459110,0.8523613918225577,0.8726005034727244,0.8914422244588185,0.9088563815731882,0.9248150877800640,0.9392927869149461,0.9522662946898635,0.9637148359867558,0.9736200785062364,0.9819661630995504,0.9887397320937170,0.9939299616944889,0.9975286383787241,0.9995307999924234};

static const double w79[79] = {0.0005869650649782,0.0013654535328778,0.0021429645565631,0.0029172299343817,0.0036869605656653,0.0044509404913261,0.0052079731022564,0.0059568751075590,0.0066964766724123,0.0074256227631753,0.0081431747880959,0.0088480123121553,0.0095390347794690,0.0102151632190699,0.0108753419233040,0.0115185400928598,0.0121437534443996,0.0127500057775645,0.0133363504985527,0.0139018720977236,0.0144456875788036,0.0149669478374192,0.0154648389867621,0.0159385836283059,0.0163874420655653,0.0168107134590154,0.0172077369203386,0.0175778925443056,0.0179206023766728,0.0182353313165769,0.0185215879520233,0.0187789253271655,0.0190069416401628,0.0192052808705519,0.0193736333351202,0.0195117361714395,0.0196193737482971,0.0196963780023719,0.0197426287006454,0.0197580536281357,0.0197426287006454,0.0196963780023712,0.0196193737482973,0.0195117361714395,0.0193736333351201,0.0192052808705519,0.0190069416401628,0.0187789253271651,0.0185215879520236,0.0182353313165765,0.0179206023766734,0.0175778925443057,0.0172077369203383,0.0168107134590158,0.0163874420655650,0.0159385836283058,0.0154648389867619,0.0149669478374194,0.0144456875788034,0.0139018720977238,0.0133363504985527,0.0127500057775639,0.0121437534443997,0.0115185400928597,0.0108753419233040,0.0102151632190707,0.0095390347794689,0.0088480123121555,0.0081431747880958,0.0074256227631749,0.0066964766724129,0.0059568751075584,0.0052079731022565,0.0044509404913262,0.0036869605656654,0.0029172299343819,0.0021429645565632,0.0013654535328772,0.0005869650649784};
static const double pts79[79] = {-0.9995425284795696,-0.9975903943369414,-0.9940815547855424,-0.9890207076877845,-0.9824156592512788,-0.9742766995978065,-0.9646165291148646,-0.9534502278892687,-0.9407952293065771,-0.9266712918809037,-0.9111004680345807,-0.8941070695042347,-0.8757176293035286,-0.8559608602552193,-0.8348676101377778,-0.8124708135078073,-0.7888054402691980,-0.7639084410671702,-0.7378186895912779,-0.7105769218768240,-0.6822256726990708,-0.6528092091593444,-0.6223734615665774,-0.5909659517221404,-0.5586357187198592,-0.5254332423770549,-0.4914103644161196,-0.4566202075196888,-0.4211170923857720,-0.3849564529123511,-0.3481947496438680,-0.3108893816147370,-0.2730985967275233,-0.2348814008057318,-0.1962974654631845,-0.1574070349338614,-0.1182708320076610,-0.0789499632189542,-0.0395058234359740,0.0000000000000003,0.0395058234359742,0.0789499632189545,0.1182708320076606,0.1574070349338615,0.1962974654631846,0.2348814008057317,0.2730985967275238,0.3108893816147369,0.3481947496438678,0.3849564529123510,0.4211170923857720,0.4566202075196893,0.4914103644161196,0.5254332423770545,0.5586357187198588,0.5909659517221395,0.6223734615665772,0.6528092091593437,0.6822256726990713,0.7105769218768239,0.7378186895912779,0.7639084410671698,0.7888054402691979,0.8124708135078063,0.8348676101377780,0.8559608602552192,0.8757176293035296,0.8941070695042348,0.9111004680345807,0.9266712918809036,0.9407952293065772,0.9534502278892693,0.9646165291148647,0.9742766995978070,0.9824156592512787,0.9890207076877841,0.9940815547855425,0.9975903943369413,0.9995425284795698};

static const double w80[80] = {0.0005724750015934,0.0013317667947562,0.0020901565623478,0.0028454612257017,0.0035964523840584,0.0043419726346308,0.0050808830205516,0.0058120570603989,0.0065343807962005,0.0072467540202542,0.0079480917918627,0.0086373260281350,0.0093134071041494,0.0099753054390710,0.0106220130578912,0.0112525451231663,0.0118659414329649,0.0124612678820579,0.0130376178837824,0.0135941137502433,0.0141299080286382,0.0146441847916342,0.0151361608797787,0.0156050870940575,0.0160502493367444,0.0164709696988224,0.0168666074923056,0.0172365602258771,0.0175802645223736,0.0178971969767081,0.0181868749529178,0.0184488573191381,0.0186827451193652,0.0188881821810010,0.0190648556572387,0.0192124965034796,0.0193308798870384,0.0194198255295253,0.0194791979813848,0.0195089068281534,0.0195089068281532,0.0194791979813850,0.0194198255295259,0.0193308798870382,0.0192124965034794,0.0190648556572392,0.0188881821810008,0.0186827451193658,0.0184488573191383,0.0181868749529185,0.0178971969767078,0.0175802645223735,0.0172365602258769,0.0168666074923058,0.0164709696988227,0.0160502493367435,0.0156050870940570,0.0151361608797786,0.0146441847916338,0.0141299080286381,0.0135941137502426,0.0130376178837833,0.0124612678820581,0.0118659414329652,0.0112525451231663,0.0106220130578908,0.0099753054390709,0.0093134071041496,0.0086373260281348,0.0079480917918629,0.0072467540202548,0.0065343807962008,0.0058120570603991,0.0050808830205519,0.0043419726346307,0.0035964523840583,0.0028454612257017,0.0020901565623474,0.0013317667947562,0.0005724750015936};
static const double pts80[80] = {-0.9995538226516306,-0.9976498643982379,-0.9942275409656883,-0.9892913024997549,-0.9828485727386286,-0.9749091405857274,-0.9654850890437988,-0.9545907663436349,-0.9422427613098721,-0.9284598771724455,-0.9132631025717577,-0.8966755794387705,-0.8787225676782137,-0.8594314066631110,-0.8388314735802552,-0.8169541386814635,-0.7938327175046057,-0.7695024201350420,-0.7440002975835972,-0.7173651853621000,-0.6896376443420278,-0.6608598989861200,-0.6310757730468721,-0.6003306228297516,-0.5686712681227100,-0.5361459208971323,-0.5028041118887850,-0.4686966151705447,-0.4338753708317558,-0.3983934058819698,-0.3623047534994870,-0.3256643707477020,-0.2885280548845120,-0.2509523583922719,-0.2129945028576659,-0.1747122918326469,-0.1361640228091436,-0.0974083984415846,-0.0585044371524208,-0.0195113832567936,0.0195113832567938,0.0585044371524207,0.0974083984415842,0.1361640228091437,0.1747122918326464,0.2129945028576657,0.2509523583922717,0.2885280548845113,0.3256643707477013,0.3623047534994870,0.3983934058819688,0.4338753708317559,0.4686966151705445,0.5028041118887849,0.5361459208971319,0.5686712681227095,0.6003306228297520,0.6310757730468721,0.6608598989861196,0.6896376443420279,0.7173651853621001,0.7440002975835974,0.7695024201350417,0.7938327175046054,0.8169541386814640,0.8388314735802552,0.8594314066631112,0.8787225676782139,0.8966755794387707,0.9132631025717581,0.9284598771724457,0.9422427613098728,0.9545907663436348,0.9654850890437993,0.9749091405857276,0.9828485727386292,0.9892913024997555,0.9942275409656882,0.9976498643982380,0.9995538226516306};

static const double w81[81] = {0.0005585149235623,0.0012993111499644,0.0020392755567110,0.0027763056851283,0.0035092302424657,0.0042369468926726,0.0049583709047978,0.0056724292477083,0.0063780605575673,0.0070742162566177,0.0077598619562324,0.0084339789338178,0.0090955656206278,0.0097436390778009,0.0103772364507230,0.0109954163963756,0.0115972604801366,0.0121818745392818,0.0127483900108328,0.0132959652216100,0.0138237866384624,0.0143310700767803,0.0148170618654526,0.0152810399665266,0.0157223150478870,0.0161402315073660,0.0165341684467443,0.0169035405941981,0.0172477991738299,0.0175664327209695,0.0178589678420521,0.0181249699179322,0.0183640437495899,0.0185758341452819,0.0187600264482379,0.0189163470041503,0.0190445635677378,0.0191444856477914,0.0192159647901876,0.0192588947984420,0.0192732118914907,0.0192588947984426,0.0192159647901878,0.0191444856477919,0.0190445635677379,0.0189163470041504,0.0187600264482378,0.0185758341452821,0.0183640437495902,0.0181249699179317,0.0178589678420524,0.0175664327209694,0.0172477991738301,0.0169035405941978,0.0165341684467436,0.0161402315073657,0.0157223150478874,0.0152810399665263,0.0148170618654529,0.0143310700767805,0.0138237866384626,0.0132959652216097,0.0127483900108326,0.0121818745392812,0.0115972604801370,0.0109954163963759,0.0103772364507231,0.0097436390778011,0.0090955656206279,0.0084339789338175,0.0077598619562322,0.0070742162566180,0.0063780605575667,0.0056724292477083,0.0049583709047983,0.0042369468926724,0.0035092302424659,0.0027763056851280,0.0020392755567107,0.0012993111499647,0.0005585149235621};
static const double pts81[81] = {-0.9995647036903187,-0.9977071599883461,-0.9943681932852197,-0.9895520213710212,-0.9832657085664298,-0.9755185726723610,-0.9663221163380558,-0.9556899997564020,-0.9436380176528137,-0.9301840749151671,-0.9153481596407510,-0.8991523132861565,-0.8816205978467195,-0.8627790600697921,-0.8426556927364667,-0.8212803930609103,-0.7986849182650287,-0.7749028383924234,-0.7499694864306208,-0.7239219058150526,-0.6967987953924358,-0.6686404519250901,-0.6394887102214947,-0.6093868809819367,-0.5783796864515511,-0.5465131939763115,-0.5138347475606585,-0.4803928975284487,-0.4462373283916999,-0.4114187850342974,-0.3759889973203315,-0.3400006032390490,-0.3035070707006261,-0.2665626180989354,-0.2292221337593157,-0.1915410943910431,-0.1535754826656305,-0.1153817040434366,-0.0770165029721267,-0.0385368785815123,-0.0000000000000004,0.0385368785815120,0.0770165029721270,0.1153817040434366,0.1535754826656304,0.1915410943910428,0.2292221337593159,0.2665626180989353,0.3035070707006262,0.3400006032390481,0.3759889973203310,0.4114187850342976,0.4462373283916989,0.4803928975284482,0.5138347475606582,0.5465131939763113,0.5783796864515515,0.6093868809819371,0.6394887102214946,0.6686404519250901,0.6967987953924356,0.7239219058150523,0.7499694864306207,0.7749028383924234,0.7986849182650283,0.8212803930609104,0.8426556927364670,0.8627790600697917,0.8816205978467200,0.8991523132861564,0.9153481596407506,0.9301840749151672,0.9436380176528136,0.9556899997564027,0.9663221163380560,0.9755185726723612,0.9832657085664300,0.9895520213710219,0.9943681932852199,0.9977071599883465,0.9995647036903190};

static const double w82[82] = {0.0005450592976380,0.0012680273484280,0.0019902289689275,0.0027096381162239,0.0034251372670915,0.0041356759091919,0.0048402203521859,0.0055377478908798,0.0062272467005707,0.0069077168570634,0.0075781716353813,0.0082376388819919,0.0088851623992493,0.0095198033200894,0.0101406414634561,0.0107467766653874,0.0113373300824568,0.0119114454650246,0.0124682903981201,0.0130070575080085,0.0135269656325623,0.0140272609537271,0.0145072180903822,0.0149661411500064,0.0154033647376074,0.0158182549204506,0.0162102101471700,0.0165786621199535,0.0169230766184984,0.0172429542745756,0.0175378312960561,0.0178072801393636,0.0180509101293639,0.0182683680258038,0.0184593385354770,0.0186235447693638,0.0187607486440927,0.0188707512271379,0.0189533930252528,0.0190085542157176,0.0190361548200710,0.0190361548200709,0.0190085542157177,0.0189533930252528,0.0188707512271378,0.0187607486440925,0.0186235447693641,0.0184593385354773,0.0182683680258040,0.0180509101293632,0.0178072801393633,0.0175378312960562,0.0172429542745756,0.0169230766184981,0.0165786621199539,0.0162102101471704,0.0158182549204502,0.0154033647376076,0.0149661411500067,0.0145072180903820,0.0140272609537274,0.0135269656325619,0.0130070575080087,0.0124682903981208,0.0119114454650242,0.0113373300824572,0.0107467766653875,0.0101406414634560,0.0095198033200893,0.0088851623992493,0.0082376388819919,0.0075781716353813,0.0069077168570631,0.0062272467005708,0.0055377478908800,0.0048402203521857,0.0041356759091920,0.0034251372670921,0.0027096381162230,0.0019902289689282,0.0012680273484278,0.0005450592976379};
static const double pts82[82] = {-0.9995751915016529,-0.9977623858263855,-0.9945037683780756,-0.9898033388399092,-0.9836678235220079,-0.9761060970944991,-0.9671291162525905,-0.9567498938616109,-0.9449834774389611,-0.9318469264546232,-0.9173592872532801,-0.9015415652888412,-0.8844166945967246,-0.8660095045047652,-0.8463466836129131,-0.8254567410857675,-0.8033699653101085,-0.7801183799753583,-0.7557356976395602,-0.7302572708475961,-0.7037200408721666,-0.6761624841516469,-0.6476245565023470,-0.6181476351859784,-0.5877744589162852,-0.5565490658917638,-0.5245167299443280,-0.4917238948964500,-0.4582181072219628,-0.4240479471081505,-0.3892629580190550,-0.3539135748621486,-0.3180510508625020,-0.2817273832504801,-0.2449952378707045,-0.2079078728215925,-0.1705190612361903,-0.1328830133162578,-0.0950542977326454,-0.0570877625059274,-0.0190384554820071,0.0190384554820067,0.0570877625059265,0.0950542977326449,0.1328830133162573,0.1705190612361902,0.2079078728215924,0.2449952378707046,0.2817273832504802,0.3180510508625020,0.3539135748621479,0.3892629580190547,0.4240479471081512,0.4582181072219631,0.4917238948964492,0.5245167299443279,0.5565490658917638,0.5877744589162850,0.6181476351859789,0.6476245565023467,0.6761624841516470,0.7037200408721668,0.7302572708475965,0.7557356976395604,0.7801183799753582,0.8033699653101083,0.8254567410857675,0.8463466836129139,0.8660095045047657,0.8844166945967248,0.9015415652888416,0.9173592872532801,0.9318469264546230,0.9449834774389604,0.9567498938616110,0.9671291162525909,0.9761060970944990,0.9836678235220077,0.9898033388399089,0.9945037683780754,0.9977623858263860,0.9995751915016529};

static const double w83[83] = {0.0005320841098339,0.0012378596612725,0.0019429297176767,0.0026453407229301,0.0033440258176216,0.0040379832965614,0.0047262275462398,0.0054077832790186,0.0060816853638993,0.0067469797561874,0.0074027247003590,0.0080479920059677,0.0086818683369125,0.0093034564927395,0.0099118766728272,0.0105062677186353,0.0110857883309017,0.0116496182594502,0.0121969594635793,0.0127270372412447,0.0132391013253368,0.0137324269454520,0.0142063158536236,0.0146600973125523,0.0150931290449069,0.0155047981423698,0.0158945219331109,0.0162617488064845,0.0166059589937522,0.0169266653037575,0.0172234138124754,0.0174957845054895,0.0177433918724735,0.0179658854528306,0.0181629503317309,0.0183343075858392,0.0184797146780926,0.0185989658009886,0.0186918921678783,0.0187583622518685,0.0187982819719774,0.0188115948263001,0.0187982819719776,0.0187583622518685,0.0186918921678789,0.0185989658009878,0.0184797146780925,0.0183343075858391,0.0181629503317310,0.0179658854528300,0.0177433918724736,0.0174957845054899,0.0172234138124754,0.0169266653037575,0.0166059589937522,0.0162617488064837,0.0158945219331111,0.0155047981423699,0.0150931290449070,0.0146600973125522,0.0142063158536242,0.0137324269454511,0.0132391013253371,0.0127270372412442,0.0121969594635792,0.0116496182594504,0.0110857883309016,0.0105062677186354,0.0099118766728278,0.0093034564927390,0.0086818683369121,0.0080479920059678,0.0074027247003591,0.0067469797561878,0.0060816853638995,0.0054077832790183,0.0047262275462396,0.0040379832965611,0.0033440258176220,0.0026453407229303,0.0019429297176765,0.0012378596612733,0.0005320841098335};
static const double pts83[83] = {-0.9995853048070485,-0.9978156404034291,-0.9946345076317797,-0.9900457012972642,-0.9840556295966805,-0.9766727500728426,-0.9679075054501279,-0.9577722991227663,-0.9462814750117905,-0.9334512964018388,-0.9192999225872081,-0.9038473830228997,-0.8871155489050638,-0.8691281021787169,-0.8499105019989339,-0.8294899486849845,-0.8078953452145897,-0.7851572563108159,-0.7613078651784587,-0.7363809279505644,-0.7104117259092174,-0.6834370155480222,-0.6554949765468232,-0.6266251577322393,-0.5968684211004188,-0.5662668839812413,-0.5348638594257853,-0.5027037949014260,-0.4698322093813203,-0.4362956289173198,-0.4021415207874885,-0.3674182263114403,-0.3321748924285648,-0.2964614021360036,-0.2603283038848260,-0.2238267400343274,-0.1870083744657229,-0.1499253194576872,-0.1126300619272408,-0.0751753891403780,-0.0376143139975853,-0.0000000000000004,0.0376143139975840,0.0751753891403769,0.1126300619272400,0.1499253194576869,0.1870083744657229,0.2238267400343275,0.2603283038848266,0.2964614021360035,0.3321748924285642,0.3674182263114404,0.4021415207874886,0.4362956289173194,0.4698322093813203,0.5027037949014259,0.5348638594257854,0.5662668839812409,0.5968684211004184,0.6266251577322397,0.6554949765468234,0.6834370155480217,0.7104117259092174,0.7363809279505644,0.7613078651784587,0.7851572563108158,0.8078953452145899,0.8294899486849844,0.8499105019989336,0.8691281021787171,0.8871155489050632,0.9038473830228997,0.9192999225872081,0.9334512964018384,0.9462814750117907,0.9577722991227668,0.9679075054501288,0.9766727500728428,0.9840556295966814,0.9900457012972653,0.9946345076317804,0.9978156404034297,0.9995853048070492};

static const double w84[84] = {0.0005195667582262,0.0012087556327214,0.0018972958252262,0.0025833025913734,0.0032657568438567,0.0039437028763242,0.0046162003920948,0.0052823188115039,0.0059411370449008,0.0065917443395914,0.0072332413945804,0.0078647415477921,0.0084853719776058,0.0090942748980281,0.0096906087386594,0.0102735493048780,0.0108422909153225,0.0113960475144711,0.0119340537584788,0.0124555660726031,0.0129598636786676,0.0134462495910988,0.0139140515801292,0.0143626231008109,0.0147913441865556,0.0151996223059513,0.0155868931816726,0.0159526215703467,0.0162963020022921,0.0166174594801201,0.0169156501352129,0.0171904618411865,0.0174415147834813,0.0176684619843006,0.0178709897821578,0.0180488182653863,0.0182017016590012,0.0183294286643796,0.0184318227512951,0.0185087424018972,0.0185600813063008,0.0185857685095171,0.0185857685095169,0.0185600813063010,0.0185087424018974,0.0184318227512951,0.0183294286643796,0.0182017016590012,0.0180488182653860,0.0178709897821579,0.0176684619843002,0.0174415147834812,0.0171904618411859,0.0169156501352129,0.0166174594801205,0.0162963020022919,0.0159526215703463,0.0155868931816726,0.0151996223059517,0.0147913441865557,0.0143626231008114,0.0139140515801293,0.0134462495910992,0.0129598636786674,0.0124555660726030,0.0119340537584795,0.0113960475144709,0.0108422909153226,0.0102735493048781,0.0096906087386598,0.0090942748980284,0.0084853719776059,0.0078647415477913,0.0072332413945808,0.0065917443395911,0.0059411370449009,0.0052823188115036,0.0046162003920952,0.0039437028763243,0.0032657568438569,0.0025833025913729,0.0018972958252263,0.0012087556327217,0.0005195667582259};
static const double pts84[84] = {-0.9995950612269233,-0.9978670164217116,-0.9947606382612848,-0.9902795289653566,-0.9844297971275821,-0.9772195073583160,-0.9686586181736220,-0.9587589587296934,-0.9475342099474433,-0.9349998847635588,-0.9211733063630509,-0.9060735840940081,-0.8897215869883155,-0.8721399148835787,-0.8533528671689183,-0.8333864091900214,-0.8122681363561230,-0.7900272359965967,-0.7666944470188362,-0.7423020174226099,-0.7168836597292748,-0.6904745043872484,-0.6631110512180146,-0.6348311189696918,-0.6056737930478331,-0.5756793714956741,-0.5448893092984494,-0.5133461610887613,-0.4810935223321562,-0.4481759690742025,-0.4146389963323315,-0.3805289552175882,-0.3458929888731968,-0.3107789673184641,-0.2752354212880884,-0.2393114751583031,-0.2030567790525533,-0.1665214402205475,-0.1297559537855245,-0.0928111329554379,-0.0557380387945282,-0.0185879096523323,0.0185879096523321,0.0557380387945281,0.0928111329554381,0.1297559537855247,0.1665214402205482,0.2030567790525532,0.2393114751583028,0.2752354212880880,0.3107789673184638,0.3458929888731971,0.3805289552175888,0.4146389963323311,0.4481759690742024,0.4810935223321560,0.5133461610887611,0.5448893092984496,0.5756793714956741,0.6056737930478332,0.6348311189696912,0.6631110512180146,0.6904745043872484,0.7168836597292746,0.7423020174226099,0.7666944470188363,0.7900272359965967,0.8122681363561232,0.8333864091900215,0.8533528671689186,0.8721399148835790,0.8897215869883153,0.9060735840940084,0.9211733063630507,0.9349998847635589,0.9475342099474428,0.9587589587296935,0.9686586181736220,0.9772195073583155,0.9844297971275814,0.9902795289653564,0.9947606382612846,0.9978670164217116,0.9995950612269232};

static const double w85[85] = {0.0005074859544841,0.0011806658521423,0.0018532500628798,0.0025234192134625,0.0031901992939482,0.0038526779801916,0.0045099577199966,0.0051611501152619,0.0058053756433526,0.0064417644282488,0.0070694572742003,0.0076876067711951,0.0082953784155772,0.0088919517256989,0.0094765213440915,0.0100482981217875,0.0106065101820451,0.0111504039614193,0.0116792452264951,0.0121923200647181,0.0126889358479331,0.0131684221672569,0.0136301317380059,0.0140734412734324,0.0144977523260950,0.0149024920956979,0.0152871142023252,0.0156510994240106,0.0159939563976521,0.0163152222823211,0.0166144633840661,0.0168912757413788,0.0171452856705149,0.0173761502699509,0.0175835578832776,0.0177672285199277,0.0179269142331404,0.0180623994546813,0.0181735012858473,0.0182600697443727,0.0183219879668930,0.0183591723667098,0.0183715727466259,0.0183591723667099,0.0183219879668925,0.0182600697443725,0.0181735012858475,0.0180623994546812,0.0179269142331411,0.0177672285199276,0.0175835578832778,0.0173761502699503,0.0171452856705148,0.0168912757413785,0.0166144633840664,0.0163152222823210,0.0159939563976525,0.0156510994240099,0.0152871142023251,0.0149024920956982,0.0144977523260948,0.0140734412734321,0.0136301317380059,0.0131684221672572,0.0126889358479330,0.0121923200647182,0.0116792452264953,0.0111504039614196,0.0106065101820444,0.0100482981217877,0.0094765213440916,0.0088919517256986,0.0082953784155770,0.0076876067711951,0.0070694572742009,0.0064417644282487,0.0058053756433523,0.0051611501152620,0.0045099577199969,0.0038526779801917,0.0031901992939484,0.0025234192134627,0.0018532500628795,0.0011806658521424,0.0005074859544837};
static const double pts85[85] = {-0.9996044773574783,-0.9979166011981165,-0.9948823742956161,-0.9905052177164158,-0.9847909576855806,-0.9777472884122436,-0.9693837119236787,-0.9597115159571887,-0.9487437562545786,-0.9364952381164307,-0.9229824960960900,-0.9082237715390917,-0.8922389878913560,-0.8750497237690964,-0.8566791838099562,-0.8371521673370828,-0.8164950348747917,-0.7947356725591168,-0.7719034544902932,-0.7480292030774343,-0.7231451474286010,-0.6972848798422500,-0.6704833104586626,-0.6427766201325144,-0.6142022115901368,-0.5847986589373881,-0.5546056555862694,-0.5236639606705678,-0.4920153440228512,-0.4597025297870892,-0.4267691387430097,-0.3932596294200596,-0.3592192380804383,-0.3246939176522480,-0.2897302756951738,-0.2543755114824534,-0.2186773522840588,-0.1826839889371127,-0.1464440107905113,-0.1100063401115775,-0.0734201660432915,-0.0367348782012496,-0.0000000000000004,0.0367348782012497,0.0734201660432911,0.1100063401115773,0.1464440107905109,0.1826839889371127,0.2186773522840585,0.2543755114824535,0.2897302756951739,0.3246939176522474,0.3592192380804377,0.3932596294200592,0.4267691387430096,0.4597025297870888,0.4920153440228515,0.5236639606705680,0.5546056555862693,0.5847986589373878,0.6142022115901368,0.6427766201325154,0.6704833104586624,0.6972848798422494,0.7231451474286013,0.7480292030774344,0.7719034544902926,0.7947356725591164,0.8164950348747917,0.8371521673370829,0.8566791838099560,0.8750497237690970,0.8922389878913562,0.9082237715390921,0.9229824960960898,0.9364952381164302,0.9487437562545791,0.9597115159571881,0.9693837119236787,0.9777472884122431,0.9847909576855807,0.9905052177164162,0.9948823742956162,0.9979166011981170,0.9996044773574785};

static const double w86[86] = {0.0004958216333101,0.0011535437444050,0.0018107196248053,0.0024655920484797,0.0031172295695706,0.0037647608060974,0.0044073285509777,0.0050440842301928,0.0056741875780889,0.0062968073390345,0.0069111222263837,0.0075163219525406,0.0081116082748647,0.0086961960378453,0.0092693142033548,0.0098302068647812,0.0103781342424547,0.0109123736584637,0.0114322204892739,0.0119369890947395,0.0124260137221997,0.0128986493844198,0.0133542727101863,0.0137922827664257,0.0142121018507469,0.0146131762533551,0.0149949769873324,0.0153570004863161,0.0156987692686512,0.0160198325671470,0.0163197669235947,0.0165981767472759,0.0168546948367091,0.0170889828639598,0.0173007318208694,0.0174896624266050,0.0176555254960171,0.0177981022682877,0.0179172046954620,0.0180126756904674,0.0180843893343002,0.0181322510421012,0.0181561976879070,0.0181561976879063,0.0181322510421015,0.0180843893343003,0.0180126756904676,0.0179172046954622,0.0177981022682881,0.0176555254960172,0.0174896624266047,0.0173007318208694,0.0170889828639601,0.0168546948367086,0.0165981767472754,0.0163197669235950,0.0160198325671471,0.0156987692686514,0.0153570004863160,0.0149949769873330,0.0146131762533548,0.0142121018507462,0.0137922827664261,0.0133542727101862,0.0128986493844201,0.0124260137222001,0.0119369890947394,0.0114322204892743,0.0109123736584632,0.0103781342424540,0.0098302068647813,0.0092693142033549,0.0086961960378452,0.0081116082748649,0.0075163219525403,0.0069111222263830,0.0062968073390348,0.0056741875780892,0.0050440842301932,0.0044073285509774,0.0037647608060975,0.0031172295695700,0.0024655920484797,0.0018107196248058,0.0011535437444048,0.0004958216333102};
static const double pts86[86] = {-0.9996135688413257,-0.9979644770352442,-0.9949999174853379,-0.9907231407455188,-0.9851397067325027,-0.9782569602536850,-0.9700839726857401,-0.9606315209428983,-0.9499120708522104,-0.9379397599098929,-0.9247303783228619,-0.9103013480461657,-0.8946716997394463,-0.8778620476333656,-0.8598945623226850,-0.8407929415144336,-0.8205823787661601,-0.7992895302536621,-0.7769424796110235,-0.7535707008888088,-0.7292050196789289,-0.7038775724572677,-0.6776217641975885,-0.6504722243125262,-0.6224647609797510,-0.5936363139134976,-0.5640249056437406,-0.5336695913672487,-0.5026104074366571,-0.4708883185554981,-0.4385451637488099,-0.4056236011806005,-0.3721670518909392,-0.3382196425268729,-0.3038261471427061,-0.2690319281464104,-0.2338828764700375,-0.1984253510430511,-0.1627061176484115,-0.1267722872420480,-0.0906712538170805,-0.0544506318947313,-0.0181581937243857,0.0181581937243861,0.0544506318947315,0.0906712538170802,0.1267722872420482,0.1627061176484116,0.1984253510430514,0.2338828764700375,0.2690319281464102,0.3038261471427059,0.3382196425268732,0.3721670518909401,0.4056236011806012,0.4385451637488094,0.4708883185554981,0.5026104074366574,0.5336695913672491,0.5640249056437413,0.5936363139134981,0.6224647609797509,0.6504722243125262,0.6776217641975888,0.7038775724572672,0.7292050196789281,0.7535707008888092,0.7769424796110236,0.7992895302536612,0.8205823787661602,0.8407929415144331,0.8598945623226851,0.8778620476333661,0.8946716997394463,0.9103013480461659,0.9247303783228618,0.9379397599098929,0.9499120708522102,0.9606315209428984,0.9700839726857400,0.9782569602536846,0.9851397067325024,0.9907231407455190,0.9949999174853378,0.9979644770352438,0.9996135688413259};

static const double w87[87] = {0.0004845548690884,0.0011273453768766,0.0017696358276941,0.0024097281192511,0.0030467310238173,0.0036798118244090,0.0043081514192446,0.0049309388568512,0.0055473709702802,0.0061566530150237,0.0067579995591228,0.0073506354436203,0.0079337967594126,0.0085067318215006,0.0090687021326773,0.0096189833326782,0.0101568661303277,0.0106816572169014,0.0111926801592427,0.0116892762713302,0.0121708054630841,0.0126366470652782,0.0130862006294666,0.0135188867018678,0.0139341475702148,0.0143314479825881,0.0147102758373114,0.0150701428430096,0.0154105851479810,0.0157311639380755,0.0160314660022951,0.0163111042654007,0.0165697182868309,0.0168069747252884,0.0170225677684002,0.0172162195268905,0.0173876803927737,0.0175367293610762,0.0176631743147051,0.0177668522720805,0.0178476295972046,0.0179054021719168,0.0179400955300934,0.0179516649536326,0.0179400955300935,0.0179054021719171,0.0178476295972045,0.0177668522720802,0.0176631743147053,0.0175367293610761,0.0173876803927740,0.0172162195268910,0.0170225677683999,0.0168069747252881,0.0165697182868313,0.0163111042654007,0.0160314660022945,0.0157311639380758,0.0154105851479820,0.0150701428430094,0.0147102758373117,0.0143314479825881,0.0139341475702140,0.0135188867018679,0.0130862006294667,0.0126366470652784,0.0121708054630841,0.0116892762713302,0.0111926801592430,0.0106816572169016,0.0101568661303277,0.0096189833326784,0.0090687021326769,0.0085067318215002,0.0079337967594137,0.0073506354436198,0.0067579995591230,0.0061566530150239,0.0055473709702804,0.0049309388568509,0.0043081514192441,0.0036798118244089,0.0030467310238176,0.0024097281192509,0.0017696358276945,0.0011273453768761,0.0004845548690887};
static const double pts87[87] = {-0.9996223504324840,-0.9980107215629825,-0.9951134581379922,-0.9909336501109645,-0.9854766060684202,-0.9787493410038163,-0.9707605197472847,-0.9615204369360736,-0.9510410013893140,-0.9393357199742061,-0.9264196798912374,-0.9123095290941228,-0.8970234547675694,-0.8805811598520416,-0.8630038376297067,-0.8443141443970351,-0.8245361702557803,-0.8036954080581775,-0.7818187205454374,-0.7589343057213492,-0.7350716605053133,-0.7102615427114729,-0.6845359314028238,-0.6579279856713496,-0.6304720018972506,-0.6022033695423357,-0.5731585255345306,-0.5433749073022938,-0.5128909045194524,-0.4817458096226673,-0.4499797671652836,-0.4176337220728688,-0.3847493668670964,-0.3513690879260408,-0.3175359108501156,-0.2832934450040915,-0.2486858273066768,-0.2137576653401013,-0.1785539798530440,-0.1431201467310083,-0.1075018385089432,-0.0717449655015000,-0.0358956166268011,-0.0000000000000000,0.0358956166268005,0.0717449655014991,0.1075018385089427,0.1431201467310083,0.1785539798530442,0.2137576653401020,0.2486858273066773,0.2832934450040919,0.3175359108501156,0.3513690879260414,0.3847493668670970,0.4176337220728689,0.4499797671652848,0.4817458096226670,0.5128909045194521,0.5433749073022934,0.5731585255345303,0.6022033695423352,0.6304720018972503,0.6579279856713489,0.6845359314028235,0.7102615427114730,0.7350716605053139,0.7589343057213495,0.7818187205454377,0.8036954080581777,0.8245361702557803,0.8443141443970352,0.8630038376297068,0.8805811598520414,0.8970234547675693,0.9123095290941228,0.9264196798912372,0.9393357199742058,0.9510410013893132,0.9615204369360733,0.9707605197472839,0.9787493410038162,0.9854766060684201,0.9909336501109647,0.9951134581379918,0.9980107215629825,0.9996223504324840};

static const double w88[88] = {0.0004736677990812,0.0011020292815719,0.0017299338339314,0.0023557396397995,0.0029785934980682,0.0035976992298985,0.0042122737463511,0.0048215416610265,0.0054247348877146,0.0060210932197909,0.0066098651568139,0.0071903088006496,0.0077616927684670,0.0083232971041091,0.0088744141801618,0.0094143495868775,0.0099424230056371,0.0104579690652886,0.0109603381799948,0.0114488973673907,0.0119230310459295,0.0123821418103842,0.0128256511844810,0.0132530003497176,0.0136636508494277,0.0140570852672038,0.0144328078788178,0.0147903452768100,0.0151292469669720,0.0154490859359561,0.0157494591893022,0.0160299882592032,0.0162903196813661,0.0165301254403734,0.0167491033829759,0.0169469775988050,0.0171234987680103,0.0172784444754039,0.0174116194906997,0.0175228560145021,0.0176120138897294,0.0176789807782120,0.0177236723022349,0.0177460321508573,0.0177460321508573,0.0177236723022353,0.0176789807782115,0.0176120138897295,0.0175228560145024,0.0174116194906998,0.0172784444754038,0.0171234987680095,0.0169469775988052,0.0167491033829767,0.0165301254403734,0.0162903196813658,0.0160299882592039,0.0157494591893029,0.0154490859359562,0.0151292469669714,0.0147903452768096,0.0144328078788177,0.0140570852672044,0.0136636508494278,0.0132530003497173,0.0128256511844807,0.0123821418103843,0.0119230310459295,0.0114488973673904,0.0109603381799955,0.0104579690652881,0.0099424230056372,0.0094143495868778,0.0088744141801620,0.0083232971041095,0.0077616927684664,0.0071903088006499,0.0066098651568137,0.0060210932197902,0.0054247348877148,0.0048215416610265,0.0042122737463512,0.0035976992298984,0.0029785934980691,0.0023557396397994,0.0017299338339314,0.0011020292815719,0.0004736677990810};
static const double pts88[88] = {-0.9996308360562707,-0.9980554080532491,-0.9952231758879885,-0.9911370781540151,-0.9858021860877636,-0.9792252031542967,-0.9714144101413225,-0.9623796460637715,-0.9521322934638020,-0.9406852633026432,-0.9280529783946919,-0.9142513551045268,-0.8992977832300566,-0.8832111040594506,-0.8660115866137811,-0.8477209020982091,-0.8283620965904566,-0.8079595619992365,-0.7865390053282872,-0.7641274162842063,-0.7407530332686078,-0.7164453077972504,-0.6912348673908805,-0.6651534769844533,-0.6382339989033260,-0.6105103514568192,-0.5820174662012878,-0.5527912439265559,-0.5228685094211433,-0.4922869650732863,-0.4610851433661971,-0.4293023583274242,-0.3969786559934908,-0.3641547639521978,-0.3308720400261961,-0.2971724201624641,-0.2630983655933627,-0.2286928093358314,-0.1939991020961467,-0.1590609576483940,-0.1239223977554793,-0.0886276967020762,-0.0532213255094039,-0.0177478959021125,0.0177478959021119,0.0532213255094032,0.0886276967020759,0.1239223977554789,0.1590609576483937,0.1939991020961464,0.2286928093358307,0.2630983655933622,0.2971724201624643,0.3308720400261962,0.3641547639521985,0.3969786559934910,0.4293023583274245,0.4610851433661964,0.4922869650732871,0.5228685094211442,0.5527912439265554,0.5820174662012878,0.6105103514568192,0.6382339989033267,0.6651534769844529,0.6912348673908805,0.7164453077972504,0.7407530332686078,0.7641274162842072,0.7865390053282871,0.8079595619992364,0.8283620965904562,0.8477209020982091,0.8660115866137814,0.8832111040594505,0.8992977832300570,0.9142513551045273,0.9280529783946919,0.9406852633026438,0.9521322934638020,0.9623796460637709,0.9714144101413222,0.9792252031542966,0.9858021860877636,0.9911370781540154,0.9952231758879888,0.9980554080532495,0.9996308360562707};

static const double w89[89] = {0.0004631435525965,0.0010775562911093,0.0016915523962038,0.0023035436717316,0.0029127128943852,0.0035182984354947,0.0041195512626946,0.0047157296303985,0.0053060986449861,0.0058899307904379,0.0064665066963012,0.0070351159743222,0.0075950580723333,0.0081456431273963,0.0086861928107508,0.0092160411608924,0.0097345354025758,0.0102410367502007,0.0107349211942802,0.0112155802699182,0.0116824218062278,0.0121348706557608,0.0125723694030016,0.0129943790510369,0.0134003796855644,0.0137898711153921,0.0141623734886528,0.0145174278839633,0.0148545968758060,0.0151734650734250,0.0154736396325777,0.0157547507395171,0.0160164520665947,0.0162584211989319,0.0164803600316309,0.0166819951370381,0.0168630781016075,0.0170233858319353,0.0171627208296193,0.0172809114345689,0.0173778120364911,0.0174533032542802,0.0175072920830984,0.0175397120089507,0.0175505230906364,0.0175397120089506,0.0175072920830981,0.0174533032542801,0.0173778120364903,0.0172809114345691,0.0171627208296197,0.0170233858319359,0.0168630781016076,0.0166819951370386,0.0164803600316306,0.0162584211989314,0.0160164520665948,0.0157547507395171,0.0154736396325776,0.0151734650734245,0.0148545968758066,0.0145174278839633,0.0141623734886527,0.0137898711153922,0.0134003796855647,0.0129943790510372,0.0125723694030017,0.0121348706557611,0.0116824218062285,0.0112155802699183,0.0107349211942802,0.0102410367502001,0.0097345354025757,0.0092160411608918,0.0086861928107511,0.0081456431273962,0.0075950580723328,0.0070351159743217,0.0064665066963013,0.0058899307904378,0.0053060986449859,0.0047157296303989,0.0041195512626943,0.0035182984354952,0.0029127128943851,0.0023035436717317,0.0016915523962041,0.0010775562911092,0.0004631435525970};
static const double pts89[89] = {-0.9996390388645336,-0.9980986057102742,-0.9953292404067499,-0.9913337388086657,-0.9861169478611039,-0.9796852765838769,-0.9720466427489095,-0.9632104546565361,-0.9531875972928414,-0.9419904181702150,-0.9296327118237186,-0.9161297026888232,-0.9014980262839978,-0.8857557086844695,-0.8689221442970838,-0.8510180719566777,-0.8320655493700790,-0.8120879259374857,-0.7911098139837935,-0.7691570584348014,-0.7462567049753602,-0.7224369667285084,-0.6977271894965400,-0.6721578156067597,-0.6457603464064209,-0.6185673034530197,-0.5906121884477528,-0.5619294419614645,-0.5325544010039442,-0.5025232554888300,-0.4718730036477530,-0.4406414064486519,-0.4088669410743989,-0.3765887535190675,-0.3438466103602280,-0.3106808497666889,-0.2771323318020519,-0.2432423880852819,-0.2090527708703415,-0.1746056016075962,-0.1399433190503741,-0.1051086269706137,-0.0701444415480060,-0.0350938384974570,-0.0000000000000000,0.0350938384974570,0.0701444415480062,0.1051086269706136,0.1399433190503743,0.1746056016075965,0.2090527708703419,0.2432423880852823,0.2771323318020522,0.3106808497666897,0.3438466103602285,0.3765887535190678,0.4088669410743990,0.4406414064486517,0.4718730036477532,0.5025232554888294,0.5325544010039437,0.5619294419614643,0.5906121884477529,0.6185673034530192,0.6457603464064201,0.6721578156067598,0.6977271894965400,0.7224369667285085,0.7462567049753600,0.7691570584348013,0.7911098139837934,0.8120879259374864,0.8320655493700793,0.8510180719566776,0.8689221442970839,0.8857557086844698,0.9014980262839976,0.9161297026888233,0.9296327118237190,0.9419904181702151,0.9531875972928411,0.9632104546565355,0.9720466427489096,0.9796852765838765,0.9861169478611034,0.9913337388086655,0.9953292404067496,0.9980986057102740,0.9996390388645335};

static const double w90[90] = {0.0004529661856075,0.0010538893872630,0.0016544336216680,0.0022530618068376,0.0028489907803736,0.0034414916042320,0.0040298474723096,0.0046133484788709,0.0051912911549465,0.0057629789445741,0.0063277229185844,0.0068848425561685,0.0074336665440216,0.0079735335755035,0.0085037931426114,0.0090238063172300,0.0095329465195685,0.0100306002723202,0.0105161679393610,0.0109890644479668,0.0114487199935817,0.0118945807262645,0.0123261094179523,0.0127427861097218,0.0131441087382572,0.0135295937407738,0.0138987766376514,0.0142512125920805,0.0145864769460505,0.0149041657320155,0.0152038961596436,0.0154853070770402,0.0157480594059093,0.0159918365501090,0.0162163447771278,0.0164213135720039,0.0166064959632758,0.0167716688205623,0.0169166331234156,0.0170412142011266,0.0171452619431877,0.0172286509801620,0.0172912808347489,0.0173330760428438,0.0173539862444750,0.0173539862444748,0.0173330760428444,0.0172912808347487,0.0172286509801622,0.0171452619431875,0.0170412142011265,0.0169166331234157,0.0167716688205619,0.0166064959632754,0.0164213135720041,0.0162163447771283,0.0159918365501098,0.0157480594059095,0.0154853070770404,0.0152038961596432,0.0149041657320156,0.0145864769460502,0.0142512125920811,0.0138987766376510,0.0135295937407738,0.0131441087382571,0.0127427861097214,0.0123261094179525,0.0118945807262643,0.0114487199935813,0.0109890644479667,0.0105161679393611,0.0100306002723200,0.0095329465195681,0.0090238063172303,0.0085037931426115,0.0079735335755031,0.0074336665440221,0.0068848425561686,0.0063277229185844,0.0057629789445739,0.0051912911549465,0.0046133484788714,0.0040298474723103,0.0034414916042315,0.0028489907803738,0.0022530618068378,0.0016544336216677,0.0010538893872629,0.0004529661856073};
static const double pts90[90] = {-0.9996469712866387,-0.9981403799385683,-0.9954318120583446,-0.9915239288110629,-0.9864213650578327,-0.9801302513451480,-0.9726581620901926,-0.9640140981715055,-0.9542084738815005,-0.9432531036453576,-0.9311611875004320,-0.9179472950665862,-0.9036273479313023,-0.8882186004347459,-0.8717396188629031,-0.8542102590670712,-0.8356516425333769,-0.8160861309294807,-0.7955372991582477,-0.7740299069503346,-0.7515898690296390,-0.7282442238873903,-0.7040211012023913,-0.6789496879465970,-0.6530601932168423,-0.6263838118350447,-0.5989526867607421,-0.5707998703612206,-0.5419592845859135,-0.5124656800930277,-0.4823545943776656,-0.4516623089518697,-0.4204258056281979,-0.3886827219594979,-0.3564713058885673,-0.3238303696623459,-0.2907992430661662,-0.2574177260344201,-0.2237260406947227,-0.1897647829033791,-0.1555748733305291,-0.1211975081539242,-0.0866741094207350,-0.0520462751372070,-0.0173557291463000,0.0173557291462997,0.0520462751372067,0.0866741094207348,0.1211975081539241,0.1555748733305290,0.1897647829033789,0.2237260406947229,0.2574177260344202,0.2907992430661668,0.3238303696623460,0.3564713058885680,0.3886827219594984,0.4204258056281977,0.4516623089518696,0.4823545943776656,0.5124656800930278,0.5419592845859137,0.5707998703612213,0.5989526867607420,0.6263838118350449,0.6530601932168421,0.6789496879465974,0.7040211012023909,0.7282442238873905,0.7515898690296382,0.7740299069503345,0.7955372991582480,0.8160861309294805,0.8356516425333770,0.8542102590670719,0.8717396188629035,0.8882186004347461,0.9036273479313025,0.9179472950665863,0.9311611875004314,0.9432531036453579,0.9542084738815001,0.9640140981715054,0.9726581620901930,0.9801302513451481,0.9864213650578323,0.9915239288110628,0.9954318120583445,0.9981403799385680,0.9996469712866382};

static const double w91[91] = {0.0004431206203348,0.0010309935610157,0.0016185227539864,0.0022042198736515,0.0027873340237400,0.0033671672161343,0.0039430331573145,0.0045142520946170,0.0050801503272077,0.0056400606368849,0.0061933229517784,0.0067392850769155,0.0072773034426042,0.0078067438535251,0.0083269822315307,0.0088374053487609,0.0093374115490841,0.0098264114564843,0.0103038286692991,0.0107691004393431,0.0112216783350486,0.0116610288877996,0.0120866342206614,0.0124979926587675,0.0128946193206180,0.0132760466895994,0.0136418251650417,0.0139915235921617,0.0143247297702702,0.0146410509386386,0.0149401142394503,0.0152215671572974,0.0154850779346980,0.0157303359631484,0.0159570521492420,0.0161649592554323,0.0163538122150368,0.0165233884210962,0.0166734879887748,0.0168039339909681,0.0169145726668489,0.0170052736031143,0.0170759298877050,0.0171264582358258,0.0171567990881158,0.0171669166808544,0.0171567990881154,0.0171264582358254,0.0170759298877053,0.0170052736031148,0.0169145726668488,0.0168039339909683,0.0166734879887745,0.0165233884210958,0.0163538122150365,0.0161649592554323,0.0159570521492423,0.0157303359631485,0.0154850779346986,0.0152215671572971,0.0149401142394500,0.0146410509386388,0.0143247297702699,0.0139915235921615,0.0136418251650412,0.0132760466896000,0.0128946193206181,0.0124979926587672,0.0120866342206617,0.0116610288877992,0.0112216783350485,0.0107691004393429,0.0103038286692993,0.0098264114564843,0.0093374115490841,0.0088374053487610,0.0083269822315306,0.0078067438535251,0.0072773034426047,0.0067392850769154,0.0061933229517780,0.0056400606368847,0.0050801503272079,0.0045142520946170,0.0039430331573143,0.0033671672161342,0.0027873340237399,0.0022042198736518,0.0016185227539861,0.0010309935610161,0.0004431206203346};
static const double pts91[91] = {-0.9996546450765761,-0.9981807925905347,-0.9955310425053524,-0.9917079288172770,-0.9867158857234694,-0.9805607802412133,-0.9732498618306907,-0.9647917457472761,-0.9551964007322766,-0.9444751365457191,-0.9326405903562641,-0.9197067117234503,-0.9056887460965716,-0.8906032168143974,-0.8744679056122303,-0.8573018316526425,-0.8391252291013870,-0.8199595232732804,-0.7998273053752923,-0.7787523058761227,-0.7567593665333692,-0.7338744111110951,-0.7101244148221938,-0.6855373725315245,-0.6601422657572349,-0.6339690285091534,-0.6070485120044964,-0.5794124483024626,-0.5510934129005838,-0.5221247863368909,-0.4925407148431842,-0.4623760700957517,-0.4316664081110020,-0.4004479273344396,-0.3687574259723995,-0.3366322586168284,-0.3041102922142352,-0.2712298614307194,-0.2380297234656821,-0.2045490123674886,-0.1708271929049252,-0.1369040140488262,-0.1028194621187075,-0.0686137136496251,-0.0343270880348250,0.0000000000000001,0.0343270880348257,0.0686137136496259,0.1028194621187078,0.1369040140488261,0.1708271929049250,0.2045490123674887,0.2380297234656822,0.2712298614307194,0.3041102922142358,0.3366322586168289,0.3687574259723999,0.4004479273344393,0.4316664081110019,0.4623760700957510,0.4925407148431834,0.5221247863368905,0.5510934129005838,0.5794124483024633,0.6070485120044957,0.6339690285091528,0.6601422657572346,0.6855373725315245,0.7101244148221935,0.7338744111110944,0.7567593665333694,0.7787523058761224,0.7998273053752922,0.8199595232732804,0.8391252291013871,0.8573018316526425,0.8744679056122304,0.8906032168143970,0.9056887460965717,0.9197067117234503,0.9326405903562642,0.9444751365457186,0.9551964007322761,0.9647917457472760,0.9732498618306907,0.9805607802412136,0.9867158857234699,0.9917079288172770,0.9955310425053521,0.9981807925905345,0.9996546450765761};

static const double w92[92] = {0.0004335925893836,0.0010088356831314,0.0015837679716979,0.0021569476659310,0.0027276544540004,0.0032952196671075,0.0038589859186867,0.0044183020282339,0.0049725225098628,0.0055210079613180,0.0060631256813187,0.0065982503528558,0.0071257647444772,0.0076450604128976,0.0081555384001283,0.0086566099218449,0.0091476970451337,0.0096282333542799,0.0100976646035940,0.0105554493563810,0.0110010596092427,0.0114339814009463,0.0118537154051411,0.0122597775062205,0.0126516993576565,0.0130290289221571,0.0133913309930200,0.0137381876960827,0.0140691989716769,0.0143839830360538,0.0146821768217112,0.0149634363961558,0.0152274373585789,0.0154738752140205,0.0157024657245613,0.0159129452371596,0.0161050709877473,0.0162786213812200,0.0164333962470331,0.0165692170700645,0.0166859271965182,0.0167833920146017,0.0168614991097868,0.0169201583944668,0.0169593022118614,0.0169788854140513,0.0169788854140514,0.0169593022118611,0.0169201583944662,0.0168614991097871,0.0167833920146020,0.0166859271965185,0.0165692170700648,0.0164333962470333,0.0162786213812195,0.0161050709877463,0.0159129452371607,0.0157024657245613,0.0154738752140208,0.0152274373585794,0.0149634363961558,0.0146821768217111,0.0143839830360537,0.0140691989716769,0.0137381876960814,0.0133913309930197,0.0130290289221577,0.0126516993576566,0.0122597775062209,0.0118537154051408,0.0114339814009464,0.0110010596092424,0.0105554493563815,0.0100976646035941,0.0096282333542794,0.0091476970451338,0.0086566099218451,0.0081555384001278,0.0076450604128985,0.0071257647444770,0.0065982503528557,0.0060631256813186,0.0055210079613181,0.0049725225098628,0.0044183020282340,0.0038589859186866,0.0032952196671074,0.0027276544540002,0.0021569476659310,0.0015837679716981,0.0010088356831313,0.0004335925893838};
static const double pts92[92] = {-0.9996620713565247,-0.9982199021954504,-0.9956270752692153,-0.9918860044372537,-0.9870009339240126,-0.9809774812101544,-0.9738225880269423,-0.9655445044215963,-0.9561527771340074,-0.9456582378843630,-0.9340729906070958,-0.9214103973710764,-0.9076850629109251,-0.8929128177527764,-0.8771106999395701,-0.8602969353704472,-0.8424909167737810,-0.8237131813364890,-0.8039853870145662,-0.7833302875516895,-0.7617717062344164,-0.7393345084140882,-0.7160445728270328,-0.6919287617460730,-0.6670148899977244,-0.6413316928808016,-0.6149087930234078,-0.5877766662165204,-0.5599666062635780,-0.5315106888865979,-0.5024417347304569,-0.4727932715079918,-0.4425994953295940,-0.4118952312618814,-0.3807158931609507,-0.3490974428265279,-0.3170763485241384,-0.2846895429231169,-0.2519743804989960,-0.2189685944493799,-0.1857102531730125,-0.1522377163622270,-0.1185895907594261,-0.0848046856286144,-0.0509219679933479,-0.0169805176927284,0.0169805176927286,0.0509219679933479,0.0848046856286143,0.1185895907594260,0.1522377163622270,0.1857102531730124,0.2189685944493802,0.2519743804989960,0.2846895429231172,0.3170763485241384,0.3490974428265282,0.3807158931609503,0.4118952312618815,0.4425994953295943,0.4727932715079919,0.5024417347304565,0.5315106888865977,0.5599666062635779,0.5877766662165210,0.6149087930234082,0.6413316928808017,0.6670148899977241,0.6919287617460732,0.7160445728270335,0.7393345084140884,0.7617717062344167,0.7833302875516901,0.8039853870145667,0.8237131813364890,0.8424909167737813,0.8602969353704468,0.8771106999395700,0.8929128177527760,0.9076850629109248,0.9214103973710763,0.9340729906070955,0.9456582378843630,0.9561527771340071,0.9655445044215958,0.9738225880269422,0.9809774812101539,0.9870009339240124,0.9918860044372537,0.9956270752692149,0.9982199021954506,0.9996620713565247};

static const double w93[93] = {0.0004243685840338,0.0009873843843436,0.0015501202015492,0.0021111786912040,0.0026698685490846,0.0032255488971554,0.0037775897503850,0.0043253670177141,0.0048682619709438,0.0054056615952713,0.0059369591637236,0.0064615548765927,0.0069788565190037,0.0074882801203366,0.0079892506088905,0.0084812024586645,0.0089635803264068,0.0094358396777541,0.0098974474014640,0.0103478824109341,0.0107866362322497,0.0112132135780549,0.0116271329065790,0.0120279269651729,0.0124151433177265,0.0127883448553787,0.0131471102899266,0.0134910346293807,0.0138197296351363,0.0141328242602162,0.0144299650681389,0.0147108166318746,0.0149750619124967,0.0152224026170676,0.0154525595353618,0.0156652728550510,0.0158603024549959,0.0160374281763001,0.0161964500708360,0.0163371886269611,0.0164594849721526,0.0165632010523516,0.0166482197878078,0.0167144452052415,0.0167618025461831,0.0167902383513663,0.0167997205210721,0.0167902383513661,0.0167618025461840,0.0167144452052411,0.0166482197878079,0.0165632010523518,0.0164594849721524,0.0163371886269614,0.0161964500708361,0.0160374281762998,0.0158603024549962,0.0156652728550514,0.0154525595353610,0.0152224026170680,0.0149750619124965,0.0147108166318741,0.0144299650681387,0.0141328242602168,0.0138197296351351,0.0134910346293817,0.0131471102899272,0.0127883448553785,0.0124151433177257,0.0120279269651724,0.0116271329065789,0.0112132135780549,0.0107866362322496,0.0103478824109343,0.0098974474014641,0.0094358396777539,0.0089635803264067,0.0084812024586641,0.0079892506088909,0.0074882801203361,0.0069788565190043,0.0064615548765925,0.0059369591637239,0.0054056615952716,0.0048682619709438,0.0043253670177141,0.0037775897503854,0.0032255488971559,0.0026698685490845,0.0021111786912034,0.0015501202015495,0.0009873843843436,0.0004243685840343};
static const double pts93[93] = {-0.9996692606571687,-0.9982577641714123,-0.9957200462489501,-0.9920584071920625,-0.9872769112685724,-0.9813809395335015,-0.9743771421334103,-0.9662734230400593,-0.9570789290651235,-0.9468040388484759,-0.9354603508751892,-0.9230606702658531,-0.9096189942656761,-0.8951504964149989,-0.8796715094050027,-0.8631995066316017,-0.8457530824652613,-0.8273519312574521,-0.8080168251065863,-0.7877695904080756,-0.7666330832146936,-0.7446311634349150,-0.7217886678982400,-0.6981313823178538,-0.6736860121822277,-0.6484801526084997,-0.6225422571916356,-0.5959016058845360,-0.5685882719453320,-0.5406330879891729,-0.5120676111828353,-0.4829240876214212,-0.4532354159273798,-0.4230351101129191,-0.3923572617477495,-0.3612365014748494,-0.3297079599177061,-0.2978072280231482,-0.2655703168845570,-0.2330336170907867,-0.2002338576466963,-0.1672080645116635,-0.1339935188028812,-0.1006277147106174,-0.0671483171729551,-0.0335931193577769,-0.0000000000000007,0.0335931193577764,0.0671483171729551,0.1006277147106171,0.1339935188028807,0.1672080645116631,0.2002338576466959,0.2330336170907860,0.2655703168845567,0.2978072280231479,0.3297079599177056,0.3612365014748499,0.3923572617477494,0.4230351101129189,0.4532354159273797,0.4829240876214216,0.5120676111828354,0.5406330879891731,0.5685882719453321,0.5959016058845359,0.6225422571916354,0.6484801526085000,0.6736860121822282,0.6981313823178531,0.7217886678982393,0.7446311634349150,0.7666330832146927,0.7877695904080757,0.8080168251065862,0.8273519312574519,0.8457530824652614,0.8631995066316018,0.8796715094050032,0.8951504964149989,0.9096189942656769,0.9230606702658538,0.9354603508751893,0.9468040388484755,0.9570789290651232,0.9662734230400595,0.9743771421334106,0.9813809395335018,0.9872769112685724,0.9920584071920625,0.9957200462489503,0.9982577641714128,0.9996692606571688};

static const double w94[94] = {0.0004154358063410,0.0009666099443626,0.0015175329455190,0.0020668499377044,0.0026138971447538,0.0031580600455184,0.0036987346440714,0.0042353225472670,0.0047672304164326,0.0052938702824767,0.0058146600805617,0.0063290242488193,0.0068363943453032,0.0073362096672496,0.0078279178662578,0.0083109755563329,0.0087848489130718,0.0092490142628329,0.0097029586609911,0.0101461804585056,0.0105781898561109,0.0109985094454697,0.0114066747366777,0.0118022346715075,0.0121847521218342,0.0125538043726762,0.0129089835893081,0.0132498972679455,0.0135761686694832,0.0138874372358175,0.0141833589882882,0.0144636069078032,0.0147278712962169,0.0149758601185717,0.0152072993258214,0.0154219331576748,0.0156195244252336,0.0157998547731065,0.0159627249207080,0.0161079548824802,0.0162353841667939,0.0163448719533032,0.0164362972485644,0.0165095590197455,0.0165645763062739,0.0166012883093033,0.0166196544589081,0.0166196544589075,0.0166012883093030,0.0165645763062732,0.0165095590197456,0.0164362972485645,0.0163448719533033,0.0162353841667940,0.0161079548824799,0.0159627249207081,0.0157998547731065,0.0156195244252337,0.0154219331576742,0.0152072993258210,0.0149758601185720,0.0147278712962169,0.0144636069078036,0.0141833589882884,0.0138874372358166,0.0135761686694836,0.0132498972679454,0.0129089835893090,0.0125538043726758,0.0121847521218346,0.0118022346715075,0.0114066747366775,0.0109985094454703,0.0105781898561102,0.0101461804585057,0.0097029586609905,0.0092490142628329,0.0087848489130718,0.0083109755563328,0.0078279178662580,0.0073362096672499,0.0068363943453037,0.0063290242488195,0.0058146600805614,0.0052938702824771,0.0047672304164323,0.0042353225472677,0.0036987346440714,0.0031580600455181,0.0026138971447541,0.0020668499377033,0.0015175329455193,0.0009666099443627,0.0004154358063410};
static const double pts94[94] = {-0.9996762229550501,-0.9982944310216879,-0.9958100842017192,-0.9922253754008765,-0.9875441983204798,-0.9817717098833779,-0.9749142837904649,-0.9669794958813431,-0.9579761137429547,-0.9479140863487621,-0.9368045328028248,-0.9246597299379514,-0.9114930986940577,-0.8973191892587683,-0.8821536649728724,-0.8660132850121991,-0.8489158858620338,-0.8308803616030178,-0.8119266430294827,-0.7920756756228453,-0.7713493964041237,-0.7497707096910132,-0.7273634617861990,-0.7041524146248200,-0.6801632184101719,-0.6554223832678551,-0.6299572499496729,-0.6037959596196577,-0.5769674227555817,-0.5495012872003407,-0.5214279053984838,-0.4927783008541189,-0.4635841338472391,-0.4338776664463642,-0.4036917268561588,-0.3730596731394281,-0.3420153563535676,-0.3105930831422241,-0.2788275778234900,-0.2467539440165345,-0.2144076258490725,-0.1818243687885507,-0.1490401801403192,-0.1160912892564542,-0.0830141074992020,-0.0498451880032832,-0.0166211852815262,0.0166211852815260,0.0498451880032828,0.0830141074992022,0.1160912892564544,0.1490401801403191,0.1818243687885513,0.2144076258490729,0.2467539440165342,0.2788275778234902,0.3105930831422239,0.3420153563535673,0.3730596731394280,0.4036917268561591,0.4338776664463638,0.4635841338472393,0.4927783008541194,0.5214279053984842,0.5495012872003407,0.5769674227555817,0.6037959596196572,0.6299572499496727,0.6554223832678553,0.6801632184101722,0.7041524146248200,0.7273634617861986,0.7497707096910130,0.7713493964041235,0.7920756756228449,0.8119266430294828,0.8308803616030177,0.8489158858620333,0.8660132850121988,0.8821536649728724,0.8973191892587677,0.9114930986940573,0.9246597299379516,0.9368045328028249,0.9479140863487616,0.9579761137429551,0.9669794958813434,0.9749142837904649,0.9817717098833781,0.9875441983204797,0.9922253754008763,0.9958100842017187,0.9982944310216875,0.9996762229550497};

static const double w95[95] = {0.0004067821247269,0.0009464841889615,0.0014859621204094,0.0020239016581859,0.0025596651649640,0.0030926631305165,0.0036223162219666,0.0041480504372654,0.0046692965419382,0.0051854903515583,0.0056960732295433,0.0062004926480577,0.0066982027671844,0.0071886650168293,0.0076713486751440,0.0081457314404957,0.0086112999953588,0.0090675505610228,0.0095139894422725,0.0099501335613288,0.0103755109803926,0.0107896614122055,0.0111921367180345,0.0115825013925356,0.0119603330349653,0.0123252228062213,0.0126767758712157,0.0130146118261013,0.0133383651098807,0.0136476853999652,0.0139422379912386,0.0142217041582275,0.0144857814999806,0.0147341842672836,0.0149666436718571,0.0151829081772027,0.0153827437707791,0.0155659342172220,0.0157322812923194,0.0158816049975061,0.0160137437546334,0.0161285545808072,0.0162259132431019,0.0163057143929908,0.0163678716803418,0.0164123178468495,0.0164390047988161,0.0164479036591898,0.0164390047988156,0.0164123178468495,0.0163678716803424,0.0163057143929910,0.0162259132431015,0.0161285545808079,0.0160137437546331,0.0158816049975061,0.0157322812923187,0.0155659342172225,0.0153827437707797,0.0151829081772025,0.0149666436718568,0.0147341842672835,0.0144857814999806,0.0142217041582272,0.0139422379912384,0.0136476853999648,0.0133383651098809,0.0130146118261016,0.0126767758712162,0.0123252228062213,0.0119603330349654,0.0115825013925356,0.0111921367180352,0.0107896614122056,0.0103755109803928,0.0099501335613292,0.0095139894422727,0.0090675505610224,0.0086112999953582,0.0081457314404957,0.0076713486751441,0.0071886650168299,0.0066982027671843,0.0062004926480585,0.0056960732295427,0.0051854903515575,0.0046692965419380,0.0041480504372655,0.0036223162219668,0.0030926631305164,0.0025596651649641,0.0020239016581858,0.0014859621204093,0.0009464841889611,0.0004067821247271};
static const double pts95[95] = {-0.9996829677071920,-0.9983299525167464,-0.9958973111884236,-0.9923871350035011,-0.9878031559060811,-0.9821503182216256,-0.9754347334114409,-0.9676636660221963,-0.9588455238479096,-0.9489898481742953,-0.9381073031984777,-0.9262096643777195,-0.9133098056340672,-0.8994216853963930,-0.8845603314814405,-0.8687418248241303,-0.8519832820717840,-0.8343028370596011,-0.8157196211866089,-0.7962537427128930,-0.7759262650002235,-0.7547591837194917,-0.7327754030495019,-0.7099987108928225,-0.6864537531354821,-0.6621660069783182,-0.6371617533688404,-0.6114680485634109,-0.5851126948505145,-0.5581242104667848,-0.5305317987383438,-0.5023653164808340,-0.4736552416923439,-0.4444326405741701,-0.4147291339151181,-0.3845768628756991,-0.3540084542092523,-0.3230569849576366,-0.2917559466596620,-0.2601392091110291,-0.2282409837149576,-0.1960957864631829,-0.1637384005873556,-0.1312038389212868,-0.0985273060147347,-0.0657441600397498,-0.0328898745307892,-0.0000000000000001,0.0328898745307890,0.0657441600397497,0.0985273060147348,0.1312038389212870,0.1637384005873554,0.1960957864631823,0.2282409837149582,0.2601392091110292,0.2917559466596618,0.3230569849576367,0.3540084542092533,0.3845768628756983,0.4147291339151182,0.4444326405741700,0.4736552416923434,0.5023653164808339,0.5305317987383433,0.5581242104667842,0.5851126948505138,0.6114680485634105,0.6371617533688400,0.6621660069783177,0.6864537531354825,0.7099987108928234,0.7327754030495024,0.7547591837194925,0.7759262650002242,0.7962537427128932,0.8157196211866097,0.8343028370596011,0.8519832820717844,0.8687418248241300,0.8845603314814406,0.8994216853963932,0.9133098056340675,0.9262096643777198,0.9381073031984778,0.9489898481742957,0.9588455238479097,0.9676636660221968,0.9754347334114407,0.9821503182216255,0.9878031559060814,0.9923871350035012,0.9958973111884236,0.9983299525167464,0.9996829677071921};

static const double w96[96] = {0.0003983960327758,0.0009269803944736,0.0014553659089673,0.0019822771692224,0.0025071013714639,0.0030292727521178,0.0035482353955770,0.0040634384628494,0.0045743356153919,0.0050803852675040,0.0055810510499193,0.0060758023355441,0.0065641147834809,0.0070454708861574,0.0075193605134973,0.0079852814512814,0.0084427399321230,0.0088912511580225,0.0093303398137055,0.0097595405700726,0.0101783985771663,0.0105864699460957,0.0109833222193721,0.0113685348291644,0.0117416995429632,0.0121024208961826,0.0124503166112418,0.0127850180026744,0.0131061703678364,0.0134134333627957,0.0137064813630148,0.0139850038084244,0.0142487055325425,0.0144973070752777,0.0147305449790838,0.0149481720681642,0.0151499577104139,0.0153356880618345,0.0155051662931571,0.0156582127984303,0.0157946653853635,0.0159143794472057,0.0160172281159961,0.0161031023970151,0.0161719112842878,0.0162235818570319,0.0162580593569349,0.0162753072461817,0.0162753072461813,0.0162580593569344,0.0162235818570317,0.0161719112842883,0.0161031023970151,0.0160172281159967,0.0159143794472060,0.0157946653853633,0.0156582127984307,0.0155051662931566,0.0153356880618346,0.0151499577104143,0.0149481720681640,0.0147305449790838,0.0144973070752774,0.0142487055325428,0.0139850038084243,0.0137064813630140,0.0134134333627959,0.0131061703678365,0.0127850180026747,0.0124503166112417,0.0121024208961822,0.0117416995429630,0.0113685348291647,0.0109833222193723,0.0105864699460962,0.0101783985771668,0.0097595405700725,0.0093303398137058,0.0088912511580223,0.0084427399321225,0.0079852814512810,0.0075193605134978,0.0070454708861578,0.0065641147834813,0.0060758023355439,0.0055810510499196,0.0050803852675040,0.0045743356153914,0.0040634384628490,0.0035482353955771,0.0030292727521176,0.0025071013714635,0.0019822771692225,0.0014553659089672,0.0009269803944735,0.0003983960327761};
static const double pts96[96] = {-0.9996895038832311,-0.9983643758631819,-0.9959818429872097,-0.9925439003237634,-0.9880541263296249,-0.9825172635630152,-0.9759391745851369,-0.9683268284632647,-0.9596882914487422,-0.9500327177844372,-0.9393703397527550,-0.9277124567223084,-0.9150714231208976,-0.9014606353158517,-0.8868945174024202,-0.8713885059092964,-0.8549590334346009,-0.8376235112281866,-0.8194003107379316,-0.8003087441391409,-0.7803690438674336,-0.7596023411766474,-0.7380306437444001,-0.7156768123489681,-0.6925645366421717,-0.6687183100439159,-0.6441634037849666,-0.6189258401254686,-0.5930323647775722,-0.5665104185613972,-0.5393881083243579,-0.5116941771546677,-0.4834579739205960,-0.4547094221677433,-0.4254789884073011,-0.3957976498289087,-0.3656968614723138,-0.3352085228926255,-0.3043649443544962,-0.2731988125910488,-0.2417431561638398,-0.2100313104605672,-0.1780968823676186,-0.1459737146548971,-0.1136958501106658,-0.0812974954644255,-0.0488129851360499,-0.0162767448496027,0.0162767448496029,0.0488129851360496,0.0812974954644254,0.1136958501106655,0.1459737146548971,0.1780968823676187,0.2100313104605673,0.2417431561638402,0.2731988125910496,0.3043649443544971,0.3352085228926255,0.3656968614723137,0.3957976498289087,0.4254789884073009,0.4547094221677430,0.4834579739205964,0.5116941771546679,0.5393881083243574,0.5665104185613974,0.5930323647775722,0.6189258401254687,0.6441634037849672,0.6687183100439161,0.6925645366421715,0.7156768123489679,0.7380306437444006,0.7596023411766473,0.7803690438674333,0.8003087441391404,0.8194003107379320,0.8376235112281873,0.8549590334346014,0.8713885059092965,0.8868945174024205,0.9014606353158522,0.9150714231208978,0.9277124567223084,0.9393703397527549,0.9500327177844372,0.9596882914487426,0.9683268284632641,0.9759391745851365,0.9825172635630149,0.9880541263296239,0.9925439003237628,0.9959818429872090,0.9983643758631814,0.9996895038832309};

static const double w97[97] = {0.0003902666109711,0.0009080731991052,0.0014257046216066,0.0019419226647444,0.0024561381310829,0.0029678078153945,0.0034763980482341,0.0039813799989328,0.0044822290883494,0.0049784252135419,0.0054694531795979,0.0059548031926658,0.0064339713712463,0.0069064602609265,0.0073717793466186,0.0078294455595783,0.0082789837776713,0.0087199273179039,0.0091518184204823,0.0095742087237638,0.0099866597295540,0.0103887432582134,0.0107800418930958,0.0111601494138334,0.0115286712180132,0.0118852247308017,0.0122294398020939,0.0125609590907651,0.0128794384356282,0.0131845472127147,0.0134759686784983,0.0137534002987151,0.0140165540624313,0.0142651567810333,0.0144989503718346,0.0147176921259934,0.0149211549604837,0.0151091276538279,0.0152814150653794,0.0154378383378987,0.0155782350832343,0.0157024595509007,0.0158103827793873,0.0159018927300362,0.0159768944033543,0.0160353099376362,0.0160770786897925,0.0161021572983066,0.0161105197282496,0.0161021572983066,0.0160770786897925,0.0160353099376367,0.0159768944033546,0.0159018927300354,0.0158103827793866,0.0157024595509011,0.0155782350832348,0.0154378383378989,0.0152814150653793,0.0151091276538279,0.0149211549604837,0.0147176921259935,0.0144989503718342,0.0142651567810333,0.0140165540624314,0.0137534002987151,0.0134759686784988,0.0131845472127150,0.0128794384356284,0.0125609590907653,0.0122294398020938,0.0118852247308014,0.0115286712180129,0.0111601494138328,0.0107800418930959,0.0103887432582124,0.0099866597295540,0.0095742087237644,0.0091518184204826,0.0087199273179041,0.0082789837776710,0.0078294455595782,0.0073717793466188,0.0069064602609270,0.0064339713712470,0.0059548031926656,0.0054694531795977,0.0049784252135422,0.0044822290883493,0.0039813799989324,0.0034763980482346,0.0029678078153938,0.0024561381310830,0.0019419226647446,0.0014257046216064,0.0009080731991054,0.0003902666109712};
static const double pts97[97] = {-0.9996958399952466,-0.9983977458605663,-0.9960637894774880,-0.9926958747785516,-0.9882974345018388,-0.9828730196135284,-0.9764282563086198,-0.9689698330349505,-0.9605054916527871,-0.9510440187666384,-0.9405952363580280,-0.9291699914816186,-0.9167801449531888,-0.9034385590101214,-0.8891590839443007,-0.8739565437154143,-0.8578467205567907,-0.8408463385882867,-0.8229730464524844,-0.8042453989917706,-0.7846828379850856,-0.7643056719641822,-0.7431350551302542,-0.7211929653927709,-0.6985021815532714,-0.6750862596577851,-0.6509695085424080,-0.6261769645974143,-0.6007343657760842,-0.5746681248752444,-0.5480053021152277,-0.5207735770477427,-0.4930012198207936,-0.4647170618304893,-0.4359504657902107,-0.4067312952481958,-0.3770898835852039,-0.3470570025244212,-0.3166638301863192,-0.2859419187216165,-0.2549231615559508,-0.2236397602802590,-0.1921241912212447,-0.1604091717266307,-0.1285276262002082,-0.0965126519219214,-0.0643974846884959,-0.0322154643102616,0.0000000000000002,0.0322154643102617,0.0643974846884962,0.0965126519219214,0.1285276262002087,0.1604091717266314,0.1921241912212449,0.2236397602802597,0.2549231615559516,0.2859419187216171,0.3166638301863190,0.3470570025244216,0.3770898835852043,0.4067312952481962,0.4359504657902101,0.4647170618304892,0.4930012198207935,0.5207735770477424,0.5480053021152278,0.5746681248752442,0.6007343657760844,0.6261769645974138,0.6509695085424082,0.6750862596577852,0.6985021815532713,0.7211929653927703,0.7431350551302539,0.7643056719641820,0.7846828379850861,0.8042453989917709,0.8229730464524848,0.8408463385882865,0.8578467205567901,0.8739565437154143,0.8891590839443004,0.9034385590101214,0.9167801449531890,0.9291699914816187,0.9405952363580277,0.9510440187666391,0.9605054916527870,0.9689698330349505,0.9764282563086198,0.9828730196135284,0.9882974345018386,0.9926958747785515,0.9960637894774882,0.9983977458605664,0.9996958399952465};

static const double w98[98] = {0.0003823834911372,0.0008897385205067,0.0013969405678613,0.0019027870426764,0.0024067111992931,0.0029081912732200,0.0034067147395831,0.0039017736895500,0.0043928642336959,0.0048794867010873,0.0053611460416120,0.0058373522885694,0.0063076210394610,0.0067714739405149,0.0072284391691517,0.0076780519117489,0.0081198548352269,0.0085533985515450,0.0089782420743849,0.0093939532674526,0.0098001092838634,0.0101962969961462,0.0105821134163872,0.0109571661060893,0.0113210735753090,0.0116734656706745,0.0120139839518728,0.0123422820562303,0.0126580260510133,0.0129608947730814,0.0132505801555615,0.0135267875411983,0.0137892359820610,0.0140376585253181,0.0142718024847639,0.0144914296978445,0.0146963167679035,0.0148862552914145,0.0150610520699608,0.0152205293067473,0.0153645247874467,0.0154928920452047,0.0156055005096131,0.0157022356395235,0.0157829990395539,0.0158477085601747,0.0158962983812646,0.0159287190790618,0.0159449376764379,0.0159449376764383,0.0159287190790621,0.0158962983812642,0.0158477085601746,0.0157829990395541,0.0157022356395230,0.0156055005096131,0.0154928920452051,0.0153645247874467,0.0152205293067466,0.0150610520699611,0.0148862552914146,0.0146963167679036,0.0144914296978446,0.0142718024847640,0.0140376585253181,0.0137892359820608,0.0135267875411975,0.0132505801555625,0.0129608947730813,0.0126580260510136,0.0123422820562305,0.0120139839518725,0.0116734656706746,0.0113210735753088,0.0109571661060891,0.0105821134163877,0.0101962969961459,0.0098001092838631,0.0093939532674523,0.0089782420743848,0.0085533985515452,0.0081198548352271,0.0076780519117494,0.0072284391691519,0.0067714739405145,0.0063076210394608,0.0058373522885689,0.0053611460416124,0.0048794867010871,0.0043928642336962,0.0039017736895504,0.0034067147395825,0.0029081912732197,0.0024067111992936,0.0019027870426760,0.0013969405678613,0.0008897385205072,0.0003823834911371};
static const double pts98[98] = {-0.9997019841254912,-0.9984301050472310,-0.9961432549968596,-0.9928432515369072,-0.9885333889891585,-0.9832180362937233,-0.9769025950638863,-0.9695934871007946,-0.9612981460028912,-0.9520250089864014,-0.9417835080627118,-0.9305840603393070,-0.9184380573735678,-0.9053578535598391,-0.8913567535488909,-0.8764489987068445,-0.8606497526245523,-0.8439750856907705,-0.8264419587440478,-0.8080682058195344,-0.7888725160080218,-0.7688744144455176,-0.7480942424525926,-0.7265531368436583,-0.7042730084271773,-0.6812765197186468,-0.6575870618890151,-0.6332287309719702,-0.6082263033542799,-0.5826052105741238,-0.5563915134530408,-0.5296118755877951,-0.5022935362291369,-0.4744642825750293,-0.4461524215065259,-0.4173867507950546,-0.3881965298103834,-0.3586114497590712,-0.3286616034836677,-0.2983774548533876,-0.2677898077773909,-0.2369297748721918,-0.2058287458150534,-0.1745183554155766,-0.1430304514379427,-0.1113970622065535,-0.0796503640280057,-0.0478226484625486,-0.0159462894783092,0.0159462894783096,0.0478226484625491,0.0796503640280061,0.1113970622065538,0.1430304514379431,0.1745183554155770,0.2058287458150541,0.2369297748721921,0.2677898077773914,0.2983774548533877,0.3286616034836682,0.3586114497590717,0.3881965298103841,0.4173867507950544,0.4461524215065258,0.4744642825750288,0.5022935362291366,0.5296118755877948,0.5563915134530408,0.5826052105741242,0.6082263033542794,0.6332287309719696,0.6575870618890151,0.6812765197186464,0.7042730084271773,0.7265531368436586,0.7480942424525927,0.7688744144455179,0.7888725160080221,0.8080682058195342,0.8264419587440480,0.8439750856907707,0.8606497526245515,0.8764489987068436,0.8913567535488909,0.9053578535598393,0.9184380573735681,0.9305840603393070,0.9417835080627115,0.9520250089864015,0.9612981460028910,0.9695934871007944,0.9769025950638855,0.9832180362937230,0.9885333889891580,0.9928432515369064,0.9961432549968592,0.9984301050472305,0.9997019841254907};

static const double w99[99] = {0.0003747368233686,0.0008719534791098,0.0013690379368135,0.0018648217436214,0.0023587595187606,0.0028503498866979,0.0033391004302870,0.0038245231396676,0.0043061338077398,0.0047834522056632,0.0052560024577623,0.0057233134757494,0.0061849194110873,0.0066403601113288,0.0070891815747897,0.0075309364009955,0.0079651842354800,0.0083914922080692,0.0088094353639619,0.0092185970870894,0.0096185695152435,0.0100089539465432,0.0103893612367972,0.0107594121873652,0.0111187379231195,0.0114669802601257,0.0118037920626690,0.0121288375892783,0.0124417928273908,0.0127423458163275,0.0130301969582578,0.0133050593168428,0.0135666589032565,0.0138147349492998,0.0140490401673401,0.0142693409968133,0.0144754178370368,0.0146670652661140,0.0148440922457026,0.0150063223114453,0.0151535937488728,0.0152857597546032,0.0154026885826784,0.0155042636758926,0.0155903837819791,0.0156609630545377,0.0157159311386108,0.0157552332408142,0.0157788301839559,0.0157866984460871,0.0157788301839558,0.0157552332408142,0.0157159311386106,0.0156609630545380,0.0155903837819787,0.0155042636758928,0.0154026885826786,0.0152857597546029,0.0151535937488732,0.0150063223114453,0.0148440922457027,0.0146670652661138,0.0144754178370366,0.0142693409968133,0.0140490401673406,0.0138147349492997,0.0135666589032563,0.0133050593168429,0.0130301969582575,0.0127423458163270,0.0124417928273908,0.0121288375892780,0.0118037920626684,0.0114669802601257,0.0111187379231198,0.0107594121873653,0.0103893612367972,0.0100089539465443,0.0096185695152433,0.0092185970870895,0.0088094353639622,0.0083914922080697,0.0079651842354808,0.0075309364009951,0.0070891815747899,0.0066403601113288,0.0061849194110879,0.0057233134757492,0.0052560024577622,0.0047834522056634,0.0043061338077397,0.0038245231396676,0.0033391004302875,0.0028503498866979,0.0023587595187606,0.0018648217436215,0.0013690379368134,0.0008719534791094,0.0003747368233689};
static const double pts99[99] = {-0.9997079439521693,-0.9984614938358414,-0.9962203386730883,-0.9929862141331123,-0.9887622829898733,-0.9835527411562800,-0.9773627767507062,-0.9701985580742902,-0.9620672256409019,-0.9529768844533735,-0.9429365956884799,-0.9319563675614969,-0.9200471453004999,-0.9072208002105735,-0.8934901178264143,-0.8788687851595135,-0.8633713770499175,-0.8470133416347745,-0.8298109849474309,-0.8117814546619889,-0.7929427229993093,-0.7733135688113366,-0.7529135588615385,-0.7317630283200438,-0.7098830604928970,-0.6872954658056086,-0.6640227600619387,-0.6400881419995629,-0.6155154701650074,-0.5903292391308795,-0.5645545550791022,-0.5382171107745015,-0.5113431599536713,-0.4839594911546598,-0.4560934010135566,-0.4277726670545996,-0.3990255200009247,-0.3698806156335567,-0.3403670062266995,-0.3105141115877906,-0.2803516897311916,-0.2499098072147470,-0.2192188091687846,-0.1883092890474246,-0.1572120581323587,-0.1259581148194887,-0.0945786137190519,-0.0631048346000261,-0.0315681512097721,0.0000000000000003,0.0315681512097722,0.0631048346000263,0.0945786137190524,0.1259581148194886,0.1572120581323582,0.1883092890474248,0.2192188091687844,0.2499098072147467,0.2803516897311914,0.3105141115877912,0.3403670062266995,0.3698806156335560,0.3990255200009240,0.4277726670545996,0.4560934010135567,0.4839594911546603,0.5113431599536711,0.5382171107745012,0.5645545550791015,0.5903292391308789,0.6155154701650073,0.6400881419995630,0.6640227600619388,0.6872954658056091,0.7098830604928968,0.7317630283200439,0.7529135588615384,0.7733135688113362,0.7929427229993091,0.8117814546619893,0.8298109849474306,0.8470133416347743,0.8633713770499170,0.8788687851595144,0.8934901178264144,0.9072208002105738,0.9200471453005005,0.9319563675614970,0.9429365956884794,0.9529768844533738,0.9620672256409021,0.9701985580742903,0.9773627767507060,0.9835527411562803,0.9887622829898736,0.9929862141331125,0.9962203386730890,0.9984614938358415,0.9997079439521696};

static const double w100[100] = {0.0003673172452530,0.0008546963267594,0.0013419626857764,0.0018279806006633,0.0023122250317108,0.0027942140019326,0.0032734742254230,0.0037495366277323,0.0042219357348348,0.0046902098268470,0.0051539012874342,0.0056125570115933,0.0060657288314898,0.0065129739464860,0.0069538553518591,0.0073879422637206,0.0078148105387731,0.0082340430880726,0.0086452302841620,0.0090479703610641,0.0094418698066875,0.0098265437472177,0.0102016163231046,0.0105667210562636,0.0109215012081235,0.0112656101281681,0.0115987115926271,0.0119204801329840,0.0122306013539784,0.0125287722407900,0.0128147014551042,0.0130881096197727,0.0133487295917857,0.0135963067232881,0.0138305991103966,0.0140513778295505,0.0142584271611974,0.0144515448005630,0.0146305420553193,0.0147952440299558,0.0149454897966665,0.0150811325525843,0.0152020397632273,0.0153080932919905,0.0153991895155762,0.0154752394252458,0.0155361687137832,0.0155819178481046,0.0156124421274249,0.0156277117269317,0.0156277117269318,0.0156124421274245,0.0155819178481054,0.0155361687137831,0.0154752394252458,0.0153991895155762,0.0153080932919905,0.0152020397632276,0.0150811325525845,0.0149454897966665,0.0147952440299561,0.0146305420553190,0.0144515448005628,0.0142584271611974,0.0140513778295503,0.0138305991103962,0.0135963067232883,0.0133487295917856,0.0130881096197727,0.0128147014551044,0.0125287722407900,0.0122306013539782,0.0119204801329848,0.0115987115926270,0.0112656101281679,0.0109215012081240,0.0105667210562640,0.0102016163231042,0.0098265437472176,0.0094418698066873,0.0090479703610644,0.0086452302841617,0.0082340430880721,0.0078148105387734,0.0073879422637203,0.0069538553518591,0.0065129739464857,0.0060657288314900,0.0056125570115927,0.0051539012874344,0.0046902098268473,0.0042219357348346,0.0037495366277324,0.0032734742254224,0.0027942140019328,0.0023122250317109,0.0018279806006633,0.0013419626857767,0.0008546963267593,0.0003673172452526};
static const double pts100[100] = {-0.9997137267734408,-0.9984919506395952,-0.9962951347331248,-0.9931249370374428,-0.9889843952429915,-0.9838775407060570,-0.9778093584869180,-0.9707857757637058,-0.9628136542558152,-0.9539007829254911,-0.9440558701362561,-0.9332885350430791,-0.9216092981453337,-0.9090295709825292,-0.8955616449707269,-0.8812186793850184,-0.8660146884971648,-0.8499645278795912,-0.8330838798884005,-0.8153892383391763,-0.7968978923903143,-0.7776279096494952,-0.7575981185197069,-0.7368280898020209,-0.7153381175730564,-0.6931491993558019,-0.6702830156031411,-0.6467619085141293,-0.6226088602037080,-0.5978474702471791,-0.5725019326213817,-0.5465970120650946,-0.5201580198817630,-0.4932107892081909,-0.4657816497733577,-0.4378974021720319,-0.4095852916783015,-0.3808729816246302,-0.3517885263724220,-0.3223603439005289,-0.2926171880384720,-0.2625881203715034,-0.2323024818449741,-0.2017898640957365,-0.1710800805386038,-0.1402031372361143,-0.1091892035800613,-0.0780685828134367,-0.0468716824215921,-0.0156289844215430,0.0156289844215430,0.0468716824215919,0.0780685828134368,0.1091892035800610,0.1402031372361137,0.1710800805386028,0.2017898640957361,0.2323024818449740,0.2625881203715035,0.2926171880384722,0.3223603439005296,0.3517885263724219,0.3808729816246302,0.4095852916783014,0.4378974021720316,0.4657816497733579,0.4932107892081906,0.5201580198817631,0.5465970120650941,0.5725019326213808,0.5978474702471784,0.6226088602037078,0.6467619085141290,0.6702830156031410,0.6931491993558021,0.7153381175730562,0.7368280898020206,0.7575981185197069,0.7776279096494951,0.7968978923903142,0.8153892383391760,0.8330838798884006,0.8499645278795909,0.8660146884971643,0.8812186793850182,0.8955616449707269,0.9090295709825296,0.9216092981453335,0.9332885350430793,0.9440558701362561,0.9539007829254917,0.9628136542558156,0.9707857757637062,0.9778093584869183,0.9838775407060569,0.9889843952429918,0.9931249370374431,0.9962951347331250,0.9984919506395959,0.9997137267734411};

static const double w101[101] = {0.0003601158532010,0.0008379463802494,0.0013156824365907,0.0017922196994012,0.0022670525050468,0.0027397173418911,0.0032097591350890,0.0036767268373956,0.0041401728128617,0.0045996529704611,0.0050547270897561,0.0055049592040299,0.0059499180013557,0.0063891772300450,0.0068223161031115,0.0072489196993185,0.0076685793595229,0.0080808930774777,0.0084854658845464,0.0088819102278059,0.0092698463411464,0.0096489026089592,0.0100187159220481,0.0103789320254226,0.0107292058576142,0.0110692018811992,0.0113985944042035,0.0117170678920821,0.0120243172699699,0.0123200482149143,0.0126039774378119,0.0128758329547755,0.0131353543476735,0.0133822930135865,0.0136164124029535,0.0138374882461660,0.0140453087683998,0.0142396748924842,0.0144204004295980,0.0145873122576248,0.0147402504869965,0.0148790686138486,0.0150036336603653,0.0151138263021605,0.0152095409825824,0.0152906860138264,0.0153571836647707,0.0154089702354324,0.0154459961179885,0.0154682258442989,0.0154756381198786,0.0154682258442984,0.0154459961179892,0.0154089702354320,0.0153571836647710,0.0152906860138260,0.0152095409825824,0.0151138263021609,0.0150036336603655,0.0148790686138490,0.0147402504869970,0.0145873122576249,0.0144204004295978,0.0142396748924839,0.0140453087683996,0.0138374882461657,0.0136164124029539,0.0133822930135864,0.0131353543476732,0.0128758329547758,0.0126039774378121,0.0123200482149140,0.0120243172699695,0.0117170678920817,0.0113985944042035,0.0110692018811997,0.0107292058576140,0.0103789320254229,0.0100187159220476,0.0096489026089588,0.0092698463411464,0.0088819102278063,0.0084854658845462,0.0080808930774781,0.0076685793595228,0.0072489196993194,0.0068223161031114,0.0063891772300449,0.0059499180013554,0.0055049592040296,0.0050547270897557,0.0045996529704609,0.0041401728128617,0.0036767268373956,0.0032097591350890,0.0027397173418910,0.0022670525050468,0.0017922196994014,0.0013156824365916,0.0008379463802495,0.0003601158532006};
static const double pts101[101] = {-0.9997193395297704,-0.9985215119897576,-0.9963677327909444,-0.9932595861878678,-0.9891999908750336,-0.9841928216302208,-0.9782428702864437,-0.9713558345581716,-0.9635383108331339,-0.9547977872711914,-0.9451426364046479,-0.9345821070189454,-0.9231263152456138,-0.9107862348473935,-0.8975736866928781,-0.8835013274253608,-0.8685826373341303,-0.8528319074385107,-0.8362642257962889,-0.8188954630492581,-0.8007422572194869,-0.7818219977707433,-0.7621528089502495,-0.7417535324266842,-0.7206437092410168,-0.6988435610874445,-0.6763739709423537,-0.6532564630598443,-0.6295131823529774,-0.6051668731804859,-0.5802408575592740,-0.5547590128235738,-0.5287457487521392,-0.5022259841854193,-0.4752251231550760,-0.4477690305487353,-0.4198840073332678,-0.3915967653603417,-0.3629344017783819,-0.3339243730754320,-0.3045944687778126,-0.2749727848297392,-0.2450876966794193,-0.2149678320974091,-0.1846420437532569,-0.1541393815767154,-0.1234890649299897,-0.0927204546176825,-0.0618630247612484,-0.0309463345648982,-0.0000000000000002,0.0309463345648981,0.0618630247612479,0.0927204546176823,0.1234890649299897,0.1541393815767154,0.1846420437532573,0.2149678320974090,0.2450876966794194,0.2749727848297394,0.3045944687778134,0.3339243730754323,0.3629344017783816,0.3915967653603423,0.4198840073332678,0.4477690305487356,0.4752251231550761,0.5022259841854194,0.5287457487521391,0.5547590128235738,0.5802408575592737,0.6051668731804853,0.6295131823529774,0.6532564630598453,0.6763739709423535,0.6988435610874446,0.7206437092410169,0.7417535324266843,0.7621528089502496,0.7818219977707432,0.8007422572194866,0.8188954630492575,0.8362642257962885,0.8528319074385100,0.8685826373341300,0.8835013274253609,0.8975736866928785,0.9107862348473934,0.9231263152456138,0.9345821070189458,0.9451426364046487,0.9547977872711912,0.9635383108331343,0.9713558345581714,0.9782428702864432,0.9841928216302207,0.9891999908750331,0.9932595861878678,0.9963677327909443,0.9985215119897570,0.9997193395297703};

static const double w102[102] = {0.0003531241757290,0.0008216839593627,0.0012901663789444,0.0017574972474449,0.0022231893672213,0.0026867968121995,0.0031478818509684,0.0036060106069601,0.0040607524379975,0.0045116800513703,0.0049583698074020,0.0054004020795681,0.0058373616324336,0.0062688380041254,0.0066944258881134,0.0071137255119323,0.0075263430115933,0.0079318908009115,0.0083299879351979,0.0087202604688536,0.0091023418064788,0.0094758730471286,0.0098405033213737,0.0101958901208419,0.0105416996199107,0.0108776069892615,0.0112032967009858,0.0115184628249568,0.0118228093161937,0.0121160502929362,0.0123979103051820,0.0126681245934132,0.0129264393373006,0.0131726118941154,0.0134064110266503,0.0136276171204304,0.0138360223899952,0.0140314310740846,0.0142136596195173,0.0143825368536102,0.0145379041449629,0.0146796155524695,0.0148075379623962,0.0149215512134297,0.0150215482095407,0.0151074350205826,0.0151791309705277,0.0152365687132418,0.0152796942957514,0.0153084672089162,0.0153228604254864,0.0153228604254861,0.0153084672089158,0.0152796942957513,0.0152365687132418,0.0151791309705269,0.0151074350205826,0.0150215482095407,0.0149215512134301,0.0148075379623963,0.0146796155524693,0.0145379041449636,0.0143825368536101,0.0142136596195172,0.0140314310740847,0.0138360223899950,0.0136276171204298,0.0134064110266502,0.0131726118941152,0.0129264393373008,0.0126681245934131,0.0123979103051812,0.0121160502929376,0.0118228093161934,0.0115184628249566,0.0112032967009855,0.0108776069892618,0.0105416996199109,0.0101958901208420,0.0098405033213741,0.0094758730471278,0.0091023418064791,0.0087202604688533,0.0083299879351988,0.0079318908009118,0.0075263430115933,0.0071137255119327,0.0066944258881135,0.0062688380041255,0.0058373616324333,0.0054004020795682,0.0049583698074016,0.0045116800513701,0.0040607524379977,0.0036060106069600,0.0031478818509681,0.0026867968121998,0.0022231893672221,0.0017574972474447,0.0012901663789441,0.0008216839593621,0.0003531241757293};
static const double pts102[102] = {-0.9997247888247575,-0.9985502126452123,-0.9964382181158626,-0.9933903194857222,-0.9894093221895709,-0.9844989519453873,-0.9786638166244044,-0.9719093954671730,-0.9642420322205768,-0.9556689286080153,-0.9461981373424649,-0.9358385544652222,-0.9245999109431420,-0.9124927635041749,-0.8995284847081002,-0.8857192522564802,-0.8710780375493311,-0.8556185934979409,-0.8393554416045920,-0.8223038583209255,-0.8044798606975382,-0.7859001913381587,-0.7665823026724495,-0.7465443405621531,-0.7258051272559547,-0.7043841437090435,-0.6823015112839677,-0.6595779728499640,-0.6362348732985048,-0.6122941394933620,-0.5877782596740169,-0.5627102623317646,-0.5371136945783450,-0.5110126000274272,-0.4844314962097154,-0.4573953515428918,-0.4299295618780386,-0.4020599266445491,-0.3738126246159585,-0.3452141893194337,-0.3162914841120488,-0.2870716769472300,-0.2575822148550892,-0.2278507981606133,-0.1979053544639264,-0.1677740124070662,-0.1374850752519141,-0.1070669942941028,-0.0765483421378692,-0.0459577858569590,-0.0153240600667961,0.0153240600667959,0.0459577858569592,0.0765483421378695,0.1070669942941034,0.1374850752519152,0.1677740124070668,0.1979053544639263,0.2278507981606126,0.2575822148550885,0.2870716769472299,0.3162914841120485,0.3452141893194332,0.3738126246159577,0.4020599266445495,0.4299295618780384,0.4573953515428916,0.4844314962097152,0.5110126000274275,0.5371136945783451,0.5627102623317645,0.5877782596740166,0.6122941394933612,0.6362348732985051,0.6595779728499642,0.6823015112839678,0.7043841437090435,0.7258051272559549,0.7465443405621529,0.7665823026724498,0.7859001913381591,0.8044798606975381,0.8223038583209258,0.8393554416045924,0.8556185934979412,0.8710780375493311,0.8857192522564805,0.8995284847081001,0.9124927635041746,0.9245999109431413,0.9358385544652220,0.9461981373424651,0.9556689286080156,0.9642420322205767,0.9719093954671737,0.9786638166244047,0.9844989519453872,0.9894093221895707,0.9933903194857221,0.9964382181158629,0.9985502126452130,0.9997247888247575};

static const double w103[103] = {0.0003463341485364,0.0008058903290717,0.0012653851801786,0.0017237734526363,0.0021805855559957,0.0026353923198238,0.0030877725376136,0.0035373086952362,0.0039835863473593,0.0044261942153985,0.0048647244704938,0.0052987730721394,0.0057279401244952,0.0061518302373746,0.0065700528867958,0.0069822227728095,0.0073879601733688,0.0077868912935376,0.0081786486094728,0.0085628712067866,0.0089392051128938,0.0093073036230198,0.0096668276195496,0.0100174458843957,0.0103588354041131,0.0106906816674581,0.0110126789551232,0.0113245306213755,0.0116259493673377,0.0119166575056635,0.0121963872163533,0.0124648807934905,0.0127218908826491,0.0129671807087765,0.0132005242943214,0.0134217066674204,0.0136305240599414,0.0138267840952113,0.0140103059652419,0.0141809205973050,0.0143384708096916,0.0144828114565179,0.0146138095614437,0.0147313444401798,0.0148353078116689,0.0149256038978408,0.0150021495118518,0.0150648741347202,0.0151137199802931,0.0151486420484849,0.0151696081667294,0.0151765990196265,0.0151696081667300,0.0151486420484842,0.0151137199802935,0.0150648741347199,0.0150021495118520,0.0149256038978405,0.0148353078116690,0.0147313444401804,0.0146138095614437,0.0144828114565176,0.0143384708096909,0.0141809205973046,0.0140103059652423,0.0138267840952117,0.0136305240599415,0.0134217066674194,0.0132005242943212,0.0129671807087766,0.0127218908826493,0.0124648807934903,0.0121963872163532,0.0119166575056631,0.0116259493673387,0.0113245306213754,0.0110126789551233,0.0106906816674579,0.0103588354041127,0.0100174458843958,0.0096668276195494,0.0093073036230204,0.0089392051128930,0.0085628712067870,0.0081786486094729,0.0077868912935378,0.0073879601733691,0.0069822227728092,0.0065700528867959,0.0061518302373742,0.0057279401244958,0.0052987730721392,0.0048647244704936,0.0044261942153986,0.0039835863473594,0.0035373086952362,0.0030877725376137,0.0026353923198239,0.0021805855559953,0.0017237734526367,0.0012653851801786,0.0008058903290716,0.0003463341485360};
static const double pts103[103] = {-0.9997300809445722,-0.9985780856946571,-0.9965066718828267,-0.9935172872581344,-0.9896126294038796,-0.9847962820681040,-0.9790726778979438,-0.9724470880245817,-0.9649256155239884,-0.9565151892344070,-0.9472235571551704,-0.9370592792134924,-0.9260317193329335,-0.9141510367833071,-0.9014281768085082,-0.8878748605356954,-0.8735035741726349,-0.8583275575018534,-0.8423607916815328,-0.8256179863639880,-0.8081145661433814,-0.7898666563450231,-0.7708910681692639,-0.7512052832036251,-0.7308274373173925,-0.7097763039534859,-0.6880712768330037,-0.6657323520883320,-0.6427801098413073,-0.6192356952433704,-0.5951207989951933,-0.5704576373637176,-0.5452689317150073,-0.5195778875817795,-0.4934081732848867,-0.4667838981284564,-0.4397295901887623,-0.4122701737173014,-0.3844309461788888,-0.3562375549459192,-0.3277159736702789,-0.2988924783546578,-0.2697936231453276,-0.2404462158686662,-0.2108772933339807,-0.1811140964253718,-0.1511840450055977,-0.1211147126550433,-0.0909338012690795,-0.0606691155372115,-0.0303485373275182,-0.0000000000000004,0.0303485373275175,0.0606691155372107,0.0909338012690793,0.1211147126550423,0.1511840450055971,0.1811140964253721,0.2108772933339812,0.2404462158686669,0.2697936231453282,0.2988924783546582,0.3277159736702789,0.3562375549459195,0.3844309461788888,0.4122701737173010,0.4397295901887618,0.4667838981284562,0.4934081732848862,0.5195778875817790,0.5452689317150070,0.5704576373637171,0.5951207989951929,0.6192356952433704,0.6427801098413075,0.6657323520883321,0.6880712768330040,0.7097763039534861,0.7308274373173919,0.7512052832036257,0.7708910681692642,0.7898666563450233,0.8081145661433820,0.8256179863639880,0.8423607916815329,0.8583275575018533,0.8735035741726348,0.8878748605356953,0.9014281768085081,0.9141510367833074,0.9260317193329339,0.9370592792134925,0.9472235571551709,0.9565151892344078,0.9649256155239889,0.9724470880245821,0.9790726778979435,0.9847962820681032,0.9896126294038798,0.9935172872581345,0.9965066718828270,0.9985780856946576,0.9997300809445726};

static const double w104[104] = {0.0003397380912423,0.0007905476455974,0.0012413109010883,0.0016910104093434,0.0021391933762360,0.0025854466036639,0.0030293646373756,0.0034705455625902,0.0039085903782132,0.0043431030789618,0.0047736909191635,0.0051999647312970,0.0056215392620828,0.0060380335133583,0.0064490710827633,0.0068542805019833,0.0072532955713841,0.0076457556903463,0.0080313061827761,0.0084095986174073,0.0087802911225413,0.0091430486949112,0.0094975435023667,0.0098434551801022,0.0101804711201488,0.0105082867538599,0.0108266058271491,0.0111351406682012,0.0114336124474475,0.0117217514295403,0.0119992972171137,0.0122659989861114,0.0125216157124524,0.0127659163898524,0.0129986802385876,0.0132196969050143,0.0134287666516698,0.0136257005377808,0.0138103205900103,0.0139824599632944,0.0141419630916281,0.0142886858286473,0.0144224955779006,0.0145432714126783,0.0146509041852958,0.0147452966257332,0.0148263634295408,0.0148940313349280,0.0149482391889738,0.0149889380028904,0.0150160909962971,0.0150296736304578,0.0150296736304572,0.0150160909962970,0.0149889380028897,0.0149482391889736,0.0148940313349277,0.0148263634295414,0.0147452966257334,0.0146509041852962,0.0145432714126781,0.0144224955779006,0.0142886858286466,0.0141419630916284,0.0139824599632951,0.0138103205900101,0.0136257005377810,0.0134287666516695,0.0132196969050142,0.0129986802385875,0.0127659163898530,0.0125216157124515,0.0122659989861113,0.0119992972171145,0.0117217514295404,0.0114336124474469,0.0111351406682014,0.0108266058271492,0.0105082867538605,0.0101804711201488,0.0098434551801025,0.0094975435023663,0.0091430486949112,0.0087802911225419,0.0084095986174076,0.0080313061827759,0.0076457556903459,0.0072532955713836,0.0068542805019826,0.0064490710827636,0.0060380335133585,0.0056215392620829,0.0051999647312972,0.0047736909191634,0.0043431030789620,0.0039085903782132,0.0034705455625904,0.0030293646373749,0.0025854466036642,0.0021391933762363,0.0016910104093439,0.0012413109010882,0.0007905476455973,0.0003397380912423};
static const double pts104[104] = {-0.9997352218760888,-0.9986051626519776,-0.9965731714060388,-0.9936406326897030,-0.9898101413367201,-0.9850851458144628,-0.9794699117905923,-0.9729695120673590,-0.9655898203461579,-0.9573375053700739,-0.9482200246834841,-0.9382456177991046,-0.9274232987070867,-0.9157628477059166,-0.9032748025512225,-0.8899704489254117,-0.8758618102342715,-0.8609616367385051,-0.8452833940293626,-0.8288412508583834,-0.8116500663320463,-0.7937253764827693,-0.7750833802283035,-0.7557409247321754,-0.7357154901783581,-0.7150251739739252,-0.6936886743939370,-0.6717252736833362,-0.6491548206311187,-0.6259977126325146,-0.6022748772554005,-0.5780077533275771,-0.5532182715620347,-0.5279288347376770,-0.5021622974534504,-0.4759419454741394,-0.4492914746865265,-0.4222349696849034,-0.3947968820053119,-0.3670020080281645,-0.3388754665692303,-0.3104426761792210,-0.2817293321725083,-0.2527613834057212,-0.2235650088272126,-0.1941665938185883,-0.1645927063496752,-0.1348700729684854,-0.1050255546478668,-0.0750861225106705,-0.0450788334553779,-0.0150308057042056,0.0150308057042062,0.0450788334553783,0.0750861225106706,0.1050255546478668,0.1348700729684857,0.1645927063496753,0.1941665938185882,0.2235650088272128,0.2527613834057210,0.2817293321725081,0.3104426761792209,0.3388754665692308,0.3670020080281647,0.3947968820053117,0.4222349696849034,0.4492914746865270,0.4759419454741399,0.5021622974534501,0.5279288347376772,0.5532182715620343,0.5780077533275783,0.6022748772554003,0.6259977126325154,0.6491548206311184,0.6717252736833368,0.6936886743939373,0.7150251739739258,0.7357154901783589,0.7557409247321757,0.7750833802283033,0.7937253764827689,0.8116500663320461,0.8288412508583829,0.8452833940293625,0.8609616367385053,0.8758618102342711,0.8899704489254119,0.9032748025512226,0.9157628477059159,0.9274232987070863,0.9382456177991046,0.9482200246834838,0.9573375053700734,0.9655898203461571,0.9729695120673587,0.9794699117905921,0.9850851458144622,0.9898101413367193,0.9936406326897032,0.9965731714060390,0.9986051626519773,0.9997352218760883};

static const double w105[105] = {0.0003333286856650,0.0007756389060140,0.0012179169172660,0.0016591719922165,0.0020989673670233,0.0025369050761800,0.0029725946879608,0.0034056491660821,0.0038356842425465,0.0042623184851665,0.0046851735434581,0.0051038744484175,0.0055180499296754,0.0059273327375507,0.0063313599651123,0.0067297733680759,0.0071222196814038,0.0075083509319370,0.0078878247465640,0.0082603046555766,0.0086254603908667,0.0089829681786700,0.0093325110265875,0.0096737790046098,0.0100064695199014,0.0103302875850707,0.0106449460797200,0.0109501660050155,0.0112456767310548,0.0115312162368298,0.0118065313425402,0.0120713779340844,0.0123255211794998,0.0125687357371867,0.0128008059557040,0.0130215260649858,0.0132307003587865,0.0134281433682105,0.0136136800261581,0.0137871458225573,0.0139483869502220,0.0140972604412371,0.0142336342937175,0.0143573875888518,0.0144684105981187,0.0145666048805788,0.0146518833701588,0.0147241704528524,0.0147834020337626,0.0148295255939347,0.0148625002369219,0.0148822967250479,0.0148888975053312,0.0148822967250476,0.0148625002369216,0.0148295255939343,0.0147834020337625,0.0147241704528528,0.0146518833701585,0.0145666048805789,0.0144684105981190,0.0143573875888519,0.0142336342937170,0.0140972604412372,0.0139483869502220,0.0137871458225569,0.0136136800261585,0.0134281433682101,0.0132307003587863,0.0130215260649856,0.0128008059557036,0.0125687357371865,0.0123255211795006,0.0120713779340841,0.0118065313425405,0.0115312162368296,0.0112456767310544,0.0109501660050149,0.0106449460797196,0.0103302875850703,0.0100064695199016,0.0096737790046107,0.0093325110265872,0.0089829681786700,0.0086254603908668,0.0082603046555763,0.0078878247465633,0.0075083509319369,0.0071222196814041,0.0067297733680757,0.0063313599651122,0.0059273327375511,0.0055180499296754,0.0051038744484173,0.0046851735434584,0.0042623184851663,0.0038356842425468,0.0034056491660818,0.0029725946879606,0.0025369050761806,0.0020989673670232,0.0016591719922166,0.0012179169172659,0.0007756389060145,0.0003333286856649};
static const double pts105[105] = {-0.9997402173238205,-0.9986314735453337,-0.9966377903571823,-0.9937604922257571,-0.9900020760509027,-0.9853658613341564,-0.9798559545473947,-0.9734772393982805,-0.9662353708801532,-0.9581367697190225,-0.9491886164708115,-0.9393988450629263,-0.9287761357156258,-0.9173299072229908,-0.9050703085892554,-0.8920082100229346,-0.8781551932943182,-0.8635235414636403,-0.8481262279883752,-0.8319769052189561,-0.8150898922928844,-0.7974801624378591,-0.7791633296950865,-0.7601556350745053,-0.7404739321541617,-0.7201356721364885,-0.6991588883747246,-0.6775621803831735,-0.6553646973454956,-0.6325861211356224,-0.6092466488663678,-0.5853669749811975,-0.5609682729050361,-0.5360721762703762,-0.5107007597353447,-0.4848765194107149,-0.4586223529132428,-0.4319615390629950,-0.4049177172426770,-0.3775148664372628,-0.3497772839725031,-0.3217295639711891,-0.2933965755462280,-0.2648034407499162,-0.2359755122989270,-0.2069383510947801,-0.1777177035597163,-0.1483394788080770,-0.1188297256734330,-0.0892146096118247,-0.0595203895015963,-0.0297733943603992,-0.0000000000000005,0.0297733943603990,0.0595203895015962,0.0892146096118244,0.1188297256734330,0.1483394788080767,0.1777177035597161,0.2069383510947802,0.2359755122989269,0.2648034407499159,0.2933965755462277,0.3217295639711896,0.3497772839725038,0.3775148664372616,0.4049177172426774,0.4319615390629953,0.4586223529132433,0.4848765194107155,0.5107007597353453,0.5360721762703765,0.5609682729050351,0.5853669749811965,0.6092466488663674,0.6325861211356225,0.6553646973454967,0.6775621803831743,0.6991588883747244,0.7201356721364891,0.7404739321541614,0.7601556350745055,0.7791633296950862,0.7974801624378588,0.8150898922928844,0.8319769052189560,0.8481262279883757,0.8635235414636402,0.8781551932943182,0.8920082100229344,0.9050703085892555,0.9173299072229911,0.9287761357156256,0.9393988450629257,0.9491886164708117,0.9581367697190225,0.9662353708801537,0.9734772393982800,0.9798559545473947,0.9853658613341565,0.9900020760509030,0.9937604922257571,0.9966377903571823,0.9986314735453333,0.9997402173238206};

static const double w106[106] = {0.0003270989555120,0.0007611479011575,0.0011951778455708,0.0016282237568578,0.0020598641773692,0.0024897156752405,0.0029174021517010,0.0033425507676548,0.0037647913159064,0.0041837562751906,0.0045990810393741,0.0050104041996641,0.0054173678440463,0.0058196178616894,0.0062168042475556,0.0066085814050995,0.0069946084459412,0.0073745494858825,0.0077480739368063,0.0081148567941054,0.0084745789193241,0.0088269273177563,0.0091715954107173,0.0095082833022587,0.0098366980400805,0.0101565538704078,0.0104675724866117,0.0107694832713522,0.0110620235320370,0.0113449387293807,0.0116179826988821,0.0118809178650005,0.0121335154478744,0.0123755556623770,0.0126068279093509,0.0128271309588502,0.0130362731252282,0.0132340724339233,0.0134203567797928,0.0135949640768651,0.0137577423993651,0.0139085501139075,0.0140472560027327,0.0141737393778763,0.0142878901861808,0.0143896091050529,0.0144788076288843,0.0145554081460592,0.0146193440064855,0.0146705595795846,0.0147090103026992,0.0147346627198627,0.0147474945109139,0.0147474945109138,0.0147346627198629,0.0147090103026991,0.0146705595795844,0.0146193440064858,0.0145554081460593,0.0144788076288846,0.0143896091050529,0.0142878901861801,0.0141737393778767,0.0140472560027331,0.0139085501139079,0.0137577423993649,0.0135949640768645,0.0134203567797930,0.0132340724339229,0.0130362731252281,0.0128271309588499,0.0126068279093509,0.0123755556623769,0.0121335154478743,0.0118809178650007,0.0116179826988825,0.0113449387293810,0.0110620235320363,0.0107694832713521,0.0104675724866120,0.0101565538704079,0.0098366980400805,0.0095082833022591,0.0091715954107170,0.0088269273177560,0.0084745789193243,0.0081148567941049,0.0077480739368061,0.0073745494858824,0.0069946084459414,0.0066085814050997,0.0062168042475553,0.0058196178616892,0.0054173678440465,0.0050104041996640,0.0045990810393738,0.0041837562751910,0.0037647913159065,0.0033425507676552,0.0029174021517006,0.0024897156752406,0.0020598641773689,0.0016282237568577,0.0011951778455711,0.0007611479011568,0.0003270989555124};
static const double pts106[106] = {-0.9997450727257577,-0.9986570470004216,-0.9967005989693929,-0.9938769959493108,-0.9901886414540269,-0.9856387319838419,-0.9802312221673921,-0.9739708153412303,-0.9668629578678989,-0.9589138338682481,-0.9501303596348836,-0.9405201775243768,-0.9300916492646369,-0.9188538486572626,-0.9068165536703729,-0.8939902379238910,-0.8803860615723237,-0.8660158615917620,-0.8508921414788970,-0.8350280603706594,-0.8184374215937379,-0.8011346606538131,-0.7831348326748798,-0.7644535992995430,-0.7451072150616429,-0.7251125132430605,-0.7044868912269844,-0.6832482953603795,-0.6614152053388160,-0.6390066181272516,-0.6160420314307398,-0.5925414267294585,-0.5685252518928048,-0.5440144033876954,-0.5190302080965421,-0.4935944047607255,-0.4677291250657134,-0.4414568743842773,-0.4148005121945754,-0.3877832321901105,-0.3604285420989073,-0.3327602432294379,-0.3048024097611078,-0.2765793677973145,-0.2481156741993102,-0.2194360952192818,-0.1905655849512395,-0.1615292636184636,-0.1323523957164052,-0.1030603680300530,-0.0736786675448973,-0.0442328592707117,-0.0147485639974404,0.0147485639974408,0.0442328592707121,0.0736786675448976,0.1030603680300528,0.1323523957164057,0.1615292636184636,0.1905655849512397,0.2194360952192820,0.2481156741993101,0.2765793677973145,0.3048024097611081,0.3327602432294379,0.3604285420989073,0.3877832321901106,0.4148005121945753,0.4414568743842779,0.4677291250657131,0.4935944047607254,0.5190302080965423,0.5440144033876959,0.5685252518928049,0.5925414267294591,0.6160420314307397,0.6390066181272516,0.6614152053388158,0.6832482953603792,0.7044868912269838,0.7251125132430605,0.7451072150616430,0.7644535992995433,0.7831348326748803,0.8011346606538128,0.8184374215937377,0.8350280603706592,0.8508921414788972,0.8660158615917622,0.8803860615723237,0.8939902379238900,0.9068165536703731,0.9188538486572626,0.9300916492646369,0.9405201775243770,0.9501303596348838,0.9589138338682484,0.9668629578678994,0.9739708153412305,0.9802312221673922,0.9856387319838418,0.9901886414540269,0.9938769959493107,0.9967005989693929,0.9986570470004215,0.9997450727257575};

static const double w107[107] = {0.0003210422473964,0.0007470591715702,0.0011730694753560,0.0015981328468910,0.0020218424499188,0.0024438287254386,0.0028637292556772,0.0032811847544549,0.0036958384394706,0.0041073360738773,0.0045153261798913,0.0049194603045714,0.0053193933026398,0.0057147836243578,0.0061052936037608,0.0064905897452193,0.0068703430072263,0.0072442290828196,0.0076119286761856,0.0079731277751208,0.0083275179190588,0.0086747964624016,0.0090146668329187,0.0093468387849736,0.0096710286473651,0.0099869595655577,0.0102943617380998,0.0105929726470192,0.0108825372820038,0.0111628083581736,0.0114335465272515,0.0116945205819641,0.0119455076534863,0.0121862934017664,0.0124166721985691,0.0126364473030789,0.0128454310299123,0.0130434449094008,0.0132303198399967,0.0134058962326886,0.0135700241472856,0.0137225634204635,0.0138633837854640,0.0139923649833397,0.0141093968656547,0.0142143794885486,0.0143072231980890,0.0143878487068327,0.0144561871615375,0.0145121802019625,0.0145557800107052,0.0145869493540405,0.0146056616137120,0.0146119008096694,0.0146056616137119,0.0145869493540407,0.0145557800107053,0.0145121802019620,0.0144561871615372,0.0143878487068326,0.0143072231980892,0.0142143794885489,0.0141093968656549,0.0139923649833396,0.0138633837854644,0.0137225634204634,0.0135700241472854,0.0134058962326885,0.0132303198399964,0.0130434449094003,0.0128454310299131,0.0126364473030794,0.0124166721985693,0.0121862934017666,0.0119455076534865,0.0116945205819634,0.0114335465272517,0.0111628083581729,0.0108825372820039,0.0105929726470189,0.0102943617380999,0.0099869595655581,0.0096710286473653,0.0093468387849733,0.0090146668329179,0.0086747964624013,0.0083275179190586,0.0079731277751206,0.0076119286761855,0.0072442290828196,0.0068703430072264,0.0064905897452189,0.0061052936037607,0.0057147836243575,0.0053193933026407,0.0049194603045715,0.0045153261798912,0.0041073360738775,0.0036958384394702,0.0032811847544547,0.0028637292556776,0.0024438287254389,0.0020218424499186,0.0015981328468916,0.0011730694753557,0.0007470591715704,0.0003210422473964};
static const double pts107[107] = {-0.9997497932681649,-0.9986819103183445,-0.9967616642280318,-0.9939902679336546,-0.9903700358604377,-0.9859040471442654,-0.9805961115195163,-0.9744507601968966,-0.9674732404337489,-0.9596695105339541,-0.9510462345576823,-0.9416107765421038,-0.9313711941703715,-0.9203362318687549,-0.9085153133271660,-0.8959185334446641,-0.8825566497044788,-0.8684410729847379,-0.8535838578121107,-0.8379976920663317,-0.8216958861441935,-0.8046923615921373,-0.7870016392170764,-0.7686388266855514,-0.7496196056217881,-0.7299602182156414,-0.7096774533518618,-0.6887886322725111,-0.6673115937847689,-0.6452646790267592,-0.6226667158043989,-0.5995370025126476,-0.5758952916548835,-0.5517617729744793,-0.5271570562129878,-0.5021021535096516,-0.4766184614572709,-0.4507277428297662,-0.4244521079970081,-0.3978139960428230,-0.3708361556022697,-0.3435416254345727,-0.3159537147482858,-0.2880959832955012,-0.2599922212520921,-0.2316664289011839,-0.2031427961371886,-0.1744456818079199,-0.1455995929124190,-0.1166291636722658,-0.0875591344942407,-0.0584143308423054,-0.0292196420369496,0.0000000000000002,0.0292196420369502,0.0584143308423062,0.0875591344942412,0.1166291636722663,0.1455995929124194,0.1744456818079204,0.2031427961371889,0.2316664289011842,0.2599922212520923,0.2880959832955013,0.3159537147482858,0.3435416254345728,0.3708361556022693,0.3978139960428231,0.4244521079970082,0.4507277428297660,0.4766184614572710,0.5021021535096502,0.5271570562129879,0.5517617729744788,0.5758952916548831,0.5995370025126475,0.6226667158043984,0.6452646790267590,0.6673115937847685,0.6887886322725109,0.7096774533518619,0.7299602182156416,0.7496196056217882,0.7686388266855519,0.7870016392170768,0.8046923615921378,0.8216958861441936,0.8379976920663316,0.8535838578121111,0.8684410729847380,0.8825566497044792,0.8959185334446644,0.9085153133271662,0.9203362318687544,0.9313711941703717,0.9416107765421040,0.9510462345576823,0.9596695105339533,0.9674732404337487,0.9744507601968971,0.9805961115195168,0.9859040471442653,0.9903700358604381,0.9939902679336547,0.9967616642280317,0.9986819103183446,0.9997497932681652};

static const double w108[108] = {0.0003151522130616,0.0007333579662864,0.0011515687040916,0.0015688679069677,0.0019848627120531,0.0023991968082054,0.0028115208419289,0.0032214884704008,0.0036287557344340,0.0040329810885408,0.0044338255999840,0.0048309531991724,0.0052240309469076,0.0056127293067407,0.0059967224178576,0.0063756883664809,0.0067493094547411,0.0071172724664454,0.0074792689293091,0.0078349953733464,0.0081841535851388,0.0085264508577480,0.0088616002360389,0.0091893207572029,0.0095093376862629,0.0098213827463766,0.0101251943437186,0.0104205177867746,0.0107071054998429,0.0109847172305804,0.0112531202514054,0.0115120895545957,0.0117614080409128,0.0120008667016003,0.0122302647935991,0.0124494100078324,0.0126581186304211,0.0128562156966965,0.0130435351378727,0.0132199199202674,0.0133852221769454,0.0135393033316782,0.0136820342151149,0.0138132951730672,0.0139329761668176,0.0140409768653682,0.0141372067295486,0.0142215850879168,0.0142940412043885,0.0143545143375351,0.0144029537915079,0.0144393189585305,0.0144635793529512,0.0144757146367869,0.0144757146367876,0.0144635793529503,0.0144393189585308,0.0144029537915072,0.0143545143375356,0.0142940412043883,0.0142215850879164,0.0141372067295487,0.0140409768653689,0.0139329761668178,0.0138132951730671,0.0136820342151146,0.0135393033316782,0.0133852221769458,0.0132199199202673,0.0130435351378729,0.0128562156966964,0.0126581186304208,0.0124494100078324,0.0122302647935987,0.0120008667016007,0.0117614080409131,0.0115120895545961,0.0112531202514059,0.0109847172305807,0.0107071054998423,0.0104205177867741,0.0101251943437189,0.0098213827463770,0.0095093376862623,0.0091893207572020,0.0088616002360392,0.0085264508577479,0.0081841535851391,0.0078349953733467,0.0074792689293089,0.0071172724664453,0.0067493094547405,0.0063756883664809,0.0059967224178580,0.0056127293067404,0.0052240309469074,0.0048309531991726,0.0044338255999838,0.0040329810885402,0.0036287557344345,0.0032214884704014,0.0028115208419286,0.0023991968082049,0.0019848627120533,0.0015688679069675,0.0011515687040917,0.0007333579662865,0.0003151522130616};
static const double pts108[108] = {-0.9997543838994400,-0.9987060895484801,-0.9968210500492208,-0.9941004265723664,-0.9905464485172712,-0.9861620829852561,-0.9809510013874646,-0.9749175706060933,-0.9680668478021078,-0.9604045756662573,-0.9519371774066426,-0.9426717512773787,-0.9326160645865383,-0.9217785471633678,-0.9101682842797724,-0.8977950090272941,-0.8846690941536929,-0.8708015433647981,-0.8562039820983122,-0.8408886477769367,-0.8248683795488013,-0.8081566075236674,-0.7907673415138636,-0.7727151592893393,-0.7540151943566501,-0.7346831232721113,-0.7147351524997246,-0.6941880048249052,-0.6730589053353763,-0.6513655669809887,-0.6291261757245663,-0.6063593752962180,-0.5830842515639048,-0.5593203165333537,-0.5350874919907365,-0.5104060928018241,-0.4852968098816164,-0.4597806928487209,-0.4338791323790299,-0.4076138422734776,-0.3810068412549194,-0.3540804345093883,-0.3268571949872060,-0.2993599444796169,-0.2716117344868204,-0.2436358268934304,-0.2154556744675650,-0.1870949011999181,-0.1585772824992879,-0.1299267252611720,-0.1011672478261316,-0.0723229598447330,-0.0434180420659375,-0.0144767260658924,0.0144767260658918,0.0434180420659377,0.0723229598447333,0.1011672478261324,0.1299267252611729,0.1585772824992884,0.1870949011999192,0.2154556744675656,0.2436358268934307,0.2716117344868209,0.2993599444796172,0.3268571949872056,0.3540804345093886,0.3810068412549192,0.4076138422734776,0.4338791323790304,0.4597806928487213,0.4852968098816167,0.5104060928018243,0.5350874919907364,0.5593203165333527,0.5830842515639046,0.6063593752962176,0.6291261757245660,0.6513655669809888,0.6730589053353762,0.6941880048249055,0.7147351524997252,0.7346831232721112,0.7540151943566507,0.7727151592893392,0.7907673415138639,0.8081566075236671,0.8248683795488010,0.8408886477769367,0.8562039820983121,0.8708015433647975,0.8846690941536922,0.8977950090272945,0.9101682842797723,0.9217785471633678,0.9326160645865380,0.9426717512773783,0.9519371774066431,0.9604045756662570,0.9680668478021076,0.9749175706060934,0.9809510013874646,0.9861620829852557,0.9905464485172708,0.9941004265723660,0.9968210500492203,0.9987060895484797,0.9997543838994398};

static const double w109[109] = {0.0003094227927468,0.0007200302042201,0.0011306534770810,0.0015403990012761,0.0019488872738634,0.0023557746400732,0.0027607242270163,0.0031634020582223,0.0035634764278398,0.0039606179200719,0.0043544995946319,0.0047447972227063,0.0051311895396042,0.0055133585025549,0.0058909895491702,0.0062637718546097,0.0066313985864435,0.0069935671566393,0.0073499794702860,0.0077003421707355,0.0080443668809358,0.0083817704406940,0.0087122751396910,0.0090356089460136,0.0093515057300364,0.0096597054834456,0.0099599545332362,0.0102520057504928,0.0105356187537891,0.0108105601070390,0.0110766035116257,0.0113335299926602,0.0115811280792147,0.0118191939783811,0.0120475317429965,0.0122659534329356,0.0124742792697924,0.0126723377848492,0.0128599659602161,0.0130370093629984,0.0132033222724149,0.0133587677997304,0.0135032180009324,0.0136365539820328,0.0137586659969303,0.0138694535377401,0.0139688254175193,0.0140566998453205,0.0141330044935105,0.0141976765573073,0.0142506628064661,0.0142919196290966,0.0143214130675586,0.0143391188464100,0.0143450223923897,0.0143391188464098,0.0143214130675579,0.0142919196290963,0.0142506628064658,0.0141976765573070,0.0141330044935105,0.0140566998453201,0.0139688254175197,0.0138694535377402,0.0137586659969303,0.0136365539820324,0.0135032180009327,0.0133587677997307,0.0132033222724146,0.0130370093629989,0.0128599659602154,0.0126723377848502,0.0124742792697923,0.0122659534329362,0.0120475317429967,0.0118191939783798,0.0115811280792156,0.0113335299926602,0.0110766035116255,0.0108105601070393,0.0105356187537888,0.0102520057504928,0.0099599545332356,0.0096597054834454,0.0093515057300363,0.0090356089460138,0.0087122751396913,0.0083817704406942,0.0080443668809360,0.0077003421707364,0.0073499794702861,0.0069935671566395,0.0066313985864434,0.0062637718546105,0.0058909895491705,0.0055133585025548,0.0051311895396042,0.0047447972227063,0.0043544995946321,0.0039606179200718,0.0035634764278395,0.0031634020582222,0.0027607242270159,0.0023557746400732,0.0019488872738634,0.0015403990012765,0.0011306534770808,0.0007200302042201,0.0003094227927466};
static const double pts109[109] = {-0.9997588493430827,-0.9987296095567185,-0.9968788174470392,-0.9942075848883766,-0.9907180600971576,-0.9864131031823449,-0.9812962534486652,-0.9753717208273341,-0.9686443809073819,-0.9611197704224664,-0.9528040824990931,-0.9437041614741201,-0.9338274972206492,-0.9231822189623478,-0.9117770885710501,-0.8996214933485118,-0.8867254382960097,-0.8730995378770197,-0.8587550072791230,-0.8437036531820091,-0.8279578640389549,-0.8115305998796812,-0.7944353816428855,-0.7766862800472077,-0.7582979040097400,-0.7392853886216034,-0.7196643826904749,-0.6994510358603069,-0.6786619853188337,-0.6573143421038068,-0.6354256770192178,-0.6130140061731109,-0.5900977761488704,-0.5666958488222098,-0.5428274858363324,-0.5185123327480643,-0.4937704028579889,-0.4686220607379087,-0.4430880054691809,-0.4171892536057226,-0.3909471218757181,-0.3643832096362551,-0.3375193810953371,-0.3103777473159001,-0.2829806480166556,-0.2553506331847235,-0.2275104445152020,-0.1994829966929473,-0.1712913585319668,-0.1429587339879552,-0.1145084430595919,-0.0859639025943369,-0.0573486070145002,-0.0286861089794688,-0.0000000000000002,0.0286861089794689,0.0573486070145000,0.0859639025943370,0.1145084430595918,0.1429587339879548,0.1712913585319673,0.1994829966929474,0.2275104445152017,0.2553506331847232,0.2829806480166553,0.3103777473158998,0.3375193810953364,0.3643832096362551,0.3909471218757186,0.4171892536057232,0.4430880054691809,0.4686220607379090,0.4937704028579887,0.5185123327480642,0.5428274858363332,0.5666958488222102,0.5900977761488710,0.6130140061731107,0.6354256770192186,0.6573143421038071,0.6786619853188344,0.6994510358603069,0.7196643826904751,0.7392853886216035,0.7582979040097402,0.7766862800472080,0.7944353816428856,0.8115305998796810,0.8279578640389554,0.8437036531820086,0.8587550072791225,0.8730995378770192,0.8867254382960096,0.8996214933485117,0.9117770885710499,0.9231822189623470,0.9338274972206489,0.9437041614741202,0.9528040824990924,0.9611197704224668,0.9686443809073823,0.9753717208273340,0.9812962534486651,0.9864131031823451,0.9907180600971579,0.9942075848883764,0.9968788174470392,0.9987296095567190,0.9997588493430825};

static const double w110[110] = {0.0003038481995928,0.0007070624380004,0.0011103027309582,0.0015126975371666,0.0019138801324996,0.0023135189585297,0.0027112890702926,0.0031068683112145,0.0034999366890505,0.0038901763855047,0.0042772719289698,0.0046609104169774,0.0050407817551348,0.0054165789012535,0.0057879981102632,0.0061547391779998,0.0065165056828929,0.0068730052250003,0.0072239496620117,0.0075690553419354,0.0079080433322335,0.0082406396451842,0.0085665754592751,0.0088855873364431,0.0091974174349697,0.0095018137178665,0.0097985301565666,0.0100873269297725,0.0103679706172795,0.0106402343886385,0.0109038981864836,0.0111587489043910,0.0114045805591225,0.0116411944571092,0.0118683993550406,0.0120860116144408,0.0122938553500917,0.0124917625721918,0.0126795733221320,0.0128571358017844,0.0130243064961915,0.0131809502895604,0.0133269405744743,0.0134621593542181,0.0135864973381503,0.0136998540300413,0.0138021378092929,0.0138932660049948,0.0139731649627421,0.0140417701041673,0.0140990259791332,0.0141448863105553,0.0141793140317984,0.0142022813166439,0.0142137696017717,0.0142137696017721,0.0142022813166436,0.0141793140317986,0.0141448863105549,0.0140990259791331,0.0140417701041663,0.0139731649627420,0.0138932660049946,0.0138021378092925,0.0136998540300416,0.0135864973381509,0.0134621593542177,0.0133269405744740,0.0131809502895605,0.0130243064961911,0.0128571358017840,0.0126795733221319,0.0124917625721920,0.0122938553500920,0.0120860116144409,0.0118683993550404,0.0116411944571090,0.0114045805591234,0.0111587489043905,0.0109038981864834,0.0106402343886382,0.0103679706172794,0.0100873269297728,0.0097985301565670,0.0095018137178663,0.0091974174349697,0.0088855873364428,0.0085665754592751,0.0082406396451842,0.0079080433322335,0.0075690553419355,0.0072239496620112,0.0068730052250006,0.0065165056828928,0.0061547391779998,0.0057879981102636,0.0054165789012537,0.0050407817551350,0.0046609104169775,0.0042772719289697,0.0038901763855043,0.0034999366890508,0.0031068683112146,0.0027112890702922,0.0023135189585302,0.0019138801324992,0.0015126975371668,0.0011103027309587,0.0007070624380000,0.0003038481995926};
static const double pts110[110] = {-0.9997631941098531,-0.9987524940894014,-0.9969350246901908,-0.9943118508236003,-0.9908850431599953,-0.9866573595884794,-0.9816322131920404,-0.9758136639347582,-0.9692064139038785,-0.9618158030181841,-0.9536478045209081,-0.9447090200683341,-0.9350066743540582,-0.9245486092490930,-0.9133432774524758,-0.9013997356529535,-0.8887276372050831,-0.8753372243245289,-0.8612393198082738,-0.8464453182860944,-0.8309671770101783,-0.8148174061902074,-0.7980090588816583,-0.7805557204354310,-0.7624714975173208,-0.7437710067061727,-0.7244693626799381,-0.7045821659991621,-0.6841254904977679,-0.6631158702913367,-0.6415702864133699,-0.6195061530903357,-0.5969413036665977,-0.5738939761905860,-0.5503827986738771,-0.5264267740350889,-0.5020452647407514,-0.4772579771555777,-0.4520849456147861,-0.4265465162313296,-0.4006633304511450,-0.3744563083696834,-0.3479466318232400,-0.3211557272687195,-0.2941052484656923,-0.2668170589747335,-0.2393132144861871,-0.2116159449936473,-0.1837476368265531,-0.1557308145564300,-0.1275881227913903,-0.0993423078736229,-0.0710161994946518,-0.0426326922432231,-0.0142147271007503,0.0142147271007499,0.0426326922432232,0.0710161994946515,0.0993423078736231,0.1275881227913903,0.1557308145564297,0.1837476368265535,0.2116159449936474,0.2393132144861868,0.2668170589747329,0.2941052484656923,0.3211557272687192,0.3479466318232391,0.3744563083696831,0.4006633304511445,0.4265465162313299,0.4520849456147861,0.4772579771555777,0.5020452647407508,0.5264267740350895,0.5503827986738771,0.5738939761905851,0.5969413036665975,0.6195061530903355,0.6415702864133692,0.6631158702913363,0.6841254904977676,0.7045821659991618,0.7244693626799381,0.7437710067061727,0.7624714975173209,0.7805557204354312,0.7980090588816582,0.8148174061902073,0.8309671770101780,0.8464453182860945,0.8612393198082737,0.8753372243245288,0.8887276372050832,0.9013997356529538,0.9133432774524760,0.9245486092490937,0.9350066743540584,0.9447090200683340,0.9536478045209086,0.9618158030181855,0.9692064139038793,0.9758136639347591,0.9816322131920404,0.9866573595884787,0.9908850431599953,0.9943118508236001,0.9969350246901914,0.9987524940894017,0.9997631941098535};

static const double w111[111] = {0.0002984229050302,0.0006944418200523,0.0010904963407159,0.0014857361935227,0.0018798068824526,0.0022723884149072,0.0026631672502586,0.0030518325340561,0.0034380754761466,0.0038215893512340,0.0042020696597347,0.0045792143375389,0.0049527239820868,0.0053223020836439,0.0056876552574860,0.0060484934751080,0.0064045302935171,0.0067554830820801,0.0071010732465584,0.0074410264500598,0.0077750728306852,0.0081029472156709,0.0084243893318292,0.0087391440121243,0.0090469613981976,0.0093475971387000,0.0096408125832416,0.0099263749718302,0.0102040576196394,0.0104736400969384,0.0107349084040810,0.0109876551413728,0.0112316796737089,0.0114667882898392,0.0116927943561408,0.0119095184647688,0.0121167885760701,0.0123144401551576,0.0125023163025124,0.0126802678785417,0.0128481536219595,0.0130058402619303,0.0131532026238562,0.0132901237287449,0.0134164948860673,0.0135322157800438,0.0136371945492695,0.0137313478596397,0.0138146009705010,0.0138868877939819,0.0139481509474543,0.0139983417990846,0.0140374205064397,0.0140653560481117,0.0140821262483495,0.0140877177946527,0.0140821262483484,0.0140653560481114,0.0140374205064394,0.0139983417990852,0.0139481509474546,0.0138868877939823,0.0138146009705013,0.0137313478596400,0.0136371945492697,0.0135322157800433,0.0134164948860677,0.0132901237287448,0.0131532026238565,0.0130058402619301,0.0128481536219600,0.0126802678785414,0.0125023163025123,0.0123144401551574,0.0121167885760703,0.0119095184647684,0.0116927943561413,0.0114667882898392,0.0112316796737092,0.0109876551413726,0.0107349084040808,0.0104736400969386,0.0102040576196384,0.0099263749718300,0.0096408125832409,0.0093475971387000,0.0090469613981973,0.0087391440121236,0.0084243893318295,0.0081029472156708,0.0077750728306857,0.0074410264500604,0.0071010732465589,0.0067554830820802,0.0064045302935173,0.0060484934751079,0.0056876552574861,0.0053223020836440,0.0049527239820869,0.0045792143375388,0.0042020696597343,0.0038215893512344,0.0034380754761467,0.0030518325340562,0.0026631672502581,0.0022723884149075,0.0018798068824524,0.0014857361935228,0.0010904963407160,0.0006944418200526,0.0002984229050294};
static const double pts111[111] = {-0.9997674225091638,-0.9987747658332606,-0.9969897274488894,-0.9944133275105087,-0.9910475625859754,-0.9868950928640002,-0.9819592107788911,-0.9762438329420228,-0.9697534955826924,-0.9624933504647920,-0.9544691606095651,-0.9456872956387844,-0.9361547266791972,-0.9258790208085457,-0.9148683350376861,-0.9031314098290993,-0.8906775621547893,-0.8775166780979684,-0.8636592050038083,-0.8491161431851725,-0.8338990371896997,-0.8180199666350814,-0.8014915366197158,-0.7843268677163213,-0.7665395855564229,-0.7481438100139449,-0.7291541439965075,-0.7095856618532977,-0.6894538974087205,-0.6687748316313179,-0.6475648799477508,-0.6258408792118991,-0.6036200743394411,-0.5809201046184969,-0.5577589897072247,-0.5341551153294688,-0.5101272186798229,-0.4856943735496885,-0.4608759751861402,-0.4356917248956133,-0.4101616144046307,-0.3843059099900057,-0.3581451363910811,-0.3317000605168116,-0.3049916749606032,-0.2780411813359985,-0.2508699734464415,-0.2234996203024741,-0.1959518489998572,-0.1682485274721915,-0.1404116471317482,-0.1124633054122734,-0.0844256882276342,-0.0563210523602260,-0.0281717077931231,0.0000000000000002,0.0281717077931228,0.0563210523602255,0.0844256882276342,0.1124633054122735,0.1404116471317484,0.1682485274721918,0.1959518489998568,0.2234996203024744,0.2508699734464412,0.2780411813359986,0.3049916749606032,0.3317000605168110,0.3581451363910807,0.3843059099900062,0.4101616144046312,0.4356917248956128,0.4608759751861405,0.4856943735496883,0.5101272186798227,0.5341551153294690,0.5577589897072252,0.5809201046184973,0.6036200743394409,0.6258408792118995,0.6475648799477505,0.6687748316313173,0.6894538974087202,0.7095856618532976,0.7291541439965074,0.7481438100139443,0.7665395855564225,0.7843268677163215,0.8014915366197147,0.8180199666350809,0.8338990371896994,0.8491161431851723,0.8636592050038087,0.8775166780979684,0.8906775621547897,0.9031314098290993,0.9148683350376862,0.9258790208085461,0.9361547266791976,0.9456872956387844,0.9544691606095651,0.9624933504647920,0.9697534955826924,0.9762438329420231,0.9819592107788918,0.9868950928640005,0.9910475625859753,0.9944133275105085,0.9969897274488896,0.9987747658332612,0.9997674225091643};

static const double w112[112] = {0.0002931416250620,0.0006821560707879,0.0010712150699985,0.0014594888535438,0.0018466346313439,0.0022323434738323,0.0026163127484529,0.0029982424120462,0.0033778343915512,0.0037547925762040,0.0041288229672711,0.0044996338759112,0.0048669361371601,0.0052304433291310,0.0055898719932230,0.0059449418534963,0.0062953760343115,0.0066409012756911,0.0069812481460881,0.0073161512522818,0.0076453494462005,0.0079685860284757,0.0082856089485534,0.0085961710012021,0.0089000300192465,0.0091969490623887,0.0094866966019498,0.0097690467014060,0.0100437791925534,0.0103106798471885,0.0105695405441521,0.0108201594316112,0.0110623410844583,0.0112958966566932,0.0115206440286768,0.0117364079491498,0.0119430201718762,0.0121403195868447,0.0123281523458928,0.0125063719826722,0.0126748395268631,0.0128334236125326,0.0129820005805739,0.0131204545751306,0.0132486776339372,0.0133665697725048,0.0134740390620852,0.0135710017013572,0.0136573820817675,0.0137331128464922,0.0137981349429557,0.0138523976688825,0.0138958587118296,0.0139284841821815,0.0139502486395777,0.0139611351127482,0.0139611351127481,0.0139502486395778,0.0139284841821817,0.0138958587118296,0.0138523976688826,0.0137981349429564,0.0137331128464921,0.0136573820817680,0.0135710017013576,0.0134740390620855,0.0133665697725046,0.0132486776339371,0.0131204545751306,0.0129820005805743,0.0128334236125330,0.0126748395268628,0.0125063719826724,0.0123281523458920,0.0121403195868446,0.0119430201718763,0.0117364079491500,0.0115206440286777,0.0112958966566928,0.0110623410844580,0.0108201594316118,0.0105695405441516,0.0103106798471883,0.0100437791925534,0.0097690467014057,0.0094866966019498,0.0091969490623882,0.0089000300192467,0.0085961710012013,0.0082856089485532,0.0079685860284756,0.0076453494462004,0.0073161512522816,0.0069812481460881,0.0066409012756917,0.0062953760343113,0.0059449418534967,0.0055898719932223,0.0052304433291316,0.0048669361371600,0.0044996338759112,0.0041288229672711,0.0037547925762044,0.0033778343915511,0.0029982424120467,0.0026163127484526,0.0022323434738326,0.0018466346313436,0.0014594888535437,0.0010712150699991,0.0006821560707877,0.0002931416250623};
static const double pts112[112] = {-0.9997715386597716,-0.9987964464716551,-0.9970429789326634,-0.9945121135269259,-0.9912057759819008,-0.9871265330678494,-0.9822775618509003,-0.9766626418573365,-0.9702861507020548,-0.9631530602011960,-0.9552689323109244,-0.9466399147098046,-0.9372727359664953,-0.9271747002732021,-0.9163536817392874,-0.9048181182450920,-0.8925770048586295,-0.8796398868192198,-0.8660168520929351,-0.8517185235053483,-0.8367560504575278,-0.8211411002316257,-0.8048858488927740,-0.7880029717943317,-0.7705056336938653,-0.7524074784875494,-0.7337226185709798,-0.7144656238346833,-0.6946515103029069,-0.6742957284245360,-0.6534141510252656,-0.6320230609304270,-0.6101391382681104,-0.5877794474624903,-0.5649614239274849,-0.5417028604711382,-0.5180218934213136,-0.4939369884835275,-0.4694669263419373,-0.4446307880147301,-0.4194479399753091,-0.3939380190509034,-0.3681209171103526,-0.3420167655530266,-0.3156459196109638,-0.2890289424764705,-0.2621865892675629,-0.2351397908437466,-0.2079096374847637,-0.1805173624450228,-0.1529843253965485,-0.1253319957733488,-0.0975819360301959,-0.0697557848288723,-0.0418752401649923,-0.0139620424485589,0.0139620424485585,0.0418752401649927,0.0697557848288722,0.0975819360301956,0.1253319957733488,0.1529843253965480,0.1805173624450223,0.2079096374847632,0.2351397908437464,0.2621865892675624,0.2890289424764704,0.3156459196109637,0.3420167655530267,0.3681209171103530,0.3939380190509042,0.4194479399753099,0.4446307880147305,0.4694669263419380,0.4939369884835275,0.5180218934213140,0.5417028604711379,0.5649614239274849,0.5877794474624900,0.6101391382681102,0.6320230609304264,0.6534141510252651,0.6742957284245363,0.6946515103029072,0.7144656238346827,0.7337226185709795,0.7524074784875495,0.7705056336938654,0.7880029717943319,0.8048858488927740,0.8211411002316255,0.8367560504575278,0.8517185235053485,0.8660168520929350,0.8796398868192198,0.8925770048586290,0.9048181182450913,0.9163536817392873,0.9271747002732011,0.9372727359664949,0.9466399147098044,0.9552689323109245,0.9631530602011964,0.9702861507020550,0.9766626418573375,0.9822775618509008,0.9871265330678496,0.9912057759819010,0.9945121135269257,0.9970429789326634,0.9987964464716551,0.9997715386597715};

static const double w113[113] = {0.0002879993074025,0.0006701934487337,0.0010524405244447,0.0014339305416396,0.0018143319208487,0.0021933463187750,0.0025706815403498,0.0029460478881941,0.0033191575462687,0.0036897245643576,0.0040574649973847,0.0044220970921157,0.0047833414897663,0.0051409214338517,0.0054945629791269,0.0058439951998247,0.0061889503963119,0.0065291642996489,0.0068643762737295,0.0071943295147667,0.0075187712478982,0.0078374529207597,0.0081501303938442,0.0084565641274988,0.0087565193654105,0.0090497663144318,0.0093360803206121,0.0096152420412934,0.0098870376131380,0.0101512588159676,0.0104077032322702,0.0106561744022683,0.0108964819744273,0.0111284418512739,0.0113518763304352,0.0115666142407704,0.0117724910735057,0.0119693491082612,0.0121570375338764,0.0123354125639490,0.0125043375469843,0.0126636830710849,0.0128133270630892,0.0129531548820934,0.0130830594072747,0.0132029411199567,0.0133127081798469,0.0134122764953987,0.0135015697882303,0.0135805196515610,0.0136490656026193,0.0137071551289746,0.0137547437287687,0.0137917949448082,0.0138182803924935,0.0138341797815630,0.0138394809316409,0.0138341797815633,0.0138182803924927,0.0137917949448081,0.0137547437287685,0.0137071551289746,0.0136490656026190,0.0135805196515609,0.0135015697882304,0.0134122764953986,0.0133127081798467,0.0132029411199564,0.0130830594072754,0.0129531548820931,0.0128133270630892,0.0126636830710849,0.0125043375469843,0.0123354125639494,0.0121570375338763,0.0119693491082617,0.0117724910735058,0.0115666142407704,0.0113518763304351,0.0111284418512743,0.0108964819744273,0.0106561744022691,0.0104077032322695,0.0101512588159672,0.0098870376131377,0.0096152420412931,0.0093360803206121,0.0090497663144319,0.0087565193654104,0.0084565641274985,0.0081501303938442,0.0078374529207595,0.0075187712478982,0.0071943295147671,0.0068643762737297,0.0065291642996479,0.0061889503963125,0.0058439951998246,0.0054945629791269,0.0051409214338516,0.0047833414897660,0.0044220970921153,0.0040574649973851,0.0036897245643575,0.0033191575462690,0.0029460478881939,0.0025706815403499,0.0021933463187750,0.0018143319208490,0.0014339305416397,0.0010524405244446,0.0006701934487339,0.0002879993074019};
static const double pts113[113] = {-0.9997755464998068,-0.9988175567373460,-0.9970948300197058,-0.9946083031352179,-0.9913598340626494,-0.9873519002126643,-0.9825875682889197,-0.9770704866744155,-0.9708048812371327,-0.9637955516271196,-0.9560478674184156,-0.9475677639163093,-0.9383617375724997,-0.9284368409887626,-0.9178006775034040,-0.9064613953603375,-0.8944276814631561,-0.8817087547179265,-0.8683143589692355,-0.8542547555345771,-0.8395407153426151,-0.8241835106812366,-0.8081949065616553,-0.7915871517051196,-0.7743729691591248,-0.7565655465502857,-0.7381785259813305,-0.7192259935799437,-0.6997224687074635,-0.6796828928356944,-0.6591226181003506,-0.6380573955399020,-0.6165033630288285,-0.5944770329145270,-0.5719952793673418,-0.5490753254534038,-0.5257347299401933,-0.5019913738449193,-0.4778634467360293,-0.4533694327983435,-0.4285280966724858,-0.4033584690794595,-0.3778798322413868,-0.3521117051095644,-0.3260738284111799,-0.2997861495261122,-0.2732688072054259,-0.2465421161432592,-0.2196265514139187,-0.1925427327861106,-0.1653114089263240,-0.1379534415034640,-0.1104897892069200,-0.0829414916903000,-0.0553296534531472,-0.0276754276729732,0.0000000000000001,0.0276754276729732,0.0553296534531474,0.0829414916902997,0.1104897892069195,0.1379534415034636,0.1653114089263237,0.1925427327861112,0.2196265514139191,0.2465421161432596,0.2732688072054262,0.2997861495261123,0.3260738284111809,0.3521117051095652,0.3778798322413872,0.4033584690794600,0.4285280966724854,0.4533694327983427,0.4778634467360296,0.5019913738449197,0.5257347299401942,0.5490753254534041,0.5719952793673418,0.5944770329145270,0.6165033630288287,0.6380573955399025,0.6591226181003509,0.6796828928356944,0.6997224687074636,0.7192259935799427,0.7381785259813303,0.7565655465502859,0.7743729691591249,0.7915871517051197,0.8081949065616555,0.8241835106812366,0.8395407153426147,0.8542547555345772,0.8683143589692357,0.8817087547179259,0.8944276814631558,0.9064613953603371,0.9178006775034032,0.9284368409887620,0.9383617375724993,0.9475677639163094,0.9560478674184151,0.9637955516271193,0.9708048812371323,0.9770704866744155,0.9825875682889197,0.9873519002126639,0.9913598340626496,0.9946083031352178,0.9970948300197050,0.9988175567373456,0.9997755464998069};

static const double w114[114] = {0.0002829911193829,0.0006585427224917,0.0010341551078569,0.0014090373641468,0.0017828686523889,0.0021553607632785,0.0025262314927885,0.0028952010476279,0.0032619914321570,0.0036263264257559,0.0039879317123968,0.0043465350568470,0.0047018664965959,0.0050536585390099,0.0054016463596732,0.0057455680001309,0.0060851645642091,0.0064201804123808,0.0067503633539097,0.0070754648364908,0.0073952401332391,0.0077094485268339,0.0080178534906703,0.0083202228668725,0.0086163290410326,0.0089059491135338,0.0091888650673304,0.0094648639320530,0.0097337379443231,0.0099952847041436,0.0102493073272568,0.0104956145933478,0.0107340210899905,0.0109643473522158,0.0111864199976069,0.0114000718568163,0.0116051420994027,0.0118014763549008,0.0119889268290230,0.0121673524149173,0.0123366187993863,0.0124965985639935,0.0126471712809788,0.0127882236039158,0.0129196493530301,0.0130413495951354,0.0131532327180986,0.0132552144998085,0.0133472181715745,0.0134291744759133,0.0135010217186863,0.0135627058155386,0.0136141803326152,0.0136554065215120,0.0136863533484445,0.0137069975176114,0.0137173234887289,0.0137173234887285,0.0137069975176116,0.0136863533484442,0.0136554065215118,0.0136141803326153,0.0135627058155386,0.0135010217186862,0.0134291744759131,0.0133472181715744,0.0132552144998092,0.0131532327180985,0.0130413495951355,0.0129196493530302,0.0127882236039156,0.0126471712809787,0.0124965985639927,0.0123366187993857,0.0121673524149174,0.0119889268290224,0.0118014763549004,0.0116051420994027,0.0114000718568159,0.0111864199976071,0.0109643473522165,0.0107340210899901,0.0104956145933473,0.0102493073272568,0.0099952847041438,0.0097337379443235,0.0094648639320525,0.0091888650673303,0.0089059491135344,0.0086163290410328,0.0083202228668723,0.0080178534906706,0.0077094485268342,0.0073952401332393,0.0070754648364908,0.0067503633539097,0.0064201804123814,0.0060851645642083,0.0057455680001312,0.0054016463596727,0.0050536585390101,0.0047018664965959,0.0043465350568467,0.0039879317123966,0.0036263264257557,0.0032619914321569,0.0028952010476281,0.0025262314927890,0.0021553607632785,0.0017828686523888,0.0014090373641465,0.0010341551078569,0.0006585427224917,0.0002829911193824};
static const double pts114[114] = {-0.9997794497962007,-0.9988381164620720,-0.9971453293783659,-0.9947019865069586,-0.9915098810095153,-0.9875714047863015,-0.9828895189259460,-0.9774677463037507,-0.9713101675547708,-0.9644214175446323,-0.9568066817025913,-0.9484716920403321,-0.9394227227998883,-0.9296665857114681,-0.9192106248553739,-0.9080627111276355,-0.8962312363114794,-0.8837251067580505,-0.8705537366805783,-0.8567270410667264,-0.8422554282142806,-0.8271497918956753,-0.8114215031572083,-0.7950824017590579,-0.7781447872625289,-0.7606214097712115,-0.7425254603330214,-0.7238705610103277,-0.7046707546256415,-0.6849404941905843,-0.6646946320260816,-0.6439484085819812,-0.6227174409645008,-0.6010177111801444,-0.5788655541049411,-0.5562776451880483,-0.5332709878989925,-0.5098629009279797,-0.4860710051489299,-0.4619132103550238,-0.4374077017767742,-0.4125729263927485,-0.3874275790432586,-0.3619905883574722,-0.3362811025045273,-0.3103184747793948,-0.2841222490343180,-0.2577121449668164,-0.2311080432753111,-0.2043299706935592,-0.1773980849151569,-0.1503326594194549,-0.1231540682103224,-0.0958827704792315,-0.0685392952042210,-0.0411442256963240,-0.0137181841050948,0.0137181841050956,0.0411442256963242,0.0685392952042210,0.0958827704792319,0.1231540682103227,0.1503326594194554,0.1773980849151570,0.2043299706935595,0.2311080432753115,0.2577121449668161,0.2841222490343182,0.3103184747793951,0.3362811025045275,0.3619905883574721,0.3874275790432588,0.4125729263927479,0.4374077017767740,0.4619132103550231,0.4860710051489289,0.5098629009279795,0.5332709878989919,0.5562776451880480,0.5788655541049414,0.6010177111801442,0.6227174409645001,0.6439484085819811,0.6646946320260815,0.6849404941905839,0.7046707546256411,0.7238705610103280,0.7425254603330215,0.7606214097712116,0.7781447872625292,0.7950824017590588,0.8114215031572086,0.8271497918956753,0.8422554282142808,0.8567270410667268,0.8705537366805787,0.8837251067580507,0.8962312363114793,0.9080627111276353,0.9192106248553741,0.9296665857114683,0.9394227227998885,0.9484716920403324,0.9568066817025918,0.9644214175446320,0.9713101675547708,0.9774677463037510,0.9828895189259460,0.9875714047863022,0.9915098810095156,0.9947019865069588,0.9971453293783659,0.9988381164620723,0.9997794497962011};

static const double w115[115] = {0.0002781124365999,0.0006471931443749,0.0010163419810139,0.0013847864535996,0.0017522160172777,0.0021183521674835,0.0024829222674991,0.0028456560088304,0.0032062848016874,0.0035645417457853,0.0039201617507928,0.0042728817026697,0.0046224406455393,0.0049685799687812,0.0053110435953794,0.0056495781697936,0.0059839332445180,0.0063138614648588,0.0066391187516260,0.0069594644815085,0.0072746616649762,0.0075844771215190,0.0078886816521041,0.0081870502086976,0.0084793620607349,0.0087654009583908,0.0090449552925514,0.0093178182513531,0.0095837879731706,0.0098426676959484,0.0100942659027625,0.0103383964634967,0.0105748787725393,0.0108035378823941,0.0110242046330983,0.0112367157773746,0.0114409141013846,0.0116366485410457,0.0118237742937840,0.0120021529256532,0.0121716524737511,0.0123321475438400,0.0124835194031178,0.0126256560680502,0.0127584523872156,0.0128818101190982,0.0129956380047642,0.0130998518353708,0.0131943745144706,0.0132791361150401,0.0133540739312141,0.0134191325246745,0.0134742637656617,0.0135194268685842,0.0135545884221859,0.0135797224142679,0.0135948102509307,0.0135998407703293,0.0135948102509309,0.0135797224142676,0.0135545884221855,0.0135194268685843,0.0134742637656620,0.0134191325246740,0.0133540739312146,0.0132791361150401,0.0131943745144709,0.0130998518353709,0.0129956380047635,0.0128818101190984,0.0127584523872158,0.0126256560680502,0.0124835194031174,0.0123321475438398,0.0121716524737507,0.0120021529256534,0.0118237742937842,0.0116366485410460,0.0114409141013840,0.0112367157773747,0.0110242046330994,0.0108035378823936,0.0105748787725392,0.0103383964634958,0.0100942659027622,0.0098426676959483,0.0095837879731706,0.0093178182513531,0.0090449552925515,0.0087654009583903,0.0084793620607351,0.0081870502086982,0.0078886816521033,0.0075844771215192,0.0072746616649766,0.0069594644815086,0.0066391187516260,0.0063138614648599,0.0059839332445179,0.0056495781697935,0.0053110435953794,0.0049685799687809,0.0046224406455394,0.0042728817026704,0.0039201617507929,0.0035645417457851,0.0032062848016874,0.0028456560088305,0.0024829222674990,0.0021183521674836,0.0017522160172774,0.0013847864535996,0.0010163419810137,0.0006471931443745,0.0002781124365999};
static const double pts115[115] = {-0.9997832521535361,-0.9988581446231311,-0.9971945235813190,-0.9947932499340714,-0.9916560548070077,-0.9877852482420589,-0.9831836902174098,-0.9778547834482728,-0.9718024695183064,-0.9650312255141514,-0.9575460605384420,-0.9493525119276813,-0.9404566411192155,-0.9308650291482468,-0.9205847717689997,-0.9096234741994791,-0.8979892454916870,-0.8856906925304575,-0.8727369136647709,-0.8591374919759684,-0.8449024881876656,-0.8300424332224983,-0.8145683204111470,-0.7984915973593626,-0.7818241574789745,-0.7645783311891459,-0.7467668767943566,-0.7284029710458609,-0.7095001993936011,-0.6900725459357748,-0.6701343830735006,-0.6497004608782229,-0.6287858961797226,-0.6074061613828147,-0.5855770730209851,-0.5633147800554592,-0.5406357519283371,-0.5175567663786445,-0.4940948970303067,-0.4702675007612348,-0.4460922048628584,-0.4215868939996142,-0.3967696969780343,-0.3716589733352115,-0.3462732997565797,-0.3206314563330528,-0.2947524126676799,-0.2686553138421034,-0.2423594662532025,-0.2158843233303917,-0.1892494711441537,-0.1624746139164379,-0.1355795594436567,-0.1085842044430554,-0.0815085198333049,-0.0543725359601911,-0.0271963277783511,0.0000000000000006,0.0271963277783517,0.0543725359601915,0.0815085198333053,0.1085842044430559,0.1355795594436565,0.1624746139164380,0.1892494711441539,0.2158843233303916,0.2423594662532016,0.2686553138421027,0.2947524126676790,0.3206314563330526,0.3462732997565797,0.3716589733352114,0.3967696969780352,0.4215868939996146,0.4460922048628577,0.4702675007612345,0.4940948970303068,0.5175567663786445,0.5406357519283371,0.5633147800554590,0.5855770730209847,0.6074061613828147,0.6287858961797228,0.6497004608782226,0.6701343830735008,0.6900725459357745,0.7095001993936010,0.7284029710458615,0.7467668767943568,0.7645783311891463,0.7818241574789742,0.7984915973593624,0.8145683204111476,0.8300424332224984,0.8449024881876656,0.8591374919759683,0.8727369136647707,0.8856906925304575,0.8979892454916875,0.9096234741994793,0.9205847717690001,0.9308650291482462,0.9404566411192151,0.9493525119276808,0.9575460605384420,0.9650312255141515,0.9718024695183062,0.9778547834482727,0.9831836902174094,0.9877852482420588,0.9916560548070085,0.9947932499340716,0.9971945235813188,0.9988581446231312,0.9997832521535361};

static const double w116[116] = {0.0002733588322357,0.0006361344256276,0.0009989850229381,0.0013611559163242,0.0017223464310134,0.0020822873595948,0.0024407152303009,0.0027973688212417,0.0031519885547067,0.0035043164619168,0.0038540962949195,0.0042010736836531,0.0045449963083563,0.0048856140771797,0.0052226793051240,0.0055559468925937,0.0058851745027672,0.0062101227373188,0.0065305553101954,0.0068462392192560,0.0071569449155742,0.0074624464702849,0.0077625217388126,0.0080569525223736,0.0083455247266092,0.0086280285172519,0.0089042584726909,0.0091740137333358,0.0094370981476661,0.0096933204148537,0.0099424942238679,0.0101844383889417,0.0104189769813265,0.0106459394572083,0.0108651607817223,0.0110764815489535,0.0112797480978499,0.0114748126239525,0.0116615332868718,0.0118397743134283,0.0120094060963757,0.0121703052886461,0.0123223548930394,0.0124654443472997,0.0125994696045071,0.0127243332087379,0.0128399443659262,0.0129462190098875,0.0130430798634435,0.0131304564946169,0.0132082853678435,0.0132765098901729,0.0133350804524220,0.0133839544652416,0.0134230963900923,0.0134524777650814,0.0134720772256623,0.0134818805201646,0.0134818805201651,0.0134720772256617,0.0134524777650816,0.0134230963900923,0.0133839544652422,0.0133350804524216,0.0132765098901729,0.0132082853678425,0.0131304564946163,0.0130430798634434,0.0129462190098875,0.0128399443659265,0.0127243332087378,0.0125994696045070,0.0124654443472998,0.0123223548930398,0.0121703052886459,0.0120094060963758,0.0118397743134287,0.0116615332868720,0.0114748126239525,0.0112797480978504,0.0110764815489543,0.0108651607817222,0.0106459394572084,0.0104189769813267,0.0101844383889420,0.0099424942238676,0.0096933204148535,0.0094370981476665,0.0091740137333359,0.0089042584726907,0.0086280285172517,0.0083455247266088,0.0080569525223730,0.0077625217388125,0.0074624464702845,0.0071569449155740,0.0068462392192561,0.0065305553101957,0.0062101227373186,0.0058851745027676,0.0055559468925935,0.0052226793051239,0.0048856140771799,0.0045449963083560,0.0042010736836532,0.0038540962949193,0.0035043164619169,0.0031519885547064,0.0027973688212418,0.0024407152303005,0.0020822873595955,0.0017223464310131,0.0013611559163243,0.0009989850229380,0.0006361344256276,0.0002733588322360};
static const double pts116[116] = {-0.9997869570223721,-0.9988776593871703,-0.9972424572129094,-0.9948821760273694,-0.9917984875595769,-0.9879936234597294,-0.9834703468716658,-0.9782319454271527,-0.9722822275271324,-0.9656255191306380,-0.9582666604372997,-0.9502110022926898,-0.9414644022615467,-0.9320332203500056,-0.9219243143708712,-0.9111450349512257,-0.8997032201839995,-0.8876071899264050,-0.8748657397488234,-0.8614881345382452,-0.8474841017607472,-0.8328638243877892,-0.8176379334914208,-0.8018175005137332,-0.7854140292161539,-0.7684394473144264,-0.7509060978053358,-0.7328267299914915,-0.7142144902106712,-0.6950829122764826,-0.6754459076372759,-0.6553177552604706,-0.6347130912496437,-0.6136468982019323,-0.5921344943134885,-0.5701915222409064,-0.5478339377267210,-0.5250779979972486,-0.5019402499412060,-0.4784375180777022,-0.4545868923223594,-0.4304057155604381,-0.4059115710360368,-0.3811222695665004,-0.3560558365913530,-0.3307304990651771,-0.3051646722039509,-0.2793769460945024,-0.2533860721767991,-0.2272109496089168,-0.2008706115245907,-0.1743842111933505,-0.1477710080932955,-0.1210503539066472,-0.0942416784482477,-0.0673644755372514,-0.0404382888222716,-0.0134826975702964,0.0134826975702968,0.0404382888222726,0.0673644755372522,0.0942416784482484,0.1210503539066472,0.1477710080932958,0.1743842111933505,0.2008706115245912,0.2272109496089173,0.2533860721767996,0.2793769460945022,0.3051646722039510,0.3307304990651767,0.3560558365913536,0.3811222695665000,0.4059115710360371,0.4304057155604379,0.4545868923223585,0.4784375180777024,0.5019402499412057,0.5250779979972485,0.5478339377267212,0.5701915222409059,0.5921344943134881,0.6136468982019321,0.6347130912496437,0.6553177552604706,0.6754459076372757,0.6950829122764824,0.7142144902106706,0.7328267299914919,0.7509060978053360,0.7684394473144264,0.7854140292161537,0.8018175005137335,0.8176379334914212,0.8328638243877895,0.8474841017607470,0.8614881345382449,0.8748657397488233,0.8876071899264053,0.8997032201839993,0.9111450349512252,0.9219243143708709,0.9320332203500048,0.9414644022615458,0.9502110022926895,0.9582666604372995,0.9656255191306372,0.9722822275271321,0.9782319454271523,0.9834703468716655,0.9879936234597295,0.9917984875595769,0.9948821760273693,0.9972424572129091,0.9988776593871704,0.9997869570223719};

static const double w117[117] = {0.0002687260670135,0.0006253567131125,0.0009820687944563,0.0013381247831275,0.0016932334714345,0.0020471345619478,0.0023995733656113,0.0027502973688161,0.0030990556317413,0.0034455987475348,0.0037896789461930,0.0041310502429060,0.0044694686015455,0.0048046921033528,0.0051364811169960,0.0054645984683440,0.0057888096091644,0.0061088827843000,0.0064245891970375,0.0067357031724807,0.0070420023187546,0.0073432676858982,0.0076392839223283,0.0079298394287449,0.0082147265093617,0.0084937415203546,0.0087666850154252,0.0090333618883509,0.0092935815124577,0.0095471578768678,0.0097939097194695,0.0100336606564794,0.0102662393085276,0.0104914794231586,0.0107092199936747,0.0109193053742210,0.0111215853910499,0.0113159154498636,0.0115021566391748,0.0116801758296021,0.0118498457690366,0.0120110451736007,0.0121636588143449,0.0123075775996190,0.0124426986530484,0.0125689253870764,0.0126861675720054,0.0127943414004948,0.0128933695474673,0.0129831812253862,0.0130637122348514,0.0131349050104937,0.0131967086621223,0.0132490790111031,0.0132919786219367,0.0133253768290217,0.0133492497585707,0.0133635803456790,0.0133683583465231,0.0133635803456789,0.0133492497585702,0.0133253768290214,0.0132919786219366,0.0132490790111032,0.0131967086621220,0.0131349050104939,0.0130637122348516,0.0129831812253857,0.0128933695474673,0.0127943414004944,0.0126861675720055,0.0125689253870765,0.0124426986530488,0.0123075775996191,0.0121636588143456,0.0120110451736006,0.0118498457690366,0.0116801758296024,0.0115021566391744,0.0113159154498635,0.0111215853910501,0.0109193053742211,0.0107092199936743,0.0104914794231586,0.0102662393085279,0.0100336606564795,0.0097939097194695,0.0095471578768684,0.0092935815124577,0.0090333618883512,0.0087666850154243,0.0084937415203545,0.0082147265093612,0.0079298394287454,0.0076392839223279,0.0073432676858982,0.0070420023187539,0.0067357031724813,0.0064245891970375,0.0061088827843000,0.0057888096091652,0.0054645984683439,0.0051364811169957,0.0048046921033527,0.0044694686015450,0.0041310502429062,0.0037896789461932,0.0034455987475343,0.0030990556317416,0.0027502973688160,0.0023995733656111,0.0020471345619479,0.0016932334714347,0.0013381247831273,0.0009820687944563,0.0006253567131126,0.0002687260670137};
static const double pts117[117] = {-0.9997905677070756,-0.9988966781513899,-0.9972891729701391,-0.9949688439033463,-0.9919373057896212,-0.9881967151794649,-0.9837497424433748,-0.9785995649512292,-0.9727498634953962,-0.9662048192252962,-0.9589691104896512,-0.9510479094184467,-0.9424468781904594,-0.9331721649676527,-0.9232303994904323,-0.9126286883328898,-0.9013746098194813,-0.8894762086057700,-0.8769419899265924,-0.8637809135154452,-0.8500023871992755,-0.8356162601731513,-0.8206328159595501,-0.8050627650572654,-0.7889172372851545,-0.7722077738261880,-0.7549463189774718,-0.7371452116121389,-0.7188171763591956,-0.6999753145076423,-0.6806330946413466,-0.6608043430113776,-0.6405032336526784,-0.6197442782521281,-0.5985423157752598,-0.5769125018590213,-0.5548702979781858,-0.5324314603931278,-0.5096120288869020,-0.4864283152996356,-0.4628968918684596,-0.4390345793813013,-0.4148584351530000,-0.3903857408323637,-0.3656339900488507,-0.3406208759077350,-0.3153642783426750,-0.2898822513347356,-0.2641930100069983,-0.2383149176039843,-0.2122664723651919,-0.1860662943021439,-0.1597331118883849,-0.1332857486719471,-0.1067431098198590,-0.0801241686043078,-0.0534479528401181,-0.0267335312832452,-0.0000000000000003,0.0267335312832449,0.0534479528401184,0.0801241686043079,0.1067431098198597,0.1332857486719470,0.1597331118883850,0.1860662943021444,0.2122664723651923,0.2383149176039847,0.2641930100069990,0.2898822513347358,0.3153642783426753,0.3406208759077355,0.3656339900488508,0.3903857408323637,0.4148584351529996,0.4390345793813009,0.4628968918684598,0.4864283152996355,0.5096120288869019,0.5324314603931276,0.5548702979781853,0.5769125018590214,0.5985423157752600,0.6197442782521279,0.6405032336526785,0.6608043430113782,0.6806330946413465,0.6999753145076424,0.7188171763591955,0.7371452116121383,0.7549463189774719,0.7722077738261879,0.7889172372851548,0.8050627650572655,0.8206328159595503,0.8356162601731510,0.8500023871992756,0.8637809135154449,0.8769419899265919,0.8894762086057696,0.9013746098194810,0.9126286883328902,0.9232303994904322,0.9331721649676530,0.9424468781904596,0.9510479094184469,0.9589691104896513,0.9662048192252966,0.9727498634953963,0.9785995649512291,0.9837497424433747,0.9881967151794647,0.9919373057896207,0.9949688439033462,0.9972891729701382,0.9988966781513891,0.9997905677070754};

static const double w118[118] = {0.0002642100797451,0.0006148505673662,0.0009655785038942,0.0013156729628675,0.0016648518204998,0.0020128633213804,0.0023594611959024,0.0027044012791326,0.0030474409134046,0.0033883389023681,0.0037268556073559,0.0040627530875174,0.0043957952549094,0.0047257480347660,0.0050523795271746,0.0053754601685796,0.0056947628922790,0.0060100632875456,0.0063211397570514,0.0066277736724342,0.0069297495278395,0.0072268550913077,0.0075188815538831,0.0078056236763360,0.0080868799333787,0.0083624526552919,0.0086321481668307,0.0088957769233342,0.0091531536439358,0.0094040974417735,0.0096484319511168,0.0098859854513156,0.0101165909874831,0.0103400864878343,0.0105563148775919,0.0107651241893723,0.0109663676699972,0.0111599038836273,0.0113455968111639,0.0115233159458494,0.0116929363849835,0.0118543389177055,0.0120074101087806,0.0121520423783190,0.0122881340773871,0.0124155895594441,0.0125343192475674,0.0126442396974028,0.0127452736558144,0.0128373501151768,0.0129204043632793,0.0129943780288085,0.0130592191223696,0.0131148820730259,0.0131613277603277,0.0131985235418049,0.0132264432759100,0.0132450673403871,0.0132543826460691,0.0132543826460689,0.0132450673403873,0.0132264432759099,0.0131985235418051,0.0131613277603273,0.0131148820730259,0.0130592191223692,0.0129943780288084,0.0129204043632797,0.0128373501151765,0.0127452736558146,0.0126442396974026,0.0125343192475672,0.0124155895594445,0.0122881340773867,0.0121520423783192,0.0120074101087807,0.0118543389177053,0.0116929363849836,0.0115233159458498,0.0113455968111640,0.0111599038836267,0.0109663676699969,0.0107651241893724,0.0105563148775912,0.0103400864878346,0.0101165909874833,0.0098859854513157,0.0096484319511168,0.0094040974417736,0.0091531536439351,0.0088957769233347,0.0086321481668310,0.0083624526552921,0.0080868799333789,0.0078056236763350,0.0075188815538833,0.0072268550913082,0.0069297495278397,0.0066277736724344,0.0063211397570514,0.0060100632875456,0.0056947628922793,0.0053754601685796,0.0050523795271749,0.0047257480347652,0.0043957952549095,0.0040627530875170,0.0037268556073568,0.0033883389023679,0.0030474409134040,0.0027044012791326,0.0023594611959030,0.0020128633213798,0.0016648518204994,0.0013156729628679,0.0009655785038948,0.0006148505673666,0.0002642100797450};
static const double pts118[118] = {-0.9997940873731902,-0.9989152175823158,-0.9973347117577214,-0.9950533293600030,-0.9920726307180311,-0.9883947004102458,-0.9840221198922338,-0.9789579608532745,-0.9732057817738542,-0.9667696249977148,-0.9596540137247274,-0.9518639487593397,-0.9434049049612392,-0.9342828273797233,-0.9245041270657300,-0.9140756765605161,-0.9030048050622420,-0.8912992932728807,-0.8789673679285492,-0.8660176960168177,-0.8524593786848891,-0.8383019448428241,-0.8235553444662542,-0.8082299416032453,-0.7923365070902041,-0.7758862109819237,-0.7588906147010843,-0.7413616629127173,-0.7233116751293350,-0.7047533370526275,-0.6856996916578028,-0.6661641300268377,-0.6461603819370845,-0.6257025062118369,-0.6048048808396498,-0.5834821928693357,-0.5617494280877698,-0.5396218604877254,-0.5171150415331633,-0.4942447892295148,-0.4710271770066288,-0.4474785224222136,-0.4236153756937008,-0.3994545080665921,-0.3750129000274695,-0.3503077293699431,-0.3253563591219394,-0.3001763253427935,-0.2747853247987447,-0.2492012025254787,-0.2234419392864652,-0.1975256389359092,-0.1714705156951880,-0.1452948813517242,-0.1190171323892882,-0.0926557370587736,-0.0662292223985355,-0.0397561612134106,-0.0132551590215784,0.0132551590215783,0.0397561612134106,0.0662292223985347,0.0926557370587732,0.1190171323892884,0.1452948813517242,0.1714705156951878,0.1975256389359094,0.2234419392864657,0.2492012025254789,0.2747853247987452,0.3001763253427938,0.3253563591219396,0.3503077293699436,0.3750129000274696,0.3994545080665924,0.4236153756937006,0.4474785224222133,0.4710271770066283,0.4942447892295148,0.5171150415331638,0.5396218604877244,0.5617494280877692,0.5834821928693349,0.6048048808396489,0.6257025062118375,0.6461603819370846,0.6661641300268377,0.6856996916578028,0.7047533370526279,0.7233116751293351,0.7413616629127174,0.7588906147010842,0.7758862109819237,0.7923365070902044,0.8082299416032452,0.8235553444662540,0.8383019448428244,0.8524593786848896,0.8660176960168183,0.8789673679285490,0.8912992932728807,0.9030048050622421,0.9140756765605157,0.9245041270657299,0.9342828273797229,0.9434049049612395,0.9518639487593396,0.9596540137247276,0.9667696249977148,0.9732057817738540,0.9789579608532738,0.9840221198922334,0.9883947004102458,0.9920726307180309,0.9950533293600028,0.9973347117577215,0.9989152175823165,0.9997940873731901};

static const double w119[119] = {0.0002598069784249,0.0006046069419334,0.0009494999747785,0.0012937811987285,0.0016371772094209,0.0019794444436242,0.0023203447057894,0.0026596418377041,0.0029971011255285,0.0033324892491122,0.0036655743713197,0.0039961262704347,0.0043239164873324,0.0046487184778079,0.0049703077663529,0.0052884620998321,0.0056029616002653,0.0059135889163121,0.0062201293732080,0.0065223711209481,0.0068201052805844,0.0071131260885147,0.0074012310386328,0.0076842210222497,0.0079619004656745,0.0082340774653590,0.0085005639205080,0.0087611756630723,0.0090157325850160,0.0092640587627856,0.0095059825788880,0.0097413368404898,0.0099699588949665,0.0101916907423036,0.0104063791442930,0.0106138757304346,0.0108140371004711,0.0110067249234940,0.0111918060335406,0.0113691525216260,0.0115386418241401,0.0117001568075505,0.0118535858493516,0.0119988229152090,0.0121357676322361,0.0122643253583657,0.0123844072477515,0.0124959303121753,0.0125988174783922,0.0126929976414032,0.0127784057135908,0.0128549826697025,0.0129226755876430,0.0129814376850461,0.0130312283516122,0.0130720131771653,0.0131037639754398,0.0131264588035579,0.0131400819771956,0.0131446240814197,0.0131400819771955,0.0131264588035582,0.0131037639754401,0.0130720131771646,0.0130312283516118,0.0129814376850464,0.0129226755876428,0.0128549826697028,0.0127784057135912,0.0126929976414032,0.0125988174783921,0.0124959303121751,0.0123844072477520,0.0122643253583656,0.0121357676322358,0.0119988229152088,0.0118535858493517,0.0117001568075505,0.0115386418241407,0.0113691525216259,0.0111918060335403,0.0110067249234938,0.0108140371004712,0.0106138757304344,0.0104063791442934,0.0101916907423032,0.0099699588949664,0.0097413368404899,0.0095059825788875,0.0092640587627857,0.0090157325850161,0.0087611756630723,0.0085005639205083,0.0082340774653587,0.0079619004656748,0.0076842210222493,0.0074012310386329,0.0071131260885143,0.0068201052805842,0.0065223711209479,0.0062201293732083,0.0059135889163121,0.0056029616002649,0.0052884620998319,0.0049703077663532,0.0046487184778079,0.0043239164873325,0.0039961262704342,0.0036655743713199,0.0033324892491129,0.0029971011255286,0.0026596418377047,0.0023203447057889,0.0019794444436242,0.0016371772094206,0.0012937811987284,0.0009494999747786,0.0006046069419334,0.0002598069784249};
static const double pts119[119] = {-0.9997975190543789,-0.9989332936523240,-0.9973791127775998,-0.9951357050424426,-0.9922045785284273,-0.9885877488146595,-0.9842877121093537,-0.9793074387760656,-0.9736503700186114,-0.9673204150829744,-0.9603219483922782,-0.9526598064522477,-0.9443392844745692,-0.9353661326998371,-0.9257465524140127,-0.9154871916572539,-0.9045951406261999,-0.8930779267719352,-0.8809435095964960,-0.8682002751512353,-0.8548570302406762,-0.8409229963357634,-0.8264078032006630,-0.8113214822374618,-0.7956744595533572,-0.7794775487551026,-0.7627419434756804,-0.7454792096383570,-0.7277012774634676,-0.7094204332234404,-0.6906493107517699,-0.6714008827117911,-0.6516884516312937,-0.6315256407091778,-0.6109263844004912,-0.5899049187863635,-0.5684757717354845,-0.5466537528639400,-0.5244539433003244,-0.5018916852632153,-0.4789825714582129,-0.4557424343018673,-0.4321873349799421,-0.4083335523475775,-0.3841975716790214,-0.3597960732747127,-0.3351459209335683,-0.3102641502984689,-0.2851679570829773,-0.2598746851874347,-0.2344018147126442,-0.2087669498794263,-0.1829878068623984,-0.1570822015463815,-0.1310680372138958,-0.1049632921722619,-0.0787860073288415,-0.0525542737230310,-0.0262862200235944,-0.0000000000000002,0.0262862200235942,0.0525542737230312,0.0787860073288412,0.1049632921722612,0.1310680372138962,0.1570822015463813,0.1829878068623982,0.2087669498794261,0.2344018147126440,0.2598746851874349,0.2851679570829777,0.3102641502984689,0.3351459209335688,0.3597960732747132,0.3841975716790220,0.4083335523475771,0.4321873349799416,0.4557424343018670,0.4789825714582126,0.5018916852632147,0.5244539433003246,0.5466537528639400,0.5684757717354844,0.5899049187863632,0.6109263844004919,0.6315256407091784,0.6516884516312934,0.6714008827117908,0.6906493107517705,0.7094204332234402,0.7277012774634677,0.7454792096383569,0.7627419434756805,0.7794775487551030,0.7956744595533571,0.8113214822374619,0.8264078032006624,0.8409229963357638,0.8548570302406759,0.8682002751512354,0.8809435095964966,0.8930779267719350,0.9045951406262001,0.9154871916572540,0.9257465524140133,0.9353661326998369,0.9443392844745687,0.9526598064522471,0.9603219483922780,0.9673204150829738,0.9736503700186121,0.9793074387760656,0.9842877121093537,0.9885877488146593,0.9922045785284275,0.9951357050424425,0.9973791127776004,0.9989332936523246,0.9997975190543789};

static const double w120[120] = {0.0002555130318471,0.0005946171638967,0.0009338196153860,0.0012724310270052,0.0016101863669629,0.0019468499314504,0.0022821912704410,0.0026159819071482,0.0029479947496417,0.0032780040358364,0.0036057854161894,0.0039311160788452,0.0042537748893258,0.0045735425353691,0.0048902016732485,0.0052035370740625,0.0055133357692144,0.0058193871947018,0.0061214833339584,0.0064194188590619,0.0067129912701870,0.0070020010331650,0.0072862517150560,0.0075655501176291,0.0078397064086533,0.0081085342509000,0.0083718509287886,0.0086294774725607,0.0088812387799167,0.0091269637350242,0.0093664853248185,0.0095996407525131,0.0098262715482477,0.0100462236767945,0.0102593476422518,0.0104654985896502,0.0106645364034057,0.0108563258025549,0.0110407364327002,0.0112176429546061,0.0113869251293900,0.0115484679002493,0.0117021614706554,0.0118479013789827,0.0119855885695126,0.0121151294597506,0.0122364360040377,0.0123494257533930,0.0124540219115474,0.0125501533871466,0.0126377548420628,0.0127167667358095,0.0127871353660068,0.0128488129048821,0.0129017574317746,0.0129459329616342,0.0129813094694734,0.0130078629107767,0.0130255752378435,0.0130344344120552,0.0130344344120551,0.0130255752378434,0.0130078629107764,0.0129813094694732,0.0129459329616340,0.0129017574317748,0.0128488129048815,0.0127871353660070,0.0127167667358094,0.0126377548420621,0.0125501533871466,0.0124540219115478,0.0123494257533931,0.0122364360040377,0.0121151294597505,0.0119855885695127,0.0118479013789833,0.0117021614706549,0.0115484679002494,0.0113869251293902,0.0112176429546060,0.0110407364326996,0.0108563258025555,0.0106645364034057,0.0104654985896498,0.0102593476422523,0.0100462236767943,0.0098262715482481,0.0095996407525131,0.0093664853248185,0.0091269637350243,0.0088812387799165,0.0086294774725608,0.0083718509287889,0.0081085342509000,0.0078397064086534,0.0075655501176297,0.0072862517150559,0.0070020010331647,0.0067129912701867,0.0064194188590617,0.0061214833339582,0.0058193871947016,0.0055133357692144,0.0052035370740628,0.0048902016732483,0.0045735425353687,0.0042537748893262,0.0039311160788448,0.0036057854161902,0.0032780040358357,0.0029479947496421,0.0026159819071481,0.0022821912704411,0.0019468499314503,0.0016101863669632,0.0012724310270053,0.0009338196153858,0.0005946171638969,0.0002555130318474};
static const double pts120[120] = {-0.9998008656589593,-0.9989509216740351,-0.9974224136132905,-0.9952160405989076,-0.9923332606161664,-0.9887760230715262,-0.9845467424134113,-0.9796482918210424,-0.9740840000102284,-0.9678576485579723,-0.9609734691715827,-0.9534361407422755,-0.9452507861314761,-0.9364229686716756,-0.9269586883757739,-0.9168643778536238,-0.9061468979367375,-0.8948135330131572,-0.8828719860751703,-0.8703303734829441,-0.8571972194474832,-0.8434814502365490,-0.8291923881074365,-0.8143397449706763,-0.7989336157889582,-0.7829844717157362,-0.7665031529781775,-0.7495008615092769,-0.7319891533341408,-0.7139799307156215,-0.6954854340646220,-0.6765182336205763,-0.6570912209077653,-0.6372175999732600,-0.6169108784124538,-0.5961848581882868,-0.5750536262503931,-0.5535315449605562,-0.5316332423309660,-0.5093736020819324,-0.4867677535257895,-0.4638310612838927,-0.4405791148436580,-0.4170277179627974,-0.3931928779278952,-0.3690907946746596,-0.3447378497772405,-0.3201505953140886,-0.2953457426179222,-0.2703401509174619,-0.2451508158786386,-0.2197948580530699,-0.1942895112416572,-0.1686521107812039,-0.1429000817620318,-0.1170509271845843,-0.0911222160630848,-0.0651315714843212,-0.0390966586296818,-0.0130351727685786,0.0130351727685787,0.0390966586296824,0.0651315714843214,0.0911222160630848,0.1170509271845841,0.1429000817620315,0.1686521107812039,0.1942895112416574,0.2197948580530706,0.2451508158786390,0.2703401509174624,0.2953457426179226,0.3201505953140888,0.3447378497772413,0.3690907946746595,0.3931928779278947,0.4170277179627984,0.4405791148436586,0.4638310612838921,0.4867677535257903,0.5093736020819317,0.5316332423309662,0.5535315449605562,0.5750536262503937,0.5961848581882865,0.6169108784124538,0.6372175999732602,0.6570912209077657,0.6765182336205763,0.6954854340646218,0.7139799307156217,0.7319891533341412,0.7495008615092764,0.7665031529781769,0.7829844717157365,0.7989336157889577,0.8143397449706760,0.8291923881074365,0.8434814502365486,0.8571972194474827,0.8703303734829442,0.8828719860751699,0.8948135330131572,0.9061468979367371,0.9168643778536237,0.9269586883757734,0.9364229686716758,0.9452507861314757,0.9534361407422758,0.9609734691715829,0.9678576485579723,0.9740840000102280,0.9796482918210417,0.9845467424134100,0.9887760230715263,0.9923332606161664,0.9952160405989080,0.9974224136132904,0.9989509216740345,0.9998008656589588};

static const double w121[121] = {0.0002513246616968,0.0005848729155219,0.0009185243900512,0.0012516047382497,0.0015838569706817,0.0019150529263246,0.0022449695880470,0.0025733858509002,0.0029000819384581,0.0032248393438126,0.0035474409060761,0.0038676709286616,0.0041853153119330,0.0045001616909607,0.0048119995748029,0.0051206204858129,0.0054258180982220,0.0057273883756236,0.0060251297071074,0.0063188430418719,0.0066083320221950,0.0068934031146303,0.0071738657393494,0.0074495323975184,0.0077202187966224,0.0079857439736613,0.0082459304161146,0.0085006041806063,0.0087495950091903,0.0089927364431649,0.0092298659343551,0.0094608249537770,0.0096854590976211,0.0099036181904718,0.0101151563857054,0.0103199322629919,0.0105178089228364,0.0107086540781074,0.0108923401424651,0.0110687443156632,0.0112377486656442,0.0113992402073775,0.0115531109783968,0.0116992581109740,0.0118375839008918,0.0119679958727598,0.0120904068418389,0.0122047349723273,0.0123109038320681,0.0124088424436498,0.0124984853318543,0.0125797725674319,0.0126526498071636,0.0127170683301918,0.0127729850705929,0.0128203626461673,0.0128591693834321,0.0128893793387915,0.0129109723158888,0.0129239338790992,0.0129282553631888,0.0129239338791000,0.0129109723158886,0.0128893793387919,0.0128591693834320,0.0128203626461677,0.0127729850705929,0.0127170683301918,0.0126526498071634,0.0125797725674319,0.0124984853318542,0.0124088424436495,0.0123109038320677,0.0122047349723277,0.0120904068418394,0.0119679958727597,0.0118375839008916,0.0116992581109743,0.0115531109783967,0.0113992402073771,0.0112377486656436,0.0110687443156636,0.0108923401424651,0.0107086540781076,0.0105178089228366,0.0103199322629912,0.0101151563857057,0.0099036181904721,0.0096854590976208,0.0094608249537770,0.0092298659343551,0.0089927364431646,0.0087495950091907,0.0085006041806067,0.0082459304161143,0.0079857439736616,0.0077202187966225,0.0074495323975178,0.0071738657393497,0.0068934031146298,0.0066083320221949,0.0063188430418725,0.0060251297071074,0.0057273883756236,0.0054258180982217,0.0051206204858129,0.0048119995748029,0.0045001616909600,0.0041853153119332,0.0038676709286620,0.0035474409060765,0.0032248393438123,0.0029000819384581,0.0025733858509001,0.0022449695880470,0.0019150529263245,0.0015838569706817,0.0012516047382493,0.0009185243900512,0.0005848729155220,0.0002513246616970};
static const double pts121[121] = {-0.9998041299760687,-0.9989681163327500,-0.9974646503093888,-0.9952944028278836,-0.9924587838231073,-0.9889596792178339,-0.9847994250185207,-0.9799808011600819,-0.9745070284263807,-0.9683817658908714,-0.9616091083123655,-0.9541935833284941,-0.9461401483958065,-0.9374541874585690,-0.9281415073401638,-0.9182083338557355,-0.9076613076468585,-0.8965074797400899,-0.8847543068318718,-0.8724096463026579,-0.8594817509634447,-0.8459792635381110,-0.8319112108852067,-0.8172869979630039,-0.8021164015418381,-0.7864095636679076,-0.7701769848829034,-0.7534295172039958,-0.7361783568688514,-0.7184350368505475,-0.7002114191473702,-0.6815196868526509,-0.6623723360099520,-0.6427821672590317,-0.6227622772781793,-0.6023260500286455,-0.5814871478070127,-0.5602595021114855,-0.5386573043282246,-0.5166949962439226,-0.4943872603909920,-0.4717490102317989,-0.4487953801885173,-0.4255417155252606,-0.4020035620892671,-0.3781966559179730,-0.3541369127189610,-0.3298404172297683,-0.3053234124647098,-0.2806022888558830,-0.2556935732956154,-0.2306139180876929,-0.2053800898147352,-0.1800089581291829,-0.1545174844753686,-0.1289227107502330,-0.1032417479102464,-0.0774917645321686,-0.0516899753352810,-0.0258536296727786,-0.0000000000000007,0.0258536296727775,0.0516899753352804,0.0774917645321678,0.1032417479102460,0.1289227107502322,0.1545174844753683,0.1800089581291822,0.2053800898147353,0.2306139180876924,0.2556935732956151,0.2806022888558821,0.3053234124647093,0.3298404172297680,0.3541369127189610,0.3781966559179733,0.4020035620892662,0.4255417155252615,0.4487953801885173,0.4717490102317995,0.4943872603909924,0.5166949962439230,0.5386573043282245,0.5602595021114853,0.5814871478070124,0.6023260500286463,0.6227622772781792,0.6427821672590315,0.6623723360099528,0.6815196868526514,0.7002114191473703,0.7184350368505482,0.7361783568688516,0.7534295172039955,0.7701769848829038,0.7864095636679074,0.8021164015418378,0.8172869979630037,0.8319112108852060,0.8459792635381108,0.8594817509634441,0.8724096463026575,0.8847543068318715,0.8965074797400902,0.9076613076468588,0.9182083338557354,0.9281415073401638,0.9374541874585693,0.9461401483958068,0.9541935833284948,0.9616091083123656,0.9683817658908715,0.9745070284263808,0.9799808011600817,0.9847994250185215,0.9889596792178340,0.9924587838231074,0.9952944028278845,0.9974646503093891,0.9989681163327502,0.9998041299760686};

static const double w122[122] = {0.0002472384350927,0.0005753662169475,0.0009036017920940,0.0012312853406124,0.0015581676009192,0.0018840276533505,0.0022086496160641,0.0025318194611991,0.0028533244360555,0.0031729530004401,0.0034904948973386,0.0038057412647330,0.0041184847616026,0.0044285196989947,0.0047356421726503,0.0050396501957140,0.0053403438307962,0.0056375253210220,0.0059309992198159,0.0062205725192805,0.0065060547770234,0.0067872582413342,0.0070639979746207,0.0073360919750012,0.0076033612959824,0.0078656301641266,0.0081227260946456,0.0083744800048285,0.0086207263252313,0.0088613031085706,0.0090960521362161,0.0093248190222549,0.0095474533150118,0.0097638085960047,0.0099737425762303,0.0101771171897457,0.0103737986844669,0.0105636577101315,0.0107465694033711,0.0109224134698240,0.0110910742632500,0.0112524408615884,0.0114064071399044,0.0115528718401857,0.0116917386379340,0.0118229162055158,0.0119463182722257,0.0120618636810181,0.0121694764418899,0.0122690857818499,0.0123606261914633,0.0124440374679403,0.0125192647547232,0.0125862585775678,0.0126449748770778,0.0126953750376831,0.0127374259130344,0.0127710998478049,0.0127963746958742,0.0128132338348961,0.0128216661772291,0.0128216661772290,0.0128132338348957,0.0127963746958745,0.0127710998478047,0.0127374259130346,0.0126953750376823,0.0126449748770776,0.0125862585775673,0.0125192647547232,0.0124440374679405,0.0123606261914631,0.0122690857818496,0.0121694764418907,0.0120618636810184,0.0119463182722255,0.0118229162055160,0.0116917386379344,0.0115528718401857,0.0114064071399046,0.0112524408615879,0.0110910742632504,0.0109224134698239,0.0107465694033709,0.0105636577101315,0.0103737986844667,0.0101771171897454,0.0099737425762298,0.0097638085960049,0.0095474533150121,0.0093248190222541,0.0090960521362168,0.0088613031085700,0.0086207263252314,0.0083744800048279,0.0081227260946460,0.0078656301641267,0.0076033612959819,0.0073360919750019,0.0070639979746208,0.0067872582413341,0.0065060547770230,0.0062205725192813,0.0059309992198162,0.0056375253210219,0.0053403438307967,0.0050396501957139,0.0047356421726505,0.0044285196989946,0.0041184847616030,0.0038057412647335,0.0034904948973384,0.0031729530004400,0.0028533244360553,0.0025318194611987,0.0022086496160641,0.0018840276533505,0.0015581676009193,0.0012312853406122,0.0009036017920941,0.0005753662169472,0.0002472384350927};
static const double pts122[122] = {-0.9998073146814794,-0.9989848917170407,-0.9975058574465668,-0.9953708558168483,-0.9925812506590683,-0.9891388669713072,-0.9850459654756880,-0.9803052366127893,-0.9749197975710800,-0.9688931898373071,-0.9622293767119452,-0.9549327406347434,-0.9470080802700724,-0.9384606073343112,-0.9292959431591954,-0.9195201149896516,-0.9091395520167864,-0.8981610811477139,-0.8865919225145168,-0.8744396847250190,-0.8617123598583396,-0.8484183182084212,-0.8345663027789292,-0.8201654235331118,-0.8052251514023752,-0.7897553120574948,-0.7737660794465603,-0.7572679691038815,-0.7402718312342651,-0.7227888435771970,-0.7048305040556245,-0.6864086232141710,-0.6675353164517595,-0.6482229960537396,-0.6284843630287723,-0.6083323987558300,-0.5877803564468117,-0.5668417524303839,-0.5455303572627769,-0.5238601866713900,-0.5018454923371555,-0.4795007525217263,-0.4568406625456460,-0.4338801251237735,-0.4106342405643091,-0.3871182968378669,-0.3633477595231390,-0.3393382616357419,-0.3151055933469556,-0.2906656915990996,-0.2660346296243885,-0.2412286063741516,-0.2162639358653728,-0.1911570364515571,-0.1659244200249755,-0.1405826811573977,-0.1151484861864455,-0.0896385622547501,-0.0640696863091197,-0.0384586740669545,-0.0128223689571597,0.0128223689571600,0.0384586740669545,0.0640696863091196,0.0896385622547504,0.1151484861864453,0.1405826811573980,0.1659244200249754,0.1911570364515568,0.2162639358653730,0.2412286063741516,0.2660346296243885,0.2906656915990994,0.3151055933469555,0.3393382616357418,0.3633477595231384,0.3871182968378667,0.4106342405643088,0.4338801251237736,0.4568406625456458,0.4795007525217262,0.5018454923371554,0.5238601866713893,0.5455303572627765,0.5668417524303840,0.5877803564468123,0.6083323987558298,0.6284843630287721,0.6482229960537397,0.6675353164517593,0.6864086232141713,0.7048305040556239,0.7227888435771971,0.7402718312342654,0.7572679691038817,0.7737660794465597,0.7897553120574946,0.8052251514023749,0.8201654235331123,0.8345663027789293,0.8484183182084213,0.8617123598583404,0.8744396847250192,0.8865919225145169,0.8981610811477144,0.9091395520167866,0.9195201149896515,0.9292959431591952,0.9384606073343108,0.9470080802700719,0.9549327406347434,0.9622293767119452,0.9688931898373072,0.9749197975710799,0.9803052366127891,0.9850459654756879,0.9891388669713066,0.9925812506590690,0.9953708558168481,0.9975058574465676,0.9989848917170416,0.9998073146814795};

static const double w123[123] = {0.0002432510575523,0.0005660894098483,0.0008890398182765,0.0012114565252531,0.0015330976973780,0.0018537493692939,0.0021732025110199,0.0024912498910435,0.0028076855024547,0.0031223044969244,0.0034349032499231,0.0037452794664321,0.0040532323006738,0.0043585624808543,0.0046610724355099,0.0049605664199699,0.0052568506422552,0.0055497333880319,0.0058390251444014,0.0061245387223621,0.0064060893778251,0.0066834949310932,0.0069565758846918,0.0072251555394854,0.0074890601089936,0.0077481188318194,0.0080021640821389,0.0082510314781516,0.0084945599884418,0.0087325920361705,0.0089649736010325,0.0091915543189153,0.0094121875791903,0.0096267306195783,0.0098350446185203,0.0100369947850098,0.0102324504457967,0.0104212851299555,0.0106033766507057,0.0107786071844777,0.0109468633471555,0.0111080362674357,0.0112620216572767,0.0114087198793787,0.0115480360116537,0.0116798799086452,0.0118041662598598,0.0119208146449645,0.0120297495858237,0.0121309005953414,0.0122242022230653,0.0123095940975408,0.0123870209653727,0.0124564327269775,0.0125177844690017,0.0125710364933806,0.0126161543430297,0.0126531088241372,0.0126818760250521,0.0127024373317620,0.0127147794399332,0.0127188943635204,0.0127147794399333,0.0127024373317622,0.0126818760250523,0.0126531088241366,0.0126161543430304,0.0125710364933808,0.0125177844690015,0.0124564327269775,0.0123870209653730,0.0123095940975408,0.0122242022230657,0.0121309005953412,0.0120297495858239,0.0119208146449642,0.0118041662598603,0.0116798799086454,0.0115480360116534,0.0114087198793782,0.0112620216572768,0.0111080362674355,0.0109468633471553,0.0107786071844780,0.0106033766507050,0.0104212851299555,0.0102324504457971,0.0100369947850093,0.0098350446185207,0.0096267306195779,0.0094121875791905,0.0091915543189150,0.0089649736010326,0.0087325920361705,0.0084945599884411,0.0082510314781515,0.0080021640821391,0.0077481188318188,0.0074890601089935,0.0072251555394862,0.0069565758846919,0.0066834949310935,0.0064060893778255,0.0061245387223620,0.0058390251444020,0.0055497333880318,0.0052568506422551,0.0049605664199699,0.0046610724355097,0.0043585624808543,0.0040532323006731,0.0037452794664322,0.0034349032499228,0.0031223044969245,0.0028076855024543,0.0024912498910443,0.0021732025110197,0.0018537493692942,0.0015330976973779,0.0012114565252526,0.0008890398182767,0.0005660894098485,0.0002432510575520};
static const double pts123[123] = {-0.9998104223430794,-0.9990012613476082,-0.9975460682123333,-0.9954454610732016,-0.9927007595108207,-0.9893137300348529,-0.9852865610894834,-0.9806218571914866,-0.9753226360631910,-0.9693923262867362,-0.9628347649326536,-0.9556541950102311,-0.9478552626900777,-0.9394430142813628,-0.9304228929576078,-0.9208007352295156,-0.9105827671653508,-0.8997756003604256,-0.8883862276578077,-0.8764220186227603,-0.8638907147736818,-0.8508004245725331,-0.8371596181779452,-0.8229771219643657,-0.8082621128107552,-0.7930241121625314,-0.7772729798705773,-0.7610189078113058,-0.7442724132918933,-0.7270443322449532,-0.7093458122170445,-0.6911883051555600,-0.6725835599986473,-0.6535436150729688,-0.6340807903042069,-0.6142076792453682,-0.5939371409280292,-0.5732822915418098,-0.5522564959474463,-0.5308733590289687,-0.5091467168905578,-0.4870906279038034,-0.4647193636111321,-0.4420473994913122,-0.4190894055929911,-0.3958602370423382,-0.3723749244309391,-0.3486486640901413,-0.3246968082581664,-0.3005348551463418,-0.2761784389108724,-0.2516433195366558,-0.2269453726396759,-0.2021005791945748,-0.1771250151940572,-0.1520348412468071,-0.1268462921206578,-0.1015756662377720,-0.0762393151286388,-0.0508536328517020,-0.0254350453854758,0.0000000000000003,0.0254350453854759,0.0508536328517025,0.0762393151286387,0.1015756662377724,0.1268462921206581,0.1520348412468076,0.1771250151940572,0.2021005791945747,0.2269453726396760,0.2516433195366557,0.2761784389108724,0.3005348551463413,0.3246968082581655,0.3486486640901408,0.3723749244309389,0.3958602370423385,0.4190894055929911,0.4420473994913128,0.4647193636111326,0.4870906279038034,0.5091467168905578,0.5308733590289686,0.5522564959474463,0.5732822915418094,0.5939371409280291,0.6142076792453683,0.6340807903042069,0.6535436150729693,0.6725835599986474,0.6911883051555602,0.7093458122170451,0.7270443322449529,0.7442724132918939,0.7610189078113058,0.7772729798705769,0.7930241121625310,0.8082621128107557,0.8229771219643655,0.8371596181779450,0.8508004245725322,0.8638907147736815,0.8764220186227604,0.8883862276578071,0.8997756003604251,0.9105827671653507,0.9208007352295151,0.9304228929576073,0.9394430142813621,0.9478552626900776,0.9556541950102312,0.9628347649326535,0.9693923262867361,0.9753226360631907,0.9806218571914866,0.9852865610894838,0.9893137300348529,0.9927007595108200,0.9954454610732012,0.9975460682123334,0.9990012613476082,0.9998104223430792};

static const double w124[124] = {0.0002393593663511,0.0005570351420163,0.0008748269446841,0.0011921026336672,0.0015086275181114,0.0018241943134833,0.0021386005716341,0.0024516455899125,0.0027631298423214,0.0030728549104372,0.0033806235434822,0.0036862397582976,0.0039895089531302,0.0042902380264108,0.0045882354971458,0.0048833116254834,0.0051752785327703,0.0054639503207451,0.0057491431896417,0.0060306755550554,0.0063083681634560,0.0065820442062551,0.0068515294323370,0.0071166522589722,0.0073772438810493,0.0076331383785345,0.0078841728221093,0.0081301873768932,0.0083710254042123,0.0086065335613261,0.0088365618990562,0.0090609639572600,0.0092795968580794,0.0094923213969115,0.0096990021310385,0.0098995074658644,0.0100937097387016,0.0102814853000552,0.0104627145923456,0.0106372822260364,0.0108050770531030,0.0109659922377957,0.0111199253246686,0.0112667783038107,0.0114064576732461,0.0115388744984725,0.0116639444690820,0.0117815879524450,0.0118917300444099,0.0119943006169956,0.0120892343630437,0.0121764708377982,0.0122559544973905,0.0123276347342081,0.0123914659091108,0.0124474073804941,0.0124954235301656,0.0125354837860188,0.0125675626415043,0.0125916396718656,0.0126076995471467,0.0126157320419503,0.0126157320419504,0.0126076995471472,0.0125916396718658,0.0125675626415040,0.0125354837860186,0.0124954235301653,0.0124474073804944,0.0123914659091101,0.0123276347342078,0.0122559544973909,0.0121764708377980,0.0120892343630439,0.0119943006169957,0.0118917300444101,0.0117815879524452,0.0116639444690816,0.0115388744984719,0.0114064576732456,0.0112667783038108,0.0111199253246694,0.0109659922377954,0.0108050770531027,0.0106372822260366,0.0104627145923452,0.0102814853000553,0.0100937097387026,0.0098995074658645,0.0096990021310383,0.0094923213969114,0.0092795968580797,0.0090609639572603,0.0088365618990558,0.0086065335613258,0.0083710254042128,0.0081301873768928,0.0078841728221089,0.0076331383785346,0.0073772438810493,0.0071166522589719,0.0068515294323374,0.0065820442062555,0.0063083681634560,0.0060306755550554,0.0057491431896418,0.0054639503207447,0.0051752785327701,0.0048833116254841,0.0045882354971466,0.0042902380264107,0.0039895089531302,0.0036862397582975,0.0033806235434825,0.0030728549104366,0.0027631298423215,0.0024516455899125,0.0021386005716338,0.0018241943134831,0.0015086275181114,0.0011921026336680,0.0008748269446838,0.0005570351420158,0.0002393593663508};
static const double pts124[124] = {-0.9998134554260517,-0.9990172382045250,-0.9975853144678354,-0.9955182776478886,-0.9928174048394176,-0.9894844063840539,-0.9855214013115685,-0.9809309116159607,-0.9757158594868435,-0.9698795650620641,-0.9634257441632799,-0.9563585058643079,-0.9486823498434115,-0.9404021635021680,-0.9315232188448255,-0.9220511691165449,-0.9119920452009370,-0.9013522517783084,-0.8901385632465767,-0.8783581194071984,-0.8660184209187002,-0.8531273245206126,-0.8396930380307928,-0.8257241151192920,-0.8112294498620605,-0.7962182710779545,-0.7807001364526326,-0.7646849264530765,-0.7481828380366174,-0.7312043781584491,-0.7137603570817763,-0.6958618814948546,-0.6775203474392936,-0.6587474330541326,-0.6395550911403053,-0.6199555415502289,-0.5999612634073624,-0.5795849871606822,-0.5588396864791477,-0.5377385699912961,-0.5162950728752534,-0.4945228483044821,-0.4724357587547469,-0.4500478671778100,-0.4273734280474830,-0.4044268782837316,-0.3812228280606301,-0.3577760515039865,-0.3341014772845931,-0.3102141791130705,-0.2861293661423638,-0.2618623732840084,-0.2374286514443160,-0.2128437576867154,-0.1881233453264926,-0.1632831539642588,-0.1383389994644675,-0.1133067638853857,-0.0882023853669088,-0.0630418479826785,-0.0378411715629438,-0.0126164014946644,0.0126164014946627,0.0378411715629430,0.0630418479826775,0.0882023853669085,0.1133067638853850,0.1383389994644668,0.1632831539642579,0.1881233453264922,0.2128437576867147,0.2374286514443157,0.2618623732840084,0.2861293661423641,0.3102141791130702,0.3341014772845932,0.3577760515039863,0.3812228280606298,0.4044268782837320,0.4273734280474830,0.4500478671778110,0.4724357587547474,0.4945228483044823,0.5162950728752537,0.5377385699912970,0.5588396864791476,0.5795849871606824,0.5999612634073623,0.6199555415502291,0.6395550911403056,0.6587474330541329,0.6775203474392938,0.6958618814948547,0.7137603570817761,0.7312043781584491,0.7481828380366177,0.7646849264530768,0.7807001364526319,0.7962182710779545,0.8112294498620606,0.8257241151192917,0.8396930380307926,0.8531273245206129,0.8660184209187008,0.8783581194071990,0.8901385632465768,0.9013522517783085,0.9119920452009372,0.9220511691165445,0.9315232188448251,0.9404021635021679,0.9486823498434116,0.9563585058643085,0.9634257441632805,0.9698795650620649,0.9757158594868435,0.9809309116159611,0.9855214013115691,0.9894844063840537,0.9928174048394177,0.9955182776478890,0.9975853144678356,0.9990172382045258,0.9998134554260523};

static const double w125[125] = {0.0002355603242463,0.0005481963527936,0.0008609521039443,0.0011732086268369,0.0014847381007791,0.0017953396614127,0.0021048171850632,0.0024129762429696,0.0027196235375398,0.0030245668304706,0.0033276149979923,0.0036285781254188,0.0039272676153222,0.0042234963006688,0.0045170785595767,0.0048078304303001,0.0050955697257574,0.0053801161472719,0.0056612913972841,0.0059389192909208,0.0062128258662905,0.0064828394934226,0.0067487909817694,0.0070105136861882,0.0072678436113443,0.0075206195144518,0.0077686830063010,0.0080118786504988,0.0082500540608547,0.0084830599968666,0.0087107504572292,0.0089329827713178,0.0091496176885807,0.0093605194657959,0.0095655559521247,0.0097645986719146,0.0099575229052062,0.0101442077658782,0.0103245362773925,0.0104983954460998,0.0106656763320278,0.0108262741171567,0.0109800881710860,0.0111270221140978,0.0112669838775426,0.0113998857615322,0.0115256444898921,0.0116441812623402,0.0117554218038639,0.0118592964112656,0.0119557399968274,0.0120446921291050,0.0121260970707917,0.0121999038136400,0.0122660661104265,0.0123245425039288,0.0123752963529044,0.0124182958550462,0.0124535140669142,0.0124809289208161,0.0125005232386349,0.0125122847425922,0.0125162060629432,0.0125122847425925,0.0125005232386348,0.0124809289208159,0.0124535140669142,0.0124182958550454,0.0123752963529042,0.0123245425039289,0.0122660661104266,0.0121999038136396,0.0121260970707914,0.0120446921291050,0.0119557399968271,0.0118592964112654,0.0117554218038649,0.0116441812623403,0.0115256444898918,0.0113998857615324,0.0112669838775424,0.0111270221140979,0.0109800881710864,0.0108262741171560,0.0106656763320280,0.0104983954460997,0.0103245362773926,0.0101442077658777,0.0099575229052062,0.0097645986719147,0.0095655559521244,0.0093605194657961,0.0091496176885807,0.0089329827713175,0.0087107504572291,0.0084830599968663,0.0082500540608546,0.0080118786504987,0.0077686830063012,0.0075206195144517,0.0072678436113444,0.0070105136861885,0.0067487909817693,0.0064828394934227,0.0062128258662904,0.0059389192909201,0.0056612913972839,0.0053801161472720,0.0050955697257580,0.0048078304302996,0.0045170785595772,0.0042234963006688,0.0039272676153223,0.0036285781254191,0.0033276149979928,0.0030245668304704,0.0027196235375400,0.0024129762429698,0.0021048171850634,0.0017953396614122,0.0014847381007790,0.0011732086268369,0.0008609521039437,0.0005481963527937,0.0002355603242469};
static const double pts125[125] = {-0.9998164162977692,-0.9990328347529771,-0.9976236268109623,-0.9955893622521632,-0.9929312773666032,-0.9896510285387510,-0.9857506681124875,-0.9812326387998599,-0.9760997710061092,-0.9703552806754754,-0.9640027671280047,-0.9570462107394970,-0.9494899704164607,-0.9413387808489156,-0.9325977495349710,-0.9232723535755036,-0.9133684362392490,-0.9028922032995753,-0.8918502191447819,-0.8802494026640920,-0.8680970229117678,-0.8554006945519689,-0.8421683730871689,-0.8284083498730652,-0.8141292469230968,-0.7993400115058048,-0.7840499105384182,-0.7682685247801553,-0.7520057428288939,-0.7352717549249539,-0.7180770465658811,-0.7004323919362264,-0.6823488471564397,-0.6638377433551057,-0.6449106795688581,-0.6255795154744326,-0.6058563639574009,-0.5857535835222406,-0.5652837705485093,-0.5444597513979627,-0.5232945743775692,-0.5018015015634495,-0.4799940004908752,-0.4578857357155249,-0.4354905602512863,-0.4128225068899710,-0.3898957794083824,-0.3667247436682453,-0.3433239186145745,-0.3197079671781101,-0.2958916870875526,-0.2718900015973137,-0.2477179501366249,-0.2233906788858477,-0.1989234312858921,-0.1743315384866942,-0.1496304097407345,-0.1248355227476162,-0.0999624139557578,-0.0750266688272689,-0.0500439120721195,-0.0250297978577126,0.0000000000000002,0.0250297978577135,0.0500439120721195,0.0750266688272691,0.0999624139557580,0.1248355227476165,0.1496304097407345,0.1743315384866945,0.1989234312858924,0.2233906788858478,0.2477179501366251,0.2718900015973139,0.2958916870875530,0.3197079671781112,0.3433239186145750,0.3667247436682469,0.3898957794083825,0.4128225068899707,0.4354905602512869,0.4578857357155257,0.4799940004908754,0.5018015015634493,0.5232945743775690,0.5444597513979630,0.5652837705485091,0.5857535835222404,0.6058563639574007,0.6255795154744328,0.6449106795688575,0.6638377433551055,0.6823488471564403,0.7004323919362264,0.7180770465658811,0.7352717549249542,0.7520057428288935,0.7682685247801553,0.7840499105384180,0.7993400115058048,0.8141292469230966,0.8284083498730659,0.8421683730871700,0.8554006945519694,0.8680970229117679,0.8802494026640922,0.8918502191447814,0.9028922032995746,0.9133684362392487,0.9232723535755042,0.9325977495349705,0.9413387808489156,0.9494899704164604,0.9570462107394970,0.9640027671280043,0.9703552806754753,0.9760997710061090,0.9812326387998599,0.9857506681124869,0.9896510285387506,0.9929312773666021,0.9955893622521630,0.9976236268109614,0.9990328347529763,0.9998164162977685};

static const double w126[126] = {0.0002318510135562,0.0005395662593115,0.0008474046637000,0.0011547600560593,0.0014614112260187,0.0017671634808803,0.0020718267760666,0.0023752127135767,0.0026771339834133,0.0029774042891373,0.0032758383985840,0.0035722522332850,0.0038664629713477,0.0041582891552408,0.0044475508012310,0.0047340695090725,0.0050176685713071,0.0052981730818286,0.0055754100435031,0.0058492084747028,0.0061193995146610,0.0063858165275505,0.0066482952052092,0.0069066736684442,0.0071607925668510,0.0074104951770737,0.0076556274994510,0.0078960383529874,0.0081315794685844,0.0083621055804806,0.0085874745158349,0.0088075472824109,0.0090221881542970,0.0092312647556055,0.0094346481421176,0.0096322128808048,0.0098238371271864,0.0100094027004761,0.0101887951564638,0.0103619038580998,0.0105286220437293,0.0106888468929300,0.0108424795899302,0.0109894253845477,0.0111295936506281,0.0112628979419339,0.0113892560454610,0.0115085900321403,0.0116208263048976,0.0117258956440511,0.0118237332499887,0.0119142787831432,0.0119974764011972,0.0120732747935320,0.0121416272128633,0.0122024915040751,0.0122558301302217,0.0123016101956722,0.0123398034664026,0.0123703863874061,0.0123933400972204,0.0124086504395620,0.0124163079720541,0.0124163079720547,0.0124086504395619,0.0123933400972204,0.0123703863874056,0.0123398034664024,0.0123016101956725,0.0122558301302213,0.0122024915040751,0.0121416272128627,0.0120732747935316,0.0119974764011977,0.0119142787831429,0.0118237332499889,0.0117258956440509,0.0116208263048983,0.0115085900321395,0.0113892560454608,0.0112628979419344,0.0111295936506282,0.0109894253845480,0.0108424795899296,0.0106888468929304,0.0105286220437287,0.0103619038581005,0.0101887951564635,0.0100094027004763,0.0098238371271872,0.0096322128808050,0.0094346481421176,0.0092312647556049,0.0090221881542970,0.0088075472824115,0.0085874745158342,0.0083621055804802,0.0081315794685852,0.0078960383529878,0.0076556274994507,0.0074104951770734,0.0071607925668513,0.0069066736684442,0.0066482952052093,0.0063858165275507,0.0061193995146608,0.0058492084747021,0.0055754100435030,0.0052981730818295,0.0050176685713069,0.0047340695090727,0.0044475508012314,0.0041582891552409,0.0038664629713477,0.0035722522332850,0.0032758383985841,0.0029774042891372,0.0026771339834140,0.0023752127135772,0.0020718267760667,0.0017671634808803,0.0014614112260187,0.0011547600560590,0.0008474046637003,0.0005395662593109,0.0002318510135560};
static const double pts126[126] = {-0.9998193072324032,-0.9990480629675661,-0.9976610346359589,-0.9956587693679211,-0.9930424642509681,-0.9898137238197389,-0.9859745363331001,-0.9815272683105118,-0.9764746619461733,-0.9708198330431659,-0.9645662689460820,-0.9577178263265722,-0.9502787287743495,-0.9422535641767126,-0.9336472818805115,-0.9244651896348400,-0.9147129503146590,-0.9043965784265120,-0.8935224363980339,-0.8820972306532828,-0.8701280074761643,-0.8576221486644146,-0.8445873669767635,-0.8310317013760596,-0.8169635120712556,-0.8023914753613094,-0.7873245782841659,-0.7717721130741128,-0.7557436714309217,-0.7392491386043124,-0.7222986872973801,-0.7049027713927489,-0.6870721195053129,-0.6688177283655444,-0.6501508560374544,-0.6310830149753758,-0.6116259649238599,-0.5917917056650644,-0.5715924696181002,-0.5510407142949043,-0.5301491146172939,-0.5089305550999378,-0.4873981219040611,-0.4655650947667907,-0.4434449388111218,-0.4210512962415407,-0.3983979779304442,-0.3754989549005358,-0.3523683497084475,-0.3290204277349105,-0.3054695883868396,-0.2817303562167577,-0.2578173719650466,-0.2337453835305297,-0.2095292368749764,-0.1851838668671241,-0.1607242880718679,-0.1361655854903006,-0.1115229052563112,-0.0868114452954829,-0.0620464459520473,-0.0372431805896777,-0.0124169461719226,0.0124169461719235,0.0372431805896792,0.0620464459520482,0.0868114452954832,0.1115229052563115,0.1361655854903010,0.1607242880718680,0.1851838668671243,0.2095292368749762,0.2337453835305298,0.2578173719650467,0.2817303562167585,0.3054695883868398,0.3290204277349109,0.3523683497084477,0.3754989549005352,0.3983979779304443,0.4210512962415405,0.4434449388111222,0.4655650947667912,0.4873981219040612,0.5089305550999379,0.5301491146172940,0.5510407142949038,0.5715924696181002,0.5917917056650644,0.6116259649238596,0.6310830149753753,0.6501508560374540,0.6688177283655440,0.6870721195053130,0.7049027713927492,0.7222986872973798,0.7392491386043115,0.7557436714309212,0.7717721130741124,0.7873245782841659,0.8023914753613088,0.8169635120712554,0.8310317013760593,0.8445873669767636,0.8576221486644143,0.8701280074761640,0.8820972306532824,0.8935224363980340,0.9043965784265120,0.9147129503146592,0.9244651896348404,0.9336472818805117,0.9422535641767128,0.9502787287743497,0.9577178263265725,0.9645662689460818,0.9708198330431654,0.9764746619461727,0.9815272683105120,0.9859745363330999,0.9898137238197384,0.9930424642509679,0.9956587693679204,0.9976610346359590,0.9990480629675669,0.9998193072324033};

static const double w127[127] = {0.0002282286305481,0.0005311383434767,0.0008341744062587,0.0011367430353745,0.0014386293828145,0.0017396446905026,0.0020396047589127,0.0023383269888885,0.0026356298282822,0.0029313326951765,0.0032252560243443,0.0035172213518341,0.0038070514128261,0.0040945702443712,0.0043796032897701,0.0046619775032657,0.0049415214543777,0.0052180654315707,0.0054914415450343,0.0057614838284611,0.0060280283397005,0.0062909132602323,0.0065499789933588,0.0068050682610698,0.0070560261995017,0.0073027004529464,0.0075449412663337,0.0077826015761367,0.0080155370996553,0.0082436064225972,0.0084666710849358,0.0086845956649594,0.0088972478614874,0.0091044985741880,0.0093062219819506,0.0095022956192782,0.0096926004506232,0.0098770209426644,0.0100554451344402,0.0102277647053199,0.0103938750407660,0.0105536752958441,0.0107070684564467,0.0108539613981868,0.0109942649429364,0.0111278939129653,0.0112547671826500,0.0113748077277288,0.0114879426720587,0.0115941033318601,0.0116932252574136,0.0117852482721912,0.0118701165093806,0.0119477784458104,0.0120181869332254,0.0120812992269093,0.0121370770116391,0.0121854864249414,0.0122264980776507,0.0122600870717556,0.0122862330155102,0.0123049200358154,0.0123161367878543,0.0123198764619806,0.0123161367878538,0.0123049200358156,0.0122862330155102,0.0122600870717563,0.0122264980776502,0.0121854864249412,0.0121370770116393,0.0120812992269096,0.0120181869332254,0.0119477784458103,0.0118701165093806,0.0117852482721912,0.0116932252574142,0.0115941033318600,0.0114879426720587,0.0113748077277291,0.0112547671826499,0.0111278939129651,0.0109942649429364,0.0108539613981869,0.0107070684564468,0.0105536752958446,0.0103938750407663,0.0102277647053191,0.0100554451344405,0.0098770209426643,0.0096926004506237,0.0095022956192783,0.0093062219819506,0.0091044985741872,0.0088972478614877,0.0086845956649594,0.0084666710849359,0.0082436064225976,0.0080155370996551,0.0077826015761369,0.0075449412663335,0.0073027004529465,0.0070560261995016,0.0068050682610694,0.0065499789933588,0.0062909132602323,0.0060280283397002,0.0057614838284610,0.0054914415450347,0.0052180654315703,0.0049415214543769,0.0046619775032653,0.0043796032897703,0.0040945702443709,0.0038070514128264,0.0035172213518344,0.0032252560243450,0.0029313326951760,0.0026356298282817,0.0023383269888890,0.0020396047589128,0.0017396446905027,0.0014386293828145,0.0011367430353743,0.0008341744062589,0.0005311383434769,0.0002282286305481};
static const double pts127[127] = {-0.9998221304153060,-0.9990629343553121,-0.9976975661898047,-0.9957265513520274,-0.9931510492545175,-0.9899726145914839,-0.9861931740169314,-0.9818150208038139,-0.9768408123430699,-0.9712735681615288,-0.9651166679452915,-0.9583738494252385,-0.9510492060778805,-0.9431471846248148,-0.9346725823247377,-0.9256305440562336,-0.9160265591914655,-0.9058664582618212,-0.8951564094170840,-0.8839029146800265,-0.8721128059985601,-0.8597932410977407,-0.8469516991340978,-0.8335959761548996,-0.8197341803650783,-0.8053747272046802,-0.7905263342398138,-0.7751980158702028,-0.7593990778565370,-0.7431391116709544,-0.7264279886740727,-0.7092758541221049,-0.6916931210077006,-0.6736904637382506,-0.6552788116554825,-0.6364693424002973,-0.6172734751268579,-0.5977028635700655,-0.5777693889706120,-0.5574851528619323,-0.5368624697233970,-0.5159138595042491,-0.4946520400227818,-0.4730899192454046,-0.4512405874502662,-0.4291173092801932,-0.4067335156897826,-0.3841027957915171,-0.3612388886058698,-0.3381556747203989,-0.3148671678628949,-0.2913875063937055,-0.2677309447223886,-0.2439118446539180,-0.2199446666696878,-0.1958439611486109,-0.1716243595336419,-0.1473005654490859,-0.1228873457740833,-0.0983995216776992,-0.0738519596210488,-0.0492595623319268,-0.0246372597574212,-0.0000000000000001,0.0246372597574209,0.0492595623319266,0.0738519596210486,0.0983995216776989,0.1228873457740826,0.1473005654490855,0.1716243595336420,0.1958439611486105,0.2199446666696875,0.2439118446539179,0.2677309447223886,0.2913875063937052,0.3148671678628948,0.3381556747203981,0.3612388886058695,0.3841027957915165,0.4067335156897826,0.4291173092801936,0.4512405874502662,0.4730899192454053,0.4946520400227821,0.5159138595042494,0.5368624697233974,0.5574851528619321,0.5777693889706125,0.5977028635700652,0.6172734751268584,0.6364693424002971,0.6552788116554825,0.6736904637382507,0.6916931210077006,0.7092758541221047,0.7264279886740727,0.7431391116709543,0.7593990778565370,0.7751980158702021,0.7905263342398134,0.8053747272046803,0.8197341803650788,0.8335959761548993,0.8469516991340978,0.8597932410977408,0.8721128059985611,0.8839029146800266,0.8951564094170836,0.9058664582618209,0.9160265591914660,0.9256305440562338,0.9346725823247379,0.9431471846248147,0.9510492060778808,0.9583738494252385,0.9651166679452924,0.9712735681615290,0.9768408123430702,0.9818150208038141,0.9861931740169316,0.9899726145914842,0.9931510492545169,0.9957265513520273,0.9976975661898044,0.9990629343553121,0.9998221304153061};

static const double w128[128] = {0.0002246904801461,0.0005229063396700,0.0008212515093344,0.0011191442154814,0.0014163757357291,0.0017127630204554,0.0020081274918692,0.0023022921283512,0.0025950809163382,0.0028863187714330,0.0031758315808537,0.0034634462834494,0.0037489909628172,0.0040322949452432,0.0043131888993083,0.0045915049358301,0.0048670767075034,0.0051397395079163,0.0054093303697514,0.0056756881620403,0.0059386536863704,0.0061980697719754,0.0064537813696336,0.0067056356443084,0.0069534820664758,0.0071971725020834,0.0074365613010737,0.0076715053844325,0.0079018643296999,0.0081275004548924,0.0083482789007943,0.0085640677115560,0.0087747379135588,0.0089801635925042,0.0091802219686659,0.0093747934702723,0.0095637618049758,0.0097470140293526,0.0099244406164156,0.0100959355210655,0.0102613962434797,0.0104207238903754,0.0105738232341108,0.0107206027696041,0.0108609747690262,0.0109948553342300,0.0111221644469003,0.0112428260163725,0.0113567679251179,0.0114639220718436,0.0115642244121935,0.0116576149970312,0.0117440380082681,0.0118234417922235,0.0118957788905015,0.0119610060683514,0.0120190843405121,0.0120699789945099,0.0121136596114080,0.0121501000839860,0.0121792786323450,0.0122011778169246,0.0122157845489253,0.0122230900981312,0.0122230900981308,0.0122157845489251,0.0122011778169245,0.0121792786323455,0.0121501000839862,0.0121136596114076,0.0120699789945100,0.0120190843405117,0.0119610060683515,0.0118957788905014,0.0118234417922239,0.0117440380082685,0.0116576149970317,0.0115642244121938,0.0114639220718436,0.0113567679251182,0.0112428260163729,0.0111221644468995,0.0109948553342301,0.0108609747690258,0.0107206027696042,0.0105738232341106,0.0104207238903750,0.0102613962434797,0.0100959355210655,0.0099244406164151,0.0097470140293534,0.0095637618049759,0.0093747934702719,0.0091802219686657,0.0089801635925039,0.0087747379135591,0.0085640677115558,0.0083482789007949,0.0081275004548920,0.0079018643296995,0.0076715053844326,0.0074365613010733,0.0071971725020831,0.0069534820664755,0.0067056356443086,0.0064537813696338,0.0061980697719758,0.0059386536863701,0.0056756881620402,0.0054093303697513,0.0051397395079163,0.0048670767075037,0.0045915049358307,0.0043131888993082,0.0040322949452428,0.0037489909628173,0.0034634462834496,0.0031758315808538,0.0028863187714330,0.0025950809163383,0.0023022921283518,0.0020081274918694,0.0017127630204553,0.0014163757357292,0.0011191442154816,0.0008212515093347,0.0005229063396702,0.0002246904801456};
static const double pts128[128] = {-0.9998248879471320,-0.9990774599773762,-0.9977332486255139,-0.9957927585349812,-0.9932571129002132,-0.9901278184917345,-0.9864067427245868,-0.9820961084357188,-0.9771984914639075,-0.9717168187471368,-0.9656543664319653,-0.9590147578536997,-0.9518019613412645,-0.9440202878302201,-0.9356743882779163,-0.9267692508789479,-0.9173101980809607,-0.9073028834017574,-0.8967532880491584,-0.8856677173453974,-0.8740527969580316,-0.8619154689395480,-0.8492629875779690,-0.8361029150609066,-0.8224431169556436,-0.8082917575079137,-0.7936572947621932,-0.7785484755064117,-0.7629743300440949,-0.7469441667970618,-0.7304675667419093,-0.7135543776835878,-0.6962147083695140,-0.6784589224477194,-0.6602976322726456,-0.6417416925623073,-0.6228021939105843,-0.6034904561585481,-0.5838180216287635,-0.5637966482266185,-0.5434383024128101,-0.5227551520511752,-0.5017595591361446,-0.4804640724041718,-0.4588814198335521,-0.4370245010371046,-0.4149063795522753,-0.3925402750332677,-0.3699395553498587,-0.3471177285976357,-0.3240884350244135,-0.3008654388776771,-0.2774626201779045,-0.2538939664226945,-0.2301735642266601,-0.2063155909020796,-0.1823343059853378,-0.1582440427142253,-0.1340591994611881,-0.1097942311276439,-0.0854636405045156,-0.0610819696041394,-0.0366637909687333,-0.0122236989606157,0.0122236989606159,0.0366637909687334,0.0610819696041399,0.0854636405045154,0.1097942311276436,0.1340591994611875,0.1582440427142247,0.1823343059853369,0.2063155909020790,0.2301735642266599,0.2538939664226942,0.2774626201779042,0.3008654388776771,0.3240884350244136,0.3471177285976356,0.3699395553498591,0.3925402750332674,0.4149063795522751,0.4370245010371044,0.4588814198335525,0.4804640724041722,0.5017595591361446,0.5227551520511757,0.5434383024128103,0.5637966482266180,0.5838180216287632,0.6034904561585485,0.6228021939105850,0.6417416925623077,0.6602976322726463,0.6784589224477193,0.6962147083695143,0.7135543776835878,0.7304675667419085,0.7469441667970619,0.7629743300440948,0.7785484755064119,0.7936572947621935,0.8082917575079137,0.8224431169556440,0.8361029150609067,0.8492629875779693,0.8619154689395484,0.8740527969580321,0.8856677173453971,0.8967532880491585,0.9073028834017568,0.9173101980809607,0.9267692508789478,0.9356743882779162,0.9440202878302203,0.9518019613412648,0.9590147578537001,0.9656543664319656,0.9717168187471366,0.9771984914639076,0.9820961084357184,0.9864067427245861,0.9901278184917346,0.9932571129002131,0.9957927585349809,0.9977332486255140,0.9990774599773760,0.9998248879471320};

static const double w129[129] = {0.0002212339709147,0.0005148642230982,0.0008086265278392,0.0011019507590479,0.0013946340938898,0.0016864989753125,0.0019773722341061,0.0022670822149259,0.0025554582334622,0.0028423304956231,0.0031275301362235,0.0034108892946757,0.0036922412036229,0.0039714202823332,0.0042482622317858,0.0045226041301065,0.0047942845277553,0.0050631435421367,0.0053290229514530,0.0055917662876655,0.0058512189284826,0.0061072281882912,0.0063596434079728,0.0066083160435305,0.0068530997534969,0.0070938504850318,0.0073304265586898,0.0075626887517936,0.0077905003803534,0.0080137273795069,0.0082322383824075,0.0084459047975318,0.0086546008843540,0.0088582038273390,0.0090565938082222,0.0092496540765120,0.0094372710182059,0.0096193342226417,0.0097957365474784,0.0099663741817446,0.0101311467069341,0.0102899571560965,0.0104427120709030,0.0105893215566451,0.0107296993351398,0.0108637627954963,0.0109914330427396,0.0111126349442333,0.0112272971738972,0.0113353522541810,0.0114367365957757,0.0115313905350323,0.0116192583690750,0.0117002883885826,0.0117744329082183,0.0118416482946891,0.0119018949924286,0.0119551375468714,0.0120013446253186,0.0120404890353771,0.0120725477409624,0.0120975018758544,0.0121153367547993,0.0121260418821543,0.0121296109580606,0.0121260418821540,0.0121153367547999,0.0120975018758540,0.0120725477409630,0.0120404890353768,0.0120013446253190,0.0119551375468708,0.0119018949924286,0.0118416482946894,0.0117744329082178,0.0117002883885827,0.0116192583690747,0.0115313905350320,0.0114367365957755,0.0113353522541811,0.0112272971738972,0.0111126349442334,0.0109914330427394,0.0108637627954966,0.0107296993351398,0.0105893215566459,0.0104427120709023,0.0102899571560970,0.0101311467069339,0.0099663741817450,0.0097957365474779,0.0096193342226414,0.0094372710182060,0.0092496540765127,0.0090565938082225,0.0088582038273393,0.0086546008843533,0.0084459047975312,0.0082322383824074,0.0080137273795073,0.0077905003803535,0.0075626887517941,0.0073304265586904,0.0070938504850316,0.0068530997534970,0.0066083160435310,0.0063596434079725,0.0061072281882912,0.0058512189284823,0.0055917662876656,0.0053290229514531,0.0050631435421363,0.0047942845277556,0.0045226041301071,0.0042482622317861,0.0039714202823331,0.0036922412036226,0.0034108892946760,0.0031275301362226,0.0028423304956235,0.0025554582334622,0.0022670822149262,0.0019773722341058,0.0016864989753123,0.0013946340938898,0.0011019507590481,0.0008086265278395,0.0005148642230981,0.0002212339709148};
static const double pts129[129] = {-0.9998275818477489,-0.9990916504696409,-0.9977681080525850,-0.9958574393142837,-0.9933607326210715,-0.9902794486488180,-0.9866153978313477,-0.9823707352517416,-0.9775479582993679,-0.9721499048427045,-0.9661797514202101,-0.9596410113101924,-0.9525375324342091,-0.9448734950776736,-0.9366534094216517,-0.9278821128840040,-0.9185647672698293,-0.9087068557320702,-0.8983141795436342,-0.8873928546826807,-0.8759493082329433,-0.8639902746011262,-0.8515227915535364,-0.8385541960742665,-0.8250921200473363,-0.8111444857653121,-0.7967195012670594,-0.7818256555073412,-0.7664717133611216,-0.7506667104654917,-0.7344199479022731,-0.7177409867244061,-0.7006396423293517,-0.6831259786828255,-0.6652103023962410,-0.6469031566613705,-0.6282153150457803,-0.6091577751526872,-0.5897417521489813,-0.5699786721652139,-0.5498801655714283,-0.5294580601328042,-0.5087243740491435,-0.4876913088822741,-0.4663712423755609,-0.4447767211697223,-0.4229204534192648,-0.4008153013138606,-0.3784742735090804,-0.3559105174709361,-0.3331373117387247,-0.3101680581107489,-0.2870162737574914,-0.2636955832669005,-0.2402197106264597,-0.2166024711467598,-0.1928577633313303,-0.1689995606975132,-0.1450419035531889,-0.1209988907342008,-0.0968846713073332,-0.0727134362437304,-0.0484994100676562,-0.0242568424855056,0.0000000000000005,0.0242568424855062,0.0484994100676567,0.0727134362437306,0.0968846713073336,0.1209988907342011,0.1450419035531891,0.1689995606975133,0.1928577633313306,0.2166024711467601,0.2402197106264599,0.2636955832669008,0.2870162737574913,0.3101680581107484,0.3331373117387249,0.3559105174709360,0.3784742735090801,0.4008153013138597,0.4229204534192645,0.4447767211697228,0.4663712423755617,0.4876913088822748,0.5087243740491429,0.5294580601328033,0.5498801655714275,0.5699786721652139,0.5897417521489815,0.6091577751526865,0.6282153150457797,0.6469031566613708,0.6652103023962407,0.6831259786828258,0.7006396423293523,0.7177409867244060,0.7344199479022728,0.7506667104654913,0.7664717133611215,0.7818256555073413,0.7967195012670594,0.8111444857653124,0.8250921200473360,0.8385541960742666,0.8515227915535358,0.8639902746011259,0.8759493082329436,0.8873928546826808,0.8983141795436336,0.9087068557320698,0.9185647672698286,0.9278821128840038,0.9366534094216514,0.9448734950776736,0.9525375324342092,0.9596410113101915,0.9661797514202104,0.9721499048427036,0.9775479582993675,0.9823707352517416,0.9866153978313477,0.9902794486488180,0.9933607326210715,0.9958574393142835,0.9977681080525854,0.9990916504696411,0.9998275818477489};

static const double w130[130] = {0.0002178566103126,0.0005070061987739,0.0007962903766330,0.0010851503173438,0.0013733888816237,0.0016608337988538,0.0019473171048738,0.0022326723088795,0.0025167338558839,0.0027993370441739,0.0030803180604497,0.0033595140514388,0.0036367632082696,0.0039119048555708,0.0041847795422603,0.0044552291327161,0.0047230968977354,0.0049882276049698,0.0052504676086422,0.0055096649384472,0.0057656693875209,0.0060183325994283,0.0062675081540981,0.0065130516526446,0.0067548208010320,0.0069926754925176,0.0072264778888374,0.0074560925000781,0.0076813862631874,0.0079022286190819,0.0081184915883041,0.0083300498451857,0.0085367807904719,0.0087385646223677,0.0089352844059628,0.0091268261409957,0.0093130788279148,0.0094939345322073,0.0096692884469416,0.0098390389535072,0.0100030876805027,0.0101613395607436,0.0103137028863480,0.0104600893618887,0.0106004141555572,0.0107345959483264,0.0108625569810722,0.0109842230996383,0.0110995237978068,0.0112083922581586,0.0113107653907943,0.0114065838698908,0.0114957921680898,0.0115783385886674,0.0116541752954978,0.0117232583407722,0.0117855476904681,0.0118410072475489,0.0118896048728809,0.0119313124038616,0.0119661056707356,0.0119939645106047,0.0120148727791112,0.0120288183597928,0.0120357931711055,0.0120357931711051,0.0120288183597929,0.0120148727791108,0.0119939645106050,0.0119661056707352,0.0119313124038612,0.0118896048728809,0.0118410072475489,0.0117855476904681,0.0117232583407730,0.0116541752954979,0.0115783385886673,0.0114957921680900,0.0114065838698908,0.0113107653907935,0.0112083922581590,0.0110995237978067,0.0109842230996383,0.0108625569810721,0.0107345959483262,0.0106004141555572,0.0104600893618881,0.0103137028863481,0.0101613395607439,0.0100030876805038,0.0098390389535072,0.0096692884469412,0.0094939345322074,0.0093130788279148,0.0091268261409954,0.0089352844059627,0.0087385646223677,0.0085367807904715,0.0083300498451852,0.0081184915883043,0.0079022286190819,0.0076813862631872,0.0074560925000781,0.0072264778888375,0.0069926754925176,0.0067548208010322,0.0065130516526450,0.0062675081540984,0.0060183325994280,0.0057656693875210,0.0055096649384475,0.0052504676086423,0.0049882276049691,0.0047230968977356,0.0044552291327156,0.0041847795422600,0.0039119048555707,0.0036367632082696,0.0033595140514391,0.0030803180604493,0.0027993370441743,0.0025167338558838,0.0022326723088788,0.0019473171048740,0.0016608337988535,0.0013733888816235,0.0010851503173446,0.0007962903766330,0.0005070061987740,0.0002178566103128};
static const double pts130[130] = {-0.9998302140599383,-0.9991055160621789,-0.9978021695847504,-0.9959206402428223,-0.9934619829013116,-0.9904276138873859,-0.9868192888089691,-0.9826390975558296,-0.9778894620301704,-0.9725731343910994,-0.9666931953227887,-0.9602530521893563,-0.9532564370316575,-0.9457074043898372,-0.9376103289456815,-0.9289699029828734,-0.9197911336650405,-0.9100793401323806,-0.8998401504181049,-0.8890794981862469,-0.8778036192925929,-0.8660190481706406,-0.8537326140446235,-0.8409514369717749,-0.8276829237160942,-0.8139347634559958,-0.7997149233283239,-0.7850316438112995,-0.7698934339490798,-0.7543090664206890,-0.7382875724561780,-0.7218382366029572,-0.7049705913453355,-0.6876944115803765,-0.6700197089532839,-0.6519567260555869,-0.6335159304894944,-0.6147080088018523,-0.5955438602912272,-0.5760345906916979,-0.5561915057370108,-0.5360261046088456,-0.5155500732729648,-0.4947752777071366,-0.4737137570247256,-0.4523777164979554,-0.4307795204848845,-0.4089316852641903,-0.3868468717819089,-0.3645378783143469,-0.3420176330514044,-0.3192991866046138,-0.2963957044442375,-0.2733204592697986,-0.2500868233184783,-0.2267082606158236,-0.2031983191732695,-0.1795706231369872,-0.1558388648926138,-0.1320167971304341,-0.1081182248756197,-0.0841569974881358,-0.0601470006369577,-0.0361021482532453,-0.0120363744671411,0.0120363744671410,0.0361021482532457,0.0601470006369580,0.0841569974881359,0.1081182248756204,0.1320167971304344,0.1558388648926139,0.1795706231369877,0.2031983191732700,0.2267082606158240,0.2500868233184784,0.2733204592697990,0.2963957044442372,0.3192991866046135,0.3420176330514041,0.3645378783143464,0.3868468717819089,0.4089316852641904,0.4307795204848846,0.4523777164979548,0.4737137570247251,0.4947752777071368,0.5155500732729648,0.5360261046088447,0.5561915057370110,0.5760345906916985,0.5955438602912276,0.6147080088018515,0.6335159304894942,0.6519567260555869,0.6700197089532839,0.6876944115803763,0.7049705913453356,0.7218382366029580,0.7382875724561778,0.7543090664206887,0.7698934339490797,0.7850316438112992,0.7997149233283237,0.8139347634559958,0.8276829237160941,0.8409514369717755,0.8537326140446235,0.8660190481706409,0.8778036192925931,0.8890794981862470,0.8998401504181045,0.9100793401323809,0.9197911336650405,0.9289699029828733,0.9376103289456812,0.9457074043898368,0.9532564370316573,0.9602530521893563,0.9666931953227887,0.9725731343910994,0.9778894620301700,0.9826390975558290,0.9868192888089692,0.9904276138873860,0.9934619829013110,0.9959206402428225,0.9978021695847501,0.9991055160621785,0.9998302140599381};

static const double w131[131] = {0.0002145560001992,0.0004993266910783,0.0007842343141929,0.0010687310081014,0.0013526251106363,0.0016357494407179,0.0019179410448259,0.0021990384039793,0.0024788809015128,0.0027573087389615,0.0030341629678732,0.0033092855575629,0.0035825194754508,0.0038537087720947,0.0041226986678942,0.0043893356402256,0.0046534675103845,0.0049149435300516,0.0051736144671001,0.0054293326906177,0.0056819522550786,0.0059313289835750,0.0061773205500644,0.0064197865605730,0.0066585886333025,0.0068935904775949,0.0071246579717094,0.0073516592393632,0.0075744647249875,0.0077929472676690,0.0080069821737199,0.0082164472878400,0.0084212230628357,0.0086211926278434,0.0088162418550341,0.0090062594247448,0.0091911368890124,0.0093707687334683,0.0095450524375553,0.0097138885330417,0.0098771806607852,0.0100348356257357,0.0101867634501128,0.0103328774247686,0.0104730941586693,0.0106073336264880,0.0107355192142808,0.0108575777632111,0.0109734396112987,0.0110830386331859,0.0111863122778679,0.0112832016044029,0.0113736513155362,0.0114576097892768,0.0115350291083478,0.0116058650875360,0.0116700772989143,0.0117276290949083,0.0117784876292166,0.0118226238755572,0.0118600126442289,0.0118906325964940,0.0119144662567515,0.0119315000225142,0.0119417241721705,0.0119451328705338,0.0119417241721703,0.0119315000225145,0.0119144662567516,0.0118906325964941,0.0118600126442287,0.0118226238755568,0.0117784876292169,0.0117276290949077,0.0116700772989140,0.0116058650875366,0.0115350291083483,0.0114576097892772,0.0113736513155365,0.0112832016044023,0.0111863122778694,0.0110830386331858,0.0109734396112988,0.0108575777632105,0.0107355192142813,0.0106073336264884,0.0104730941586685,0.0103328774247688,0.0101867634501121,0.0100348356257352,0.0098771806607860,0.0097138885330417,0.0095450524375550,0.0093707687334681,0.0091911368890126,0.0090062594247448,0.0088162418550339,0.0086211926278436,0.0084212230628353,0.0082164472878400,0.0080069821737201,0.0077929472676696,0.0075744647249877,0.0073516592393631,0.0071246579717097,0.0068935904775944,0.0066585886333021,0.0064197865605729,0.0061773205500643,0.0059313289835750,0.0056819522550790,0.0054293326906175,0.0051736144670995,0.0049149435300516,0.0046534675103843,0.0043893356402260,0.0041226986678949,0.0038537087720943,0.0035825194754513,0.0033092855575628,0.0030341629678729,0.0027573087389614,0.0024788809015132,0.0021990384039791,0.0019179410448259,0.0016357494407182,0.0013526251106364,0.0010687310081008,0.0007842343141927,0.0004993266910789,0.0002145560001988};
static const double pts131[131] = {-0.9998327864528976,-0.9991190665976861,-0.9978354573851936,-0.9959824061125837,-0.9935609354100403,-0.9905724189232886,-0.9870185594926107,-0.9829013842598185,-0.9782232424690480,-0.9729868037793002,-0.9671950566059270,-0.9608513063561259,-0.9539591735142766,-0.9465225915611470,-0.9385458047210608,-0.9300333655350815,-0.9209901322600605,-0.9114212660942332,-0.9013322282305185,-0.8907287767389765,-0.8796169632800576,-0.8680031296504375,-0.8558939041633667,-0.8432961978655520,-0.8302172005927339,-0.8166643768661690,-0.8026454616323759,-0.7881684558485463,-0.7732416219161606,-0.7578734789653890,-0.7420727979929833,-0.7258485968564249,-0.7092101351271844,-0.6921669088060352,-0.6747286449034299,-0.6569052958880394,-0.6387070340066090,-0.6201442454783974,-0.6012275245674830,-0.5819676675363387,-0.5623756664841295,-0.5424627030732254,-0.5222401421475436,-0.5017195252463297,-0.4809125640171044,-0.4598311335315205,-0.4384872655079552,-0.4168931414446861,-0.3950610856676036,-0.3730035582963934,-0.3507331481332246,-0.3282625654779948,-0.3056046348742277,-0.2827722877897776,-0.2597785552365058,-0.2366365603331419,-0.2133595108155814,-0.1899606914988864,-0.1664534566953009,-0.1428512225925949,-0.1191674595971010,-0.0954156846458034,-0.0716094534918719,-0.0477623529680418,-0.0238879932322571,-0.0000000000000001,0.0238879932322568,0.0477623529680421,0.0716094534918721,0.0954156846458040,0.1191674595971011,0.1428512225925950,0.1664534566953007,0.1899606914988862,0.2133595108155811,0.2366365603331417,0.2597785552365055,0.2827722877897768,0.3056046348742267,0.3282625654779939,0.3507331481332241,0.3730035582963925,0.3950610856676027,0.4168931414446849,0.4384872655079547,0.4598311335315210,0.4809125640171034,0.5017195252463291,0.5222401421475436,0.5424627030732259,0.5623756664841292,0.5819676675363391,0.6012275245674830,0.6201442454783974,0.6387070340066096,0.6569052958880388,0.6747286449034302,0.6921669088060352,0.7092101351271841,0.7258485968564248,0.7420727979929834,0.7578734789653887,0.7732416219161606,0.7881684558485461,0.8026454616323753,0.8166643768661693,0.8302172005927333,0.8432961978655520,0.8558939041633666,0.8680031296504384,0.8796169632800577,0.8907287767389765,0.9013322282305186,0.9114212660942335,0.9209901322600614,0.9300333655350819,0.9385458047210613,0.9465225915611472,0.9539591735142771,0.9608513063561264,0.9671950566059279,0.9729868037793008,0.9782232424690483,0.9829013842598184,0.9870185594926112,0.9905724189232887,0.9935609354100406,0.9959824061125843,0.9978354573851945,0.9991190665976866,0.9998327864528982};

static const double w132[132] = {0.0002113298325742,0.0004918203338721,0.0007724499271386,0.0010526813945353,0.0013323283536530,0.0016112285248031,0.0018892237793442,0.0021661573859670,0.0024418734837772,0.0027162169967831,0.0029890336625690,0.0032601700963977,0.0035294738677347,0.0037967935814042,0.0040619789604442,0.0043248809293844,0.0045853516973928,0.0048432448409725,0.0050984153860431,0.0053507198892955,0.0056000165187430,0.0058461651333855,0.0060890273619583,0.0063284666806825,0.0065643484900011,0.0067965401902224,0.0070249112560581,0.0072493333099851,0.0074696801944093,0.0076858280425857,0.0078976553482372,0.0081050430338634,0.0083078745176777,0.0085060357791370,0.0086994154230428,0.0088879047421556,0.0090713977783072,0.0092497913819610,0.0094229852701998,0.0095908820830944,0.0097533874384391,0.0099104099848031,0.0100618614528852,0.0102076567051367,0.0103477137836128,0.0104819539560532,0.0106103017601362,0.0107326850459013,0.0108490350163058,0.0109592862658996,0.0110633768175938,0.0111612481575003,0.0112528452678218,0.0113381166577840,0.0114170143925783,0.0114894941203096,0.0115555150969267,0.0116150402091279,0.0116680359952230,0.0117144726639429,0.0117543241111895,0.0117875679347079,0.0118141854466779,0.0118341616842227,0.0118474854178192,0.0118541491576081,0.0118541491576077,0.0118474854178194,0.0118341616842228,0.0118141854466780,0.0117875679347080,0.0117543241111903,0.0117144726639429,0.0116680359952227,0.0116150402091277,0.0115555150969269,0.0114894941203093,0.0114170143925781,0.0113381166577842,0.0112528452678218,0.0111612481575002,0.0110633768175943,0.0109592862658997,0.0108490350163058,0.0107326850459012,0.0106103017601363,0.0104819539560535,0.0103477137836128,0.0102076567051367,0.0100618614528853,0.0099104099848026,0.0097533874384384,0.0095908820830947,0.0094229852701997,0.0092497913819616,0.0090713977783071,0.0088879047421561,0.0086994154230426,0.0085060357791371,0.0083078745176779,0.0081050430338636,0.0078976553482371,0.0076858280425861,0.0074696801944094,0.0072493333099842,0.0070249112560580,0.0067965401902225,0.0065643484900012,0.0063284666806831,0.0060890273619576,0.0058461651333862,0.0056000165187431,0.0053507198892957,0.0050984153860427,0.0048432448409721,0.0045853516973930,0.0043248809293840,0.0040619789604438,0.0037967935814046,0.0035294738677345,0.0032601700963984,0.0029890336625686,0.0027162169967833,0.0024418734837772,0.0021661573859666,0.0018892237793440,0.0016112285248028,0.0013323283536533,0.0010526813945354,0.0007724499271383,0.0004918203338720,0.0002113298325745};
static const double pts132[132] = {-0.9998353008255637,-0.9991323115489609,-0.9978679947094029,-0.9960427800339634,-0.9936576591279315,-0.9907139645482466,-0.9872133483338157,-0.9831577772146497,-0.9785495304796948,-0.9733911983540781,-0.9676856804101843,-0.9614361838796346,-0.9546462218225924,-0.9473196111386554,-0.9394604704134283,-0.9310732175988277,-0.9221625675268996,-0.9127335292577540,-0.9027914032627016,-0.8923417784439360,-0.8813905289923014,-0.8699438110848308,-0.8580080594238639,-0.8455899836196606,-0.8326965644185148,-0.8193350497784883,-0.8055129507949464,-0.7912380374781969,-0.7765183343855868,-0.7613621161105159,-0.7457779026309036,-0.7297744545197156,-0.7133607680202450,-0.6965460699889193,-0.6793398127084684,-0.6617516685743718,-0.6437915246575722,-0.6254694771465149,-0.6067958256716305,-0.5877810675154551,-0.5684358917116415,-0.5487711730361826,-0.5287979658942159,-0.5085274981058565,-0.4879711645945392,-0.4671405209814337,-0.4460472770895119,-0.4247032903609479,-0.4031205591915203,-0.3813112161857901,-0.3592875213368203,-0.3370618551343020,-0.3146467116049267,-0.2920546912889487,-0.2692984941568623,-0.2463909124701903,-0.2233448235903880,-0.2001731827399125,-0.1768890157195172,-0.1535054115858799,-0.1300355152936628,-0.1064925203061551,-0.0828896611786452,-0.0592402061186947,-0.0355574495274950,-0.0118547045264938,0.0118547045264940,0.0355574495274960,0.0592402061186957,0.0828896611786454,0.1064925203061554,0.1300355152936634,0.1535054115858809,0.1768890157195177,0.2001731827399124,0.2233448235903879,0.2463909124701899,0.2692984941568624,0.2920546912889485,0.3146467116049270,0.3370618551343023,0.3592875213368208,0.3813112161857901,0.4031205591915202,0.4247032903609469,0.4460472770895115,0.4671405209814336,0.4879711645945400,0.5085274981058570,0.5287979658942162,0.5487711730361817,0.5684358917116407,0.5877810675154543,0.6067958256716304,0.6254694771465147,0.6437915246575724,0.6617516685743721,0.6793398127084694,0.6965460699889203,0.7133607680202452,0.7297744545197153,0.7457779026309042,0.7613621161105163,0.7765183343855872,0.7912380374781974,0.8055129507949462,0.8193350497784880,0.8326965644185147,0.8455899836196603,0.8580080594238637,0.8699438110848303,0.8813905289923012,0.8923417784439356,0.9027914032627008,0.9127335292577535,0.9221625675268997,0.9310732175988282,0.9394604704134284,0.9473196111386558,0.9546462218225922,0.9614361838796339,0.9676856804101844,0.9733911983540775,0.9785495304796946,0.9831577772146488,0.9872133483338151,0.9907139645482457,0.9936576591279311,0.9960427800339633,0.9978679947094029,0.9991323115489609,0.9998353008255630};

static const double w133[133] = {0.0002081758855469,0.0004844819611200,0.0007609291155627,0.0010369904654677,0.0013124847194226,0.0015872543192924,0.0018611457837631,0.0021340069931545,0.0024056866678257,0.0026760342814029,0.0029449000865031,0.0032121351753851,0.0034775915528465,0.0037411222137163,0.0040025812220419,0.0042618237907218,0.0045187063610337,0.0047730866817539,0.0050248238877047,0.0052737785776214,0.0055198128912574,0.0057627905856672,0.0060025771106121,0.0062390396830478,0.0064720473606284,0.0067014711142071,0.0069271838992782,0.0071490607263216,0.0073669787300115,0.0075808172372481,0.0077904578339825,0.0079957844307821,0.0081966833271187,0.0083930432743267,0.0085847555372050,0.0087717139542356,0.0089538149963614,0.0091309578243221,0.0093030443444941,0.0094699792632020,0.0096316701394986,0.0097880274363475,0.0099389645702051,0.0100843979589700,0.0102242470682603,0.0103584344560183,0.0104868858153865,0.0106095300158601,0.0107262991426740,0.0108371285344119,0.0109419568188092,0.0110407259467460,0.0111333812243801,0.0112198713434491,0.0113001484096674,0.0113741679692573,0.0114418890335632,0.0115032741017493,0.0115582891815638,0.0116069038081655,0.0116490910609913,0.0116848275786654,0.0117140935719342,0.0117368728346255,0.0117531527526223,0.0117629243108493,0.0117661820982633,0.0117629243108492,0.0117531527526230,0.0117368728346255,0.0117140935719341,0.0116848275786658,0.0116490910609913,0.0116069038081661,0.0115582891815641,0.0115032741017493,0.0114418890335634,0.0113741679692568,0.0113001484096670,0.0112198713434495,0.0111333812243809,0.0110407259467452,0.0109419568188093,0.0108371285344108,0.0107262991426739,0.0106095300158603,0.0104868858153869,0.0103584344560180,0.0102242470682607,0.0100843979589694,0.0099389645702060,0.0097880274363479,0.0096316701394991,0.0094699792632021,0.0093030443444938,0.0091309578243224,0.0089538149963613,0.0087717139542356,0.0085847555372056,0.0083930432743259,0.0081966833271187,0.0079957844307824,0.0077904578339820,0.0075808172372481,0.0073669787300111,0.0071490607263215,0.0069271838992781,0.0067014711142066,0.0064720473606285,0.0062390396830488,0.0060025771106121,0.0057627905856669,0.0055198128912576,0.0052737785776218,0.0050248238877049,0.0047730866817542,0.0045187063610340,0.0042618237907219,0.0040025812220416,0.0037411222137163,0.0034775915528461,0.0032121351753855,0.0029449000865032,0.0026760342814027,0.0024056866678254,0.0021340069931535,0.0018611457837633,0.0015872543192932,0.0013124847194225,0.0010369904654673,0.0007609291155621,0.0004844819611203,0.0002081758855471};
static const double pts133[133] = {-0.9998377589097495,-0.9991452600354491,-0.9978998039457668,-0.9961018035109384,-0.9937522204672895,-0.9908523478049005,-0.9874037886403362,-0.9834084515244051,-0.9788685483740385,-0.9737865929110661,-0.9681653991393764,-0.9620080797294669,-0.9553180442674462,-0.9480989973529027,-0.9403549365398077,-0.9320901501184635,-0.9233092147382226,-0.9140169928715257,-0.9042186301202528,-0.8939195523656437,-0.8831254627632308,-0.8718423385843830,-0.8600764279061462,-0.8478342461511809,-0.8351225724797097,-0.8219484460354416,-0.8083191620475558,-0.7942422677908875,-0.7797255584065572,-0.7647770725853483,-0.7494050881162276,-0.7336181173024657,-0.7174249022478976,-0.7008344100159352,-0.6838558276640080,-0.6664985571561829,-0.6487722101567793,-0.6306866027078651,-0.6122517497935744,-0.5934778597942637,-0.5743753288335761,-0.5549547350215386,-0.5352268325968840,-0.5152025459718439,-0.4948929636827094,-0.4743093322495003,-0.4534630499481538,-0.4323656604986820,-0.4110288466727871,-0.3894644238244676,-0.3676843333472197,-0.3457006360614377,-0.3235255055356785,-0.3011712213454966,-0.2786501622735765,-0.2559747994549220,-0.2331576894709156,-0.2102114673960555,-0.1871488398012250,-0.1639825777173756,-0.1407255095635117,-0.1173905140428972,-0.0939905130114160,-0.0705384643220408,-0.0470473546493610,-0.0235301922981588,-0.0000000000000004,0.0235301922981589,0.0470473546493607,0.0705384643220405,0.0939905130114159,0.1173905140428968,0.1407255095635118,0.1639825777173762,0.1871488398012253,0.2102114673960555,0.2331576894709158,0.2559747994549222,0.2786501622735768,0.3011712213454973,0.3235255055356788,0.3457006360614382,0.3676843333472202,0.3894644238244678,0.4110288466727879,0.4323656604986832,0.4534630499481536,0.4743093322495002,0.4948929636827098,0.5152025459718439,0.5352268325968830,0.5549547350215384,0.5743753288335761,0.5934778597942637,0.6122517497935738,0.6306866027078646,0.6487722101567797,0.6664985571561830,0.6838558276640084,0.7008344100159352,0.7174249022478982,0.7336181173024660,0.7494050881162282,0.7647770725853485,0.7797255584065571,0.7942422677908875,0.8083191620475555,0.8219484460354420,0.8351225724797098,0.8478342461511811,0.8600764279061468,0.8718423385843834,0.8831254627632306,0.8939195523656436,0.9042186301202537,0.9140169928715258,0.9233092147382225,0.9320901501184634,0.9403549365398081,0.9480989973529028,0.9553180442674464,0.9620080797294674,0.9681653991393764,0.9737865929110665,0.9788685483740384,0.9834084515244046,0.9874037886403362,0.9908523478048994,0.9937522204672894,0.9961018035109372,0.9978998039457667,0.9991452600354491,0.9998377589097492};

static const double w134[134] = {0.0002050920195049,0.0004773065980082,0.0007496640791252,0.0010216476164610,0.0012930808290110,0.0015638107082365,0.0018336882503740,0.0021025657790417,0.0023702964289525,0.0026367340580147,0.0029017332702939,0.0031651494733823,0.0034268389478662,0.0036866589213410,0.0039444676441078,0.0042001244653503,0.0044534899092241,0.0047044257505793,0.0049527950901444,0.0051984624290807,0.0054412937428117,0.0056811565540865,0.0059179200052143,0.0061514549294303,0.0063816339213414,0.0066083314064242,0.0068314237095213,0.0070507891223052,0.0072663079696740,0.0074778626750354,0.0076853378244467,0.0078886202295823,0.0080875989894757,0.0082821655510227,0.0084722137682057,0.0086576399599959,0.0088383429669172,0.0090142242062368,0.0091851877257402,0.0093511402560865,0.0095119912616831,0.0096676529900820,0.0098180405198507,0.0099630718069041,0.0101026677292613,0.0102367521302098,0.0103652518598555,0.0104880968150280,0.0106052199775242,0.0107165574506725,0.0108220484941925,0.0109216355573266,0.0110152643102433,0.0111028836736711,0.0111844458467718,0.0112599063332097,0.0113292239654331,0.0113923609271321,0.0114492827738671,0.0114999584518621,0.0115443603149440,0.0115824641396282,0.0116142491383312,0.0116396979707104,0.0116587967531293,0.0116715350662250,0.0116779059605975,0.0116779059605982,0.0116715350662254,0.0116587967531298,0.0116396979707106,0.0116142491383306,0.0115824641396276,0.0115443603149441,0.0114999584518618,0.0114492827738671,0.0113923609271323,0.0113292239654332,0.0112599063332095,0.0111844458467717,0.0111028836736719,0.0110152643102430,0.0109216355573267,0.0108220484941922,0.0107165574506731,0.0106052199775239,0.0104880968150274,0.0103652518598562,0.0102367521302099,0.0101026677292610,0.0099630718069042,0.0098180405198504,0.0096676529900811,0.0095119912616835,0.0093511402560868,0.0091851877257404,0.0090142242062367,0.0088383429669172,0.0086576399599955,0.0084722137682059,0.0082821655510224,0.0080875989894751,0.0078886202295830,0.0076853378244473,0.0074778626750346,0.0072663079696739,0.0070507891223049,0.0068314237095210,0.0066083314064245,0.0063816339213416,0.0061514549294301,0.0059179200052146,0.0056811565540858,0.0054412937428122,0.0051984624290808,0.0049527950901441,0.0047044257505790,0.0044534899092243,0.0042001244653502,0.0039444676441088,0.0036866589213412,0.0034268389478667,0.0031651494733820,0.0029017332702937,0.0026367340580145,0.0023702964289522,0.0021025657790415,0.0018336882503743,0.0015638107082363,0.0012930808290110,0.0010216476164609,0.0007496640791258,0.0004773065980081,0.0002050920195050};
static const double pts134[134] = {-0.9998401623731366,-0.9991579208389498,-0.9979309066540872,-0.9961595165123527,-0.9938446833859217,-0.9909876621528412,-0.9875900088036121,-0.9836535758441988,-0.9791805102891247,-0.9741732521587938,-0.9686345330194169,-0.9625673744364684,-0.9559750862993311,-0.9488612650017352,-0.9412297914721925,-0.9330848290524323,-0.9244308212234985,-0.9152724891800135,-0.9056148292534978,-0.8954631101859519,-0.8848228702550328,-0.8736999142523346,-0.8621003103163626,-0.8500303866218960,-0.8374967279275339,-0.8245061719832939,-0.8110658058002045,-0.7971829617839366,-0.7828652137345643,-0.7681203727146410,-0.7529564827878509,-0.7373818166305376,-0.7214048710185273,-0.7050343621916944,-0.6882792210987945,-0.6711485885251719,-0.6536518101059884,-0.6357984312276969,-0.6175981918205423,-0.5990610210449265,-0.5801970318745471,-0.5610165155792419,-0.5415299361105860,-0.5217479243932566,-0.5016812725253320,-0.4813409278906395,-0.4607379871864032,-0.4398836903694255,-0.4187894145241147,-0.3974666676557061,-0.3759270824120587,-0.3541824097374418,-0.3322445124618033,-0.3101253588289868,-0.2878370159674413,-0.2653916433069866,-0.2428014859452230,-0.2200788679672052,-0.1972361857220223,-0.1742859010599587,-0.1512405345339145,-0.1281126585688068,-0.1049148906026675,-0.0816598862031869,-0.0583603321634545,-0.0350289395806653,-0.0116784369215679,0.0116784369215685,0.0350289395806660,0.0583603321634547,0.0816598862031870,0.1049148906026674,0.1281126585688072,0.1512405345339146,0.1742859010599588,0.1972361857220226,0.2200788679672047,0.2428014859452226,0.2653916433069861,0.2878370159674410,0.3101253588289865,0.3322445124618034,0.3541824097374410,0.3759270824120583,0.3974666676557064,0.4187894145241138,0.4398836903694248,0.4607379871864031,0.4813409278906394,0.5016812725253318,0.5217479243932566,0.5415299361105851,0.5610165155792423,0.5801970318745463,0.5990610210449266,0.6175981918205417,0.6357984312276966,0.6536518101059882,0.6711485885251717,0.6882792210987946,0.7050343621916946,0.7214048710185281,0.7373818166305377,0.7529564827878509,0.7681203727146407,0.7828652137345639,0.7971829617839369,0.8110658058002047,0.8245061719832939,0.8374967279275342,0.8500303866218962,0.8621003103163629,0.8736999142523352,0.8848228702550329,0.8954631101859514,0.9056148292534982,0.9152724891800132,0.9244308212234986,0.9330848290524326,0.9412297914721928,0.9488612650017355,0.9559750862993320,0.9625673744364690,0.9686345330194173,0.9741732521587942,0.9791805102891250,0.9836535758441984,0.9875900088036123,0.9909876621528411,0.9938446833859225,0.9961595165123526,0.9979309066540867,0.9991579208389499,0.9998401623731367};

static const double w135[135] = {0.0002020761734873,0.0004702894525086,0.0007386473038575,0.0010066426319356,0.0012741037933121,0.0015408821645689,0.0018068330571085,0.0020718130768266,0.0023356796131226,0.0025982907499999,0.0028595052864262,0.0031191827906024,0.0033771836661708,0.0036333692229253,0.0038876017492041,0.0041397445847733,0.0043896621936533,0.0046372202366076,0.0048822856431364,0.0051247266828730,0.0053644130363050,0.0056012158647680,0.0058350078796662,0.0060656634108679,0.0062930584742351,0.0065170708382626,0.0067375800897690,0.0069544676986148,0.0071676170814140,0.0073769136641966,0.0075822449439916,0.0077835005492994,0.0079805722994193,0.0081733542625965,0.0083617428129643,0.0085456366862463,0.0087249370341830,0.0088995474776714,0.0090693741585686,0.0092343257901436,0.0093943137061418,0.0095492519084558,0.0096990571133388,0.0098436487961834,0.0099829492347976,0.0101168835511880,0.0102453797518044,0.0103683687662429,0.0104857844843693,0.0105975637918562,0.0107036466041116,0.0108039758985715,0.0108984977453533,0.0109871613362459,0.0110699190120197,0.0111467262880420,0.0112175418781931,0.0112823277170575,0.0113410489803824,0.0113936741037995,0.0114401747997920,0.0114805260728977,0.0115147062331479,0.0115426969077224,0.0115644830508292,0.0115800529517893,0.0115893982413335,0.0115925138960995,0.0115893982413338,0.0115800529517892,0.0115644830508298,0.0115426969077229,0.0115147062331480,0.0114805260728985,0.0114401747997919,0.0113936741037995,0.0113410489803821,0.0112823277170571,0.0112175418781933,0.0111467262880421,0.0110699190120191,0.0109871613362461,0.0108984977453535,0.0108039758985714,0.0107036466041116,0.0105975637918565,0.0104857844843693,0.0103683687662426,0.0102453797518043,0.0101168835511879,0.0099829492347979,0.0098436487961831,0.0096990571133391,0.0095492519084555,0.0093943137061423,0.0092343257901428,0.0090693741585697,0.0088995474776715,0.0087249370341833,0.0085456366862457,0.0083617428129649,0.0081733542625963,0.0079805722994193,0.0077835005492990,0.0075822449439913,0.0073769136641968,0.0071676170814145,0.0069544676986145,0.0067375800897687,0.0065170708382628,0.0062930584742351,0.0060656634108679,0.0058350078796669,0.0056012158647683,0.0053644130363045,0.0051247266828733,0.0048822856431361,0.0046372202366072,0.0043896621936534,0.0041397445847738,0.0038876017492039,0.0036333692229248,0.0033771836661702,0.0031191827906031,0.0028595052864270,0.0025982907499996,0.0023356796131220,0.0020718130768267,0.0018068330571086,0.0015408821645693,0.0012741037933123,0.0010066426319355,0.0007386473038572,0.0004702894525085,0.0002020761734872};
static const double pts135[135] = {-0.9998425128221000,-0.9991703024185039,-0.9979613236020991,-0.9962159575395434,-0.9939351094951610,-0.9911199976261157,-0.9877721325145961,-0.9838933126628359,-0.9794856225447794,-0.9745514311591065,-0.9690933906288151,-0.9631144347201227,-0.9566177772389431,-0.9496069102897272,-0.9420856023909248,-0.9340578964450351,-0.9255281075628864,-0.9165008207425676,-0.9069808884038556,-0.8969734277792378,-0.8864838181628093,-0.8755176980184456,-0.8640809619487489,-0.8521797575263795,-0.8398204819894504,-0.8270097788027428,-0.8137545340865953,-0.8000618729153715,-0.7859391554874909,-0.7713939731690851,-0.7564341444133983,-0.7410677105581311,-0.7253029315029730,-0.7091482812696609,-0.6926124434469428,-0.6757043065228862,-0.6584329591070616,-0.6408076850451450,-0.6228379584285825,-0.6045334385019883,-0.5859039644710226,-0.5669595502135332,-0.5477103788968058,-0.5281667975038170,-0.5083393112714335,-0.4882385780435452,-0.4678754025421615,-0.4472607305595678,-0.4264056430746423,-0.4053213502965149,-0.3840191856387539,-0.3625105996273296,-0.3408071537456290,-0.3189205142198245,-0.2968624457479421,-0.2746448051759968,-0.2522795351245976,-0.2297786575694451,-0.2071542673791741,-0.1844185258140122,-0.1615836539887548,-0.1386619263035622,-0.1156656638461187,-0.0926072277686913,-0.0694990126436579,-0.0463534398010633,-0.0231829506518025,-0.0000000000000001,0.0231829506518030,0.0463534398010642,0.0694990126436582,0.0926072277686920,0.1156656638461190,0.1386619263035618,0.1615836539887542,0.1844185258140117,0.2071542673791738,0.2297786575694455,0.2522795351245972,0.2746448051759965,0.2968624457479417,0.3189205142198244,0.3408071537456289,0.3625105996273294,0.3840191856387536,0.4053213502965148,0.4264056430746419,0.4472607305595667,0.4678754025421605,0.4882385780435448,0.5083393112714342,0.5281667975038169,0.5477103788968051,0.5669595502135327,0.5859039644710220,0.6045334385019877,0.6228379584285819,0.6408076850451452,0.6584329591070612,0.6757043065228855,0.6926124434469423,0.7091482812696601,0.7253029315029728,0.7410677105581305,0.7564341444133982,0.7713939731690845,0.7859391554874907,0.8000618729153717,0.8137545340865953,0.8270097788027421,0.8398204819894503,0.8521797575263791,0.8640809619487487,0.8755176980184454,0.8864838181628099,0.8969734277792378,0.9069808884038562,0.9165008207425678,0.9255281075628864,0.9340578964450353,0.9420856023909253,0.9496069102897277,0.9566177772389431,0.9631144347201231,0.9690933906288155,0.9745514311591071,0.9794856225447801,0.9838933126628363,0.9877721325145962,0.9911199976261167,0.9939351094951614,0.9962159575395437,0.9979613236020994,0.9991703024185045,0.9998425128221005};

static const double w136[136] = {0.0001991263617404,0.0004634259073833,0.0007278715496394,0.0009919656681864,0.0012555411916991,0.0015184537245036,0.0017805627378028,0.0020417289656986,0.0023018138994745,0.0025606796978332,0.0028181892047926,0.0030742060010210,0.0033285944669604,0.0035812198503913,0.0038319483356850,0.0040806471135622,0.0043271844508109,0.0045714297597081,0.0048132536669751,0.0050525280821669,0.0052891262654421,0.0055229228946331,0.0057537941315943,0.0059816176877710,0.0062062728889576,0.0064276407392021,0.0066456039838303,0.0068600471715447,0.0070708567155744,0.0072779209538368,0.0074811302080770,0.0076803768419663,0.0078755553181080,0.0080665622539421,0.0082532964764997,0.0084356590759982,0.0086135534582237,0.0087868853957022,0.0089555630776045,0.0091194971583788,0.0092786008050762,0.0094327897433412,0.0095819823020520,0.0097260994565828,0.0098650648706563,0.0099988049367803,0.0101272488152383,0.0102503284716071,0.0103679787127982,0.0104801372215864,0.0105867445896182,0.0106877443488821,0.0107830830016133,0.0108727100486376,0.0109565780161128,0.0110346424806803,0.0111068620929921,0.0111731985996127,0.0112336168632849,0.0112880848815355,0.0113365738036330,0.0113790579458635,0.0114155148051381,0.0114459250709131,0.0114702726354145,0.0114885446021738,0.0115007312928578,0.0115068262523953,0.0115068262523957,0.0115007312928580,0.0114885446021734,0.0114702726354139,0.0114459250709127,0.0114155148051388,0.0113790579458637,0.0113365738036329,0.0112880848815355,0.0112336168632844,0.0111731985996132,0.0111068620929917,0.0110346424806807,0.0109565780161135,0.0108727100486378,0.0107830830016135,0.0106877443488819,0.0105867445896185,0.0104801372215864,0.0103679787127983,0.0102503284716074,0.0101272488152382,0.0099988049367800,0.0098650648706561,0.0097260994565827,0.0095819823020523,0.0094327897433408,0.0092786008050759,0.0091194971583792,0.0089555630776044,0.0087868853957023,0.0086135534582240,0.0084356590759978,0.0082532964764996,0.0080665622539417,0.0078755553181082,0.0076803768419661,0.0074811302080777,0.0072779209538364,0.0070708567155749,0.0068600471715446,0.0066456039838300,0.0064276407392023,0.0062062728889576,0.0059816176877714,0.0057537941315938,0.0055229228946332,0.0052891262654420,0.0050525280821670,0.0048132536669743,0.0045714297597084,0.0043271844508112,0.0040806471135625,0.0038319483356859,0.0035812198503906,0.0033285944669604,0.0030742060010213,0.0028181892047926,0.0025606796978337,0.0023018138994745,0.0020417289656983,0.0017805627378031,0.0015184537245041,0.0012555411916989,0.0009919656681865,0.0007278715496390,0.0004634259073832,0.0001991263617400};
static const double pts136[136] = {-0.9998448118043923,-0.9991824129245248,-0.9979910748001350,-0.9962711636905115,-0.9940235581623769,-0.9912494409827258,-0.9879502789686140,-0.9841278185711499,-0.9797840839831754,-0.9749213757453538,-0.9695422694024518,-0.9636496140844333,-0.9572465309711641,-0.9503364116257427,-0.9429229161907206,-0.9350099714451932,-0.9266017687223467,-0.9177027616878386,-0.9083176639797765,-0.8984514467113379,-0.8881093358372254,-0.8772968093852720,-0.8660195945546169,-0.8542836646819616,-0.8420952360774897,-0.8294607647321237,-0.8163869428978366,-0.8028806955428472,-0.7889491766835541,-0.7745997655951492,-0.7598400629029347,-0.7446778865563874,-0.7291212676881224,-0.7131784463599325,-0.6968578671981683,-0.6801681749207662,-0.6631182097582888,-0.6457170027714094,-0.6279737710673187,-0.6098979129175827,-0.5914990027800484,-0.5727867862274201,-0.5537711747852022,-0.5344622406817428,-0.5148702115131523,-0.4950054648259275,-0.4748785226201520,-0.4545000457761783,-0.4338808284077545,-0.4130317921445670,-0.3919639803472580,-0.3706885522579486,-0.3492167770893912,-0.3275600280558666,-0.3057297763489990,-0.2837375850616688,-0.2615951030632506,-0.2393140588294153,-0.2169062542297659,-0.1943835582766005,-0.1717579008381081,-0.1490412663193313,-0.1262456873142412,-0.1033832382322880,-0.0804660289028041,-0.0575061981606441,-0.0345159074164590,-0.0115073342150184,0.0115073342150183,0.0345159074164588,0.0575061981606437,0.0804660289028045,0.1033832382322877,0.1262456873142409,0.1490412663193312,0.1717579008381081,0.1943835582766007,0.2169062542297659,0.2393140588294151,0.2615951030632507,0.2837375850616695,0.3057297763489991,0.3275600280558662,0.3492167770893904,0.3706885522579479,0.3919639803472569,0.4130317921445663,0.4338808284077539,0.4545000457761786,0.4748785226201521,0.4950054648259282,0.5148702115131525,0.5344622406817428,0.5537711747852019,0.5727867862274196,0.5914990027800487,0.6098979129175826,0.6279737710673184,0.6457170027714100,0.6631182097582892,0.6801681749207665,0.6968578671981686,0.7131784463599324,0.7291212676881222,0.7446778865563870,0.7598400629029340,0.7745997655951494,0.7889491766835539,0.8028806955428482,0.8163869428978363,0.8294607647321234,0.8420952360774898,0.8542836646819616,0.8660195945546172,0.8772968093852719,0.8881093358372252,0.8984514467113371,0.9083176639797765,0.9177027616878387,0.9266017687223470,0.9350099714451930,0.9429229161907209,0.9503364116257431,0.9572465309711637,0.9636496140844332,0.9695422694024520,0.9749213757453535,0.9797840839831757,0.9841278185711499,0.9879502789686141,0.9912494409827262,0.9940235581623771,0.9962711636905116,0.9979910748001352,0.9991824129245256,0.9998448118043924};

static const double w137[137] = {0.0001962406704472,0.0004567115125887,0.0007173298383152,0.0009776072372647,0.0012373810517490,0.0014965109632131,0.0017548604539580,0.0020122942388154,0.0022686777646896,0.0025238771200293,0.0027777590504125,0.0030301910071056,0.0032810412072476,0.0035301786984354,0.0037774734249882,0.0040227962947318,0.0042660192457673,0.0045070153129700,0.0047456586940524,0.0049818248151034,0.0052153903955326,0.0054462335123701,0.0056742336638761,0.0058992718324156,0.0061212305465754,0.0063399939424676,0.0065554478242031,0.0067674797235007,0.0069759789583881,0.0071808366909761,0.0073819459842706,0.0075792018579915,0.0077725013433720,0.0079617435369099,0.0081468296530339,0.0083276630756753,0.0085041494086989,0.0086761965251767,0.0088437146154811,0.0090066162341629,0.0091648163456015,0.0093182323683909,0.0094667842184492,0.0096103943508215,0.0097489878001611,0.0098824922198575,0.0100108379198076,0.0101339579027877,0.0102517878994331,0.0103642664017808,0.0104713346953830,0.0105729368899488,0.0106690199485300,0.0107595337151935,0.0108444309412160,0.0109236673097366,0.0109972014588997,0.0110649950034414,0.0111270125547262,0.0111832217392236,0.0112335932154035,0.0112781006890548,0.0113167209270116,0.0113494337692791,0.0113762221395586,0.0113970720541613,0.0114119726293080,0.0114209160868081,0.0114238977581255,0.0114209160868084,0.0114119726293081,0.0113970720541614,0.0113762221395584,0.0113494337692797,0.0113167209270116,0.0112781006890547,0.0112335932154033,0.0111832217392232,0.0111270125547264,0.0110649950034416,0.0109972014588996,0.0109236673097362,0.0108444309412156,0.0107595337151934,0.0106690199485298,0.0105729368899499,0.0104713346953824,0.0103642664017811,0.0102517878994325,0.0101339579027879,0.0100108379198073,0.0098824922198576,0.0097489878001616,0.0096103943508221,0.0094667842184495,0.0093182323683907,0.0091648163456016,0.0090066162341631,0.0088437146154810,0.0086761965251766,0.0085041494086989,0.0083276630756752,0.0081468296530340,0.0079617435369093,0.0077725013433718,0.0075792018579913,0.0073819459842712,0.0071808366909763,0.0069759789583875,0.0067674797235010,0.0065554478242026,0.0063399939424671,0.0061212305465756,0.0058992718324163,0.0056742336638753,0.0054462335123701,0.0052153903955321,0.0049818248151034,0.0047456586940534,0.0045070153129698,0.0042660192457668,0.0040227962947317,0.0037774734249886,0.0035301786984351,0.0032810412072473,0.0030301910071055,0.0027777590504124,0.0025238771200298,0.0022686777646896,0.0020122942388152,0.0017548604539582,0.0014965109632136,0.0012373810517488,0.0009776072372645,0.0007173298383155,0.0004567115125890,0.0001962406704468};
static const double pts137[137] = {-0.9998470608116927,-0.9991942602122132,-0.9980201795340237,-0.9963251707208409,-0.9941100866083116,-0.9913760758465644,-0.9881245630598955,-0.9843572445168106,-0.9800760862913264,-0.9752833229196060,-0.9699814561101686,-0.9641732533840918,-0.9578617466045648,-0.9510502303809976,-0.9437422603419922,-0.9359416512751464,-0.9276524751332439,-0.9188790589071413,-0.9096259823660762,-0.8998980756663612,-0.8897004168295816,-0.8790383290915432,-0.8679173781233038,-0.8563433691257130,-0.8443223437989523,-0.8318605771886579,-0.8189645744102472,-0.8056410672531694,-0.7918970106668339,-0.7777395791300620,-0.7631761629059430,-0.7482143641840638,-0.7328619931121018,-0.7171270637188720,-0.7010177897309524,-0.6845425802850598,-0.6677100355384261,-0.6505289421794603,-0.6330082688410422,-0.6151571614188401,-0.5969849382970951,-0.5785010854843671,-0.5597152516617804,-0.5406372431463551,-0.5212770187720462,-0.5016446846911767,-0.4817504890989598,-0.4616048168838834,-0.4412181842067336,-0.4206012330110978,-0.3997647254682036,-0.3787195383590018,-0.3574766573964237,-0.3360471714907695,-0.3144422669612333,-0.2926732216965787,-0.2707513992680100,-0.2486882429973229,-0.2264952699834220,-0.2041840650903246,-0.1817662748997948,-0.1592536016317576,-0.1366577970356693,-0.1139906562560353,-0.0912640116752741,-0.0684897267371427,-0.0456796897539493,-0.0228458077007825,0.0000000000000005,0.0228458077007833,0.0456796897539500,0.0684897267371434,0.0912640116752743,0.1139906562560355,0.1366577970356701,0.1592536016317589,0.1817662748997957,0.2041840650903250,0.2264952699834223,0.2486882429973233,0.2707513992680102,0.2926732216965788,0.3144422669612338,0.3360471714907697,0.3574766573964236,0.3787195383590019,0.3997647254682034,0.4206012330110980,0.4412181842067338,0.4616048168838828,0.4817504890989595,0.5016446846911768,0.5212770187720465,0.5406372431463552,0.5597152516617807,0.5785010854843670,0.5969849382970958,0.6151571614188404,0.6330082688410424,0.6505289421794602,0.6677100355384259,0.6845425802850602,0.7010177897309527,0.7171270637188724,0.7328619931121018,0.7482143641840641,0.7631761629059427,0.7777395791300610,0.7918970106668343,0.8056410672531698,0.8189645744102474,0.8318605771886572,0.8443223437989522,0.8563433691257124,0.8679173781233038,0.8790383290915429,0.8897004168295809,0.8998980756663608,0.9096259823660759,0.9188790589071413,0.9276524751332436,0.9359416512751462,0.9437422603419910,0.9510502303809963,0.9578617466045635,0.9641732533840914,0.9699814561101685,0.9752833229196051,0.9800760862913259,0.9843572445168102,0.9881245630598949,0.9913760758465637,0.9941100866083112,0.9963251707208409,0.9980201795340238,0.9991942602122128,0.9998470608116927};

static const double w138[138] = {0.0001934172546239,0.0004501419780636,0.0007070154424021,0.0009635581916645,0.0012196118299890,0.0014750399717243,0.0017297099678998,0.0019834903728768,0.0022362504491199,0.0024878600760039,0.0027381897632302,0.0029871106967489,0.0032344947961548,0.0034802147764391,0.0037241442114188,0.0039661575976816,0.0042061304185591,0.0044439392078375,0.0046794616130731,0.0049125764584130,0.0051431638068578,0.0053711050219127,0.0055962828285940,0.0058185813737408,0.0060378862856034,0.0062540847326767,0.0064670654817416,0.0066767189550896,0.0068829372868969,0.0070856143787122,0.0072846459540471,0.0074799296120221,0.0076713648800477,0.0078588532655221,0.0080422983064953,0.0082216056213063,0.0083966829571366,0.0085674402374745,0.0087337896084601,0.0088956454840827,0.0090529245902180,0.0092055460074664,0.0093534312127938,0.0094965041199213,0.0096346911184809,0.0097679211118799,0.0098961255538850,0.0100192384838839,0.0101371965608275,0.0102499390958153,0.0103574080833184,0.0104595482310248,0.0105563069882881,0.0106476345731617,0.0107334839980135,0.0108138110937005,0.0108885745322928,0.0109577358483375,0.0110212594586476,0.0110791126806115,0.0111312657490070,0.0111776918313143,0.0112183670415231,0.0112532704524210,0.0112823841063592,0.0113056930244944,0.0113231852144923,0.0113348516766999,0.0113406864087763,0.0113406864087758,0.0113348516767001,0.0113231852144926,0.0113056930244939,0.0112823841063588,0.0112532704524205,0.0112183670415235,0.0111776918313141,0.0111312657490067,0.0110791126806113,0.0110212594586473,0.0109577358483373,0.0108885745322930,0.0108138110937007,0.0107334839980136,0.0106476345731618,0.0105563069882882,0.0104595482310250,0.0103574080833179,0.0102499390958152,0.0101371965608280,0.0100192384838839,0.0098961255538850,0.0097679211118804,0.0096346911184811,0.0094965041199213,0.0093534312127933,0.0092055460074667,0.0090529245902176,0.0088956454840827,0.0087337896084601,0.0085674402374749,0.0083966829571366,0.0082216056213063,0.0080422983064950,0.0078588532655222,0.0076713648800479,0.0074799296120218,0.0072846459540473,0.0070856143787123,0.0068829372868963,0.0066767189550902,0.0064670654817413,0.0062540847326764,0.0060378862856034,0.0058185813737412,0.0055962828285945,0.0053711050219125,0.0051431638068574,0.0049125764584126,0.0046794616130731,0.0044439392078377,0.0042061304185590,0.0039661575976821,0.0037241442114189,0.0034802147764397,0.0032344947961536,0.0029871106967488,0.0027381897632300,0.0024878600760038,0.0022362504491200,0.0019834903728774,0.0017297099678996,0.0014750399717243,0.0012196118299891,0.0009635581916652,0.0007070154424015,0.0004501419780630,0.0001934172546245};
static const double pts138[138] = {-0.9998492612820287,-0.9992058518542901,-0.9980486563963408,-0.9963780131015642,-0.9941947499995214,-0.9914999828422401,-0.9882950955663554,-0.9845817360464060,-0.9803618143074964,-0.9756375012301011,-0.9704112273115868,-0.9646856813626109,-0.9584638090983378,-0.9517488116098249,-0.9445441437099573,-0.9368535121518891,-0.9286808737194995,-0.9200304331901372,-0.9109066411703263,-0.9013141918053071,-0.8912580203635053,-0.8807433006970603,-0.8697754425797021,-0.8583600889232964,-0.8465031128744908,-0.8342106147929284,-0.8214889191125813,-0.8083445710878175,-0.7947843334258596,-0.7808151828073814,-0.7664443062970145,-0.7516790976456201,-0.7365271534862284,-0.7209962694255915,-0.7050944360333726,-0.6888298347310288,-0.6722108335824997,-0.6552459829888722,-0.6379440112892355,-0.6203138202699854,-0.6023644805848928,-0.5841052270882945,-0.5655454540837948,-0.5466947104909438,-0.5275626949323534,-0.5081592507438050,-0.4884943609098920,-0.4685781429278191,-0.4484208436020002,-0.4280328337721124,-0.4074246029773588,-0.3866067540596328,-0.3655899977084175,-0.3443851469501736,-0.3230031115850897,-0.3014548925740378,-0.2797515763786311,-0.2579043292572855,-0.2359243915202326,-0.2138230717464280,-0.1916117409653405,-0.1693018268066074,-0.1469048076205704,-0.1244322065727165,-0.1018955857150604,-0.0793065400375199,-0.0566766915023495,-0.0340176830646892,-0.0113411726823166,0.0113411726823170,0.0340176830646891,0.0566766915023495,0.0793065400375203,0.1018955857150599,0.1244322065727165,0.1469048076205706,0.1693018268066077,0.1916117409653406,0.2138230717464281,0.2359243915202323,0.2579043292572857,0.2797515763786309,0.3014548925740380,0.3230031115850893,0.3443851469501739,0.3655899977084177,0.3866067540596333,0.4074246029773584,0.4280328337721133,0.4484208436020001,0.4685781429278196,0.4884943609098916,0.5081592507438051,0.5275626949323533,0.5466947104909434,0.5655454540837945,0.5841052270882938,0.6023644805848929,0.6203138202699852,0.6379440112892351,0.6552459829888726,0.6722108335824992,0.6888298347310288,0.7050944360333725,0.7209962694255914,0.7365271534862289,0.7516790976456202,0.7664443062970144,0.7808151828073815,0.7947843334258599,0.8083445710878172,0.8214889191125815,0.8342106147929282,0.8465031128744909,0.8583600889232967,0.8697754425797017,0.8807433006970607,0.8912580203635058,0.9013141918053075,0.9109066411703264,0.9200304331901378,0.9286808737194989,0.9368535121518885,0.9445441437099572,0.9517488116098246,0.9584638090983383,0.9646856813626113,0.9704112273115865,0.9756375012301010,0.9803618143074960,0.9845817360464055,0.9882950955663553,0.9914999828422396,0.9941947499995212,0.9963780131015635,0.9980486563963401,0.9992058518542896,0.9998492612820279};

static const double w139[139] = {0.0001906543351728,0.0004437131668744,0.0006969218743632,0.0009498097097765,0.0012022223935976,0.0014540273349577,0.0017050956172703,0.0019552994991907,0.0022045119245797,0.0024526064307545,0.0026994571598579,0.0029449389022785,0.0031889271514021,0.0034312981626720,0.0036719290143076,0.0039106976685681,0.0041474830330491,0.0043821650217491,0.0046146246157645,0.0048447439235228,0.0050724062404891,0.0052974961083030,0.0055198993732938,0.0057395032443519,0.0059561963501122,0.0061698687954270,0.0063804122170869,0.0065877198387748,0.0067916865252101,0.0069922088354640,0.0071891850754188,0.0073825153493380,0.0075721016105294,0.0077578477110627,0.0079396594505372,0.0081174446238464,0.0082911130679454,0.0084605767075730,0.0086257495999197,0.0087865479782105,0.0089428902941913,0.0090946972594826,0.0092418918857862,0.0093843995239409,0.0095221479017675,0.0096550671607278,0.0097830898913553,0.0099061511674349,0.0100241885789346,0.0101371422636562,0.0102449549375922,0.0103475719239782,0.0104449411810234,0.0105370133282995,0.0106237416717877,0.0107050822275578,0.0107809937440739,0.0108514377231174,0.0109163784393059,0.0109757829582185,0.0110296211530912,0.0110778657201009,0.0111204921922083,0.0111574789515727,0.0111888072405059,0.0112144611709919,0.0112344277327457,0.0112486967998025,0.0112572611356650,0.0112601163969636,0.0112572611356649,0.0112486967998026,0.0112344277327451,0.0112144611709919,0.0111888072405057,0.0111574789515727,0.0111204921922087,0.0110778657201005,0.0110296211530911,0.0109757829582185,0.0109163784393063,0.0108514377231172,0.0107809937440743,0.0107050822275578,0.0106237416717875,0.0105370133282992,0.0104449411810222,0.0103475719239789,0.0102449549375919,0.0101371422636566,0.0100241885789349,0.0099061511674343,0.0097830898913547,0.0096550671607285,0.0095221479017673,0.0093843995239407,0.0092418918857867,0.0090946972594823,0.0089428902941920,0.0087865479782112,0.0086257495999193,0.0084605767075733,0.0082911130679452,0.0081174446238462,0.0079396594505369,0.0077578477110637,0.0075721016105292,0.0073825153493377,0.0071891850754182,0.0069922088354638,0.0067916865252097,0.0065877198387755,0.0063804122170872,0.0061698687954267,0.0059561963501121,0.0057395032443518,0.0055198993732945,0.0052974961083033,0.0050724062404894,0.0048447439235228,0.0046146246157646,0.0043821650217496,0.0041474830330489,0.0039106976685675,0.0036719290143072,0.0034312981626719,0.0031889271514022,0.0029449389022790,0.0026994571598572,0.0024526064307548,0.0022045119245796,0.0019552994991906,0.0017050956172703,0.0014540273349576,0.0012022223935975,0.0009498097097767,0.0006969218743625,0.0004437131668747,0.0001906543351728};
static const double pts139[139] = {-0.9998514146020706,-0.9992171951531054,-0.9980765233160926,-0.9964297240741311,-0.9942776015362101,-0.9916212397231891,-0.9884619833251931,-0.9848014335355020,-0.9806414463124254,-0.9759841311300310,-0.9708318497885015,-0.9651872151640000,-0.9590530898585163,-0.9524325847352428,-0.9453290573338962,-0.9377461101639377,-0.9296875888751756,-0.9211575803059766,-0.9121604104096889,-0.9027006420601371,-0.8927830727371542,-0.8824127320932763,-0.8715948794027712,-0.8603350008942749,-0.8486388069683698,-0.8365122293015020,-0.8239614178376992,-0.8109927376696051,-0.7976127658104222,-0.7838282878583730,-0.7696462945553995,-0.7550739782418140,-0.7401187292087289,-0.7247881319500837,-0.7090899613161932,-0.6930321785707604,-0.6766229273533455,-0.6598705295493501,-0.6427834810696000,-0.6253704475416786,-0.6076402599151870,-0.5896019099831556,-0.5712645458218993,-0.5526374671516021,-0.5337301206199948,-0.5145520950115368,-0.4951131163844918,-0.4754230431383996,-0.4554918610144281,-0.4353296780311419,-0.4149467193582680,-0.3943533221310321,-0.3735599302077272,-0.3525770888731533,-0.3314154394906165,-0.3100857141052055,-0.2885987300010764,-0.2669653842155127,-0.2451966480125345,-0.2233035613188686,-0.2012972271250900,-0.1791888058547904,-0.1569895097046089,-0.1347105969580142,-0.1123633662757129,-0.0899591509655759,-0.0675093132349997,-0.0450252384286064,-0.0225183292542148,-0.0000000000000002,0.0225183292542155,0.0450252384286070,0.0675093132349999,0.0899591509655761,0.1123633662757127,0.1347105969580135,0.1569895097046085,0.1791888058547903,0.2012972271250905,0.2233035613188684,0.2451966480125347,0.2669653842155126,0.2885987300010762,0.3100857141052050,0.3314154394906162,0.3525770888731534,0.3735599302077272,0.3943533221310322,0.4149467193582683,0.4353296780311423,0.4554918610144273,0.4754230431383994,0.4951131163844916,0.5145520950115366,0.5337301206199949,0.5526374671516013,0.5712645458218999,0.5896019099831556,0.6076402599151860,0.6253704475416786,0.6427834810695998,0.6598705295493498,0.6766229273533455,0.6930321785707607,0.7090899613161934,0.7247881319500837,0.7401187292087292,0.7550739782418144,0.7696462945553993,0.7838282878583727,0.7976127658104223,0.8109927376696053,0.8239614178376989,0.8365122293015020,0.8486388069683697,0.8603350008942745,0.8715948794027711,0.8824127320932763,0.8927830727371545,0.9027006420601373,0.9121604104096886,0.9211575803059757,0.9296875888751753,0.9377461101639373,0.9453290573338959,0.9524325847352427,0.9590530898585166,0.9651872151640000,0.9708318497885016,0.9759841311300306,0.9806414463124259,0.9848014335355021,0.9884619833251931,0.9916212397231887,0.9942776015362100,0.9964297240741310,0.9980765233160933,0.9992171951531057,0.9998514146020711};

static const double w140[140] = {0.0001879501960716,0.0004374210887103,0.0006870428764129,0.0009363532820581,0.0011852020030071,0.0014334601108534,0.0016810022907766,0.0019277043761552,0.0021734428637055,0.0024180948212510,0.0026615378971656,0.0029036503614335,0.0031443111578754,0.0033833999606512,0.0036207972324048,0.0038563842829722,0.0040900433281313,0.0043216575481453,0.0045511111459708,0.0047782894050226,0.0050030787464448,0.0052253667858462,0.0054450423894517,0.0056619957296406,0.0058761183398391,0.0060873031687354,0.0062954446337969,0.0065004386740452,0.0067021828020803,0.0069005761553168,0.0070955195464052,0.0072869155128227,0.0074746683655944,0.0076586842371376,0.0078388711281851,0.0080151389537817,0.0081873995883238,0.0083555669096146,0.0085195568419231,0.0086792873980172,0.0088346787201509,0.0089856531199940,0.0091321351174671,0.0092740514784825,0.0094113312515554,0.0095439058032753,0.0096717088526221,0.0097946765041015,0.0099127472796902,0.0100258621495708,0.0101339645616480,0.0102370004698158,0.0103349183609830,0.0104276692808243,0.0105152068582580,0.0105974873286257,0.0106744695555757,0.0107461150516273,0.0108123879974145,0.0108732552595905,0.0109286864073984,0.0109786537278812,0.0110231322397347,0.0110620997058036,0.0110955366441936,0.0111234263380141,0.0111457548437334,0.0111625109981535,0.0111736864239877,0.0111792755340500,0.0111792755340499,0.0111736864239876,0.0111625109981536,0.0111457548437335,0.0111234263380139,0.0110955366441938,0.0110620997058038,0.0110231322397350,0.0109786537278819,0.0109286864073990,0.0108732552595911,0.0108123879974149,0.0107461150516270,0.0106744695555752,0.0105974873286256,0.0105152068582578,0.0104276692808247,0.0103349183609829,0.0102370004698160,0.0101339645616480,0.0100258621495716,0.0099127472796903,0.0097946765041014,0.0096717088526221,0.0095439058032750,0.0094113312515546,0.0092740514784826,0.0091321351174667,0.0089856531199931,0.0088346787201511,0.0086792873980168,0.0085195568419238,0.0083555669096147,0.0081873995883235,0.0080151389537819,0.0078388711281853,0.0076586842371379,0.0074746683655943,0.0072869155128228,0.0070955195464050,0.0069005761553171,0.0067021828020802,0.0065004386740453,0.0062954446337968,0.0060873031687359,0.0058761183398384,0.0056619957296402,0.0054450423894521,0.0052253667858460,0.0050030787464452,0.0047782894050223,0.0045511111459714,0.0043216575481456,0.0040900433281311,0.0038563842829724,0.0036207972324048,0.0033833999606506,0.0031443111578752,0.0029036503614337,0.0026615378971660,0.0024180948212508,0.0021734428637054,0.0019277043761552,0.0016810022907759,0.0014334601108538,0.0011852020030073,0.0009363532820577,0.0006870428764132,0.0004374210887101,0.0001879501960718};
static const double pts140[140] = {-0.9998535221093257,-0.9992282971521391,-0.9981037975869401,-0.9964803357026613,-0.9943586925357154,-0.9917399214934406,-0.9886253293998115,-0.9850164724073570,-0.9809151543062233,-0.9763234253187030,-0.9712435809560955,-0.9656781608194362,-0.9596299473051374,-0.9531019642012323,-0.9460974751687073,-0.9386199821058695,-0.9306732233951910,-0.9222611720328362,-0.9133880336414139,-0.9040582443667524,-0.8942764686596216,-0.8840475969434473,-0.8733767431691278,-0.8622692422581649,-0.8507306474353451,-0.8387667274523191,-0.8263834637034410,-0.8135870472353109,-0.8003838756515113,-0.7867805499140843,-0.7727838710433417,-0.7584008367176588,-0.7436386377749599,-0.7285046546176210,-0.7130064535226158,-0.6971517828587248,-0.6809485692127150,-0.6644049134264106,-0.6475290865466584,-0.6303295256901851,-0.6128148298254420,-0.5949937554735176,-0.5768752123302932,-0.5584682588120153,-0.5397820975265076,-0.5208260706723076,-0.5016096553680031,-0.4821424589141225,-0.4624342139899321,-0.4424947737875639,-0.4223341070858765,-0.4019622932665372,-0.3813895172748114,-0.3606260645275648,-0.3396823157710429,-0.3185687418909873,-0.2972958986776867,-0.2758744215485791,-0.2543150202310477,-0.2326284734080578,-0.2108256233293293,-0.1889173703907190,-0.1669146676845412,-0.1448285155235341,-0.1226699559412269,-0.1004500671714394,-0.0781799581096933,-0.0558707627592847,-0.0335336346648094,-0.0111797413359169,0.0111797413359168,0.0335336346648096,0.0558707627592851,0.0781799581096937,0.1004500671714393,0.1226699559412271,0.1448285155235341,0.1669146676845411,0.1889173703907191,0.2108256233293291,0.2326284734080576,0.2543150202310474,0.2758744215485791,0.2972958986776866,0.3185687418909876,0.3396823157710430,0.3606260645275651,0.3813895172748119,0.4019622932665377,0.4223341070858764,0.4424947737875642,0.4624342139899327,0.4821424589141219,0.5016096553680027,0.5208260706723072,0.5397820975265067,0.5584682588120148,0.5768752123302932,0.5949937554735170,0.6128148298254412,0.6303295256901859,0.6475290865466575,0.6644049134264112,0.6809485692127145,0.6971517828587256,0.7130064535226156,0.7285046546176208,0.7436386377749595,0.7584008367176589,0.7727838710433411,0.7867805499140840,0.8003838756515113,0.8135870472353107,0.8263834637034414,0.8387667274523194,0.8507306474353451,0.8622692422581655,0.8733767431691281,0.8840475969434474,0.8942764686596220,0.9040582443667525,0.9133880336414147,0.9222611720328364,0.9306732233951913,0.9386199821058695,0.9460974751687079,0.9531019642012324,0.9596299473051376,0.9656781608194361,0.9712435809560953,0.9763234253187032,0.9809151543062231,0.9850164724073566,0.9886253293998113,0.9917399214934403,0.9943586925357147,0.9964803357026609,0.9981037975869393,0.9992282971521387,0.9998535221093255};

static const double w141[141] = {0.0001853031817169,0.0004312618936839,0.0006773724108265,0.0009231806978833,0.0011685402953644,0.0014133258105149,0.0016574154051090,0.0019006883630852,0.0021430246108040,0.0023843046244446,0.0026244094376207,0.0028632206802006,0.0031006206281427,0.0033364922575541,0.0035707193003991,0.0038031863007561,0.0040337786711565,0.0042623827487243,0.0044888858510083,0.0047131763313938,0.0049351436340633,0.0051546783484347,0.0053716722630587,0.0055860184189361,0.0057976111622203,0.0060063461962848,0.0062121206331272,0.0064148330440741,0.0066143835097742,0.0068106736694466,0.0070036067693619,0.0071930877105291,0.0073790230955747,0.0075613212747710,0.0077398923912179,0.0079146484251284,0.0080855032372180,0.0082523726111597,0.0084151742950963,0.0085738280421861,0.0087282556501524,0.0088783809998317,0.0090241300926962,0.0091654310873263,0.0093022143348187,0.0094344124131250,0.0095619601602779,0.0096847947065122,0.0098028555052557,0.0099160843629703,0.0100244254678391,0.0101278254172750,0.0102262332442437,0.0103196004423860,0.0104078809899268,0.0104910313723619,0.0105690106039027,0.0106417802476820,0.0107093044346988,0.0107715498814985,0.0108284859065785,0.0108800844455127,0.0109263200647824,0.0109671699743152,0.0110026140387177,0.0110326347871989,0.0110572174221844,0.0110763498266071,0.0110900225698851,0.0110982289125645,0.0111009648096417,0.0110982289125646,0.0110900225698856,0.0110763498266069,0.0110572174221838,0.0110326347871989,0.0110026140387178,0.0109671699743155,0.0109263200647827,0.0108800844455125,0.0108284859065787,0.0107715498814981,0.0107093044346987,0.0106417802476819,0.0105690106039027,0.0104910313723619,0.0104078809899271,0.0103196004423860,0.0102262332442438,0.0101278254172749,0.0100244254678389,0.0099160843629701,0.0098028555052561,0.0096847947065125,0.0095619601602776,0.0094344124131250,0.0093022143348185,0.0091654310873255,0.0090241300926969,0.0088783809998323,0.0087282556501522,0.0085738280421857,0.0084151742950967,0.0082523726111592,0.0080855032372179,0.0079146484251291,0.0077398923912179,0.0075613212747716,0.0073790230955744,0.0071930877105296,0.0070036067693619,0.0068106736694467,0.0066143835097743,0.0064148330440739,0.0062121206331270,0.0060063461962847,0.0057976111622195,0.0055860184189358,0.0053716722630590,0.0051546783484348,0.0049351436340636,0.0047131763313945,0.0044888858510079,0.0042623827487249,0.0040337786711562,0.0038031863007558,0.0035707193003981,0.0033364922575544,0.0031006206281426,0.0028632206802013,0.0026244094376204,0.0023843046244446,0.0021430246108041,0.0019006883630845,0.0016574154051091,0.0014133258105148,0.0011685402953642,0.0009231806978836,0.0006773724108265,0.0004312618936840,0.0001853031817174};
static const double pts141[141] = {-0.9998555850942054,-0.9992391646469285,-0.9981304958940094,-0.9965298789236147,-0.9944380725118821,-0.9918561005234134,-0.9887852332385558,-0.9852269833409273,-0.9811831042717318,-0.9766555890660825,-0.9716466692541544,-0.9661588137103447,-0.9601947274119990,-0.9537573500935901,-0.9468498547908730,-0.9394756462729528,-0.9316383593617004,-0.9233418571386700,-0.9145902290400117,-0.9053877888401431,-0.8957390725250313,-0.8856488360560715,-0.8751220530256250,-0.8641639122053391,-0.8527798149884380,-0.8409753727272428,-0.8287564039672117,-0.8161289315788740,-0.8030991797890511,-0.7896735711128431,-0.7758587231878766,-0.7616614455123776,-0.7470887360886793,-0.7321477779738206,-0.7168459357389219,-0.7011907518390980,-0.6851899428956907,-0.6688513958926492,-0.6521831642889477,-0.6351934640489324,-0.6178906695925793,-0.6002833096676424,-0.5823800631457346,-0.5641897547444059,-0.5457213506773433,-0.5269839542348155,-0.5079868012965533,-0.4887392557792793,-0.4692508050211246,-0.4495310551052057,-0.4295897261246821,-0.4094366473915979,-0.3890817525919119,-0.3685350748890577,-0.3478067419784893,-0.3269069710956173,-0.3058460639796168,-0.2846344017955818,-0.2632824400175248,-0.2418007032747564,-0.2201997801641715,-0.1984903180310072,-0.1766830177206431,-0.1547886283040317,-0.1328179417793522,-0.1107817877525158,-0.0886910280991242,-0.0665565516105239,-0.0443892686265984,-0.0222001056579293,-0.0000000000000000,0.0222001056579291,0.0443892686265978,0.0665565516105241,0.0886910280991243,0.1107817877525161,0.1328179417793519,0.1547886283040312,0.1766830177206436,0.1984903180310073,0.2201997801641713,0.2418007032747565,0.2632824400175252,0.2846344017955814,0.3058460639796173,0.3269069710956172,0.3478067419784892,0.3685350748890575,0.3890817525919121,0.4094366473915988,0.4295897261246819,0.4495310551052066,0.4692508050211245,0.4887392557792796,0.5079868012965535,0.5269839542348158,0.5457213506773440,0.5641897547444068,0.5823800631457344,0.6002833096676425,0.6178906695925795,0.6351934640489323,0.6521831642889477,0.6688513958926496,0.6851899428956905,0.7011907518390986,0.7168459357389224,0.7321477779738211,0.7470887360886794,0.7616614455123771,0.7758587231878765,0.7896735711128433,0.8030991797890510,0.8161289315788737,0.8287564039672125,0.8409753727272429,0.8527798149884381,0.8641639122053389,0.8751220530256253,0.8856488360560711,0.8957390725250317,0.9053877888401434,0.9145902290400121,0.9233418571386700,0.9316383593617011,0.9394756462729524,0.9468498547908730,0.9537573500935899,0.9601947274119982,0.9661588137103446,0.9716466692541549,0.9766555890660822,0.9811831042717317,0.9852269833409272,0.9887852332385557,0.9918561005234134,0.9944380725118811,0.9965298789236138,0.9981304958940087,0.9992391646469276,0.9998555850942048};

static const double w142[142] = {0.0001827116943860,0.0004252318664481,0.0006679046507173,0.0009102840330378,0.0011522272687919,0.0013936123793158,0.0016343208829958,0.0018742353952906,0.0021132391540962,0.0023512159268139,0.0025880500162714,0.0028236262974090,0.0030578302648351,0.0032905480845773,0.0035216666474447,0.0037510736229799,0.0039786575134767,0.0042043077078436,0.0044279145351627,0.0046493693178717,0.0048685644245064,0.0050853933219592,0.0052997506272248,0.0055115321585935,0.0057206349862709,0.0059269574823931,0.0061303993704096,0.0063308617738182,0.0065282472642093,0.0067224599086226,0.0069134053161671,0.0071009906838913,0.0072851248418914,0.0074657182976174,0.0076426832793678,0.0078159337789477,0.0079853855934700,0.0081509563662790,0.0083125656269779,0.0084701348305352,0.0086235873954639,0.0087728487410375,0.0089178463235380,0.0090585096715154,0.0091947704200345,0.0093265623439071,0.0094538213898703,0.0095764857077249,0.0096944956803940,0.0098077939528928,0.0099163254602142,0.0100200374540781,0.0101188795285824,0.0102128036446880,0.0103017641535768,0.0103857178188316,0.0104646238374521,0.0105384438596866,0.0106071420076688,0.0106706848928550,0.0107290416322548,0.0107821838634372,0.0108300857583159,0.0108727240357043,0.0109100779726279,0.0109421294143983,0.0109688627834348,0.0109902650868355,0.0110063259226958,0.0110170374851575,0.0110223945682080,0.0110223945682079,0.0110170374851575,0.0110063259226958,0.0109902650868360,0.0109688627834339,0.0109421294143984,0.0109100779726286,0.0108727240357045,0.0108300857583161,0.0107821838634370,0.0107290416322549,0.0106706848928552,0.0106071420076681,0.0105384438596867,0.0104646238374520,0.0103857178188314,0.0103017641535768,0.0102128036446875,0.0101188795285825,0.0100200374540788,0.0099163254602141,0.0098077939528931,0.0096944956803936,0.0095764857077255,0.0094538213898696,0.0093265623439067,0.0091947704200350,0.0090585096715148,0.0089178463235381,0.0087728487410375,0.0086235873954644,0.0084701348305356,0.0083125656269779,0.0081509563662795,0.0079853855934696,0.0078159337789476,0.0076426832793676,0.0074657182976173,0.0072851248418910,0.0071009906838911,0.0069134053161674,0.0067224599086232,0.0065282472642093,0.0063308617738175,0.0061303993704099,0.0059269574823933,0.0057206349862706,0.0055115321585939,0.0052997506272249,0.0050853933219597,0.0048685644245062,0.0046493693178717,0.0044279145351627,0.0042043077078432,0.0039786575134764,0.0037510736229801,0.0035216666474445,0.0032905480845774,0.0030578302648355,0.0028236262974086,0.0025880500162719,0.0023512159268138,0.0021132391540962,0.0018742353952907,0.0016343208829958,0.0013936123793163,0.0011522272687914,0.0009102840330375,0.0006679046507167,0.0004252318664486,0.0001827116943858};
static const double pts142[142] = {-0.9998576048020060,-0.9992498041954749,-0.9981566343394176,-0.9965783835930414,-0.9945157892505708,-0.9919698466600565,-0.9889417908257203,-0.9854330924687675,-0.9814454564251118,-0.9769808205216048,-0.9720413545193854,-0.9666294590091598,-0.9607477642204740,-0.9543991287310459,-0.9475866380707195,-0.9403136032179938,-0.9325835589885288,-0.9244002623157339,-0.9157676904239289,-0.9066900388947386,-0.8971717196275676,-0.8872173586950606,-0.8768317940945526,-0.8660200733965809,-0.8547874512915733,-0.8431393870358984,-0.8310815417985185,-0.8186197759095131,-0.8057601460118260,-0.7925089021175987,-0.7788724845705369,-0.7648575209157698,-0.7504708226787314,-0.7357193820546302,-0.7206103685101033,-0.7051511252987260,-0.6893491658920479,-0.6732121703279076,-0.6567479814777935,-0.6399646012350608,-0.6228701866258687,-0.6054730458447117,-0.5877816342164870,-0.5698045500870556,-0.5515505306442845,-0.5330284476716161,-0.5142473032362221,-0.4952162253138352,-0.4759444633523842,-0.4564413837765981,-0.4367164654357500,-0.4167792949967684,-0.3966395622849437,-0.3763070555744909,-0.3557916568312807,-0.3351033369100190,-0.3142521507082306,-0.2932482322794016,-0.2721017899076409,-0.2508231011462737,-0.2294225078227615,-0.2079104110123884,-0.1862972659831499,-0.1645935771143043,-0.1428098927910521,-0.1209568002778332,-0.0990449205727224,-0.0770849032454324,-0.0550874212614329,-0.0330631657946923,-0.0110228410315775,0.0110228410315771,0.0330631657946919,0.0550874212614324,0.0770849032454316,0.0990449205727213,0.1209568002778321,0.1428098927910514,0.1645935771143033,0.1862972659831497,0.2079104110123876,0.2294225078227608,0.2508231011462730,0.2721017899076409,0.2932482322794013,0.3142521507082308,0.3351033369100190,0.3557916568312815,0.3763070555744910,0.3966395622849435,0.4167792949967693,0.4367164654357502,0.4564413837765985,0.4759444633523852,0.4952162253138362,0.5142473032362226,0.5330284476716162,0.5515505306442843,0.5698045500870558,0.5877816342164873,0.6054730458447116,0.6228701866258687,0.6399646012350614,0.6567479814777937,0.6732121703279080,0.6893491658920480,0.7051511252987266,0.7206103685101040,0.7357193820546295,0.7504708226787314,0.7648575209157699,0.7788724845705371,0.7925089021175987,0.8057601460118258,0.8186197759095132,0.8310815417985183,0.8431393870358984,0.8547874512915733,0.8660200733965813,0.8768317940945528,0.8872173586950607,0.8971717196275677,0.9066900388947389,0.9157676904239286,0.9244002623157342,0.9325835589885291,0.9403136032179943,0.9475866380707199,0.9543991287310456,0.9607477642204743,0.9666294590091596,0.9720413545193853,0.9769808205216050,0.9814454564251125,0.9854330924687675,0.9889417908257203,0.9919698466600564,0.9945157892505710,0.9965783835930417,0.9981566343394176,0.9992498041954749,0.9998576048020066};

static const double w143[143] = {0.0001801741918228,0.0004193274205929,0.0006586339712658,0.0008976556378158,0.0011362532674142,0.0013743081789256,0.0016117051322954,0.0018483299603673,0.0020840690992897,0.0023188094953522,0.0025524386092984,0.0027848444509861,0.0030159156247877,0.0032455413791204,0.0034736116576045,0.0037000171507911,0.0039246493479888,0.0041474005889432,0.0043681641152387,0.0045868341213530,0.0048033058052766,0.0050174754187034,0.0052292403167139,0.0054384990069492,0.0056451511982406,0.0058490978486583,0.0060502412129772,0.0062484848895182,0.0064437338663382,0.0066358945667745,0.0068248748942805,0.0070105842765703,0.0071929337090224,0.0073718357973358,0.0075472047994164,0.0077189566664670,0.0078870090832714,0.0080512815076435,0.0082116952090292,0.0083681733062374,0.0085206408042901,0.0086690246303620,0.0088132536687998,0.0089532587952128,0.0090889729095946,0.0092203309684847,0.0093472700161444,0.0094697292147221,0.0095876498734204,0.0097009754766178,0.0098096517109564,0.0099136264913732,0.0100128499860641,0.0101072746403635,0.0101968551995386,0.0102815487304761,0.0103613146422620,0.0104361147056306,0.0105059130712913,0.0105706762871084,0.0106303733141330,0.0106849755414780,0.0107344568000336,0.0107787933750068,0.0108179640172873,0.0108519499536317,0.0108807348956635,0.0109043050476740,0.0109226491132409,0.0109357583006357,0.0109436263270430,0.0109462494215667,0.0109436263270426,0.0109357583006353,0.0109226491132402,0.0109043050476742,0.0108807348956636,0.0108519499536314,0.0108179640172869,0.0107787933750067,0.0107344568000336,0.0106849755414778,0.0106303733141324,0.0105706762871085,0.0105059130712913,0.0104361147056301,0.0103613146422614,0.0102815487304764,0.0101968551995390,0.0101072746403637,0.0100128499860641,0.0099136264913737,0.0098096517109565,0.0097009754766177,0.0095876498734205,0.0094697292147219,0.0093472700161441,0.0092203309684853,0.0090889729095943,0.0089532587952127,0.0088132536688003,0.0086690246303615,0.0085206408042903,0.0083681733062377,0.0082116952090283,0.0080512815076438,0.0078870090832716,0.0077189566664669,0.0075472047994160,0.0073718357973359,0.0071929337090225,0.0070105842765703,0.0068248748942806,0.0066358945667742,0.0064437338663387,0.0062484848895181,0.0060502412129773,0.0058490978486578,0.0056451511982405,0.0054384990069497,0.0052292403167141,0.0050174754187034,0.0048033058052770,0.0045868341213530,0.0043681641152388,0.0041474005889425,0.0039246493479891,0.0037000171507910,0.0034736116576044,0.0032455413791202,0.0030159156247874,0.0027848444509857,0.0025524386092984,0.0023188094953520,0.0020840690992900,0.0018483299603676,0.0016117051322953,0.0013743081789259,0.0011362532674145,0.0008976556378160,0.0006586339712655,0.0004193274205930,0.0001801741918226};
static const double pts143[143] = {-0.9998595824347913,-0.9992602221281375,-0.9981822284665414,-0.9966258785315432,-0.9945918888815022,-0.9920812273316600,-0.9890950948252514,-0.9856349215653657,-0.9817023654543503,-0.9772993110081462,-0.9724278683398635,-0.9670903720989935,-0.9612893803288181,-0.9550276732282701,-0.9483082518128347,-0.9411343364724672,-0.9335093654258946,-0.9254369930713829,-0.9169210882344060,-0.9079657323128504,-0.8985752173205378,-0.8887540438299287,-0.8785069188149487,-0.8678387533949510,-0.8567546604808763,-0.8452599523247226,-0.8333601379735011,-0.8210609206288835,-0.8083681949138062,-0.7952880440473459,-0.7818267369292035,-0.7679907251352075,-0.7537866398252678,-0.7392212885652618,-0.7243016520643770,-0.7090348808294746,-0.6934282917380756,-0.6774893645316050,-0.6612257382305917,-0.6446452074735251,-0.6277557187811298,-0.6105653667478471,-0.5930823901623571,-0.5753151680589859,-0.5572722157018967,-0.5389621805039989,-0.5203938378825119,-0.5015760870531911,-0.4825179467652155,-0.4632285509787858,-0.4437171444875057,-0.4239930784876504,-0.4040658060964352,-0.3839448778214336,-0.3636399369833248,-0.3431607150941561,-0.3225170271933385,-0.3017187671436116,-0.2807759028892286,-0.2596984716786381,-0.2384965752539495,-0.2171803750094910,-0.1957600871217741,-0.1742459776532076,-0.1526483576318989,-0.1309775781099060,-0.1092440252023099,-0.0874581151094763,-0.0656302891249058,-0.0437710086310518,-0.0218907500855123,0.0000000000000003,0.0218907500855125,0.0437710086310519,0.0656302891249061,0.0874581151094768,0.1092440252023104,0.1309775781099067,0.1526483576318989,0.1742459776532078,0.1957600871217743,0.2171803750094912,0.2384965752539500,0.2596984716786384,0.2807759028892290,0.3017187671436120,0.3225170271933390,0.3431607150941564,0.3636399369833252,0.3839448778214340,0.4040658060964358,0.4239930784876511,0.4437171444875056,0.4632285509787855,0.4825179467652159,0.5015760870531917,0.5203938378825119,0.5389621805039984,0.5572722157018968,0.5753151680589864,0.5930823901623572,0.6105653667478466,0.6277557187811293,0.6446452074735254,0.6612257382305922,0.6774893645316049,0.6934282917380753,0.7090348808294749,0.7243016520643766,0.7392212885652609,0.7537866398252675,0.7679907251352076,0.7818267369292030,0.7952880440473460,0.8083681949138062,0.8210609206288829,0.8333601379735014,0.8452599523247225,0.8567546604808762,0.8678387533949510,0.8785069188149488,0.8887540438299286,0.8985752173205378,0.9079657323128502,0.9169210882344058,0.9254369930713829,0.9335093654258944,0.9411343364724674,0.9483082518128342,0.9550276732282695,0.9612893803288175,0.9670903720989928,0.9724278683398631,0.9772993110081457,0.9817023654543499,0.9856349215653655,0.9890950948252517,0.9920812273316600,0.9945918888815014,0.9966258785315426,0.9981822284665405,0.9992602221281371,0.9998595824347907};

static const double w144[144] = {0.0001776891849488,0.0004135450933120,0.0006495549413714,0.0008852881256916,0.0011206089671015,0.0013554019701858,0.0015895550261044,0.0018229570755968,0.0020554976444049,0.0022870667499301,0.0025175549040384,0.0027468531458007,0.0029748530848329,0.0032014469487260,0.0034265276320903,0.0036499887461700,0.0038717246685798,0.0040916305929075,0.0043096025780529,0.0045255375972468,0.0047393335866670,0.0049508894936316,0.0051601053243295,0.0053668821910622,0.0055711223589687,0.0057727292922074,0.0059716076995802,0.0061676635795673,0.0063608042647477,0.0065509384656049,0.0067379763136662,0.0069218294039827,0.0071024108369103,0.0072796352591850,0.0074534189042612,0.0076236796319103,0.0077903369670373,0.0079533121377229,0.0081125281124521,0.0082679096365255,0.0084193832676298,0.0085668774105462,0.0087103223509958,0.0088496502885845,0.0089847953688575,0.0091156937144178,0.0092422834551216,0.0093645047573230,0.0094822998521534,0.0095956130628248,0.0097043908309500,0.0098085817418520,0.0099081365488707,0.0100030081966360,0.0100931518433112,0.0101785248817859,0.0102590869598172,0.0103347999990976,0.0104056282132613,0.0104715381247882,0.0105324985808379,0.0105884807679667,0.0106394582257494,0.0106854068592859,0.0107263049505906,0.0107621331688573,0.0107928745795930,0.0108185146526265,0.0108390412689742,0.0108544447265684,0.0108647177448416,0.0108698554681707,0.0108698554681713,0.0108647177448415,0.0108544447265682,0.0108390412689742,0.0108185146526262,0.0107928745795933,0.0107621331688572,0.0107263049505911,0.0106854068592856,0.0106394582257493,0.0105884807679671,0.0105324985808387,0.0104715381247885,0.0104056282132606,0.0103347999990980,0.0102590869598171,0.0101785248817863,0.0100931518433115,0.0100030081966363,0.0099081365488703,0.0098085817418524,0.0097043908309499,0.0095956130628250,0.0094822998521529,0.0093645047573231,0.0092422834551212,0.0091156937144180,0.0089847953688576,0.0088496502885851,0.0087103223509955,0.0085668774105467,0.0084193832676298,0.0082679096365258,0.0081125281124523,0.0079533121377222,0.0077903369670372,0.0076236796319104,0.0074534189042613,0.0072796352591847,0.0071024108369102,0.0069218294039822,0.0067379763136663,0.0065509384656043,0.0063608042647476,0.0061676635795670,0.0059716076995809,0.0057727292922069,0.0055711223589682,0.0053668821910627,0.0051601053243299,0.0049508894936317,0.0047393335866674,0.0045255375972471,0.0043096025780527,0.0040916305929069,0.0038717246685805,0.0036499887461697,0.0034265276320901,0.0032014469487268,0.0029748530848323,0.0027468531458006,0.0025175549040385,0.0022870667499299,0.0020554976444047,0.0018229570755970,0.0015895550261042,0.0013554019701852,0.0011206089671017,0.0008852881256921,0.0006495549413711,0.0004135450933120,0.0001776891849488};
static const double pts144[144] = {-0.9998615191531732,-0.9992704245570446,-0.9982072932831175,-0.9966723915670502,-0.9946664159466312,-0.9921903076476249,-0.9892452347175487,-0.9858325882264503,-0.9819539807463441,-0.9776112453019418,-0.9728064343925928,-0.9675418189733547,-0.9618198873582733,-0.9556433440322708,-0.9490151083663123,-0.9419383132337970,-0.9344163035275460,-0.9264526345774283,-0.9180510704690240,-0.9092155822639183,-0.8999503461223562,-0.8902597413290853,-0.8801483482232562,-0.8696209460333638,-0.8586825106182050,-0.8473382121149284,-0.8355934124952801,-0.8234536630311791,-0.8109247016708374,-0.7980124503266508,-0.7847230120761400,-0.7710626682772692,-0.7570378755995016,-0.7426552629719922,-0.7279216284503701,-0.7128439360035700,-0.6974293122222603,-0.6816850429503936,-0.6656185698414936,-0.6492374868412997,-0.6325495365984189,-0.6155626068047060,-0.5982847264670781,-0.5807240621125431,-0.5628889139282204,-0.5447877118381960,-0.5264290115190464,-0.5078214903559314,-0.4889739433411610,-0.4698952789171694,-0.4505945147658661,-0.4310807735463654,-0.4113632785830785,-0.3914513495062439,-0.3713543978469249,-0.3510819225885771,-0.3306435056772777,-0.3100488074927438,-0.2893075622822748,-0.2684295735597854,-0.2474247094720958,-0.2263028981346729,-0.2050741229390302,-0.1837484178339974,-0.1623358625830933,-0.1408465780002469,-0.1192907211661164,-0.0976784806272615,-0.0760200715804467,-0.0543257310443477,-0.0326057130209442,-0.0108702836488855,0.0108702836488857,0.0326057130209455,0.0543257310443478,0.0760200715804465,0.0976784806272617,0.1192907211661171,0.1408465780002472,0.1623358625830927,0.1837484178339971,0.2050741229390304,0.2263028981346731,0.2474247094720956,0.2684295735597857,0.2893075622822753,0.3100488074927439,0.3306435056772773,0.3510819225885771,0.3713543978469249,0.3914513495062441,0.4113632785830791,0.4310807735463654,0.4505945147658662,0.4698952789171684,0.4889739433411603,0.5078214903559309,0.5264290115190455,0.5447877118381961,0.5628889139282207,0.5807240621125428,0.5982847264670781,0.6155626068047059,0.6325495365984186,0.6492374868413000,0.6656185698414940,0.6816850429503934,0.6974293122222600,0.7128439360035709,0.7279216284503699,0.7426552629719928,0.7570378755995012,0.7710626682772698,0.7847230120761403,0.7980124503266512,0.8109247016708375,0.8234536630311790,0.8355934124952802,0.8473382121149285,0.8586825106182049,0.8696209460333637,0.8801483482232559,0.8902597413290851,0.8999503461223566,0.9092155822639182,0.9180510704690247,0.9264526345774283,0.9344163035275458,0.9419383132337968,0.9490151083663123,0.9556433440322707,0.9618198873582730,0.9675418189733543,0.9728064343925923,0.9776112453019418,0.9819539807463440,0.9858325882264504,0.9892452347175480,0.9921903076476246,0.9946664159466304,0.9966723915670499,0.9982072932831174,0.9992704245570446,0.9998615191531728};

static const double w145[145] = {0.0001752552356727,0.0004078815403268,0.0006406623157025,0.0008731743625348,0.0011052853618935,0.0013368828968123,0.0015678578837955,0.0017981022664321,0.0020275085557886,0.0022559697369521,0.0024833792704133,0.0027096311229864,0.0029346198091878,0.0031582404366662,0.0033803887532268,0.0036009611944420,0.0038198549313889,0.0040369679182628,0.0042521989397673,0.0044654476581778,0.0046766146600445,0.0048856015024903,0.0050923107590664,0.0052966460651584,0.0054985121628838,0.0056978149454967,0.0058944615012480,0.0060883601566961,0.0062794205194381,0.0064675535202437,0.0066526714545816,0.0068346880234994,0.0070135183738556,0.0071890791378735,0.0073612884720096,0.0075300660951011,0.0076953333257975,0.0078570131192333,0.0080150301029530,0.0081693106120385,0.0083197827234602,0.0084663762895981,0.0086090229709484,0.0087476562679807,0.0088822115521356,0.0090126260959615,0.0091388391023468,0.0092607917328707,0.0093784271352286,0.0094916904697366,0.0096005289348970,0.0097048917920132,0.0098047303888434,0.0098999981822809,0.0099906507600531,0.0100766458614245,0.0101579433968968,0.0102345054669025,0.0103062963794673,0.0103732826668525,0.0104354331011570,0.0104927187088744,0.0105451127843995,0.0105925909024794,0.0106351309295988,0.0106727130342987,0.0107053196964247,0.0107329357152868,0.0107555482167536,0.0107731466592503,0.0107857228386733,0.0107932708922154,0.0107957873010995,0.0107932708922159,0.0107857228386732,0.0107731466592500,0.0107555482167540,0.0107329357152864,0.0107053196964250,0.0106727130342993,0.0106351309295988,0.0105925909024786,0.0105451127843995,0.0104927187088744,0.0104354331011568,0.0103732826668523,0.0103062963794671,0.0102345054669028,0.0101579433968972,0.0100766458614243,0.0099906507600524,0.0098999981822810,0.0098047303888430,0.0097048917920133,0.0096005289348972,0.0094916904697367,0.0093784271352286,0.0092607917328712,0.0091388391023470,0.0090126260959608,0.0088822115521365,0.0087476562679801,0.0086090229709489,0.0084663762895984,0.0083197827234602,0.0081693106120388,0.0080150301029529,0.0078570131192337,0.0076953333257972,0.0075300660951014,0.0073612884720095,0.0071890791378737,0.0070135183738552,0.0068346880234993,0.0066526714545817,0.0064675535202440,0.0062794205194376,0.0060883601566965,0.0058944615012478,0.0056978149454961,0.0054985121628838,0.0052966460651587,0.0050923107590667,0.0048856015024901,0.0046766146600449,0.0044654476581776,0.0042521989397674,0.0040369679182625,0.0038198549313886,0.0036009611944427,0.0033803887532265,0.0031582404366661,0.0029346198091880,0.0027096311229859,0.0024833792704135,0.0022559697369518,0.0020275085557889,0.0017981022664318,0.0015678578837950,0.0013368828968122,0.0011052853618935,0.0008731743625348,0.0006406623157019,0.0004078815403268,0.0001752552356734};
static const double pts145[145] = {-0.9998634160780222,-0.9992804173850652,-0.9982318432832455,-0.9967179495755708,-0.9947394134652653,-0.9922971504934610,-0.9893922969297322,-0.9860262060397558,-0.9822004466031947,-0.9779168018992298,-0.9731772687650827,-0.9679840566169966,-0.9623395863972292,-0.9562464894336187,-0.9497076062064592,-0.9427259850206200,-0.9353048805822728,-0.9274477524802366,-0.9191582635723033,-0.9104402782771035,-0.9012978607721915,-0.8917352730991286,-0.8817569731764086,-0.8713676127211138,-0.8605720350802682,-0.8493752729728777,-0.8377825461437093,-0.8257992589298896,-0.8134309977414663,-0.8006835284570899,-0.7875627937360399,-0.7740749102478410,-0.7602261658207603,-0.7460230165105182,-0.7314720835905749,-0.7165801504653960,-0.7013541595081354,-0.6858012088242134,-0.6699285489422934,-0.6537435794342019,-0.6372538454653709,-0.6204670342774000,-0.6033909716043938,-0.5860336180247303,-0.5684030652499719,-0.5505075323526391,-0.5323553619346154,-0.5139550162379648,-0.4953150731999706,-0.4764442224542473,-0.4573512612797659,-0.4380450904997219,-0.4185347103321088,-0.3988292161939658,-0.3789377944612443,-0.3588697181862731,-0.3386343427748136,-0.3182411016247229,-0.2976995017282610,-0.2770191192400844,-0.2562095950130048,-0.2352806301035809,-0.2142419812496459,-0.1931034563218772,-0.1718749097515289,-0.1505662379364601,-0.1291873746275956,-0.1077482862979744,-0.0862589674965487,-0.0647294361888864,-0.0431697290869612,-0.0215898969702059,-0.0000000000000000,0.0215898969702054,0.0431697290869614,0.0647294361888862,0.0862589674965488,0.1077482862979745,0.1291873746275953,0.1505662379364605,0.1718749097515292,0.1931034563218774,0.2142419812496461,0.2352806301035809,0.2562095950130047,0.2770191192400843,0.2976995017282610,0.3182411016247231,0.3386343427748132,0.3588697181862725,0.3789377944612436,0.3988292161939654,0.4185347103321091,0.4380450904997225,0.4573512612797654,0.4764442224542458,0.4953150731999707,0.5139550162379646,0.5323553619346154,0.5505075323526393,0.5684030652499726,0.5860336180247313,0.6033909716043941,0.6204670342774004,0.6372538454653708,0.6537435794342024,0.6699285489422931,0.6858012088242130,0.7013541595081352,0.7165801504653962,0.7314720835905750,0.7460230165105178,0.7602261658207601,0.7740749102478403,0.7875627937360404,0.8006835284570897,0.8134309977414663,0.8257992589298888,0.8377825461437091,0.8493752729728780,0.8605720350802680,0.8713676127211140,0.8817569731764089,0.8917352730991287,0.9012978607721915,0.9104402782771039,0.9191582635723045,0.9274477524802368,0.9353048805822727,0.9427259850206208,0.9497076062064598,0.9562464894336191,0.9623395863972293,0.9679840566169970,0.9731772687650827,0.9779168018992297,0.9822004466031947,0.9860262060397561,0.9893922969297325,0.9922971504934603,0.9947394134652657,0.9967179495755709,0.9982318432832447,0.9992804173850643,0.9998634160780221};

static const double w146[146] = {0.0001728709548153,0.0004023335310516,0.0006319510271232,0.0008613074563302,0.0010902737510667,0.0013187404698621,0.0015466014529600,0.0017737515459850,0.0020000861452500,0.0022255011042432,0.0024498927336806,0.0026731578306894,0.0028951937183261,0.0031158982890918,0.0033351700500414,0.0035529081684765,0.0037690125177737,0.0039833837231152,0.0041959232069973,0.0044065332344467,0.0046151169578872,0.0048215784616334,0.0050258228059553,0.0052277560707216,0.0054272853985705,0.0056243190375983,0.0058187663835443,0.0060105380214493,0.0061995457667660,0.0063857027059110,0.0065689232362243,0.0067491231053364,0.0069262194499043,0.0071001308337199,0.0072707772851514,0.0074380803339227,0.0076019630471917,0.0077623500649319,0.0079191676345790,0.0080723436449527,0.0082218076594103,0.0083674909482387,0.0085093265202617,0.0086472491536378,0.0087811954258583,0.0089111037429100,0.0090369143675994,0.0091585694470163,0.0092760130391457,0.0093891911385880,0.0094980517013900,0.0096025446689835,0.0097026219911964,0.0097982376483573,0.0098893476724468,0.0099759101673258,0.0100578853279933,0.0101352354588955,0.0102079249912554,0.0102759204994357,0.0103391907162986,0.0103977065475950,0.0104514410853357,0.0105003696201672,0.0105444696527356,0.0105837209040275,0.0106181053247042,0.0106476071033919,0.0106722126739572,0.0106919107217468,0.0107066921887868,0.0107165502779497,0.0107214804560805,0.0107214804560804,0.0107165502779499,0.0107066921887866,0.0106919107217466,0.0106722126739572,0.0106476071033913,0.0106181053247039,0.0105837209040275,0.0105444696527346,0.0105003696201678,0.0104514410853356,0.0103977065475950,0.0103391907162987,0.0102759204994355,0.0102079249912559,0.0101352354588953,0.0100578853279934,0.0099759101673261,0.0098893476724471,0.0097982376483569,0.0097026219911964,0.0096025446689836,0.0094980517013901,0.0093891911385877,0.0092760130391459,0.0091585694470163,0.0090369143675995,0.0089111037429100,0.0087811954258586,0.0086472491536370,0.0085093265202613,0.0083674909482387,0.0082218076594099,0.0080723436449519,0.0079191676345788,0.0077623500649320,0.0076019630471921,0.0074380803339229,0.0072707772851509,0.0071001308337197,0.0069262194499046,0.0067491231053369,0.0065689232362246,0.0063857027059109,0.0061995457667668,0.0060105380214492,0.0058187663835440,0.0056243190375980,0.0054272853985703,0.0052277560707217,0.0050258228059556,0.0048215784616330,0.0046151169578878,0.0044065332344458,0.0041959232069969,0.0039833837231157,0.0037690125177740,0.0035529081684765,0.0033351700500410,0.0031158982890920,0.0028951937183257,0.0026731578306898,0.0024498927336808,0.0022255011042431,0.0020000861452498,0.0017737515459856,0.0015466014529601,0.0013187404698616,0.0010902737510670,0.0008613074563301,0.0006319510271231,0.0004023335310519,0.0001728709548151};
static const double pts146[146] = {-0.9998652742920865,-0.9992902063143406,-0.9982558924683286,-0.9967625785199898,-0.9948109229960844,-0.9924018166212848,-0.9895363649597531,-0.9862158847477087,-0.9824419024482847,-0.9782161532703214,-0.9735405802618023,-0.9684173333688948,-0.9628487684246094,-0.9568374460538267,-0.9503861304894583,-0.9434977882976953,-0.9361755870116850,-0.9284228936736229,-0.9202432732855877,-0.9116404871696436,-0.9026184912378509,-0.8931814341729131,-0.8833336555202589,-0.8730796836924140,-0.8624242338865511,-0.8513722059161833,-0.8399286819579757,-0.8280989242147104,-0.8158883724954828,-0.8033026417142274,-0.7903475193077344,-0.7770289625743331,-0.7633530959344680,-0.7493262081144315,-0.7349547492545428,-0.7202453279430994,-0.7052047081774738,-0.6898398062537412,-0.6741576875862852,-0.6581655634588218,-0.6418707877083528,-0.6252808533435698,-0.6084033890992550,-0.5912461559282746,-0.5738170434327763,-0.5561240662362188,-0.5381753602979195,-0.5199791791718034,-0.5015438902110835,-0.4828779707206018,-0.4639900040586148,-0.4448886756898138,-0.4255827691913915,-0.4060811622139905,-0.3863928223993888,-0.3665268032568159,-0.3464922399997725,-0.3262983453452838,-0.3059544052775139,-0.2854697747776843,-0.2648538735222724,-0.2441161815514536,-0.2232662349097901,-0.2023136212611634,-0.1812679754799733,-0.1601389752206240,-0.1389363364673412,-0.1176698090663633,-0.0963491722425593,-0.0749842301025374,-0.0535848071263160,-0.0321607436496215,-0.0107218913388977,0.0107218913388980,0.0321607436496217,0.0535848071263162,0.0749842301025373,0.0963491722425591,0.1176698090663641,0.1389363364673415,0.1601389752206242,0.1812679754799734,0.2023136212611636,0.2232662349097903,0.2441161815514538,0.2648538735222729,0.2854697747776845,0.3059544052775137,0.3262983453452842,0.3464922399997724,0.3665268032568157,0.3863928223993888,0.4060811622139905,0.4255827691913925,0.4448886756898144,0.4639900040586143,0.4828779707206021,0.5015438902110841,0.5199791791718037,0.5381753602979187,0.5561240662362185,0.5738170434327765,0.5912461559282740,0.6084033890992541,0.6252808533435696,0.6418707877083527,0.6581655634588215,0.6741576875862852,0.6898398062537411,0.7052047081774735,0.7202453279430994,0.7349547492545428,0.7493262081144311,0.7633530959344674,0.7770289625743326,0.7903475193077348,0.8033026417142279,0.8158883724954824,0.8280989242147104,0.8399286819579759,0.8513722059161833,0.8624242338865511,0.8730796836924137,0.8833336555202591,0.8931814341729126,0.9026184912378505,0.9116404871696434,0.9202432732855875,0.9284228936736229,0.9361755870116851,0.9434977882976954,0.9503861304894583,0.9568374460538264,0.9628487684246091,0.9684173333688944,0.9735405802618021,0.9782161532703206,0.9824419024482847,0.9862158847477086,0.9895363649597534,0.9924018166212851,0.9948109229960845,0.9967625785199901,0.9982558924683289,0.9992902063143406,0.9998652742920862};

static const double w147[147] = {0.0001705350001192,0.0003968979439885,0.0006234161794813,0.0008496807473931,0.0010755657268138,0.0013009645529284,0.0015257738921919,0.0017498913954769,0.0019732152482579,0.0021956440770985,0.0024170769484427,0.0026374133961566,0.0028565534592712,0.0030743977236760,0.0032908473653978,0.0035058041944665,0.0037191706989237,0.0039308500887499,0.0041407463395842,0.0043487642361752,0.0045548094154959,0.0047587884095054,0.0049606086875175,0.0051601786981497,0.0053574079108459,0.0055522068569259,0.0057444871701701,0.0059341616268935,0.0061211441855145,0.0063053500255774,0.0064866955862320,0.0066650986041333,0.0068404781507615,0.0070127546691291,0.0071818500098683,0.0073476874666873,0.0075101918111570,0.0076692893268450,0.0078249078427502,0.0079769767660409,0.0081254271140796,0.0082701915457156,0.0084112043918301,0.0085484016851284,0.0086817211891529,0.0088111024265209,0.0089364867063552,0.0090578171509065,0.0091750387213582,0.0092880982427917,0.0093969444283076,0.0095015279022921,0.0096018012228126,0.0096977189031427,0.0097892374323928,0.0098763152952472,0.0099589129908031,0.0100369930504775,0.0101105200550173,0.0101794606505569,0.0102437835637519,0.0103034596159658,0.0103584617365050,0.0104087649749002,0.0104543465122230,0.0104951856714389,0.0105312639267857,0.0105625649121774,0.0105890744286295,0.0106107804506981,0.0106276731319369,0.0106397448093623,0.0106469900069316,0.0106494054380228,0.0106469900069316,0.0106397448093627,0.0106276731319365,0.0106107804506976,0.0105890744286296,0.0105625649121772,0.0105312639267856,0.0104951856714392,0.0104543465122232,0.0104087649748999,0.0103584617365049,0.0103034596159655,0.0102437835637518,0.0101794606505575,0.0101105200550178,0.0100369930504771,0.0099589129908022,0.0098763152952475,0.0097892374323926,0.0096977189031429,0.0096018012228129,0.0095015279022918,0.0093969444283083,0.0092880982427920,0.0091750387213586,0.0090578171509067,0.0089364867063549,0.0088111024265210,0.0086817211891526,0.0085484016851277,0.0084112043918303,0.0082701915457155,0.0081254271140796,0.0079769767660408,0.0078249078427496,0.0076692893268463,0.0075101918111570,0.0073476874666871,0.0071818500098681,0.0070127546691289,0.0068404781507619,0.0066650986041328,0.0064866955862322,0.0063053500255773,0.0061211441855146,0.0059341616268939,0.0057444871701701,0.0055522068569265,0.0053574079108459,0.0051601786981499,0.0049606086875171,0.0047587884095056,0.0045548094154962,0.0043487642361753,0.0041407463395840,0.0039308500887492,0.0037191706989244,0.0035058041944666,0.0032908473653977,0.0030743977236765,0.0028565534592710,0.0026374133961564,0.0024170769484428,0.0021956440770979,0.0019732152482579,0.0017498913954774,0.0015257738921920,0.0013009645529282,0.0010755657268136,0.0008496807473930,0.0006234161794814,0.0003968979439881,0.0001705350001192};
static const double pts147[147] = {-0.9998670948415376,-0.9992997968544294,-0.9982794543670452,-0.9968063034870421,-0.9948809846962290,-0.9925043647360478,-0.9896775194946430,-0.9864017304024664,-0.9826784830226815,-0.9785094661017735,-0.9738965706963165,-0.9688418892683062,-0.9633477147135712,-0.9574165393101411,-0.9510510535814115,-0.9442541450720524,-0.9370288970359962,-0.9293785870364599,-0.9213066854583060,-0.9128168539332246,-0.9039129436783419,-0.8945989937489461,-0.8848792292060813,-0.8747580591998158,-0.8642400749690379,-0.8533300477586772,-0.8420329266552828,-0.8303538363419476,-0.8182980747735809,-0.8058711107735882,-0.7930785815530456,-0.7799262901534941,-0.7664202028145080,-0.7525664462672375,-0.7383713049551475,-0.7238412181832203,-0.7089827771969003,-0.6938027221921242,-0.6783079392577804,-0.6625054572519845,-0.6464024446135981,-0.6300062061104256,-0.6133241795255699,-0.5963639322834473,-0.5791331580169986,-0.5616396730776424,-0.5438914129895649,-0.5258964288499450,-0.5076628836767609,-0.4891990487058164,-0.4705132996386814,-0.4516141128432460,-0.4325100615086067,-0.4132098117560321,-0.3937221187077714,-0.3740558225154922,-0.3542198443501459,-0.3342231823550782,-0.3140749075642256,-0.2937841597872454,-0.2733601434634461,-0.2528121234864034,-0.2321494210011508,-0.2113814091758492,-0.1905175089498650,-0.1695671847601707,-0.1485399402480180,-0.1274453139478254,-0.1062928749602381,-0.0850922186113214,-0.0638529620998562,-0.0425847401347174,-0.0212972005643008,0.0000000000000004,0.0212972005643007,0.0425847401347171,0.0638529620998564,0.0850922186113211,0.1062928749602381,0.1274453139478251,0.1485399402480176,0.1695671847601708,0.1905175089498651,0.2113814091758495,0.2321494210011510,0.2528121234864039,0.2733601434634460,0.2937841597872449,0.3140749075642258,0.3342231823550783,0.3542198443501463,0.3740558225154922,0.3937221187077711,0.4132098117560321,0.4325100615086069,0.4516141128432457,0.4705132996386808,0.4891990487058157,0.5076628836767608,0.5258964288499447,0.5438914129895647,0.5616396730776430,0.5791331580169989,0.5963639322834478,0.6133241795255704,0.6300062061104255,0.6464024446135982,0.6625054572519842,0.6783079392577808,0.6938027221921247,0.7089827771969004,0.7238412181832199,0.7383713049551474,0.7525664462672363,0.7664202028145077,0.7799262901534941,0.7930785815530458,0.8058711107735878,0.8182980747735804,0.8303538363419470,0.8420329266552824,0.8533300477586768,0.8642400749690375,0.8747580591998158,0.8848792292060812,0.8945989937489461,0.9039129436783420,0.9128168539332246,0.9213066854583060,0.9293785870364596,0.9370288970359965,0.9442541450720524,0.9510510535814118,0.9574165393101415,0.9633477147135709,0.9688418892683067,0.9738965706963169,0.9785094661017735,0.9826784830226813,0.9864017304024663,0.9896775194946434,0.9925043647360476,0.9948809846962293,0.9968063034870429,0.9982794543670455,0.9992997968544295,0.9998670948415379};

static const double w148[148] = {0.0001682460743661,0.0003915717623341,0.0006150530407317,0.0008382877990349,0.0010611531624915,0.0012835453480333,0.0015053637546721,0.0017265087455917,0.0019468812031519,0.0021663824354341,0.0023849141738440,0.0026023785990897,0.0028186783772352,0.0030337166996637,0.0032473973245996,0.0034596246192375,0.0036703036020135,0.0038793399848094,0.0040866402149683,0.0042921115170539,0.0044956619342939,0.0046972003696942,0.0048966366267753,0.0050938814499152,0.0052888465642837,0.0054814447153382,0.0056715897078636,0.0058591964445465,0.0060441809640529,0.0062264604786032,0.0064059534110181,0.0065825794312297,0.0067562594922286,0.0069269158654389,0.0070944721755069,0.0072588534344783,0.0074199860753603,0.0075777979850434,0.0077322185365767,0.0078831786207717,0.0080306106771381,0.0081744487241120,0.0083146283885905,0.0084510869347390,0.0085837632920670,0.0087125980827618,0.0088375336482600,0.0089585140750531,0.0090754852197114,0.0091883947331124,0.0092971920838748,0.0094018285809655,0.0095022573954981,0.0095984335816847,0.0096903140969543,0.0097778578212178,0.0098610255752641,0.0099397801383001,0.0100140862646079,0.0100839106993156,0.0101492221932830,0.0102099915170856,0.0102661914740968,0.0103177969126571,0.0103647847373327,0.0104071339192524,0.0104448255055156,0.0104778426276768,0.0105061705092939,0.0105297964725435,0.0105487099438906,0.0105629024588241,0.0105723676656436,0.0105771013283020,0.0105771013283010,0.0105723676656431,0.0105629024588242,0.0105487099438899,0.0105297964725439,0.0105061705092943,0.0104778426276767,0.0104448255055152,0.0104071339192526,0.0103647847373324,0.0103177969126571,0.0102661914740972,0.0102099915170857,0.0101492221932832,0.0100839106993153,0.0100140862646076,0.0099397801382998,0.0098610255752642,0.0097778578212177,0.0096903140969547,0.0095984335816841,0.0095022573954978,0.0094018285809655,0.0092971920838749,0.0091883947331130,0.0090754852197107,0.0089585140750538,0.0088375336482598,0.0087125980827611,0.0085837632920667,0.0084510869347388,0.0083146283885905,0.0081744487241120,0.0080306106771382,0.0078831786207716,0.0077322185365760,0.0075777979850438,0.0074199860753603,0.0072588534344784,0.0070944721755069,0.0069269158654390,0.0067562594922290,0.0065825794312296,0.0064059534110178,0.0062264604786028,0.0060441809640526,0.0058591964445468,0.0056715897078636,0.0054814447153384,0.0052888465642836,0.0050938814499151,0.0048966366267753,0.0046972003696949,0.0044956619342936,0.0042921115170537,0.0040866402149685,0.0038793399848090,0.0036703036020138,0.0034596246192374,0.0032473973245997,0.0030337166996639,0.0028186783772361,0.0026023785990898,0.0023849141738440,0.0021663824354341,0.0019468812031520,0.0017265087455910,0.0015053637546720,0.0012835453480329,0.0010611531624915,0.0008382877990345,0.0006150530407318,0.0003915717623345,0.0001682460743664};
static const double pts148[148] = {-0.9998688787374446,-0.9993091943300514,-0.9983025420543618,-0.9968491487225449,-0.9949496373776267,-0.9926048515777250,-0.9898158385232462,-0.9865838455137156,-0.9829103185723912,-0.9787969015273056,-0.9742454351698643,-0.9692579563848156,-0.9638366972165761,-0.9579840838589475,-0.9517027355631151,-0.9449954634618867,-0.9378652693094832,-0.9303153441368301,-0.9223490668226099,-0.9139700025805325,-0.9051819013633987,-0.8959886961845955,-0.8863945013577426,-0.8764036106552514,-0.8660204953866043,-0.8552498023972013,-0.8440963519886699,-0.8325651357615539,-0.8206613143813483,-0.8083902152688829,-0.7957573302160752,-0.7827683129281273,-0.7694289764932645,-0.7557452907811452,-0.7417233797711033,-0.7273695188114274,-0.7126901318108936,-0.6976917883638134,-0.6823812008098827,-0.6667652212301503,-0.6508508383804371,-0.6346451745636048,-0.6181554824420384,-0.6013891417918057,-0.5843536561999139,-0.5670566497061674,-0.5495058633911126,-0.5317091519116020,-0.5136744799855326,-0.4954099188273244,-0.4769236425357393,-0.4582239244356557,-0.4393191333754320,-0.4202177299815245,-0.4009282628720287,-0.3814593648308430,-0.3618197489441589,-0.3420182047010202,-0.3220635940596869,-0.3019648474815634,-0.2817309599344703,-0.2613709868670497,-0.2408940401561006,-0.2203092840286600,-0.1996259309606554,-0.1788532375539676,-0.1580005003937403,-0.1370770518877979,-0.1160922560900344,-0.0950555045096311,-0.0739762119079976,-0.0528638120852981,-0.0317277536584616,-0.0105774958325586,0.0105774958325587,0.0317277536584620,0.0528638120852984,0.0739762119079975,0.0950555045096314,0.1160922560900346,0.1370770518877985,0.1580005003937407,0.1788532375539680,0.1996259309606554,0.2203092840286601,0.2408940401561006,0.2613709868670501,0.2817309599344704,0.3019648474815635,0.3220635940596872,0.3420182047010201,0.3618197489441584,0.3814593648308424,0.4009282628720290,0.4202177299815241,0.4393191333754320,0.4582239244356560,0.4769236425357400,0.4954099188273247,0.5136744799855328,0.5317091519116021,0.5495058633911124,0.5670566497061674,0.5843536561999139,0.6013891417918057,0.6181554824420388,0.6346451745636046,0.6508508383804379,0.6667652212301498,0.6823812008098832,0.6976917883638136,0.7126901318108938,0.7273695188114279,0.7417233797711034,0.7557452907811452,0.7694289764932645,0.7827683129281265,0.7957573302160746,0.8083902152688830,0.8206613143813489,0.8325651357615538,0.8440963519886699,0.8552498023972008,0.8660204953866033,0.8764036106552514,0.8863945013577424,0.8959886961845953,0.9051819013633988,0.9139700025805322,0.9223490668226100,0.9303153441368306,0.9378652693094834,0.9449954634618873,0.9517027355631156,0.9579840838589473,0.9638366972165756,0.9692579563848156,0.9742454351698641,0.9787969015273056,0.9829103185723908,0.9865838455137159,0.9898158385232458,0.9926048515777245,0.9949496373776262,0.9968491487225445,0.9983025420543603,0.9993091943300505,0.9998688787374442};

static const double w149[149] = {0.0001660029235740,0.0003863520697978,0.0006068570363804,0.0008271223886646,0.0010470282014218,0.0012664733821654,0.0014853599725144,0.0017035909586895,0.0019210698313007,0.0021377004919867,0.0023533872499007,0.0025680348462105,0.0027815484885371,0.0029938338892606,0.0032047973053823,0.0034143455789817,0.0036223861778369,0.0038288272359775,0.0040335775940814,0.0042365468396072,0.0044376453466554,0.0046367843154915,0.0048338758117369,0.0050288328051661,0.0052215692081334,0.0054119999135688,0.0056000408325566,0.0057856089314577,0.0059686222685738,0.0061490000303294,0.0063266625669485,0.0065015314276304,0.0066735293951875,0.0068425805201408,0.0070086101542578,0.0071715449835131,0.0073313130604622,0.0074878438360112,0.0076410681905678,0.0077909184645656,0.0079373284883347,0.0080802336113269,0.0082195707306568,0.0083552783189726,0.0084872964516210,0.0086155668331073,0.0087400328228388,0.0088606394601393,0.0089773334885080,0.0090900633791465,0.0091987793537081,0.0093034334062762,0.0094039793245666,0.0095003727103316,0.0095925709989644,0.0096805334782960,0.0097642213065697,0.0098435975295974,0.0099186270970729,0.0099892768780488,0.0100555156755728,0.0101173142404542,0.0101746452841883,0.0102274834909975,0.0102758055290185,0.0103195900605980,0.0103588177517207,0.0103934712805414,0.0104235353450372,0.0104489966697638,0.0104698440117167,0.0104860681652954,0.0104976619663725,0.0105046202954503,0.0105069400799262,0.0105046202954501,0.0104976619663725,0.0104860681652957,0.0104698440117167,0.0104489966697634,0.0104235353450376,0.0103934712805413,0.0103588177517209,0.0103195900605982,0.0102758055290179,0.0102274834909978,0.0101746452841885,0.0101173142404546,0.0100555156755725,0.0099892768780493,0.0099186270970720,0.0098435975295975,0.0097642213065699,0.0096805334782959,0.0095925709989638,0.0095003727103315,0.0094039793245670,0.0093034334062760,0.0091987793537080,0.0090900633791468,0.0089773334885083,0.0088606394601391,0.0087400328228392,0.0086155668331063,0.0084872964516212,0.0083552783189727,0.0082195707306565,0.0080802336113266,0.0079373284883349,0.0077909184645653,0.0076410681905682,0.0074878438360115,0.0073313130604619,0.0071715449835136,0.0070086101542573,0.0068425805201409,0.0066735293951876,0.0065015314276303,0.0063266625669486,0.0061490000303293,0.0059686222685739,0.0057856089314571,0.0056000408325567,0.0054119999135694,0.0052215692081330,0.0050288328051661,0.0048338758117365,0.0046367843154915,0.0044376453466549,0.0042365468396078,0.0040335775940818,0.0038288272359779,0.0036223861778365,0.0034143455789823,0.0032047973053825,0.0029938338892604,0.0027815484885365,0.0025680348462108,0.0023533872499007,0.0021377004919863,0.0019210698313006,0.0017035909586892,0.0014853599725146,0.0012664733821660,0.0010470282014218,0.0008271223886651,0.0006068570363804,0.0003863520697975,0.0001660029235742};
static const double pts149[149] = {-0.9998706269571738,-0.9993184038884794,-0.9983251681696677,-0.9968911376649928,-0.9950169185606875,-0.9927033319996845,-0.9899513974437101,-0.9867623291896231,-0.9831375350269428,-0.9790786153480312,-0.9745873623370883,-0.9696657591331881,-0.9643159789327816,-0.9585403840188756,-0.9523415247118080,-0.9457221382395998,-0.9386851475271831,-0.9312336599044325,-0.9233709657332269,-0.9151005369539738,-0.9064260255521424,-0.8973512619453919,-0.8878802532919969,-0.8780171817212702,-0.8677664024867648,-0.8571324420430509,-0.8461199960469061,-0.8347339272838152,-0.8229792635206697,-0.8108611952856234,-0.7983850735760882,-0.7855564074958699,-0.7723808618224900,-0.7588642545057742,-0.7450125540988015,-0.7308318771223543,-0.7163284853640304,-0.7015087831132083,-0.6863793143330937,-0.6709467597710856,-0.6552179340087443,-0.6391997824526590,-0.6228993782675584,-0.6063239192529923,-0.5894807246649845,-0.5723772319840608,-0.5550209936310596,-0.5374196736321976,-0.5195810442348521,-0.5015129824755539,-0.4832234667017067,-0.4647205730485781,-0.4460124718731016,-0.4271074241460789,-0.4080137778043633,-0.3887399640646551,-0.3692944937005003,-0.3496859532841833,-0.3299230013951338,-0.3100143647965397,-0.2899688345818590,-0.2697952622929161,-0.2495025560113136,-0.2290996764248696,-0.2085956328708339,-0.1879994793576173,-0.1673203105667964,-0.1465672578371564,-0.1257494851325511,-0.1048761849953547,-0.0839565744872896,-0.0629998911194396,-0.0420153887732148,-0.0210123336141046,0.0000000000000001,0.0210123336141043,0.0420153887732138,0.0629998911194394,0.0839565744872902,0.1048761849953547,0.1257494851325512,0.1465672578371561,0.1673203105667960,0.1879994793576177,0.2085956328708339,0.2290996764248695,0.2495025560113137,0.2697952622929164,0.2899688345818589,0.3100143647965397,0.3299230013951339,0.3496859532841839,0.3692944937005007,0.3887399640646546,0.4080137778043636,0.4271074241460778,0.4460124718731009,0.4647205730485776,0.4832234667017063,0.5015129824755528,0.5195810442348525,0.5374196736321979,0.5550209936310596,0.5723772319840617,0.5894807246649849,0.6063239192529921,0.6228993782675588,0.6391997824526591,0.6552179340087431,0.6709467597710851,0.6863793143330936,0.7015087831132079,0.7163284853640298,0.7308318771223541,0.7450125540988013,0.7588642545057742,0.7723808618224896,0.7855564074958703,0.7983850735760887,0.8108611952856239,0.8229792635206697,0.8347339272838160,0.8461199960469067,0.8571324420430511,0.8677664024867653,0.8780171817212705,0.8878802532919968,0.8973512619453921,0.9064260255521422,0.9151005369539738,0.9233709657332269,0.9312336599044331,0.9386851475271839,0.9457221382395999,0.9523415247118081,0.9585403840188758,0.9643159789327812,0.9696657591331879,0.9745873623370885,0.9790786153480313,0.9831375350269425,0.9867623291896227,0.9899513974437100,0.9927033319996844,0.9950169185606876,0.9968911376649925,0.9983251681696681,0.9993184038884793,0.9998706269571738};

static const double w150[150] = {0.0001638043352770,0.0003812360466059,0.0005988237432347,0.0008161784993053,0.0010331832462069,0.0012497394944473,0.0014657518418280,0.0016811258118384,0.0018957674181727,0.0021095830714959,0.0023224795748979,0.0025343641469735,0.0027451444547244,0.0029547286502953,0.0031630254092352,0.0033699439693713,0.0035753941698428,0.0037792864900890,0.0039815320886813,0.0041820428419239,0.0043807313821788,0.0045775111358942,0.0047722963612925,0.0049650021857104,0.0051555446425677,0.0053438407079425,0.0055298083367368,0.0057133664984263,0.0058944352123589,0.0060729355826039,0.0062487898323224,0.0064219213376625,0.0065922546611383,0.0067597155844998,0.0069242311410760,0.0070857296475616,0.0072441407352513,0.0073993953807044,0.0075514259358180,0.0077001661572996,0.0078455512355373,0.0079875178228310,0.0081260040609989,0.0082609496083316,0.0083922956658786,0.0085199850030773,0.0086439619826797,0.0087641725850007,0.0088805644314563,0.0089930868073825,0.0091016906841358,0.0092063287404540,0.0093069553830767,0.0094035267666117,0.0094960008126353,0.0095843372280358,0.0096684975225579,0.0097484450255857,0.0098241449021126,0.0098955641679241,0.0099626717039674,0.0100254382699121,0.0100838365168906,0.0101378409994142,0.0101874281864616,0.0102325764717298,0.0102732661830507,0.0103094795909592,0.0103412009164252,0.0103684163377203,0.0103911139964461,0.0104092840026988,0.0104229184393815,0.0104320113656479,0.0104365588194978,0.0104365588194978,0.0104320113656481,0.0104229184393812,0.0104092840026995,0.0103911139964456,0.0103684163377199,0.0103412009164256,0.0103094795909598,0.0102732661830504,0.0102325764717301,0.0101874281864615,0.0101378409994137,0.0100838365168904,0.0100254382699119,0.0099626717039675,0.0098955641679246,0.0098241449021131,0.0097484450255858,0.0096684975225580,0.0095843372280352,0.0094960008126353,0.0094035267666114,0.0093069553830775,0.0092063287404540,0.0091016906841362,0.0089930868073831,0.0088805644314568,0.0087641725850005,0.0086439619826790,0.0085199850030778,0.0083922956658787,0.0082609496083309,0.0081260040609993,0.0079875178228315,0.0078455512355372,0.0077001661572998,0.0075514259358176,0.0073993953807047,0.0072441407352511,0.0070857296475607,0.0069242311410767,0.0067597155845002,0.0065922546611379,0.0064219213376629,0.0062487898323225,0.0060729355826038,0.0058944352123592,0.0057133664984263,0.0055298083367364,0.0053438407079421,0.0051555446425682,0.0049650021857103,0.0047722963612925,0.0045775111358946,0.0043807313821790,0.0041820428419236,0.0039815320886815,0.0037792864900892,0.0035753941698425,0.0033699439693712,0.0031630254092352,0.0029547286502950,0.0027451444547243,0.0025343641469726,0.0023224795748983,0.0021095830714957,0.0018957674181728,0.0016811258118388,0.0014657518418284,0.0012497394944476,0.0010331832462067,0.0008161784993054,0.0005988237432348,0.0003812360466054,0.0001638043352772};
static const double pts150[150] = {-0.9998723404457335,-0.9993274305065946,-0.9983473449340833,-0.9969322929775998,-0.9950828645255290,-0.9927998590434373,-0.9900842691660191,-0.9869372772712792,-0.9833602541697531,-0.9793547582425896,-0.9749225346595949,-0.9700655145738376,-0.9647858142586955,-0.9590857341746903,-0.9529677579610972,-0.9464345513503145,-0.9394889610042834,-0.9321340132728527,-0.9243729128743137,-0.9162090414984958,-0.9076459563329236,-0.8986873885126236,-0.8893372414942058,-0.8795995893549102,-0.8694786750173528,-0.8589789084007133,-0.8481048644991848,-0.8368612813885015,-0.8252530581614231,-0.8132852527930610,-0.8009630799369828,-0.7882919086530555,-0.7752772600680047,-0.7619248049697274,-0.7482403613363831,-0.7342298918013644,-0.7198995010552308,-0.7052554331857485,-0.6903040689571924,-0.6750519230300926,-0.6595056411226445,-0.6436719971150086,-0.6275578900977730,-0.6111703413658551,-0.5945164913591591,-0.5776035965513140,-0.5604390262878621,-0.5430302595752541,-0.5253848818220793,-0.5075105815339174,-0.4894151469632755,-0.4711064627160670,-0.4525925063160998,-0.4338813447290867,-0.4149811308476708,-0.3959000999390260,-0.3766465660565524,-0.3572289184172501,-0.3376556177463402,-0.3179351925907264,-0.2980762356029074,-0.2780873997969573,-0.2579773947782036,-0.2377549829482451,-0.2174289756869711,-0.1970082295132339,-0.1765016422258558,-0.1559181490266509,-0.1352667186271444,-0.1145563493406963,-0.0937960651617234,-0.0729949118337356,-0.0521619529078925,-0.0313062657937975,-0.0104369378042604,0.0104369378042596,0.0313062657937971,0.0521619529078925,0.0729949118337357,0.0937960651617228,0.1145563493406953,0.1352667186271438,0.1559181490266513,0.1765016422258564,0.1970082295132340,0.2174289756869710,0.2377549829482449,0.2579773947782033,0.2780873997969572,0.2980762356029070,0.3179351925907260,0.3376556177463396,0.3572289184172498,0.3766465660565519,0.3959000999390255,0.4149811308476704,0.4338813447290860,0.4525925063160998,0.4711064627160662,0.4894151469632751,0.5075105815339173,0.5253848818220801,0.5430302595752549,0.5604390262878612,0.5776035965513142,0.5945164913591586,0.6111703413658554,0.6275578900977727,0.6436719971150082,0.6595056411226448,0.6750519230300932,0.6903040689571928,0.7052554331857491,0.7198995010552307,0.7342298918013638,0.7482403613363829,0.7619248049697270,0.7752772600680055,0.7882919086530551,0.8009630799369831,0.8132852527930610,0.8252530581614234,0.8368612813885017,0.8481048644991848,0.8589789084007136,0.8694786750173528,0.8795995893549106,0.8893372414942060,0.8986873885126240,0.9076459563329236,0.9162090414984955,0.9243729128743139,0.9321340132728526,0.9394889610042839,0.9464345513503151,0.9529677579610976,0.9590857341746907,0.9647858142586955,0.9700655145738376,0.9749225346595949,0.9793547582425899,0.9833602541697533,0.9869372772712800,0.9900842691660193,0.9927998590434371,0.9950828645255294,0.9969322929775997,0.9983473449340834,0.9993274305065950,0.9998723404457338};

static const double w151[151] = {0.0001616491368892,0.0003762209656988,0.0005909488834359,0.0008054503114945,0.0010196109485349,0.0012333348238792,0.0014465290084619,0.0016591014806161,0.0018709606952576,0.0020820154908375,0.0022921750838054,0.0025013490903538,0.0027094475578553,0.0029163810000862,0.0031220604339770,0.0033263974169640,0.0035293040845106,0.0037306931875993,0.0039304781300730,0.0041285730057616,0.0043248926353545,0.0045193526029800,0.0047118692924754,0.0049023599233202,0.0050907425862169,0.0052769362783054,0.0054608609379785,0.0056424374793100,0.0058215878260539,0.0059982349452147,0.0061723028801662,0.0063437167833163,0.0065124029482837,0.0066782888415929,0.0068413031338616,0.0070013757304704,0.0071584378017063,0.0073124218123508,0.0074632615507286,0.0076108921571683,0.0077552501518991,0.0078962734623407,0.0080339014497980,0.0081680749355328,0.0082987362262113,0.0084258291387076,0.0085492990242683,0.0086690927920079,0.0087851589317328,0.0088974475361001,0.0090059103220677,0.0091105006516613,0.0092111735520259,0.0093078857347633,0.0094005956145483,0.0094892633270058,0.0095738507458587,0.0096543214993132,0.0097306409857056,0.0098027763883750,0.0098706966897819,0.0099343726848361,0.0099937769934622,0.0100488840723658,0.0100996702260248,0.0101461136168713,0.0101881942746877,0.0102258941051870,0.0102591968977977,0.0102880883326333,0.0103125559866508,0.0103325893389882,0.0103481797754946,0.0103593205924288,0.0103660069993447,0.0103682361211501,0.0103660069993438,0.0103593205924287,0.0103481797754948,0.0103325893389882,0.0103125559866514,0.0102880883326336,0.0102591968977974,0.0102258941051865,0.0101881942746882,0.0101461136168721,0.0100996702260243,0.0100488840723655,0.0099937769934618,0.0099343726848361,0.0098706966897820,0.0098027763883757,0.0097306409857056,0.0096543214993131,0.0095738507458584,0.0094892633270068,0.0094005956145480,0.0093078857347635,0.0092111735520260,0.0091105006516616,0.0090059103220681,0.0088974475361002,0.0087851589317329,0.0086690927920070,0.0085492990242683,0.0084258291387080,0.0082987362262103,0.0081680749355337,0.0080339014497979,0.0078962734623403,0.0077552501518988,0.0076108921571677,0.0074632615507285,0.0073124218123512,0.0071584378017056,0.0070013757304710,0.0068413031338614,0.0066782888415925,0.0065124029482838,0.0063437167833170,0.0061723028801663,0.0059982349452143,0.0058215878260535,0.0056424374793104,0.0054608609379781,0.0052769362783053,0.0050907425862168,0.0049023599233199,0.0047118692924756,0.0045193526029803,0.0043248926353550,0.0041285730057623,0.0039304781300734,0.0037306931875991,0.0035293040845102,0.0033263974169636,0.0031220604339770,0.0029163810000857,0.0027094475578552,0.0025013490903540,0.0022921750838061,0.0020820154908373,0.0018709606952573,0.0016591014806169,0.0014465290084629,0.0012333348238788,0.0010196109485352,0.0008054503114944,0.0005909488834359,0.0003762209656985,0.0001616491368889};
static const double pts151[151] = {-0.9998740201170466,-0.9993362789976042,-0.9983690841669448,-0.9969726365788608,-0.9951475103608314,-0.9928944840099513,-0.9902145242098266,-0.9871087824610021,-0.9835785938007119,-0.9796254759676865,-0.9752511286479646,-0.9704574326996506,-0.9652464493229419,-0.9596204191629233,-0.9535817613401683,-0.9471330724071293,-0.9402771252296179,-0.9330168677932350,-0.9253554219349649,-0.9172960820002858,-0.9088423134262814,-0.8999977512512842,-0.8907661985516846,-0.8811516248065120,-0.8711581641905145,-0.8607901137964338,-0.8500519317872521,-0.8389482354791856,-0.8274837993562549,-0.8156635530172796,-0.8034925790561827,-0.7909761108765098,-0.7781195304411043,-0.7649283659579064,-0.7514082895028679,-0.7375651145810111,-0.7234047936266692,-0.7089334154439940,-0.6941572025888230,-0.6790825086930379,-0.6637158157325614,-0.6480637312401671,-0.6321329854643005,-0.6159304284751335,-0.5994630272191012,-0.5827378625231758,-0.5657621260501822,-0.5485431172064448,-0.5310882400031148,-0.5134049998725153,-0.4955010004408728,-0.4773839402588324,-0.4590616094911482,-0.4405418865669948,-0.4218327347923083,-0.4029421989256460,-0.3838784017190117,-0.3646495404251487,-0.3452638832728031,-0.3257297659114589,-0.3060555878270891,-0.2862498087304561,-0.2663209449195159,-0.2462775656174880,-0.2261282892881736,-0.2058817799300958,-0.1855467433510632,-0.1651319234247516,-0.1446460983309253,-0.1240980767808987,-0.1034966942298762,-0.0828508090777888,-0.0621692988602661,-0.0414610564313778,-0.0207349861397954,-0.0000000000000001,0.0207349861397958,0.0414610564313787,0.0621692988602659,0.0828508090777893,0.1034966942298766,0.1240980767808983,0.1446460983309249,0.1651319234247512,0.1855467433510627,0.2058817799300958,0.2261282892881737,0.2462775656174879,0.2663209449195162,0.2862498087304566,0.3060555878270898,0.3257297659114587,0.3452638832728027,0.3646495404251487,0.3838784017190112,0.4029421989256461,0.4218327347923088,0.4405418865669944,0.4590616094911479,0.4773839402588320,0.4955010004408729,0.5134049998725159,0.5310882400031153,0.5485431172064446,0.5657621260501821,0.5827378625231761,0.5994630272191006,0.6159304284751337,0.6321329854643005,0.6480637312401676,0.6637158157325614,0.6790825086930377,0.6941572025888219,0.7089334154439937,0.7234047936266699,0.7375651145810111,0.7514082895028680,0.7649283659579061,0.7781195304411040,0.7909761108765101,0.8034925790561828,0.8156635530172792,0.8274837993562554,0.8389482354791857,0.8500519317872525,0.8607901137964336,0.8711581641905145,0.8811516248065122,0.8907661985516847,0.8999977512512841,0.9088423134262802,0.9172960820002861,0.9253554219349642,0.9330168677932349,0.9402771252296183,0.9471330724071299,0.9535817613401684,0.9596204191629238,0.9652464493229420,0.9704574326996507,0.9752511286479651,0.9796254759676869,0.9835785938007118,0.9871087824610022,0.9902145242098268,0.9928944840099517,0.9951475103608318,0.9969726365788608,0.9983690841669449,0.9993362789976049,0.9998740201170467};

static const double w152[152] = {0.0001595361941395,0.0003713041890925,0.0005832283187687,0.0007949321955600,0.0010063041994485,0.0012172507976484,0.0014276814543999,0.0016375065236385,0.0018466368228101,0.0020549835400368,0.0022624582276550,0.0024689728226831,0.0026744396768663,0.0028787715904595,0.0030818818475291,0.0032836842518490,0.0034840931629875,0.0036830235323561,0.0038803909391357,0.0040761116259897,0.0042701025345447,0.0044622813405953,0.0046525664890044,0.0048408772283020,0.0050271336449296,0.0052112566971543,0.0053931682485959,0.0055727911013855,0.0057500490289220,0.0059248668082161,0.0060971702518117,0.0062668862392662,0.0064339427481826,0.0065982688847664,0.0067597949139191,0.0069184522888223,0.0070741736800330,0.0072268930040510,0.0073765454513660,0.0075230675139593,0.0076663970122550,0.0078064731215044,0.0079432363976031,0.0080766288023122,0.0082065937278906,0.0083330760211185,0.0084560220066966,0.0085753795100363,0.0086910978793867,0.0088031280073386,0.0089114223516649,0.0090159349554885,0.0091166214667937,0.0092134391572422,0.0093063469403066,0.0093953053887085,0.0094802767511491,0.0095612249683275,0.0096381156882475,0.0097109162807909,0.0097795958515688,0.0098441252550290,0.0099044771068276,0.0099606257954470,0.0100125474930664,0.0100602201656743,0.0101036235824167,0.0101427393241841,0.0101775507914282,0.0102080432112069,0.0102342036434487,0.0102560209864528,0.0102734859815917,0.0102865912172444,0.0102953311319423,0.0102997020167282,0.0102997020167281,0.0102953311319422,0.0102865912172445,0.0102734859815917,0.0102560209864528,0.0102342036434490,0.0102080432112067,0.0101775507914289,0.0101427393241838,0.0101036235824163,0.0100602201656747,0.0100125474930667,0.0099606257954474,0.0099044771068271,0.0098441252550287,0.0097795958515687,0.0097109162807910,0.0096381156882471,0.0095612249683271,0.0094802767511490,0.0093953053887091,0.0093063469403067,0.0092134391572420,0.0091166214667942,0.0090159349554889,0.0089114223516649,0.0088031280073384,0.0086910978793865,0.0085753795100366,0.0084560220066970,0.0083330760211180,0.0082065937278911,0.0080766288023126,0.0079432363976027,0.0078064731215043,0.0076663970122550,0.0075230675139596,0.0073765454513664,0.0072268930040508,0.0070741736800330,0.0069184522888224,0.0067597949139189,0.0065982688847665,0.0064339427481814,0.0062668862392664,0.0060971702518116,0.0059248668082165,0.0057500490289220,0.0055727911013858,0.0053931682485958,0.0052112566971540,0.0050271336449299,0.0048408772283019,0.0046525664890044,0.0044622813405949,0.0042701025345451,0.0040761116259893,0.0038803909391356,0.0036830235323563,0.0034840931629874,0.0032836842518489,0.0030818818475290,0.0028787715904601,0.0026744396768664,0.0024689728226832,0.0022624582276555,0.0020549835400366,0.0018466368228102,0.0016375065236383,0.0014276814544000,0.0012172507976485,0.0010063041994482,0.0007949321955596,0.0005832283187695,0.0003713041890923,0.0001595361941395};
static const double pts152[152] = {-0.9998756668551735,-0.9993449540174619,-0.9983903973015599,-0.9970121896717249,-0.9952108900104762,-0.9929872565277192,-0.9903422307978290,-0.9872769344447929,-0.9837926678913778,-0.9798909095495502,-0.9755733150928300,-0.9708417167098640,-0.9656981223059573,-0.9601447146402083,-0.9541838503933496,-0.9478180591642773,-0.9410500423945595,-0.9338826722207909,-0.9263189902549390,-0.9183622062930652,-0.9100156969528296,-0.9012830042403142,-0.8921678340467356,-0.8826740545756580,-0.8728056947013501,-0.8625669422589951,-0.8519621422674456,-0.8409957950852989,-0.8296725545010436,-0.8179972257581180,-0.8059747635156901,-0.7936102697460341,-0.7809089915693985,-0.7678763190272762,-0.7545177827950273,-0.7408390518348200,-0.7268459309898887,-0.7125443585211290,-0.6979404035870774,-0.6830402636683358,-0.6678502619375465,-0.6523768445760292,-0.6366265780382059,-0.6206061462649997,-0.6043223478473689,-0.5877820931411826,-0.5709924013346790,-0.5539603974697297,-0.5366933094181808,-0.5191984648145656,-0.5014832879464747,-0.4835552966039069,-0.4654220988889490,-0.4470913899871233,-0.4285709489017787,-0.4098686351529178,-0.3909923854418531,-0.3719502102831053,-0.3527501906049813,-0.3334004743202735,-0.3139092728685269,-0.2942848577313505,-0.2745355569222496,-0.2546697514524654,-0.2346958717743251,-0.2146223942036120,-0.1944578373224685,-0.1742107583643660,-0.1538897495826744,-0.1335034346043626,-0.1130604647703930,-0.0925695154643514,-0.0720392824308712,-0.0514784780854252,-0.0308958278170323,-0.0103000662854674,0.0103000662854671,0.0308958278170320,0.0514784780854250,0.0720392824308709,0.0925695154643510,0.1130604647703927,0.1335034346043622,0.1538897495826743,0.1742107583643656,0.1944578373224678,0.2146223942036118,0.2346958717743255,0.2546697514524656,0.2745355569222495,0.2942848577313508,0.3139092728685271,0.3334004743202738,0.3527501906049815,0.3719502102831049,0.3909923854418536,0.4098686351529180,0.4285709489017785,0.4470913899871231,0.4654220988889495,0.4835552966039071,0.5014832879464742,0.5191984648145661,0.5366933094181798,0.5539603974697297,0.5709924013346793,0.5877820931411822,0.6043223478473687,0.6206061462650000,0.6366265780382061,0.6523768445760297,0.6678502619375468,0.6830402636683353,0.6979404035870771,0.7125443585211293,0.7268459309898887,0.7408390518348198,0.7545177827950278,0.7678763190272764,0.7809089915693986,0.7936102697460347,0.8059747635156904,0.8179972257581183,0.8296725545010433,0.8409957950852984,0.8519621422674460,0.8625669422589948,0.8728056947013501,0.8826740545756581,0.8921678340467362,0.9012830042403147,0.9100156969528297,0.9183622062930662,0.9263189902549394,0.9338826722207908,0.9410500423945602,0.9478180591642769,0.9541838503933497,0.9601447146402087,0.9656981223059573,0.9708417167098646,0.9755733150928300,0.9798909095495506,0.9837926678913775,0.9872769344447923,0.9903422307978287,0.9929872565277190,0.9952108900104765,0.9970121896717248,0.9983903973015597,0.9993449540174620,0.9998756668551732};

static const double w153[153] = {0.0001574644095804,0.0003664831644134,0.0005756580452288,0.0007846187042400,0.0009932561200541,0.0012014791199650,0.0014091994847601,0.0016163298677909,0.0018227833733601,0.0020284734641392,0.0022333139538357,0.0024372190264481,0.0026401032649828,0.0028418816838572,0.0030424697628229,0.0032417834814726,0.0034397393539424,0.0036362544636022,0.0038312464976070,0.0040246337812761,0.0042163353122351,0.0044062707942999,0.0045943606710806,0.0047805261592880,0.0049646892817135,0.0051467728998875,0.0053267007463775,0.0055043974567330,0.0056797886010433,0.0058528007151163,0.0060233613312453,0.0061913990085586,0.0063568433629478,0.0065196250965417,0.0066796760267362,0.0068369291147519,0.0069913184937100,0.0071427794962248,0.0072912486814896,0.0074366638618467,0.0075789641288376,0.0077180898787133,0.0078539828374022,0.0079865860849129,0.0081158440791842,0.0082417026793420,0.0083641091683790,0.0084830122752365,0.0085983621962806,0.0087101106161592,0.0088182107280411,0.0089226172532249,0.0090232864600982,0.0091201761824593,0.0092132458371783,0.0093024564411931,0.0093877706278414,0.0094691526625098,0.0095465684576021,0.0096199855868165,0.0096893732987304,0.0097547025296757,0.0098159459159191,0.0098730778051173,0.0099260742670653,0.0099749131037197,0.0100195738584948,0.0100600378248327,0.0100962880540376,0.0101283093623747,0.0101560883374330,0.0101796133437378,0.0101988745276303,0.0102138638213900,0.0102245749466168,0.0102310034168594,0.0102331465394958,0.0102310034168599,0.0102245749466163,0.0102138638213903,0.0101988745276300,0.0101796133437381,0.0101560883374322,0.0101283093623747,0.0100962880540371,0.0100600378248325,0.0100195738584946,0.0099749131037196,0.0099260742670652,0.0098730778051168,0.0098159459159194,0.0097547025296759,0.0096893732987300,0.0096199855868162,0.0095465684576019,0.0094691526625097,0.0093877706278416,0.0093024564411933,0.0092132458371780,0.0091201761824598,0.0090232864600985,0.0089226172532251,0.0088182107280413,0.0087101106161589,0.0085983621962807,0.0084830122752368,0.0083641091683783,0.0082417026793415,0.0081158440791843,0.0079865860849132,0.0078539828374021,0.0077180898787139,0.0075789641288371,0.0074366638618474,0.0072912486814898,0.0071427794962249,0.0069913184937099,0.0068369291147517,0.0066796760267366,0.0065196250965424,0.0063568433629479,0.0061913990085588,0.0060233613312450,0.0058528007151165,0.0056797886010438,0.0055043974567326,0.0053267007463775,0.0051467728998868,0.0049646892817132,0.0047805261592876,0.0045943606710815,0.0044062707943000,0.0042163353122356,0.0040246337812757,0.0038312464976070,0.0036362544636022,0.0034397393539431,0.0032417834814715,0.0030424697628229,0.0028418816838576,0.0026401032649825,0.0024372190264480,0.0022333139538354,0.0020284734641390,0.0018227833733604,0.0016163298677908,0.0014091994847604,0.0012014791199652,0.0009932561200540,0.0007846187042396,0.0005756580452291,0.0003664831644127,0.0001574644095811};
static const double pts153[153] = {-0.9998772815154704,-0.9993534600709890,-0.9984112954002311,-0.9970509727714357,-0.9952730363180596,-0.9930782246177330,-0.9904674549449133,-0.9874418200092623,-0.9840025867331771,-0.9801511954667574,-0.9758892592855499,-0.9712185632716619,-0.9661410637453923,-0.9606588874351777,-0.9547743305810086,-0.9484898579693091,-0.9418081018985563,-0.9347318610754973,-0.9272640994420993,-0.9194079449335675,-0.9111666881678289,-0.9025437810669967,-0.8935428354113332,-0.8841676213263036,-0.8744220657033424,-0.8643102505549755,-0.8538364113049832,-0.8430049350143224,-0.8318203585435426,-0.8202873666524528,-0.8084107900378594,-0.7961956033101675,-0.7836469229097144,-0.7707700049636921,-0.7575702430845664,-0.7440531661109084,-0.7302244357915871,-0.7160898444142907,-0.7016553123793710,-0.6869268857200317,-0.6719107335698897,-0.6566131455789748,-0.6410405292792526,-0.6251994074007741,-0.6090964151395660,-0.5927382973784222,-0.5761319058617469,-0.5592841963256373,-0.5422022255844161,-0.5248931485748161,-0.5073642153590719,-0.4896227680881644,-0.4716762379265012,-0.4535321419392955,-0.4351980799439838,-0.4166817313269728,-0.3979908518270582,-0.3791332702868626,-0.3601168853736564,-0.3409496622709279,-0.3216396293420982,-0.3021948747677643,-0.2826235431578953,-0.2629338321403898,-0.2431339889274209,-0.2232323068610247,-0.2032371219393536,-0.1831568093250699,-0.1629997798373353,-0.1427744764288637,-0.1224893706495122,-0.1021529590978992,-0.0817737598625257,-0.0613603089538974,-0.0409211567291434,-0.0204648643106178,0.0000000000000002,0.0204648643106181,0.0409211567291434,0.0613603089538977,0.0817737598625254,0.1021529590978986,0.1224893706495120,0.1427744764288634,0.1629997798373349,0.1831568093250691,0.2032371219393534,0.2232323068610250,0.2431339889274211,0.2629338321403895,0.2826235431578958,0.3021948747677645,0.3216396293420984,0.3409496622709285,0.3601168853736563,0.3791332702868627,0.3979908518270582,0.4166817313269729,0.4351980799439836,0.4535321419392951,0.4716762379265011,0.4896227680881653,0.5073642153590718,0.5248931485748164,0.5422022255844166,0.5592841963256370,0.5761319058617458,0.5927382973784225,0.6090964151395660,0.6251994074007747,0.6410405292792528,0.6566131455789749,0.6719107335698904,0.6869268857200322,0.7016553123793710,0.7160898444142901,0.7302244357915877,0.7440531661109088,0.7575702430845666,0.7707700049636920,0.7836469229097144,0.7961956033101679,0.8084107900378592,0.8202873666524529,0.8318203585435420,0.8430049350143225,0.8538364113049824,0.8643102505549753,0.8744220657033428,0.8841676213263039,0.8935428354113325,0.9025437810669965,0.9111666881678286,0.9194079449335670,0.9272640994420999,0.9347318610754971,0.9418081018985558,0.9484898579693090,0.9547743305810088,0.9606588874351772,0.9661410637453919,0.9712185632716623,0.9758892592855498,0.9801511954667578,0.9840025867331780,0.9874418200092624,0.9904674549449130,0.9930782246177333,0.9952730363180592,0.9970509727714352,0.9984112954002307,0.9993534600709887,0.9998772815154703};

static const double w154[154] = {0.0001554327211634,0.0003617554215834,0.0005682341878323,0.0007745045656415,0.0009804600526490,0.0011860117613933,0.0013910737153859,0.0015955607941157,0.0017993883159604,0.0020024719458765,0.0022047276872575,0.0024060719000319,0.0026064213281099,0.0028056931304788,0.0030038049137952,0.0032006747655750,0.0033962212875709,0.0035903636291517,0.0037830215205605,0.0039741153059962,0.0041635659764878,0.0043512952025125,0.0045372253663557,0.0047212795941833,0.0049033817878101,0.0050834566561580,0.0052614297463724,0.0054372274746043,0.0056107771564326,0.0057820070369070,0.0059508463202174,0.0061172251989641,0.0062810748830145,0.0064423276279500,0.0066009167630692,0.0067567767189544,0.0069098430545827,0.0070600524839667,0.0072073429023222,0.0073516534117435,0.0074929243463844,0.0076310972971233,0.0077661151357164,0.0078979220384166,0.0080264635090514,0.0081516864015586,0.0082735389419563,0.0083919707497494,0.0085069328587655,0.0086183777373888,0.0087262593082229,0.0088305329671361,0.0089311556017053,0.0090280856090389,0.0091212829129807,0.0092107089806769,0.0092963268385098,0.0093781010873807,0.0094559979173533,0.0095299851216233,0.0096000321098436,0.0096661099207631,0.0097281912342096,0.0097862503823768,0.0098402633604453,0.0098902078364998,0.0099360631607678,0.0099778103741557,0.0100154322160859,0.0100489131316354,0.0100782392779657,0.0101033985300473,0.0101243804856721,0.0101411764697530,0.0101537795379143,0.0101621844793600,0.0101663878190277,0.0101663878190277,0.0101621844793604,0.0101537795379148,0.0101411764697528,0.0101243804856712,0.0101033985300467,0.0100782392779657,0.0100489131316356,0.0100154322160865,0.0099778103741562,0.0099360631607683,0.0098902078364996,0.0098402633604454,0.0097862503823772,0.0097281912342096,0.0096661099207631,0.0096000321098435,0.0095299851216239,0.0094559979173531,0.0093781010873803,0.0092963268385090,0.0092107089806768,0.0091212829129810,0.0090280856090381,0.0089311556017051,0.0088305329671359,0.0087262593082231,0.0086183777373888,0.0085069328587655,0.0083919707497502,0.0082735389419560,0.0081516864015590,0.0080264635090516,0.0078979220384161,0.0077661151357164,0.0076310972971231,0.0074929243463838,0.0073516534117435,0.0072073429023227,0.0070600524839671,0.0069098430545824,0.0067567767189546,0.0066009167630697,0.0064423276279504,0.0062810748830150,0.0061172251989633,0.0059508463202171,0.0057820070369075,0.0056107771564325,0.0054372274746052,0.0052614297463719,0.0050834566561578,0.0049033817878103,0.0047212795941829,0.0045372253663561,0.0043512952025123,0.0041635659764877,0.0039741153059966,0.0037830215205597,0.0035903636291520,0.0033962212875709,0.0032006747655741,0.0030038049137954,0.0028056931304793,0.0026064213281100,0.0024060719000323,0.0022047276872574,0.0020024719458764,0.0017993883159605,0.0015955607941157,0.0013910737153853,0.0011860117613930,0.0009804600526499,0.0007745045656416,0.0005682341878322,0.0003617554215832,0.0001554327211633};
static const double pts154[154] = {-0.9998788649257053,-0.9993618015177256,-0.9984317891686133,-0.9970890057321237,-0.9953339810694058,-0.9931674347555464,-0.9905902605433032,-0.9876035231533122,-0.9842084570789579,-0.9804064658248862,-0.9761991212290436,-0.9715881627701177,-0.9665754968279338,-0.9611631958847645,-0.9553534976627389,-0.9491488041953690,-0.9425516808324653,-0.9355648551782713,-0.9281912159629507,-0.9204338118477198,-0.9122958501640276,-0.9037806955872320,-0.8948918687452975,-0.8856330447630573,-0.8760080517426346,-0.8660208691806303,-0.8556756263227376,-0.8449766004564515,-0.8339282151425784,-0.8225350383862721,-0.8108017807483584,-0.7987332933977186,-0.7863345661055393,-0.7736107251822649,-0.7605670313580905,-0.7472088776078873,-0.7335417869214459,-0.7195714100199693,-0.7053035230197522,-0.6907440250440172,-0.6758989357838935,-0.6607743930095465,-0.6453766500324883,-0.6297120731201123,-0.6137871388635360,-0.5976084314998178,-0.5811826401896755,-0.5645165562518264,-0.5476170703550758,-0.5304911696693433,-0.5131459349767872,-0.4955885377442165,-0.4778262371580189,-0.4598663771228146,-0.4417163832250877,-0.4233837596630406,-0.4048760861439475,-0.3862010147502939,-0.3673662667759841,-0.3483796295339395,-0.3292489531363943,-0.3099821472492352,-0.2905871778217106,-0.2710720637928732,-0.2514448737761133,-0.2317137227231516,-0.2118867685688778,-0.1919722088584129,-0.1719782773577980,-0.1519132406497039,-0.1317853947155768,-0.1116030615056267,-0.0913745854980753,-0.0711083302490973,-0.0508126749348691,-0.0304960108871579,-0.0101667381238872,0.0101667381238867,0.0304960108871569,0.0508126749348690,0.0711083302490974,0.0913745854980748,0.1116030615056259,0.1317853947155765,0.1519132406497034,0.1719782773577977,0.1919722088584128,0.2118867685688773,0.2317137227231515,0.2514448737761131,0.2710720637928736,0.2905871778217107,0.3099821472492355,0.3292489531363941,0.3483796295339388,0.3673662667759843,0.3862010147502943,0.4048760861439475,0.4233837596630405,0.4417163832250883,0.4598663771228149,0.4778262371580189,0.4955885377442161,0.5131459349767868,0.5304911696693431,0.5476170703550752,0.5645165562518263,0.5811826401896757,0.5976084314998167,0.6137871388635358,0.6297120731201120,0.6453766500324878,0.6607743930095467,0.6758989357838932,0.6907440250440172,0.7053035230197519,0.7195714100199695,0.7335417869214460,0.7472088776078880,0.7605670313580906,0.7736107251822653,0.7863345661055398,0.7987332933977191,0.8108017807483593,0.8225350383862721,0.8339282151425781,0.8449766004564514,0.8556756263227373,0.8660208691806303,0.8760080517426346,0.8856330447630575,0.8948918687452971,0.9037806955872322,0.9122958501640281,0.9204338118477208,0.9281912159629513,0.9355648551782714,0.9425516808324651,0.9491488041953687,0.9553534976627389,0.9611631958847643,0.9665754968279339,0.9715881627701178,0.9761991212290441,0.9804064658248863,0.9842084570789582,0.9876035231533120,0.9905902605433036,0.9931674347555464,0.9953339810694061,0.9970890057321239,0.9984317891686135,0.9993618015177257,0.9998788649257053};

static const double w155[155] = {0.0001534401008733,0.0003571185696594,0.0005609529956593,0.0007645846765091,0.0009679095522510,0.0011708409486668,0.0013732950609801,0.0015751889243258,0.0017764400011273,0.0019769660890999,0.0021766853123423,0.0023755161383329,0.0025733774041697,0.0027701883464129,0.0029658686324055,0.0031603383922042,0.0033535182506892,0.0035453293596941,0.0037356934300177,0.0039245327632756,0.0041117702835489,0.0042973295688023,0.0044811348820476,0.0046631112022342,0.0048431842548588,0.0050212805422717,0.0051973273736666,0.0053712528947469,0.0055429861170479,0.0057124569469123,0.0058795962140906,0.0060443356999778,0.0062066081654545,0.0063663473783278,0.0065234881403653,0.0066779663139066,0.0068297188480380,0.0069786838043290,0.0071248003821118,0.0072680089432966,0.0074082510367138,0.0075454694219704,0.0076796080928144,0.0078106122999892,0.0079384285735848,0.0080630047448619,0.0081842899675382,0.0083022347385486,0.0084167909182483,0.0085279117500579,0.0086355518795510,0.0087396673729633,0.0088402157351264,0.0089371559268106,0.0090304483814770,0.0091200550214237,0.0092059392733321,0.0092880660831893,0.0093664019305988,0.0094409148424620,0.0095115744060249,0.0095783517812969,0.0096412197128143,0.0097001525407735,0.0097551262114968,0.0098061182872532,0.0098531079554181,0.0098960760369627,0.0099350049942886,0.0099698789383809,0.0100006836352946,0.0100274065119672,0.0100500366613447,0.0100685648468397,0.0100829835060955,0.0100932867540782,0.0100994703854731,0.0101015318764076,0.0100994703854735,0.0100932867540781,0.0100829835060955,0.0100685648468394,0.0100500366613449,0.0100274065119667,0.0100006836352952,0.0099698789383812,0.0099350049942880,0.0098960760369620,0.0098531079554175,0.0098061182872543,0.0097551262114971,0.0097001525407731,0.0096412197128147,0.0095783517812965,0.0095115744060249,0.0094409148424617,0.0093664019305993,0.0092880660831897,0.0092059392733321,0.0091200550214237,0.0090304483814767,0.0089371559268110,0.0088402157351264,0.0087396673729636,0.0086355518795509,0.0085279117500586,0.0084167909182480,0.0083022347385490,0.0081842899675383,0.0080630047448616,0.0079384285735852,0.0078106122999891,0.0076796080928142,0.0075454694219711,0.0074082510367141,0.0072680089432966,0.0071248003821117,0.0069786838043290,0.0068297188480379,0.0066779663139067,0.0065234881403654,0.0063663473783272,0.0062066081654545,0.0060443356999775,0.0058795962140903,0.0057124569469124,0.0055429861170486,0.0053712528947466,0.0051973273736664,0.0050212805422715,0.0048431842548585,0.0046631112022340,0.0044811348820474,0.0042973295688030,0.0041117702835482,0.0039245327632746,0.0037356934300179,0.0035453293596945,0.0033535182506892,0.0031603383922043,0.0029658686324057,0.0027701883464125,0.0025733774041696,0.0023755161383332,0.0021766853123418,0.0019769660891007,0.0017764400011277,0.0015751889243255,0.0013732950609801,0.0011708409486669,0.0009679095522515,0.0007645846765093,0.0005609529956597,0.0003571185696592,0.0001534401008730};
static const double pts155[155] = {-0.9998804178871166,-0.9993699825775185,-0.9984518889694197,-0.9971263077722053,-0.9953937550331777,-0.9932549319305473,-0.9907107094438939,-0.9877621251948236,-0.9844103822782331,-0.9806568485233966,-0.9765030558392621,-0.9719506995470669,-0.9670016376682399,-0.9616578901556886,-0.9559216380637043,-0.9497952226545249,-0.9432811444408075,-0.9363820621638429,-0.9291007917076145,-0.9214403049489818,-0.9134037285443670,-0.9049943426533574,-0.8962155795997396,-0.8870710224704632,-0.8775644036531085,-0.8676996033124336,-0.8574806478066246,-0.8469117080438854,-0.8359970977800419,-0.8247412718578389,-0.8131488243886655,-0.8012244868774384,-0.7889731262914055,-0.7763997430736675,-0.7635094691022214,-0.7503075655953546,-0.7367994209642570,-0.7229905486137145,-0.7088865846917831,-0.6944932857893769,-0.6798165265906828,-0.6648622974753883,-0.6496367020736767,-0.6341459547750086,-0.6183963781916895,-0.6023944005782707,-0.5861465532078269,-0.5696594677061950,-0.5529398733452425,-0.5359945942962889,-0.5188305468447936,-0.5014547365674428,-0.4838742554727950,-0.4660962791066510,-0.4481280636233184,-0.4299769428239882,-0.4116503251634120,-0.3931556907261091,-0.3745005881733395,-0.3556926316620873,-0.3367394977373108,-0.3176489221987281,-0.2984286969434210,-0.2790866667855370,-0.2596307262543961,-0.2400688163723093,-0.2204089214134135,-0.2006590656448611,-0.1808273100516785,-0.1609217490466434,-0.1409505071665181,-0.1209217357559833,-0.1008436096406363,-0.0807243237903999,-0.0605720899747127,-0.0403951334108625,-0.0202016894068265,-0.0000000000000003,0.0202016894068257,0.0403951334108621,0.0605720899747125,0.0807243237903994,0.1008436096406360,0.1209217357559833,0.1409505071665179,0.1609217490466434,0.1808273100516785,0.2006590656448606,0.2204089214134134,0.2400688163723087,0.2596307262543955,0.2790866667855365,0.2984286969434208,0.3176489221987281,0.3367394977373102,0.3556926316620869,0.3745005881733396,0.3931556907261096,0.4116503251634128,0.4299769428239887,0.4481280636233185,0.4660962791066511,0.4838742554727958,0.5014547365674424,0.5188305468447933,0.5359945942962882,0.5529398733452422,0.5696594677061959,0.5861465532078274,0.6023944005782705,0.6183963781916890,0.6341459547750083,0.6496367020736765,0.6648622974753879,0.6798165265906831,0.6944932857893770,0.7088865846917835,0.7229905486137145,0.7367994209642575,0.7503075655953545,0.7635094691022211,0.7763997430736671,0.7889731262914051,0.8012244868774383,0.8131488243886656,0.8247412718578386,0.8359970977800418,0.8469117080438854,0.8574806478066237,0.8676996033124329,0.8775644036531084,0.8870710224704633,0.8962155795997397,0.9049943426533572,0.9134037285443674,0.9214403049489822,0.9291007917076144,0.9363820621638430,0.9432811444408077,0.9497952226545249,0.9559216380637044,0.9616578901556888,0.9670016376682405,0.9719506995470676,0.9765030558392622,0.9806568485233967,0.9844103822782334,0.9877621251948239,0.9907107094438944,0.9932549319305478,0.9953937550331783,0.9971263077722063,0.9984518889694205,0.9993699825775191,0.9998804178871169};

static const double w156[156] = {0.0001514855534319,0.0003525702938081,0.0005538108371216,0.0007548540957955,0.0009555983784903,0.0011559591549466,0.0013558547237720,0.0015552042079106,0.0017539271464470,0.0019519434029396,0.0021491731557969,0.0023455369142272,0.0025409555433232,0.0027353502927055,0.0029286428266373,0.0031207552547357,0.0033116101628857,0.0035011306441621,0.0036892403296528,0.0038758634191352,0.0040609247115540,0.0042443496352801,0.0044260642781375,0.0046059954171613,0.0047840705480966,0.0049602179145988,0.0051343665371473,0.0053064462416381,0.0054763876876616,0.0056441223964364,0.0058095827784048,0.0059727021604661,0.0061334148128393,0.0062916559755528,0.0064473618845347,0.0066004697973098,0.0067509180182801,0.0068986459235841,0.0070435939855259,0.0071857037965632,0.0073249180928419,0.0074611807772700,0.0075944369421217,0.0077246328911653,0.0078517161612979,0.0079756355436876,0.0080963411044027,0.0082137842045434,0.0083279175198288,0.0084386950596753,0.0085460721857272,0.0086500056298385,0.0087504535115151,0.0088473753547862,0.0089407321045167,0.0090304861421419,0.0091166013008295,0.0091990428800511,0.0092777776595645,0.0093527739128016,0.0094240014196514,0.0094914314786394,0.0095550369184886,0.0096147921090741,0.0096706729717469,0.0097226569890359,0.0097707232137264,0.0098148522772948,0.0098550263977175,0.0098912293866337,0.0099234466558710,0.0099516652233210,0.0099758737181734,0.0099960623854951,0.0100122230901630,0.0100243493201424,0.0100324361891068,0.0100364804384146,0.0100364804384149,0.0100324361891070,0.0100243493201421,0.0100122230901634,0.0099960623854949,0.0099758737181733,0.0099516652233213,0.0099234466558706,0.0098912293866337,0.0098550263977170,0.0098148522772947,0.0097707232137261,0.0097226569890356,0.0096706729717467,0.0096147921090741,0.0095550369184887,0.0094914314786392,0.0094240014196518,0.0093527739128018,0.0092777776595649,0.0091990428800516,0.0091166013008298,0.0090304861421418,0.0089407321045163,0.0088473753547864,0.0087504535115149,0.0086500056298387,0.0085460721857271,0.0084386950596758,0.0083279175198284,0.0082137842045431,0.0080963411044030,0.0079756355436875,0.0078517161612984,0.0077246328911654,0.0075944369421219,0.0074611807772695,0.0073249180928414,0.0071857037965636,0.0070435939855258,0.0068986459235840,0.0067509180182799,0.0066004697973100,0.0064473618845347,0.0062916559755523,0.0061334148128393,0.0059727021604655,0.0058095827784051,0.0056441223964363,0.0054763876876617,0.0053064462416383,0.0051343665371467,0.0049602179145984,0.0047840705480962,0.0046059954171615,0.0044260642781371,0.0042443496352801,0.0040609247115529,0.0038758634191357,0.0036892403296530,0.0035011306441616,0.0033116101628859,0.0031207552547365,0.0029286428266372,0.0027353502927061,0.0025409555433233,0.0023455369142272,0.0021491731557968,0.0019519434029408,0.0017539271464468,0.0015552042079103,0.0013558547237717,0.0011559591549472,0.0009555983784899,0.0007548540957961,0.0005538108371218,0.0003525702938080,0.0001514855534319};
static const double pts156[156] = {-0.9998819411754282,-0.9993780073358569,-0.9984716048355211,-0.9971628974986478,-0.9954523879996741,-0.9933407597026090,-0.9908288615339779,-0.9879177048726240,-0.9846084624064445,-0.9809024674151393,-0.9768012131377722,-0.9723063521294696,-0.9674196955756277,-0.9621432125518653,-0.9564790292250023,-0.9504294279931221,-0.9439968465639632,-0.9371838769714510,-0.9299932645304769,-0.9224279067301607,-0.9144908520659655,-0.9061852988110619,-0.8975145937274071,-0.8884822307170399,-0.8790918494141086,-0.8693472337182062,-0.8592523102695819,-0.8488111468668499,-0.8380279508278232,-0.8269070672941314,-0.8154529774803144,-0.8036702968680797,-0.7915637733464614,-0.7791382852986283,-0.7663988396361082,-0.7533505697812257,-0.7399987335985562,-0.7263487112762427,-0.7124060031580214,-0.6981762275268258,-0.6836651183408704,-0.6688785229231236,-0.6538223996050982,-0.6385028153259130,-0.6229259431875850,-0.6070980599675484,-0.5910255435893980,-0.5747148705528696,-0.5581726133241012,-0.5414054376872310,-0.5244201000583791,-0.5072234447631203,-0.4898224012785285,-0.4722239814409065,-0.4544352766203359,-0.4364634548631718,-0.4183157580036452,-0.3999994987457266,-0.3815220577164403,-0.3628908804917981,-0.3441134745965742,-0.3251974064791062,-0.3061502984623587,-0.2869798256724728,-0.2676937129460322,-0.2482997317173048,-0.2288056968867050,-0.2092194636717389,-0.1895489244417069,-0.1698020055374362,-0.1499866640773181,-0.1301108847509526,-0.1101826766016762,-0.0902100697992776,-0.0702011124042023,-0.0501638671245463,-0.0301064080671485,-0.0100368174840908,0.0100368174840895,0.0301064080671477,0.0501638671245450,0.0702011124042014,0.0902100697992773,0.1101826766016761,0.1301108847509526,0.1499866640773183,0.1698020055374360,0.1895489244417075,0.2092194636717390,0.2288056968867050,0.2482997317173047,0.2676937129460326,0.2869798256724733,0.3061502984623587,0.3251974064791061,0.3441134745965748,0.3628908804917990,0.3815220577164410,0.3999994987457276,0.4183157580036458,0.4364634548631725,0.4544352766203357,0.4722239814409068,0.4898224012785284,0.5072234447631211,0.5244201000583794,0.5414054376872312,0.5581726133241010,0.5747148705528684,0.5910255435893976,0.6070980599675485,0.6229259431875845,0.6385028153259137,0.6538223996050988,0.6688785229231234,0.6836651183408703,0.6981762275268255,0.7124060031580218,0.7263487112762432,0.7399987335985562,0.7533505697812261,0.7663988396361087,0.7791382852986285,0.7915637733464617,0.8036702968680797,0.8154529774803140,0.8269070672941311,0.8380279508278222,0.8488111468668502,0.8592523102695822,0.8693472337182059,0.8790918494141085,0.8884822307170397,0.8975145937274076,0.9061852988110615,0.9144908520659654,0.9224279067301601,0.9299932645304764,0.9371838769714510,0.9439968465639631,0.9504294279931220,0.9564790292250021,0.9621432125518650,0.9674196955756279,0.9723063521294698,0.9768012131377726,0.9809024674151394,0.9846084624064445,0.9879177048726236,0.9908288615339773,0.9933407597026090,0.9954523879996746,0.9971628974986478,0.9984716048355211,0.9993780073358566,0.9998819411754282};

static const double w157[157] = {0.0001495681150551,0.0003481083524184,0.0005468041954326,0.0007453080385162,0.0009435204878721,0.0011413590905186,0.0013387441826744,0.0015355969098106,0.0017318388228064,0.0019273917866500,0.0021221779701369,0.0023161198608320,0.0025091402890442,0.0027011624553229,0.0028921099594262,0.0030819068298639,0.0032704775536561,0.0034577471061148,0.0036436409805258,0.0038280852176891,0.0040110064352871,0.0041923318570344,0.0043719893416055,0.0045499074113211,0.0047260152805670,0.0049002428839541,0.0050725209041831,0.0052427807996196,0.0054109548315608,0.0055769760911825,0.0057407785261570,0.0059022969669308,0.0060614671526534,0.0062182257567396,0.0063725104120675,0.0065242597357862,0.0066734133537407,0.0068199119244937,0.0069636971629258,0.0071047118634339,0.0072428999226859,0.0073782063619422,0.0075105773489279,0.0076399602192525,0.0077663034973624,0.0078895569170172,0.0080096714412923,0.0081265992820884,0.0082402939191395,0.0083507101185250,0.0084578039506683,0.0085615328078085,0.0086618554209565,0.0087587318763124,0.0088521236311460,0.0089419935291298,0.0090283058151241,0.0091110261493997,0.0091901216213024,0.0092655607623474,0.0093373135587325,0.0094053514632902,0.0094696474068344,0.0095301758089388,0.0095869125881072,0.0096398351713585,0.0096889225032073,0.0097341550540404,0.0097755148278836,0.0098129853695681,0.0098465517712712,0.0098762006784497,0.0099019202951539,0.0099237003887197,0.0099415322938392,0.0099554089160102,0.0099653247343551,0.0099712758038239,0.0099732597567542,0.0099712758038240,0.0099653247343555,0.0099554089160099,0.0099415322938396,0.0099237003887198,0.0099019202951542,0.0098762006784494,0.0098465517712710,0.0098129853695688,0.0097755148278835,0.0097341550540406,0.0096889225032073,0.0096398351713587,0.0095869125881064,0.0095301758089388,0.0094696474068346,0.0094053514632899,0.0093373135587332,0.0092655607623472,0.0091901216213024,0.0091110261493997,0.0090283058151240,0.0089419935291294,0.0088521236311459,0.0087587318763125,0.0086618554209567,0.0085615328078091,0.0084578039506686,0.0083507101185252,0.0082402939191391,0.0081265992820882,0.0080096714412924,0.0078895569170171,0.0077663034973622,0.0076399602192527,0.0075105773489285,0.0073782063619420,0.0072428999226861,0.0071047118634339,0.0069636971629257,0.0068199119244935,0.0066734133537411,0.0065242597357854,0.0063725104120671,0.0062182257567401,0.0060614671526530,0.0059022969669308,0.0057407785261563,0.0055769760911824,0.0054109548315609,0.0052427807996196,0.0050725209041831,0.0049002428839546,0.0047260152805670,0.0045499074113212,0.0043719893416062,0.0041923318570345,0.0040110064352874,0.0038280852176888,0.0036436409805261,0.0034577471061154,0.0032704775536558,0.0030819068298630,0.0028921099594272,0.0027011624553233,0.0025091402890436,0.0023161198608319,0.0021221779701369,0.0019273917866495,0.0017318388228061,0.0015355969098106,0.0013387441826746,0.0011413590905190,0.0009435204878727,0.0007453080385163,0.0005468041954328,0.0003481083524181,0.0001495681150551};
static const double pts157[157] = {-0.9998834355418151,-0.9993858797489678,-0.9984909464824588,-0.9971987929301593,-0.9955099088179173,-0.9934249602562252,-0.9909447748115373,-0.9880703384439525,-0.9848027943885339,-0.9811434424588585,-0.9770937384359025,-0.9726552934477806,-0.9678298733091197,-0.9626193978084298,-0.9570259399388045,-0.9510517250700236,-0.9446991300612989,-0.9379706823144667,-0.9308690587677055,-0.9233970848300156,-0.9155577332567935,-0.9073541229668777,-0.8987895178015212,-0.8898673252257393,-0.8805910949725558,-0.8709645176306683,-0.8609914231760826,-0.8506757794483077,-0.8400216905717102,-0.8290333953226456,-0.8177152654430295,-0.8060718039010125,-0.7941076430994365,-0.7818275430328121,-0.7692363893935235,-0.7563391916280318,-0.7431410809438393,-0.7296473082680109,-0.7158632421580693,-0.7017943666660866,-0.6874462791568300,-0.6728246880808181,-0.6579354107031953,-0.6427843707893003,-0.6273775962478697,-0.6117212167328072,-0.5958214612044732,-0.5796846554514651,-0.5633172195738706,-0.5467256654290052,-0.5299165940406401,-0.5128966929727528,-0.4956727336688506,-0.4782515687579243,-0.4606401293280927,-0.4428454221690458,-0.4248745269843555,-0.4067345935747882,-0.3884328389937217,-0.3699765446758105,-0.3513730535400322,-0.3326297670682771,-0.3137541423606318,-0.2947536891685428,-0.2756359669070245,-0.2564085816471167,-0.2370791830897697,-0.2176554615223807,-0.1981451447591772,-0.1785559950666722,-0.1588958060754114,-0.1391723996792414,-0.1193936229233367,-0.0995673448822164,-0.0797014535289975,-0.0598038525971295,-0.0398824584358606,-0.0199451968606803,-0.0000000000000002,0.0199451968606805,0.0398824584358611,0.0598038525971305,0.0797014535289981,0.0995673448822172,0.1193936229233369,0.1391723996792416,0.1588958060754117,0.1785559950666729,0.1981451447591771,0.2176554615223808,0.2370791830897698,0.2564085816471171,0.2756359669070252,0.2947536891685430,0.3137541423606317,0.3326297670682768,0.3513730535400325,0.3699765446758108,0.3884328389937219,0.4067345935747883,0.4248745269843556,0.4428454221690453,0.4606401293280928,0.4782515687579237,0.4956727336688508,0.5128966929727529,0.5299165940406403,0.5467256654290056,0.5633172195738704,0.5796846554514652,0.5958214612044738,0.6117212167328075,0.6273775962478698,0.6427843707893010,0.6579354107031956,0.6728246880808177,0.6874462791568298,0.7017943666660870,0.7158632421580695,0.7296473082680107,0.7431410809438391,0.7563391916280322,0.7692363893935235,0.7818275430328117,0.7941076430994364,0.8060718039010122,0.8177152654430295,0.8290333953226449,0.8400216905717098,0.8506757794483076,0.8609914231760827,0.8709645176306684,0.8805910949725557,0.8898673252257390,0.8987895178015212,0.9073541229668777,0.9155577332567926,0.9233970848300158,0.9308690587677054,0.9379706823144669,0.9446991300612991,0.9510517250700237,0.9570259399388046,0.9626193978084299,0.9678298733091203,0.9726552934477806,0.9770937384359019,0.9811434424588585,0.9848027943885332,0.9880703384439518,0.9909447748115369,0.9934249602562250,0.9955099088179170,0.9971987929301589,0.9984909464824586,0.9993858797489674,0.9998834355418150};

static const double w158[158] = {0.0001476868522625,0.0003437305743381,0.0005399296642846,0.0007359418698699,0.0009316700263751,0.0011270336938847,0.0013219551829232,0.0015163575986279,0.0017101644412246,0.0019032995151106,0.0020956869179161,0.0022872510545259,0.0024779166599969,0.0026676088259619,0.0028562530284864,0.0030437751565078,0.0032301015404917,0.0034151589811039,0.0035988747778080,0.0037811767573296,0.0039619933019454,0.0041412533775767,0.0043188865616704,0.0044948230708436,0.0046689937882882,0.0048413302909124,0.0050117648762147,0.0051802305888770,0.0053466612470642,0.0055109914684208,0.0056731566957564,0.0058330932224023,0.0059907382172412,0.0061460297493857,0.0062989068125127,0.0064493093488232,0.0065971782726382,0.0067424554936130,0.0068850839395525,0.0070250075788353,0.0071621714424258,0.0072965216454647,0.0074280054084444,0.0075565710779362,0.0076821681468865,0.0078047472744572,0.0079242603054104,0.0080406602890238,0.0081539014975387,0.0082639394441184,0.0083707309003322,0.0084742339131322,0.0085744078213373,0.0086712132716034,0.0087646122338905,0.0088545680163935,0.0089410452799642,0.0090240100519905,0.0091034297397439,0.0091792731431810,0.0092515104672065,0.0093201133333691,0.0093850547910194,0.0094463093278925,0.0095038528801280,0.0095576628417306,0.0096077180734445,0.0096539989110608,0.0096964871731425,0.0097351661681669,0.0097700207010812,0.0098010370792770,0.0098282031179615,0.0098515081449506,0.0098709430048604,0.0098865000627004,0.0098981732068785,0.0099059578515962,0.0099098509386550,0.0099098509386553,0.0099059578515966,0.0098981732068779,0.0098865000627002,0.0098709430048597,0.0098515081449509,0.0098282031179616,0.0098010370792769,0.0097700207010818,0.0097351661681666,0.0096964871731429,0.0096539989110607,0.0096077180734444,0.0095576628417308,0.0095038528801282,0.0094463093278924,0.0093850547910197,0.0093201133333692,0.0092515104672053,0.0091792731431809,0.0091034297397442,0.0090240100519908,0.0089410452799644,0.0088545680163940,0.0087646122338898,0.0086712132716034,0.0085744078213364,0.0084742339131324,0.0083707309003320,0.0082639394441185,0.0081539014975383,0.0080406602890242,0.0079242603054103,0.0078047472744578,0.0076821681468864,0.0075565710779364,0.0074280054084446,0.0072965216454650,0.0071621714424254,0.0070250075788355,0.0068850839395521,0.0067424554936132,0.0065971782726378,0.0064493093488230,0.0062989068125131,0.0061460297493862,0.0059907382172412,0.0058330932224022,0.0056731566957559,0.0055109914684213,0.0053466612470639,0.0051802305888770,0.0050117648762146,0.0048413302909127,0.0046689937882885,0.0044948230708435,0.0043188865616701,0.0041412533775770,0.0039619933019450,0.0037811767573294,0.0035988747778082,0.0034151589811034,0.0032301015404916,0.0030437751565083,0.0028562530284864,0.0026676088259615,0.0024779166599964,0.0022872510545267,0.0020956869179160,0.0019032995151104,0.0017101644412248,0.0015163575986278,0.0013219551829230,0.0011270336938849,0.0009316700263751,0.0007359418698702,0.0005399296642847,0.0003437305743383,0.0001476868522624};
static const double pts158[158] = {-0.9998849017138335,-0.9993936036487018,-0.9985099233204192,-0.9972340115193672,-0.9955663454311084,-0.9935075744522798,-0.9910585054562916,-0.9882200997776671,-0.9849934721171127,-0.9813798898650380,-0.9773807725108651,-0.9729976910448326,-0.9682323673214405,-0.9630866733730582,-0.9575626306690617,-0.9516624093185930,-0.9453883272161708,-0.9387428491299584,-0.9317285857327452,-0.9243482925758615,-0.9166048690063353,-0.9085013570276594,-0.9000409401045912,-0.8912269419124057,-0.8820628250311190,-0.8725521895851472,-0.8626987718289558,-0.8525064426792380,-0.8419792061941981,-0.8311211980005396,-0.8199366836687633,-0.8084300570374309,-0.7966058384870317,-0.7844686731641430,-0.7720233291565795,-0.7592746956202402,-0.7462277808584036,-0.7328877103542072,-0.7192597247570996,-0.7053491778240488,-0.6911615343163140,-0.6767023678526117,-0.6619773587195182,-0.6469922916399687,-0.6317530535007192,-0.6162656310396906,-0.6005361084940700,-0.5845706652101200,-0.5683755732156170,-0.5519571947558879,-0.5353219797943977,-0.5184764634788780,-0.5014272635739965,-0.4841810778615624,-0.4667446815093080,-0.4491249244092511,-0.4313287284867241,-0.4133630849810889,-0.3952350516992277,-0.3769517502428807,-0.3585203632109276,-0.3399481313776953,-0.3212423508484242,-0.3024103701929895,-0.2834595875590112,-0.2643974477654948,-0.2452314393781282,-0.2259690917674011,-0.2066179721506863,-0.1871856826194596,-0.1676798571528145,-0.1481081586184541,-0.1284782757623285,-0.1087979201881133,-0.0890748233277008,-0.0693167334039074,-0.0495314123865827,-0.0297266329433158,-0.0099101753859448,0.0099101753859445,0.0297266329433162,0.0495314123865825,0.0693167334039074,0.0890748233277010,0.1087979201881136,0.1284782757623286,0.1481081586184539,0.1676798571528151,0.1871856826194598,0.2066179721506868,0.2259690917674015,0.2452314393781284,0.2643974477654950,0.2834595875590116,0.3024103701929894,0.3212423508484247,0.3399481313776946,0.3585203632109274,0.3769517502428804,0.3952350516992273,0.4133630849810888,0.4313287284867241,0.4491249244092506,0.4667446815093078,0.4841810778615632,0.5014272635739958,0.5184764634788775,0.5353219797943974,0.5519571947558879,0.5683755732156166,0.5845706652101191,0.6005361084940699,0.6162656310396902,0.6317530535007194,0.6469922916399684,0.6619773587195185,0.6767023678526116,0.6911615343163134,0.7053491778240485,0.7192597247570994,0.7328877103542071,0.7462277808584037,0.7592746956202400,0.7720233291565790,0.7844686731641434,0.7966058384870317,0.8084300570374312,0.8199366836687638,0.8311211980005397,0.8419792061941985,0.8525064426792380,0.8626987718289559,0.8725521895851474,0.8820628250311189,0.8912269419124061,0.9000409401045911,0.9085013570276600,0.9166048690063346,0.9243482925758613,0.9317285857327454,0.9387428491299585,0.9453883272161705,0.9516624093185930,0.9575626306690618,0.9630866733730574,0.9682323673214405,0.9729976910448322,0.9773807725108650,0.9813798898650378,0.9849934721171125,0.9882200997776676,0.9910585054562916,0.9935075744522800,0.9955663454311088,0.9972340115193673,0.9985099233204183,0.9993936036487018,0.9998849017138332};

static const double w159[159] = {0.0001458408607410,0.0003394348562371,0.0005331839437055,0.0007267510996265,0.0009200413223666,0.0011129761232556,0.0013054797261536,0.0014974771353420,0.0016888937402524,0.0018796552249569,0.0020696875566344,0.0022589169986952,0.0024472701326897,0.0026346738836661,0.0028210555469675,0.0030063428156088,0.0031904638078762,0.0033733470949500,0.0035549217284512,0.0037351172678767,0.0039138638078589,0.0040910920052435,0.0042667331059705,0.0044407189717199,0.0046129821063400,0.0047834556820179,0.0049520735652027,0.0051187703422529,0.0052834813448108,0.0054461426748910,0.0056066912296615,0.0057650647259259,0.0059212017242833,0.0060750416529642,0.0062265248313238,0.0063755924929993,0.0065221868087030,0.0066662509086582,0.0068077289046623,0.0069465659117625,0.0070827080695572,0.0072161025630790,0.0073466976432939,0.0074744426471688,0.0075992880173314,0.0077211853212930,0.0078400872702341,0.0079559477373581,0.0080687217757751,0.0081783656359492,0.0082848367826608,0.0083880939115144,0.0084880969649608,0.0085848071478340,0.0086781869424056,0.0087682001229358,0.0088548117697307,0.0089379882826847,0.0090176973943174,0.0090939081822923,0.0091665910814132,0.0092357178950885,0.0093012618062776,0.0093631973878886,0.0094215006126440,0.0094761488624027,0.0095271209369345,0.0095743970621430,0.0096179588977372,0.0096577895443468,0.0096938735500808,0.0097261969165156,0.0097547471041323,0.0097795130371760,0.0098004851079559,0.0098176551805715,0.0098310165940678,0.0098405641650210,0.0098462941895485,0.0098482044447456,0.0098462941895491,0.0098405641650211,0.0098310165940680,0.0098176551805714,0.0098004851079562,0.0097795130371760,0.0097547471041322,0.0097261969165157,0.0096938735500807,0.0096577895443469,0.0096179588977375,0.0095743970621428,0.0095271209369345,0.0094761488624035,0.0094215006126442,0.0093631973878885,0.0093012618062776,0.0092357178950886,0.0091665910814132,0.0090939081822927,0.0090176973943171,0.0089379882826845,0.0088548117697312,0.0087682001229365,0.0086781869424055,0.0085848071478337,0.0084880969649603,0.0083880939115150,0.0082848367826612,0.0081783656359486,0.0080687217757754,0.0079559477373577,0.0078400872702342,0.0077211853212928,0.0075992880173308,0.0074744426471693,0.0073466976432942,0.0072161025630792,0.0070827080695563,0.0069465659117624,0.0068077289046615,0.0066662509086584,0.0065221868087037,0.0063755924929990,0.0062265248313235,0.0060750416529649,0.0059212017242833,0.0057650647259256,0.0056066912296618,0.0054461426748908,0.0052834813448108,0.0051187703422522,0.0049520735652026,0.0047834556820183,0.0046129821063403,0.0044407189717201,0.0042667331059698,0.0040910920052435,0.0039138638078585,0.0037351172678768,0.0035549217284514,0.0033733470949499,0.0031904638078769,0.0030063428156089,0.0028210555469670,0.0026346738836659,0.0024472701326895,0.0022589169986953,0.0020696875566343,0.0018796552249563,0.0016888937402531,0.0014974771353427,0.0013054797261542,0.0011129761232553,0.0009200413223666,0.0007267510996264,0.0005331839437056,0.0003394348562370,0.0001458408607408};
static const double pts159[159] = {-0.9998863403963049,-0.9994011827471901,-0.9985285444656711,-0.9972685701740219,-0.9956217249105396,-0.9935886418775562,-0.9911701078976365,-0.9883670604433931,-0.9851805865655048,-0.9816119222354233,-0.9776624517742580,-0.9733337072756919,-0.9686273679924841,-0.9635452596751733,-0.9580893538584396,-0.9522617670931939,-0.9460647601236519,-0.9395007370091617,-0.9325722441908543,-0.9252819695032994,-0.9176327411314698,-0.9096275265133548,-0.9012694311886178,-0.8925616975937292,-0.8835077038040108,-0.8741109622230927,-0.8643751182202662,-0.8543039487162682,-0.8439013607180367,-0.8331713898030143,-0.8221181985535605,-0.8107460749421240,-0.7990594306677435,-0.7870627994445780,-0.7747608352430858,-0.7621583104845635,-0.7492601141897267,-0.7360712500820646,-0.7225968346466906,-0.7088420951454543,-0.6948123675890762,-0.6805130946670956,-0.6659498236364330,-0.6511282041693853,-0.6360539861618973,-0.6207330175029427,-0.6051712418058968,-0.5893746961027727,-0.5733495085022119,-0.5571018958121536,-0.5406381611280772,-0.5239646913877910,-0.5070879548936783,-0.4900144988033857,-0.4727509465899225,-0.4553039954721482,-0.4376804138166603,-0.4198870385120687,-0.4019307723166964,-0.3838185811807305,-0.3655574915438450,-0.3471545876093669,-0.3286170085960375,-0.3099519459684175,-0.2911666406470363,-0.2722683801993500,-0.2532644960126023,-0.2341623604496905,-0.2149693839891290,-0.1956930123502332,-0.1763407236046263,-0.1569200252751979,-0.1374384514236383,-0.1179035597276757,-0.0983229285491512,-0.0787041539940724,-0.0590548469657797,-0.0393826302123764,-0.0196951353695579,0.0000000000000001,0.0196951353695583,0.0393826302123767,0.0590548469657805,0.0787041539940729,0.0983229285491516,0.1179035597276755,0.1374384514236383,0.1569200252751976,0.1763407236046263,0.1956930123502331,0.2149693839891294,0.2341623604496904,0.2532644960126025,0.2722683801993498,0.2911666406470368,0.3099519459684177,0.3286170085960382,0.3471545876093680,0.3655574915438451,0.3838185811807314,0.4019307723166973,0.4198870385120687,0.4376804138166603,0.4553039954721484,0.4727509465899223,0.4900144988033855,0.5070879548936783,0.5239646913877908,0.5406381611280774,0.5571018958121530,0.5733495085022126,0.5893746961027728,0.6051712418058968,0.6207330175029421,0.6360539861618970,0.6511282041693851,0.6659498236364326,0.6805130946670959,0.6948123675890767,0.7088420951454543,0.7225968346466906,0.7360712500820645,0.7492601141897268,0.7621583104845634,0.7747608352430863,0.7870627994445781,0.7990594306677439,0.8107460749421237,0.8221181985535605,0.8331713898030135,0.8439013607180369,0.8543039487162676,0.8643751182202660,0.8741109622230927,0.8835077038040108,0.8925616975937289,0.9012694311886181,0.9096275265133547,0.9176327411314701,0.9252819695032992,0.9325722441908537,0.9395007370091609,0.9460647601236517,0.9522617670931938,0.9580893538584392,0.9635452596751729,0.9686273679924837,0.9733337072756926,0.9776624517742577,0.9816119222354232,0.9851805865655040,0.9883670604433928,0.9911701078976367,0.9935886418775561,0.9956217249105390,0.9972685701740222,0.9985285444656704,0.9994011827471895,0.9998863403963050};

static const double w160[160] = {0.0001440292642601,0.0003352191600764,0.0005265638361068,0.0007177313767417,0.0009086288798326,0.0010991797483984,0.0012893100609186,0.0014789466625197,0.0016680167739109,0.0018564479012937,0.0020441678242840,0.0022311046081672,0.0024171866248512,0.0026023425772239,0.0027865015249306,0.0029695929107427,0.0031515465871392,0.0033322928429185,0.0035117624297573,0.0036898865886368,0.0038665970761339,0.0040418261905184,0.0042155067976712,0.0043875723567837,0.0045579569458401,0.0047265952868619,0.0048934227709145,0.0050583754828532,0.0052213902258125,0.0053824045454054,0.0055413567536591,0.0056981859526438,0.0058528320578012,0.0060052358209665,0.0061553388530636,0.0063030836464803,0.0064484135970913,0.0065912730259555,0.0067316072006351,0.0068693623561761,0.0070044857156979,0.0071369255106179,0.0072666310004844,0.0073935524924139,0.0075176413601327,0.0076388500626021,0.0077571321622389,0.0078724423426993,0.0079847364262470,0.0080939713906731,0.0082001053857820,0.0083030977494247,0.0084029090230770,0.0084995009669564,0.0085928365746725,0.0086828800874056,0.0087695970076078,0.0088529541122141,0.0089329194653818,0.0090094624307115,0.0090825536829978,0.0091521652194554,0.0092182703704536,0.0092808438097268,0.0093398615640861,0.0093953010225975,0.0094471409452483,0.0094953614710811,0.0095399441258066,0.0095808718288790,0.0096181289000420,0.0096517010653337,0.0096815754625567,0.0097077406462061,0.0097301865918543,0.0097489046999904,0.0097638877993170,0.0097751301494962,0.0097826274433485,0.0097863768085046,0.0097863768085047,0.0097826274433489,0.0097751301494961,0.0097638877993173,0.0097489046999900,0.0097301865918547,0.0097077406462059,0.0096815754625569,0.0096517010653335,0.0096181289000428,0.0095808718288797,0.0095399441258061,0.0094953614710808,0.0094471409452479,0.0093953010225978,0.0093398615640857,0.0092808438097267,0.0092182703704530,0.0091521652194561,0.0090825536829984,0.0090094624307122,0.0089329194653806,0.0088529541122150,0.0087695970076070,0.0086828800874058,0.0085928365746724,0.0084995009669565,0.0084029090230767,0.0083030977494253,0.0082001053857818,0.0080939713906726,0.0079847364262476,0.0078724423426991,0.0077571321622389,0.0076388500626021,0.0075176413601323,0.0073935524924139,0.0072666310004841,0.0071369255106182,0.0070044857156974,0.0068693623561758,0.0067316072006353,0.0065912730259549,0.0064484135970922,0.0063030836464803,0.0061553388530640,0.0060052358209658,0.0058528320578016,0.0056981859526430,0.0055413567536596,0.0053824045454054,0.0052213902258130,0.0050583754828539,0.0048934227709140,0.0047265952868613,0.0045579569458399,0.0043875723567843,0.0042155067976715,0.0040418261905183,0.0038665970761335,0.0036898865886366,0.0035117624297572,0.0033322928429186,0.0031515465871394,0.0029695929107435,0.0027865015249301,0.0026023425772236,0.0024171866248510,0.0022311046081674,0.0020441678242839,0.0018564479012939,0.0016680167739105,0.0014789466625199,0.0012893100609189,0.0010991797483981,0.0009086288798323,0.0007177313767415,0.0005265638361071,0.0003352191600762,0.0001440292642606};
static const double pts160[160] = {-0.9998877522721633,-0.9994086206413063,-0.9985468187515170,-0.9973024852772795,-0.9956760734880251,-0.9936682008920967,-0.9912796348796467,-0.9885112897968070,-0.9853642258958901,-0.9818396486965261,-0.9779389084333056,-0.9736634994989338,-0.9690150598527878,-0.9639953703836627,-0.9586063542221828,-0.9528500760009747,-0.9467287410618519,-0.9402446946097833,-0.9334004208136781,-0.9261985418541854,-0.9186418169187577,-0.9107331411443390,-0.9024755445080245,-0.8938721906660991,-0.8849263757419047,-0.8756415270629636,-0.8660212018478565,-0.8560690858433443,-0.8457889919122622,-0.8351848585727044,-0.8242607484890901,-0.8130208469156555,-0.8014694600929877,-0.7896110135982044,-0.7774500506494230,-0.7649912303651484,-0.7522393259792669,-0.7391992230123147,-0.7258759173997351,-0.7122745135778249,-0.6984002225281181,-0.6842583597809496,-0.6698543433789623,-0.6551936918013400,-0.6402820218495651,-0.6251250464954985,-0.6097285726926286,-0.5940984991512984,-0.5782408140787865,-0.5621615928851040,-0.5458669958553740,-0.5293632657897016,-0.5126567256114193,-0.4957537759446513,-0.4786608926620949,-0.4613846244039790,-0.4439315900691492,-0.4263084762792189,-0.4085220348167962,-0.3905790800387239,-0.3724864862653670,-0.3542511851469113,-0.3358801630077043,-0.3173804581696508,-0.2987591582556807,-0.2800233974743375,-0.2611803538865114,-0.2422372466553738,-0.2232013332805665,-0.2040799068177022,-0.1848802930842417,-0.1656098478528216,-0.1462759540331027,-0.1268860188432250,-0.1074474709719457,-0.0879677577325562,-0.0684543422096585,-0.0489147003999028,-0.0293563183477775,-0.0097866892775494,0.0097866892775486,0.0293563183477770,0.0489147003999019,0.0684543422096579,0.0879677577325556,0.1074474709719453,0.1268860188432245,0.1462759540331024,0.1656098478528216,0.1848802930842418,0.2040799068177023,0.2232013332805663,0.2422372466553737,0.2611803538865111,0.2800233974743370,0.2987591582556800,0.3173804581696499,0.3358801630077041,0.3542511851469109,0.3724864862653668,0.3905790800387240,0.4085220348167960,0.4263084762792195,0.4439315900691489,0.4613846244039795,0.4786608926620945,0.4957537759446511,0.5126567256114194,0.5293632657897013,0.5458669958553742,0.5621615928851034,0.5782408140787856,0.5940984991512981,0.6097285726926289,0.6251250464954987,0.6402820218495644,0.6551936918013399,0.6698543433789627,0.6842583597809502,0.6984002225281184,0.7122745135778255,0.7258759173997354,0.7391992230123148,0.7522393259792667,0.7649912303651488,0.7774500506494230,0.7896110135982047,0.8014694600929870,0.8130208469156559,0.8242607484890904,0.8351848585727042,0.8457889919122621,0.8560690858433447,0.8660212018478565,0.8756415270629643,0.8849263757419051,0.8938721906660998,0.9024755445080246,0.9107331411443396,0.9186418169187578,0.9261985418541847,0.9334004208136787,0.9402446946097829,0.9467287410618525,0.9528500760009752,0.9586063542221835,0.9639953703836631,0.9690150598527878,0.9736634994989343,0.9779389084333064,0.9818396486965266,0.9853642258958906,0.9885112897968076,0.9912796348796467,0.9936682008920972,0.9956760734880254,0.9973024852772797,0.9985468187515171,0.9994086206413060,0.9998877522721636};

static const double w161[161] = {0.0001422512136311,0.0003310815106923,0.0005200662424908,0.0007088784842205,0.0008974273718950,0.0010856381428455,0.0012734386736043,0.0014607575939776,0.0016475239001395,0.0018336668649817,0.0020191160255122,0.0022038011943023,0.0023876524795084,0.0025706003082856,0.0027525754515851,0.0029335090495507,0.0031133326371315,0.0032919781697324,0.0034693780488039,0.0036454651473321,0.0038201728351726,0.0039934350042300,0.0041651860934402,0.0043353611135646,0.0045038956717694,0.0046707259959806,0.0048357889590084,0.0049990221024316,0.0051603636602284,0.0053197525821431,0.0054771285567854,0.0056324320344545,0.0057856042496670,0.0059365872433913,0.0060853238849844,0.0062317578938016,0.0063758338604989,0.0065174972679923,0.0066566945120956,0.0067933729217915,0.0069274807791730,0.0070589673390061,0.0071877828479335,0.0073138785633015,0.0074372067716004,0.0075577208065231,0.0076753750666198,0.0077901250325563,0.0079019272839547,0.0080107395158333,0.0081165205545960,0.0082192303736355,0.0083188301084596,0.0084152820714072,0.0085085497659067,0.0085985979002847,0.0086853924011220,0.0087689004261433,0.0088490903766497,0.0089259319094724,0.0089993959484512,0.0090694546954424,0.0091360816408347,0.0091992515735801,0.0092589405907318,0.0093151261064942,0.0093677868607626,0.0094169029271725,0.0094624557206382,0.0095044280043844,0.0095428038964686,0.0095775688757923,0.0096087097875941,0.0096362148484282,0.0096600736506211,0.0096802771662141,0.0096968177503736,0.0097096891442901,0.0097188864775403,0.0097244062699354,0.0097262464328342,0.0097244062699357,0.0097188864775403,0.0097096891442900,0.0096968177503738,0.0096802771662146,0.0096600736506213,0.0096362148484282,0.0096087097875942,0.0095775688757924,0.0095428038964682,0.0095044280043838,0.0094624557206385,0.0094169029271732,0.0093677868607627,0.0093151261064938,0.0092589405907325,0.0091992515735801,0.0091360816408346,0.0090694546954425,0.0089993959484510,0.0089259319094715,0.0088490903766497,0.0087689004261427,0.0086853924011221,0.0085985979002850,0.0085085497659073,0.0084152820714074,0.0083188301084595,0.0082192303736354,0.0081165205545965,0.0080107395158319,0.0079019272839562,0.0077901250325561,0.0076753750666197,0.0075577208065233,0.0074372067716000,0.0073138785633019,0.0071877828479339,0.0070589673390062,0.0069274807791727,0.0067933729217915,0.0066566945120952,0.0065174972679932,0.0063758338604983,0.0062317578938018,0.0060853238849842,0.0059365872433914,0.0057856042496663,0.0056324320344549,0.0054771285567856,0.0053197525821428,0.0051603636602280,0.0049990221024315,0.0048357889590083,0.0046707259959807,0.0045038956717701,0.0043353611135650,0.0041651860934397,0.0039934350042295,0.0038201728351723,0.0036454651473317,0.0034693780488039,0.0032919781697327,0.0031133326371317,0.0029335090495502,0.0027525754515857,0.0025706003082856,0.0023876524795087,0.0022038011943017,0.0020191160255128,0.0018336668649817,0.0016475239001394,0.0014607575939772,0.0012734386736040,0.0010856381428457,0.0008974273718953,0.0007088784842204,0.0005200662424915,0.0003310815106923,0.0001422512136315};
static const double pts161[161] = {-0.9998891380032660,-0.9994159208169338,-0.9985647547387659,-0.9973357727071094,-0.9957294165869467,-0.9937462886745224,-0.9913871375232771,-0.9886528550612708,-0.9855444755628305,-0.9820631750274089,-0.9782102706452148,-0.9739872202597473,-0.9693956217974820,-0.9644372126536374,-0.9591138690295277,-0.9534276052196264,-0.9473805728475925,-0.9409750600509997,-0.9342134906148276,-0.9270984230538548,-0.9196325496442266,-0.9118186954045092,-0.9036598170265793,-0.8951590017567276,-0.8863194662273953,-0.8771445552399755,-0.8676377404991243,-0.8578026192990661,-0.8476429131623886,-0.8371624664318277,-0.8263652448155925,-0.8152553338867622,-0.8038369375373337,-0.7921143763874968,-0.7800920861507455,-0.7677746159554397,-0.7551666266234482,-0.7422728889065348,-0.7290982816811433,-0.7156477901022724,-0.7019265037171363,-0.6879396145393217,-0.6736924150841764,-0.6591902963661640,-0.6444387458589551,-0.6294433454190110,-0.6142097691734618,-0.5987437813730615,-0.5830512342110504,-0.5671380656087309,-0.5510102969686185,-0.5346740308959885,-0.5181354488897072,-0.5014008090032048,-0.4844764434764862,-0.4673687563400642,-0.4500842209917339,-0.4326293777470910,-0.4150108313647391,-0.3972352485471046,-0.3793093554178145,-0.3612399349765947,-0.3430338245326364,-0.3246979131174238,-0.3062391388779832,-0.2876644864515499,-0.2689809843226424,-0.2501957021635463,-0.2313157481592117,-0.2123482663175813,-0.1933004337663583,-0.1741794580372456,-0.1549925743386785,-0.1357470428180873,-0.1164501458147212,-0.0971091851040734,-0.0777314791349563,-0.0583243602602617,-0.0388951719624686,-0.0194512660749282,0.0000000000000003,0.0194512660749285,0.0388951719624686,0.0583243602602622,0.0777314791349568,0.0971091851040739,0.1164501458147220,0.1357470428180884,0.1549925743386790,0.1741794580372454,0.1933004337663582,0.2123482663175813,0.2313157481592113,0.2501957021635455,0.2689809843226423,0.2876644864515502,0.3062391388779835,0.3246979131174240,0.3430338245326363,0.3612399349765948,0.3793093554178146,0.3972352485471045,0.4150108313647395,0.4326293777470914,0.4500842209917345,0.4673687563400650,0.4844764434764863,0.5014008090032046,0.5181354488897071,0.5346740308959885,0.5510102969686179,0.5671380656087307,0.5830512342110490,0.5987437813730616,0.6142097691734623,0.6294433454190109,0.6444387458589551,0.6591902963661639,0.6736924150841763,0.6879396145393216,0.7019265037171362,0.7156477901022721,0.7290982816811432,0.7422728889065344,0.7551666266234487,0.7677746159554396,0.7800920861507455,0.7921143763874964,0.8038369375373340,0.8152553338867625,0.8263652448155926,0.8371624664318272,0.8476429131623883,0.8578026192990661,0.8676377404991240,0.8771445552399756,0.8863194662273952,0.8951590017567267,0.9036598170265794,0.9118186954045095,0.9196325496442264,0.9270984230538547,0.9342134906148277,0.9409750600509992,0.9473805728475918,0.9534276052196269,0.9591138690295278,0.9644372126536374,0.9693956217974816,0.9739872202597472,0.9782102706452150,0.9820631750274087,0.9855444755628303,0.9886528550612704,0.9913871375232763,0.9937462886745220,0.9957294165869456,0.9973357727071089,0.9985647547387649,0.9994159208169332,0.9998891380032654};

static const double w162[162] = {0.0001405058857099,0.0003270199934864,0.0005136881588294,0.0007001883341891,0.0008864316346053,0.0010723450764286,0.0012578582797342,0.0014429016048899,0.0016274057697475,0.0018113017604540,0.0019945208183631,0.0021769944507039,0.0023586544497262,0.0025394329151947,0.0027192622782577,0.0028980753259141,0.0030758052256945,0.0032523855503837,0.0034277503026997,0.0036018339398612,0.0037745713980329,0.0039458981165968,0.0041157500622592,0.0042840637529662,0.0044507762816147,0.0046158253395609,0.0047791492398952,0.0049406869404993,0.0051003780668544,0.0052581629346037,0.0054139825718572,0.0055677787412346,0.0057194939616243,0.0058690715296724,0.0060164555409701,0.0061615909109503,0.0063044233954732,0.0064448996110999,0.0065829670550471,0.0067185741248053,0.0068516701374264,0.0069822053484687,0.0071101309705853,0.0072353991917623,0.0073579631931822,0.0074777771667282,0.0075947963321038,0.0077089769535651,0.0078202763562708,0.0079286529422364,0.0080340662058654,0.0081364767491089,0.0082358462961757,0.0083321377078425,0.0084253149953356,0.0085153433337813,0.0086021890752189,0.0086858197611808,0.0087662041348218,0.0088433121525990,0.0089171149955050,0.0089875850798343,0.0090546960674986,0.0091184228758630,0.0091787416871277,0.0092356299572253,0.0092890664242484,0.0093390311163969,0.0093855053594400,0.0094284717836966,0.0094679143305310,0.0095038182583480,0.0095361701481073,0.0095649579083392,0.0095901707796595,0.0096117993387938,0.0096298355021015,0.0096442725285923,0.0096551050224501,0.0096623289350438,0.0096659415664490,0.0096659415664486,0.0096623289350443,0.0096551050224497,0.0096442725285928,0.0096298355021014,0.0096117993387937,0.0095901707796589,0.0095649579083390,0.0095361701481080,0.0095038182583477,0.0094679143305304,0.0094284717836973,0.0093855053594392,0.0093390311163970,0.0092890664242488,0.0092356299572250,0.0091787416871276,0.0091184228758629,0.0090546960674983,0.0089875850798343,0.0089171149955048,0.0088433121525986,0.0087662041348222,0.0086858197611813,0.0086021890752187,0.0085153433337812,0.0084253149953359,0.0083321377078424,0.0082358462961755,0.0081364767491097,0.0080340662058658,0.0079286529422358,0.0078202763562719,0.0077089769535650,0.0075947963321036,0.0074777771667284,0.0073579631931823,0.0072353991917620,0.0071101309705857,0.0069822053484682,0.0068516701374263,0.0067185741248050,0.0065829670550476,0.0064448996110998,0.0063044233954727,0.0061615909109501,0.0060164555409702,0.0058690715296725,0.0057194939616244,0.0055677787412344,0.0054139825718569,0.0052581629346032,0.0051003780668548,0.0049406869404994,0.0047791492398949,0.0046158253395609,0.0044507762816154,0.0042840637529656,0.0041157500622592,0.0039458981165969,0.0037745713980332,0.0036018339398611,0.0034277503026993,0.0032523855503832,0.0030758052256949,0.0028980753259142,0.0027192622782573,0.0025394329151945,0.0023586544497265,0.0021769944507041,0.0019945208183632,0.0018113017604540,0.0016274057697473,0.0014429016048895,0.0012578582797345,0.0010723450764285,0.0008864316346052,0.0007001883341889,0.0005136881588295,0.0003270199934863,0.0001405058857102};
static const double pts162[162] = {-0.9998904982311673,-0.9994230866530504,-0.9985823607257545,-0.9973684478548704,-0.9957817788519520,-0.9938229412654145,-0.9914926653859099,-0.9887918214059611,-0.9857214184123538,-0.9822826037820256,-0.9784766626649578,-0.9743050174652763,-0.9697692272911849,-0.9648709873627704,-0.9596121283732510,-0.9539946158018004,-0.9480205491771840,-0.9416921612919703,-0.9350118173673320,-0.9279820141685862,-0.9206053790717296,-0.9128846690812452,-0.9048227697995275,-0.8964226943482887,-0.8876875822423345,-0.8786206982161150,-0.8692254310034958,-0.8595052920711908,-0.8494639143063346,-0.8391050506586771,-0.8284325727379075,-0.8174504693666383,-0.8061628450895785,-0.7945739186394575,-0.7826880213602749,-0.7705095955884654,-0.7580431929925733,-0.7452934728720748,-0.7322652004159668,-0.7189632449217811,-0.7053925779756938,-0.6915582715943981,-0.6774654963294449,-0.6631195193347548,-0.6485257023980283,-0.6336894999367838,-0.6186164569597754,-0.6033122069945551,-0.5877824699819502,-0.5720330501382412,-0.5560698337858430,-0.5398987871533094,-0.5235259541454504,-0.5069574540844402,-0.4901994794227280,-0.4732582934286184,-0.4561402278453767,-0.4388516805247628,-0.4213991130358303,-0.4037890482499314,-0.3860280679028008,-0.3681228101346443,-0.3500799670091400,-0.3319062820122920,-0.3136085475320611,-0.2951936023197199,-0.2766683289338804,-0.2580396511681450,-0.2393145314633543,-0.2204999683053795,-0.2016029936094518,-0.1826306700919926,-0.1635900886309344,-0.1444883656155173,-0.1253326402865458,-0.1061300720681097,-0.0868878378917602,-0.0676131295141421,-0.0483131508290848,-0.0289951151751577,-0.0096662426396961,0.0096662426396960,0.0289951151751577,0.0483131508290850,0.0676131295141414,0.0868878378917602,0.1061300720681100,0.1253326402865457,0.1444883656155179,0.1635900886309342,0.1826306700919926,0.2016029936094521,0.2204999683053799,0.2393145314633543,0.2580396511681455,0.2766683289338800,0.2951936023197205,0.3136085475320612,0.3319062820122925,0.3500799670091398,0.3681228101346443,0.3860280679028005,0.4037890482499307,0.4213991130358297,0.4388516805247626,0.4561402278453773,0.4732582934286175,0.4901994794227282,0.5069574540844402,0.5235259541454501,0.5398987871533091,0.5560698337858436,0.5720330501382406,0.5877824699819506,0.6033122069945557,0.6186164569597754,0.6336894999367836,0.6485257023980286,0.6631195193347545,0.6774654963294446,0.6915582715943980,0.7053925779756938,0.7189632449217810,0.7322652004159661,0.7452934728720747,0.7580431929925731,0.7705095955884654,0.7826880213602750,0.7945739186394574,0.8061628450895789,0.8174504693666391,0.8284325727379072,0.8391050506586772,0.8494639143063348,0.8595052920711905,0.8692254310034958,0.8786206982161150,0.8876875822423345,0.8964226943482888,0.9048227697995271,0.9128846690812453,0.9206053790717297,0.9279820141685863,0.9350118173673314,0.9416921612919702,0.9480205491771843,0.9539946158018010,0.9596121283732520,0.9648709873627712,0.9697692272911860,0.9743050174652768,0.9784766626649578,0.9822826037820255,0.9857214184123536,0.9887918214059616,0.9914926653859093,0.9938229412654136,0.9957817788519514,0.9973684478548694,0.9985823607257540,0.9994230866530497,0.9998904982311670};

static const double w163[163] = {0.0001387924824472,0.0003230327522063,0.0005074266725907,0.0006916569631831,0.0008756366610052,0.0010592945081315,0.0012425618156458,0.0014253706223101,0.0016076533158138,0.0017893425440491,0.0019703712015725,0.0021506724395336,0.0023301796839806,0.0025088266574708,0.0026865474020611,0.0028632763028679,0.0030389481118676,0.0032134979717294,0.0033868614396116,0.0035589745108619,0.0037297736425858,0.0038991957770736,0.0040671783650469,0.0042336593887423,0.0043985773847901,0.0045618714669022,0.0047234813483392,0.0048833473641692,0.0050414104932887,0.0051976123802109,0.0053518953566098,0.0055042024626084,0.0056544774678048,0.0058026648920362,0.0059487100258554,0.0060925589507328,0.0062341585589600,0.0063734565732564,0.0065104015660714,0.0066449429785658,0.0067770311392865,0.0069066172824933,0.0070336535661726,0.0071580930896927,0.0072798899111258,0.0073989990642018,0.0075153765749164,0.0076289794777615,0.0077397658315876,0.0078476947350934,0.0079527263419183,0.0080548218753568,0.0081539436426787,0.0082500550490377,0.0083431206109855,0.0084331059695737,0.0085199779030333,0.0086037043390471,0.0086842543665831,0.0087615982473134,0.0088357074265865,0.0089065545439771,0.0089741134433791,0.0090383591826695,0.0090992680429111,0.0091568175371136,0.0092109864185333,0.0092617546885164,0.0093091036038850,0.0093530156838553,0.0093934747164907,0.0094304657646890,0.0094639751716950,0.0094939905661448,0.0095205008666295,0.0095434962857901,0.0095629683339311,0.0095789098221492,0.0095913148649945,0.0096001788826405,0.0096054986025710,0.0096072720607966,0.0096054986025713,0.0096001788826405,0.0095913148649950,0.0095789098221489,0.0095629683339309,0.0095434962857904,0.0095205008666295,0.0094939905661445,0.0094639751716952,0.0094304657646895,0.0093934747164909,0.0093530156838550,0.0093091036038847,0.0092617546885164,0.0092109864185334,0.0091568175371141,0.0090992680429108,0.0090383591826691,0.0089741134433793,0.0089065545439767,0.0088357074265865,0.0087615982473128,0.0086842543665832,0.0086037043390465,0.0085199779030334,0.0084331059695734,0.0083431206109859,0.0082500550490378,0.0081539436426788,0.0080548218753573,0.0079527263419181,0.0078476947350939,0.0077397658315881,0.0076289794777609,0.0075153765749166,0.0073989990642015,0.0072798899111253,0.0071580930896931,0.0070336535661724,0.0069066172824937,0.0067770311392864,0.0066449429785663,0.0065104015660712,0.0063734565732566,0.0062341585589595,0.0060925589507330,0.0059487100258551,0.0058026648920357,0.0056544774678049,0.0055042024626088,0.0053518953566102,0.0051976123802107,0.0050414104932882,0.0048833473641696,0.0047234813483394,0.0045618714669025,0.0043985773847905,0.0042336593887421,0.0040671783650470,0.0038991957770734,0.0037297736425858,0.0035589745108620,0.0033868614396116,0.0032134979717291,0.0030389481118675,0.0028632763028674,0.0026865474020607,0.0025088266574710,0.0023301796839807,0.0021506724395338,0.0019703712015729,0.0017893425440487,0.0016076533158139,0.0014253706223105,0.0012425618156457,0.0010592945081317,0.0008756366610054,0.0006916569631826,0.0005074266725909,0.0003230327522064,0.0001387924824471};
static const double pts163[163] = {-0.9998918335778662,-0.9994301214256386,-0.9985996447579498,-0.9974005256430949,-0.9958331841774067,-0.9938981936088486,-0.9915962665183652,-0.9889282520206996,-0.9858951347768580,-0.9824980344063866,-0.9787382049868191,-0.9746170345525721,-0.9701360445642790,-0.9652968893377195,-0.9601013554279519,-0.9545513609668166,-0.9486489549530341,-0.9423963164946502,-0.9357957540038413,-0.9288497043442199,-0.9215607319308606,-0.9139315277833324,-0.9059649085320547,-0.8976638153783176,-0.8890313130083417,-0.8800705884617706,-0.8707849499550020,-0.8611778256597931,-0.8512527624375906,-0.8410134245300410,-0.8304635922061736,-0.8196071603667467,-0.8084481371062811,-0.7969906422332987,-0.7852389057493211,-0.7731972662871903,-0.7608701695092778,-0.7482621664661880,-0.7353779119165451,-0.7222221626085044,-0.7087997755235929,-0.6951157060835628,-0.6811750063208912,-0.6669828230136171,-0.6525443957851936,-0.6378650551700699,-0.6229502206457059,-0.6078053986317487,-0.5924361804571147,-0.5768482402957215,-0.5610473330716326,-0.5450392923343964,-0.5288300281053485,-0.5124255246956889,-0.4958318384971284,-0.4790550957459248,-0.4621014902611307,-0.4449772811578965,-0.4276887905366551,-0.4102424011490728,-0.3926445540415799,-0.3749017461774113,-0.3570205280379758,-0.3390075012044851,-0.3208693159207083,-0.3026126686377621,-0.2842442995418450,-0.2657709900658208,-0.2471995603855767,-0.2285368669020773,-0.2097897997100427,-0.1909652800541925,-0.1720702577739806,-0.1531117087377834,-0.1340966322674701,-0.1150320485543199,-0.0959249960672305,-0.0767825289541784,-0.0576117144378972,-0.0384196302067191,-0.0192133618015589,-0.0000000000000001,0.0192133618015589,0.0384196302067187,0.0576117144378971,0.0767825289541787,0.0959249960672301,0.1150320485543201,0.1340966322674705,0.1531117087377832,0.1720702577739807,0.1909652800541928,0.2097897997100433,0.2285368669020771,0.2471995603855769,0.2657709900658208,0.2842442995418449,0.3026126686377620,0.3208693159207085,0.3390075012044853,0.3570205280379760,0.3749017461774113,0.3926445540415798,0.4102424011490715,0.4276887905366552,0.4449772811578953,0.4621014902611303,0.4790550957459244,0.4958318384971284,0.5124255246956892,0.5288300281053487,0.5450392923343967,0.5610473330716328,0.5768482402957213,0.5924361804571149,0.6078053986317489,0.6229502206457054,0.6378650551700694,0.6525443957851935,0.6669828230136163,0.6811750063208917,0.6951157060835620,0.7087997755235924,0.7222221626085041,0.7353779119165452,0.7482621664661872,0.7608701695092775,0.7731972662871903,0.7852389057493211,0.7969906422332991,0.8084481371062813,0.8196071603667470,0.8304635922061734,0.8410134245300414,0.8512527624375908,0.8611778256597936,0.8707849499550023,0.8800705884617710,0.8890313130083422,0.8976638153783180,0.9059649085320550,0.9139315277833322,0.9215607319308607,0.9288497043442198,0.9357957540038410,0.9423963164946498,0.9486489549530346,0.9545513609668169,0.9601013554279516,0.9652968893377194,0.9701360445642796,0.9746170345525718,0.9787382049868193,0.9824980344063869,0.9858951347768580,0.9889282520206998,0.9915962665183653,0.9938981936088488,0.9958331841774070,0.9974005256430954,0.9985996447579499,0.9994301214256388,0.9998918335778664};

static const double w164[164] = {0.0001371102299732,0.0003191179868280,0.0005012789594175,0.0006832805276301,0.0008650375954365,0.0010464805792481,0.0012275424305116,0.0014081568160962,0.0015882577435428,0.0017677794728266,0.0019466565023949,0.0021248235783844,0.0023022157121334,0.0024787682009452,0.0026544166502254,0.0028290969961931,0.0030027455288163,0.0031752989148047,0.0033466942205586,0.0035168689350260,0.0036857609924505,0.0038533087949672,0.0040194512350403,0.0041841277177384,0.0043472781828176,0.0045088431266216,0.0046687636237771,0.0048269813486781,0.0049834385967596,0.0051380783055344,0.0052908440754124,0.0054416801902592,0.0055905316377229,0.0057373441292932,0.0058820641201015,0.0060246388284516,0.0061650162550663,0.0063031452020525,0.0064389752915765,0.0065724569842345,0.0067035415971212,0.0068321813215853,0.0069583292406654,0.0070819393462021,0.0072029665556177,0.0073213667283587,0.0074370966819912,0.0075501142079566,0.0076603780869601,0.0077678481040052,0.0078724850630650,0.0079742508013705,0.0080731082033347,0.0081690212140868,0.0082619548526218,0.0083518752245605,0.0084387495345097,0.0085225460980235,0.0086032343531586,0.0086807848716232,0.0087551693695056,0.0088263607175952,0.0088943329512709,0.0089590612799770,0.0090205220962580,0.0090786929843774,0.0091335527284830,0.0091850813203520,0.0092332599666855,0.0092780710959638,0.0093194983648537,0.0093575266641695,0.0093921421243846,0.0094233321206881,0.0094510852775923,0.0094753914730777,0.0094962418422882,0.0095136287807613,0.0095275459472029,0.0095379882658012,0.0095449519280769,0.0095484343942693,0.0095484343942698,0.0095449519280767,0.0095379882658015,0.0095275459472030,0.0095136287807611,0.0094962418422883,0.0094753914730777,0.0094510852775922,0.0094233321206880,0.0093921421243842,0.0093575266641705,0.0093194983648533,0.0092780710959642,0.0092332599666858,0.0091850813203513,0.0091335527284828,0.0090786929843776,0.0090205220962585,0.0089590612799768,0.0088943329512708,0.0088263607175949,0.0087551693695063,0.0086807848716232,0.0086032343531590,0.0085225460980230,0.0084387495345099,0.0083518752245606,0.0082619548526216,0.0081690212140864,0.0080731082033350,0.0079742508013704,0.0078724850630652,0.0077678481040053,0.0076603780869596,0.0075501142079566,0.0074370966819909,0.0073213667283583,0.0072029665556177,0.0070819393462026,0.0069583292406644,0.0068321813215853,0.0067035415971212,0.0065724569842343,0.0064389752915769,0.0063031452020520,0.0061650162550662,0.0060246388284517,0.0058820641201023,0.0057373441292930,0.0055905316377231,0.0054416801902597,0.0052908440754124,0.0051380783055338,0.0049834385967586,0.0048269813486786,0.0046687636237773,0.0045088431266222,0.0043472781828177,0.0041841277177383,0.0040194512350400,0.0038533087949670,0.0036857609924509,0.0035168689350256,0.0033466942205580,0.0031752989148050,0.0030027455288169,0.0028290969961926,0.0026544166502249,0.0024787682009450,0.0023022157121334,0.0021248235783842,0.0019466565023947,0.0017677794728273,0.0015882577435429,0.0014081568160958,0.0012275424305118,0.0010464805792483,0.0008650375954365,0.0006832805276300,0.0005012789594175,0.0003191179868281,0.0001371102299736};
static const double pts164[164] = {-0.9998931446465129,-0.9994370283114320,-0.9986166146371370,-0.9974320205425258,-0.9958836557346293,-0.9939720795921735,-0.9916979875195026,-0.9890622081876042,-0.9860657025659991,-0.9827095633507903,-0.9789950144799878,-0.9749234106494821,-0.9704962368009622,-0.9657151075710858,-0.9605817666975534,-0.9550980863802534,-0.9492660665967169,-0.9430878343716269,-0.9365656430003773,-0.9297018712268132,-0.9224990223753672,-0.9149597234378467,-0.9070867241151861,-0.8988828958144844,-0.8903512306016805,-0.8814948401102483,-0.8723169544062876,-0.8628209208104440,-0.8530102026770576,-0.8428883781310096,-0.8324591387627064,-0.8217262882816881,-0.8106937411293441,-0.7993655210512511,-0.7877457596296404,-0.7758386947765387,-0.7636486691881327,-0.7511801287609161,-0.7384376209701967,-0.7254257932115546,-0.7121493911058678,-0.6986132567685009,-0.6848223270433129,-0.6707816317021054,-0.6564962916101864,-0.6419715168587095,-0.6272126048644675,-0.6122249384378410,-0.5970139838196012,-0.5815852886872849,-0.5659444801318655,-0.5500972626054655,-0.5340494158408498,-0.5178067927434661,-0.5013753172567963,-0.4847609822017986,-0.4679698470912359,-0.4510080359196636,-0.4338817349299210,-0.4165971903569080,-0.3991607061494777,-0.3815786416712941,-0.3638574093814642,-0.3460034724958161,-0.3280233426296573,-0.3099235774228894,-0.2917107781483278,-0.2733915873041154,-0.2549726861910955,-0.2364607924760368,-0.2178626577415916,-0.1991850650238873,-0.1804348263386425,-0.1616187801967207,-0.1427437891100123,-0.1238167370885686,-0.1048445271298946,-0.0858340787013123,-0.0667923252163266,-0.0477262115058936,-0.0286426912855319,-0.0095487246191917,0.0095487246191916,0.0286426912855320,0.0477262115058936,0.0667923252163274,0.0858340787013122,0.1048445271298944,0.1238167370885685,0.1427437891100120,0.1616187801967205,0.1804348263386422,0.1991850650238868,0.2178626577415913,0.2364607924760364,0.2549726861910952,0.2733915873041152,0.2917107781483277,0.3099235774228894,0.3280233426296571,0.3460034724958156,0.3638574093814640,0.3815786416712943,0.3991607061494780,0.4165971903569077,0.4338817349299216,0.4510080359196638,0.4679698470912362,0.4847609822017993,0.5013753172567962,0.5178067927434656,0.5340494158408496,0.5500972626054658,0.5659444801318660,0.5815852886872858,0.5970139838196016,0.6122249384378413,0.6272126048644674,0.6419715168587091,0.6564962916101864,0.6707816317021053,0.6848223270433131,0.6986132567685017,0.7121493911058676,0.7254257932115551,0.7384376209701966,0.7511801287609164,0.7636486691881325,0.7758386947765382,0.7877457596296397,0.7993655210512510,0.8106937411293441,0.8217262882816877,0.8324591387627061,0.8428883781310096,0.8530102026770576,0.8628209208104438,0.8723169544062879,0.8814948401102479,0.8903512306016809,0.8988828958144841,0.9070867241151858,0.9149597234378465,0.9224990223753673,0.9297018712268132,0.9365656430003773,0.9430878343716271,0.9492660665967175,0.9550980863802536,0.9605817666975535,0.9657151075710861,0.9704962368009622,0.9749234106494824,0.9789950144799882,0.9827095633507894,0.9860657025659995,0.9890622081876040,0.9916979875195021,0.9939720795921736,0.9958836557346299,0.9974320205425259,0.9986166146371372,0.9994370283114317,0.9998931446465129};

static const double w165[165] = {0.0001354583777269,0.0003152739515228,0.0004952422799424,0.0006750552995292,0.0008546297280885,0.0010338976068214,0.0012127934786982,0.0013912525902057,0.0015692105205365,0.0017466030938532,0.0019233663649284,0.0020994366276948,0.0022747504319828,0.0024492446034843,0.0026228562650703,0.0027955228586797,0.0029671821674438,0.0031377723378532,0.0033072319019035,0.0034754997991500,0.0036425153986548,0.0038082185207967,0.0039725494589246,0.0041354490008610,0.0042968584502237,0.0044567196475656,0.0046149749913241,0.0047715674585801,0.0049264406255883,0.0050795386881186,0.0052308064815513,0.0053801895007613,0.0055276339197526,0.0056730866110487,0.0058164951648429,0.0059578079078764,0.0060969739220582,0.0062339430628130,0.0063686659771481,0.0065010941214357,0.0066311797789058,0.0067588760768376,0.0068841370034494,0.0070069174244790,0.0071271730994435,0.0072448606975826,0.0073599378134709,0.0074723629822966,0.0075820956948035,0.0076890964118851,0.0077933265788359,0.0078947486392375,0.0079933260484966,0.0080890232870074,0.0081818058729554,0.0082716403747388,0.0083584944230139,0.0084423367223613,0.0085231370625615,0.0086008663294764,0.0086754965155483,0.0087470007298805,0.0088153532079376,0.0088805293208204,0.0089425055841454,0.0090012596665053,0.0090567703975144,0.0091090177754389,0.0091579829744011,0.0092036483511658,0.0092459974514960,0.0092850150160805,0.0093206869860353,0.0093530005079677,0.0093819439386047,0.0094075068489952,0.0094296800282603,0.0094484554869168,0.0094638264597556,0.0094757874082782,0.0094843340226921,0.0094894632234642,0.0094911731624307,0.0094894632234643,0.0094843340226922,0.0094757874082787,0.0094638264597563,0.0094484554869168,0.0094296800282602,0.0094075068489950,0.0093819439386048,0.0093530005079672,0.0093206869860356,0.0092850150160810,0.0092459974514954,0.0092036483511656,0.0091579829744010,0.0091090177754386,0.0090567703975151,0.0090012596665055,0.0089425055841452,0.0088805293208205,0.0088153532079375,0.0087470007298807,0.0086754965155485,0.0086008663294768,0.0085231370625614,0.0084423367223612,0.0083584944230138,0.0082716403747384,0.0081818058729560,0.0080890232870075,0.0079933260484965,0.0078947486392379,0.0077933265788360,0.0076890964118848,0.0075820956948028,0.0074723629822964,0.0073599378134712,0.0072448606975825,0.0071271730994439,0.0070069174244789,0.0068841370034499,0.0067588760768377,0.0066311797789062,0.0065010941214354,0.0063686659771478,0.0062339430628127,0.0060969739220587,0.0059578079078759,0.0058164951648431,0.0056730866110492,0.0055276339197517,0.0053801895007619,0.0052308064815516,0.0050795386881179,0.0049264406255882,0.0047715674585792,0.0046149749913243,0.0044567196475655,0.0042968584502240,0.0041354490008608,0.0039725494589243,0.0038082185207966,0.0036425153986557,0.0034754997991493,0.0033072319019029,0.0031377723378532,0.0029671821674434,0.0027955228586803,0.0026228562650698,0.0024492446034848,0.0022747504319830,0.0020994366276949,0.0019233663649282,0.0017466030938526,0.0015692105205360,0.0013912525902061,0.0012127934786989,0.0010338976068221,0.0008546297280887,0.0006750552995292,0.0004952422799426,0.0003152739515226,0.0001354583777270};
static const double pts165[165] = {-0.9998944320220912,-0.9994438103914965,-0.9986332779302194,-0.9974629465884158,-0.9959332159979790,-0.9940446320841096,-0.9917978735885290,-0.9891937493497496,-0.9862331973537822,-0.9829172841773544,-0.9792472045184929,-0.9752242807288589,-0.9708499623194932,-0.9661258254293881,-0.9610535722525892,-0.9556350304220067,-0.9498721523491742,-0.9437670145197008,-0.9373218167443916,-0.9305388813661690,-0.9234206524229831,-0.9159696947669688,-0.9081886931401285,-0.9000804512068610,-0.8916478905436651,-0.8828940495863778,-0.8738220825353189,-0.8644352582187316,-0.8547369589149314,-0.8447306791335777,-0.8344200243565125,-0.8238087097386138,-0.8129005587691355,-0.8016995018940163,-0.7902095750996434,-0.7784349184585998,-0.7663797746378956,-0.7540484873702432,-0.7414454998889100,-0.7285753533267247,-0.7154426850798024,-0.7020522271365933,-0.6884088043728338,-0.6745173328130464,-0.6603828178591784,-0.6460103524870531,-0.6314051154112514,-0.6165723692191130,-0.6015174584745047,-0.5862458077920605,-0.5707629198825701,-0.5550743735702348,-0.5391858217824931,-0.5231029895131435,-0.5068316717595100,-0.4903777314343714,-0.4737470972534267,-0.4569457615990507,-0.4399797783611057,-0.4228552607555877,-0.4055783791219111,-0.3881553586995863,-0.3705924773851417,-0.3528960634700537,-0.3350724933605221,-0.3171281892799167,-0.2990696169547058,-0.2809032832847133,-0.2626357339985408,-0.2442735512949979,-0.2258233514713892,-0.2072917825395217,-0.1886855218302765,-0.1700112735876209,-0.1512757665529222,-0.1324857515404357,-0.1136479990048351,-0.0947692966016745,-0.0758564467416408,-0.0569162641395002,-0.0379555733586065,-0.0189812063518583,0.0000000000000002,0.0189812063518580,0.0379555733586061,0.0569162641395004,0.0758564467416407,0.0947692966016745,0.1136479990048353,0.1324857515404353,0.1512757665529224,0.1700112735876210,0.1886855218302768,0.2072917825395219,0.2258233514713890,0.2442735512949971,0.2626357339985408,0.2809032832847130,0.2990696169547057,0.3171281892799167,0.3350724933605221,0.3528960634700537,0.3705924773851421,0.3881553586995863,0.4055783791219106,0.4228552607555878,0.4399797783611052,0.4569457615990519,0.4737470972534272,0.4903777314343724,0.5068316717595108,0.5231029895131437,0.5391858217824929,0.5550743735702347,0.5707629198825699,0.5862458077920604,0.6015174584745051,0.6165723692191134,0.6314051154112514,0.6460103524870526,0.6603828178591785,0.6745173328130457,0.6884088043728338,0.7020522271365929,0.7154426850798028,0.7285753533267245,0.7414454998889101,0.7540484873702438,0.7663797746378960,0.7784349184586000,0.7902095750996434,0.8016995018940158,0.8129005587691351,0.8238087097386134,0.8344200243565125,0.8447306791335776,0.8547369589149315,0.8644352582187312,0.8738220825353186,0.8828940495863783,0.8916478905436649,0.9000804512068610,0.9081886931401285,0.9159696947669688,0.9234206524229835,0.9305388813661691,0.9373218167443919,0.9437670145197009,0.9498721523491742,0.9556350304220065,0.9610535722525889,0.9661258254293875,0.9708499623194929,0.9752242807288591,0.9792472045184925,0.9829172841773539,0.9862331973537819,0.9891937493497490,0.9917978735885287,0.9940446320841093,0.9959332159979792,0.9974629465884159,0.9986332779302196,0.9994438103914965,0.9998944320220911};

static const double w166[166] = {0.0001338361976164,0.0003114989527110,0.0004893139767404,0.0006669776623033,0.0008444084897773,0.0010215400773591,0.0011983085124431,0.0013746505743622,0.0015505033674715,0.0017258042339208,0.0019004907389263,0.0020745006786828,0.0022477720963620,0.0024202433013082,0.0025918528895735,0.0027625397650187,0.0029322431606509,0.0031009026600111,0.0032684582185433,0.0034348501848765,0.0036000193220077,0.0037639068283539,0.0039264543586595,0.0040876040447531,0.0042472985161346,0.0044054809203955,0.0045620949434490,0.0047170848295772,0.0048703954012748,0.0050219720788918,0.0051717609000639,0.0053197085389192,0.0054657623250640,0.0056098702623306,0.0057519810472920,0.0058920440875207,0.0060300095196025,0.0061658282268894,0.0062994518569800,0.0064308328389393,0.0065599244002292,0.0066866805833629,0.0068110562622640,0.0069330071583332,0.0070524898562113,0.0071694618192328,0.0072838814045728,0.0073957078780720,0.0075049014287345,0.0076114231829045,0.0077152352181025,0.0078163005765317,0.0079145832782276,0.0080100483338723,0.0081026617572482,0.0081923905773398,0.0082792028500695,0.0083630676696708,0.0084439551796903,0.0085218365836189,0.0085966841551413,0.0086684712480057,0.0087371723055135,0.0088027628696168,0.0088652195896219,0.0089245202305090,0.0089806436808397,0.0090335699602810,0.0090832802267136,0.0091297567829397,0.0091729830829867,0.0092129437379939,0.0092496245216929,0.0092830123754729,0.0093130954130291,0.0093398629245920,0.0093633053807432,0.0093834144358081,0.0094001829308247,0.0094136048960932,0.0094236755533011,0.0094303913172254,0.0094337497970093,0.0094337497970092,0.0094303913172257,0.0094236755533012,0.0094136048960927,0.0094001829308241,0.0093834144358081,0.0093633053807432,0.0093398629245916,0.0093130954130291,0.0092830123754729,0.0092496245216929,0.0092129437379932,0.0091729830829870,0.0091297567829403,0.0090832802267140,0.0090335699602814,0.0089806436808395,0.0089245202305088,0.0088652195896227,0.0088027628696168,0.0087371723055134,0.0086684712480055,0.0085966841551411,0.0085218365836190,0.0084439551796905,0.0083630676696700,0.0082792028500696,0.0081923905773401,0.0081026617572483,0.0080100483338725,0.0079145832782277,0.0078163005765321,0.0077152352181029,0.0076114231829038,0.0075049014287344,0.0073957078780720,0.0072838814045729,0.0071694618192323,0.0070524898562115,0.0069330071583339,0.0068110562622633,0.0066866805833625,0.0065599244002292,0.0064308328389389,0.0062994518569805,0.0061658282268884,0.0060300095196025,0.0058920440875205,0.0057519810472919,0.0056098702623309,0.0054657623250635,0.0053197085389195,0.0051717609000638,0.0050219720788920,0.0048703954012741,0.0047170848295771,0.0045620949434491,0.0044054809203955,0.0042472985161347,0.0040876040447525,0.0039264543586594,0.0037639068283538,0.0036000193220083,0.0034348501848771,0.0032684582185439,0.0031009026600113,0.0029322431606508,0.0027625397650187,0.0025918528895730,0.0024202433013084,0.0022477720963612,0.0020745006786828,0.0019004907389266,0.0017258042339205,0.0015505033674710,0.0013746505743623,0.0011983085124433,0.0010215400773591,0.0008444084897773,0.0006669776623040,0.0004893139767399,0.0003114989527112,0.0001338361976162};
static const double pts166[166] = {-0.9998956962720705,-0.9994504706546727,-0.9986496419776556,-0.9974933173961699,-0.9959818867698573,-0.9941158829712635,-0.9918959685751222,-0.9893229331769566,-0.9863976924620135,-0.9831212876630852,-0.9794948851057408,-0.9755197757563594,-0.9711973747449725,-0.9665292208524378,-0.9615169759577004,-0.9561624244433381,-0.9504674725586238,-0.9444341477398482,-0.9380645978878686,-0.9313610906030156,-0.9243260123775079,-0.9169618677456486,-0.9092712783920541,-0.9012569822182115,-0.8929218323676970,-0.8842687962103837,-0.8753009542859955,-0.8660214992073870,-0.8564337345239271,-0.8465410735453941,-0.8363470381268011,-0.8258552574145820,-0.8150694665545811,-0.8039935053623067,-0.7926313169559295,-0.7809869463524949,-0.7690645390278736,-0.7568683394409322,-0.7444026895224806,-0.7316720271295097,-0.7186808844652832,-0.7054338864658400,-0.6919357491534869,-0.6781912779578561,-0.6642053660051410,-0.6499829923761122,-0.6355292203335248,-0.6208491955195634,-0.6059481441239588,-0.5908313710234262,-0.5755042578930937,-0.5599722612905922,-0.5442409107134715,-0.5283158066306740,-0.5122026184887227,-0.4959070826933590,-0.4794350005673451,-0.4627922362851525,-0.4459847147852721,-0.4290184196609003,-0.4118993910297365,-0.3946337233836552,-0.3772275634190344,-0.3596871078484797,-0.3420186011947596,-0.3242283335677066,-0.3063226384248984,-0.2883078903169016,-0.2701905026178899,-0.2519769252424355,-0.2336736423492980,-0.2152871700330185,-0.1968240540041445,-0.1782908672589115,-0.1596942077392142,-0.1410406959836894,-0.1223369727707617,-0.1035896967544803,-0.0848055420939903,-0.0659911960774903,-0.0471533567415071,-0.0282987304863514,-0.0094340296885930,0.0094340296885923,0.0282987304863505,0.0471533567415065,0.0659911960774898,0.0848055420939901,0.1035896967544796,0.1223369727707611,0.1410406959836883,0.1596942077392135,0.1782908672589111,0.1968240540041438,0.2152871700330181,0.2336736423492977,0.2519769252424354,0.2701905026178896,0.2883078903169016,0.3063226384248979,0.3242283335677064,0.3420186011947596,0.3596871078484795,0.3772275634190341,0.3946337233836552,0.4118993910297363,0.4290184196609010,0.4459847147852722,0.4627922362851530,0.4794350005673456,0.4959070826933585,0.5122026184887220,0.5283158066306736,0.5442409107134716,0.5599722612905921,0.5755042578930953,0.5908313710234261,0.6059481441239584,0.6208491955195633,0.6355292203335247,0.6499829923761119,0.6642053660051407,0.6781912779578551,0.6919357491534871,0.7054338864658403,0.7186808844652838,0.7316720271295095,0.7444026895224808,0.7568683394409327,0.7690645390278743,0.7809869463524958,0.7926313169559293,0.8039935053623072,0.8150694665545807,0.8258552574145821,0.8363470381268010,0.8465410735453938,0.8564337345239269,0.8660214992073872,0.8753009542859955,0.8842687962103836,0.8929218323676972,0.9012569822182116,0.9092712783920543,0.9169618677456494,0.9243260123775078,0.9313610906030159,0.9380645978878691,0.9444341477398482,0.9504674725586246,0.9561624244433388,0.9615169759577008,0.9665292208524376,0.9711973747449728,0.9755197757563597,0.9794948851057410,0.9831212876630858,0.9863976924620144,0.9893229331769577,0.9918959685751220,0.9941158829712639,0.9959818867698574,0.9974933173961703,0.9986496419776564,0.9994504706546733,0.9998956962720715};

static const double w167[167] = {0.0001322429832164,0.0003077913472005,0.0004834914713994,0.0006590441068292,0.0008343694469386,0.0010094026408107,0.0011840812748305,0.0013583436160572,0.0015321282491590,0.0017053739896965,0.0018780198690616,0.0020500051417671,0.0022212693007561,0.0023917520958491,0.0025613935535267,0.0027301339972878,0.0028979140682201,0.0030646747456482,0.0032303573677508,0.0033949036521045,0.0035582557161370,0.0037203560974466,0.0038811477739928,0.0040405741841381,0.0041985792465343,0.0043551073798430,0.0045101035222782,0.0046635131509755,0.0048152823011635,0.0049653575851524,0.0051136862111029,0.0052602160016029,0.0054048954120180,0.0055476735486222,0.0056885001865015,0.0058273257872199,0.0059641015162458,0.0060987792601294,0.0062313116434292,0.0063616520453727,0.0064897546162632,0.0066155742935998,0.0067390668179357,0.0068601887484430,0.0069788974781961,0.0070951512491582,0.0072089091668708,0.0073201312148395,0.0074287782686099,0.0075348121095304,0.0076381954381941,0.0077388918875685,0.0078368660357755,0.0079320834185598,0.0080245105414102,0.0081141148913429,0.0082008649483375,0.0082847301964237,0.0083656811344201,0.0084436892863051,0.0085187272112421,0.0085907685132228,0.0086597878503623,0.0087257609438053,0.0087886645862727,0.0088484766502219,0.0089051760956296,0.0089587429773978,0.0090091584523654,0.0090564047859366,0.0091004653583242,0.0091413246703891,0.0091789683490994,0.0092133831525798,0.0092445569747749,0.0092724788497033,0.0092971389553187,0.0093185286169663,0.0093366403104271,0.0093514676645722,0.0093630054635990,0.0093712496488702,0.0093761973203379,0.0093778467375645,0.0093761973203376,0.0093712496488699,0.0093630054635989,0.0093514676645721,0.0093366403104266,0.0093185286169662,0.0092971389553196,0.0092724788497026,0.0092445569747739,0.0092133831525797,0.0091789683490996,0.0091413246703894,0.0091004653583240,0.0090564047859374,0.0090091584523646,0.0089587429773978,0.0089051760956299,0.0088484766502214,0.0087886645862732,0.0087257609438056,0.0086597878503624,0.0085907685132228,0.0085187272112411,0.0084436892863055,0.0083656811344195,0.0082847301964240,0.0082008649483369,0.0081141148913427,0.0080245105414095,0.0079320834185602,0.0078368660357753,0.0077388918875691,0.0076381954381948,0.0075348121095299,0.0074287782686096,0.0073201312148394,0.0072089091668710,0.0070951512491585,0.0069788974781962,0.0068601887484428,0.0067390668179356,0.0066155742935996,0.0064897546162634,0.0063616520453733,0.0062313116434286,0.0060987792601301,0.0059641015162458,0.0058273257872204,0.0056885001865016,0.0055476735486215,0.0054048954120178,0.0052602160016031,0.0051136862111025,0.0049653575851528,0.0048152823011637,0.0046635131509757,0.0045101035222784,0.0043551073798427,0.0041985792465346,0.0040405741841375,0.0038811477739930,0.0037203560974467,0.0035582557161376,0.0033949036521046,0.0032303573677505,0.0030646747456487,0.0028979140682202,0.0027301339972879,0.0025613935535267,0.0023917520958482,0.0022212693007564,0.0020500051417678,0.0018780198690608,0.0017053739896970,0.0015321282491587,0.0013583436160579,0.0011840812748303,0.0010094026408105,0.0008343694469387,0.0006590441068291,0.0004834914713998,0.0003077913472008,0.0001322429832158};
static const double pts167[167] = {-0.9998969379470357,-0.9994570120008636,-0.9986657139015422,-0.9975231461763198,-0.9960296892046703,-0.9941858631931223,-0.9919923150274761,-0.9894498156288601,-0.9865592590403127,-0.9833216618986811,-0.9797381629939146,-0.9758100228321663,-0.9715386231750287,-0.9669254665445520,-0.9619721756898436,-0.9566804930134469,-0.9510522799567613,-0.9450895163442102,-0.9387942996861490,-0.9321688444405933,-0.9252154812339499,-0.9179366560409790,-0.9103349293242368,-0.9024129751332824,-0.8941735801639625,-0.8856196427780827,-0.8767541719838161,-0.8675802863771981,-0.8581012130450788,-0.8483202864299181,-0.8382409471568161,-0.8278667408232023,-0.8172013167515924,-0.8062484267058674,-0.7950119235715100,-0.7834957600002781,-0.7717039870197828,-0.7596407526084578,-0.7473103002364256,-0.7347169673727812,-0.7218651839597975,-0.7087594708546110,-0.6954044382389247,-0.6818047839972863,-0.6679652920645203,-0.6538908307428876,-0.6395863509895644,-0.6250568846750566,-0.6103075428131356,-0.5953435137629466,-0.5801700614039071,-0.5647925232840322,-0.5492163087423577,-0.5334468970060962,-0.5174898352632203,-0.5013507367111336,-0.4850352785821212,-0.4685492001462755,-0.4518983006926021,-0.4350884374890073,-0.4181255237218991,-0.4010155264161039,-0.3837644643358595,-0.3663784058675999,-0.3488634668852836,-0.3312258085990222,-0.3134716353877574,-0.2956071926167522,-0.2776387644406687,-0.2595726715929962,-0.2414152691626152,-0.2231729443582737,-0.2048521142617654,-0.1864592235706036,-0.1680007423309733,-0.1494831636617725,-0.1309130014705354,-0.1122967881620418,-0.0936410723404197,-0.0749524165055523,-0.0562373947445927,-0.0375025904194070,-0.0187545938507507,-0.0000000000000005,0.0187545938507508,0.0375025904194065,0.0562373947445925,0.0749524165055516,0.0936410723404192,0.1122967881620412,0.1309130014705352,0.1494831636617718,0.1680007423309727,0.1864592235706033,0.2048521142617650,0.2231729443582734,0.2414152691626152,0.2595726715929962,0.2776387644406686,0.2956071926167519,0.3134716353877570,0.3312258085990225,0.3488634668852838,0.3663784058675999,0.3837644643358594,0.4010155264161036,0.4181255237218988,0.4350884374890077,0.4518983006926014,0.4685492001462748,0.4850352785821209,0.5013507367111337,0.5174898352632202,0.5334468970060958,0.5492163087423577,0.5647925232840323,0.5801700614039068,0.5953435137629464,0.6103075428131352,0.6250568846750565,0.6395863509895648,0.6538908307428869,0.6679652920645198,0.6818047839972861,0.6954044382389245,0.7087594708546111,0.7218651839597976,0.7347169673727811,0.7473103002364259,0.7596407526084573,0.7717039870197830,0.7834957600002781,0.7950119235715094,0.8062484267058674,0.8172013167515928,0.8278667408232023,0.8382409471568161,0.8483202864299181,0.8581012130450792,0.8675802863771984,0.8767541719838167,0.8856196427780832,0.8941735801639626,0.9024129751332827,0.9103349293242372,0.9179366560409791,0.9252154812339495,0.9321688444405931,0.9387942996861494,0.9450895163442106,0.9510522799567616,0.9566804930134474,0.9619721756898435,0.9669254665445521,0.9715386231750286,0.9758100228321663,0.9797381629939151,0.9833216618986816,0.9865592590403128,0.9894498156288605,0.9919923150274765,0.9941858631931229,0.9960296892046712,0.9975231461763200,0.9986657139015426,0.9994570120008646,0.9998969379470365};

static const double w168[168] = {0.0001306780490005,0.0003041495403918,0.0004777722617274,0.0006512512276298,0.0008245082968264,0.0009974801047913,0.0011701056930612,0.0013423247728871,0.0015140773659691,0.0016853037182688,0.0018559442846225,0.0020259397354597,0.0021952309714275,0.0023637591411403,0.0025314656602397,0.0026982922310224,0.0028641808622978,0.0030290738893085,0.0031929139936350,0.0033556442230348,0.0035172080111798,0.0036775491972864,0.0038366120456137,0.0039943412648170,0.0041506820271642,0.0043055799875780,0.0044589813025252,0.0046108326487292,0.0047610812417020,0.0049096748540871,0.0050565618338190,0.0052016911220693,0.0053450122710014,0.0054864754612971,0.0056260315194816,0.0057636319350126,0.0058992288771402,0.0060327752115377,0.0061642245166830,0.0062935310999935,0.0064206500137117,0.0065455370705266,0.0066681488589369,0.0067884427583366,0.0069063769538351,0.0070219104507851,0.0071350030890421,0.0072456155569149,0.0073537094048381,0.0074592470587312,0.0075621918330653,0.0076625079436074,0.0077601605198712,0.0078551156172267,0.0079473402287036,0.0080368022964659,0.0081234707229575,0.0082073153817032,0.0082883071277932,0.0083664178080025,0.0084416202705850,0.0085138883747065,0.0085831969995360,0.0086495220529741,0.0087128404800288,0.0087731302708305,0.0088303704682819,0.0088845411753427,0.0089356235619449,0.0089835998715419,0.0090284534272761,0.0090701686377794,0.0091087310025914,0.0091441271172001,0.0091763446777001,0.0092053724850727,0.0092312004490744,0.0092538195917496,0.0092732220505458,0.0092894010810512,0.0093023510593359,0.0093120674839093,0.0093185469772827,0.0093217872871447,0.0093217872871447,0.0093185469772830,0.0093120674839091,0.0093023510593361,0.0092894010810510,0.0092732220505460,0.0092538195917499,0.0092312004490747,0.0092053724850725,0.0091763446777002,0.0091441271172008,0.0091087310025915,0.0090701686377800,0.0090284534272759,0.0089835998715418,0.0089356235619446,0.0088845411753425,0.0088303704682821,0.0087731302708308,0.0087128404800287,0.0086495220529736,0.0085831969995358,0.0085138883747066,0.0084416202705844,0.0083664178080028,0.0082883071277929,0.0082073153817034,0.0081234707229566,0.0080368022964664,0.0079473402287030,0.0078551156172273,0.0077601605198718,0.0076625079436078,0.0075621918330647,0.0074592470587313,0.0073537094048379,0.0072456155569149,0.0071350030890413,0.0070219104507850,0.0069063769538351,0.0067884427583371,0.0066681488589369,0.0065455370705264,0.0064206500137114,0.0062935310999938,0.0061642245166831,0.0060327752115380,0.0058992288771404,0.0057636319350118,0.0056260315194824,0.0054864754612974,0.0053450122710010,0.0052016911220701,0.0050565618338192,0.0049096748540873,0.0047610812417018,0.0046108326487293,0.0044589813025249,0.0043055799875782,0.0041506820271642,0.0039943412648171,0.0038366120456134,0.0036775491972864,0.0035172080111800,0.0033556442230347,0.0031929139936354,0.0030290738893083,0.0028641808622975,0.0026982922310224,0.0025314656602393,0.0023637591411401,0.0021952309714275,0.0020259397354603,0.0018559442846224,0.0016853037182686,0.0015140773659690,0.0013423247728868,0.0011701056930612,0.0009974801047919,0.0008245082968262,0.0006512512276296,0.0004777722617275,0.0003041495403923,0.0001306780490002};
static const double pts168[168] = {-0.9998981575812802,-0.9994634372441964,-0.9986815006133610,-0.9975524457488848,-0.9960766438317991,-0.9942546027756011,-0.9920869542383607,-0.9895744510153639,-0.9867179661428115,-0.9835184923832692,-0.9799771417984734,-0.9760951453268985,-0.9718738523387213,-0.9673147301579573,-0.9624193635476055,-0.9571894541560211,-0.9516268199237740,-0.9457333944507034,-0.9395112263231343,-0.9329624784013568,-0.9260894270675110,-0.9188944614341092,-0.9113800825134273,-0.9035489023480411,-0.8954036431027897,-0.8869471361184856,-0.8781823209276847,-0.8691122442328533,-0.8597400588473016,-0.8500690225992227,-0.8401024971992395,-0.8298439470718456,-0.8192969381511409,-0.8084651366412842,-0.7973523077420931,-0.7859623143402336,-0.7742991156664555,-0.7623667659193339,-0.7501694128560048,-0.7377112963503775,-0.7249967469193254,-0.7120301842173742,-0.6988161155003987,-0.6853591340588727,-0.6716639176212139,-0.6577352267277768,-0.6435779030760573,-0.6291968678376899,-0.6145971199478202,-0.5997837343674378,-0.5847618603192978,-0.5695367194980123,-0.5541136042549619,-0.5384978757586369,-0.5226949621310668,-0.5067103565609726,-0.4905496153942978,-0.4742183562027874,-0.4577222558312925,-0.4410670484244575,-0.4242585234335003,-0.4073025236037605,-0.3902049429437299,-0.3729717246762582,-0.3556088591726488,-0.3381223818703743,-0.3205183711751173,-0.3028029463478846,-0.2849822653779100,-0.2670625228421030,-0.2490499477517746,-0.2309508013873957,-0.2127713751221393,-0.1945179882349575,-0.1761969857139660,-0.1578147360508835,-0.1393776290273075,-0.1208920734935898,-0.1023644951410766,-0.0838013342685009,-0.0652090435432961,-0.0465940857586105,-0.0279629315867979,-0.0093220573301760,0.0093220573301765,0.0279629315867976,0.0465940857586098,0.0652090435432958,0.0838013342685003,0.1023644951410764,0.1208920734935897,0.1393776290273072,0.1578147360508828,0.1761969857139660,0.1945179882349577,0.2127713751221394,0.2309508013873964,0.2490499477517748,0.2670625228421033,0.2849822653779103,0.3028029463478848,0.3205183711751177,0.3381223818703740,0.3556088591726488,0.3729717246762579,0.3902049429437300,0.4073025236037599,0.4242585234334995,0.4410670484244578,0.4577222558312923,0.4742183562027876,0.4905496153942971,0.5067103565609731,0.5226949621310674,0.5384978757586366,0.5541136042549619,0.5695367194980133,0.5847618603192984,0.5997837343674383,0.6145971199478203,0.6291968678376906,0.6435779030760576,0.6577352267277776,0.6716639176212142,0.6853591340588722,0.6988161155003990,0.7120301842173744,0.7249967469193259,0.7377112963503775,0.7501694128560041,0.7623667659193337,0.7742991156664556,0.7859623143402337,0.7973523077420934,0.8084651366412842,0.8192969381511414,0.8298439470718465,0.8401024971992397,0.8500690225992227,0.8597400588473021,0.8691122442328533,0.8781823209276836,0.8869471361184856,0.8954036431027894,0.9035489023480415,0.9113800825134278,0.9188944614341091,0.9260894270675106,0.9329624784013566,0.9395112263231340,0.9457333944507031,0.9516268199237744,0.9571894541560207,0.9624193635476052,0.9673147301579574,0.9718738523387211,0.9760951453268980,0.9799771417984728,0.9835184923832688,0.9867179661428113,0.9895744510153640,0.9920869542383604,0.9942546027756012,0.9960766438317989,0.9975524457488848,0.9986815006133609,0.9994634372441966,0.9998981575812803};

static const double w169[169] = {0.0001291407296030,0.0003005719845710,0.0004721539190557,0.0006435957192235,0.0008148208629113,0.0009857674290431,0.0011563758719941,0.0013265873051947,0.0014963431456080,0.0016655850280756,0.0018342547896392,0.0020022944756993,0.0021696463540046,0.0023362529317143,0.0025020569737693,0.0026670015218313,0.0028310299134379,0.0029940858012390,0.0031561131722156,0.0033170563668250,0.0034768600980826,0.0036354694705001,0.0037928299989360,0.0039488876272835,0.0041035887470366,0.0042568802156927,0.0044087093750052,0.0045590240690702,0.0047077726622331,0.0048549040568320,0.0050003677107451,0.0051441136547503,0.0052860925096939,0.0054262555034461,0.0055645544876628,0.0057009419543163,0.0058353710520202,0.0059677956021229,0.0060981701145672,0.0062264498035211,0.0063525906027604,0.0064765491808028,0.0065982829558006,0.0067177501101594,0.0068349096049104,0.0069497211938031,0.0070621454371332,0.0071721437152882,0.0072796782420174,0.0073847120774097,0.0074872091405834,0.0075871342220769,0.0076844529959557,0.0077791320315889,0.0078711388051408,0.0079604417107452,0.0080470100713577,0.0081308141492978,0.0082118251564596,0.0082900152642058,0.0083653576129263,0.0084378263212614,0.0085073964949970,0.0085740442356117,0.0086377466484937,0.0086984818507946,0.0087562289789569,0.0088109681958737,0.0088626806977101,0.0089113487203533,0.0089569555455231,0.0089994855065121,0.0090389239935662,0.0090752574589047,0.0091084734213740,0.0091385604707349,0.0091655082715821,0.0091893075668939,0.0092099501812156,0.0092274290234622,0.0092417380893589,0.0092528724635027,0.0092608283210497,0.0092656029290286,0.0092671946472824,0.0092656029290291,0.0092608283210496,0.0092528724635027,0.0092417380893597,0.0092274290234622,0.0092099501812158,0.0091893075668946,0.0091655082715818,0.0091385604707352,0.0091084734213740,0.0090752574589044,0.0090389239935657,0.0089994855065116,0.0089569555455237,0.0089113487203531,0.0088626806977102,0.0088109681958746,0.0087562289789568,0.0086984818507946,0.0086377466484937,0.0085740442356121,0.0085073964949965,0.0084378263212616,0.0083653576129261,0.0082900152642059,0.0082118251564596,0.0081308141492974,0.0080470100713576,0.0079604417107457,0.0078711388051411,0.0077791320315884,0.0076844529959568,0.0075871342220783,0.0074872091405819,0.0073847120774098,0.0072796782420174,0.0071721437152884,0.0070621454371330,0.0069497211938028,0.0068349096049107,0.0067177501101595,0.0065982829558001,0.0064765491808035,0.0063525906027594,0.0062264498035215,0.0060981701145672,0.0059677956021227,0.0058353710520199,0.0057009419543163,0.0055645544876628,0.0054262555034465,0.0052860925096933,0.0051441136547498,0.0050003677107453,0.0048549040568321,0.0047077726622329,0.0045590240690697,0.0044087093750056,0.0042568802156925,0.0041035887470360,0.0039488876272838,0.0037928299989361,0.0036354694705004,0.0034768600980826,0.0033170563668257,0.0031561131722147,0.0029940858012394,0.0028310299134377,0.0026670015218309,0.0025020569737694,0.0023362529317139,0.0021696463540048,0.0020022944756995,0.0018342547896390,0.0016655850280758,0.0014963431456076,0.0013265873051954,0.0011563758719938,0.0009857674290429,0.0008148208629114,0.0006435957192234,0.0004721539190561,0.0003005719845709,0.0001291407296033};
static const double pts169[169] = {-0.9998993556933840,-0.9994697491160440,-0.9986970088214079,-0.9975812285571393,-0.9961227705776192,-0.9943221308632115,-0.9921799262892878,-0.9896968920546326,-0.9868738808017298,-0.9837118621152762,-0.9802119221079754,-0.9763752630119900,-0.9722032027489985,-0.9676971744687616,-0.9628587260520606,-0.9576895195762546,-0.9521913307427081,-0.9463660482658031,-0.9402156732234905,-0.9337423183694658,-0.9269482074071242,-0.9198356742254820,-0.9124071620973123,-0.9046652228397435,-0.8966125159375975,-0.8882518076297575,-0.8795859699588856,-0.8706179797847962,-0.8613509177618295,-0.8517879672805857,-0.8419324133743563,-0.8317876415906565,-0.8213571368282199,-0.8106444821398717,-0.7996533575016879,-0.7883875385488553,-0.7768508952786732,-0.7650473907211442,-0.7529810795776044,-0.7406561068278612,-0.7280767063063239,-0.7152471992476107,-0.7021719928021267,-0.6888555785221380,-0.6753025308188443,-0.6615175053909927,-0.6475052376255651,-0.6332705409710969,-0.6188183052841707,-0.6041534951496749,-0.5892811481753771,-0.5742063732614293,-0.5589343488453746,-0.5434703211232560,-0.5278196022474736,-0.5119875685019654,-0.4959796584553631,-0.4798013710927516,-0.4634582639266802,-0.4469559510880597,-0.4303001013976138,-0.4134964364185487,-0.3965507284910962,-0.3794687987496189,-0.3622565151229543,-0.3449197903186836,-0.3274645797920131,-0.3098968796999816,-0.2922227248416766,-0.2744481865851788,-0.2565793707819488,-0.2386224156693623,-0.2205834897621237,-0.2024687897332778,-0.1842845382855497,-0.1660369820137402,-0.1477323892589184,-0.1293770479551394,-0.1109772634694340,-0.0925393564358121,-0.0740696605840158,-0.0555745205637795,-0.0370602897653333,-0.0185333281369114,0.0000000000000001,0.0185333281369106,0.0370602897653328,0.0555745205637789,0.0740696605840157,0.0925393564358120,0.1109772634694337,0.1293770479551383,0.1477323892589182,0.1660369820137400,0.1842845382855497,0.2024687897332778,0.2205834897621231,0.2386224156693617,0.2565793707819485,0.2744481865851784,0.2922227248416763,0.3098968796999817,0.3274645797920132,0.3449197903186835,0.3622565151229545,0.3794687987496185,0.3965507284910958,0.4134964364185487,0.4303001013976143,0.4469559510880600,0.4634582639266809,0.4798013710927524,0.4959796584553635,0.5119875685019659,0.5278196022474744,0.5434703211232558,0.5589343488453747,0.5742063732614303,0.5892811481753776,0.6041534951496746,0.6188183052841715,0.6332705409710970,0.6475052376255651,0.6615175053909931,0.6753025308188442,0.6888555785221381,0.7021719928021264,0.7152471992476107,0.7280767063063239,0.7406561068278611,0.7529810795776046,0.7650473907211445,0.7768508952786731,0.7883875385488550,0.7996533575016878,0.8106444821398714,0.8213571368282195,0.8317876415906568,0.8419324133743569,0.8517879672805856,0.8613509177618295,0.8706179797847960,0.8795859699588863,0.8882518076297572,0.8966125159375968,0.9046652228397434,0.9124071620973120,0.9198356742254817,0.9269482074071245,0.9337423183694659,0.9402156732234903,0.9463660482658036,0.9521913307427086,0.9576895195762545,0.9628587260520600,0.9676971744687616,0.9722032027489981,0.9763752630119891,0.9802119221079751,0.9837118621152756,0.9868738808017294,0.9896968920546326,0.9921799262892881,0.9943221308632114,0.9961227705776193,0.9975812285571390,0.9986970088214079,0.9994697491160438,0.9998993556933838};

static const double w170[170] = {0.0001276303791121,0.0002970571772581,0.0004666340856686,0.0006360743726221,0.0008053030904665,0.0009742597201184,0.0011428860879509,0.0013111246690196,0.0014789182352223,0.0016462097702040,0.0018129424533884,0.0019790596656224,0.0021445050025366,0.0023092222909666,0.0024731556066572,0.0026362492925340,0.0027984479771961,0.0029596965934868,0.0031199403970503,0.0032791249848324,0.0034371963134980,0.0035941007177403,0.0037497849284795,0.0039041960909304,0.0040572817825371,0.0042089900307622,0.0043592693307235,0.0045080686626785,0.0046553375093440,0.0048010258730409,0.0049450842926674,0.0050874638604941,0.0052281162387602,0.0053669936760907,0.0055040490237015,0.0056392357514080,0.0057725079634238,0.0059038204139395,0.0060331285224840,0.0061603883890580,0.0062855568090425,0.0064085912878599,0.0065294500554068,0.0066480920802323,0.0067644770834660,0.0068785655524969,0.0069903187543850,0.0070996987490112,0.0072066684019591,0.0073111913971214,0.0074132322490278,0.0075127563148961,0.0076097298063906,0.0077041198010889,0.0077958942536710,0.0078850220067866,0.0079714728016376,0.0080552172882533,0.0081362270354505,0.0082144745404894,0.0082899332384068,0.0083625775110400,0.0084323826957192,0.0084993250936417,0.0085633819779238,0.0086245316013046,0.0086827532035387,0.0087380270184429,0.0087903342806030,0.0088396572317476,0.0088859791267774,0.0089292842394480,0.0089695578677093,0.0090067863386996,0.0090409570133854,0.0090720582908499,0.0091000796122364,0.0091250114643307,0.0091468453827890,0.0091655739550161,0.0091811908226753,0.0091936906838547,0.0092030692948630,0.0092093234716675,0.0092124510909820,0.0092124510909817,0.0092093234716677,0.0092030692948624,0.0091936906838546,0.0091811908226756,0.0091655739550158,0.0091468453827891,0.0091250114643304,0.0091000796122366,0.0090720582908501,0.0090409570133854,0.0090067863386995,0.0089695578677096,0.0089292842394478,0.0088859791267777,0.0088396572317477,0.0087903342806027,0.0087380270184431,0.0086827532035385,0.0086245316013039,0.0085633819779236,0.0084993250936425,0.0084323826957187,0.0083625775110397,0.0082899332384070,0.0082144745404890,0.0081362270354506,0.0080552172882533,0.0079714728016378,0.0078850220067866,0.0077958942536712,0.0077041198010898,0.0076097298063900,0.0075127563148967,0.0074132322490275,0.0073111913971209,0.0072066684019588,0.0070996987490114,0.0069903187543851,0.0068785655524966,0.0067644770834660,0.0066480920802322,0.0065294500554072,0.0064085912878597,0.0062855568090424,0.0061603883890581,0.0060331285224842,0.0059038204139399,0.0057725079634239,0.0056392357514081,0.0055040490237014,0.0053669936760909,0.0052281162387603,0.0050874638604935,0.0049450842926670,0.0048010258730406,0.0046553375093441,0.0045080686626788,0.0043592693307230,0.0042089900307623,0.0040572817825373,0.0039041960909314,0.0037497849284787,0.0035941007177398,0.0034371963134981,0.0032791249848322,0.0031199403970504,0.0029596965934866,0.0027984479771958,0.0026362492925340,0.0024731556066569,0.0023092222909665,0.0021445050025364,0.0019790596656222,0.0018129424533888,0.0016462097702041,0.0014789182352225,0.0013111246690194,0.0011428860879513,0.0009742597201175,0.0008053030904673,0.0006360743726222,0.0004666340856681,0.0002970571772583,0.0001276303791122};
static const double pts170[170] = {-0.9999005327867653,-0.9994759502679309,-0.9987122450379209,-0.9976095066808218,-0.9961680887866318,-0.9943884757499218,-0.9922712700928877,-0.9898171899287147,-0.9870270680979497,-0.9839018516796093,-0.9804426015894565,-0.9766504921847879,-0.9725268108489815,-0.9680729575458271,-0.9632904443395449,-0.9581808948787555,-0.9527460438436466,-0.9469877363560593,-0.9409079273524363,-0.9345086809197071,-0.9277921695942516,-0.9207606736241355,-0.9134165801948330,-0.9057623826186822,-0.8978006794883421,-0.8895341737945135,-0.8809656720082498,-0.8720980831281239,-0.8629344176926086,-0.8534777867579847,-0.8437314008421244,-0.8336985688345152,-0.8233826968728862,-0.8127872871868222,-0.8019159369087507,-0.7907723368527181,-0.7793602702613571,-0.7676836115214742,-0.7557463248487006,-0.7435524629416392,-0.7311061656059746,-0.7184116583490145,-0.7054732509451306,-0.6922953359725927,-0.6788823873222913,-0.6652389586788571,-0.6513696819746849,-0.6372792658173974,-0.6229724938912781,-0.6084542233332111,-0.5937293830836897,-0.5788029722134476,-0.5636800582262640,-0.5483657753385747,-0.5328653227363859,-0.5171839628101698,-0.5013270193682806,-0.4852998758295285,-0.4691079733955128,-0.4527568092033382,-0.4362519344593429,-0.4195989525544666,-0.4028035171619066,-0.3858713303176944,-0.3688081404848682,-0.3516197406018685,-0.3343119661158405,-0.3168906930015073,-0.2993618357662802,-0.2817313454422880,-0.2640052075660079,-0.2461894401461792,-0.2282900916206948,-0.2103132388031639,-0.1922649848198355,-0.1741514570375945,-0.1559788049837253,-0.1377531982581522,-0.1194808244388663,-0.1011678869812464,-0.0828206031119924,-0.0644452017183820,-0.0460479212335694,-0.0276350075186397,-0.0092127117421478,0.0092127117421487,0.0276350075186402,0.0460479212335698,0.0644452017183827,0.0828206031119926,0.1011678869812464,0.1194808244388667,0.1377531982581524,0.1559788049837254,0.1741514570375944,0.1922649848198354,0.2103132388031640,0.2282900916206949,0.2461894401461792,0.2640052075660079,0.2817313454422886,0.2993618357662799,0.3168906930015074,0.3343119661158405,0.3516197406018687,0.3688081404848685,0.3858713303176948,0.4028035171619065,0.4195989525544671,0.4362519344593431,0.4527568092033382,0.4691079733955122,0.4852998758295275,0.5013270193682801,0.5171839628101695,0.5328653227363863,0.5483657753385748,0.5636800582262650,0.5788029722134462,0.5937293830836907,0.6084542233332109,0.6229724938912772,0.6372792658173966,0.6513696819746839,0.6652389586788565,0.6788823873222912,0.6922953359725921,0.7054732509451299,0.7184116583490147,0.7311061656059741,0.7435524629416392,0.7557463248487007,0.7676836115214744,0.7793602702613571,0.7907723368527183,0.8019159369087507,0.8127872871868225,0.8233826968728867,0.8336985688345149,0.8437314008421248,0.8534777867579848,0.8629344176926087,0.8720980831281239,0.8809656720082496,0.8895341737945136,0.8978006794883412,0.9057623826186824,0.9134165801948327,0.9207606736241354,0.9277921695942511,0.9345086809197067,0.9409079273524363,0.9469877363560588,0.9527460438436466,0.9581808948787554,0.9632904443395452,0.9680729575458273,0.9725268108489811,0.9766504921847881,0.9804426015894565,0.9839018516796088,0.9870270680979495,0.9898171899287149,0.9922712700928880,0.9943884757499214,0.9961680887866315,0.9976095066808215,0.9987122450379202,0.9994759502679307,0.9999005327867649};

static const double w171[171] = {0.0001261463703903,0.0002936036596375,0.0004612104723261,0.0006286840719712,0.0007959510423307,0.0009629522262827,0.0011296307827740,0.0012959305093191,0.0014617954938255,0.0016271700300312,0.0017919986012959,0.0019562258857296,0.0021197967689742,0.0022826563599937,0.0024447500081446,0.0026060233208072,0.0027664221812406,0.0029258927665141,0.0030843815654326,0.0032418353964069,0.0033982014252484,0.0035534271828574,0.0037074605828147,0.0038602499388340,0.0040117439821014,0.0041618918784689,0.0043106432455066,0.0044579481694030,0.0046037572217151,0.0047480214759454,0.0048906925239656,0.0050317224922530,0.0051710640579543,0.0053086704647668,0.0054444955386252,0.0055784937031959,0.0057106199951672,0.0058408300793395,0.0059690802635028,0.0060953275130921,0.0062195294656336,0.0063416444449564,0.0064616314751764,0.0065794502944476,0.0066950613684712,0.0068084259037600,0.0069195058606589,0.0070282639661039,0.0071346637261362,0.0072386694381402,0.0073402462028306,0.0074393599359538,0.0075359773797367,0.0076300661140405,0.0077215945672302,0.0078105320267888,0.0078968486496043,0.0079805154719918,0.0080615044194140,0.0081397883158976,0.0082153408931505,0.0082881367993845,0.0083581516078131,0.0084253618248535,0.0084897448980075,0.0085512792234305,0.0086099441531766,0.0086657200021357,0.0087185880546297,0.0087685305706966,0.0088155307920445,0.0088595729476718,0.0089006422591614,0.0089387249456401,0.0089738082283973,0.0090058803351833,0.0090349305041491,0.0090609489874630,0.0090839270545808,0.0091038569951737,0.0091207321217191,0.0091345467717397,0.0091452963097068,0.0091529771285972,0.0091575866510980,0.0091591233304759,0.0091575866510979,0.0091529771285975,0.0091452963097072,0.0091345467717395,0.0091207321217191,0.0091038569951738,0.0090839270545806,0.0090609489874628,0.0090349305041492,0.0090058803351836,0.0089738082283976,0.0089387249456394,0.0089006422591615,0.0088595729476720,0.0088155307920444,0.0087685305706968,0.0087185880546298,0.0086657200021362,0.0086099441531769,0.0085512792234302,0.0084897448980079,0.0084253618248536,0.0083581516078136,0.0082881367993841,0.0082153408931505,0.0081397883158967,0.0080615044194145,0.0079805154719923,0.0078968486496038,0.0078105320267882,0.0077215945672303,0.0076300661140398,0.0075359773797376,0.0074393599359537,0.0073402462028295,0.0072386694381404,0.0071346637261361,0.0070282639661045,0.0069195058606587,0.0068084259037606,0.0066950613684711,0.0065794502944475,0.0064616314751769,0.0063416444449565,0.0062195294656334,0.0060953275130918,0.0059690802635017,0.0058408300793397,0.0057106199951670,0.0055784937031958,0.0054444955386258,0.0053086704647668,0.0051710640579542,0.0050317224922524,0.0048906925239658,0.0047480214759458,0.0046037572217144,0.0044579481694037,0.0043106432455061,0.0041618918784691,0.0040117439821013,0.0038602499388336,0.0037074605828150,0.0035534271828576,0.0033982014252483,0.0032418353964071,0.0030843815654326,0.0029258927665139,0.0027664221812406,0.0026060233208074,0.0024447500081446,0.0022826563599940,0.0021197967689740,0.0019562258857294,0.0017919986012954,0.0016271700300317,0.0014617954938259,0.0012959305093189,0.0011296307827735,0.0009629522262830,0.0007959510423309,0.0006286840719713,0.0004612104723265,0.0002936036596376,0.0001261463703903};
static const double pts171[171] = {-0.9999016893502090,-0.9994820432743188,-0.9987272155859119,-0.9976372918488038,-0.9962126172417284,-0.9944536649087583,-0.9923610234335554,-0.9899353943369106,-0.9871775912287372,-0.9840885393313096,-0.9806692750895500,-0.9769209457886182,-0.9728448091523835,-0.9684422329128783,-0.9637146943467219,-0.9586637797767561,-0.9532911840381744,-0.9475987099088284,-0.9415882675036797,-0.9352618736334476,-0.9286216511275874,-0.9216698281217800,-0.9144087373101500,-0.9068408151624245,-0.8989686011063088,-0.8907947366753242,-0.8823219646224001,-0.8735531279995118,-0.8644911692036659,-0.8551391289895596,-0.8455001454492377,-0.8355774529590893,-0.8253743810945408,-0.8148943535128043,-0.8041408868040594,-0.7931175893114515,-0.7818281599203012,-0.7702763868169383,-0.7584661462175638,-0.7464014010675791,-0.7340861997118122,-0.7215246745360866,-0.7087210405805902,-0.6956795941255149,-0.6824047112494284,-0.6689008463608731,-0.6551725307036835,-0.6412243708365207,-0.6270610470871290,-0.6126873119818466,-0.5981079886508900,-0.5833279692099370,-0.5683522131185816,-0.5531857455161656,-0.5378336555355905,-0.5223010945956524,-0.5065932746724732,-0.4907154665506140,-0.4746729980544506,-0.4584712522604207,-0.4421156656907165,-0.4256117264890546,-0.4089649725791204,-0.3921809898063073,-0.3752654100633788,-0.3582239094006747,-0.3410622061215065,-0.3237860588633700,-0.3064012646656236,-0.2889136570242851,-0.2713291039345905,-0.2536535059219795,-0.2358927940621637,-0.2180529279909454,-0.2001398939044521,-0.1821597025504574,-0.1641183872114662,-0.1460220016802365,-0.1278766182284175,-0.1096883255689934,-0.0914632268132005,-0.0732074374226223,-0.0549270831571344,-0.0366282980193954,-0.0183172221965750,-0.0000000000000002,0.0183172221965746,0.0366282980193954,0.0549270831571343,0.0732074374226228,0.0914632268132005,0.1096883255689937,0.1278766182284179,0.1460220016802366,0.1641183872114661,0.1821597025504576,0.2001398939044516,0.2180529279909455,0.2358927940621640,0.2536535059219793,0.2713291039345906,0.2889136570242851,0.3064012646656236,0.3237860588633699,0.3410622061215064,0.3582239094006747,0.3752654100633785,0.3921809898063081,0.4089649725791204,0.4256117264890547,0.4421156656907162,0.4584712522604213,0.4746729980544515,0.4907154665506139,0.5065932746724741,0.5223010945956524,0.5378336555355900,0.5531857455161650,0.5683522131185819,0.5833279692099376,0.5981079886508891,0.6126873119818462,0.6270610470871282,0.6412243708365205,0.6551725307036840,0.6689008463608727,0.6824047112494277,0.6956795941255155,0.7087210405805904,0.7215246745360864,0.7340861997118125,0.7464014010675791,0.7584661462175643,0.7702763868169381,0.7818281599203012,0.7931175893114509,0.8041408868040594,0.8148943535128041,0.8253743810945408,0.8355774529590894,0.8455001454492376,0.8551391289895598,0.8644911692036659,0.8735531279995121,0.8823219646224010,0.8907947366753245,0.8989686011063094,0.9068408151624250,0.9144087373101500,0.9216698281217802,0.9286216511275868,0.9352618736334473,0.9415882675036789,0.9475987099088277,0.9532911840381741,0.9586637797767563,0.9637146943467214,0.9684422329128782,0.9728448091523837,0.9769209457886185,0.9806692750895492,0.9840885393313090,0.9871775912287371,0.9899353943369105,0.9923610234335550,0.9944536649087583,0.9962126172417283,0.9976372918488041,0.9987272155859127,0.9994820432743190,0.9999016893502088};

static const double w172[172] = {0.0001246880944235,0.0002902100150375,0.0004558808558962,0.0006214217913258,0.0007867608948416,0.0009518403326252,0.0011166045581155,0.0012809986534768,0.0014449679850225,0.0016084581192079,0.0017714148061828,0.0019337839844503,0.0020955117930691,0.0022565445868577,0.0024168289528480,0.0025763117273034,0.0027349400129593,0.0028926611963447,0.0030494229650961,0.0032051733252282,0.0033598606183246,0.0035134335386333,0.0036658411500681,0.0038170329030823,0.0039669586514236,0.0041155686687609,0.0042628136651720,0.0044086448034843,0.0045530137154749,0.0046958725179073,0.0048371738284126,0.0049768707812029,0.0051149170426173,0.0052512668264846,0.0053858749093110,0.0055186966452813,0.0056496879810613,0.0057788054704126,0.0059060062886020,0.0060312482466033,0.0061544898050913,0.0062756900882192,0.0063948088971758,0.0065118067235191,0.0066266447622762,0.0067392849248207,0.0068496898514986,0.0069578229240244,0.0070636482776226,0.0071671308129279,0.0072682362076201,0.0073669309278140,0.0074631822391794,0.0075569582177930,0.0076482277607394,0.0077369605964136,0.0078231272945672,0.0079066992760717,0.0079876488223930,0.0080659490847879,0.0081415740932072,0.0082144987649104,0.0082846989127853,0.0083521512533679,0.0084168334145687,0.0084787239430886,0.0085378023115373,0.0085940489252419,0.0086474451287430,0.0086979732119845,0.0087456164161893,0.0087903589394124,0.0088321859417873,0.0088710835504442,0.0089070388641134,0.0089400399574049,0.0089700758847609,0.0089971366840892,0.0090212133800634,0.0090422979871060,0.0090603835120302,0.0090754639563640,0.0090875343183383,0.0090965905945447,0.0091026297812638,0.0091056498754654,0.0091056498754657,0.0091026297812640,0.0090965905945440,0.0090875343183384,0.0090754639563648,0.0090603835120299,0.0090422979871058,0.0090212133800643,0.0089971366840890,0.0089700758847612,0.0089400399574050,0.0089070388641133,0.0088710835504435,0.0088321859417871,0.0087903589394126,0.0087456164161891,0.0086979732119848,0.0086474451287420,0.0085940489252417,0.0085378023115375,0.0084787239430885,0.0084168334145687,0.0083521512533683,0.0082846989127854,0.0082144987649102,0.0081415740932075,0.0080659490847877,0.0079876488223928,0.0079066992760719,0.0078231272945671,0.0077369605964131,0.0076482277607399,0.0075569582177936,0.0074631822391783,0.0073669309278144,0.0072682362076201,0.0071671308129272,0.0070636482776234,0.0069578229240237,0.0068496898514984,0.0067392849248206,0.0066266447622765,0.0065118067235188,0.0063948088971762,0.0062756900882191,0.0061544898050913,0.0060312482466030,0.0059060062886019,0.0057788054704122,0.0056496879810614,0.0055186966452810,0.0053858749093113,0.0052512668264846,0.0051149170426174,0.0049768707812033,0.0048371738284123,0.0046958725179073,0.0045530137154751,0.0044086448034846,0.0042628136651718,0.0041155686687611,0.0039669586514243,0.0038170329030823,0.0036658411500685,0.0035134335386333,0.0033598606183247,0.0032051733252290,0.0030494229650958,0.0028926611963439,0.0027349400129591,0.0025763117273032,0.0024168289528482,0.0022565445868578,0.0020955117930694,0.0019337839844500,0.0017714148061826,0.0016084581192077,0.0014449679850221,0.0012809986534770,0.0011166045581154,0.0009518403326247,0.0007867608948418,0.0006214217913261,0.0004558808558965,0.0002902100150376,0.0001246880944233};
static const double pts172[172] = {-0.9999028258583741,-0.9994880306352770,-0.9987419266057324,-0.9976645954512458,-0.9962563741836400,-0.9945177250202180,-0.9924492230064592,-0.9900515535469931,-0.9873255115727370,-0.9842720010758462,-0.9808920347315475,-0.9771867335280361,-0.9731573263783051,-0.9688051497041386,-0.9641316469882775,-0.9591383682930240,-0.9538269697445694,-0.9481992129827254,-0.9422569645760227,-0.9360021954022115,-0.9294369799943039,-0.9225634958523208,-0.9153840227209428,-0.9079009418332902,-0.9001167351210607,-0.8920339843912969,-0.8836553704700290,-0.8749836723130962,-0.8660217660844167,-0.8567726242020319,-0.8472393143522194,-0.8374249984720178,-0.8273329317004919,-0.8169664612990847,-0.8063290255414193,-0.7954241525729117,-0.7842554592405796,-0.7728266498934314,-0.7611415151538308,-0.7492039306602528,-0.7370178557818374,-0.7245873323051739,-0.7119164830937502,-0.6990095107205124,-0.6858706960739850,-0.6725043969384162,-0.6589150465484221,-0.6451071521186020,-0.6310852933486195,-0.6168541209042414,-0.6024183548748383,-0.5877827832078609,-0.5729522601208109,-0.5579317044912252,-0.5427260982252239,-0.5273404846051462,-0.5117799666168314,-0.4960497052571008,-0.4801549178219959,-0.4641008761763402,-0.4478929050052133,-0.4315363800478930,-0.4150367263148723,-0.3983994162885330,-0.3816299681080733,-0.3647339437392895,-0.3477169471298282,-0.3305846223505082,-0.3133426517233397,-0.2959967539368504,-0.2785526821493559,-0.2610162220807939,-0.2433931900937610,-0.2256894312643829,-0.2079108174436644,-0.1900632453099558,-0.1721526344131900,-0.1541849252115260,-0.1361660771010658,-0.1181020664392810,-0.0999988845628255,-0.0818625358003694,-0.0636990354811281,-0.0455144079397445,-0.0273146845181801,-0.0091059015652864,0.0091059015652870,0.0273146845181804,0.0455144079397447,0.0636990354811287,0.0818625358003700,0.0999988845628261,0.1181020664392813,0.1361660771010657,0.1541849252115266,0.1721526344131902,0.1900632453099563,0.2079108174436645,0.2256894312643832,0.2433931900937615,0.2610162220807942,0.2785526821493559,0.2959967539368505,0.3133426517233401,0.3305846223505089,0.3477169471298281,0.3647339437392897,0.3816299681080735,0.3983994162885335,0.4150367263148726,0.4315363800478934,0.4478929050052139,0.4641008761763411,0.4801549178219964,0.4960497052571022,0.5117799666168319,0.5273404846051462,0.5427260982252239,0.5579317044912254,0.5729522601208111,0.5877827832078615,0.6024183548748385,0.6168541209042415,0.6310852933486197,0.6451071521186016,0.6589150465484219,0.6725043969384166,0.6858706960739849,0.6990095107205124,0.7119164830937502,0.7245873323051739,0.7370178557818375,0.7492039306602526,0.7611415151538303,0.7728266498934305,0.7842554592405792,0.7954241525729114,0.8063290255414193,0.8169664612990845,0.8273329317004917,0.8374249984720173,0.8472393143522189,0.8567726242020319,0.8660217660844169,0.8749836723130953,0.8836553704700283,0.8920339843912960,0.9001167351210602,0.9079009418332894,0.9153840227209427,0.9225634958523203,0.9294369799943033,0.9360021954022111,0.9422569645760226,0.9481992129827252,0.9538269697445690,0.9591383682930237,0.9641316469882766,0.9688051497041386,0.9731573263783048,0.9771867335280362,0.9808920347315471,0.9842720010758456,0.9873255115727366,0.9900515535469928,0.9924492230064585,0.9945177250202171,0.9962563741836403,0.9976645954512456,0.9987419266057325,0.9994880306352771,0.9999028258583738};

static const double w173[173] = {0.0001232549596969,0.0002868748674823,0.0004506430770728,0.0006142845915566,0.0007777289339365,0.0009409195563544,0.0011038021699642,0.0012663231050560,0.0014284289700296,0.0015900665679476,0.0017511828798740,0.0019117250690717,0.0020716404926675,0.0022308767162775,0.0023893815298771,0.0025471029642320,0.0027039893075424,0.0028599891221839,0.0030150512614314,0.0031691248861509,0.0033221594814141,0.0034741048730255,0.0036249112439513,0.0037745291506359,0.0039229095392029,0.0040700037615313,0.0042157635911956,0.0043601412392803,0.0045030893700401,0.0046445611164171,0.0047845100954115,0.0049228904232776,0.0050596567305762,0.0051947641770395,0.0053281684662826,0.0054598258603150,0.0055896931938873,0.0057177278886417,0.0058438879670696,0.0059681320662775,0.0060904194515463,0.0062107100296823,0.0063289643621717,0.0064451436781021,0.0065592098868789,0.0066711255907091,0.0067808540968694,0.0068883594297281,0.0069936063425472,0.0070965603290318,0.0071971876346532,0.0072954552677013,0.0073913310101135,0.0074847834280335,0.0075757818821186,0.0076642965375772,0.0077502983739657,0.0078337591946877,0.0079146516362472,0.0079929491772192,0.0080686261469423,0.0081416577339360,0.0082120199940404,0.0082796898582553,0.0083446451403159,0.0084068645439580,0.0084663276699061,0.0085230150225571,0.0085769080163742,0.0086279889819818,0.0086762411719545,0.0087216487663119,0.0087641968777025,0.0088038715562884,0.0088406597943134,0.0088745495303726,0.0089055296533650,0.0089335900061358,0.0089587213888065,0.0089809155617940,0.0090001652485085,0.0090164641377400,0.0090298068857286,0.0090401891179161,0.0090476074303801,0.0090520593909509,0.0090535435400045,0.0090520593909500,0.0090476074303801,0.0090401891179160,0.0090298068857280,0.0090164641377399,0.0090001652485090,0.0089809155617944,0.0089587213888069,0.0089335900061354,0.0089055296533646,0.0088745495303724,0.0088406597943136,0.0088038715562880,0.0087641968777033,0.0087216487663118,0.0086762411719547,0.0086279889819818,0.0085769080163741,0.0085230150225571,0.0084663276699061,0.0084068645439582,0.0083446451403153,0.0082796898582556,0.0082120199940402,0.0081416577339364,0.0080686261469420,0.0079929491772185,0.0079146516362472,0.0078337591946877,0.0077502983739658,0.0076642965375784,0.0075757818821182,0.0074847834280343,0.0073913310101134,0.0072954552677003,0.0071971876346525,0.0070965603290323,0.0069936063425471,0.0068883594297277,0.0067808540968693,0.0066711255907099,0.0065592098868791,0.0064451436781019,0.0063289643621715,0.0062107100296825,0.0060904194515460,0.0059681320662780,0.0058438879670699,0.0057177278886417,0.0055896931938876,0.0054598258603149,0.0053281684662826,0.0051947641770402,0.0050596567305760,0.0049228904232776,0.0047845100954113,0.0046445611164177,0.0045030893700395,0.0043601412392800,0.0042157635911957,0.0040700037615309,0.0039229095392036,0.0037745291506359,0.0036249112439514,0.0034741048730257,0.0033221594814142,0.0031691248861509,0.0030150512614308,0.0028599891221844,0.0027039893075423,0.0025471029642315,0.0023893815298772,0.0022308767162764,0.0020716404926673,0.0019117250690714,0.0017511828798743,0.0015900665679475,0.0014284289700290,0.0012663231050561,0.0011038021699644,0.0009409195563544,0.0007777289339369,0.0006142845915565,0.0004506430770734,0.0002868748674825,0.0001232549596964};
static const double pts173[173] = {-0.9999039427722799,-0.9994939147790475,-0.9987563840613605,-0.9976914285512657,-0.9962993773296036,-0.9945806819995334,-0.9925359044549946,-0.9901657144443771,-0.9874708887523703,-0.9844523107462064,-0.9811109700086061,-0.9774479619794967,-0.9734644875806845,-0.9691618528138027,-0.9645414683275992,-0.9596048489528446,-0.9543536132041277,-0.9487894827482516,-0.9429142818391566,-0.9367299367194167,-0.9302384749884299,-0.9234420249374653,-0.9163428148517515,-0.9089431722798142,-0.9012455232703029,-0.8932523915765325,-0.8849663978290101,-0.8763902586762070,-0.8675267858938553,-0.8583788854630603,-0.8489495566175361,-0.8392418908602622,-0.8292590709498969,-0.8190043698572681,-0.8084811496922941,-0.7976928606016721,-0.7866430396377169,-0.7753353095986883,-0.7637733778410264,-0.7519610350638495,-0.7399021540661316,-0.7276006884769688,-0.7150606714593364,-0.7022862143877732,-0.6892815055004268,-0.6760508085258919,-0.6625984612853059,-0.6489288742701467,-0.6350465291962082,-0.6209559775342214,-0.6066618390176077,-0.5921688001278502,-0.5774816125579881,-0.5626050916547138,-0.5475441148396230,-0.5323036200100884,-0.5168886039203340,-0.5013041205431853,-0.4855552794130724,-0.4696472439508274,-0.4535852297707891,-0.4373745029708186,-0.4210203784057520,-0.4045282179448683,-0.3879034287139462,-0.3711514613224849,-0.3542778080766597,-0.3372880011786167,-0.3201876109126804,-0.3029822438190811,-0.2856775408557872,-0.2682791755490657,-0.2507928521333520,-0.2332243036810611,-0.2155792902229371,-0.1978635968595702,-0.1800830318646908,-0.1622434247808647,-0.1443506245082214,-0.1264104973868273,-0.1084289252733469,-0.0904118036126152,-0.0723650395047546,-0.0542945497684722,-0.0362062590011678,-0.0181060976364931,0.0000000000000003,0.0181060976364934,0.0362062590011677,0.0542945497684721,0.0723650395047547,0.0904118036126148,0.1084289252733467,0.1264104973868275,0.1443506245082218,0.1622434247808651,0.1800830318646904,0.1978635968595705,0.2155792902229365,0.2332243036810611,0.2507928521333521,0.2682791755490658,0.2856775408557871,0.3029822438190805,0.3201876109126807,0.3372880011786165,0.3542778080766597,0.3711514613224849,0.3879034287139466,0.4045282179448680,0.4210203784057520,0.4373745029708193,0.4535852297707894,0.4696472439508276,0.4855552794130724,0.5013041205431840,0.5168886039203340,0.5323036200100888,0.5475441148396226,0.5626050916547143,0.5774816125579882,0.5921688001278511,0.6066618390176071,0.6209559775342214,0.6350465291962087,0.6489288742701469,0.6625984612853062,0.6760508085258916,0.6892815055004262,0.7022862143877736,0.7150606714593368,0.7276006884769691,0.7399021540661317,0.7519610350638497,0.7637733778410266,0.7753353095986883,0.7866430396377170,0.7976928606016723,0.8084811496922937,0.8190043698572683,0.8292590709498971,0.8392418908602628,0.8489495566175365,0.8583788854630605,0.8675267858938548,0.8763902586762072,0.8849663978290100,0.8932523915765319,0.9012455232703027,0.9089431722798138,0.9163428148517508,0.9234420249374654,0.9302384749884293,0.9367299367194164,0.9429142818391573,0.9487894827482521,0.9543536132041276,0.9596048489528448,0.9645414683275995,0.9691618528138021,0.9734644875806842,0.9774479619794975,0.9811109700086067,0.9844523107462070,0.9874708887523705,0.9901657144443775,0.9925359044549946,0.9945806819995333,0.9962993773296038,0.9976914285512656,0.9987563840613607,0.9994939147790479,0.9999039427722800};

static const double w174[174] = {0.0001218463915942,0.0002835968802960,0.0004454950381931,0.0006072696173773,0.0007688515514027,0.0009301855422926,0.0010912185233843,0.0012518980378087,0.0014121719009632,0.0015719881176326,0.0017312948651233,0.0018900404970314,0.0020481735543826,0.0022056427797111,0.0023623971323676,0.0025183858043761,0.0026735582365235,0.0028278641345204,0.0029812534851801,0.0031336765725389,0.0032850839939226,0.0034354266759259,0.0035846558902896,0.0037327232696875,0.0038795808233856,0.0040251809527911,0.0041694764668769,0.0043124205974708,0.0044539670144096,0.0045940698405572,0.0047326836666685,0.0048697635661094,0.0050052651094140,0.0051391443786864,0.0052713579818348,0.0054018630666319,0.0055306173346086,0.0056575790547578,0.0057827070770636,0.0059059608458370,0.0060273004128604,0.0061466864503367,0.0062640802636323,0.0063794438038228,0.0064927396800219,0.0066039311715027,0.0067129822395969,0.0068198575393769,0.0069245224311113,0.0070269429914918,0.0071270860246301,0.0072249190728119,0.0073204104270237,0.0074135291372260,0.0075042450223821,0.0075925286802497,0.0076783514968985,0.0077616856559929,0.0078425041478053,0.0079207807779683,0.0079964901759687,0.0080696078033639,0.0081401099617440,0.0082079738004040,0.0082731773237572,0.0083356993984591,0.0083955197602603,0.0084526190205704,0.0085069786727488,0.0085585810980959,0.0086074095715684,0.0086534482671969,0.0086966822632179,0.0087370975469077,0.0087746810191276,0.0088094204985644,0.0088413047256845,0.0088703233663771,0.0088964670153093,0.0089197271989700,0.0089400963784200,0.0089575679517327,0.0089721362561342,0.0089837965698402,0.0089925451135858,0.0089983790518489,0.0090012964937715,0.0090012964937716,0.0089983790518486,0.0089925451135855,0.0089837965698403,0.0089721362561344,0.0089575679517321,0.0089400963784208,0.0089197271989698,0.0088964670153093,0.0088703233663770,0.0088413047256843,0.0088094204985645,0.0087746810191276,0.0087370975469084,0.0086966822632177,0.0086534482671969,0.0086074095715686,0.0085585810980956,0.0085069786727489,0.0084526190205706,0.0083955197602602,0.0083356993984595,0.0082731773237571,0.0082079738004045,0.0081401099617437,0.0080696078033642,0.0079964901759682,0.0079207807779691,0.0078425041478053,0.0077616856559926,0.0076783514968984,0.0075925286802494,0.0075042450223821,0.0074135291372254,0.0073204104270244,0.0072249190728119,0.0071270860246295,0.0070269429914918,0.0069245224311113,0.0068198575393771,0.0067129822395965,0.0066039311715031,0.0064927396800226,0.0063794438038226,0.0062640802636319,0.0061466864503368,0.0060273004128605,0.0059059608458370,0.0057827070770629,0.0056575790547580,0.0055306173346079,0.0054018630666320,0.0052713579818348,0.0051391443786868,0.0050052651094142,0.0048697635661090,0.0047326836666685,0.0045940698405570,0.0044539670144097,0.0043124205974706,0.0041694764668775,0.0040251809527914,0.0038795808233851,0.0037327232696879,0.0035846558902899,0.0034354266759252,0.0032850839939226,0.0031336765725389,0.0029812534851803,0.0028278641345205,0.0026735582365230,0.0025183858043762,0.0023623971323674,0.0022056427797111,0.0020481735543823,0.0018900404970308,0.0017312948651237,0.0015719881176321,0.0014121719009636,0.0012518980378085,0.0010912185233844,0.0009301855422924,0.0007688515514029,0.0006072696173770,0.0004454950381934,0.0002835968802963,0.0001218463915945};
static const double pts174[174] = {-0.9999050405397764,-0.9994996980645078,-0.9987705937464525,-0.9977178018961439,-0.9963416438912862,-0.9946425610228590,-0.9926211024067347,-0.9902779225793318,-0.9876137806937516,-0.9846295400769245,-0.9813261678732410,-0.9777047346976434,-0.9737664142726287,-0.9695124830396121,-0.9649443197407349,-0.9600634049694343,-0.9548713206890247,-0.9493697497190210,-0.9435604751891071,-0.9374453799607977,-0.9310264460169189,-0.9243057538190306,-0.9172854816329968,-0.9099679048228849,-0.9023553951134277,-0.8944504198212622,-0.8862555410552064,-0.8777734148858158,-0.8690067904844943,-0.8599585092324364,-0.8506315037996820,-0.8410287971945909,-0.8311535017840375,-0.8210088182846423,-0.8105980347253721,-0.7999245253818434,-0.7889917496826683,-0.7778032510882050,-0.7663626559420744,-0.7546736722958064,-0.7427400887070140,-0.7305657730114664,-0.7181546710694706,-0.7055108054869637,-0.6926382743117331,-0.6795412497051789,-0.6662239765900628,-0.6526907712746721,-0.6389460200538410,-0.6249941777872957,-0.6108397664557723,-0.5964873736953842,-0.5819416513107050,-0.5672073137670521,-0.5522891366624727,-0.5371919551799014,-0.5219206625200119,-0.5064802083152692,-0.4908755970256819,-0.4751118863167889,-0.4591941854204072,-0.4431276534786539,-0.4269174978718001,-0.4105689725304936,-0.3940873762328830,-0.3774780508872124,-0.3607463798004403,-0.3438977859334333,-0.3269377301433131,-0.3098717094135187,-0.2927052550721593,-0.2754439309992355,-0.2580933318233118,-0.2406590811082211,-0.2231468295303911,-0.2055622530473840,-0.1879110510582436,-0.1701989445562387,-0.1524316742746169,-0.1346149988259518,-0.1167546928357000,-0.0988565450705667,-0.0809263565622880,-0.0629699387274389,-0.0449931114838735,-0.0270017013644115,-0.0090015396283797,0.0090015396283789,0.0270017013644112,0.0449931114838733,0.0629699387274389,0.0809263565622879,0.0988565450705663,0.1167546928356996,0.1346149988259515,0.1524316742746168,0.1701989445562385,0.1879110510582432,0.2055622530473839,0.2231468295303911,0.2406590811082212,0.2580933318233116,0.2754439309992352,0.2927052550721586,0.3098717094135180,0.3269377301433128,0.3438977859334332,0.3607463798004399,0.3774780508872126,0.3940873762328828,0.4105689725304943,0.4269174978718002,0.4431276534786527,0.4591941854204067,0.4751118863167887,0.4908755970256813,0.5064802083152692,0.5219206625200119,0.5371919551799009,0.5522891366624731,0.5672073137670522,0.5819416513107045,0.5964873736953845,0.6108397664557723,0.6249941777872959,0.6389460200538416,0.6526907712746727,0.6662239765900634,0.6795412497051788,0.6926382743117329,0.7055108054869644,0.7181546710694704,0.7305657730114664,0.7427400887070139,0.7546736722958062,0.7663626559420748,0.7778032510882057,0.7889917496826685,0.7999245253818437,0.8105980347253727,0.8210088182846423,0.8311535017840380,0.8410287971945912,0.8506315037996821,0.8599585092324363,0.8690067904844945,0.8777734148858160,0.8862555410552070,0.8944504198212631,0.9023553951134279,0.9099679048228851,0.9172854816329966,0.9243057538190308,0.9310264460169190,0.9374453799607979,0.9435604751891071,0.9493697497190211,0.9548713206890252,0.9600634049694342,0.9649443197407357,0.9695124830396120,0.9737664142726291,0.9777047346976439,0.9813261678732415,0.9846295400769242,0.9876137806937521,0.9902779225793320,0.9926211024067351,0.9946425610228595,0.9963416438912864,0.9977178018961441,0.9987705937464525,0.9994996980645081,0.9999050405397766};

static const double w175[175] = {0.0001204618318230,0.0002803747547605,0.0004404347011367,0.0006003740944927,0.0007601252412825,0.0009196340585406,0.0010788486674620,0.0012377177899182,0.0013961904144010,0.0015542157137004,0.0017117430278628,0.0018687218675376,0.0020251019246288,0.0021808330858343,0.0023358654474213,0.0024901493305360,0.0026436352967462,0.0027962741636679,0.0029480170205910,0.0030988152440741,0.0032486205134737,0.0033973848263941,0.0035450605140476,0.0036916002565132,0.0038369570978883,0.0039810844613300,0.0041239361639725,0.0042654664317223,0.0044056299139224,0.0045443816978846,0.0046816773232753,0.0048174727963631,0.0049517246041153,0.0050843897281395,0.0052154256584658,0.0053447904071725,0.0054724425218333,0.0055983410988064,0.0057224457963371,0.0058447168474834,0.0059651150728636,0.0060836018932041,0.0062001393417067,0.0063146900762105,0.0064272173911583,0.0065376852293604,0.0066460581935448,0.0067523015577034,0.0068563812782147,0.0069582640047561,0.0070579170909896,0.0071553086050227,0.0072504073396367,0.0073431828222919,0.0074336053248907,0.0075216458733006,0.0076072762566397,0.0076904690363169,0.0077711975548247,0.0078494359442793,0.0079251591347118,0.0079983428620972,0.0080689636761341,0.0081369989477573,0.0082024268763875,0.0082652264969153,0.0083253776864278,0.0083828611706427,0.0084376585300989,0.0084897522060467,0.0085391255060818,0.0085857626094900,0.0086296485723191,0.0086707693321666,0.0087091117126846,0.0087446634278030,0.0087774130856672,0.0088073501922859,0.0088344651548944,0.0088587492850321,0.0088801948013220,0.0088987948319643,0.0089145434169425,0.0089274355099279,0.0089374669799009,0.0089446346124713,0.0089489361109103,0.0089503700968881,0.0089489361109101,0.0089446346124708,0.0089374669799001,0.0089274355099277,0.0089145434169425,0.0088987948319648,0.0088801948013216,0.0088587492850325,0.0088344651548945,0.0088073501922853,0.0087774130856671,0.0087446634278041,0.0087091117126851,0.0086707693321668,0.0086296485723191,0.0085857626094896,0.0085391255060810,0.0084897522060464,0.0084376585300990,0.0083828611706426,0.0083253776864276,0.0082652264969162,0.0082024268763868,0.0081369989477574,0.0080689636761345,0.0079983428620969,0.0079251591347115,0.0078494359442797,0.0077711975548249,0.0076904690363166,0.0076072762566393,0.0075216458733007,0.0074336053248909,0.0073431828222923,0.0072504073396362,0.0071553086050220,0.0070579170909904,0.0069582640047563,0.0068563812782141,0.0067523015577030,0.0066460581935451,0.0065376852293607,0.0064272173911583,0.0063146900762099,0.0062001393417070,0.0060836018932039,0.0059651150728636,0.0058447168474838,0.0057224457963365,0.0055983410988068,0.0054724425218329,0.0053447904071723,0.0052154256584666,0.0050843897281386,0.0049517246041153,0.0048174727963627,0.0046816773232753,0.0045443816978849,0.0044056299139228,0.0042654664317217,0.0041239361639723,0.0039810844613297,0.0038369570978884,0.0036916002565136,0.0035450605140475,0.0033973848263944,0.0032486205134738,0.0030988152440741,0.0029480170205914,0.0027962741636681,0.0026436352967461,0.0024901493305359,0.0023358654474210,0.0021808330858343,0.0020251019246288,0.0018687218675383,0.0017117430278628,0.0015542157136999,0.0013961904144009,0.0012377177899180,0.0010788486674622,0.0009196340585409,0.0007601252412828,0.0006003740944922,0.0004404347011369,0.0002803747547605,0.0001204618318231};
static const double pts175[175] = {-0.9999061195959897,-0.9995053827835333,-0.9987845612901400,-0.9977437259280771,-0.9963831905919920,-0.9947033865524120,-0.9927048505079615,-0.9903882222123196,-0.9877542436842314,-0.9848037587751765,-0.9815377128232948,-0.9779571523174042,-0.9740632245458595,-0.9698571772208026,-0.9653403580739314,-0.9605142144221087,-0.9553802927020810,-0.9499402379740197,-0.9441957933937923,-0.9381487996540118,-0.9318011943939569,-0.9251550115785161,-0.9182123808463108,-0.9109755268272073,-0.9034467684294096,-0.8956285180963653,-0.8875232810337070,-0.8791336544064811,-0.8704623265069171,-0.8615120758930019,-0.8522857704981287,-0.8427863667121187,-0.8330169084338925,-0.8229805260961081,-0.8126804356620685,-0.8021199375952247,-0.7913024158016051,-0.7802313365455033,-0.7689102473387814,-0.7573427758041357,-0.7455326285126943,-0.7334835897963188,-0.7211995205349838,-0.7086843569196378,-0.6959421091909220,-0.6829768603541680,-0.6697927648710770,-0.6563940473285035,-0.6427850010847687,-0.6289699868939370,-0.6149534315084939,-0.6007398262608827,-0.5863337256243430,-0.5717397457535193,-0.5569625630053011,-0.5420069124403768,-0.5268775863059743,-0.5115794325002839,-0.4961173530190346,-0.4804963023847534,-0.4647212860591769,-0.4487973588393550,-0.4327296232379373,-0.4165232278481713,-0.4001833656941371,-0.3837152725667407,-0.3671242253460116,-0.3504155403102256,-0.3335945714324066,-0.3166667086647547,-0.2996373762115341,-0.2825120307909977,-0.2652961598868849,-0.2479952799900659,-0.2306149348308882,-0.2131606936027979,-0.1956381491777977,-0.1780529163143204,-0.1604106298580916,-0.1427169429365484,-0.1249775251474085,-0.1071980607419553,-0.0893842468036318,-0.0715417914225215,-0.0536764118662994,-0.0357938327482476,-0.0178997841929130,-0.0000000000000002,0.0178997841929128,0.0357938327482475,0.0536764118662991,0.0715417914225213,0.0893842468036314,0.1071980607419544,0.1249775251474080,0.1427169429365483,0.1604106298580912,0.1780529163143203,0.1956381491777978,0.2131606936027979,0.2306149348308885,0.2479952799900658,0.2652961598868844,0.2825120307909976,0.2996373762115341,0.3166667086647549,0.3335945714324067,0.3504155403102250,0.3671242253460117,0.3837152725667403,0.4001833656941368,0.4165232278481715,0.4327296232379374,0.4487973588393545,0.4647212860591762,0.4804963023847527,0.4961173530190348,0.5115794325002837,0.5268775863059744,0.5420069124403764,0.5569625630053008,0.5717397457535198,0.5863337256243428,0.6007398262608825,0.6149534315084934,0.6289699868939365,0.6427850010847689,0.6563940473285035,0.6697927648710766,0.6829768603541679,0.6959421091909223,0.7086843569196384,0.7211995205349846,0.7334835897963190,0.7455326285126949,0.7573427758041357,0.7689102473387814,0.7802313365455033,0.7913024158016050,0.8021199375952245,0.8126804356620686,0.8229805260961076,0.8330169084338924,0.8427863667121184,0.8522857704981289,0.8615120758930017,0.8704623265069179,0.8791336544064812,0.8875232810337073,0.8956285180963656,0.9034467684294100,0.9109755268272069,0.9182123808463113,0.9251550115785167,0.9318011943939573,0.9381487996540110,0.9441957933937922,0.9499402379740197,0.9553802927020815,0.9605142144221090,0.9653403580739323,0.9698571772208029,0.9740632245458596,0.9779571523174051,0.9815377128232955,0.9848037587751768,0.9877542436842315,0.9903882222123196,0.9927048505079613,0.9947033865524118,0.9963831905919918,0.9977437259280770,0.9987845612901400,0.9995053827835332,0.9999061195959894};

static const double w176[176] = {0.0001191007378600,0.0002772072288347,0.0004354600853092,0.0005935953268587,0.0007515465964126,0.0009092609923212,0.0010666877904502,0.0012237768584686,0.0013804783251850,0.0015367424988117,0.0016925198497469,0.0018477610135263,0.0020024168010019,0.0021564382113692,0.0023097764464261,0.0024623829253600,0.0026142092997636,0.0027652074687417,0.0029153295940177,0.0030645281150140,0.0032127557638652,0.0033599655803635,0.0035061109268119,0.0036511455027868,0.0037950233597969,0.0039376989158262,0.0040791269697818,0.0042192627157976,0.0043580617574354,0.0044954801217454,0.0046314742731937,0.0047660011274569,0.0048990180650692,0.0050304829449230,0.0051603541176206,0.0052885904386713,0.0054151512815181,0.0055399965504163,0.0056630866931343,0.0057843827134798,0.0059038461836592,0.0060214392564491,0.0061371246771862,0.0062508657955718,0.0063626265772826,0.0064723716153846,0.0065800661415525,0.0066856760370825,0.0067891678437056,0.0068905087741824,0.0069896667226936,0.0070866102750088,0.0071813087184420,0.0072737320515834,0.0073638509937950,0.0074516369944933,0.0075370622422007,0.0076200996733427,0.0077007229808328,0.0077789066224012,0.0078546258286893,0.0079278566110971,0.0079985757693800,0.0080667608990025,0.0081323903982370,0.0081954434749979,0.0082559001534458,0.0083137412802978,0.0083689485309083,0.0084215044150693,0.0084713922825519,0.0085185963283808,0.0085631015978432,0.0086048939912255,0.0086439602682800,0.0086802880524201,0.0087138658346403,0.0087446829771651,0.0087727297168150,0.0087979971681032,0.0088204773260485,0.0088401630687128,0.0088570481594562,0.0088711272489136,0.0088823958766871,0.0088908504727659,0.0088964883586470,0.0088993077481936,0.0088993077481933,0.0088964883586474,0.0088908504727660,0.0088823958766883,0.0088711272489134,0.0088570481594565,0.0088401630687124,0.0088204773260484,0.0087979971681030,0.0087727297168152,0.0087446829771650,0.0087138658346406,0.0086802880524205,0.0086439602682801,0.0086048939912259,0.0085631015978434,0.0085185963283808,0.0084713922825517,0.0084215044150691,0.0083689485309088,0.0083137412802980,0.0082559001534458,0.0081954434749981,0.0081323903982362,0.0080667608990029,0.0079985757693794,0.0079278566110970,0.0078546258286891,0.0077789066224014,0.0077007229808329,0.0076200996733431,0.0075370622422005,0.0074516369944938,0.0073638509937938,0.0072737320515833,0.0071813087184433,0.0070866102750080,0.0069896667226940,0.0068905087741823,0.0067891678437058,0.0066856760370831,0.0065800661415519,0.0064723716153850,0.0063626265772827,0.0062508657955716,0.0061371246771868,0.0060214392564490,0.0059038461836589,0.0057843827134802,0.0056630866931342,0.0055399965504168,0.0054151512815176,0.0052885904386715,0.0051603541176212,0.0050304829449231,0.0048990180650691,0.0047660011274569,0.0046314742731938,0.0044954801217449,0.0043580617574356,0.0042192627157976,0.0040791269697813,0.0039376989158262,0.0037950233597963,0.0036511455027870,0.0035061109268121,0.0033599655803635,0.0032127557638647,0.0030645281150143,0.0029153295940182,0.0027652074687415,0.0026142092997632,0.0024623829253598,0.0023097764464263,0.0021564382113694,0.0020024168010020,0.0018477610135270,0.0016925198497468,0.0015367424988115,0.0013804783251852,0.0012237768584679,0.0010666877904505,0.0009092609923208,0.0007515465964134,0.0005935953268588,0.0004354600853089,0.0002772072288340,0.0001191007378603};
static const double pts176[176] = {-0.9999071803637540,-0.9995109711632694,-0.9987982921626093,-0.9977692107945139,-0.9964240336831949,-0.9947631823606194,-0.9927871814568319,-0.9904966563575539,-0.9878923324276785,-0.9849750345891004,-0.9817456869845457,-0.9782053126521064,-0.9743550331854920,-0.9701960683706717,-0.9657297357950524,-0.9609574504275462,-0.9558807241687989,-0.9505011653712779,-0.9448204783291384,-0.9388404627378981,-0.9325630131240160,-0.9259901182445064,-0.9191238604567578,-0.9119664150587290,-0.9045200495997310,-0.8967871231619942,-0.8887700856132573,-0.8804714768305927,-0.8718939258957306,-0.8630401502621239,-0.8539129548940176,-0.8445152313778026,-0.8348499570059202,-0.8249201938336257,-0.8147290877088873,-0.8042798672757505,-0.7935758429514679,-0.7826204058777226,-0.7714170268462792,-0.7599692551993986,-0.7482807177053724,-0.7363551174095233,-0.7241962324610430,-0.7118079149160355,-0.6991940895171477,-0.6863587524501690,-0.6733059700780015,-0.6600398776523948,-0.6465646780038549,-0.6328846402101459,-0.6190040982438044,-0.6049274495990929,-0.5906591538988308,-0.5762037314815369,-0.5615657619693413,-0.5467498828171250,-0.5317607878433159,-0.5166032257428439,-0.5012819985827092,-0.4858019602806364,-0.4701680150673093,-0.4543851159326530,-0.4384582630566882,-0.4223925022254135,-0.4061929232322621,-0.3898646582655895,-0.3734128802827586,-0.3568428013712855,-0.3401596710976054,-0.3233687748439517,-0.3064754321338972,-0.2894849949470745,-0.2724028460236183,-0.2552343971588542,-0.2379850874887939,-0.2206603817669573,-0.2032657686330880,-0.1858067588742957,-0.1682888836791830,-0.1507176928855115,-0.1330987532219564,-0.1154376465445121,-0.0977399680681034,-0.0800113245939663,-0.0622573327333589,-0.0444836171281587,-0.0266958086689239,-0.0088995427109697,0.0088995427109691,0.0266958086689237,0.0444836171281583,0.0622573327333586,0.0800113245939667,0.0977399680681032,0.1154376465445115,0.1330987532219562,0.1507176928855110,0.1682888836791827,0.1858067588742950,0.2032657686330880,0.2206603817669570,0.2379850874887937,0.2552343971588542,0.2724028460236178,0.2894849949470745,0.3064754321338969,0.3233687748439514,0.3401596710976053,0.3568428013712860,0.3734128802827579,0.3898646582655897,0.4061929232322619,0.4223925022254144,0.4384582630566881,0.4543851159326530,0.4701680150673092,0.4858019602806370,0.5012819985827096,0.5166032257428440,0.5317607878433163,0.5467498828171256,0.5615657619693417,0.5762037314815354,0.5906591538988312,0.6049274495990941,0.6190040982438051,0.6328846402101456,0.6465646780038548,0.6600398776523948,0.6733059700780022,0.6863587524501691,0.6991940895171477,0.7118079149160360,0.7241962324610435,0.7363551174095234,0.7482807177053726,0.7599692551993991,0.7714170268462793,0.7826204058777224,0.7935758429514681,0.8042798672757498,0.8147290877088872,0.8249201938336257,0.8348499570059200,0.8445152313778024,0.8539129548940174,0.8630401502621234,0.8718939258957309,0.8804714768305927,0.8887700856132572,0.8967871231619942,0.9045200495997301,0.9119664150587287,0.9191238604567579,0.9259901182445064,0.9325630131240157,0.9388404627378975,0.9448204783291378,0.9505011653712773,0.9558807241687984,0.9609574504275457,0.9657297357950521,0.9701960683706715,0.9743550331854914,0.9782053126521056,0.9817456869845457,0.9849750345890999,0.9878923324276786,0.9904966563575531,0.9927871814568312,0.9947631823606193,0.9964240336831945,0.9977692107945145,0.9987982921626094,0.9995109711632694,0.9999071803637537};

static const double w177[177] = {0.0001177625824200,0.0002740930759135,0.0004305692657037,0.0005869306940484,0.0007431123051098,0.0008990623459730,0.0010547312151102,0.0012100698941258,0.0013650296204742,0.0015195618062828,0.0016736180209901,0.0018271499939186,0.0019801096239893,0.0021324489922756,0.0022841203757504,0.0024350762615765,0.0025852693616178,0.0027346526270434,0.0028831792629380,0.0030308027428801,0.0031774768234703,0.0033231555587792,0.0034677933147253,0.0036113447833494,0.0037537649969989,0.0038950093424110,0.0040350335746752,0.0041737938310953,0.0043112466449260,0.0044473489589825,0.0045820581391321,0.0047153319876478,0.0048471287564200,0.0049774071600402,0.0051061263887306,0.0052332461211276,0.0053587265369098,0.0054825283292760,0.0056046127172543,0.0057249414578514,0.0058434768580326,0.0059601817865277,0.0060750196854629,0.0061879545818128,0.0062989510986700,0.0064079744663239,0.0065149905331544,0.0066199657763297,0.0067228673123076,0.0068236629071348,0.0069223209865462,0.0070188106458528,0.0071131016596262,0.0072051644911624,0.0072949703017421,0.0073824909596490,0.0074676990490018,0.0075505678783278,0.0076310714889274,0.0077091846630105,0.0077848829315895,0.0078581425821477,0.0079289406660675,0.0079972550058178,0.0080630642018992,0.0081263476395539,0.0081870854952169,0.0082452587427263,0.0083008491592866,0.0083538393311761,0.0084042126592000,0.0084519533638897,0.0084970464904487,0.0085394779134356,0.0085792343411877,0.0086163033199861,0.0086506732379569,0.0086823333287089,0.0087112736747039,0.0087374852103653,0.0087609597249186,0.0087816898649615,0.0087996691367674,0.0088148919083232,0.0088273534110875,0.0088370497414892,0.0088439778621499,0.0088481356028308,0.0088495216611191,0.0088481356028311,0.0088439778621497,0.0088370497414898,0.0088273534110869,0.0088148919083232,0.0087996691367673,0.0087816898649615,0.0087609597249186,0.0087374852103653,0.0087112736747041,0.0086823333287097,0.0086506732379573,0.0086163033199868,0.0085792343411878,0.0085394779134354,0.0084970464904491,0.0084519533638894,0.0084042126592004,0.0083538393311763,0.0083008491592863,0.0082452587427259,0.0081870854952171,0.0081263476395541,0.0080630642018995,0.0079972550058177,0.0079289406660678,0.0078581425821479,0.0077848829315891,0.0077091846630107,0.0076310714889274,0.0075505678783276,0.0074676990490019,0.0073824909596496,0.0072949703017417,0.0072051644911636,0.0071131016596256,0.0070188106458523,0.0069223209865459,0.0068236629071346,0.0067228673123071,0.0066199657763297,0.0065149905331542,0.0064079744663238,0.0062989510986699,0.0061879545818134,0.0060750196854629,0.0059601817865272,0.0058434768580328,0.0057249414578520,0.0056046127172541,0.0054825283292757,0.0053587265369101,0.0052332461211273,0.0051061263887309,0.0049774071600406,0.0048471287564198,0.0047153319876476,0.0045820581391326,0.0044473489589826,0.0043112466449257,0.0041737938310958,0.0040350335746752,0.0038950093424114,0.0037537649969992,0.0036113447833488,0.0034677933147251,0.0033231555587794,0.0031774768234701,0.0030308027428801,0.0028831792629375,0.0027346526270435,0.0025852693616173,0.0024350762615767,0.0022841203757506,0.0021324489922756,0.0019801096239901,0.0018271499939185,0.0016736180209898,0.0015195618062829,0.0013650296204744,0.0012100698941256,0.0010547312151099,0.0008990623459729,0.0007431123051099,0.0005869306940486,0.0004305692657044,0.0002740930759128,0.0001177625824205};
static const double pts177[177] = {-0.9999082232540282,-0.9995164653683132,-0.9988117916804545,-0.9977942663580802,-0.9964641889604212,-0.9948219715533254,-0.9928681270352459,-0.9906032668248488,-0.9880281000976037,-0.9851434333734311,-0.9819501701900762,-0.9784493107877514,-0.9746419517803523,-0.9705292858040023,-0.9661126011391282,-0.9613932813044263,-0.9563728046219960,-0.9510527437533411,-0.9454347652061437,-0.9395206288118475,-0.9333121871741344,-0.9268113850884175,-0.9200202589325077,-0.9129409360286280,-0.9055756339769694,-0.8979266599609759,-0.8899964100245844,-0.8817873683216373,-0.8733021063376968,-0.8645432820845175,-0.8555136392674034,-0.8462160064257357,-0.8366532960469247,-0.8268285036540615,-0.8167447068675705,-0.8064050644411355,-0.7958128152722160,-0.7849712773874595,-0.7738838469033265,-0.7625539969622518,-0.7509852766446813,-0.7391813098573206,-0.7271457941979412,-0.7148824997971065,-0.7023952681371776,-0.6896880108489647,-0.6767647084864054,-0.6636294092796576,-0.6502862278669872,-0.6367393440058551,-0.6229930012636056,-0.6090515056881689,-0.5949192244591881,-0.5806005845200011,-0.5661000711908869,-0.5514222267640564,-0.5365716490807589,-0.5215529900910173,-0.5063709543963978,-0.4910302977762919,-0.4755358256981689,-0.4598923918122581,-0.4441048964311389,-0.4281782849947242,-0.4121175465210876,-0.3959277120436602,-0.3796138530352535,-0.3631810798194163,-0.3466345399696286,-0.3299794166968179,-0.3132209272257174,-0.2963643211605672,-0.2794148788406757,-0.2623779096863492,-0.2452587505357124,-0.2280627639729430,-0.2107953366484412,-0.1934618775914567,-0.1760678165157090,-0.1586186021185264,-0.1411197003740395,-0.1235765928209635,-0.1059947748455020,-0.0883797539599161,-0.0707370480772936,-0.0530721837830581,-0.0353906946037670,-0.0176981192737308,-0.0000000000000001,0.0176981192737305,0.0353906946037669,0.0530721837830579,0.0707370480772933,0.0883797539599164,0.1059947748455027,0.1235765928209634,0.1411197003740395,0.1586186021185261,0.1760678165157092,0.1934618775914570,0.2107953366484415,0.2280627639729425,0.2452587505357120,0.2623779096863491,0.2794148788406758,0.2963643211605671,0.3132209272257168,0.3299794166968176,0.3466345399696285,0.3631810798194159,0.3796138530352529,0.3959277120436601,0.4121175465210874,0.4281782849947237,0.4441048964311389,0.4598923918122573,0.4755358256981693,0.4910302977762923,0.5063709543963976,0.5215529900910175,0.5365716490807592,0.5514222267640569,0.5661000711908875,0.5806005845200001,0.5949192244591892,0.6090515056881689,0.6229930012636051,0.6367393440058542,0.6502862278669868,0.6636294092796577,0.6767647084864049,0.6896880108489643,0.7023952681371780,0.7148824997971072,0.7271457941979407,0.7391813098573206,0.7509852766446815,0.7625539969622512,0.7738838469033260,0.7849712773874593,0.7958128152722159,0.8064050644411357,0.8167447068675709,0.8268285036540614,0.8366532960469244,0.8462160064257359,0.8555136392674033,0.8645432820845176,0.8733021063376970,0.8817873683216367,0.8899964100245850,0.8979266599609762,0.9055756339769697,0.9129409360286285,0.9200202589325083,0.9268113850884183,0.9333121871741353,0.9395206288118474,0.9454347652061431,0.9510527437533409,0.9563728046219961,0.9613932813044256,0.9661126011391277,0.9705292858040027,0.9746419517803532,0.9784493107877514,0.9819501701900762,0.9851434333734309,0.9880281000976040,0.9906032668248487,0.9928681270352459,0.9948219715533251,0.9964641889604217,0.9977942663580801,0.9988117916804546,0.9995164653683133,0.9999082232540281};

static const double w178[178] = {0.0001164468529459,0.0002710311036436,0.0004257603710445,0.0005803776487213,0.0007348191479712,0.0008890342331153,0.0010429743942200,0.0011965916960322,0.0013498384540220,0.0015026671537709,0.0016550304334791,0.0018068810861761,0.0019581720689973,0.0021088565152705,0.0022588877477809,0.0024082192925802,0.0025568048930145,0.0027045985238451,0.0028515544053779,0.0029976270175632,0.0031427711140522,0.0032869417361760,0.0034300942268497,0.0035721842443952,0.0037131677762609,0.0038530011526499,0.0039916410600421,0.0041290445546053,0.0042651690754966,0.0043999724580424,0.0045334129467978,0.0046654492084778,0.0047960403447622,0.0049251459049618,0.0050527258985472,0.0051787408075345,0.0053031515987299,0.0054259197358147,0.0055470071912840,0.0056663764582284,0.0057839905619461,0.0058998130713994,0.0060138081104998,0.0061259403692186,0.0062361751145218,0.0063444782011363,0.0064508160821181,0.0065551558192478,0.0066574650932336,0.0067577122137184,0.0068558661291014,0.0069518964361512,0.0070457733894261,0.0071374679104877,0.0072269515969040,0.0073141967310564,0.0073991762887135,0.0074818639474097,0.0075622340945967,0.0076402618355769,0.0077159230012129,0.0077891941554169,0.0078600526024079,0.0079284763937420,0.0079944443351127,0.0080579359929113,0.0081189317005632,0.0081774125646128,0.0082333604705806,0.0082867580885702,0.0083375888786415,0.0083858370959278,0.0084314877955170,0.0084745268370799,0.0085149408892483,0.0085527174337477,0.0085878447692728,0.0086203120151113,0.0086501091145166,0.0086772268378184,0.0087016567852885,0.0087233913897376,0.0087424239188583,0.0087587484773160,0.0087723600085670,0.0087832542964342,0.0087914279664048,0.0087968784866800,0.0087996041689581,0.0087996041689590,0.0087968784866796,0.0087914279664042,0.0087832542964346,0.0087723600085663,0.0087587484773155,0.0087424239188588,0.0087233913897382,0.0087016567852888,0.0086772268378184,0.0086501091145161,0.0086203120151118,0.0085878447692729,0.0085527174337481,0.0085149408892482,0.0084745268370795,0.0084314877955171,0.0083858370959280,0.0083375888786417,0.0082867580885703,0.0082333604705806,0.0081774125646134,0.0081189317005630,0.0080579359929111,0.0079944443351119,0.0079284763937418,0.0078600526024080,0.0077891941554169,0.0077159230012131,0.0076402618355768,0.0075622340945969,0.0074818639474093,0.0073991762887135,0.0073141967310563,0.0072269515969042,0.0071374679104869,0.0070457733894261,0.0069518964361511,0.0068558661291008,0.0067577122137181,0.0066574650932336,0.0065551558192474,0.0064508160821184,0.0063444782011365,0.0062361751145221,0.0061259403692178,0.0060138081104997,0.0058998130713995,0.0057839905619459,0.0056663764582282,0.0055470071912843,0.0054259197358144,0.0053031515987299,0.0051787408075348,0.0050527258985475,0.0049251459049617,0.0047960403447622,0.0046654492084780,0.0045334129467977,0.0043999724580427,0.0042651690754965,0.0041290445546055,0.0039916410600421,0.0038530011526499,0.0037131677762612,0.0035721842443961,0.0034300942268498,0.0032869417361761,0.0031427711140519,0.0029976270175631,0.0028515544053780,0.0027045985238451,0.0025568048930144,0.0024082192925795,0.0022588877477806,0.0021088565152704,0.0019581720689989,0.0018068810861761,0.0016550304334792,0.0015026671537709,0.0013498384540223,0.0011965916960326,0.0010429743942195,0.0008890342331151,0.0007348191479714,0.0005803776487211,0.0004257603710451,0.0002710311036433,0.0001164468529457};
static const double pts178[178] = {-0.9999092486662925,-0.9995218675028079,-0.9988250650118221,-0.9978189022061156,-0.9965036717785100,-0.9948797765920870,-0.9929477181394767,-0.9907080942598435,-0.9881615983882114,-0.9853090191525981,-0.9821512400565798,-0.9786892391736626,-0.9749240888290380,-0.9708569552595796,-0.9664890982483139,-0.9618218707317587,-0.9568567183793800,-0.9515951791448927,-0.9460388827893010,-0.9401895503756962,-0.9340489937359054,-0.9276191149090999,-0.9209019055525122,-0.9138994463244343,-0.9066139062396684,-0.8990475419976254,-0.8912026972832818,-0.8830818020411878,-0.8746873717227792,-0.8660220065071921,-0.8570883904958505,-0.8478892908810512,-0.8384275570888180,-0.8287061198962844,-0.8187279905238811,-0.8084962597026016,-0.7980140967166462,-0.7872847484217301,-0.7763115382393674,-0.7650978651274374,-0.7536472025273536,-0.7419630972881621,-0.7300491685679039,-0.7179091067125731,-0.7055466721130360,-0.6929656940402418,-0.6801700694591070,-0.6671637618214257,-0.6539507998381890,-0.6405352762316874,-0.6269213464677910,-0.6131132274687885,-0.5991151963071923,-0.5849315888809157,-0.5705667985702243,-0.5560252748768844,-0.5413115220459245,-0.5264300976704479,-0.5113856112799110,-0.4961827229123232,-0.4808261416707905,-0.4653206242648775,-0.4496709735372064,-0.4338820369757768,-0.4179587052124527,-0.4019059105080873,-0.3857286252247531,-0.3694318602855473,-0.3530206636224592,-0.3365001186127660,-0.3198753425044585,-0.3031514848311670,-0.2863337258170925,-0.2694272747724274,-0.2524373684797732,-0.2353692695720366,-0.2182282649023336,-0.2010196639063800,-0.1837487969578906,-0.1664210137174940,-0.1490416814756726,-0.1316161834902401,-0.1141499173188743,-0.0966482931472222,-0.0791167321130903,-0.0615606646272473,-0.0439855286913466,-0.0263967682135042,-0.0087998313220480,0.0087998313220481,0.0263967682135044,0.0439855286913465,0.0615606646272476,0.0791167321130903,0.0966482931472217,0.1141499173188732,0.1316161834902396,0.1490416814756722,0.1664210137174943,0.1837487969578907,0.2010196639063803,0.2182282649023333,0.2353692695720362,0.2524373684797724,0.2694272747724276,0.2863337258170923,0.3031514848311668,0.3198753425044585,0.3365001186127663,0.3530206636224594,0.3694318602855478,0.3857286252247528,0.4019059105080873,0.4179587052124522,0.4338820369757767,0.4496709735372065,0.4653206242648783,0.4808261416707909,0.4961827229123228,0.5113856112799118,0.5264300976704481,0.5413115220459239,0.5560252748768836,0.5705667985702243,0.5849315888809153,0.5991151963071920,0.6131132274687878,0.6269213464677911,0.6405352762316870,0.6539507998381885,0.6671637618214259,0.6801700694591072,0.6929656940402420,0.7055466721130359,0.7179091067125735,0.7300491685679045,0.7419630972881632,0.7536472025273543,0.7650978651274375,0.7763115382393677,0.7872847484217299,0.7980140967166460,0.8084962597026017,0.8187279905238813,0.8287061198962847,0.8384275570888182,0.8478892908810512,0.8570883904958505,0.8660220065071917,0.8746873717227786,0.8830818020411876,0.8912026972832808,0.8990475419976254,0.9066139062396678,0.9138994463244341,0.9209019055525116,0.9276191149090999,0.9340489937359051,0.9401895503756961,0.9460388827893003,0.9515951791448928,0.9568567183793804,0.9618218707317588,0.9664890982483140,0.9708569552595789,0.9749240888290380,0.9786892391736622,0.9821512400565797,0.9853090191525982,0.9881615983882120,0.9907080942598442,0.9929477181394781,0.9948797765920879,0.9965036717785111,0.9978189022061164,0.9988250650118228,0.9995218675028090,0.9999092486662928};

static const double w179[179] = {0.0001151530511148,0.0002680201527819,0.0004210315819911,0.0005739337141918,0.0007266639948141,0.0008791728749483,0.0010314129062704,0.0011833372068934,0.0013348991406762,0.0014860522372010,0.0016367501741435,0.0017869467791479,0.0019365960386832,0.0020856521096702,0.0022340693323018,0.0023818022433762,0.0025288055898599,0.0026750343425481,0.0028204437097268,0.0029649891508226,0.0031086263899921,0.0032513114296527,0.0033930005639432,0.0035336503920922,0.0036732178317027,0.0038116601319436,0.0039489348866394,0.0040850000472549,0.0042198139357726,0.0043533352574586,0.0044855231135084,0.0046163370135733,0.0047457368881651,0.0048736831009235,0.0050001364607642,0.0051250582338745,0.0052484101555866,0.0053701544420886,0.0054902538020054,0.0056086714478187,0.0057253711071347,0.0058403170337920,0.0059534740188188,0.0060648074012095,0.0061742830785443,0.0062818675174369,0.0063875277638037,0.0064912314529601,0.0065929468195303,0.0066926427071834,0.0067902885781690,0.0068858545226775,0.0069793112680009,0.0070706301874945,0.0071597833093545,0.0072467433251730,0.0073314835983159,0.0074139781720754,0.0074942017776197,0.0075721298417377,0.0076477384943603,0.0077210045758773,0.0077919056442297,0.0078604199817798,0.0079265266019702,0.0079902052557491,0.0080514364377714,0.0081102013923734,0.0081664821193229,0.0082202613793257,0.0082715226993099,0.0083202503774732,0.0083664294880880,0.0084100458860776,0.0084510862113467,0.0084895378928749,0.0085253891525659,0.0085586290088552,0.0085892472800770,0.0086172345875786,0.0086425823585964,0.0086652828288795,0.0086853290450697,0.0087027148668305,0.0087174349687294,0.0087294848418642,0.0087388607952530,0.0087455599569551,0.0087495802749579,0.0087509205178022,0.0087495802749588,0.0087455599569552,0.0087388607952527,0.0087294848418647,0.0087174349687293,0.0087027148668310,0.0086853290450700,0.0086652828288794,0.0086425823585966,0.0086172345875791,0.0085892472800770,0.0085586290088554,0.0085253891525658,0.0084895378928748,0.0084510862113463,0.0084100458860777,0.0083664294880880,0.0083202503774728,0.0082715226993100,0.0082202613793251,0.0081664821193230,0.0081102013923743,0.0080514364377713,0.0079902052557490,0.0079265266019705,0.0078604199817798,0.0077919056442286,0.0077210045758775,0.0076477384943603,0.0075721298417376,0.0074942017776205,0.0074139781720753,0.0073314835983159,0.0072467433251721,0.0071597833093537,0.0070706301874950,0.0069793112680010,0.0068858545226779,0.0067902885781685,0.0066926427071826,0.0065929468195306,0.0064912314529603,0.0063875277638039,0.0062818675174373,0.0061742830785442,0.0060648074012092,0.0059534740188198,0.0058403170337927,0.0057253711071343,0.0056086714478192,0.0054902538020059,0.0053701544420886,0.0052484101555862,0.0051250582338752,0.0050001364607639,0.0048736831009230,0.0047457368881641,0.0046163370135737,0.0044855231135080,0.0043533352574588,0.0042198139357734,0.0040850000472550,0.0039489348866395,0.0038116601319438,0.0036732178317022,0.0035336503920919,0.0033930005639439,0.0032513114296528,0.0031086263899914,0.0029649891508226,0.0028204437097270,0.0026750343425474,0.0025288055898601,0.0023818022433761,0.0022340693323022,0.0020856521096697,0.0019365960386826,0.0017869467791490,0.0016367501741434,0.0014860522372003,0.0013348991406763,0.0011833372068936,0.0010314129062708,0.0008791728749481,0.0007266639948147,0.0005739337141915,0.0004210315819910,0.0002680201527820,0.0001151530511149};
static const double pts179[179] = {-0.9999102569889313,-0.9995271796124632,-0.9988381171813613,-0.9978431276598475,-0.9965424970662859,-0.9949366193156112,-0.9930259848096081,-0.9908111781826638,-0.9882928775634815,-0.9854718541813797,-0.9823489720577168,-0.9789251877096203,-0.9752015498418880,-0.9711791990179915,-0.9668593673064794,-0.9622433779011585,-0.9573326447143425,-0.9521286719428609,-0.9466330536067387,-0.9408474730605588,-0.9347737024775824,-0.9284136023067469,-0.9217691207026654,-0.9148422929288096,-0.9076352407340238,-0.9001501717025707,-0.8923893785778936,-0.8843552385603008,-0.8760502125787899,-0.8674768445372294,-0.8586377605351230,-0.8495356680632052,-0.8401733551741040,-0.8305536896283299,-0.8206796180158500,-0.8105541648535196,-0.8001804316586368,-0.7895615959989233,-0.7787009105192036,-0.7676017019450847,-0.7562673700639545,-0.7447013866835911,-0.7329072945687176,-0.7208887063558188,-0.7086493034465619,-0.6961928348801439,-0.6835231161849302,-0.6706440282097208,-0.6575595159350153,-0.6442735872646240,-0.6307903117980148,-0.6171138195837579,-0.6032482998544522,-0.5891979997435269,-0.5749672229843065,-0.5605603285917331,-0.5459817295271745,-0.5312358913466780,-0.5163273308331411,-0.5012606146127758,-0.4860403577563100,-0.4706712223653505,-0.4551579161443417,-0.4395051909585488,-0.4237178413785201,-0.4078007032114689,-0.3917586520200211,-0.3755966016287854,-0.3593195026192051,-0.3429323408131519,-0.3264401357457218,-0.3098479391277057,-0.2931608332982095,-0.2763839296678828,-0.2595223671532487,-0.2425813106026103,-0.2255659492140082,-0.2084814949457246,-0.1913331809198115,-0.1741262598191392,-0.1568660022784534,-0.1395576952699311,-0.1222066404837325,-0.1048181527040481,-0.0873975581811305,-0.0699501929998174,-0.0524814014450381,-0.0349965343648167,-0.0175009475312516,0.0000000000000003,0.0175009475312520,0.0349965343648173,0.0524814014450393,0.0699501929998172,0.0873975581811309,0.1048181527040486,0.1222066404837333,0.1395576952699314,0.1568660022784537,0.1741262598191395,0.1913331809198113,0.2084814949457250,0.2255659492140085,0.2425813106026102,0.2595223671532489,0.2763839296678824,0.2931608332982096,0.3098479391277059,0.3264401357457214,0.3429323408131517,0.3593195026192055,0.3755966016287849,0.3917586520200213,0.4078007032114689,0.4237178413785196,0.4395051909585481,0.4551579161443420,0.4706712223653506,0.4860403577563094,0.5012606146127756,0.5163273308331409,0.5312358913466783,0.5459817295271741,0.5605603285917331,0.5749672229843050,0.5891979997435267,0.6032482998544519,0.6171138195837579,0.6307903117980145,0.6442735872646234,0.6575595159350142,0.6706440282097207,0.6835231161849297,0.6961928348801442,0.7086493034465622,0.7208887063558188,0.7329072945687167,0.7447013866835911,0.7562673700639542,0.7676017019450843,0.7787009105192038,0.7895615959989233,0.8001804316586362,0.8105541648535191,0.8206796180158502,0.8305536896283299,0.8401733551741039,0.8495356680632051,0.8586377605351226,0.8674768445372295,0.8760502125787898,0.8843552385603003,0.8923893785778936,0.9001501717025709,0.9076352407340236,0.9148422929288094,0.9217691207026659,0.9284136023067467,0.9347737024775826,0.9408474730605587,0.9466330536067386,0.9521286719428609,0.9573326447143425,0.9622433779011587,0.9668593673064794,0.9711791990179912,0.9752015498418880,0.9789251877096201,0.9823489720577163,0.9854718541813795,0.9882928775634813,0.9908111781826638,0.9930259848096084,0.9949366193156112,0.9965424970662856,0.9978431276598475,0.9988381171813610,0.9995271796124636,0.9999102569889310};

static const double w180[180] = {0.0001138806923722,0.0002650590960977,0.0004163811294214,0.0005675964820920,0.0007186438017225,0.0008694745967032,0.0010200424513218,0.0011703015082492,0.0013202061510882,0.0014697109249245,0.0016187705185848,0.0017673397661807,0.0019153736555664,0.0020628273395384,0.0022096561482026,0.0023558156018627,0.0025012614241451,0.0026459495551993,0.0027898361649240,0.0029328776661691,0.0030750307278938,0.0032162522882528,0.0033564995676316,0.0034957300815811,0.0036339016536822,0.0037709724283175,0.0039069008833401,0.0040416458426506,0.0041751664886703,0.0043074223746982,0.0044383734371668,0.0045679800077776,0.0046962028255121,0.0048230030485266,0.0049483422659204,0.0050721825093680,0.0051944862646199,0.0053152164828693,0.0054343365919729,0.0055518105075288,0.0056676026438089,0.0057816779245367,0.0058940017935147,0.0060045402250912,0.0061132597344675,0.0062201273878412,0.0063251108123803,0.0064281782060372,0.0065292983471726,0.0066284406040197,0.0067255749439601,0.0068206719426247,0.0069137027928040,0.0070046393131747,0.0070934539568379,0.0071801198196664,0.0072646106484432,0.0073469008488327,0.0074269654931143,0.0075047803277500,0.0075803217807199,0.0076535669686688,0.0077244937038352,0.0077930805007763,0.0078593065828702,0.0079231518886159,0.0079845970777085,0.0080436235368950,0.0081002133856153,0.0081543494814199,0.0082060154251591,0.0082551955659544,0.0083018750059368,0.0083460396047612,0.0083876759838900,0.0084267715306442,0.0084633144020251,0.0084972935283036,0.0085286986163695,0.0085575201528532,0.0085837494070053,0.0086073784333439,0.0086284000740568,0.0086468079611756,0.0086625965184997,0.0086757609632891,0.0086862973077121,0.0086942023600504,0.0086994737256713,0.0087021098077489,0.0087021098077490,0.0086994737256717,0.0086942023600508,0.0086862973077119,0.0086757609632895,0.0086625965184996,0.0086468079611753,0.0086284000740567,0.0086073784333443,0.0085837494070055,0.0085575201528530,0.0085286986163696,0.0084972935283032,0.0084633144020257,0.0084267715306438,0.0083876759838902,0.0083460396047618,0.0083018750059367,0.0082551955659538,0.0082060154251584,0.0081543494814191,0.0081002133856154,0.0080436235368950,0.0079845970777085,0.0079231518886160,0.0078593065828697,0.0077930805007762,0.0077244937038355,0.0076535669686687,0.0075803217807197,0.0075047803277504,0.0074269654931147,0.0073469008488322,0.0072646106484437,0.0071801198196655,0.0070934539568384,0.0070046393131744,0.0069137027928037,0.0068206719426246,0.0067255749439599,0.0066284406040192,0.0065292983471729,0.0064281782060374,0.0063251108123812,0.0062201273878407,0.0061132597344676,0.0060045402250913,0.0058940017935150,0.0057816779245364,0.0056676026438087,0.0055518105075291,0.0054343365919723,0.0053152164828698,0.0051944862646200,0.0050721825093677,0.0049483422659210,0.0048230030485267,0.0046962028255121,0.0045679800077781,0.0044383734371678,0.0043074223746980,0.0041751664886698,0.0040416458426506,0.0039069008833398,0.0037709724283172,0.0036339016536827,0.0034957300815807,0.0033564995676314,0.0032162522882530,0.0030750307278936,0.0029328776661699,0.0027898361649239,0.0026459495551991,0.0025012614241456,0.0023558156018624,0.0022096561482019,0.0020628273395386,0.0019153736555668,0.0017673397661802,0.0016187705185847,0.0014697109249249,0.0013202061510885,0.0011703015082491,0.0010200424513217,0.0008694745967029,0.0007186438017229,0.0005675964820919,0.0004163811294210,0.0002650590960976,0.0001138806923722};
static const double pts180[180] = {-0.9999112485995980,-0.9995324036864810,-0.9988509530749690,-0.9978669517831956,-0.9965806793406525,-0.9949925209603508,-0.9931029562578315,-0.9909125570250913,-0.9884219865043542,-0.9856319990032250,-0.9825434395946525,-0.9791572438296718,-0.9754744374390663,-0.9714961360149551,-0.9672235446686770,-0.9626579576633328,-0.9578007580202895,-0.9526534170993433,-0.9472174941524449,-0.9414946358509925,-0.9354865757867636,-0.9291951339465995,-0.9226222161609646,-0.9157698135265382,-0.9086400018030024,-0.9012349407841971,-0.8935568736438309,-0.8856081262559454,-0.8773911064903309,-0.8689083034831072,-0.8601622868826957,-0.8511557060713956,-0.8418912893628173,-0.8323718431754039,-0.8226002511822931,-0.8125794734377767,-0.8023125454806290,-0.7918025774145588,-0.7810527529660880,-0.7700663285201148,-0.7588466321334778,-0.7473970625268050,-0.7357210880549553,-0.7238222456563665,-0.7117041397816343,-0.6993704413016312,-0.6868248863955114,-0.6740712754189295,-0.6611134717528186,-0.6479554006330794,-0.6346010479615289,-0.6210544590984711,-0.6073197376372627,-0.5934010441612266,-0.5793025949833208,-0.5650286608688957,-0.5505835657419985,-0.5359716853755291,-0.5211974460657227,-0.5062653232913137,-0.4911798403578045,-0.4759455670272398,-0.4605671181339241,-0.4450491521864677,-0.4293963699566101,-0.4136135130552461,-0.3977053624960719,-0.3816767372472987,-0.3655324927718722,-0.3492775195566337,-0.3329167416308662,-0.3164551150746940,-0.2998976265177588,-0.2832492916286483,-0.2665151535955305,-0.2497002815984431,-0.2328097692737206,-0.2158487331710032,-0.1988223112033096,-0.1817356610906387,-0.1645939587975688,-0.1474023969653307,-0.1301661833388305,-0.1128905391890953,-0.0955806977316243,-0.0782419025411178,-0.0608794059630701,-0.0434984675227057,-0.0261043523317421,-0.0087023294934561,0.0087023294934558,0.0261043523317418,0.0434984675227053,0.0608794059630696,0.0782419025411174,0.0955806977316245,0.1128905391890952,0.1301661833388299,0.1474023969653302,0.1645939587975684,0.1817356610906385,0.1988223112033090,0.2158487331710022,0.2328097692737196,0.2497002815984424,0.2665151535955298,0.2832492916286483,0.2998976265177585,0.3164551150746939,0.3329167416308662,0.3492775195566327,0.3655324927718726,0.3816767372472982,0.3977053624960714,0.4136135130552461,0.4293963699566102,0.4450491521864671,0.4605671181339245,0.4759455670272394,0.4911798403578033,0.5062653232913139,0.5211974460657228,0.5359716853755291,0.5505835657419991,0.5650286608688964,0.5793025949833199,0.5934010441612273,0.6073197376372628,0.6210544590984717,0.6346010479615294,0.6479554006330795,0.6611134717528181,0.6740712754189289,0.6868248863955115,0.6993704413016312,0.7117041397816340,0.7238222456563669,0.7357210880549547,0.7473970625268053,0.7588466321334778,0.7700663285201140,0.7810527529660877,0.7918025774145598,0.8023125454806292,0.8125794734377776,0.8226002511822936,0.8323718431754044,0.8418912893628174,0.8511557060713958,0.8601622868826962,0.8689083034831081,0.8773911064903309,0.8856081262559454,0.8935568736438305,0.9012349407841970,0.9086400018030024,0.9157698135265382,0.9226222161609646,0.9291951339465999,0.9354865757867640,0.9414946358509928,0.9472174941524453,0.9526534170993439,0.9578007580202896,0.9626579576633334,0.9672235446686771,0.9714961360149548,0.9754744374390663,0.9791572438296727,0.9825434395946527,0.9856319990032255,0.9884219865043550,0.9909125570250922,0.9931029562578318,0.9949925209603512,0.9965806793406523,0.9978669517831963,0.9988509530749695,0.9995324036864816,0.9999112485995987};

static const double w181[181] = {0.0001126293054710,0.0002621468373181,0.0004118072927773,0.0005613636101226,0.0007107556082120,0.0008599358242267,0.0010088588470118,0.0011574798159343,0.0013057541066258,0.0014536372521051,0.0016010849249422,0.0017480529384860,0.0018944972549367,0.0020403739961305,0.0021856394554787,0.0023302501104343,0.0024741626351705,0.0026173339133670,0.0027597210509970,0.0029012813891142,0.0030419725165721,0.0031817522827110,0.0033205788099601,0.0034584105063672,0.0035952060780588,0.0037309245415951,0.0038655252362488,0.0039989678361833,0.0041312123625294,0.0042622191953621,0.0043919490855706,0.0045203631666131,0.0046474229661626,0.0047730904176316,0.0048973278715753,0.0050200981069725,0.0051413643423771,0.0052610902469327,0.0053792399512634,0.0054957780582159,0.0056106696534658,0.0057238803159744,0.0058353761283087,0.0059451236867929,0.0060530901115246,0.0061592430562197,0.0062635507179059,0.0063659818464495,0.0064665057539203,0.0065650923237797,0.0066617120199124,0.0067563358954656,0.0068489356015279,0.0069394833956220,0.0070279521500113,0.0071143153598350,0.0071985471510398,0.0072806222881417,0.0073605161817752,0.0074382048960717,0.0075136651558211,0.0075868743534506,0.0076578105557961,0.0077264525106727,0.0077927796532423,0.0078567721121741,0.0079184107156006,0.0079776769968581,0.0080345532000199,0.0080890222852178,0.0081410679337452,0.0081906745529480,0.0082378272808923,0.0082825119908221,0.0083247152953891,0.0083644245506616,0.0084016278599155,0.0084363140771981,0.0084684728106659,0.0084980944256991,0.0085251700477881,0.0085496915651908,0.0085716516313657,0.0085910436671700,0.0086078618628319,0.0086221011796928,0.0086337573517119,0.0086428268867508,0.0086493070676155,0.0086531959528710,0.0086544923774236,0.0086531959528718,0.0086493070676156,0.0086428268867510,0.0086337573517118,0.0086221011796927,0.0086078618628320,0.0085910436671700,0.0085716516313658,0.0085496915651911,0.0085251700477884,0.0084980944256991,0.0084684728106658,0.0084363140771977,0.0084016278599155,0.0083644245506615,0.0083247152953893,0.0082825119908223,0.0082378272808924,0.0081906745529475,0.0081410679337457,0.0080890222852175,0.0080345532000194,0.0079776769968581,0.0079184107156003,0.0078567721121745,0.0077927796532417,0.0077264525106725,0.0076578105557958,0.0075868743534508,0.0075136651558212,0.0074382048960718,0.0073605161817753,0.0072806222881411,0.0071985471510407,0.0071143153598352,0.0070279521500118,0.0069394833956213,0.0068489356015282,0.0067563358954655,0.0066617120199125,0.0065650923237798,0.0064665057539201,0.0063659818464490,0.0062635507179057,0.0061592430562197,0.0060530901115243,0.0059451236867937,0.0058353761283083,0.0057238803159745,0.0056106696534651,0.0054957780582161,0.0053792399512638,0.0052610902469330,0.0051413643423769,0.0050200981069730,0.0048973278715752,0.0047730904176312,0.0046474229661628,0.0045203631666135,0.0043919490855709,0.0042622191953619,0.0041312123625292,0.0039989678361839,0.0038655252362485,0.0037309245415952,0.0035952060780587,0.0034584105063677,0.0033205788099595,0.0031817522827110,0.0030419725165728,0.0029012813891136,0.0027597210509976,0.0026173339133663,0.0024741626351703,0.0023302501104338,0.0021856394554789,0.0020403739961305,0.0018944972549375,0.0017480529384858,0.0016010849249423,0.0014536372521052,0.0013057541066254,0.0011574798159345,0.0010088588470117,0.0008599358242268,0.0007107556082116,0.0005613636101230,0.0004118072927776,0.0002621468373183,0.0001126293054711};
static const double pts181[181] = {-0.9999122238655762,-0.9995375416594299,-0.9988635774443754,-0.9978903833912587,-0.9966182327201641,-0.9950475021803313,-0.9931786608956750,-0.9910122681663269,-0.9885489727541291,-0.9857895125063586,-0.9827347140639164,-0.9793854925827529,-0.9757428514449120,-0.9718078819503227,-0.9675817629857107,-0.9630657606690404,-0.9582612279687757,-0.9531696042976590,-0.9477924150809107,-0.9421312712988521,-0.9361878690040153,-0.9299639888128449,-0.9234614953721114,-0.9166823368001905,-0.9096285441033517,-0.9023022305672301,-0.8947055911236680,-0.8868409016930914,-0.8787105185026377,-0.8703168773802238,-0.8616624930247732,-0.8527499582528122,-0.8435819432216659,-0.8341611946294858,-0.8244905348923447,-0.8145728612986507,-0.8044111451411290,-0.7940084308266303,-0.7833678349640415,-0.7724925454305582,-0.7613858204166086,-0.7500509874497145,-0.7384914423975772,-0.7267106484506867,-0.7147121350847656,-0.7024994970033539,-0.6900763930608463,-0.6774465451663196,-0.6646137371684608,-0.6515818137219446,-0.6383546791355877,-0.6249362962026367,-0.6113306850135308,-0.5975419217514980,-0.5835741374713542,-0.5694315168618478,-0.5551182969919513,-0.5406387660414483,-0.5259972620162194,-0.5111981714485877,-0.4962459280831341,-0.4811450115483704,-0.4658999460146540,-0.4505152988387735,-0.4349956791955809,-0.4193457366971075,-0.4035701599995597,-0.3876736753986124,-0.3716610454134372,-0.3555370673598686,-0.3393065719131479,-0.3229744216606764,-0.3065455096452005,-0.2900247578988822,-0.2734171159686741,-0.2567275594334601,-0.2399610884133915,-0.2231227260718710,-0.2062175171106365,-0.1892505262583892,-0.1722268367534207,-0.1551515488206993,-0.1380297781438626,-0.1208666543325814,-0.1036673193857479,-0.0864369261509573,-0.0691806367807372,-0.0519036211859852,-0.0346110554870892,-0.0173081204631817,-0.0000000000000006,0.0173081204631813,0.0346110554870889,0.0519036211859847,0.0691806367807364,0.0864369261509568,0.1036673193857472,0.1208666543325808,0.1380297781438627,0.1551515488206994,0.1722268367534204,0.1892505262583887,0.2062175171106366,0.2231227260718710,0.2399610884133921,0.2567275594334607,0.2734171159686744,0.2900247578988818,0.3065455096452008,0.3229744216606762,0.3393065719131478,0.3555370673598683,0.3716610454134373,0.3876736753986120,0.4035701599995586,0.4193457366971070,0.4349956791955801,0.4505152988387728,0.4658999460146536,0.4811450115483704,0.4962459280831347,0.5111981714485877,0.5259972620162207,0.5406387660414494,0.5551182969919517,0.5694315168618488,0.5835741374713551,0.5975419217514994,0.6113306850135309,0.6249362962026374,0.6383546791355884,0.6515818137219449,0.6646137371684607,0.6774465451663189,0.6900763930608458,0.7024994970033532,0.7147121350847663,0.7267106484506864,0.7384914423975776,0.7500509874497149,0.7613858204166085,0.7724925454305585,0.7833678349640419,0.7940084308266305,0.8044111451411290,0.8145728612986511,0.8244905348923445,0.8341611946294857,0.8435819432216665,0.8527499582528123,0.8616624930247734,0.8703168773802235,0.8787105185026375,0.8868409016930912,0.8947055911236680,0.9023022305672302,0.9096285441033517,0.9166823368001908,0.9234614953721119,0.9299639888128448,0.9361878690040156,0.9421312712988522,0.9477924150809108,0.9531696042976592,0.9582612279687763,0.9630657606690407,0.9675817629857104,0.9718078819503227,0.9757428514449124,0.9793854925827531,0.9827347140639160,0.9857895125063580,0.9885489727541290,0.9910122681663270,0.9931786608956752,0.9950475021803317,0.9966182327201644,0.9978903833912584,0.9988635774443756,0.9995375416594297,0.9999122238655761};

static const double w182[182] = {0.0001113984320414,0.0002592823101114,0.0004073083984753,0.0005552328198901,0.0007029965345003,0.0008505530806940,0.0009978580247278,0.0011448674757070,0.0012915377744726,0.0014378254153044,0.0015836870279926,0.0017290793787684,0.0018739593780073,0.0020182840906130,0.0021620107475510,0.0023050967578919,0.0024474997210880,0.0025891774393349,0.0027300879299549,0.0028701894377617,0.0030094404473909,0.0031477996955667,0.0032852261833128,0.0034216791880824,0.0035571182758203,0.0036915033129354,0.0038247944781900,0.0039569522744921,0.0040879375406027,0.0042177114627338,0.0043462355860482,0.0044734718260596,0.0045993824799079,0.0047239302375374,0.0048470781927488,0.0049687898541378,0.0050890291559047,0.0052077604685436,0.0053249486093988,0.0054405588530911,0.0055545569418065,0.0056669090954474,0.0057775820216429,0.0058865429256152,0.0059937595198943,0.0060992000338863,0.0062028332232917,0.0063046283793573,0.0064045553379805,0.0065025844886452,0.0065986867831992,0.0066928337444557,0.0067849974746380,0.0068751506636444,0.0069632665971361,0.0070493191644637,0.0071332828663896,0.0072151328226584,0.0072948447793624,0.0073723951161258,0.0074477608531115,0.0075209196578238,0.0075918498517300,0.0076605304166834,0.0077269410011488,0.0077910619262376,0.0078528741915353,0.0079123594807338,0.0079695001670574,0.0080242793184872,0.0080766807027793,0.0081266887922724,0.0081742887684892,0.0082194665265300,0.0082622086792502,0.0083025025612273,0.0083403362325140,0.0083756984821770,0.0084085788316192,0.0084389675376829,0.0084668555955390,0.0084922347413524,0.0085150974547364,0.0085354369609750,0.0085532472330328,0.0085685229933421,0.0085812597153667,0.0085914536249393,0.0085991017013850,0.0086042016784142,0.0086067520447932,0.0086067520447930,0.0086042016784140,0.0085991017013848,0.0085914536249390,0.0085812597153665,0.0085685229933422,0.0085532472330325,0.0085354369609747,0.0085150974547365,0.0084922347413527,0.0084668555955386,0.0084389675376834,0.0084085788316197,0.0083756984821777,0.0083403362325147,0.0083025025612269,0.0082622086792502,0.0082194665265302,0.0081742887684893,0.0081266887922725,0.0080766807027792,0.0080242793184875,0.0079695001670568,0.0079123594807335,0.0078528741915350,0.0077910619262376,0.0077269410011489,0.0076605304166830,0.0075918498517299,0.0075209196578242,0.0074477608531114,0.0073723951161257,0.0072948447793612,0.0072151328226592,0.0071332828663895,0.0070493191644630,0.0069632665971370,0.0068751506636440,0.0067849974746385,0.0066928337444564,0.0065986867831986,0.0065025844886454,0.0064045553379802,0.0063046283793575,0.0062028332232915,0.0060992000338867,0.0059937595198939,0.0058865429256154,0.0057775820216427,0.0056669090954470,0.0055545569418065,0.0054405588530914,0.0053249486093989,0.0052077604685431,0.0050890291559054,0.0049687898541374,0.0048470781927488,0.0047239302375377,0.0045993824799081,0.0044734718260597,0.0043462355860495,0.0042177114627328,0.0040879375406027,0.0039569522744924,0.0038247944781897,0.0036915033129360,0.0035571182758205,0.0034216791880819,0.0032852261833127,0.0031477996955669,0.0030094404473905,0.0028701894377613,0.0027300879299548,0.0025891774393354,0.0024474997210880,0.0023050967578918,0.0021620107475507,0.0020182840906138,0.0018739593780074,0.0017290793787689,0.0015836870279926,0.0014378254153049,0.0012915377744725,0.0011448674757066,0.0009978580247277,0.0008505530806940,0.0007029965344998,0.0005552328198902,0.0004073083984754,0.0002592823101112,0.0001113984320414};
static const double pts182[182] = {-0.9999131831441103,-0.9995425954130271,-0.9988759949115292,-0.9979134310584552,-0.9966551709380641,-0.9951015830662013,-0.9932531263601765,-0.9911103479673649,-0.9886738825621092,-0.9859444519777339,-0.9829228649226703,-0.9796100167102353,-0.9760068889787186,-0.9721145493929845,-0.9679341513240025,-0.9634669335047428,-0.9587142196617040,-0.9536774181218027,-0.9483580213945034,-0.9427576057291892,-0.9368778306478447,-0.9307204384531348,-0.9242872537120070,-0.9175801827149461,-0.9106012129110425,-0.9033524123190215,-0.8958359289144113,-0.8880539899930270,-0.8800089015109581,-0.8717030474012465,-0.8631388888674658,-0.8543189636544030,-0.8452458852960645,-0.8359223423412250,-0.8263510975567452,-0.8165349871089025,-0.8064769197229709,-0.7961798758212992,-0.7856469066401478,-0.7748811333255367,-0.7638857460083842,-0.7526640028591999,-0.7412192291226174,-0.7295548161320501,-0.7176742203047710,-0.7055809621176943,-0.6932786250641847,-0.6807708545921908,-0.6680613570240197,-0.6551538984580724,-0.6420523036528674,-0.6287604548936836,-0.6152822908421544,-0.6016218053691548,-0.5877830463713356,-0.5737701145716404,-0.5595871623041716,-0.5452383922837722,-0.5307280563606595,-0.5160604542605176,-0.5012399323103940,-0.4862708821507872,-0.4711577394343123,-0.4559049825113172,-0.4405171311028518,-0.4249987449613826,-0.4093544225196319,-0.3935887995279654,-0.3777065476807207,-0.3617123732318832,-0.3456110156005210,-0.3294072459663912,-0.3131058658561404,-0.2967117057205031,-0.2802296235029396,-0.2636645032001199,-0.2470212534146913,-0.2303048059007539,-0.2135201141024730,-0.1966721516862696,-0.1797659110670139,-0.1628064019286650,-0.1457986497397954,-0.1287476942644321,-0.1116585880686714,-0.0945363950234902,-0.0773861888042125,-0.0602130513870696,-0.0430220715433042,-0.0258183433312532,-0.0086069645868705,0.0086069645868713,0.0258183433312539,0.0430220715433052,0.0602130513870703,0.0773861888042130,0.0945363950234912,0.1116585880686722,0.1287476942644329,0.1457986497397957,0.1628064019286654,0.1797659110670144,0.1966721516862697,0.2135201141024734,0.2303048059007536,0.2470212534146914,0.2636645032001195,0.2802296235029393,0.2967117057205031,0.3131058658561405,0.3294072459663914,0.3456110156005207,0.3617123732318827,0.3777065476807202,0.3935887995279648,0.4093544225196316,0.4249987449613831,0.4405171311028517,0.4559049825113161,0.4711577394343121,0.4862708821507876,0.5012399323103937,0.5160604542605177,0.5307280563606597,0.5452383922837722,0.5595871623041719,0.5737701145716397,0.5877830463713349,0.6016218053691550,0.6152822908421540,0.6287604548936834,0.6420523036528669,0.6551538984580724,0.6680613570240200,0.6807708545921913,0.6932786250641849,0.7055809621176946,0.7176742203047709,0.7295548161320503,0.7412192291226170,0.7526640028591998,0.7638857460083845,0.7748811333255371,0.7856469066401481,0.7961798758213002,0.8064769197229711,0.8165349871089028,0.8263510975567452,0.8359223423412251,0.8452458852960638,0.8543189636544027,0.8631388888674654,0.8717030474012465,0.8800089015109578,0.8880539899930266,0.8958359289144107,0.9033524123190210,0.9106012129110423,0.9175801827149463,0.9242872537120069,0.9307204384531352,0.9368778306478447,0.9427576057291893,0.9483580213945032,0.9536774181218028,0.9587142196617039,0.9634669335047430,0.9679341513240022,0.9721145493929836,0.9760068889787188,0.9796100167102356,0.9829228649226697,0.9859444519777346,0.9886738825621090,0.9911103479673649,0.9932531263601768,0.9951015830662010,0.9966551709380638,0.9979134310584546,0.9988759949115291,0.9995425954130266,0.9999131831441100};

static const double w183[183] = {0.0001101876261665,0.0002564644771156,0.0004028828183738,0.0005492018948258,0.0006953637788853,0.0008413229834475,0.0009870360259141,0.0011324599590384,0.0012775520629200,0.0014222697672838,0.0015665706334690,0.0017104123550796,0.0018537527653349,0.0019965498470625,0.0021387617438436,0.0022803467716581,0.0024212634307566,0.0025614704176306,0.0027009266369909,0.0028395912137490,0.0029774235049438,0.0031143831116274,0.0032504298906855,0.0033855239665881,0.0035196257430703,0.0036526959147270,0.0037846954785355,0.0039155857452752,0.0040453283508745,0.0041738852676435,0.0043012188154272,0.0044272916726442,0.0045520668872241,0.0046755078874402,0.0047975784926273,0.0049182429237858,0.0050374658140664,0.0051552122191398,0.0052714476274367,0.0053861379702596,0.0054992496317755,0.0056107494588626,0.0057206047708296,0.0058287833689951,0.0059352535461238,0.0060399840957191,0.0061429443211727,0.0062441040447583,0.0063434336164797,0.0064409039227590,0.0065364863949701,0.0066301530178141,0.0067218763375282,0.0068116294699327,0.0068993861083138,0.0069851205311288,0.0070688076095506,0.0071504228148290,0.0072299422254816,0.0073073425343053,0.0073826010552080,0.0074556957298568,0.0075266051341443,0.0075953084844658,0.0076617856438158,0.0077260171276864,0.0077879841097754,0.0078476684275136,0.0079050525873790,0.0079601197700265,0.0080128538352244,0.0080632393265727,0.0081112614760449,0.0081569062083114,0.0082001601448634,0.0082410106079380,0.0082794456242324,0.0083154539284115,0.0083490249664134,0.0083801488985397,0.0084088166023407,0.0084350196752903,0.0084587504372462,0.0084800019327038,0.0084987679328325,0.0085150429373018,0.0085288221758971,0.0085401016099090,0.0085488779333301,0.0085551485738111,0.0085589116934219,0.0085601661891898,0.0085589116934221,0.0085551485738101,0.0085488779333299,0.0085401016099093,0.0085288221758963,0.0085150429373024,0.0084987679328325,0.0084800019327037,0.0084587504372467,0.0084350196752904,0.0084088166023407,0.0083801488985397,0.0083490249664135,0.0083154539284112,0.0082794456242318,0.0082410106079390,0.0082001601448640,0.0081569062083115,0.0081112614760450,0.0080632393265729,0.0080128538352245,0.0079601197700268,0.0079050525873786,0.0078476684275143,0.0077879841097755,0.0077260171276858,0.0076617856438163,0.0075953084844660,0.0075266051341436,0.0074556957298568,0.0073826010552081,0.0073073425343051,0.0072299422254810,0.0071504228148289,0.0070688076095507,0.0069851205311289,0.0068993861083138,0.0068116294699330,0.0067218763375277,0.0066301530178135,0.0065364863949707,0.0064409039227591,0.0063434336164797,0.0062441040447581,0.0061429443211726,0.0060399840957193,0.0059352535461241,0.0058287833689956,0.0057206047708294,0.0056107494588627,0.0054992496317760,0.0053861379702589,0.0052714476274365,0.0051552122191401,0.0050374658140667,0.0049182429237856,0.0047975784926274,0.0046755078874401,0.0045520668872239,0.0044272916726443,0.0043012188154280,0.0041738852676436,0.0040453283508740,0.0039155857452751,0.0037846954785350,0.0036526959147273,0.0035196257430696,0.0033855239665885,0.0032504298906856,0.0031143831116282,0.0029774235049436,0.0028395912137488,0.0027009266369908,0.0025614704176304,0.0024212634307567,0.0022803467716575,0.0021387617438434,0.0019965498470624,0.0018537527653345,0.0017104123550806,0.0015665706334684,0.0014222697672841,0.0012775520629205,0.0011324599590385,0.0009870360259143,0.0008413229834476,0.0006953637788855,0.0005492018948261,0.0004028828183731,0.0002564644771153,0.0001101876261666};
static const double pts183[183] = {-0.9999141267827396,-0.9995475667778665,-0.9988882099728327,-0.9979361031263703,-0.9966915073548324,-0.9951547831635708,-0.9933263795390755,-0.9912068318040890,-0.9887967609256189,-0.9860968731549711,-0.9831079597515265,-0.9798308967205754,-0.9762666445420989,-0.9724162478818249,-0.9682808352809776,-0.9638616188231895,-0.9591598937778502,-0.9541770382196063,-0.9489145126238977,-0.9433738594385364,-0.9375567026313666,-0.9314647472141201,-0.9250997787425536,-0.9184636627930206,-0.9115583444156116,-0.9043858475640105,-0.8969482745022428,-0.8892478051884742,-0.8812866966360434,-0.8730672822519200,-0.8645919711527618,-0.8558632474588000,-0.8468836695657295,-0.8376558693948374,-0.8281825516215807,-0.8184664928828395,-0.8085105409630794,-0.7983176139596622,-0.7878906994275452,-0.7772328535036291,-0.7663472000109944,-0.7552369295433115,-0.7439052985296696,-0.7323556282801152,-0.7205913040121744,-0.7086157738586406,-0.6964325478569239,-0.6840451969202560,-0.6714573517910541,-0.6586727019767424,-0.6456949946683602,-0.6325280336422527,-0.6191756781451812,-0.6056418417631787,-0.5919304912744701,-0.5780456454868075,-0.5639913740595525,-0.5497717963108619,-0.5353910800103053,-0.5208534401572915,-0.5061631377456483,-0.4913244785147230,-0.4763418116873630,-0.4612195286951590,-0.4459620618913125,-0.4305738832515094,-0.4150595030631733,-0.3994234686035095,-0.3836703628066834,-0.3678048029205646,-0.3518314391534068,-0.3357549533108654,-0.3195800574237606,-0.3033114923669745,-0.2869540264698978,-0.2705124541188277,-0.2539915943517320,-0.2373962894457821,-0.2207314034980798,-0.2040018209999857,-0.1872124454054708,-0.1703681976939098,-0.1534740149277410,-0.1365348488054050,-0.1195556642100009,-0.1025414377540741,-0.0854971563209666,-0.0684278156031587,-0.0513384186380284,-0.0342339743414533,-0.0171194960396977,-0.0000000000000008,0.0171194960396966,0.0342339743414517,0.0513384186380273,0.0684278156031582,0.0854971563209661,0.1025414377540734,0.1195556642100004,0.1365348488054052,0.1534740149277408,0.1703681976939094,0.1872124454054700,0.2040018209999849,0.2207314034980791,0.2373962894457817,0.2539915943517316,0.2705124541188278,0.2869540264698974,0.3033114923669746,0.3195800574237608,0.3357549533108655,0.3518314391534066,0.3678048029205644,0.3836703628066833,0.3994234686035095,0.4150595030631734,0.4305738832515094,0.4459620618913139,0.4612195286951600,0.4763418116873630,0.4913244785147227,0.5061631377456487,0.5208534401572921,0.5353910800103058,0.5497717963108623,0.5639913740595526,0.5780456454868076,0.5919304912744706,0.6056418417631794,0.6191756781451813,0.6325280336422529,0.6456949946683598,0.6586727019767424,0.6714573517910537,0.6840451969202560,0.6964325478569241,0.7086157738586408,0.7205913040121747,0.7323556282801152,0.7439052985296697,0.7552369295433123,0.7663472000109945,0.7772328535036291,0.7878906994275453,0.7983176139596619,0.8085105409630787,0.8184664928828390,0.8281825516215806,0.8376558693948369,0.8468836695657295,0.8558632474587999,0.8645919711527621,0.8730672822519194,0.8812866966360442,0.8892478051884739,0.8969482745022431,0.9043858475640105,0.9115583444156116,0.9184636627930208,0.9250997787425539,0.9314647472141196,0.9375567026313666,0.9433738594385361,0.9489145126238981,0.9541770382196063,0.9591598937778504,0.9638616188231897,0.9682808352809774,0.9724162478818245,0.9762666445420987,0.9798308967205748,0.9831079597515260,0.9860968731549716,0.9887967609256186,0.9912068318040894,0.9933263795390754,0.9951547831635708,0.9966915073548324,0.9979361031263710,0.9988882099728332,0.9995475667778660,0.9999141267827397};

static const double w184[184] = {0.0001089964539809,0.0002536923289947,0.0003985289683007,0.0005432686781854,0.0006878546152172,0.0008322422409549,0.0009763889985210,0.0011202528590677,0.0012637920168311,0.0014069648119925,0.0015497297125900,0.0016920453149083,0.0018338703504782,0.0019751636957108,0.0021158843826558,0.0022559916102663,0.0023954447558882,0.0025342033868413,0.0026722272720223,0.0028094763934997,0.0029459109580715,0.0030814914087637,0.0032161784362911,0.0033499329904336,0.0034827162913498,0.0036144898408146,0.0037452154333768,0.0038748551674323,0.0040033714562111,0.0041307270386695,0.0042568849902990,0.0043818087338243,0.0045054620498098,0.0046278090871621,0.0047488143735196,0.0048684428255400,0.0049866597590730,0.0051034308992110,0.0052187223902302,0.0053325008054086,0.0054447331567092,0.0055553869043532,0.0056644299662482,0.0057718307272933,0.0058775580485427,0.0059815812762354,0.0060838702506838,0.0061843953150129,0.0062831273237662,0.0063800376513489,0.0064750982003324,0.0065682814095976,0.0066595602623275,0.0067489082938391,0.0068362995992556,0.0069217088410243,0.0070051112562435,0.0070864826638709,0.0071657994717095,0.0072430386832583,0.0073181779043800,0.0073911953497913,0.0074620698493818,0.0075307808543470,0.0075973084431519,0.0076616333273034,0.0077237368569430,0.0077836010262562,0.0078412084786903,0.0078965425119851,0.0079495870830228,0.0080003268124706,0.0080487469892465,0.0080948335747776,0.0081385732070791,0.0081799532046199,0.0082189615700054,0.0082555869934527,0.0082898188560703,0.0083216472329375,0.0083510628959821,0.0083780573166549,0.0084026226684026,0.0084247518289379,0.0084444383823044,0.0084616766207338,0.0084764615463069,0.0084887888723957,0.0084986550249121,0.0085060571433392,0.0085109930815653,0.0085134614085020,0.0085134614085016,0.0085109930815656,0.0085060571433390,0.0084986550249119,0.0084887888723958,0.0084764615463069,0.0084616766207338,0.0084444383823040,0.0084247518289383,0.0084026226684022,0.0083780573166551,0.0083510628959823,0.0083216472329378,0.0082898188560701,0.0082555869934528,0.0082189615700054,0.0081799532046201,0.0081385732070789,0.0080948335747776,0.0080487469892461,0.0080003268124709,0.0079495870830225,0.0078965425119851,0.0078412084786901,0.0077836010262563,0.0077237368569435,0.0076616333273032,0.0075973084431517,0.0075307808543467,0.0074620698493818,0.0073911953497918,0.0073181779043801,0.0072430386832581,0.0071657994717092,0.0070864826638717,0.0070051112562440,0.0069217088410224,0.0068362995992566,0.0067489082938386,0.0066595602623268,0.0065682814095982,0.0064750982003321,0.0063800376513487,0.0062831273237656,0.0061843953150129,0.0060838702506835,0.0059815812762361,0.0058775580485421,0.0057718307272931,0.0056644299662485,0.0055553869043533,0.0054447331567092,0.0053325008054082,0.0052187223902308,0.0051034308992109,0.0049866597590733,0.0048684428255400,0.0047488143735191,0.0046278090871625,0.0045054620498107,0.0043818087338240,0.0042568849902995,0.0041307270386695,0.0040033714562110,0.0038748551674328,0.0037452154333771,0.0036144898408147,0.0034827162913496,0.0033499329904339,0.0032161784362911,0.0030814914087636,0.0029459109580709,0.0028094763935000,0.0026722272720222,0.0025342033868404,0.0023954447558884,0.0022559916102666,0.0021158843826555,0.0019751636957106,0.0018338703504781,0.0016920453149082,0.0015497297125899,0.0014069648119926,0.0012637920168312,0.0011202528590670,0.0009763889985208,0.0008322422409558,0.0006878546152176,0.0005432686781853,0.0003985289683009,0.0002536923289946,0.0001089964539810};
static const double pts184[184] = {-0.9999150551196110,-0.9995524575350743,-0.9989002270032141,-0.9979584077113046,-0.9967272549702609,-0.9952071214906554,-0.9933984465950497,-0.9913017540991069,-0.9889176516304228,-0.9862468302763181,-0.9832900643149973,-0.9800482109611436,-0.9765222101030797,-0.9727130840229130,-0.9686219370961368,-0.9642499554691435,-0.9595984067139520,-0.9546686394598490,-0.9494620830018395,-0.9439802468858906,-0.9382247204710263,-0.9321971724683624,-0.9258993504571725,-0.9193330803781296,-0.9125002660038470,-0.9054028883868710,-0.8980430052852760,-0.8904227505660320,-0.8825443335863036,-0.8744100385528804,-0.8660222238598947,-0.8573833214050390,-0.8484958358844761,-0.8393623440666381,-0.8299854940451367,-0.8203680044709892,-0.8105126637643952,-0.8004223293062761,-0.7900999266098311,-0.7795484484723308,-0.7687709541074103,-0.7577705682581030,-0.7465504802908749,-0.7351139432709249,-0.7234642730190142,-0.7116048471501051,-0.6995391040940760,-0.6872705420988150,-0.6748027182159613,-0.6621392472696019,-0.6492838008082169,-0.6362401060401801,-0.6230119447531196,-0.6096031522174562,-0.5960176160744343,-0.5822592752089687,-0.5683321186076375,-0.5542401842021416,-0.5399875576985832,-0.5255783713928837,-0.5110168029726985,-0.4963070743061744,-0.4814534502178871,-0.4664602372523379,-0.4513317824253408,-0.4360724719636914,-0.4206867300334473,-0.4051790174572307,-0.3895538304208832,-0.3738156991698792,-0.3579691866958650,-0.3420188874136977,-0.3259694258293755,-0.3098254551992451,-0.2935916561808735,-0.2772727354759733,-0.2608734244657780,-0.2443984778392635,-0.2278526722146091,-0.2112408047543018,-0.1945676917742859,-0.1778381673475551,-0.1610570819026002,-0.1442293008171159,-0.1273597030073658,-0.1104531795136319,-0.0935146320821413,-0.0765489717438951,-0.0595611173907976,-0.0425559943495163,-0.0255385329534648,-0.0085136671133470,0.0085136671133479,0.0255385329534653,0.0425559943495167,0.0595611173907979,0.0765489717438956,0.0935146320821420,0.1104531795136318,0.1273597030073658,0.1442293008171159,0.1610570819026003,0.1778381673475547,0.1945676917742855,0.2112408047543019,0.2278526722146093,0.2443984778392635,0.2608734244657775,0.2772727354759731,0.2935916561808730,0.3098254551992445,0.3259694258293752,0.3420188874136973,0.3579691866958646,0.3738156991698791,0.3895538304208832,0.4051790174572317,0.4206867300334484,0.4360724719636915,0.4513317824253414,0.4664602372523369,0.4814534502178872,0.4963070743061738,0.5110168029726990,0.5255783713928834,0.5399875576985835,0.5542401842021422,0.5683321186076373,0.5822592752089689,0.5960176160744344,0.6096031522174561,0.6230119447531203,0.6362401060401804,0.6492838008082171,0.6621392472696016,0.6748027182159611,0.6872705420988153,0.6995391040940760,0.7116048471501050,0.7234642730190147,0.7351139432709249,0.7465504802908753,0.7577705682581024,0.7687709541074101,0.7795484484723312,0.7900999266098306,0.8004223293062768,0.8105126637643948,0.8203680044709892,0.8299854940451366,0.8393623440666380,0.8484958358844757,0.8573833214050389,0.8660222238598944,0.8744100385528799,0.8825443335863030,0.8904227505660313,0.8980430052852764,0.9054028883868712,0.9125002660038473,0.9193330803781296,0.9258993504571731,0.9321971724683626,0.9382247204710266,0.9439802468858904,0.9494620830018401,0.9546686394598497,0.9595984067139526,0.9642499554691438,0.9686219370961365,0.9727130840229128,0.9765222101030794,0.9800482109611435,0.9832900643149970,0.9862468302763179,0.9889176516304224,0.9913017540991066,0.9933984465950491,0.9952071214906545,0.9967272549702604,0.9979584077113044,0.9989002270032137,0.9995524575350743,0.9999150551196109};

static const double w185[185] = {0.0001078244932821,0.0002509648835369,0.0003942453066394,0.0005374310711210,0.0006804663904691,0.0008233076498807,0.0009659131935894,0.0011082418867004,0.0012502528132719,0.0013919051997429,0.0015331583967961,0.0016739718794808,0.0018143052538928,0.0019541182664473,0.0020933708142789,0.0022320229561316,0.0023700349234799,0.0025073671317427,0.0026439801915130,0.0027798349197946,0.0029148923511842,0.0030491137490255,0.0031824606164935,0.0033148947076295,0.0034463780382934,0.0035768728970595,0.0037063418560199,0.0038347477815259,0.0039620538448255,0.0040882235326314,0.0042132206575912,0.0043370093686654,0.0044595541614045,0.0045808198881407,0.0047007717680599,0.0048193753971805,0.0049365967582221,0.0050524022303594,0.0051667585988648,0.0052796330646372,0.0053909932536073,0.0055008072260227,0.0056090434856109,0.0057156709886080,0.0058206591526690,0.0059239778656335,0.0060255974941663,0.0061254888922531,0.0062236234095633,0.0063199728996638,0.0064145097280973,0.0065072067803021,0.0065980374693910,0.0066869757437807,0.0067739960946559,0.0068590735632967,0.0069421837482201,0.0070233028122038,0.0071024074890939,0.0071794750905021,0.0072544835123005,0.0073274112409634,0.0073982373597399,0.0074669415546515,0.0075335041203191,0.0075979059656153,0.0076601286191372,0.0077201542345082,0.0077779655954942,0.0078335461209407,0.0078868798695337,0.0079379515443626,0.0079867464973174,0.0080332507332833,0.0080774509141579,0.0081193343626759,0.0081588890660445,0.0081961036793903,0.0082309675290120,0.0082634706154407,0.0082936036163126,0.0083213578890351,0.0083467254732746,0.0083696990932313,0.0083902721597317,0.0084084387721170,0.0084241937199327,0.0084375324844272,0.0084484512398466,0.0084569468545284,0.0084630168918067,0.0084666596107038,0.0084678739664345,0.0084666596107037,0.0084630168918070,0.0084569468545282,0.0084484512398458,0.0084375324844273,0.0084241937199327,0.0084084387721167,0.0083902721597325,0.0083696990932313,0.0083467254732746,0.0083213578890355,0.0082936036163124,0.0082634706154409,0.0082309675290118,0.0081961036793910,0.0081588890660450,0.0081193343626757,0.0080774509141581,0.0080332507332836,0.0079867464973176,0.0079379515443623,0.0078868798695334,0.0078335461209409,0.0077779655954934,0.0077201542345079,0.0076601286191375,0.0075979059656147,0.0075335041203196,0.0074669415546514,0.0073982373597397,0.0073274112409630,0.0072544835123002,0.0071794750905013,0.0071024074890946,0.0070233028122031,0.0069421837482208,0.0068590735632953,0.0067739960946568,0.0066869757437804,0.0065980374693915,0.0065072067803017,0.0064145097280982,0.0063199728996642,0.0062236234095626,0.0061254888922534,0.0060255974941669,0.0059239778656339,0.0058206591526687,0.0057156709886080,0.0056090434856105,0.0055008072260229,0.0053909932536078,0.0052796330646371,0.0051667585988646,0.0050524022303593,0.0049365967582224,0.0048193753971803,0.0047007717680594,0.0045808198881406,0.0044595541614049,0.0043370093686651,0.0042132206575917,0.0040882235326312,0.0039620538448253,0.0038347477815258,0.0037063418560207,0.0035768728970589,0.0034463780382939,0.0033148947076293,0.0031824606164939,0.0030491137490253,0.0029148923511839,0.0027798349197944,0.0026439801915134,0.0025073671317424,0.0023700349234804,0.0022320229561320,0.0020933708142781,0.0019541182664478,0.0018143052538926,0.0016739718794810,0.0015331583967956,0.0013919051997430,0.0012502528132722,0.0011082418867010,0.0009659131935896,0.0008233076498807,0.0006804663904685,0.0005374310711211,0.0003942453066393,0.0002509648835368,0.0001078244932817};
static const double pts185[185] = {-0.9999159684837811,-0.9995572694179058,-0.9989120502600363,-0.9979803527115241,-0.9967624264350701,-0.9952586165552515,-0.9934693529890390,-0.9913951483523946,-0.9890365972896393,-0.9863943761287605,-0.9834692426196944,-0.9802620356873951,-0.9767736751770690,-0.9730051615830777,-0.9689575757580194,-0.9646320786004526,-0.9600299107205830,-0.9551523920835933,-0.9500009216305277,-0.9445769768767022,-0.9388821134876947,-0.9329179648329947,-0.9266862415174174,-0.9201887308903935,-0.9134272965332748,-0.9064038777247857,-0.8991204888847797,-0.8915792189964499,-0.8837822310071570,-0.8757317612080544,-0.8674301185926699,-0.8588796841946484,-0.8500829104048281,-0.8410423202678518,-0.8317605067585176,-0.8222401320380717,-0.8124839266906584,-0.8024946889401438,-0.7922752838475452,-0.7818286424892861,-0.7711577611165170,-0.7602657002957487,-0.7491555840310332,-0.7378305988679533,-0.7262939929796743,-0.7145490752353165,-0.7025992142509242,-0.6904478374232973,-0.6780984299469611,-0.6655545338145622,-0.6528197468009704,-0.6398977214313851,-0.6267921639337360,-0.6135068331756819,-0.6000455395865142,-0.5864121440642649,-0.5726105568683463,-0.5586447364980343,-0.5445186885571009,-0.5302364646049637,-0.5158021609946233,-0.5012199176977812,-0.4864939171174230,-0.4716283828882553,-0.4566275786652974,-0.4414958069010000,-0.4262374076112418,-0.4108567571305541,-0.3953582668569131,-0.3797463819864897,-0.3640255802387055,-0.3482003705719504,-0.3322752918903499,-0.3162549117419412,-0.3001438250086304,-0.2839466525883137,-0.2676680400695360,-0.2513126563990662,-0.2348851925427746,-0.2183903601401950,-0.2018328901531560,-0.1852175315088729,-0.1685490497378825,-0.1518322256072212,-0.1350718537492279,-0.1182727412863751,-0.1014397064525116,-0.0845775772109258,-0.0676911898696115,-0.0507853876941435,-0.0338650195185604,-0.0169349383546423,-0.0000000000000004,0.0169349383546417,0.0338650195185596,0.0507853876941429,0.0676911898696108,0.0845775772109253,0.1014397064525108,0.1182727412863743,0.1350718537492279,0.1518322256072211,0.1685490497378821,0.1852175315088724,0.2018328901531558,0.2183903601401943,0.2348851925427744,0.2513126563990664,0.2676680400695362,0.2839466525883144,0.3001438250086306,0.3162549117419412,0.3322752918903497,0.3482003705719499,0.3640255802387057,0.3797463819864903,0.3953582668569130,0.4108567571305549,0.4262374076112426,0.4414958069009991,0.4566275786652972,0.4716283828882564,0.4864939171174229,0.5012199176977800,0.5158021609946228,0.5302364646049639,0.5445186885571011,0.5586447364980338,0.5726105568683468,0.5864121440642647,0.6000455395865139,0.6135068331756823,0.6267921639337352,0.6398977214313853,0.6528197468009701,0.6655545338145625,0.6780984299469616,0.6904478374232974,0.7025992142509241,0.7145490752353163,0.7262939929796749,0.7378305988679540,0.7491555840310338,0.7602657002957485,0.7711577611165165,0.7818286424892860,0.7922752838475454,0.8024946889401440,0.8124839266906586,0.8222401320380724,0.8317605067585179,0.8410423202678518,0.8500829104048283,0.8588796841946486,0.8674301185926696,0.8757317612080544,0.8837822310071576,0.8915792189964493,0.8991204888847795,0.9064038777247856,0.9134272965332743,0.9201887308903940,0.9266862415174174,0.9329179648329945,0.9388821134876943,0.9445769768767022,0.9500009216305279,0.9551523920835928,0.9600299107205831,0.9646320786004530,0.9689575757580193,0.9730051615830775,0.9767736751770690,0.9802620356873952,0.9834692426196947,0.9863943761287609,0.9890365972896393,0.9913951483523945,0.9934693529890397,0.9952586165552518,0.9967624264350705,0.9979803527115242,0.9989120502600366,0.9995572694179059,0.9999159684837813};

static const double w186[186] = {0.0001066713331535,0.0002482811847853,0.0003900303329608,0.0005316870308276,0.0006731965223933,0.0008145160922652,0.0009556049619588,0.0010964228668621,0.0012369297573082,0.0013770857225698,0.0015168509726736,0.0016561858382805,0.0017950507770438,0.0019334063825537,0.0020712133943714,0.0022084327085769,0.0023450253885215,0.0024809526756956,0.0026161760006014,0.0027506569936288,0.0028843574959006,0.0030172395700673,0.0031492655110527,0.0032803978567408,0.0034105993985954,0.0035398331922103,0.0036680625677917,0.0037952511405543,0.0039213628210465,0.0040463618253907,0.0041702126854283,0.0042928802587916,0.0044143297388678,0.0045345266646787,0.0046534369306565,0.0047710267963203,0.0048872628958513,0.0050021122475608,0.0051155422632441,0.0052275207574316,0.0053380159565200,0.0054469965077869,0.0055544314882880,0.0056602904136302,0.0057645432466229,0.0058671604058003,0.0059681127738144,0.0060673717056971,0.0061649090369903,0.0062606970917328,0.0063547086903190,0.0064469171572061,0.0065372963284857,0.0066258205593078,0.0067124647311568,0.0067972042589773,0.0068800150981546,0.0069608737513323,0.0070397572750808,0.0071166432864108,0.0071915099691201,0.0072643360799868,0.0073351009547936,0.0074037845141963,0.0074703672694173,0.0075348303277753,0.0075971553980500,0.0076573247956676,0.0077153214477214,0.0077711288978135,0.0078247313107319,0.0078761134769311,0.0079252608168589,0.0079721593850877,0.0080167958742741,0.0080591576189325,0.0080992325990296,0.0081370094433972,0.0081724774329552,0.0082056265037566,0.0082364472498401,0.0082649309259001,0.0082910694497712,0.0083148554047142,0.0083362820415288,0.0083553432804650,0.0083720337129442,0.0083863486031022,0.0083982838891265,0.0084078361844115,0.0084150027785190,0.0084197816379466,0.0084221714067057,0.0084221714067055,0.0084197816379468,0.0084150027785188,0.0084078361844110,0.0083982838891267,0.0083863486031025,0.0083720337129444,0.0083553432804648,0.0083362820415295,0.0083148554047144,0.0082910694497707,0.0082649309259005,0.0082364472498393,0.0082056265037564,0.0081724774329552,0.0081370094433968,0.0080992325990297,0.0080591576189323,0.0080167958742748,0.0079721593850877,0.0079252608168586,0.0078761134769315,0.0078247313107314,0.0077711288978144,0.0077153214477207,0.0076573247956679,0.0075971553980504,0.0075348303277758,0.0074703672694169,0.0074037845141964,0.0073351009547935,0.0072643360799866,0.0071915099691204,0.0071166432864108,0.0070397572750804,0.0069608737513321,0.0068800150981551,0.0067972042589773,0.0067124647311564,0.0066258205593080,0.0065372963284861,0.0064469171572061,0.0063547086903189,0.0062606970917335,0.0061649090369909,0.0060673717056973,0.0059681127738145,0.0058671604058003,0.0057645432466230,0.0056602904136300,0.0055544314882882,0.0054469965077873,0.0053380159565198,0.0052275207574316,0.0051155422632440,0.0050021122475609,0.0048872628958517,0.0047710267963201,0.0046534369306564,0.0045345266646784,0.0044143297388679,0.0042928802587912,0.0041702126854283,0.0040463618253900,0.0039213628210465,0.0037952511405542,0.0036680625677919,0.0035398331922105,0.0034105993985950,0.0032803978567409,0.0031492655110530,0.0030172395700673,0.0028843574959003,0.0027506569936290,0.0026161760006011,0.0024809526756958,0.0023450253885215,0.0022084327085763,0.0020712133943718,0.0019334063825534,0.0017950507770444,0.0016561858382803,0.0015168509726737,0.0013770857225698,0.0012369297573086,0.0010964228668622,0.0009556049619588,0.0008145160922654,0.0006731965223930,0.0005316870308277,0.0003900303329605,0.0002482811847853,0.0001066713331537};
static const double pts186[186] = {-0.9999168671955094,-0.9995620041132810,-0.9989236838868776,-0.9980019458142635,-0.9967970340621014,-0.9953092863710935,-0.9935391235027139,-0.9914870471708035,-0.9891536393812040,-0.9865395620943375,-0.9836455569703625,-0.9804724451294564,-0.9770211269048217,-0.9732925815800257,-0.9692878671072120,-0.9650081198046647,-0.9604545540330387,-0.9556284618499589,-0.9505312126428764,-0.9451642527401556,-0.9395291050004547,-0.9336273683804515,-0.9274607174810390,-0.9210309020720746,-0.9143397465958346,-0.9073891496492890,-0.9001810834453490,-0.8927175932532321,-0.8850007968181037,-0.8770328837601604,-0.8688161149533193,-0.8603528218836921,-0.8516454059880252,-0.8426963379722950,-0.8335081571106452,-0.8240834705248714,-0.8144249524446556,-0.8045353434487580,-0.7944174496873806,-0.7840741420859322,-0.7735083555304065,-0.7627230880346166,-0.7517213998895154,-0.7405064127948425,-0.7290813089733552,-0.7174493302678754,-0.7056137772214269,-0.6935780081407170,-0.6813454381432206,-0.6689195381881532,-0.6563038340915944,-0.6435019055260468,-0.6305173850047107,-0.6173539568507719,-0.6040153561519839,-0.5905053677008405,-0.5768278249206628,-0.5629866087778649,-0.5489856466807432,-0.5348289113650839,-0.5205204197669127,-0.5060642318826981,-0.4914644496173372,-0.4767252156202512,-0.4618507121099206,-0.4468451596871910,-0.4317128161376886,-0.4164579752236881,-0.4010849654657627,-0.3855981489145823,-0.3700019199131937,-0.3543007038501343,-0.3384989559037426,-0.3226011597780120,-0.3066118264303503,-0.2905354927916103,-0.2743767204787472,-0.2581400945004693,-0.2418302219562569,-0.2254517307291084,-0.2090092681723910,-0.1925074997911680,-0.1759511079183710,-0.1593447903862035,-0.1426932591931429,-0.1260012391669217,-0.1092734666238712,-0.0925146880250055,-0.0757296586292232,-0.0589231411440182,-0.0420999043740716,-0.0252647218681183,-0.0084223705644630,0.0084223705644619,0.0252647218681176,0.0420999043740715,0.0589231411440173,0.0757296586292231,0.0925146880250055,0.1092734666238712,0.1260012391669217,0.1426932591931433,0.1593447903862037,0.1759511079183707,0.1925074997911680,0.2090092681723908,0.2254517307291083,0.2418302219562566,0.2581400945004696,0.2743767204787468,0.2905354927916105,0.3066118264303498,0.3226011597780116,0.3384989559037423,0.3543007038501345,0.3700019199131935,0.3855981489145819,0.4010849654657622,0.4164579752236878,0.4317128161376891,0.4468451596871904,0.4618507121099198,0.4767252156202508,0.4914644496173368,0.5060642318826978,0.5205204197669127,0.5348289113650828,0.5489856466807429,0.5629866087778654,0.5768278249206638,0.5905053677008412,0.6040153561519830,0.6173539568507720,0.6305173850047102,0.6435019055260464,0.6563038340915948,0.6689195381881535,0.6813454381432201,0.6935780081407168,0.7056137772214274,0.7174493302678753,0.7290813089733550,0.7405064127948429,0.7517213998895155,0.7627230880346171,0.7735083555304069,0.7840741420859320,0.7944174496873803,0.8045353434487573,0.8144249524446558,0.8240834705248713,0.8335081571106451,0.8426963379722949,0.8516454059880255,0.8603528218836916,0.8688161149533192,0.8770328837601605,0.8850007968181037,0.8927175932532322,0.9001810834453489,0.9073891496492887,0.9143397465958346,0.9210309020720747,0.9274607174810390,0.9336273683804523,0.9395291050004548,0.9451642527401567,0.9505312126428767,0.9556284618499590,0.9604545540330384,0.9650081198046649,0.9692878671072122,0.9732925815800257,0.9770211269048217,0.9804724451294567,0.9836455569703630,0.9865395620943376,0.9891536393812045,0.9914870471708040,0.9935391235027143,0.9953092863710936,0.9967970340621024,0.9980019458142633,0.9989236838868771,0.9995620041132811,0.9999168671955097};

static const double w187[187] = {0.0001055365736088,0.0002456403021994,0.0003858825867112,0.0005260345687560,0.0006660424972733,0.0008058645328132,0.0009454607510965,0.0010847917348764,0.0012238182779553,0.0013625013097520,0.0015008018770720,0.0016386811437587,0.0017761003967440,0.0019130210546655,0.0020494046775706,0.0021852129771095,0.0023204078269566,0.0024549512733212,0.0025888055454931,0.0027219330663707,0.0028542964629667,0.0029858585768728,0.0031165824746704,0.0032464314582842,0.0033753690752782,0.0035033591290809,0.0036303656891440,0.0037563531010219,0.0038812859963833,0.0040051293029351,0.0041278482542685,0.0042494083996175,0.0043697756135276,0.0044889161054403,0.0046067964291716,0.0047233834923063,0.0048386445654874,0.0049525472915994,0.0050650596948580,0.0051761501897808,0.0052857875900586,0.0053939411173069,0.0055005804097084,0.0056056755305347,0.0057091969765530,0.0058111156863041,0.0059114030482659,0.0060100309088810,0.0061069715804627,0.0062021978489670,0.0062956829816321,0.0063874007344852,0.0064773253597047,0.0065654316128556,0.0066516947599688,0.0067360905844911,0.0068185953940788,0.0068991860272520,0.0069778398598950,0.0070545348116077,0.0071292493519036,0.0072019625062569,0.0072726538619862,0.0073413035739898,0.0074078923703123,0.0074724015575578,0.0075348130261359,0.0075951092553480,0.0076532733183020,0.0077092888866670,0.0077631402352590,0.0078148122464497,0.0078642904144141,0.0079115608492043,0.0079566102806451,0.0079994260620622,0.0080399961738299,0.0080783092267474,0.0081143544652354,0.0081481217703562,0.0081796016626531,0.0082087853048122,0.0082356645041421,0.0082602317148779,0.0082824800402946,0.0083024032346434,0.0083199957049109,0.0083352525123829,0.0083481693740328,0.0083587426637262,0.0083669694132339,0.0083728473130715,0.0083763747131420,0.0083775506232026,0.0083763747131417,0.0083728473130716,0.0083669694132338,0.0083587426637266,0.0083481693740326,0.0083352525123828,0.0083199957049111,0.0083024032346432,0.0082824800402944,0.0082602317148777,0.0082356645041424,0.0082087853048119,0.0081796016626534,0.0081481217703562,0.0081143544652353,0.0080783092267476,0.0080399961738304,0.0079994260620622,0.0079566102806455,0.0079115608492039,0.0078642904144143,0.0078148122464499,0.0077631402352591,0.0077092888866677,0.0076532733183012,0.0075951092553473,0.0075348130261365,0.0074724015575577,0.0074078923703125,0.0073413035739896,0.0072726538619864,0.0072019625062561,0.0071292493519034,0.0070545348116069,0.0069778398598952,0.0068991860272526,0.0068185953940786,0.0067360905844912,0.0066516947599692,0.0065654316128555,0.0064773253597048,0.0063874007344855,0.0062956829816327,0.0062021978489669,0.0061069715804629,0.0060100309088812,0.0059114030482660,0.0058111156863042,0.0057091969765533,0.0056056755305353,0.0055005804097083,0.0053939411173065,0.0052857875900582,0.0051761501897811,0.0050650596948580,0.0049525472915997,0.0048386445654868,0.0047233834923062,0.0046067964291714,0.0044889161054398,0.0043697756135282,0.0042494083996176,0.0041278482542691,0.0040051293029351,0.0038812859963834,0.0037563531010222,0.0036303656891436,0.0035033591290811,0.0033753690752782,0.0032464314582846,0.0031165824746711,0.0029858585768731,0.0028542964629672,0.0027219330663707,0.0025888055454931,0.0024549512733212,0.0023204078269560,0.0021852129771090,0.0020494046775702,0.0019130210546646,0.0017761003967438,0.0016386811437585,0.0015008018770728,0.0013625013097518,0.0012238182779552,0.0010847917348764,0.0009454607510960,0.0008058645328130,0.0006660424972733,0.0005260345687562,0.0003858825867111,0.0002456403021990,0.0001055365736091};
static const double pts187[187] = {-0.9999177515665378,-0.9995666632632603,-0.9989351319171519,-0.9980231945024455,-0.9968310898370809,-0.9953591484735791,-0.9936077822600867,-0.9915774822964656,-0.9892688182839438,-0.9866824381947353,-0.9838190680238403,-0.9806795115562653,-0.9772646501275307,-0.9735754423691411,-0.9696129239355816,-0.9653782072113691,-0.9608724809974388,-0.9560970101766000,-0.9510531353579184,-0.9457422725000255,-0.9401659125133914,-0.9343256208416186,-0.9282230370218686,-0.9218598742245181,-0.9152379187721649,-0.9083590296381111,-0.9012251379244692,-0.8938382463200174,-0.8862004285379713,-0.8783138287338214,-0.8701806609033909,-0.8618032082612994,-0.8531838225999900,-0.8443249236295065,-0.8352289982982115,-0.8258986000946201,-0.8163363483305610,-0.8065449274058576,-0.7965270860547387,-0.7862856365741872,-0.7758234540344443,-0.7651434754718959,-0.7542486990645614,-0.7431421832904131,-0.7318270460687787,-0.7203064638850448,-0.7085836708989318,-0.6966619580365659,-0.6845446720666230,-0.6722352146607958,-0.6597370414388434,-0.6470536609985011,-0.6341886339305117,-0.6211455718190715,-0.6079281362279467,-0.5945400376725735,-0.5809850345784032,-0.5672669322258092,-0.5533895816818314,-0.5393568787190702,-0.5251727627220339,-0.5108412155812366,-0.4963662605753690,-0.4817519612418460,-0.4670024202360549,-0.4521217781796228,-0.4371142124980217,-0.4219839362478519,-0.4067351969341046,-0.3913722753177736,-0.3758994842141193,-0.3603211672819349,-0.3446416978041594,-0.3288654774601683,-0.3129969350900971,-0.2970405254515372,-0.2810007279689575,-0.2648820454761988,-0.2486890029524021,-0.2324261462517130,-0.2160980408271297,-0.1997092704488509,-0.1832644359174769,-0.1667681537724345,-0.1502250549959783,-0.1336397837131421,-0.1170169958879999,-0.1003613580166001,-0.0836775458169475,-0.0669702429163935,-0.0502441395368059,-0.0335039311778912,-0.0167543172990287,0.0000000000000002,0.0167543172990286,0.0335039311778907,0.0502441395368055,0.0669702429163929,0.0836775458169476,0.1003613580166002,0.1170169958880001,0.1336397837131424,0.1502250549959782,0.1667681537724344,0.1832644359174774,0.1997092704488506,0.2160980408271292,0.2324261462517124,0.2486890029524024,0.2648820454761993,0.2810007279689576,0.2970405254515374,0.3129969350900967,0.3288654774601679,0.3446416978041589,0.3603211672819346,0.3758994842141191,0.3913722753177740,0.4067351969341043,0.4219839362478515,0.4371142124980217,0.4521217781796219,0.4670024202360548,0.4817519612418461,0.4963662605753691,0.5108412155812366,0.5251727627220342,0.5393568787190702,0.5533895816818312,0.5672669322258093,0.5809850345784034,0.5945400376725737,0.6079281362279465,0.6211455718190714,0.6341886339305118,0.6470536609985007,0.6597370414388436,0.6722352146607956,0.6845446720666226,0.6966619580365648,0.7085836708989315,0.7203064638850447,0.7318270460687786,0.7431421832904133,0.7542486990645610,0.7651434754718961,0.7758234540344435,0.7862856365741866,0.7965270860547381,0.8065449274058570,0.8163363483305607,0.8258986000946199,0.8352289982982120,0.8443249236295064,0.8531838225999899,0.8618032082612995,0.8701806609033907,0.8783138287338215,0.8862004285379713,0.8938382463200166,0.9012251379244692,0.9083590296381113,0.9152379187721644,0.9218598742245184,0.9282230370218684,0.9343256208416181,0.9401659125133915,0.9457422725000260,0.9510531353579187,0.9560970101766005,0.9608724809974394,0.9653782072113696,0.9696129239355824,0.9735754423691412,0.9772646501275314,0.9806795115562650,0.9838190680238404,0.9866824381947363,0.9892688182839439,0.9915774822964655,0.9936077822600867,0.9953591484735798,0.9968310898370806,0.9980231945024459,0.9989351319171520,0.9995666632632600,0.9999177515665381};

static const double w188[188] = {0.0001044198252419,0.0002430413298470,0.0003818006459486,0.0005204717488950,0.0006590018677496,0.0007973500162779,0.0009354771020498,0.0010733445329879,0.0012109139242756,0.0013481470235022,0.0014850056923935,0.0016214519062446,0.0017574477596794,0.0018929554749547,0.0020279374113320,0.0021623560749470,0.0022961741288992,0.0024293544034298,0.0025618599061370,0.0026936538321810,0.0028246995744630,0.0029549607337599,0.0030844011288242,0.0032129848064101,0.0033406760512611,0.0034674393960154,0.0035932396310597,0.0037180418142991,0.0038418112808670,0.0039645136527459,0.0040861148483181,0.0042065810918312,0.0043258789227765,0.0044439752051853,0.0045608371368305,0.0046764322583362,0.0047907284621968,0.0049036940016916,0.0050152974997049,0.0051255079574381,0.0052342947630225,0.0053416277000233,0.0054474769558253,0.0055518131299223,0.0056546072420789,0.0057558307403784,0.0058554555091567,0.0059534538768106,0.0060497986234829,0.0061444629886222,0.0062374206784191,0.0063286458731067,0.0064181132341321,0.0065057979111970,0.0065916755491568,0.0066757222947890,0.0067579148034119,0.0068382302453818,0.0069166463124163,0.0069931412238076,0.0070676937324601,0.0071402831308006,0.0072108892565210,0.0072794924981894,0.0073460738006857,0.0074106146705054,0.0074730971808865,0.0075335039767969,0.0075918182797497,0.0076480238924647,0.0077021052033694,0.0077540471909325,0.0078038354278370,0.0078514560849903,0.0078968959353608,0.0079401423576541,0.0079811833398194,0.0080200074823851,0.0080566040016243,0.0080909627325527,0.0081230741317471,0.0081529292800023,0.0081805198848035,0.0082058382826334,0.0082288774410965,0.0082496309608771,0.0082680930775133,0.0082842586629995,0.0082981232272115,0.0083096829191505,0.0083189345280185,0.0083258754841030,0.0083305038594977,0.0083328183686314,0.0083328183686314,0.0083305038594975,0.0083258754841030,0.0083189345280181,0.0083096829191511,0.0082981232272109,0.0082842586629996,0.0082680930775133,0.0082496309608769,0.0082288774410969,0.0082058382826332,0.0081805198848037,0.0081529292800023,0.0081230741317470,0.0080909627325527,0.0080566040016245,0.0080200074823847,0.0079811833398192,0.0079401423576540,0.0078968959353609,0.0078514560849903,0.0078038354278374,0.0077540471909326,0.0077021052033687,0.0076480238924646,0.0075918182797491,0.0075335039767968,0.0074730971808866,0.0074106146705053,0.0073460738006859,0.0072794924981896,0.0072108892565218,0.0071402831308001,0.0070676937324602,0.0069931412238077,0.0069166463124165,0.0068382302453807,0.0067579148034130,0.0066757222947884,0.0065916755491565,0.0065057979111976,0.0064181132341329,0.0063286458731071,0.0062374206784192,0.0061444629886222,0.0060497986234826,0.0059534538768106,0.0058554555091569,0.0057558307403780,0.0056546072420787,0.0055518131299227,0.0054474769558244,0.0053416277000224,0.0052342947630229,0.0051255079574380,0.0050152974997051,0.0049036940016916,0.0047907284621963,0.0046764322583365,0.0045608371368301,0.0044439752051857,0.0043258789227765,0.0042065810918310,0.0040861148483182,0.0039645136527460,0.0038418112808669,0.0037180418142997,0.0035932396310596,0.0034674393960158,0.0033406760512609,0.0032129848064103,0.0030844011288240,0.0029549607337602,0.0028246995744624,0.0026936538321814,0.0025618599061370,0.0024293544034294,0.0022961741288991,0.0021623560749474,0.0020279374113320,0.0018929554749548,0.0017574477596801,0.0016214519062441,0.0014850056923939,0.0013481470235014,0.0012109139242760,0.0010733445329883,0.0009354771020496,0.0007973500162771,0.0006590018677500,0.0005204717488950,0.0003818006459485,0.0002430413298471,0.0001044198252418};
static const double pts188[188] = {-0.9999186219003618,-0.9995712484664708,-0.9989463982776120,-0.9980441060611693,-0.9968646054289905,-0.9954082199349372,-0.9936753527483435,-0.9916664846341506,-0.9893821733123165,-0.9868230531342534,-0.9839898348410414,-0.9808833053373512,-0.9775043274591734,-0.9738538397271161,-0.9699328560818832,-0.9657424656004500,-0.9612838321922506,-0.9565581942750764,-0.9515668644305826,-0.9463112290393652,-0.9407927478956525,-0.9350129538016810,-0.9289734521418350,-0.9226759204366595,-0.9161221078768600,-0.9093138348374078,-0.9022529923718834,-0.8949415416871996,-0.8873815135988421,-0.8795750079667780,-0.8715241931121933,-0.8632313052152166,-0.8546986476937923,-0.8459285905638846,-0.8369235697811797,-0.8276860865644760,-0.8182187067009499,-0.8085240598334797,-0.7986048387302440,-0.7884637985367788,-0.7781037560107126,-0.7675275887393848,-0.7567382343405776,-0.7457386896465604,-0.7345320098717001,-0.7231213077638446,-0.7115097527397357,-0.6997005700046729,-0.6876970396566880,-0.6755024957754699,-0.6631203254962956,-0.6505539680692269,-0.6378069139038279,-0.6248827035996756,-0.6117849269629299,-0.5985172220092346,-0.5850832739532268,-0.5714868141849411,-0.5577316192333821,-0.5438215097175636,-0.5297603492853005,-0.5155520435400478,-0.5012005389560871,-0.4867098217823602,-0.4720839169352584,-0.4573268868806628,-0.4424428305055689,-0.4274358819795770,-0.4123102096066021,-0.3970700146670871,-0.3817195302510629,-0.3662630200823762,-0.3507047773344004,-0.3350491234375740,-0.3193004068790882,-0.3034630019950556,-0.2875413077555045,-0.2715397465425279,-0.2554627629219314,-0.2393148224087167,-0.2231004102267490,-0.2068240300629481,-0.1904902028163533,-0.1741034653424063,-0.1576683691928003,-0.1411894793512499,-0.1246713729655315,-0.1081186380761393,-0.0915358723419202,-0.0749276817630365,-0.0582986794016125,-0.0416534841004153,-0.0249967191999352,-0.0083330112542151,0.0083330112542147,0.0249967191999344,0.0416534841004150,0.0582986794016125,0.0749276817630367,0.0915358723419201,0.1081186380761391,0.1246713729655316,0.1411894793512501,0.1576683691927999,0.1741034653424063,0.1904902028163541,0.2068240300629489,0.2231004102267495,0.2393148224087172,0.2554627629219318,0.2715397465425281,0.2875413077555049,0.3034630019950560,0.3193004068790884,0.3350491234375743,0.3507047773344005,0.3662630200823760,0.3817195302510624,0.3970700146670862,0.4123102096066019,0.4274358819795767,0.4424428305055685,0.4573268868806631,0.4720839169352584,0.4867098217823604,0.5012005389560870,0.5155520435400476,0.5297603492853004,0.5438215097175636,0.5577316192333820,0.5714868141849415,0.5850832739532270,0.5985172220092352,0.6117849269629305,0.6248827035996755,0.6378069139038276,0.6505539680692257,0.6631203254962954,0.6755024957754692,0.6876970396566877,0.6997005700046725,0.7115097527397356,0.7231213077638449,0.7345320098716998,0.7457386896465603,0.7567382343405774,0.7675275887393853,0.7781037560107127,0.7884637985367797,0.7986048387302440,0.8085240598334799,0.8182187067009498,0.8276860865644762,0.8369235697811799,0.8459285905638846,0.8546986476937924,0.8632313052152168,0.8715241931121934,0.8795750079667770,0.8873815135988424,0.8949415416871996,0.9022529923718831,0.9093138348374078,0.9161221078768597,0.9226759204366596,0.9289734521418345,0.9350129538016810,0.9407927478956524,0.9463112290393652,0.9515668644305822,0.9565581942750759,0.9612838321922497,0.9657424656004500,0.9699328560818826,0.9738538397271160,0.9775043274591736,0.9808833053373514,0.9839898348410413,0.9868230531342531,0.9893821733123167,0.9916664846341507,0.9936753527483434,0.9954082199349379,0.9968646054289901,0.9980441060611688,0.9989463982776119,0.9995712484664711,0.9999186219003615};

static const double w189[189] = {0.0001033207088916,0.0002404833856319,0.0003777831261233,0.0005149966861122,0.0006520722507326,0.0007889696649384,0.0009256506465025,0.0010620774070083,0.0011982123616229,0.0013340180548151,0.0014694571420550,0.0016044923890354,0.0017390866771556,0.0018732030115189,0.0020068045299932,0.0021398545127627,0.0022723163920931,0.0024041537622003,0.0025353303891407,0.0026658102207044,0.0027955573962748,0.0029245362566619,0.0030527113538780,0.0031800474608725,0.0033065095812007,0.0034320629586379,0.0035566730867270,0.0036803057182570,0.0038029268746767,0.0039245028554261,0.0040450002472038,0.0041643859331418,0.0042826271019145,0.0043996912567472,0.0045155462243543,0.0046301601637764,0.0047435015751347,0.0048555393082824,0.0049662425713739,0.0050755809393202,0.0051835243621538,0.0052900431732869,0.0053951080976635,0.0054986902598095,0.0056007611917610,0.0057012928408961,0.0058002575776404,0.0058976282030602,0.0059933779563407,0.0060874805221370,0.0061799100378103,0.0062706411005320,0.0063596487742691,0.0064469085966340,0.0065323965856103,0.0066160892461422,0.0066979635765922,0.0067779970750622,0.0068561677455799,0.0069324541041424,0.0070068351846197,0.0070792905445187,0.0071498002706008,0.0072183449843556,0.0072849058473252,0.0073494645662833,0.0074120033982603,0.0074725051554241,0.0075309532097996,0.0075873314978391,0.0076416245248396,0.0076938173692029,0.0077438956865273,0.0077918457135603,0.0078376542719771,0.0078813087720021,0.0079227972158680,0.0079621082011167,0.0079992309237305,0.0080341551811007,0.0080668713748342,0.0080973705133894,0.0081256442145489,0.0081516847077216,0.0081754848360796,0.0081970380585255,0.0082163384514877,0.0082333807105500,0.0082481601519123,0.0082606727136714,0.0082709149569434,0.0082788840668064,0.0082845778530712,0.0082879947508915,0.0082891338211826,0.0082879947508911,0.0082845778530712,0.0082788840668060,0.0082709149569436,0.0082606727136716,0.0082481601519125,0.0082333807105504,0.0082163384514876,0.0081970380585255,0.0081754848360801,0.0081516847077221,0.0081256442145483,0.0080973705133895,0.0080668713748339,0.0080341551811009,0.0079992309237302,0.0079621082011165,0.0079227972158685,0.0078813087720019,0.0078376542719772,0.0077918457135605,0.0077438956865271,0.0076938173692020,0.0076416245248408,0.0075873314978389,0.0075309532097988,0.0074725051554247,0.0074120033982600,0.0073494645662830,0.0072849058473256,0.0072183449843558,0.0071498002706005,0.0070792905445185,0.0070068351846201,0.0069324541041430,0.0068561677455799,0.0067779970750624,0.0066979635765917,0.0066160892461421,0.0065323965856106,0.0064469085966337,0.0063596487742689,0.0062706411005318,0.0061799100378099,0.0060874805221374,0.0059933779563408,0.0058976282030602,0.0058002575776402,0.0057012928408963,0.0056007611917614,0.0054986902598093,0.0053951080976636,0.0052900431732868,0.0051835243621538,0.0050755809393200,0.0049662425713738,0.0048555393082829,0.0047435015751345,0.0046301601637768,0.0045155462243543,0.0043996912567474,0.0042826271019145,0.0041643859331422,0.0040450002472036,0.0039245028554258,0.0038029268746768,0.0036803057182573,0.0035566730867271,0.0034320629586384,0.0033065095812011,0.0031800474608720,0.0030527113538782,0.0029245362566618,0.0027955573962749,0.0026658102207040,0.0025353303891404,0.0024041537621997,0.0022723163920930,0.0021398545127625,0.0020068045299932,0.0018732030115190,0.0017390866771558,0.0016044923890352,0.0014694571420550,0.0013340180548145,0.0011982123616229,0.0010620774070080,0.0009256506465029,0.0007889696649384,0.0006520722507325,0.0005149966861122,0.0003777831261231,0.0002404833856323,0.0001033207088918};
static const double pts189[189] = {-0.9999194784924893,-0.9995757612794798,-0.9989574867917125,-0.9980646875839456,-0.9968975922000627,-0.9954565173788227,-0.9937418578379028,-0.9917540842776306,-0.9894937427498891,-0.9869614543411820,-0.9841579149370321,-0.9810838950023670,-0.9777402393562106,-0.9741278669325314,-0.9702477705238888,-0.9661010165064066,-0.9616887445453969,-0.9570121672813361,-0.9520725699960796,-0.9468713102592815,-0.9414098175550667,-0.9356895928889983,-0.9297122083754434,-0.9234793068054253,-0.9169926011950693,-0.9102538743147669,-0.9032649781991773,-0.8960278336382018,-0.8885444296490669,-0.8808168229296596,-0.8728471372932651,-0.8646375630848614,-0.8561903565791311,-0.8475078393603517,-0.8385923976843440,-0.8294464818226375,-0.8200726053890527,-0.8104733446488690,-0.8006513378107779,-0.7906092843018067,-0.7803499440254247,-0.7698761366030255,-0.7591907405989949,-0.7482966927295817,-0.7371969870557843,-0.7258946741604834,-0.7143928603100301,-0.7026947066005410,-0.6908034280891152,-0.6787222929102281,-0.6664546213775339,-0.6540037850713283,-0.6413732059119217,-0.6285663552191756,-0.6155867527584659,-0.6024379657733289,-0.5891236080050581,-0.5756473386995240,-0.5620128616014887,-0.5482239239366830,-0.5342843153819452,-0.5201978670236844,-0.5059684503049653,-0.4915999759615008,-0.4770963929468492,-0.4624616873471030,-0.4476998812853744,-0.4328150318163780,-0.4178112298114127,-0.4026925988340455,-0.3874632940068178,-0.3721275008692707,-0.3566894342276141,-0.3411533369963553,-0.3255234790321959,-0.3098041559605303,-0.2939996879948569,-0.2781144187494355,-0.2621527140455110,-0.2461189607114369,-0.2300175653770193,-0.2138529532624273,-0.1976295669619846,-0.1813518652231956,-0.1650243217213243,-0.1486514238298745,-0.1322376713873039,-0.1157875754603159,-0.0993056571040575,-0.0827964461195807,-0.0662644798088961,-0.0497143017279632,-0.0331504604379667,-0.0165775082552143,-0.0000000000000002,0.0165775082552142,0.0331504604379668,0.0497143017279634,0.0662644798088964,0.0827964461195808,0.0993056571040578,0.1157875754603158,0.1322376713873044,0.1486514238298742,0.1650243217213242,0.1813518652231955,0.1976295669619847,0.2138529532624271,0.2300175653770199,0.2461189607114370,0.2621527140455114,0.2781144187494354,0.2939996879948568,0.3098041559605305,0.3255234790321957,0.3411533369963550,0.3566894342276141,0.3721275008692702,0.3874632940068182,0.4026925988340461,0.4178112298114125,0.4328150318163780,0.4476998812853738,0.4624616873471027,0.4770963929468494,0.4915999759615009,0.5059684503049653,0.5201978670236841,0.5342843153819453,0.5482239239366821,0.5620128616014883,0.5756473386995240,0.5891236080050577,0.6024379657733289,0.6155867527584656,0.6285663552191757,0.6413732059119215,0.6540037850713284,0.6664546213775340,0.6787222929102280,0.6908034280891147,0.7026947066005408,0.7143928603100301,0.7258946741604833,0.7371969870557845,0.7482966927295811,0.7591907405989954,0.7698761366030260,0.7803499440254248,0.7906092843018067,0.8006513378107779,0.8104733446488697,0.8200726053890532,0.8294464818226379,0.8385923976843442,0.8475078393603523,0.8561903565791308,0.8646375630848611,0.8728471372932648,0.8808168229296598,0.8885444296490668,0.8960278336382020,0.9032649781991773,0.9102538743147673,0.9169926011950695,0.9234793068054257,0.9297122083754437,0.9356895928889984,0.9414098175550673,0.9468713102592821,0.9520725699960799,0.9570121672813365,0.9616887445453974,0.9661010165064070,0.9702477705238894,0.9741278669325316,0.9777402393562109,0.9810838950023670,0.9841579149370322,0.9869614543411820,0.9894937427498887,0.9917540842776301,0.9937418578379030,0.9954565173788227,0.9968975922000626,0.9980646875839451,0.9989574867917117,0.9995757612794791,0.9999194784924892};

static const double w190[190] = {0.0001022388553243,0.0002379656105400,0.0003738286789040,0.0005096075445602,0.0006452513253853,0.0007807206761800,0.0009159781039438,0.0010509866030813,0.0011857093680158,0.0013201097194625,0.0014541510861155,0.0015877970036636,0.0017210111200093,0.0018537572029713,0.0019859991490478,0.0021177009926558,0.0022488269155950,0.0023793412566041,0.0025092085209495,0.0026383933900079,0.0027668607308309,0.0028945756056718,0.0030215032814643,0.0031476092392616,0.0032728591836103,0.0033972190518735,0.0035206550234913,0.0036431335291714,0.0037646212600201,0.0038850851765961,0.0040044925178976,0.0041228108102695,0.0042400078762301,0.0043560518432301,0.0044709111523121,0.0045845545666953,0.0046969511802755,0.0048080704260213,0.0049178820842905,0.0050263562910523,0.0051334635460026,0.0052391747205921,0.0053434610659429,0.0054462942206717,0.0055476462185984,0.0056474894963562,0.0057457969008835,0.0058425416968107,0.0059376975737305,0.0060312386533528,0.0061231394965420,0.0062133751102381,0.0063019209542500,0.0063887529479316,0.0064738474767305,0.0065571813986090,0.0066387320503380,0.0067184772536639,0.0067963953213335,0.0068724650629965,0.0069466657909698,0.0070189773258587,0.0070893800020489,0.0071578546730522,0.0072243827167156,0.0072889460402833,0.0073515270853208,0.0074121088324858,0.0074706748061587,0.0075272090789246,0.0075816962759029,0.0076341215789293,0.0076844707305832,0.0077327300380718,0.0077788863769475,0.0078229271946792,0.0078648405140661,0.0079046149364947,0.0079422396450410,0.0079777044074094,0.0080109995787147,0.0080421161041094,0.0080710455212420,0.0080977799625593,0.0081223121574500,0.0081446354342148,0.0081647437218872,0.0081826315518815,0.0081982940594800,0.0082117269851566,0.0082229266757365,0.0082318900853880,0.0082386147764496,0.0082430989200956,0.0082453412968339,0.0082453412968342,0.0082430989200958,0.0082386147764492,0.0082318900853878,0.0082229266757368,0.0082117269851567,0.0081982940594800,0.0081826315518812,0.0081647437218869,0.0081446354342151,0.0081223121574501,0.0080977799625594,0.0080710455212411,0.0080421161041095,0.0080109995787147,0.0079777044074093,0.0079422396450409,0.0079046149364951,0.0078648405140655,0.0078229271946791,0.0077788863769477,0.0077327300380723,0.0076844707305834,0.0076341215789286,0.0075816962759029,0.0075272090789247,0.0074706748061595,0.0074121088324858,0.0073515270853207,0.0072889460402834,0.0072243827167156,0.0071578546730520,0.0070893800020487,0.0070189773258589,0.0069466657909695,0.0068724650629972,0.0067963953213328,0.0067184772536639,0.0066387320503383,0.0065571813986078,0.0064738474767301,0.0063887529479317,0.0063019209542503,0.0062133751102383,0.0061231394965422,0.0060312386533534,0.0059376975737304,0.0058425416968107,0.0057457969008841,0.0056474894963560,0.0055476462185981,0.0054462942206715,0.0053434610659433,0.0052391747205916,0.0051334635460026,0.0050263562910517,0.0049178820842903,0.0048080704260210,0.0046969511802755,0.0045845545666963,0.0044709111523117,0.0043560518432295,0.0042400078762302,0.0041228108102689,0.0040044925178979,0.0038850851765960,0.0037646212600200,0.0036431335291715,0.0035206550234917,0.0033972190518738,0.0032728591836105,0.0031476092392618,0.0030215032814645,0.0028945756056717,0.0027668607308314,0.0026383933900076,0.0025092085209494,0.0023793412566045,0.0022488269155943,0.0021177009926557,0.0019859991490477,0.0018537572029716,0.0017210111200087,0.0015877970036634,0.0014541510861157,0.0013201097194628,0.0011857093680161,0.0010509866030816,0.0009159781039432,0.0007807206761801,0.0006452513253851,0.0005096075445606,0.0003738286789041,0.0002379656105401,0.0001022388553245};
static const double pts190[190] = {-0.9999203216306946,-0.9995802032181089,-0.9989684011828526,-0.9980849459787161,-0.9969300612154020,-0.9955040569943823,-0.9938073198017446,-0.9918403105350625,-0.9896035638815804,-0.9870976880076859,-0.9843233643292894,-0.9812813472984471,-0.9779724641847650,-0.9743976148435248,-0.9705577714672023,-0.9664539783189217,-0.9620873514471794,-0.9574590783815292,-0.9525704178091189,-0.9474226992320489,-0.9420173226055818,-0.9363557579572612,-0.9304395449870191,-0.9242702926483674,-0.9178496787107789,-0.9111794493033637,-0.9042614184399653,-0.8970974675258100,-0.8896895448458230,-0.8820396650347671,-0.8741499085293394,-0.8660224210023764,-0.8576594127793123,-0.8490631582370656,-0.8402359951854977,-0.8311803242316321,-0.8218986081267856,-0.8123933710968056,-0.8026671981555878,-0.7927227344020652,-0.7825626843008487,-0.7721898109467329,-0.7616069353132503,-0.7508169354854913,-0.7398227458773837,-0.7286273564336618,-0.7172338118167284,-0.7056452105786380,-0.6938647043184257,-0.6818954968250072,-0.6697408432058838,-0.6574040490018986,-0.6448884692882672,-0.6321975077621435,-0.6193346158169625,-0.6063032916038089,-0.5931070790800705,-0.5797495670456364,-0.5662343881668958,-0.5525652179888114,-0.5387457739353314,-0.5247798142984064,-0.5106711372158987,-0.4964235796386545,-0.4820410162870145,-0.4675273585970635,-0.4528865536568820,-0.4381225831331115,-0.4232394621881157,-0.4082412383880264,-0.3931319906019806,-0.3779158278928449,-0.3625968883997280,-0.3471793382125857,-0.3316673702392245,-0.3160652030650096,-0.3003770798055957,-0.2846072669529787,-0.2687600532151969,-0.2528397483499866,-0.2368506819927136,-0.2207972024789017,-0.2046836756616696,-0.1885144837244103,-0.1722940239890257,-0.1560267077200444,-0.1397169589249483,-0.1233692131510343,-0.1069879162791360,-0.0905775233145375,-0.0741424971754037,-0.0576873074790583,-0.0412164293264421,-0.0247343420850785,-0.0082455281708790,0.0082455281708795,0.0247343420850786,0.0412164293264421,0.0576873074790586,0.0741424971754035,0.0905775233145381,0.1069879162791357,0.1233692131510337,0.1397169589249479,0.1560267077200441,0.1722940239890257,0.1885144837244101,0.2046836756616699,0.2207972024789018,0.2368506819927136,0.2528397483499867,0.2687600532151967,0.2846072669529789,0.3003770798055957,0.3160652030650098,0.3316673702392244,0.3471793382125855,0.3625968883997275,0.3779158278928446,0.3931319906019802,0.4082412383880265,0.4232394621881166,0.4381225831331119,0.4528865536568823,0.4675273585970641,0.4820410162870153,0.4964235796386545,0.5106711372158987,0.5247798142984064,0.5387457739353317,0.5525652179888122,0.5662343881668959,0.5797495670456364,0.5931070790800704,0.6063032916038094,0.6193346158169624,0.6321975077621437,0.6448884692882674,0.6574040490018989,0.6697408432058846,0.6818954968250068,0.6938647043184255,0.7056452105786377,0.7172338118167274,0.7286273564336613,0.7398227458773839,0.7508169354854918,0.7616069353132504,0.7721898109467324,0.7825626843008481,0.7927227344020658,0.8026671981555881,0.8123933710968052,0.8218986081267857,0.8311803242316319,0.8402359951854977,0.8490631582370650,0.8576594127793121,0.8660224210023758,0.8741499085293386,0.8820396650347659,0.8896895448458229,0.8970974675258099,0.9042614184399657,0.9111794493033634,0.9178496787107786,0.9242702926483670,0.9304395449870186,0.9363557579572613,0.9420173226055818,0.9474226992320490,0.9525704178091192,0.9574590783815292,0.9620873514471795,0.9664539783189221,0.9705577714672020,0.9743976148435247,0.9779724641847651,0.9812813472984473,0.9843233643292896,0.9870976880076858,0.9896035638815807,0.9918403105350625,0.9938073198017449,0.9955040569943826,0.9969300612154017,0.9980849459787166,0.9989684011828516,0.9995802032181089,0.9999203216306944};

static const double w191[191] = {0.0001011739049199,0.0002354871679216,0.0003699359910490,0.0005043025361389,0.0006385368311836,0.0007726003201513,0.0009064562789338,0.0010400684645709,0.0011734008306490,0.0013064174541354,0.0014390825170619,0.0015713603053368,0.0017032152137161,0.0018346117532240,0.0019655145596176,0.0020958884023407,0.0022256981936847,0.0023549089980521,0.0024834860412477,0.0026113947197691,0.0027386006100805,0.0028650694778435,0.0029907672871170,0.0031156602095008,0.0032397146332325,0.0033628971722290,0.0034851746750630,0.0036065142338854,0.0037268831932775,0.0038462491590365,0.0039645800068970,0.0040818438911696,0.0041980092533138,0.0043130448304315,0.0044269196636758,0.0045396031065888,0.0046510648333430,0.0047612748469055,0.0048702034871114,0.0049778214386443,0.0050840997389244,0.0051890097859079,0.0052925233457795,0.0053946125605506,0.0054952499555620,0.0055944084468720,0.0056920613485480,0.0057881823798491,0.0058827456722949,0.0059757257766318,0.0060670976696820,0.0061568367610739,0.0062449188998603,0.0063313203810246,0.0064160179518519,0.0064989888181904,0.0065802106505897,0.0066596615903017,0.0067373202551731,0.0068131657453890,0.0068871776491087,0.0069593360479508,0.0070296215223562,0.0070980151568180,0.0071644985449649,0.0072290537945211,0.0072916635321188,0.0073523109079744,0.0074109796004215,0.0074676538203073,0.0075223183152380,0.0075749583736844,0.0076255598289450,0.0076741090629496,0.0077205930099356,0.0077649991599572,0.0078073155622519,0.0078475308284597,0.0078856341356867,0.0079216152294190,0.0079554644262794,0.0079871726166364,0.0080167312670538,0.0080441324225909,0.0080693687089361,0.0080924333344012,0.0081133200917401,0.0081320233598254,0.0081485381051583,0.0081628598832244,0.0081749848396896,0.0081849097114370,0.0081926318274443,0.0081981491095056,0.0082014600727871,0.0082025638262301,0.0082014600727872,0.0081981491095054,0.0081926318274442,0.0081849097114367,0.0081749848396899,0.0081628598832240,0.0081485381051585,0.0081320233598252,0.0081133200917402,0.0080924333344007,0.0080693687089363,0.0080441324225903,0.0080167312670543,0.0079871726166368,0.0079554644262792,0.0079216152294193,0.0078856341356869,0.0078475308284597,0.0078073155622524,0.0077649991599572,0.0077205930099362,0.0076741090629492,0.0076255598289445,0.0075749583736849,0.0075223183152379,0.0074676538203067,0.0074109796004218,0.0073523109079740,0.0072916635321190,0.0072290537945213,0.0071644985449649,0.0070980151568176,0.0070296215223565,0.0069593360479506,0.0068871776491080,0.0068131657453889,0.0067373202551729,0.0066596615903020,0.0065802106505894,0.0064989888181911,0.0064160179518514,0.0063313203810245,0.0062449188998607,0.0061568367610735,0.0060670976696824,0.0059757257766322,0.0058827456722949,0.0057881823798483,0.0056920613485483,0.0055944084468720,0.0054952499555619,0.0053946125605503,0.0052925233457789,0.0051890097859082,0.0050840997389247,0.0049778214386438,0.0048702034871116,0.0047612748469056,0.0046510648333427,0.0045396031065888,0.0044269196636760,0.0043130448304314,0.0041980092533139,0.0040818438911688,0.0039645800068975,0.0038462491590364,0.0037268831932772,0.0036065142338861,0.0034851746750629,0.0033628971722289,0.0032397146332327,0.0031156602095004,0.0029907672871165,0.0028650694778434,0.0027386006100808,0.0026113947197693,0.0024834860412477,0.0023549089980527,0.0022256981936850,0.0020958884023405,0.0019655145596177,0.0018346117532234,0.0017032152137167,0.0015713603053367,0.0014390825170619,0.0013064174541353,0.0011734008306485,0.0010400684645716,0.0009064562789337,0.0007726003201520,0.0006385368311832,0.0005043025361388,0.0003699359910488,0.0002354871679218,0.0001011739049199};
static const double pts191[191] = {-0.9999211515952567,-0.9995845757587154,-0.9989791450775036,-0.9981048879736487,-0.9969620232522572,-0.9955508545498114,-0.9938717603340316,-0.9919251919534707,-0.9897116730247481,-0.9872317991282332,-0.9844862375842074,-0.9814757272455000,-0.9782010782853723,-0.9746631719726537,-0.9708629604308563,-0.9668014663798048,-0.9624797828591269,-0.9578990729333030,-0.9530605693781589,-0.9479655743487617,-0.9426154590287600,-0.9370116632612140,-0.9311556951609911,-0.9250491307088207,-0.9186936133271058,-0.9120908534375958,-0.9052426280010439,-0.8981507800389613,-0.8908172181375950,-0.8832439159342728,-0.8754329115862384,-0.8673863072221243,-0.8591062683762150,-0.8505950234056433,-0.8418548628906803,-0.8328881390182854,-0.8236972649490711,-0.8142847141678617,-0.8046530198180171,-0.7948047740197030,-0.7847426271722872,-0.7744692872410524,-0.7639875190284151,-0.7533001434298542,-0.7424100366747364,-0.7313201295522523,-0.7200334066226757,-0.7085529054141390,-0.6968817156051668,-0.6850229781931678,-0.6729798846491150,-0.6607556760586436,-0.6483536422497997,-0.6357771209076685,-0.6230294966761178,-0.6101142002469149,-0.5970347074364420,-0.5837945382502706,-0.5703972559358460,-0.5568464660235273,-0.5431458153562537,-0.5292989911080965,-0.5153097197919436,-0.5011817662566141,-0.4869189326736409,-0.4725250575140142,-0.4580040145151633,-0.4433597116384363,-0.4285960900173714,-0.4137171228970516,-0.3987268145647987,-0.3836291992725300,-0.3684283401510439,-0.3531283281165303,-0.3377332807696100,-0.3222473412871898,-0.3066746773074309,-0.2910194798081403,-0.2752859619788768,-0.2594783580870810,-0.2436009223385315,-0.2276579277324369,-0.2116536649114687,-0.1955924410070448,-0.1794785784801809,-0.1633164139582089,-0.1471102970676862,-0.1308645892638101,-0.1145836626566422,-0.0982718988344702,-0.0819336876846168,-0.0655734262120151,-0.0491955173558701,-0.0328043688047221,-0.0164043918102303,0.0000000000000006,0.0164043918102312,0.0328043688047231,0.0491955173558713,0.0655734262120155,0.0819336876846172,0.0982718988344702,0.1145836626566427,0.1308645892638102,0.1471102970676862,0.1633164139582086,0.1794785784801812,0.1955924410070448,0.2116536649114684,0.2276579277324368,0.2436009223385315,0.2594783580870810,0.2752859619788763,0.2910194798081402,0.3066746773074306,0.3222473412871891,0.3377332807696096,0.3531283281165297,0.3684283401510431,0.3836291992725303,0.3987268145647989,0.4137171228970523,0.4285960900173723,0.4433597116384361,0.4580040145151635,0.4725250575140137,0.4869189326736400,0.5011817662566145,0.5153097197919440,0.5292989911080961,0.5431458153562542,0.5568464660235272,0.5703972559358464,0.5837945382502718,0.5970347074364419,0.6101142002469152,0.6230294966761172,0.6357771209076681,0.6483536422497997,0.6607556760586433,0.6729798846491146,0.6850229781931682,0.6968817156051671,0.7085529054141386,0.7200334066226758,0.7313201295522527,0.7424100366747365,0.7533001434298547,0.7639875190284158,0.7744692872410521,0.7847426271722873,0.7948047740197027,0.8046530198180163,0.8142847141678615,0.8236972649490714,0.8328881390182856,0.8418548628906805,0.8505950234056430,0.8591062683762144,0.8673863072221237,0.8754329115862373,0.8832439159342721,0.8908172181375943,0.8981507800389600,0.9052426280010437,0.9120908534375954,0.9186936133271052,0.9250491307088206,0.9311556951609909,0.9370116632612139,0.9426154590287599,0.9479655743487614,0.9530605693781585,0.9578990729333029,0.9624797828591266,0.9668014663798048,0.9708629604308564,0.9746631719726538,0.9782010782853725,0.9814757272455006,0.9844862375842068,0.9872317991282340,0.9897116730247484,0.9919251919534711,0.9938717603340320,0.9955508545498118,0.9969620232522579,0.9981048879736486,0.9989791450775038,0.9995845757587156,0.9999211515952569};

static const double w192[192] = {0.0001001255073732,0.0002330472427957,0.0003661037833131,0.0004990799190111,0.0006319265660482,0.0007646059375097,0.0008970820584774,0.0010293194290578,0.0011612827425241,0.0012929368127223,0.0014242465557383,0.0015551769885342,0.0016856932336713,0.0018157605264554,0.0019453442231286,0.0020744098095323,0.0022029229099874,0.0023308492962642,0.0024581548965989,0.0025848058046948,0.0027107682887146,0.0028360088002314,0.0029604939831541,0.0030841906825897,0.0032070659536719,0.0033290870703259,0.0034502215339802,0.0035704370822226,0.0036897016973855,0.0038079836150740,0.0039252513326264,0.0040414736174999,0.0041566195155924,0.0042706583594805,0.0043835597765942,0.0044952936972980,0.0046058303629044,0.0047151403335993,0.0048231944962808,0.0049299640723120,0.0050354206251891,0.0051395360681136,0.0052422826714702,0.0053436330702148,0.0054435602711640,0.0055420376601798,0.0056390390092605,0.0057345384835288,0.0058285106481070,0.0059209304748951,0.0060117733492347,0.0061010150764666,0.0061886318883732,0.0062746004495080,0.0063588978634141,0.0064415016787171,0.0065223898951114,0.0066015409692119,0.0066789338203004,0.0067545478359296,0.0068283628774234,0.0069003592852351,0.0069705178841825,0.0070388199885593,0.0071052474071070,0.0071697824478623,0.0072324079228699,0.0072931071527587,0.0073518639711837,0.0074086627291336,0.0074634882990981,0.0075163260790944,0.0075671619965593,0.0076159825120983,0.0076627746230849,0.0077075258671325,0.0077502243254066,0.0077908586258041,0.0078294179459772,0.0078658920162210,0.0079002711222043,0.0079325461075599,0.0079627083763224,0.0079907498952150,0.0080166631957948,0.0080404413764348,0.0080620781041692,0.0080815676163732,0.0080989047223038,0.0081140848044786,0.0081271038199058,0.0081379583011636,0.0081466453573211,0.0081531626747092,0.0081575085175357,0.0081596817283502,0.0081596817283508,0.0081575085175360,0.0081531626747088,0.0081466453573216,0.0081379583011637,0.0081271038199053,0.0081140848044780,0.0080989047223037,0.0080815676163732,0.0080620781041688,0.0080404413764354,0.0080166631957951,0.0079907498952155,0.0079627083763224,0.0079325461075599,0.0079002711222051,0.0078658920162204,0.0078294179459772,0.0077908586258037,0.0077502243254068,0.0077075258671326,0.0076627746230848,0.0076159825120979,0.0075671619965598,0.0075163260790942,0.0074634882990978,0.0074086627291342,0.0073518639711839,0.0072931071527581,0.0072324079228706,0.0071697824478619,0.0071052474071067,0.0070388199885597,0.0069705178841827,0.0069003592852353,0.0068283628774233,0.0067545478359292,0.0066789338202997,0.0066015409692123,0.0065223898951111,0.0064415016787174,0.0063588978634133,0.0062746004495080,0.0061886318883737,0.0061010150764658,0.0060117733492350,0.0059209304748951,0.0058285106481069,0.0057345384835296,0.0056390390092608,0.0055420376601789,0.0054435602711638,0.0053436330702153,0.0052422826714698,0.0051395360681135,0.0050354206251892,0.0049299640723118,0.0048231944962809,0.0047151403336002,0.0046058303629042,0.0044952936972979,0.0043835597765941,0.0042706583594812,0.0041566195155920,0.0040414736175004,0.0039252513326257,0.0038079836150741,0.0036897016973853,0.0035704370822227,0.0034502215339807,0.0033290870703258,0.0032070659536724,0.0030841906825895,0.0029604939831540,0.0028360088002316,0.0027107682887142,0.0025848058046951,0.0024581548965987,0.0023308492962638,0.0022029229099867,0.0020744098095327,0.0019453442231285,0.0018157605264552,0.0016856932336717,0.0015551769885341,0.0014242465557384,0.0012929368127222,0.0011612827425244,0.0010293194290580,0.0008970820584775,0.0007646059375092,0.0006319265660482,0.0004990799190117,0.0003661037833124,0.0002330472427957,0.0001001255073739};
static const double pts192[192] = {-0.9999219686591954,-0.9995888803394144,-0.9989897220082229,-0.9981245201227150,-0.9969934888089662,-0.9955969254054171,-0.9939352005680616,-0.9920087563423264,-0.9898181055591406,-0.9873638315366438,-0.9846465878619343,-0.9816670981895118,-0.9784261560354056,-0.9749246245590818,-0.9711634363298713,-0.9671435930764913,-0.9628661654189841,-0.9583322925828039,-0.9535431820948995,-0.9485001094617783,-0.9432044178295799,-0.9376575176261968,-0.9318608861855213,-0.9258160673539061,-0.9195246710789272,-0.9129883729805596,-0.9062089139048716,-0.8991880994603514,-0.8919277995369952,-0.8844299478082761,-0.8766965412161271,-0.8687296394390780,-0.8605313643436845,-0.8521038994193961,-0.8434494891970103,-0.8345704386508697,-0.8254691125849698,-0.8161479350031206,-0.8066093884633475,-0.7968560134167012,-0.7868904075306404,-0.7767152249971830,-0.7663331758259995,-0.7557470251226410,-0.7449595923520941,-0.7339737505878553,-0.7227924257467350,-0.7114185958095772,-0.6998552900281194,-0.6881055881181969,-0.6761726194395049,-0.6640595621621393,-0.6517696424201396,-0.6393061334522510,-0.6266723547301500,-0.6138716710743534,-0.6009074917580418,-0.5877832695990525,-0.5745025000402751,-0.5610687202186866,-0.5474855080232949,-0.5337564811422113,-0.5198852960991412,-0.5058756472795159,-0.4917312659465524,-0.4774559192474837,-0.4630534092102367,-0.4485275717308173,-0.4338822755516750,-0.4191214212313223,-0.4042489401054767,-0.3892687932400086,-0.3741849703759692,-0.3590014888669830,-0.3437223926092836,-0.3283517509646821,-0.3128936576767524,-0.2973522297805238,-0.2817316065059672,-0.2660359481755764,-0.2502694350963237,-0.2344362664462986,-0.2185406591563169,-0.2025868467868076,-0.1865790784002615,-0.1705216174295588,-0.1544187405424671,-0.1382747365026114,-0.1220939050272294,-0.1058805556420006,-0.0896390065332723,-0.0733735833979690,-0.0570886182915126,-0.0407884484740391,-0.0244774152552355,-0.0081598628380953,0.0081598628380948,0.0244774152552350,0.0407884484740383,0.0570886182915121,0.0733735833979685,0.0896390065332715,0.1058805556420006,0.1220939050272287,0.1382747365026111,0.1544187405424663,0.1705216174295583,0.1865790784002611,0.2025868467868076,0.2185406591563172,0.2344362664462986,0.2502694350963239,0.2660359481755767,0.2817316065059670,0.2973522297805228,0.3128936576767521,0.3283517509646819,0.3437223926092826,0.3590014888669826,0.3741849703759690,0.3892687932400079,0.4042489401054765,0.4191214212313223,0.4338822755516752,0.4485275717308177,0.4630534092102374,0.4774559192474835,0.4917312659465524,0.5058756472795163,0.5198852960991421,0.5337564811422120,0.5474855080232952,0.5610687202186871,0.5745025000402751,0.5877832695990530,0.6009074917580429,0.6138716710743550,0.6266723547301515,0.6393061334522512,0.6517696424201391,0.6640595621621401,0.6761726194395049,0.6881055881181971,0.6998552900281193,0.7114185958095772,0.7227924257467350,0.7339737505878553,0.7449595923520939,0.7557470251226410,0.7663331758259998,0.7767152249971834,0.7868904075306404,0.7968560134167014,0.8066093884633474,0.8161479350031201,0.8254691125849699,0.8345704386508700,0.8434494891970097,0.8521038994193962,0.8605313643436850,0.8687296394390772,0.8766965412161269,0.8844299478082762,0.8919277995369957,0.8991880994603516,0.9062089139048716,0.9129883729805605,0.9195246710789271,0.9258160673539069,0.9318608861855218,0.9376575176261975,0.9432044178295800,0.9485001094617785,0.9535431820948999,0.9583322925828044,0.9628661654189842,0.9671435930764903,0.9711634363298712,0.9749246245590814,0.9784261560354054,0.9816670981895116,0.9846465878619342,0.9873638315366435,0.9898181055591402,0.9920087563423264,0.9939352005680616,0.9955969254054174,0.9969934888089661,0.9981245201227149,0.9989897220082230,0.9995888803394141,0.9999219686591951};

static const double w193[193] = {0.0000990933214099,0.0002306450411791,0.0003623308093978,0.0004939379961783,0.0006254183845389,0.0007567349372490,0.0008878524094830,0.0010187360254401,0.0011493511992073,0.0012796634627200,0.0014096384474302,0.0015392418827682,0.0016684396006275,0.0017971975422548,0.0019254817661648,0.0020532584565319,0.0021804939317946,0.0023071546533517,0.0024332072342991,0.0025586184481640,0.0026833552376182,0.0028073847231684,0.0029306742118016,0.0030531912055924,0.0031749034102609,0.0032957787436762,0.0034157853443117,0.0035348915796395,0.0036530660544647,0.0037702776192023,0.0038864953780843,0.0040016886973011,0.0041158272130814,0.0042288808396875,0.0043408197773503,0.0044516145201242,0.0045612358636601,0.0046696549129078,0.0047768430897286,0.0048827721404305,0.0049874141432143,0.0050907415155332,0.0051927270213658,0.0052933437783898,0.0053925652650734,0.0054903653276636,0.0055867181870803,0.0056815984457103,0.0057749810941031,0.0058668415175623,0.0059571555026375,0.0060458992434980,0.0061330493482181,0.0062185828449359,0.0063024771879106,0.0063847102634656,0.0064652603958172,0.0065441063527878,0.0066212273514045,0.0066966030633724,0.0067702136204371,0.0068420396196236,0.0069120621283428,0.0069802626893918,0.0070466233258103,0.0071111265456261,0.0071737553464605,0.0072344932200129,0.0072933241564123,0.0073502326484343,0.0074052036955936,0.0074582228080944,0.0075092760106476,0.0075583498461613,0.0076054313792846,0.0076505081998129,0.0076935684259662,0.0077346007075161,0.0077735942287804,0.0078105387114720,0.0078454244174105,0.0078782421510856,0.0079089832620848,0.0079376396473709,0.0079642037534180,0.0079886685782051,0.0080110276730581,0.0080312751443529,0.0080494056550663,0.0080654144261836,0.0080792972379606,0.0080910504310321,0.0081006709073776,0.0081081561311406,0.0081135041292939,0.0081167134921608,0.0081177833737857,0.0081167134921603,0.0081135041292939,0.0081081561311405,0.0081006709073773,0.0080910504310321,0.0080792972379608,0.0080654144261841,0.0080494056550663,0.0080312751443528,0.0080110276730582,0.0079886685782048,0.0079642037534181,0.0079376396473710,0.0079089832620844,0.0078782421510854,0.0078454244174107,0.0078105387114721,0.0077735942287802,0.0077346007075165,0.0076935684259658,0.0076505081998128,0.0076054313792846,0.0075583498461621,0.0075092760106472,0.0074582228080934,0.0074052036955934,0.0073502326484344,0.0072933241564118,0.0072344932200129,0.0071737553464608,0.0071111265456264,0.0070466233258110,0.0069802626893924,0.0069120621283433,0.0068420396196235,0.0067702136204367,0.0066966030633715,0.0066212273514047,0.0065441063527885,0.0064652603958174,0.0063847102634661,0.0063024771879102,0.0062185828449361,0.0061330493482184,0.0060458992434975,0.0059571555026363,0.0058668415175631,0.0057749810941029,0.0056815984457100,0.0055867181870799,0.0054903653276643,0.0053925652650740,0.0052933437783892,0.0051927270213655,0.0050907415155334,0.0049874141432142,0.0048827721404305,0.0047768430897284,0.0046696549129079,0.0045612358636601,0.0044516145201245,0.0043408197773502,0.0042288808396868,0.0041158272130814,0.0040016886973021,0.0038864953780836,0.0037702776192023,0.0036530660544654,0.0035348915796391,0.0034157853443115,0.0032957787436764,0.0031749034102611,0.0030531912055925,0.0029306742118018,0.0028073847231682,0.0026833552376179,0.0025586184481643,0.0024332072342994,0.0023071546533515,0.0021804939317949,0.0020532584565327,0.0019254817661648,0.0017971975422543,0.0016684396006276,0.0015392418827682,0.0014096384474297,0.0012796634627198,0.0011493511992074,0.0010187360254398,0.0008878524094831,0.0007567349372492,0.0006254183845393,0.0004939379961782,0.0003623308093978,0.0002306450411790,0.0000990933214096};
static const double pts193[193] = {-0.9999227730884913,-0.9995931183612576,-0.9990001354165514,-0.9981438488110804,-0.9970244681135597,-0.9956422845262092,-0.9939976610935706,-0.9920910307962869,-0.9899228959557784,-0.9874938279418018,-0.9848044669595972,-0.9818555218539341,-0.9786477699092710,-0.9751820566381834,-0.9714592955548547,-0.9674804679322028,-0.9632466225419735,-0.9587588753775327,-0.9540184093592048,-0.9490264740221499,-0.9437843851867751,-0.9382935246117570,-0.9325553396297154,-0.9265713427656381,-0.9203431113381413,-0.9138722870436653,-0.9071605755237119,-0.9002097459152315,-0.8930216303842808,-0.8855981236430713,-0.8779411824505301,-0.8700528250965123,-0.8619351308697952,-0.8535902395099920,-0.8450203506435379,-0.8362277232038857,-0.8272146748360728,-0.8179835812858127,-0.8085368757732695,-0.7988770483516864,-0.7890066452510323,-0.7789282682068407,-0.7686445737744173,-0.7581582726286015,-0.7474721288492585,-0.7365889591926962,-0.7255116323491961,-0.7142430681868587,-0.7027862369819529,-0.6911441586359856,-0.6793199018796846,-0.6673165834641113,-0.6551373673391210,-0.6427854638193765,-0.6302641287381415,-0.6175766625890788,-0.6047264096562731,-0.5917167571327128,-0.5785511342274609,-0.5652330112617512,-0.5517658987542475,-0.5381533464957080,-0.5243989426132964,-0.5105063126247895,-0.4964791184829276,-0.4823210576101624,-0.4680358619240568,-0.4536272968535854,-0.4390991603466106,-0.4244552818687819,-0.4096995213941299,-0.3948357683876140,-0.3798679407799019,-0.3647999839346449,-0.3496358696085189,-0.3343795949043126,-0.3190351812173300,-0.3036066731753959,-0.2880981375727324,-0.2725136622979930,-0.2568573552567395,-0.2411333432886404,-0.2253457710796789,-0.2094988000696556,-0.1935966073552781,-0.1776433845891207,-0.1616433368747485,-0.1456006816582959,-0.1295196476167915,-0.1134044735435229,-0.0972594072307365,-0.0810887043499588,-0.0648966273302520,-0.0486874442346772,-0.0324654276352814,-0.0162348534868876,-0.0000000000000003,0.0162348534868877,0.0324654276352820,0.0486874442346777,0.0648966273302516,0.0810887043499584,0.0972594072307358,0.1134044735435232,0.1295196476167915,0.1456006816582959,0.1616433368747483,0.1776433845891203,0.1935966073552779,0.2094988000696552,0.2253457710796784,0.2411333432886405,0.2568573552567393,0.2725136622979926,0.2880981375727325,0.3036066731753960,0.3190351812173296,0.3343795949043123,0.3496358696085193,0.3647999839346452,0.3798679407799022,0.3948357683876144,0.4096995213941301,0.4244552818687823,0.4390991603466104,0.4536272968535849,0.4680358619240568,0.4823210576101626,0.4964791184829276,0.5105063126247894,0.5243989426132964,0.5381533464957083,0.5517658987542474,0.5652330112617514,0.5785511342274609,0.5917167571327131,0.6047264096562729,0.6175766625890783,0.6302641287381416,0.6427854638193767,0.6551373673391212,0.6673165834641115,0.6793199018796854,0.6911441586359864,0.7027862369819525,0.7142430681868583,0.7255116323491960,0.7365889591926960,0.7474721288492586,0.7581582726286019,0.7686445737744168,0.7789282682068404,0.7890066452510319,0.7988770483516862,0.8085368757732692,0.8179835812858123,0.8272146748360724,0.8362277232038854,0.8450203506435374,0.8535902395099917,0.8619351308697949,0.8700528250965117,0.8779411824505301,0.8855981236430710,0.8930216303842806,0.9002097459152313,0.9071605755237113,0.9138722870436653,0.9203431113381412,0.9265713427656388,0.9325553396297163,0.9382935246117574,0.9437843851867754,0.9490264740221496,0.9540184093592055,0.9587588753775330,0.9632466225419737,0.9674804679322029,0.9714592955548553,0.9751820566381834,0.9786477699092709,0.9818555218539342,0.9848044669595970,0.9874938279418024,0.9899228959557785,0.9920910307962874,0.9939976610935709,0.9956422845262091,0.9970244681135604,0.9981438488110804,0.9990001354165516,0.9995931183612584,0.9999227730884916};

static const double w194[194] = {0.0000980770145021,0.0002282797894419,0.0003586158549422,0.0004888751140971,0.0006190101961161,0.0007489847946061,0.0008787643763149,0.0010083148711451,0.0011376023956968,0.0012665931817753,0.0013952535580787,0.0015235499484840,0.0016514488763065,0.0017789169709376,0.0019059209755078,0.0020324277549978,0.0021584043045931,0.0022838177581046,0.0024086353964426,0.0025328246560879,0.0026563531375450,0.0027791886137650,0.0029012990385422,0.0030226525548526,0.0031432175031660,0.0032629624296937,0.0033818560945914,0.0034998674801082,0.0036169657986741,0.0037331205009318,0.0038483012837030,0.0039624780978986,0.0040756211563496,0.0041877009415854,0.0042986882135279,0.0044085540171230,0.0045172696898950,0.0046248068694197,0.0047311375007273,0.0048362338436207,0.0049400684799126,0.0050426143205765,0.0051438446128163,0.0052437329470467,0.0053422532637754,0.0054393798604132,0.0055350873979696,0.0056293509076689,0.0057221457974619,0.0058134478584417,0.0059032332711619,0.0059914786118469,0.0060781608585045,0.0061632573969335,0.0062467460266214,0.0063286049665372,0.0064088128608140,0.0064873487843183,0.0065641922481134,0.0066393232047972,0.0067127220537451,0.0067843696462066,0.0068542472903157,0.0069223367559596,0.0069886202795371,0.0070530805685913,0.0071157008063236,0.0071764646559778,0.0072353562651049,0.0072923602696966,0.0073474617981958,0.0074006464753745,0.0074519004260850,0.0075012102788786,0.0075485631694953,0.0075939467442209,0.0076373491631067,0.0076787591030603,0.0077181657608007,0.0077555588556752,0.0077909286323430,0.0078242658633152,0.0078555618513694,0.0078848084318144,0.0079119979746227,0.0079371233864157,0.0079601781123222,0.0079811561376814,0.0080000519896168,0.0080168607384613,0.0080315779990448,0.0080441999318365,0.0080547232439488,0.0080631451899945,0.0080694635728058,0.0080736767440016,0.0080757836044258,0.0080757836044248,0.0080736767440016,0.0080694635728057,0.0080631451899950,0.0080547232439488,0.0080441999318363,0.0080315779990446,0.0080168607384611,0.0080000519896171,0.0079811561376817,0.0079601781123217,0.0079371233864156,0.0079119979746220,0.0078848084318152,0.0078555618513694,0.0078242658633149,0.0077909286323431,0.0077555588556757,0.0077181657608013,0.0076787591030601,0.0076373491631062,0.0075939467442210,0.0075485631694954,0.0075012102788786,0.0074519004260849,0.0074006464753744,0.0073474617981964,0.0072923602696963,0.0072353562651046,0.0071764646559779,0.0071157008063237,0.0070530805685911,0.0069886202795369,0.0069223367559598,0.0068542472903159,0.0067843696462063,0.0067127220537454,0.0066393232047983,0.0065641922481124,0.0064873487843180,0.0064088128608139,0.0063286049665371,0.0062467460266212,0.0061632573969334,0.0060781608585045,0.0059914786118470,0.0059032332711616,0.0058134478584420,0.0057221457974613,0.0056293509076684,0.0055350873979698,0.0054393798604130,0.0053422532637758,0.0052437329470465,0.0051438446128169,0.0050426143205762,0.0049400684799126,0.0048362338436208,0.0047311375007270,0.0046248068694194,0.0045172696898952,0.0044085540171241,0.0042986882135277,0.0041877009415854,0.0040756211563496,0.0039624780978988,0.0038483012837034,0.0037331205009307,0.0036169657986742,0.0034998674801083,0.0033818560945912,0.0032629624296938,0.0031432175031658,0.0030226525548528,0.0029012990385418,0.0027791886137657,0.0026563531375447,0.0025328246560885,0.0024086353964426,0.0022838177581050,0.0021584043045935,0.0020324277549981,0.0019059209755071,0.0017789169709383,0.0016514488763064,0.0015235499484839,0.0013952535580789,0.0012665931817757,0.0011376023956964,0.0010083148711453,0.0008787643763146,0.0007489847946062,0.0006190101961162,0.0004888751140960,0.0003586158549420,0.0002282797894417,0.0000980770145021};
static const double pts194[194] = {-0.9999235651423092,-0.9995972911893850,-0.9990103886558194,-0.9981628802602929,-0.9970549711320824,-0.9956869464940431,-0.9940591619734225,-0.9921720417171268,-0.9900260778048104,-0.9876218299621060,-0.9849599253529940,-0.9820410583892593,-0.9788659905364672,-0.9754355501086881,-0.9717506320487980,-0.9678121976929379,-0.9636212745184830,-0.9591789558752231,-0.9544864006996377,-0.9495448332122262,-0.9443555425979098,-0.9389198826695572,-0.9332392715146824,-0.9273151911254220,-0.9211491870118418,-0.9147428677987021,-0.9080979048057567,-0.9012160316117058,-0.8940990436019173,-0.8867487975000184,-0.8791672108834947,-0.8713562616834106,-0.8633179876683903,-0.8550544859129866,-0.8465679122505787,-0.8378604807109424,-0.8289344629426360,-0.8197921876203593,-0.8104360398374311,-0.8008684604835498,-0.7910919456079976,-0.7811090457684575,-0.7709223653656015,-0.7605345619636441,-0.7499483455970148,-0.7391664780633499,-0.7281917722029769,-0.7170270911650818,-0.7056753476607535,-0.6941395032030976,-0.6824225673346187,-0.6705275968420691,-0.6584576949589784,-0.6462160105560634,-0.6338057373197276,-0.6212301129188742,-0.6084924181602427,-0.5955959761324939,-0.5825441513392551,-0.5693403488213774,-0.5559880132685977,-0.5424906281208750,-0.5288517146596021,-0.5150748310889564,-0.5011635716076114,-0.4871215654710601,-0.4729524760447955,-0.4586599998485809,-0.4442478655920900,-0.4297198332021289,-0.4150796928417285,-0.4003312639213387,-0.3854783941024025,-0.3705249582935484,-0.3554748576396852,-0.3403320185042451,-0.3251003914448485,-0.3097839501826594,-0.2943866905656969,-0.2789126295263729,-0.2633658040335294,-0.2477502700392498,-0.2320701014207166,-0.2163293889173941,-0.2005322390638086,-0.1846827731182141,-0.1687851259874088,-0.1528434451479971,-0.1368618895643707,-0.1208446286036907,-0.1047958409481579,-0.0887197135048542,-0.0726204403134325,-0.0565022214519528,-0.0403692619411390,-0.0242257706473454,-0.0080759591845248,0.0080759591845251,0.0242257706473450,0.0403692619411387,0.0565022214519528,0.0726204403134324,0.0887197135048543,0.1047958409481582,0.1208446286036906,0.1368618895643707,0.1528434451479970,0.1687851259874083,0.1846827731182140,0.2005322390638082,0.2163293889173935,0.2320701014207161,0.2477502700392492,0.2633658040335292,0.2789126295263724,0.2943866905656969,0.3097839501826593,0.3251003914448480,0.3403320185042447,0.3554748576396849,0.3705249582935478,0.3854783941024024,0.4003312639213388,0.4150796928417285,0.4297198332021294,0.4442478655920905,0.4586599998485811,0.4729524760447950,0.4871215654710603,0.5011635716076113,0.5150748310889562,0.5288517146596020,0.5424906281208755,0.5559880132685978,0.5693403488213779,0.5825441513392555,0.5955959761324935,0.6084924181602436,0.6212301129188738,0.6338057373197279,0.6462160105560634,0.6584576949589785,0.6705275968420682,0.6824225673346185,0.6941395032030981,0.7056753476607537,0.7170270911650816,0.7281917722029769,0.7391664780633498,0.7499483455970145,0.7605345619636436,0.7709223653656013,0.7811090457684572,0.7910919456079974,0.8008684604835490,0.8104360398374307,0.8197921876203588,0.8289344629426358,0.8378604807109421,0.8465679122505787,0.8550544859129864,0.8633179876683905,0.8713562616834102,0.8791672108834943,0.8867487975000187,0.8940990436019174,0.9012160316117058,0.9080979048057569,0.9147428677987028,0.9211491870118420,0.9273151911254214,0.9332392715146823,0.9389198826695562,0.9443555425979101,0.9495448332122258,0.9544864006996373,0.9591789558752233,0.9636212745184827,0.9678121976929379,0.9717506320487982,0.9754355501086888,0.9788659905364679,0.9820410583892596,0.9849599253529936,0.9876218299621065,0.9900260778048101,0.9921720417171271,0.9940591619734233,0.9956869464940434,0.9970549711320829,0.9981628802602930,0.9990103886558188,0.9995972911893858,0.9999235651423093};

static const double w195[195] = {0.0000970762626065,0.0002259507336838,0.0003549577365408,0.0004838896613539,0.0006126999634648,0.0007413530490365,0.0008698150784365,0.0009980526694373,0.0011260326234011,0.0012537218543454,0.0013810873706350,0.0015080962731141,0.0016347157591503,0.0017609131290250,0.0018866557933437,0.0020119112809021,0.0021366472467720,0.0022608314804717,0.0023844319141866,0.0025074166309820,0.0026297538729984,0.0027514120496355,0.0028723597456847,0.0029925657294322,0.0031119989607134,0.0032306285989259,0.0033484240109839,0.0034653547792312,0.0035813907092887,0.0036965018378529,0.0038106584404299,0.0039238310390126,0.0040359904096876,0.0041471075901846,0.0042571538873554,0.0043661008845800,0.0044739204491030,0.0045805847393052,0.0046860662118837,0.0047903376289704,0.0048933720651621,0.0049951429144765,0.0050956238972178,0.0051947890667662,0.0052926128162783,0.0053890698852958,0.0054841353662711,0.0055777847110003,0.0056699937369575,0.0057607386335444,0.0058499959682342,0.0059377426926265,0.0060239561483965,0.0061086140731454,0.0061916946061513,0.0062731762940139,0.0063530380961894,0.0064312593904334,0.0065078199781165,0.0065827000894446,0.0066558803885638,0.0067273419785516,0.0067970664062989,0.0068650356672741,0.0069312322101717,0.0069956389414444,0.0070582392297170,0.0071190169100841,0.0071779562882784,0.0072350421447296,0.0072902597384886,0.0073435948110407,0.0073950335899788,0.0074445627925692,0.0074921696291735,0.0075378418065587,0.0075815675310617,0.0076233355116458,0.0076631349628091,0.0077009556073711,0.0077367876791283,0.0077706219253730,0.0078024496092859,0.0078322625121898,0.0078600529356726,0.0078858137035758,0.0079095381638473,0.0079312201902562,0.0079508541839817,0.0079684350750507,0.0079839583236532,0.0079974199213104,0.0080088163919135,0.0080181447926173,0.0080254027146051,0.0080305882837041,0.0080337001608758,0.0080347375425588,0.0080337001608753,0.0080305882837039,0.0080254027146045,0.0080181447926178,0.0080088163919132,0.0079974199213104,0.0079839583236533,0.0079684350750506,0.0079508541839819,0.0079312201902563,0.0079095381638468,0.0078858137035762,0.0078600529356730,0.0078322625121900,0.0078024496092857,0.0077706219253730,0.0077367876791281,0.0077009556073714,0.0076631349628086,0.0076233355116458,0.0075815675310615,0.0075378418065580,0.0074921696291739,0.0074445627925687,0.0073950335899792,0.0073435948110406,0.0072902597384891,0.0072350421447290,0.0071779562882784,0.0071190169100840,0.0070582392297171,0.0069956389414445,0.0069312322101717,0.0068650356672746,0.0067970664062987,0.0067273419785513,0.0066558803885631,0.0065827000894446,0.0065078199781164,0.0064312593904337,0.0063530380961899,0.0062731762940135,0.0061916946061514,0.0061086140731453,0.0060239561483967,0.0059377426926262,0.0058499959682349,0.0057607386335442,0.0056699937369575,0.0055777847110005,0.0054841353662714,0.0053890698852951,0.0052926128162779,0.0051947890667663,0.0050956238972174,0.0049951429144766,0.0048933720651628,0.0047903376289707,0.0046860662118836,0.0045805847393054,0.0044739204491036,0.0043661008845801,0.0042571538873560,0.0041471075901847,0.0040359904096875,0.0039238310390120,0.0038106584404303,0.0036965018378528,0.0035813907092885,0.0034653547792309,0.0033484240109842,0.0032306285989254,0.0031119989607134,0.0029925657294315,0.0028723597456849,0.0027514120496351,0.0026297538729981,0.0025074166309817,0.0023844319141873,0.0022608314804721,0.0021366472467713,0.0020119112809022,0.0018866557933431,0.0017609131290253,0.0016347157591505,0.0015080962731147,0.0013810873706351,0.0012537218543453,0.0011260326234010,0.0009980526694371,0.0008698150784360,0.0007413530490363,0.0006126999634650,0.0004838896613537,0.0003549577365402,0.0002259507336840,0.0000970762626066};
static const double pts195[195] = {-0.9999243450731997,-0.9996014001541120,-0.9990204849938386,-0.9981816205332866,-0.9970850075765951,-0.9957309255193322,-0.9941197227596970,-0.9922518148348787,-0.9901276838423655,-0.9877478781586817,-0.9851130122367964,-0.9822237664208222,-0.9790808867575865,-0.9756851847974449,-0.9720375373811490,-0.9681388864113820,-0.9639902386083204,-0.9595926652489125,-0.9549473018897764,-0.9500553480736467,-0.9449180670194187,-0.9395367852958044,-0.9339128924786798,-0.9280478407921902,-0.9219431447336970,-0.9156003806826605,-0.9090211864935515,-0.9022072610728947,-0.8951603639405551,-0.8878823147753752,-0.8803749929452789,-0.8726403370219641,-0.8646803442803145,-0.8564970701826466,-0.8480926278479380,-0.8394691875061636,-0.8306289759378898,-0.8215742758992614,-0.8123074255325389,-0.8028308177623319,-0.7931468996776861,-0.7832581719001852,-0.7731671879382305,-0.7628765535276604,-0.7523889259588877,-0.7417070133907203,-0.7308335741510524,-0.7197714160245932,-0.7085233955278313,-0.6970924171714118,-0.6854814327101217,-0.6736934403806750,-0.6617314841274951,-0.6495986528166963,-0.6372980794384608,-0.6248329402980278,-0.6122064541954934,-0.5994218815946384,-0.5864825237809971,-0.5733917220093860,-0.5601528566411124,-0.5467693462710814,-0.5332446468450344,-0.5195822507671390,-0.5057856859981624,-0.4918585151444728,-0.4778043345380859,-0.4636267733080000,-0.4493294924430797,-0.4349161838466858,-0.4203905693833441,-0.4057563999176713,-0.3910174543458065,-0.3761775386196122,-0.3612404847638852,-0.3462101498868325,-0.3310904151840756,-0.3158851849364329,-0.3005983855017360,-0.2852339643009527,-0.2697958887988658,-0.2542881454795791,-0.2387147388171101,-0.2230796902413373,-0.2073870370995711,-0.1916408316140130,-0.1758451398353735,-0.1600040405929194,-0.1441216244412227,-0.1282019926038788,-0.1122492559144723,-0.0962675337550607,-0.0802609529924509,-0.0642336469125411,-0.0481897541530065,-0.0321334176346060,-0.0160687834913760,-0.0000000000000000,0.0160687834913765,0.0321334176346069,0.0481897541530075,0.0642336469125414,0.0802609529924513,0.0962675337550610,0.1122492559144722,0.1282019926038788,0.1441216244412229,0.1600040405929199,0.1758451398353736,0.1916408316140130,0.2073870370995710,0.2230796902413374,0.2387147388171098,0.2542881454795794,0.2697958887988655,0.2852339643009524,0.3005983855017361,0.3158851849364326,0.3310904151840758,0.3462101498868325,0.3612404847638848,0.3761775386196123,0.3910174543458065,0.4057563999176709,0.4203905693833439,0.4349161838466851,0.4493294924430795,0.4636267733080002,0.4778043345380851,0.4918585151444727,0.5057856859981622,0.5195822507671385,0.5332446468450351,0.5467693462710814,0.5601528566411115,0.5733917220093849,0.5864825237809964,0.5994218815946383,0.6122064541954936,0.6248329402980283,0.6372980794384607,0.6495986528166962,0.6617314841274948,0.6736934403806748,0.6854814327101215,0.6970924171714112,0.7085233955278313,0.7197714160245934,0.7308335741510523,0.7417070133907203,0.7523889259588874,0.7628765535276600,0.7731671879382301,0.7832581719001849,0.7931468996776856,0.8028308177623316,0.8123074255325387,0.8215742758992612,0.8306289759378898,0.8394691875061642,0.8480926278479382,0.8564970701826470,0.8646803442803150,0.8726403370219640,0.8803749929452785,0.8878823147753754,0.8951603639405551,0.9022072610728945,0.9090211864935513,0.9156003806826610,0.9219431447336974,0.9280478407921906,0.9339128924786800,0.9395367852958049,0.9449180670194192,0.9500553480736470,0.9549473018897762,0.9595926652489135,0.9639902386083204,0.9681388864113830,0.9720375373811493,0.9756851847974445,0.9790808867575863,0.9822237664208219,0.9851130122367971,0.9877478781586821,0.9901276838423655,0.9922518148348782,0.9941197227596972,0.9957309255193322,0.9970850075765948,0.9981816205332863,0.9990204849938384,0.9996014001541119,0.9999243450731997};

static const double w196[196] = {0.0000960907499035,0.0002236571391343,0.0003513553008028,0.0004789800673867,0.0006064857008765,0.0007338373022668,0.0008610017081310,0.0009879462068151,0.0011146382672298,0.0012410454684741,0.0013671354815329,0.0014928760672659,0.0016182350802364,0.0017431804748754,0.0018676803126430,0.0019917027696546,0.0021152161445113,0.0022381888662316,0.0023605895022185,0.0024823867662289,0.0026035495263255,0.0027240468128175,0.0028438478261505,0.0029629219447687,0.0030812387329365,0.0031987679485096,0.0033154795506618,0.0034313437075608,0.0035463308039909,0.0036604114489192,0.0037735564830106,0.0038857369860770,0.0039969242844693,0.0041070899584081,0.0042162058492430,0.0043242440666544,0.0044311769957796,0.0045369773042710,0.0046416179492836,0.0047450721843843,0.0048473135663916,0.0049483159621340,0.0050480535551252,0.0051465008521690,0.0052436326898718,0.0053394242410742,0.0054338510212002,0.0055268888945105,0.0056185140802738,0.0057087031588503,0.0057974330776671,0.0058846811571220,0.0059704250963693,0.0060546429790309,0.0061373132787900,0.0062184148648963,0.0062979270075682,0.0063758293832893,0.0064521020800035,0.0065267256022070,0.0065996808759271,0.0066709492535999,0.0067405125188384,0.0068083528910866,0.0068744530301636,0.0069387960406984,0.0070013654764430,0.0070621453444849,0.0071211201093257,0.0071782746968592,0.0072335944982203,0.0072870653735194,0.0073386736554569,0.0073884061528201,0.0074362501538483,0.0074821934294883,0.0075262242365146,0.0075683313205370,0.0076085039188717,0.0076467317632945,0.0076830050826675,0.0077173146054327,0.0077496515619840,0.0077800076869100,0.0078083752211042,0.0078347469137482,0.0078591160241671,0.0078814763235508,0.0079018220965488,0.0079201481427254,0.0079364497778947,0.0079507228353162,0.0079629636667567,0.0079731691434289,0.0079813366567837,0.0079874641191842,0.0079915499644341,0.0079935931481809,0.0079935931481808,0.0079915499644339,0.0079874641191840,0.0079813366567833,0.0079731691434286,0.0079629636667574,0.0079507228353156,0.0079364497778952,0.0079201481427257,0.0079018220965483,0.0078814763235512,0.0078591160241668,0.0078347469137472,0.0078083752211039,0.0077800076869103,0.0077496515619843,0.0077173146054323,0.0076830050826677,0.0076467317632945,0.0076085039188709,0.0075683313205377,0.0075262242365150,0.0074821934294880,0.0074362501538489,0.0073884061528202,0.0073386736554567,0.0072870653735186,0.0072335944982198,0.0071782746968596,0.0071211201093258,0.0070621453444848,0.0070013654764431,0.0069387960406976,0.0068744530301642,0.0068083528910866,0.0067405125188385,0.0066709492535994,0.0065996808759267,0.0065267256022069,0.0064521020800041,0.0063758293832892,0.0062979270075683,0.0062184148648964,0.0061373132787895,0.0060546429790307,0.0059704250963694,0.0058846811571221,0.0057974330776674,0.0057087031588503,0.0056185140802741,0.0055268888945093,0.0054338510212000,0.0053394242410744,0.0052436326898718,0.0051465008521684,0.0050480535551250,0.0049483159621336,0.0048473135663923,0.0047450721843845,0.0046416179492832,0.0045369773042713,0.0044311769957799,0.0043242440666547,0.0042162058492426,0.0041070899584081,0.0039969242844698,0.0038857369860770,0.0037735564830105,0.0036604114489195,0.0035463308039912,0.0034313437075612,0.0033154795506617,0.0031987679485092,0.0030812387329357,0.0029629219447688,0.0028438478261502,0.0027240468128187,0.0026035495263263,0.0024823867662282,0.0023605895022187,0.0022381888662319,0.0021152161445108,0.0019917027696545,0.0018676803126438,0.0017431804748758,0.0016182350802361,0.0014928760672656,0.0013671354815330,0.0012410454684742,0.0011146382672298,0.0009879462068148,0.0008610017081310,0.0007338373022666,0.0006064857008766,0.0004789800673865,0.0003513553008029,0.0002236571391343,0.0000960907499031};
static const double pts196[196] = {-0.9999251131273054,-0.9996054465519936,-0.9990304276155132,-0.9982000755392083,-0.9971145869128996,-0.9957742354523369,-0.9941793625092084,-0.9923303752282283,-0.9902277459764678,-0.9878720120674286,-0.9852637755633459,-0.9824037030949246,-0.9792925256783408,-0.9759310385219108,-0.9723201008193012,-0.9684606355278967,-0.9643536291316837,-0.9600001313883519,-0.9554012550604988,-0.9505581756308913,-0.9454721310017993,-0.9401444211784398,-0.9345764079365897,-0.9287695144744438,-0.9227252250487840,-0.9164450845955685,-0.9099306983350052,-0.9031837313612373,-0.8962059082167229,-0.8889990124514248,-0.8815648861669194,-0.8739054295455443,-0.8660226003647020,-0.8579184134964392,-0.8495949403924359,-0.8410543085545370,-0.8322987009909537,-0.8233303556582746,-0.8141515648894421,-0.8047646748078215,-0.7951720847275235,-0.7853762465401349,-0.7753796640880061,-0.7651848925242618,-0.7547945376596963,-0.7442112552967218,-0.7334377505505354,-0.7224767771576878,-0.7113311367722169,-0.7000036782495407,-0.6884972969182779,-0.6768149338401968,-0.6649595750584728,-0.6529342508344451,-0.6407420348730751,-0.6283860435372985,-0.6158694350514740,-0.6031954086941362,-0.5903672039802448,-0.5773880998331624,-0.5642614137465486,-0.5509905009364022,-0.5375787534834574,-0.5240295994661609,-0.5103465020844428,-0.4965329587745153,-0.4825925003149189,-0.4685286899240437,-0.4543451223493664,-0.4400454229486171,-0.4256332467631320,-0.4111122775836137,-0.3964862270085433,-0.3817588334954901,-0.3669338614055471,-0.3520151000411527,-0.3370063626775335,-0.3219114855880229,-0.3067343270634985,-0.2914787664261909,-0.2761487030381227,-0.2607480553044150,-0.2452807596717395,-0.2297507696221470,-0.2141620546625490,-0.1985185993101009,-0.1828244020737488,-0.1670834744322003,-0.1512998398085783,-0.1354775325420254,-0.1196205968565147,-0.1037330858271343,-0.0878190603441137,-0.0718825880748472,-0.0559277424241866,-0.0399586014932705,-0.0239792470371476,-0.0079937634214721,0.0079937634214720,0.0239792470371472,0.0399586014932698,0.0559277424241863,0.0718825880748468,0.0878190603441135,0.1037330858271338,0.1196205968565141,0.1354775325420254,0.1512998398085786,0.1670834744322003,0.1828244020737485,0.1985185993101004,0.2141620546625487,0.2297507696221466,0.2452807596717393,0.2607480553044150,0.2761487030381224,0.2914787664261910,0.3067343270634982,0.3219114855880227,0.3370063626775334,0.3520151000411524,0.3669338614055468,0.3817588334954899,0.3964862270085435,0.4111122775836134,0.4256332467631321,0.4400454229486177,0.4543451223493666,0.4685286899240438,0.4825925003149183,0.4965329587745154,0.5103465020844427,0.5240295994661621,0.5375787534834580,0.5509905009364024,0.5642614137465487,0.5773880998331625,0.5903672039802446,0.6031954086941367,0.6158694350514745,0.6283860435372989,0.6407420348730755,0.6529342508344456,0.6649595750584733,0.6768149338401970,0.6884972969182782,0.7000036782495404,0.7113311367722173,0.7224767771576877,0.7334377505505353,0.7442112552967213,0.7547945376596961,0.7651848925242618,0.7753796640880058,0.7853762465401350,0.7951720847275233,0.8047646748078208,0.8141515648894423,0.8233303556582745,0.8322987009909530,0.8410543085545369,0.8495949403924352,0.8579184134964385,0.8660226003647015,0.8739054295455440,0.8815648861669187,0.8889990124514245,0.8962059082167227,0.9031837313612371,0.9099306983350054,0.9164450845955684,0.9227252250487846,0.9287695144744434,0.9345764079365898,0.9401444211784394,0.9454721310017994,0.9505581756308916,0.9554012550604992,0.9600001313883524,0.9643536291316840,0.9684606355278969,0.9723201008193009,0.9759310385219108,0.9792925256783411,0.9824037030949251,0.9852637755633463,0.9878720120674290,0.9902277459764681,0.9923303752282279,0.9941793625092081,0.9957742354523369,0.9971145869128999,0.9982000755392092,0.9990304276155141,0.9996054465519941,0.9999251131273054};

static const double w197[197] = {0.0000951201685468,0.0002213982895708,0.0003478074234475,0.0004741448012428,0.0006003654726903,0.0007264352164159,0.0008523215283061,0.0009779923505059,0.0011034158027804,0.0012285601126877,0.0013533935972980,0.0014778846610376,0.0016020017993185,0.0017257136044737,0.0018489887726925,0.0019717961114001,0.0020941045468547,0.0022158831318427,0.0023371010533981,0.0024577276405430,0.0025777323720045,0.0026970848839109,0.0028157549774574,0.0029337126265366,0.0030509279853247,0.0031673713958320,0.0032830133953955,0.0033978247241395,0.0035117763323707,0.0036248393879281,0.0037369852834767,0.0038481856437484,0.0039584123327155,0.0040676374607112,0.0041758333914884,0.0042829727492088,0.0043890284253695,0.0044939735856632,0.0045977816767676,0.0047004264330623,0.0048018818832771,0.0049021223570588,0.0050011224914714,0.0050988572374113,0.0051953018659422,0.0052904319745569,0.0053842234933490,0.0054766526911024,0.0055676961812991,0.0056573309280313,0.0057455342518359,0.0058322838354261,0.0059175577293463,0.0060013343575172,0.0060835925227015,0.0061643114118642,0.0062434706014393,0.0063210500624968,0.0063970301658124,0.0064713916868304,0.0065441158105363,0.0066151841362010,0.0066845786820574,0.0067522818898330,0.0068182766292019,0.0068825462021164,0.0069450743470314,0.0070058452430175,0.0070648435137716,0.0071220542314954,0.0071774629206830,0.0072310555617775,0.0072828185947220,0.0073327389223870,0.0073808039138852,0.0074270014077708,0.0074713197151114,0.0075137476224509,0.0075542743946406,0.0075928897775598,0.0076295840007111,0.0076643477796883,0.0076971723185295,0.0077280493119403,0.0077569709473966,0.0077839299071189,0.0078089193699286,0.0078319330129686,0.0078529650133062,0.0078720100494056,0.0078890633024763,0.0079041204576868,0.0079171777052638,0.0079282317414500,0.0079372797693435,0.0079443194996040,0.0079493491510326,0.0079523674510235,0.0079533736358821,0.0079523674510233,0.0079493491510325,0.0079443194996046,0.0079372797693436,0.0079282317414496,0.0079171777052645,0.0079041204576870,0.0078890633024760,0.0078720100494060,0.0078529650133055,0.0078319330129689,0.0078089193699287,0.0077839299071189,0.0077569709473963,0.0077280493119406,0.0076971723185298,0.0076643477796882,0.0076295840007108,0.0075928897775596,0.0075542743946402,0.0075137476224505,0.0074713197151122,0.0074270014077706,0.0073808039138852,0.0073327389223869,0.0072828185947223,0.0072310555617778,0.0071774629206824,0.0071220542314954,0.0070648435137710,0.0070058452430184,0.0069450743470310,0.0068825462021164,0.0068182766292026,0.0067522818898331,0.0066845786820575,0.0066151841362013,0.0065441158105355,0.0064713916868315,0.0063970301658117,0.0063210500624964,0.0062434706014383,0.0061643114118644,0.0060835925227021,0.0060013343575174,0.0059175577293464,0.0058322838354263,0.0057455342518355,0.0056573309280311,0.0055676961812992,0.0054766526911023,0.0053842234933488,0.0052904319745570,0.0051953018659421,0.0050988572374112,0.0050011224914718,0.0049021223570589,0.0048018818832763,0.0047004264330627,0.0045977816767676,0.0044939735856632,0.0043890284253685,0.0042829727492087,0.0041758333914886,0.0040676374607116,0.0039584123327154,0.0038481856437485,0.0037369852834769,0.0036248393879275,0.0035117763323706,0.0033978247241394,0.0032830133953958,0.0031673713958314,0.0030509279853252,0.0029337126265366,0.0028157549774578,0.0026970848839112,0.0025777323720046,0.0024577276405429,0.0023371010533983,0.0022158831318422,0.0020941045468548,0.0019717961113995,0.0018489887726926,0.0017257136044740,0.0016020017993184,0.0014778846610374,0.0013533935972982,0.0012285601126878,0.0011034158027808,0.0009779923505057,0.0008523215283064,0.0007264352164156,0.0006003654726898,0.0004741448012429,0.0003478074234472,0.0002213982895709,0.0000951201685469};
static const double pts197[197] = {-0.9999258695445530,-0.9996094316468536,-0.9990402196253492,-0.9982182510380803,-0.9971437183680022,-0.9958168897940625,-0.9942380997984824,-0.9924077473441983,-0.9903262953120304,-0.9879942702299422,-0.9854122620800719,-0.9825809241233474,-0.9795009727217120,-0.9761731871504639,-0.9725984093975798,-0.9687775439486763,-0.9647115575569605,-0.9604014789978842,-0.9558483988083668,-0.9510534690105591,-0.9460179028201480,-0.9407429743392457,-0.9352300182339153,-0.9294804293964004,-0.9234956625921373,-0.9172772320916294,-0.9108267112872790,-0.9041457322952650,-0.8972359855425640,-0.8900992193392279,-0.8827372394360156,-0.8751519085674889,-0.8673451459806989,-0.8593189269495730,-0.8510752822751204,-0.8426162977715965,-0.8339441137387510,-0.8250609244202747,-0.8159689774486180,-0.8066705732762858,-0.7971680645937755,-0.7874638557342981,-0.7775604020654272,-0.7674602093678420,-0.7571658332013096,-0.7466798782580754,-0.7360049977038233,-0.7251438925063654,-0.7140993107522428,-0.7028740469514005,-0.6914709413301178,-0.6798928791123741,-0.6681427897898238,-0.6562236463805742,-0.6441384646769507,-0.6318903024824370,-0.6194822588379886,-0.6069174732379082,-0.5941991248354893,-0.5813304316386255,-0.5683146496955810,-0.5551550722711520,-0.5418550290133932,-0.5284178851111536,-0.5148470404426061,-0.5011459287150154,-0.4873180165959328,-0.4733668028360576,-0.4592958173839831,-0.4451086204930428,-0.4308088018204921,-0.4163999795192506,-0.4018857993224352,-0.3872699336209103,-0.3725560805340989,-0.3577479629742786,-0.3428493277046114,-0.3278639443911290,-0.3127956046489315,-0.2976481210828296,-0.2824253263226740,-0.2671310720536225,-0.2517692280415813,-0.2363436811540747,-0.2208583343767841,-0.2053171058260136,-0.1897239277573236,-0.1740827455705889,-0.1583975168117277,-0.1426722101713628,-0.1269108044806566,-0.1111172877045880,-0.0952956559329100,-0.0794499123690574,-0.0635840663172517,-0.0477021321680645,-0.0318081283826923,-0.0159060764762013,0.0000000000000000,0.0159060764762003,0.0318081283826919,0.0477021321680637,0.0635840663172514,0.0794499123690570,0.0952956559329100,0.1111172877045881,0.1269108044806564,0.1426722101713625,0.1583975168117278,0.1740827455705892,0.1897239277573239,0.2053171058260135,0.2208583343767839,0.2363436811540743,0.2517692280415811,0.2671310720536225,0.2824253263226740,0.2976481210828295,0.3127956046489314,0.3278639443911289,0.3428493277046114,0.3577479629742785,0.3725560805340982,0.3872699336209103,0.4018857993224350,0.4163999795192509,0.4308088018204926,0.4451086204930430,0.4592958173839832,0.4733668028360571,0.4873180165959318,0.5011459287150146,0.5148470404426061,0.5284178851111534,0.5418550290133938,0.5551550722711527,0.5683146496955817,0.5813304316386257,0.5941991248354904,0.6069174732379085,0.6194822588379895,0.6318903024824376,0.6441384646769507,0.6562236463805735,0.6681427897898233,0.6798928791123737,0.6914709413301177,0.7028740469514003,0.7140993107522423,0.7251438925063661,0.7360049977038234,0.7466798782580756,0.7571658332013095,0.7674602093678415,0.7775604020654278,0.7874638557342984,0.7971680645937759,0.8066705732762858,0.8159689774486177,0.8250609244202747,0.8339441137387507,0.8426162977715971,0.8510752822751195,0.8593189269495727,0.8673451459806991,0.8751519085674885,0.8827372394360157,0.8900992193392282,0.8972359855425637,0.9041457322952652,0.9108267112872797,0.9172772320916300,0.9234956625921374,0.9294804293964013,0.9352300182339157,0.9407429743392461,0.9460179028201481,0.9510534690105592,0.9558483988083675,0.9604014789978844,0.9647115575569604,0.9687775439486760,0.9725984093975797,0.9761731871504642,0.9795009727217127,0.9825809241233470,0.9854122620800720,0.9879942702299419,0.9903262953120301,0.9924077473441983,0.9942380997984818,0.9958168897940627,0.9971437183680025,0.9982182510380806,0.9990402196253489,0.9996094316468537,0.9999258695445529};

static const double w198[198] = {0.0000941642184257,0.0002191734867635,0.0003443130084198,0.0004693823703914,0.0005943373917854,0.0007191445121752,0.0008437718703753,0.0009681880460496,0.0010923617936235,0.0012162619729909,0.0013398575312619,0.0014631175004711,0.0015860110010133,0.0017085072473623,0.0018305755547815,0.0019521853464708,0.0020733061609413,0.0021939076594680,0.0023139596335911,0.0024334320126180,0.0025522948711190,0.0026705184363920,0.0027880730959069,0.0029049294047077,0.0030210580927848,0.0031364300723942,0.0032510164453454,0.0033647885102336,0.0034777177696265,0.0035897759372016,0.0037009349448324,0.0038111669496110,0.0039204443408292,0.0040287397468918,0.0041360260421673,0.0042422763537882,0.0043474640683779,0.0044515628387195,0.0045545465903530,0.0046563895281048,0.0047570661425535,0.0048565512164159,0.0049548198308606,0.0050518473717588,0.0051476095358386,0.0052420823367787,0.0053352421112171,0.0054270655246734,0.0055175295773993,0.0056066116101339,0.0056942893097845,0.0057805407150107,0.0058653442217300,0.0059486785885251,0.0060305229419658,0.0061108567818391,0.0061896599862827,0.0062669128168225,0.0063425959233208,0.0064166903488222,0.0064891775342973,0.0065600393233007,0.0066292579665076,0.0066968161261697,0.0067626968804504,0.0068268837276662,0.0068893605904233,0.0069501118196378,0.0070091221984606,0.0070663769460891,0.0071218617214650,0.0071755626268702,0.0072274662114082,0.0072775594743689,0.0073258298684912,0.0073722653031017,0.0074168541471425,0.0074595852320867,0.0075004478547372,0.0075394317799051,0.0075765272429710,0.0076117249523367,0.0076450160917493,0.0076763923225087,0.0077058457855582,0.0077333691034528,0.0077589553822053,0.0077825982130146,0.0078042916738704,0.0078240303310374,0.0078418092404167,0.0078576239487792,0.0078714704948898,0.0078833454104912,0.0078932457211800,0.0079011689471445,0.0079071131037903,0.0079110767022361,0.0079130587496887,0.0079130587496889,0.0079110767022366,0.0079071131037900,0.0079011689471440,0.0078932457211802,0.0078833454104916,0.0078714704948893,0.0078576239487791,0.0078418092404163,0.0078240303310374,0.0078042916738709,0.0077825982130141,0.0077589553822051,0.0077333691034529,0.0077058457855586,0.0076763923225082,0.0076450160917490,0.0076117249523363,0.0075765272429709,0.0075394317799052,0.0075004478547376,0.0074595852320868,0.0074168541471419,0.0073722653031016,0.0073258298684912,0.0072775594743698,0.0072274662114079,0.0071755626268709,0.0071218617214646,0.0070663769460896,0.0070091221984609,0.0069501118196381,0.0068893605904230,0.0068268837276661,0.0067626968804501,0.0066968161261703,0.0066292579665079,0.0065600393233004,0.0064891775342978,0.0064166903488218,0.0063425959233211,0.0062669128168226,0.0061896599862830,0.0061108567818396,0.0060305229419659,0.0059486785885246,0.0058653442217300,0.0057805407150106,0.0056942893097840,0.0056066116101340,0.0055175295773989,0.0054270655246738,0.0053352421112167,0.0052420823367788,0.0051476095358380,0.0050518473717587,0.0049548198308610,0.0048565512164157,0.0047570661425541,0.0046563895281054,0.0045545465903529,0.0044515628387194,0.0043474640683782,0.0042422763537874,0.0041360260421675,0.0040287397468916,0.0039204443408300,0.0038111669496107,0.0037009349448323,0.0035897759372017,0.0034777177696259,0.0033647885102336,0.0032510164453455,0.0031364300723940,0.0030210580927839,0.0029049294047087,0.0027880730959062,0.0026705184363922,0.0025522948711194,0.0024334320126184,0.0023139596335906,0.0021939076594677,0.0020733061609415,0.0019521853464708,0.0018305755547811,0.0017085072473629,0.0015860110010133,0.0014631175004710,0.0013398575312619,0.0012162619729906,0.0010923617936242,0.0009681880460500,0.0008437718703756,0.0007191445121752,0.0005943373917853,0.0004693823703914,0.0003443130084200,0.0002191734867631,0.0000941642184259};
static const double pts198[198] = {-0.9999266145588409,-0.9996133566707612,-0.9990498640498713,-0.9982361526452852,-0.9971724109372956,-0.9958589017067738,-0.9942959527382048,-0.9924839550171314,-0.9904233621749774,-0.9881146902233446,-0.9855585173656188,-0.9827554838262967,-0.9797062916782671,-0.9764117046606106,-0.9728725479838347,-0.9690897081212007,-0.9650641325854930,-0.9607968296909599,-0.9562888683002851,-0.9515413775565549,-0.9465555466002239,-0.9413326242711235,-0.9358739187955517,-0.9301807974585266,-0.9242546862612537,-0.9180970695639127,-0.9117094897138233,-0.9050935466591057,-0.8982508975479107,-0.8911832563133277,-0.8838923932440714,-0.8763801345410597,-0.8686483618599813,-0.8606990118399780,-0.8525340756185555,-0.8441555983328456,-0.8355656786073392,-0.8267664680282273,-0.8177601706044728,-0.8085490422157540,-0.7991353900474147,-0.7895215720125631,-0.7797099961614681,-0.7697031200783924,-0.7595034502660220,-0.7491135415176423,-0.7385359962772167,-0.7277734639875343,-0.7168286404265765,-0.7057042670322904,-0.6944031302159133,-0.6829280606640414,-0.6712819326296009,-0.6594676632119152,-0.6474882116260313,-0.6353465784615044,-0.6230458049308140,-0.6105889721076064,-0.5979792001549559,-0.5852196475438300,-0.5723135102619649,-0.5592640210133367,-0.5460744484084405,-0.5327480961455785,-0.5192883021833531,-0.5056984379045828,-0.4919819072718451,-0.4781421459748577,-0.4641826205699129,-0.4501068276115829,-0.4359182927769096,-0.4216205699822999,-0.4072172404933443,-0.3927119120277951,-0.3781082178519073,-0.3634098158703851,-0.3486203877101595,-0.3337436377982212,-0.3187832924337411,-0.3037430988547167,-0.2886268242993681,-0.2734382550625304,-0.2581811955472703,-0.2428594673119626,-0.2274769081130783,-0.2120373709439095,-0.1965447230694769,-0.1810028450578680,-0.1654156298082378,-0.1497869815757265,-0.1341208149935220,-0.1184210540923385,-0.1026916313175293,-0.0869364865440936,-0.0711595660898291,-0.0553648217268612,-0.0395562096918137,-0.0237376896948590,-0.0079132239278951,0.0079132239278955,0.0237376896948597,0.0395562096918145,0.0553648217268614,0.0711595660898294,0.0869364865440940,0.1026916313175291,0.1184210540923393,0.1341208149935221,0.1497869815757266,0.1654156298082387,0.1810028450578680,0.1965447230694768,0.2120373709439093,0.2274769081130781,0.2428594673119619,0.2581811955472695,0.2734382550625303,0.2886268242993673,0.3037430988547162,0.3187832924337409,0.3337436377982208,0.3486203877101595,0.3634098158703847,0.3781082178519075,0.3927119120277955,0.4072172404933443,0.4216205699822997,0.4359182927769098,0.4501068276115831,0.4641826205699129,0.4781421459748578,0.4919819072718455,0.5056984379045832,0.5192883021833531,0.5327480961455774,0.5460744484084401,0.5592640210133366,0.5723135102619654,0.5852196475438305,0.5979792001549556,0.6105889721076057,0.6230458049308140,0.6353465784615052,0.6474882116260320,0.6594676632119153,0.6712819326296007,0.6829280606640411,0.6944031302159133,0.7057042670322901,0.7168286404265761,0.7277734639875333,0.7385359962772169,0.7491135415176418,0.7595034502660214,0.7697031200783915,0.7797099961614675,0.7895215720125630,0.7991353900474145,0.8085490422157540,0.8177601706044731,0.8267664680282271,0.8355656786073390,0.8441555983328454,0.8525340756185552,0.8606990118399774,0.8686483618599813,0.8763801345410593,0.8838923932440713,0.8911832563133271,0.8982508975479107,0.9050935466591052,0.9117094897138228,0.9180970695639120,0.9242546862612538,0.9301807974585260,0.9358739187955514,0.9413326242711225,0.9465555466002239,0.9515413775565551,0.9562888683002855,0.9607968296909600,0.9650641325854931,0.9690897081212009,0.9728725479838357,0.9764117046606112,0.9797062916782675,0.9827554838262972,0.9855585173656191,0.9881146902233451,0.9904233621749774,0.9924839550171319,0.9942959527382041,0.9958589017067732,0.9971724109372954,0.9982361526452844,0.9990498640498713,0.9996133566707611,0.9999266145588410};

static const double w199[199] = {0.0000932226069319,0.0002169820499316,0.0003408709870516,0.0004646913195691,0.0005883996181305,0.0007119629670621,0.0008353501322070,0.0009585303149592,0.0010814728886857,0.0012041473299715,0.0013265232003973,0.0014485701441190,0.0015702578911185,0.0016915562627109,0.0018124351780381,0.0019328646609993,0.0020528148473967,0.0021722559921694,0.0022911584766689,0.0024094928159474,0.0025272296660222,0.0026443398311314,0.0027607942709556,0.0028765641078061,0.0029916206337805,0.0031059353178729,0.0032194798130477,0.0033322259632642,0.0034441458104568,0.0035552116014659,0.0036653957949198,0.0037746710680626,0.0038830103235291,0.0039903866960628,0.0040967735591802,0.0042021445317693,0.0043064734846322,0.0044097345469680,0.0045119021127824,0.0046129508472400,0.0047128556929480,0.0048115918761657,0.0049091349129504,0.0050054606152296,0.0051005450967960,0.0051943647792334,0.0052868963977618,0.0053781170070042,0.0054680039866849,0.0055565350472268,0.0056436882352889,0.0057294419392043,0.0058137748943408,0.0058966661883729,0.0059780952664732,0.0060580419363982,0.0061364863735088,0.0062134091256742,0.0062887911181047,0.0063626136580742,0.0064348584395650,0.0065055075477965,0.0065745434636713,0.0066419490681277,0.0067077076463712,0.0067718028920273,0.0068342189111870,0.0068949402263396,0.0069539517802208,0.0070112389395363,0.0070667874986010,0.0071205836828520,0.0071726141522724,0.0072228660046902,0.0072713267789903,0.0073179844581884,0.0073628274724294,0.0074058447018387,0.0074470254792913,0.0074863595930524,0.0075238372893126,0.0075594492746004,0.0075931867180950,0.0076250412538087,0.0076550049826681,0.0076830704744660,0.0077092307697104,0.0077334793813443,0.0077558102963595,0.0077762179772847,0.0077946973635593,0.0078112438727882,0.0078258534018787,0.0078385223280576,0.0078492475097679,0.0078580262874514,0.0078648564842054,0.0078697364063225,0.0078726648437136,0.0078736410702031,0.0078726648437137,0.0078697364063226,0.0078648564842050,0.0078580262874515,0.0078492475097677,0.0078385223280574,0.0078258534018789,0.0078112438727886,0.0077946973635593,0.0077762179772848,0.0077558102963590,0.0077334793813439,0.0077092307697106,0.0076830704744663,0.0076550049826679,0.0076250412538090,0.0075931867180947,0.0075594492746006,0.0075238372893119,0.0074863595930528,0.0074470254792908,0.0074058447018384,0.0073628274724294,0.0073179844581890,0.0072713267789899,0.0072228660046904,0.0071726141522719,0.0071205836828516,0.0070667874986010,0.0070112389395365,0.0069539517802204,0.0068949402263395,0.0068342189111872,0.0067718028920277,0.0067077076463708,0.0066419490681274,0.0065745434636716,0.0065055075477955,0.0064348584395652,0.0063626136580748,0.0062887911181045,0.0062134091256744,0.0061364863735080,0.0060580419363984,0.0059780952664724,0.0058966661883734,0.0058137748943407,0.0057294419392042,0.0056436882352895,0.0055565350472268,0.0054680039866847,0.0053781170070046,0.0052868963977615,0.0051943647792335,0.0051005450967962,0.0050054606152301,0.0049091349129507,0.0048115918761655,0.0047128556929477,0.0046129508472402,0.0045119021127827,0.0044097345469681,0.0043064734846322,0.0042021445317692,0.0040967735591800,0.0039903866960628,0.0038830103235287,0.0037746710680622,0.0036653957949197,0.0035552116014652,0.0034441458104571,0.0033322259632645,0.0032194798130478,0.0031059353178730,0.0029916206337801,0.0028765641078058,0.0027607942709556,0.0026443398311317,0.0025272296660218,0.0024094928159474,0.0022911584766689,0.0021722559921690,0.0020528148473969,0.0019328646609993,0.0018124351780375,0.0016915562627110,0.0015702578911189,0.0014485701441191,0.0013265232003970,0.0012041473299712,0.0010814728886862,0.0009585303149597,0.0008353501322070,0.0007119629670624,0.0005883996181305,0.0004646913195688,0.0003408709870519,0.0002169820499313,0.0000932226069327};
static const double pts199[199] = {-0.9999273483982206,-0.9996172228249907,-0.9990593638399702,-0.9982537858359055,-0.9972006733915040,-0.9959002840241349,-0.9943529389871615,-0.9925590214870201,-0.9905189761355302,-0.9882333086890916,-0.9857025858647069,-0.9829274351738737,-0.9799085447547393,-0.9766466631951775,-0.9731425993437332,-0.9693972221070887,-0.9654114602334255,-0.9611863020813943,-0.9567227953745688,-0.9520220469413326,-0.9470852224402097,-0.9419135460706755,-0.9365083002694872,-0.9308708253926081,-0.9250025193827782,-0.9189048374228296,-0.9125792915748097,-0.9060274504050105,-0.8992509385949887,-0.8922514365386782,-0.8850306799256867,-0.8775904593108814,-0.8699326196703784,-0.8620590599440270,-0.8539717325645240,-0.8456726429732573,-0.8371638491230077,-0.8284474609676308,-0.8195256399388421,-0.8104005984102384,-0.8010745991486855,-0.7915499547532138,-0.7818290270815539,-0.7719142266644581,-0.7618080121079509,-0.7515128894836623,-0.7410314117073875,-0.7303661779060316,-0.7195198327730938,-0.7084950659128565,-0.6972946111734327,-0.6859212459688439,-0.6743777905902976,-0.6626671075068283,-0.6507921006554840,-0.6387557147212221,-0.6265609344067121,-0.6142107836922027,-0.6017083250856623,-0.5890566588633525,-0.5762589223010444,-0.5633182888960581,-0.5502379675803208,-0.5370212019246350,-0.5236712693343621,-0.5101914802367089,-0.4965851772598366,-0.4828557344039716,-0.4690065562047477,-0.4550410768889690,-0.4409627595230151,-0.4267750951540963,-0.4124816019445592,-0.3980858242994784,-0.3835913319877463,-0.3690017192568564,-0.3543206039416290,-0.3395516265670873,-0.3246984494456998,-0.3097647557692262,-0.2947542486953869,-0.2796706504295727,-0.2645177013018443,-0.2492991588394234,-0.2340187968349314,-0.2186804044105857,-0.2032877850786015,-0.1878447557980202,-0.1723551460282052,-0.1568227967792407,-0.1412515596594595,-0.1256452959203514,-0.1100078754990727,-0.0943431760588053,-0.0786550820272007,-0.0629474836331446,-0.0472242759420864,-0.0314893578901623,-0.0157466313173670,0.0000000000000000,0.0157466313173672,0.0314893578901628,0.0472242759420868,0.0629474836331449,0.0786550820272007,0.0943431760588054,0.1100078754990727,0.1256452959203521,0.1412515596594600,0.1568227967792407,0.1723551460282056,0.1878447557980211,0.2032877850786018,0.2186804044105866,0.2340187968349318,0.2492991588394242,0.2645177013018449,0.2796706504295732,0.2947542486953869,0.3097647557692270,0.3246984494457000,0.3395516265670878,0.3543206039416296,0.3690017192568563,0.3835913319877464,0.3980858242994785,0.4124816019445587,0.4267750951540973,0.4409627595230164,0.4550410768889689,0.4690065562047470,0.4828557344039713,0.4965851772598359,0.5101914802367081,0.5236712693343611,0.5370212019246347,0.5502379675803205,0.5633182888960578,0.5762589223010438,0.5890566588633526,0.6017083250856622,0.6142107836922024,0.6265609344067112,0.6387557147212217,0.6507921006554837,0.6626671075068286,0.6743777905902972,0.6859212459688437,0.6972946111734326,0.7084950659128572,0.7195198327730944,0.7303661779060320,0.7410314117073877,0.7515128894836626,0.7618080121079508,0.7719142266644582,0.7818290270815543,0.7915499547532143,0.8010745991486858,0.8104005984102389,0.8195256399388431,0.8284474609676314,0.8371638491230082,0.8456726429732573,0.8539717325645242,0.8620590599440272,0.8699326196703788,0.8775904593108820,0.8850306799256861,0.8922514365386779,0.8992509385949885,0.9060274504050102,0.9125792915748100,0.9189048374228299,0.9250025193827787,0.9308708253926086,0.9365083002694877,0.9419135460706747,0.9470852224402099,0.9520220469413325,0.9567227953745695,0.9611863020813946,0.9654114602334249,0.9693972221070885,0.9731425993437325,0.9766466631951767,0.9799085447547382,0.9829274351738735,0.9857025858647063,0.9882333086890905,0.9905189761355299,0.9925590214870197,0.9943529389871609,0.9959002840241350,0.9972006733915028,0.9982537858359052,0.9990593638399695,0.9996172228249899,0.9999273483982204};

 
 
void getLegPtsWts(size_t n, double * pts, double * wts)
 {  
	 switch (n){
		 case 2:
 			 memmove(pts,pts2,2*sizeof(double)); 
 			 memmove(wts,w2,2*sizeof(double)); 
 			 break; 
		 case 3:
 			 memmove(pts,pts3,3*sizeof(double)); 
 			 memmove(wts,w3,3*sizeof(double)); 
 			 break; 
		 case 4:
 			 memmove(pts,pts4,4*sizeof(double)); 
 			 memmove(wts,w4,4*sizeof(double)); 
 			 break; 
		 case 5:
 			 memmove(pts,pts5,5*sizeof(double)); 
 			 memmove(wts,w5,5*sizeof(double)); 
 			 break; 
		 case 6:
 			 memmove(pts,pts6,6*sizeof(double)); 
 			 memmove(wts,w6,6*sizeof(double)); 
 			 break; 
		 case 7:
 			 memmove(pts,pts7,7*sizeof(double)); 
 			 memmove(wts,w7,7*sizeof(double)); 
 			 break; 
		 case 8:
 			 memmove(pts,pts8,8*sizeof(double)); 
 			 memmove(wts,w8,8*sizeof(double)); 
 			 break; 
		 case 9:
 			 memmove(pts,pts9,9*sizeof(double)); 
 			 memmove(wts,w9,9*sizeof(double)); 
 			 break; 
		 case 10:
 			 memmove(pts,pts10,10*sizeof(double)); 
 			 memmove(wts,w10,10*sizeof(double)); 
 			 break; 
		 case 11:
 			 memmove(pts,pts11,11*sizeof(double)); 
 			 memmove(wts,w11,11*sizeof(double)); 
 			 break; 
		 case 12:
 			 memmove(pts,pts12,12*sizeof(double)); 
 			 memmove(wts,w12,12*sizeof(double)); 
 			 break; 
		 case 13:
 			 memmove(pts,pts13,13*sizeof(double)); 
 			 memmove(wts,w13,13*sizeof(double)); 
 			 break; 
		 case 14:
 			 memmove(pts,pts14,14*sizeof(double)); 
 			 memmove(wts,w14,14*sizeof(double)); 
 			 break; 
		 case 15:
 			 memmove(pts,pts15,15*sizeof(double)); 
 			 memmove(wts,w15,15*sizeof(double)); 
 			 break; 
		 case 16:
 			 memmove(pts,pts16,16*sizeof(double)); 
 			 memmove(wts,w16,16*sizeof(double)); 
 			 break; 
		 case 17:
 			 memmove(pts,pts17,17*sizeof(double)); 
 			 memmove(wts,w17,17*sizeof(double)); 
 			 break; 
		 case 18:
 			 memmove(pts,pts18,18*sizeof(double)); 
 			 memmove(wts,w18,18*sizeof(double)); 
 			 break; 
		 case 19:
 			 memmove(pts,pts19,19*sizeof(double)); 
 			 memmove(wts,w19,19*sizeof(double)); 
 			 break; 
		 case 20:
 			 memmove(pts,pts20,20*sizeof(double)); 
 			 memmove(wts,w20,20*sizeof(double)); 
 			 break; 
		 case 21:
 			 memmove(pts,pts21,21*sizeof(double)); 
 			 memmove(wts,w21,21*sizeof(double)); 
 			 break; 
		 case 22:
 			 memmove(pts,pts22,22*sizeof(double)); 
 			 memmove(wts,w22,22*sizeof(double)); 
 			 break; 
		 case 23:
 			 memmove(pts,pts23,23*sizeof(double)); 
 			 memmove(wts,w23,23*sizeof(double)); 
 			 break; 
		 case 24:
 			 memmove(pts,pts24,24*sizeof(double)); 
 			 memmove(wts,w24,24*sizeof(double)); 
 			 break; 
		 case 25:
 			 memmove(pts,pts25,25*sizeof(double)); 
 			 memmove(wts,w25,25*sizeof(double)); 
 			 break; 
		 case 26:
 			 memmove(pts,pts26,26*sizeof(double)); 
 			 memmove(wts,w26,26*sizeof(double)); 
 			 break; 
		 case 27:
 			 memmove(pts,pts27,27*sizeof(double)); 
 			 memmove(wts,w27,27*sizeof(double)); 
 			 break; 
		 case 28:
 			 memmove(pts,pts28,28*sizeof(double)); 
 			 memmove(wts,w28,28*sizeof(double)); 
 			 break; 
		 case 29:
 			 memmove(pts,pts29,29*sizeof(double)); 
 			 memmove(wts,w29,29*sizeof(double)); 
 			 break; 
		 case 30:
 			 memmove(pts,pts30,30*sizeof(double)); 
 			 memmove(wts,w30,30*sizeof(double)); 
 			 break; 
		 case 31:
 			 memmove(pts,pts31,31*sizeof(double)); 
 			 memmove(wts,w31,31*sizeof(double)); 
 			 break; 
		 case 32:
 			 memmove(pts,pts32,32*sizeof(double)); 
 			 memmove(wts,w32,32*sizeof(double)); 
 			 break; 
		 case 33:
 			 memmove(pts,pts33,33*sizeof(double)); 
 			 memmove(wts,w33,33*sizeof(double)); 
 			 break; 
		 case 34:
 			 memmove(pts,pts34,34*sizeof(double)); 
 			 memmove(wts,w34,34*sizeof(double)); 
 			 break; 
		 case 35:
 			 memmove(pts,pts35,35*sizeof(double)); 
 			 memmove(wts,w35,35*sizeof(double)); 
 			 break; 
		 case 36:
 			 memmove(pts,pts36,36*sizeof(double)); 
 			 memmove(wts,w36,36*sizeof(double)); 
 			 break; 
		 case 37:
 			 memmove(pts,pts37,37*sizeof(double)); 
 			 memmove(wts,w37,37*sizeof(double)); 
 			 break; 
		 case 38:
 			 memmove(pts,pts38,38*sizeof(double)); 
 			 memmove(wts,w38,38*sizeof(double)); 
 			 break; 
		 case 39:
 			 memmove(pts,pts39,39*sizeof(double)); 
 			 memmove(wts,w39,39*sizeof(double)); 
 			 break; 
		 case 40:
 			 memmove(pts,pts40,40*sizeof(double)); 
 			 memmove(wts,w40,40*sizeof(double)); 
 			 break; 
		 case 41:
 			 memmove(pts,pts41,41*sizeof(double)); 
 			 memmove(wts,w41,41*sizeof(double)); 
 			 break; 
		 case 42:
 			 memmove(pts,pts42,42*sizeof(double)); 
 			 memmove(wts,w42,42*sizeof(double)); 
 			 break; 
		 case 43:
 			 memmove(pts,pts43,43*sizeof(double)); 
 			 memmove(wts,w43,43*sizeof(double)); 
 			 break; 
		 case 44:
 			 memmove(pts,pts44,44*sizeof(double)); 
 			 memmove(wts,w44,44*sizeof(double)); 
 			 break; 
		 case 45:
 			 memmove(pts,pts45,45*sizeof(double)); 
 			 memmove(wts,w45,45*sizeof(double)); 
 			 break; 
		 case 46:
 			 memmove(pts,pts46,46*sizeof(double)); 
 			 memmove(wts,w46,46*sizeof(double)); 
 			 break; 
		 case 47:
 			 memmove(pts,pts47,47*sizeof(double)); 
 			 memmove(wts,w47,47*sizeof(double)); 
 			 break; 
		 case 48:
 			 memmove(pts,pts48,48*sizeof(double)); 
 			 memmove(wts,w48,48*sizeof(double)); 
 			 break; 
		 case 49:
 			 memmove(pts,pts49,49*sizeof(double)); 
 			 memmove(wts,w49,49*sizeof(double)); 
 			 break; 
		 case 50:
 			 memmove(pts,pts50,50*sizeof(double)); 
 			 memmove(wts,w50,50*sizeof(double)); 
 			 break; 
		 case 51:
 			 memmove(pts,pts51,51*sizeof(double)); 
 			 memmove(wts,w51,51*sizeof(double)); 
 			 break; 
		 case 52:
 			 memmove(pts,pts52,52*sizeof(double)); 
 			 memmove(wts,w52,52*sizeof(double)); 
 			 break; 
		 case 53:
 			 memmove(pts,pts53,53*sizeof(double)); 
 			 memmove(wts,w53,53*sizeof(double)); 
 			 break; 
		 case 54:
 			 memmove(pts,pts54,54*sizeof(double)); 
 			 memmove(wts,w54,54*sizeof(double)); 
 			 break; 
		 case 55:
 			 memmove(pts,pts55,55*sizeof(double)); 
 			 memmove(wts,w55,55*sizeof(double)); 
 			 break; 
		 case 56:
 			 memmove(pts,pts56,56*sizeof(double)); 
 			 memmove(wts,w56,56*sizeof(double)); 
 			 break; 
		 case 57:
 			 memmove(pts,pts57,57*sizeof(double)); 
 			 memmove(wts,w57,57*sizeof(double)); 
 			 break; 
		 case 58:
 			 memmove(pts,pts58,58*sizeof(double)); 
 			 memmove(wts,w58,58*sizeof(double)); 
 			 break; 
		 case 59:
 			 memmove(pts,pts59,59*sizeof(double)); 
 			 memmove(wts,w59,59*sizeof(double)); 
 			 break; 
		 case 60:
 			 memmove(pts,pts60,60*sizeof(double)); 
 			 memmove(wts,w60,60*sizeof(double)); 
 			 break; 
		 case 61:
 			 memmove(pts,pts61,61*sizeof(double)); 
 			 memmove(wts,w61,61*sizeof(double)); 
 			 break; 
		 case 62:
 			 memmove(pts,pts62,62*sizeof(double)); 
 			 memmove(wts,w62,62*sizeof(double)); 
 			 break; 
		 case 63:
 			 memmove(pts,pts63,63*sizeof(double)); 
 			 memmove(wts,w63,63*sizeof(double)); 
 			 break; 
		 case 64:
 			 memmove(pts,pts64,64*sizeof(double)); 
 			 memmove(wts,w64,64*sizeof(double)); 
 			 break; 
		 case 65:
 			 memmove(pts,pts65,65*sizeof(double)); 
 			 memmove(wts,w65,65*sizeof(double)); 
 			 break; 
		 case 66:
 			 memmove(pts,pts66,66*sizeof(double)); 
 			 memmove(wts,w66,66*sizeof(double)); 
 			 break; 
		 case 67:
 			 memmove(pts,pts67,67*sizeof(double)); 
 			 memmove(wts,w67,67*sizeof(double)); 
 			 break; 
		 case 68:
 			 memmove(pts,pts68,68*sizeof(double)); 
 			 memmove(wts,w68,68*sizeof(double)); 
 			 break; 
		 case 69:
 			 memmove(pts,pts69,69*sizeof(double)); 
 			 memmove(wts,w69,69*sizeof(double)); 
 			 break; 
		 case 70:
 			 memmove(pts,pts70,70*sizeof(double)); 
 			 memmove(wts,w70,70*sizeof(double)); 
 			 break; 
		 case 71:
 			 memmove(pts,pts71,71*sizeof(double)); 
 			 memmove(wts,w71,71*sizeof(double)); 
 			 break; 
		 case 72:
 			 memmove(pts,pts72,72*sizeof(double)); 
 			 memmove(wts,w72,72*sizeof(double)); 
 			 break; 
		 case 73:
 			 memmove(pts,pts73,73*sizeof(double)); 
 			 memmove(wts,w73,73*sizeof(double)); 
 			 break; 
		 case 74:
 			 memmove(pts,pts74,74*sizeof(double)); 
 			 memmove(wts,w74,74*sizeof(double)); 
 			 break; 
		 case 75:
 			 memmove(pts,pts75,75*sizeof(double)); 
 			 memmove(wts,w75,75*sizeof(double)); 
 			 break; 
		 case 76:
 			 memmove(pts,pts76,76*sizeof(double)); 
 			 memmove(wts,w76,76*sizeof(double)); 
 			 break; 
		 case 77:
 			 memmove(pts,pts77,77*sizeof(double)); 
 			 memmove(wts,w77,77*sizeof(double)); 
 			 break; 
		 case 78:
 			 memmove(pts,pts78,78*sizeof(double)); 
 			 memmove(wts,w78,78*sizeof(double)); 
 			 break; 
		 case 79:
 			 memmove(pts,pts79,79*sizeof(double)); 
 			 memmove(wts,w79,79*sizeof(double)); 
 			 break; 
		 case 80:
 			 memmove(pts,pts80,80*sizeof(double)); 
 			 memmove(wts,w80,80*sizeof(double)); 
 			 break; 
		 case 81:
 			 memmove(pts,pts81,81*sizeof(double)); 
 			 memmove(wts,w81,81*sizeof(double)); 
 			 break; 
		 case 82:
 			 memmove(pts,pts82,82*sizeof(double)); 
 			 memmove(wts,w82,82*sizeof(double)); 
 			 break; 
		 case 83:
 			 memmove(pts,pts83,83*sizeof(double)); 
 			 memmove(wts,w83,83*sizeof(double)); 
 			 break; 
		 case 84:
 			 memmove(pts,pts84,84*sizeof(double)); 
 			 memmove(wts,w84,84*sizeof(double)); 
 			 break; 
		 case 85:
 			 memmove(pts,pts85,85*sizeof(double)); 
 			 memmove(wts,w85,85*sizeof(double)); 
 			 break; 
		 case 86:
 			 memmove(pts,pts86,86*sizeof(double)); 
 			 memmove(wts,w86,86*sizeof(double)); 
 			 break; 
		 case 87:
 			 memmove(pts,pts87,87*sizeof(double)); 
 			 memmove(wts,w87,87*sizeof(double)); 
 			 break; 
		 case 88:
 			 memmove(pts,pts88,88*sizeof(double)); 
 			 memmove(wts,w88,88*sizeof(double)); 
 			 break; 
		 case 89:
 			 memmove(pts,pts89,89*sizeof(double)); 
 			 memmove(wts,w89,89*sizeof(double)); 
 			 break; 
		 case 90:
 			 memmove(pts,pts90,90*sizeof(double)); 
 			 memmove(wts,w90,90*sizeof(double)); 
 			 break; 
		 case 91:
 			 memmove(pts,pts91,91*sizeof(double)); 
 			 memmove(wts,w91,91*sizeof(double)); 
 			 break; 
		 case 92:
 			 memmove(pts,pts92,92*sizeof(double)); 
 			 memmove(wts,w92,92*sizeof(double)); 
 			 break; 
		 case 93:
 			 memmove(pts,pts93,93*sizeof(double)); 
 			 memmove(wts,w93,93*sizeof(double)); 
 			 break; 
		 case 94:
 			 memmove(pts,pts94,94*sizeof(double)); 
 			 memmove(wts,w94,94*sizeof(double)); 
 			 break; 
		 case 95:
 			 memmove(pts,pts95,95*sizeof(double)); 
 			 memmove(wts,w95,95*sizeof(double)); 
 			 break; 
		 case 96:
 			 memmove(pts,pts96,96*sizeof(double)); 
 			 memmove(wts,w96,96*sizeof(double)); 
 			 break; 
		 case 97:
 			 memmove(pts,pts97,97*sizeof(double)); 
 			 memmove(wts,w97,97*sizeof(double)); 
 			 break; 
		 case 98:
 			 memmove(pts,pts98,98*sizeof(double)); 
 			 memmove(wts,w98,98*sizeof(double)); 
 			 break; 
		 case 99:
 			 memmove(pts,pts99,99*sizeof(double)); 
 			 memmove(wts,w99,99*sizeof(double)); 
 			 break; 
		 case 100:
 			 memmove(pts,pts100,100*sizeof(double)); 
 			 memmove(wts,w100,100*sizeof(double)); 
 			 break; 
		 case 101:
 			 memmove(pts,pts101,101*sizeof(double)); 
 			 memmove(wts,w101,101*sizeof(double)); 
 			 break; 
		 case 102:
 			 memmove(pts,pts102,102*sizeof(double)); 
 			 memmove(wts,w102,102*sizeof(double)); 
 			 break; 
		 case 103:
 			 memmove(pts,pts103,103*sizeof(double)); 
 			 memmove(wts,w103,103*sizeof(double)); 
 			 break; 
		 case 104:
 			 memmove(pts,pts104,104*sizeof(double)); 
 			 memmove(wts,w104,104*sizeof(double)); 
 			 break; 
		 case 105:
 			 memmove(pts,pts105,105*sizeof(double)); 
 			 memmove(wts,w105,105*sizeof(double)); 
 			 break; 
		 case 106:
 			 memmove(pts,pts106,106*sizeof(double)); 
 			 memmove(wts,w106,106*sizeof(double)); 
 			 break; 
		 case 107:
 			 memmove(pts,pts107,107*sizeof(double)); 
 			 memmove(wts,w107,107*sizeof(double)); 
 			 break; 
		 case 108:
 			 memmove(pts,pts108,108*sizeof(double)); 
 			 memmove(wts,w108,108*sizeof(double)); 
 			 break; 
		 case 109:
 			 memmove(pts,pts109,109*sizeof(double)); 
 			 memmove(wts,w109,109*sizeof(double)); 
 			 break; 
		 case 110:
 			 memmove(pts,pts110,110*sizeof(double)); 
 			 memmove(wts,w110,110*sizeof(double)); 
 			 break; 
		 case 111:
 			 memmove(pts,pts111,111*sizeof(double)); 
 			 memmove(wts,w111,111*sizeof(double)); 
 			 break; 
		 case 112:
 			 memmove(pts,pts112,112*sizeof(double)); 
 			 memmove(wts,w112,112*sizeof(double)); 
 			 break; 
		 case 113:
 			 memmove(pts,pts113,113*sizeof(double)); 
 			 memmove(wts,w113,113*sizeof(double)); 
 			 break; 
		 case 114:
 			 memmove(pts,pts114,114*sizeof(double)); 
 			 memmove(wts,w114,114*sizeof(double)); 
 			 break; 
		 case 115:
 			 memmove(pts,pts115,115*sizeof(double)); 
 			 memmove(wts,w115,115*sizeof(double)); 
 			 break; 
		 case 116:
 			 memmove(pts,pts116,116*sizeof(double)); 
 			 memmove(wts,w116,116*sizeof(double)); 
 			 break; 
		 case 117:
 			 memmove(pts,pts117,117*sizeof(double)); 
 			 memmove(wts,w117,117*sizeof(double)); 
 			 break; 
		 case 118:
 			 memmove(pts,pts118,118*sizeof(double)); 
 			 memmove(wts,w118,118*sizeof(double)); 
 			 break; 
		 case 119:
 			 memmove(pts,pts119,119*sizeof(double)); 
 			 memmove(wts,w119,119*sizeof(double)); 
 			 break; 
		 case 120:
 			 memmove(pts,pts120,120*sizeof(double)); 
 			 memmove(wts,w120,120*sizeof(double)); 
 			 break; 
		 case 121:
 			 memmove(pts,pts121,121*sizeof(double)); 
 			 memmove(wts,w121,121*sizeof(double)); 
 			 break; 
		 case 122:
 			 memmove(pts,pts122,122*sizeof(double)); 
 			 memmove(wts,w122,122*sizeof(double)); 
 			 break; 
		 case 123:
 			 memmove(pts,pts123,123*sizeof(double)); 
 			 memmove(wts,w123,123*sizeof(double)); 
 			 break; 
		 case 124:
 			 memmove(pts,pts124,124*sizeof(double)); 
 			 memmove(wts,w124,124*sizeof(double)); 
 			 break; 
		 case 125:
 			 memmove(pts,pts125,125*sizeof(double)); 
 			 memmove(wts,w125,125*sizeof(double)); 
 			 break; 
		 case 126:
 			 memmove(pts,pts126,126*sizeof(double)); 
 			 memmove(wts,w126,126*sizeof(double)); 
 			 break; 
		 case 127:
 			 memmove(pts,pts127,127*sizeof(double)); 
 			 memmove(wts,w127,127*sizeof(double)); 
 			 break; 
		 case 128:
 			 memmove(pts,pts128,128*sizeof(double)); 
 			 memmove(wts,w128,128*sizeof(double)); 
 			 break; 
		 case 129:
 			 memmove(pts,pts129,129*sizeof(double)); 
 			 memmove(wts,w129,129*sizeof(double)); 
 			 break; 
		 case 130:
 			 memmove(pts,pts130,130*sizeof(double)); 
 			 memmove(wts,w130,130*sizeof(double)); 
 			 break; 
		 case 131:
 			 memmove(pts,pts131,131*sizeof(double)); 
 			 memmove(wts,w131,131*sizeof(double)); 
 			 break; 
		 case 132:
 			 memmove(pts,pts132,132*sizeof(double)); 
 			 memmove(wts,w132,132*sizeof(double)); 
 			 break; 
		 case 133:
 			 memmove(pts,pts133,133*sizeof(double)); 
 			 memmove(wts,w133,133*sizeof(double)); 
 			 break; 
		 case 134:
 			 memmove(pts,pts134,134*sizeof(double)); 
 			 memmove(wts,w134,134*sizeof(double)); 
 			 break; 
		 case 135:
 			 memmove(pts,pts135,135*sizeof(double)); 
 			 memmove(wts,w135,135*sizeof(double)); 
 			 break; 
		 case 136:
 			 memmove(pts,pts136,136*sizeof(double)); 
 			 memmove(wts,w136,136*sizeof(double)); 
 			 break; 
		 case 137:
 			 memmove(pts,pts137,137*sizeof(double)); 
 			 memmove(wts,w137,137*sizeof(double)); 
 			 break; 
		 case 138:
 			 memmove(pts,pts138,138*sizeof(double)); 
 			 memmove(wts,w138,138*sizeof(double)); 
 			 break; 
		 case 139:
 			 memmove(pts,pts139,139*sizeof(double)); 
 			 memmove(wts,w139,139*sizeof(double)); 
 			 break; 
		 case 140:
 			 memmove(pts,pts140,140*sizeof(double)); 
 			 memmove(wts,w140,140*sizeof(double)); 
 			 break; 
		 case 141:
 			 memmove(pts,pts141,141*sizeof(double)); 
 			 memmove(wts,w141,141*sizeof(double)); 
 			 break; 
		 case 142:
 			 memmove(pts,pts142,142*sizeof(double)); 
 			 memmove(wts,w142,142*sizeof(double)); 
 			 break; 
		 case 143:
 			 memmove(pts,pts143,143*sizeof(double)); 
 			 memmove(wts,w143,143*sizeof(double)); 
 			 break; 
		 case 144:
 			 memmove(pts,pts144,144*sizeof(double)); 
 			 memmove(wts,w144,144*sizeof(double)); 
 			 break; 
		 case 145:
 			 memmove(pts,pts145,145*sizeof(double)); 
 			 memmove(wts,w145,145*sizeof(double)); 
 			 break; 
		 case 146:
 			 memmove(pts,pts146,146*sizeof(double)); 
 			 memmove(wts,w146,146*sizeof(double)); 
 			 break; 
		 case 147:
 			 memmove(pts,pts147,147*sizeof(double)); 
 			 memmove(wts,w147,147*sizeof(double)); 
 			 break; 
		 case 148:
 			 memmove(pts,pts148,148*sizeof(double)); 
 			 memmove(wts,w148,148*sizeof(double)); 
 			 break; 
		 case 149:
 			 memmove(pts,pts149,149*sizeof(double)); 
 			 memmove(wts,w149,149*sizeof(double)); 
 			 break; 
		 case 150:
 			 memmove(pts,pts150,150*sizeof(double)); 
 			 memmove(wts,w150,150*sizeof(double)); 
 			 break; 
		 case 151:
 			 memmove(pts,pts151,151*sizeof(double)); 
 			 memmove(wts,w151,151*sizeof(double)); 
 			 break; 
		 case 152:
 			 memmove(pts,pts152,152*sizeof(double)); 
 			 memmove(wts,w152,152*sizeof(double)); 
 			 break; 
		 case 153:
 			 memmove(pts,pts153,153*sizeof(double)); 
 			 memmove(wts,w153,153*sizeof(double)); 
 			 break; 
		 case 154:
 			 memmove(pts,pts154,154*sizeof(double)); 
 			 memmove(wts,w154,154*sizeof(double)); 
 			 break; 
		 case 155:
 			 memmove(pts,pts155,155*sizeof(double)); 
 			 memmove(wts,w155,155*sizeof(double)); 
 			 break; 
		 case 156:
 			 memmove(pts,pts156,156*sizeof(double)); 
 			 memmove(wts,w156,156*sizeof(double)); 
 			 break; 
		 case 157:
 			 memmove(pts,pts157,157*sizeof(double)); 
 			 memmove(wts,w157,157*sizeof(double)); 
 			 break; 
		 case 158:
 			 memmove(pts,pts158,158*sizeof(double)); 
 			 memmove(wts,w158,158*sizeof(double)); 
 			 break; 
		 case 159:
 			 memmove(pts,pts159,159*sizeof(double)); 
 			 memmove(wts,w159,159*sizeof(double)); 
 			 break; 
		 case 160:
 			 memmove(pts,pts160,160*sizeof(double)); 
 			 memmove(wts,w160,160*sizeof(double)); 
 			 break; 
		 case 161:
 			 memmove(pts,pts161,161*sizeof(double)); 
 			 memmove(wts,w161,161*sizeof(double)); 
 			 break; 
		 case 162:
 			 memmove(pts,pts162,162*sizeof(double)); 
 			 memmove(wts,w162,162*sizeof(double)); 
 			 break; 
		 case 163:
 			 memmove(pts,pts163,163*sizeof(double)); 
 			 memmove(wts,w163,163*sizeof(double)); 
 			 break; 
		 case 164:
 			 memmove(pts,pts164,164*sizeof(double)); 
 			 memmove(wts,w164,164*sizeof(double)); 
 			 break; 
		 case 165:
 			 memmove(pts,pts165,165*sizeof(double)); 
 			 memmove(wts,w165,165*sizeof(double)); 
 			 break; 
		 case 166:
 			 memmove(pts,pts166,166*sizeof(double)); 
 			 memmove(wts,w166,166*sizeof(double)); 
 			 break; 
		 case 167:
 			 memmove(pts,pts167,167*sizeof(double)); 
 			 memmove(wts,w167,167*sizeof(double)); 
 			 break; 
		 case 168:
 			 memmove(pts,pts168,168*sizeof(double)); 
 			 memmove(wts,w168,168*sizeof(double)); 
 			 break; 
		 case 169:
 			 memmove(pts,pts169,169*sizeof(double)); 
 			 memmove(wts,w169,169*sizeof(double)); 
 			 break; 
		 case 170:
 			 memmove(pts,pts170,170*sizeof(double)); 
 			 memmove(wts,w170,170*sizeof(double)); 
 			 break; 
		 case 171:
 			 memmove(pts,pts171,171*sizeof(double)); 
 			 memmove(wts,w171,171*sizeof(double)); 
 			 break; 
		 case 172:
 			 memmove(pts,pts172,172*sizeof(double)); 
 			 memmove(wts,w172,172*sizeof(double)); 
 			 break; 
		 case 173:
 			 memmove(pts,pts173,173*sizeof(double)); 
 			 memmove(wts,w173,173*sizeof(double)); 
 			 break; 
		 case 174:
 			 memmove(pts,pts174,174*sizeof(double)); 
 			 memmove(wts,w174,174*sizeof(double)); 
 			 break; 
		 case 175:
 			 memmove(pts,pts175,175*sizeof(double)); 
 			 memmove(wts,w175,175*sizeof(double)); 
 			 break; 
		 case 176:
 			 memmove(pts,pts176,176*sizeof(double)); 
 			 memmove(wts,w176,176*sizeof(double)); 
 			 break; 
		 case 177:
 			 memmove(pts,pts177,177*sizeof(double)); 
 			 memmove(wts,w177,177*sizeof(double)); 
 			 break; 
		 case 178:
 			 memmove(pts,pts178,178*sizeof(double)); 
 			 memmove(wts,w178,178*sizeof(double)); 
 			 break; 
		 case 179:
 			 memmove(pts,pts179,179*sizeof(double)); 
 			 memmove(wts,w179,179*sizeof(double)); 
 			 break; 
		 case 180:
 			 memmove(pts,pts180,180*sizeof(double)); 
 			 memmove(wts,w180,180*sizeof(double)); 
 			 break; 
		 case 181:
 			 memmove(pts,pts181,181*sizeof(double)); 
 			 memmove(wts,w181,181*sizeof(double)); 
 			 break; 
		 case 182:
 			 memmove(pts,pts182,182*sizeof(double)); 
 			 memmove(wts,w182,182*sizeof(double)); 
 			 break; 
		 case 183:
 			 memmove(pts,pts183,183*sizeof(double)); 
 			 memmove(wts,w183,183*sizeof(double)); 
 			 break; 
		 case 184:
 			 memmove(pts,pts184,184*sizeof(double)); 
 			 memmove(wts,w184,184*sizeof(double)); 
 			 break; 
		 case 185:
 			 memmove(pts,pts185,185*sizeof(double)); 
 			 memmove(wts,w185,185*sizeof(double)); 
 			 break; 
		 case 186:
 			 memmove(pts,pts186,186*sizeof(double)); 
 			 memmove(wts,w186,186*sizeof(double)); 
 			 break; 
		 case 187:
 			 memmove(pts,pts187,187*sizeof(double)); 
 			 memmove(wts,w187,187*sizeof(double)); 
 			 break; 
		 case 188:
 			 memmove(pts,pts188,188*sizeof(double)); 
 			 memmove(wts,w188,188*sizeof(double)); 
 			 break; 
		 case 189:
 			 memmove(pts,pts189,189*sizeof(double)); 
 			 memmove(wts,w189,189*sizeof(double)); 
 			 break; 
		 case 190:
 			 memmove(pts,pts190,190*sizeof(double)); 
 			 memmove(wts,w190,190*sizeof(double)); 
 			 break; 
		 case 191:
 			 memmove(pts,pts191,191*sizeof(double)); 
 			 memmove(wts,w191,191*sizeof(double)); 
 			 break; 
		 case 192:
 			 memmove(pts,pts192,192*sizeof(double)); 
 			 memmove(wts,w192,192*sizeof(double)); 
 			 break; 
		 case 193:
 			 memmove(pts,pts193,193*sizeof(double)); 
 			 memmove(wts,w193,193*sizeof(double)); 
 			 break; 
		 case 194:
 			 memmove(pts,pts194,194*sizeof(double)); 
 			 memmove(wts,w194,194*sizeof(double)); 
 			 break; 
		 case 195:
 			 memmove(pts,pts195,195*sizeof(double)); 
 			 memmove(wts,w195,195*sizeof(double)); 
 			 break; 
		 case 196:
 			 memmove(pts,pts196,196*sizeof(double)); 
 			 memmove(wts,w196,196*sizeof(double)); 
 			 break; 
		 case 197:
 			 memmove(pts,pts197,197*sizeof(double)); 
 			 memmove(wts,w197,197*sizeof(double)); 
 			 break; 
		 case 198:
 			 memmove(pts,pts198,198*sizeof(double)); 
 			 memmove(wts,w198,198*sizeof(double)); 
 			 break; 
		 case 199:
 			 memmove(pts,pts199,199*sizeof(double)); 
 			 memmove(wts,w199,199*sizeof(double)); 
 			 break; 
	} 
}
