# `rebullet` : Beautiful Python Prompts Made Simple

<p align=center>
<br><br><br>
<img src="https://github.com/h4rldev/rebullet/raw/master/assets/icon.png" width="400">
<br><br><br>
<a target="_blank"><img src="https://img.shields.io/badge/platform-windows-lightgrey?style=flat-square"></a>
<a target="_blank"><img src="https://img.shields.io/badge/platform-linux-lightgrey?style=flat-square"></a>
<a target="_blank" href="https://www.python.org/downloads/" title="Python version">
<img src="https://img.shields.io/badge/python-=_3.10-green?style=flat-square"></a>
<a target="_blank" href="https://opensource.org/licenses/MIT" title="License: MIT">
<img src="https://img.shields.io/badge/License-MIT-blue?style=flat-square"></a>
<a target="_blank" href="http://makeapullrequest.com" title="PRs Wanted">
<img src="https://img.shields.io/badge/PRs-wanted-brightgreen?style=flat-square"></a>
<a target="_blank" href="https://pypi.org/project/rebullet/" title="pypi">
<img src="https://img.shields.io/pypi/v/rebullet?style=flat-square"></a>
<a target="_blank" href="https://www.codefactor.io/repository/github/h4rldev/rebullet/">
<img src="https://img.shields.io/codefactor/grade/github/h4rldev/rebullet?style=flat-square"></a>
</p>

***
> 🎨 Customize prompts in your Python CLI tool.
> Extensive support for formatting, colors, background colors, styling, and etc.
> Also supports emojis!
***

## This REPO requires maintainers since I won't be working on it anytime soon

<p align="center">
    <img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/demo.gif" width=800>
</p>

> See the sample code for the above demo in `./examples/prompt.py`.

## Bullet-lists and checkboxes

> 🎨 Robust support for user-defined styles.

<table>
    <tr>
        <th>./examples/classic.py</th>
        <th>./examples/colorful.py</th>
        <th>./examples/star.py</th>
    </tr>
    <tr>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/classic.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/colorful.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/star.gif" width="200"/></td>
    </tr>
    <tr>
        <th>Vanilla checkbox</th>
        <th>Checkbox + styles.Exam</th>
        <th>Bullet + styles.Greece</th>
    </tr>
    <tr>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/checkbox.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/exam.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/greece.gif" width="200"/></td>
    </tr>
    <tr>
        <th>Bullet + styles.Ocean</th>
        <th>Bullet + styles.Lime</th>
        <th>Bullet + styles.Christmas</th>
    </tr>
    <tr>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/ocean.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/lime.gif" width="200"/></td>
        <td><img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/christmas.gif" width="200"/></td>
    </tr>
</table>

## ScrollBar

<p align="center">
    <img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/scrollbar.gif" width=400>
</p>

> See the sample code for the above demo in `./examples/scrollbar.py`.

## Other input prompts

> ⛔ Passwords

<img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/password.gif" width="600"/>

> 👍 Yes/No Questions

<img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/yesno.gif" width="600"/>

> 🔢 Numbers

<img src="https://github.com/h4rldev/rebullet/raw/master/assets/gifs/numbers.gif" width="600"/>

## Setting up `rebullet`

> Build from Source

```shell
git clone https://github.com/h4rldev/rebullet
cd rebullet
pip install .
```

> Install from pypi

```shell
pip install rebullet
```

## Documentation

📖 See <a href="https://github.com/h4rldev/rebullet/raw/master/DOCUMENTATION.md"> Documentation</a>.

> Currently supported prompts:
`Bullet`, `Check`, `Input`, `Numbers`, `Password`, `YesNo`, `VerticalPrompt`,
`SlidePrompt`, `Scrollbar`, `Date`, `CheckDependencies`.

## Contributing

🎉 Directly send PRs! Make sure development is done and tested in `Python 3.10`
<br>
❗  Make sure to make them mergable to save me and you time.
