import tkinter as tk
from tkdev.devicon import Icon_Empty, Icon_TkinterDev


def EmptyFunc():
    pass


class DevAction(object):
    def __init__(self, text: str = "", icon: str = None, command=EmptyFunc, bg="white", fg="black", active_bg="white", active_fg="black"):
        self._text = text
        self._icon = icon
        self._command = command
        self._bg = bg
        self._fg = fg
        self._active_bg = active_bg
        self._active_fg = active_fg

    @property
    def icon(self):
        return self._icon

    @icon.setter
    def icon(self, icon: tk.PhotoImage):
        self._icon = icon

    @property
    def text(self):
        return self._text

    @text.setter
    def text(self, text: str = None):
        self._text = text

    @property
    def command(self):
        return self._command

    @command.setter
    def command(self, command=None):
        self._command = command

    @property
    def background(self):
        return self._bg

    @background.setter
    def background(self, backgroud=None):
        self._bg = backgroud

    @property
    def foreground(self):
        return self._fg

    @foreground.setter
    def foreground(self, foregroud=None):
        self._fg = foregroud

    @property
    def active_background(self):
        return self._active_bg

    @active_background.setter
    def active_background(self, backgroud=None):
        self._active_bg = backgroud

    @property
    def active_foreground(self):
        return self._active_fg

    @active_foreground.setter
    def active_foreground(self, foregroud=None):
        self._active_fg = foregroud


class DevSysTray(object):
    def __init__(self, name: str = "", title: str = "", icon: str = Icon_TkinterDev):
        from PIL import Image
        self.menu = []
        self.name = name
        self.title = title
        self.icon = Image.open(icon)

    def add_menu(self, title: str = "", command=EmptyFunc):
        from pystray import MenuItem
        self.menu.append(MenuItem(text=title, action=command))

    def add_action(self, action: DevAction):
        self.add_menu(title=action.text, command=action.command)

    def show(self):
        from pystray import Icon
        self.Icon = Icon(name=self.name, title=self.title, menu=self.menu, icon=self.icon)
        self.Icon.run()

    def stop(self):
        self.Icon.stop()

    def notify(self, message: str = "", title: str = ""):
        self.Icon.notify()



