# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six


class NotificationEndpointsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """NotificationEndpointsService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def create_notification_endpoint(self, post_notification_endpoint, **kwargs):  # noqa: E501,D401,D403
        """Add a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_endpoint(post_notification_endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostNotificationEndpoint post_notification_endpoint: Notification endpoint to create (required)
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_endpoint_with_http_info(post_notification_endpoint, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_endpoint_with_http_info(post_notification_endpoint, **kwargs)  # noqa: E501
            return data

    def create_notification_endpoint_with_http_info(self, post_notification_endpoint, **kwargs):  # noqa: E501,D401,D403
        """Add a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_endpoint_with_http_info(post_notification_endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostNotificationEndpoint post_notification_endpoint: Notification endpoint to create (required)
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['post_notification_endpoint']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification_endpoint" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'post_notification_endpoint' is set
        if ('post_notification_endpoint' not in local_var_params or
                local_var_params['post_notification_endpoint'] is None):
            raise ValueError("Missing the required parameter `post_notification_endpoint` when calling `create_notification_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_notification_endpoint' in local_var_params:
            body_params = local_var_params['post_notification_endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_notification_endpoints_id(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_endpoints_id(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_endpoints_id_with_http_info(endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_endpoints_id_with_http_info(endpoint_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_endpoints_id_with_http_info(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_endpoints_id_with_http_info(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification_endpoints_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `delete_notification_endpoints_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_notification_endpoints_id_labels_id(self, endpoint_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_endpoints_id_labels_id(endpoint_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_endpoints_id_labels_id_with_http_info(endpoint_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_endpoints_id_labels_id_with_http_info(endpoint_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_endpoints_id_labels_id_with_http_info(self, endpoint_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_endpoints_id_labels_id_with_http_info(endpoint_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'label_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification_endpoints_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `delete_notification_endpoints_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_notification_endpoints_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_notification_endpoints(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all notification endpoints.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show notification endpoints that belong to specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :return: NotificationEndpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_endpoints_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_endpoints_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_notification_endpoints_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all notification endpoints.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show notification endpoints that belong to specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :return: NotificationEndpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_endpoints" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_notification_endpoints`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_notification_endpoints`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_notification_endpoints`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_notification_endpoints`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationEndpoints',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_notification_endpoints_id(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints_id(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_endpoints_id_with_http_info(endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_endpoints_id_with_http_info(endpoint_id, **kwargs)  # noqa: E501
            return data

    def get_notification_endpoints_id_with_http_info(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints_id_with_http_info(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_endpoints_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `get_notification_endpoints_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_notification_endpoints_id_labels(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints_id_labels(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_endpoints_id_labels_with_http_info(endpoint_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_endpoints_id_labels_with_http_info(endpoint_id, **kwargs)  # noqa: E501
            return data

    def get_notification_endpoints_id_labels_with_http_info(self, endpoint_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_endpoints_id_labels_with_http_info(endpoint_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_endpoints_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `get_notification_endpoints_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_notification_endpoints_id(self, endpoint_id, notification_endpoint_update, **kwargs):  # noqa: E501,D401,D403
        """Update a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_notification_endpoints_id(endpoint_id, notification_endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param NotificationEndpointUpdate notification_endpoint_update: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint_update, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint_update, **kwargs)  # noqa: E501
            return data

    def patch_notification_endpoints_id_with_http_info(self, endpoint_id, notification_endpoint_update, **kwargs):  # noqa: E501,D401,D403
        """Update a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param NotificationEndpointUpdate notification_endpoint_update: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'notification_endpoint_update', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_notification_endpoints_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `patch_notification_endpoints_id`")  # noqa: E501
        # verify the required parameter 'notification_endpoint_update' is set
        if ('notification_endpoint_update' not in local_var_params or
                local_var_params['notification_endpoint_update'] is None):
            raise ValueError("Missing the required parameter `notification_endpoint_update` when calling `patch_notification_endpoints_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_endpoint_update' in local_var_params:
            body_params = local_var_params['notification_endpoint_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_notification_endpoint_id_labels(self, endpoint_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_notification_endpoint_id_labels(endpoint_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_notification_endpoint_id_labels_with_http_info(endpoint_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_notification_endpoint_id_labels_with_http_info(endpoint_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_notification_endpoint_id_labels_with_http_info(self, endpoint_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_notification_endpoint_id_labels_with_http_info(endpoint_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_notification_endpoint_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `post_notification_endpoint_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_notification_endpoint_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def put_notification_endpoints_id(self, endpoint_id, notification_endpoint, **kwargs):  # noqa: E501,D401,D403
        """Update a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_notification_endpoints_id(endpoint_id, notification_endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param NotificationEndpoint notification_endpoint: A new notification endpoint to replace the existing endpoint with (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint, **kwargs)  # noqa: E501
        else:
            (data) = self.put_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint, **kwargs)  # noqa: E501
            return data

    def put_notification_endpoints_id_with_http_info(self, endpoint_id, notification_endpoint, **kwargs):  # noqa: E501,D401,D403
        """Update a notification endpoint.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_notification_endpoints_id_with_http_info(endpoint_id, notification_endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str endpoint_id: The notification endpoint ID. (required)
        :param NotificationEndpoint notification_endpoint: A new notification endpoint to replace the existing endpoint with (required)
        :param str zap_trace_span: OpenTracing span context
        :return: NotificationEndpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['endpoint_id', 'notification_endpoint', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_notification_endpoints_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'endpoint_id' is set
        if ('endpoint_id' not in local_var_params or
                local_var_params['endpoint_id'] is None):
            raise ValueError("Missing the required parameter `endpoint_id` when calling `put_notification_endpoints_id`")  # noqa: E501
        # verify the required parameter 'notification_endpoint' is set
        if ('notification_endpoint' not in local_var_params or
                local_var_params['notification_endpoint'] is None):
            raise ValueError("Missing the required parameter `notification_endpoint` when calling `put_notification_endpoints_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'endpoint_id' in local_var_params:
            path_params['endpointID'] = local_var_params['endpoint_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_endpoint' in local_var_params:
            body_params = local_var_params['notification_endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/notificationEndpoints/{endpointID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationEndpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
