# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six


class DeleteService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """DeleteService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def post_delete(self, delete_predicate_request, **kwargs):  # noqa: E501,D401,D403
        """Delete data.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_delete(delete_predicate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeletePredicateRequest delete_predicate_request: Deletes data from an InfluxDB bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: Specifies the organization to delete data from.
        :param str bucket: Specifies the bucket to delete data from.
        :param str org_id: Specifies the organization ID of the resource.
        :param str bucket_id: Specifies the bucket ID to delete data from.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_delete_with_http_info(delete_predicate_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_delete_with_http_info(delete_predicate_request, **kwargs)  # noqa: E501
            return data

    def post_delete_with_http_info(self, delete_predicate_request, **kwargs):  # noqa: E501,D401,D403
        """Delete data.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_delete_with_http_info(delete_predicate_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeletePredicateRequest delete_predicate_request: Deletes data from an InfluxDB bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: Specifies the organization to delete data from.
        :param str bucket: Specifies the bucket to delete data from.
        :param str org_id: Specifies the organization ID of the resource.
        :param str bucket_id: Specifies the bucket ID to delete data from.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['delete_predicate_request', 'zap_trace_span', 'org', 'bucket', 'org_id', 'bucket_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'delete_predicate_request' is set
        if ('delete_predicate_request' not in local_var_params or
                local_var_params['delete_predicate_request'] is None):
            raise ValueError("Missing the required parameter `delete_predicate_request` when calling `post_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501
        if 'bucket' in local_var_params:
            query_params.append(('bucket', local_var_params['bucket']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'bucket_id' in local_var_params:
            query_params.append(('bucketID', local_var_params['bucket_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_predicate_request' in local_var_params:
            body_params = local_var_params['delete_predicate_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
