# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six


class ChecksService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """ChecksService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def create_check(self, post_check, **kwargs):  # noqa: E501,D401,D403
        """Add new check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_check(post_check, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCheck post_check: Check to create (required)
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_check_with_http_info(post_check, **kwargs)  # noqa: E501
        else:
            (data) = self.create_check_with_http_info(post_check, **kwargs)  # noqa: E501
            return data

    def create_check_with_http_info(self, post_check, **kwargs):  # noqa: E501,D401,D403
        """Add new check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_check_with_http_info(post_check, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCheck post_check: Check to create (required)
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['post_check']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_check" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'post_check' is set
        if ('post_check' not in local_var_params or
                local_var_params['post_check'] is None):
            raise ValueError("Missing the required parameter `post_check` when calling `create_check`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_check' in local_var_params:
            body_params = local_var_params['post_check']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Check',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_checks_id(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checks_id(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_checks_id_with_http_info(check_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_checks_id_with_http_info(check_id, **kwargs)  # noqa: E501
            return data

    def delete_checks_id_with_http_info(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checks_id_with_http_info(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_checks_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `delete_checks_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def delete_checks_id_labels_id(self, check_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete label from a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checks_id_labels_id(check_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_checks_id_labels_id_with_http_info(check_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_checks_id_labels_id_with_http_info(check_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_checks_id_labels_id_with_http_info(self, check_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete label from a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_checks_id_labels_id_with_http_info(check_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str label_id: The ID of the label to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'label_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_checks_id_labels_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `delete_checks_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_checks_id_labels_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_checks(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all checks.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show checks that belong to a specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :return: Checks
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checks_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checks_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_checks_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all checks.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Only show checks that belong to a specific organization ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param int offset:
        :param int limit:
        :return: Checks
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_checks`")  # noqa: E501

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_checks`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_checks`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_checks`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Checks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_checks_id(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checks_id_with_http_info(check_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checks_id_with_http_info(check_id, **kwargs)  # noqa: E501
            return data

    def get_checks_id_with_http_info(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id_with_http_info(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checks_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `get_checks_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Check',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_checks_id_labels(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id_labels(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checks_id_labels_with_http_info(check_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checks_id_labels_with_http_info(check_id, **kwargs)  # noqa: E501
            return data

    def get_checks_id_labels_with_http_info(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id_labels_with_http_info(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checks_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `get_checks_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_checks_id_query(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a check query.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id_query(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: FluxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_checks_id_query_with_http_info(check_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_checks_id_query_with_http_info(check_id, **kwargs)  # noqa: E501
            return data

    def get_checks_id_query_with_http_info(self, check_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a check query.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_checks_id_query_with_http_info(check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: FluxResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_checks_id_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `get_checks_id_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}/query', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FluxResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_checks_id(self, check_id, check_patch, **kwargs):  # noqa: E501,D401,D403
        """Update a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_checks_id(check_id, check_patch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param CheckPatch check_patch: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_checks_id_with_http_info(check_id, check_patch, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_checks_id_with_http_info(check_id, check_patch, **kwargs)  # noqa: E501
            return data

    def patch_checks_id_with_http_info(self, check_id, check_patch, **kwargs):  # noqa: E501,D401,D403
        """Update a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_checks_id_with_http_info(check_id, check_patch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param CheckPatch check_patch: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'check_patch', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_checks_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `patch_checks_id`")  # noqa: E501
        # verify the required parameter 'check_patch' is set
        if ('check_patch' not in local_var_params or
                local_var_params['check_patch'] is None):
            raise ValueError("Missing the required parameter `check_patch` when calling `patch_checks_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'check_patch' in local_var_params:
            body_params = local_var_params['check_patch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Check',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_checks_id_labels(self, check_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_checks_id_labels(check_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_checks_id_labels_with_http_info(check_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_checks_id_labels_with_http_info(check_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_checks_id_labels_with_http_info(self, check_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_checks_id_labels_with_http_info(check_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_checks_id_labels" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `post_checks_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_checks_id_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def put_checks_id(self, check_id, check, **kwargs):  # noqa: E501,D401,D403
        """Update a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_checks_id(check_id, check, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param Check check: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_checks_id_with_http_info(check_id, check, **kwargs)  # noqa: E501
        else:
            (data) = self.put_checks_id_with_http_info(check_id, check, **kwargs)  # noqa: E501
            return data

    def put_checks_id_with_http_info(self, check_id, check, **kwargs):  # noqa: E501,D401,D403
        """Update a check.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_checks_id_with_http_info(check_id, check, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str check_id: The check ID. (required)
        :param Check check: Check update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Check
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['check_id', 'check', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_checks_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'check_id' is set
        if ('check_id' not in local_var_params or
                local_var_params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `put_checks_id`")  # noqa: E501
        # verify the required parameter 'check' is set
        if ('check' not in local_var_params or
                local_var_params['check'] is None):
            raise ValueError("Missing the required parameter `check` when calling `put_checks_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'check_id' in local_var_params:
            path_params['checkID'] = local_var_params['check_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'check' in local_var_params:
            body_params = local_var_params['check']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/checks/{checkID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Check',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
