# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Task(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'org_id': 'str',
        'org': 'str',
        'name': 'str',
        'owner_id': 'str',
        'description': 'str',
        'status': 'TaskStatusType',
        'labels': 'list[Label]',
        'authorization_id': 'str',
        'flux': 'str',
        'every': 'str',
        'cron': 'str',
        'offset': 'str',
        'latest_completed': 'datetime',
        'last_run_status': 'str',
        'last_run_error': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'links': 'TaskLinks'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'org_id': 'orgID',
        'org': 'org',
        'name': 'name',
        'owner_id': 'ownerID',
        'description': 'description',
        'status': 'status',
        'labels': 'labels',
        'authorization_id': 'authorizationID',
        'flux': 'flux',
        'every': 'every',
        'cron': 'cron',
        'offset': 'offset',
        'latest_completed': 'latestCompleted',
        'last_run_status': 'lastRunStatus',
        'last_run_error': 'lastRunError',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'links': 'links'
    }

    def __init__(self, id=None, type=None, org_id=None, org=None, name=None, owner_id=None, description=None, status=None, labels=None, authorization_id=None, flux=None, every=None, cron=None, offset=None, latest_completed=None, last_run_status=None, last_run_error=None, created_at=None, updated_at=None, links=None):  # noqa: E501,D401,D403
        """Task - a model defined in OpenAPI."""  # noqa: E501
        self._id = None
        self._type = None
        self._org_id = None
        self._org = None
        self._name = None
        self._owner_id = None
        self._description = None
        self._status = None
        self._labels = None
        self._authorization_id = None
        self._flux = None
        self._every = None
        self._cron = None
        self._offset = None
        self._latest_completed = None
        self._last_run_status = None
        self._last_run_error = None
        self._created_at = None
        self._updated_at = None
        self._links = None
        self.discriminator = None

        self.id = id
        if type is not None:
            self.type = type
        self.org_id = org_id
        if org is not None:
            self.org = org
        self.name = name
        if owner_id is not None:
            self.owner_id = owner_id
        if description is not None:
            self.description = description
        if status is not None:
            self.status = status
        if labels is not None:
            self.labels = labels
        if authorization_id is not None:
            self.authorization_id = authorization_id
        self.flux = flux
        if every is not None:
            self.every = every
        if cron is not None:
            self.cron = cron
        if offset is not None:
            self.offset = offset
        if latest_completed is not None:
            self.latest_completed = latest_completed
        if last_run_status is not None:
            self.last_run_status = last_run_status
        if last_run_error is not None:
            self.last_run_error = last_run_error
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if links is not None:
            self.links = links

    @property
    def id(self):
        """Get the id of this Task.

        :return: The id of this Task.
        :rtype: str
        """  # noqa: E501
        return self._id

    @id.setter
    def id(self, id):
        """Set the id of this Task.

        :param id: The id of this Task.
        :type: str
        """  # noqa: E501
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        self._id = id

    @property
    def type(self):
        """Get the type of this Task.

        Type of the task, useful for filtering a task list.

        :return: The type of this Task.
        :rtype: str
        """  # noqa: E501
        return self._type

    @type.setter
    def type(self, type):
        """Set the type of this Task.

        Type of the task, useful for filtering a task list.

        :param type: The type of this Task.
        :type: str
        """  # noqa: E501
        self._type = type

    @property
    def org_id(self):
        """Get the org_id of this Task.

        ID of the organization that owns the task.

        :return: The org_id of this Task.
        :rtype: str
        """  # noqa: E501
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Set the org_id of this Task.

        ID of the organization that owns the task.

        :param org_id: The org_id of this Task.
        :type: str
        """  # noqa: E501
        if org_id is None:
            raise ValueError("Invalid value for `org_id`, must not be `None`")  # noqa: E501
        self._org_id = org_id

    @property
    def org(self):
        """Get the org of this Task.

        Name of the organization that owns the task.

        :return: The org of this Task.
        :rtype: str
        """  # noqa: E501
        return self._org

    @org.setter
    def org(self, org):
        """Set the org of this Task.

        Name of the organization that owns the task.

        :param org: The org of this Task.
        :type: str
        """  # noqa: E501
        self._org = org

    @property
    def name(self):
        """Get the name of this Task.

        Name of the task.

        :return: The name of this Task.
        :rtype: str
        """  # noqa: E501
        return self._name

    @name.setter
    def name(self, name):
        """Set the name of this Task.

        Name of the task.

        :param name: The name of this Task.
        :type: str
        """  # noqa: E501
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        self._name = name

    @property
    def owner_id(self):
        """Get the owner_id of this Task.

        ID of the user who owns this Task.

        :return: The owner_id of this Task.
        :rtype: str
        """  # noqa: E501
        return self._owner_id

    @owner_id.setter
    def owner_id(self, owner_id):
        """Set the owner_id of this Task.

        ID of the user who owns this Task.

        :param owner_id: The owner_id of this Task.
        :type: str
        """  # noqa: E501
        self._owner_id = owner_id

    @property
    def description(self):
        """Get the description of this Task.

        Description of the task.

        :return: The description of this Task.
        :rtype: str
        """  # noqa: E501
        return self._description

    @description.setter
    def description(self, description):
        """Set the description of this Task.

        Description of the task.

        :param description: The description of this Task.
        :type: str
        """  # noqa: E501
        self._description = description

    @property
    def status(self):
        """Get the status of this Task.

        :return: The status of this Task.
        :rtype: TaskStatusType
        """  # noqa: E501
        return self._status

    @status.setter
    def status(self, status):
        """Set the status of this Task.

        :param status: The status of this Task.
        :type: TaskStatusType
        """  # noqa: E501
        self._status = status

    @property
    def labels(self):
        """Get the labels of this Task.

        :return: The labels of this Task.
        :rtype: list[Label]
        """  # noqa: E501
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Set the labels of this Task.

        :param labels: The labels of this Task.
        :type: list[Label]
        """  # noqa: E501
        self._labels = labels

    @property
    def authorization_id(self):
        """Get the authorization_id of this Task.

        ID of the authorization used when the task communicates with the query engine.

        :return: The authorization_id of this Task.
        :rtype: str
        """  # noqa: E501
        return self._authorization_id

    @authorization_id.setter
    def authorization_id(self, authorization_id):
        """Set the authorization_id of this Task.

        ID of the authorization used when the task communicates with the query engine.

        :param authorization_id: The authorization_id of this Task.
        :type: str
        """  # noqa: E501
        self._authorization_id = authorization_id

    @property
    def flux(self):
        """Get the flux of this Task.

        Flux script to run for this task.

        :return: The flux of this Task.
        :rtype: str
        """  # noqa: E501
        return self._flux

    @flux.setter
    def flux(self, flux):
        """Set the flux of this Task.

        Flux script to run for this task.

        :param flux: The flux of this Task.
        :type: str
        """  # noqa: E501
        if flux is None:
            raise ValueError("Invalid value for `flux`, must not be `None`")  # noqa: E501
        self._flux = flux

    @property
    def every(self):
        """Get the every of this Task.

        Interval at which the task runs. `every` also determines when the task first runs, depending on the specified time. Value is a [duration literal](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals)).

        :return: The every of this Task.
        :rtype: str
        """  # noqa: E501
        return self._every

    @every.setter
    def every(self, every):
        """Set the every of this Task.

        Interval at which the task runs. `every` also determines when the task first runs, depending on the specified time. Value is a [duration literal](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals)).

        :param every: The every of this Task.
        :type: str
        """  # noqa: E501
        self._every = every

    @property
    def cron(self):
        """Get the cron of this Task.

        [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview) that defines the schedule on which the task runs. Cron scheduling is based on system time. Value is a [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview).

        :return: The cron of this Task.
        :rtype: str
        """  # noqa: E501
        return self._cron

    @cron.setter
    def cron(self, cron):
        """Set the cron of this Task.

        [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview) that defines the schedule on which the task runs. Cron scheduling is based on system time. Value is a [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview).

        :param cron: The cron of this Task.
        :type: str
        """  # noqa: E501
        self._cron = cron

    @property
    def offset(self):
        """Get the offset of this Task.

        [Duration](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals) to delay execution of the task after the scheduled time has elapsed. `0` removes the offset. The value is a [duration literal](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals).

        :return: The offset of this Task.
        :rtype: str
        """  # noqa: E501
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Set the offset of this Task.

        [Duration](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals) to delay execution of the task after the scheduled time has elapsed. `0` removes the offset. The value is a [duration literal](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals).

        :param offset: The offset of this Task.
        :type: str
        """  # noqa: E501
        self._offset = offset

    @property
    def latest_completed(self):
        """Get the latest_completed of this Task.

        Timestamp of the latest scheduled and completed run. Value is a timestamp in [RFC3339 date/time format](https://docs.influxdata.com/flux/v0.x/data-types/basic/time/#time-syntax).

        :return: The latest_completed of this Task.
        :rtype: datetime
        """  # noqa: E501
        return self._latest_completed

    @latest_completed.setter
    def latest_completed(self, latest_completed):
        """Set the latest_completed of this Task.

        Timestamp of the latest scheduled and completed run. Value is a timestamp in [RFC3339 date/time format](https://docs.influxdata.com/flux/v0.x/data-types/basic/time/#time-syntax).

        :param latest_completed: The latest_completed of this Task.
        :type: datetime
        """  # noqa: E501
        self._latest_completed = latest_completed

    @property
    def last_run_status(self):
        """Get the last_run_status of this Task.

        :return: The last_run_status of this Task.
        :rtype: str
        """  # noqa: E501
        return self._last_run_status

    @last_run_status.setter
    def last_run_status(self, last_run_status):
        """Set the last_run_status of this Task.

        :param last_run_status: The last_run_status of this Task.
        :type: str
        """  # noqa: E501
        self._last_run_status = last_run_status

    @property
    def last_run_error(self):
        """Get the last_run_error of this Task.

        :return: The last_run_error of this Task.
        :rtype: str
        """  # noqa: E501
        return self._last_run_error

    @last_run_error.setter
    def last_run_error(self, last_run_error):
        """Set the last_run_error of this Task.

        :param last_run_error: The last_run_error of this Task.
        :type: str
        """  # noqa: E501
        self._last_run_error = last_run_error

    @property
    def created_at(self):
        """Get the created_at of this Task.

        :return: The created_at of this Task.
        :rtype: datetime
        """  # noqa: E501
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Set the created_at of this Task.

        :param created_at: The created_at of this Task.
        :type: datetime
        """  # noqa: E501
        self._created_at = created_at

    @property
    def updated_at(self):
        """Get the updated_at of this Task.

        :return: The updated_at of this Task.
        :rtype: datetime
        """  # noqa: E501
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Set the updated_at of this Task.

        :param updated_at: The updated_at of this Task.
        :type: datetime
        """  # noqa: E501
        self._updated_at = updated_at

    @property
    def links(self):
        """Get the links of this Task.

        :return: The links of this Task.
        :rtype: TaskLinks
        """  # noqa: E501
        return self._links

    @links.setter
    def links(self, links):
        """Set the links of this Task.

        :param links: The links of this Task.
        :type: TaskLinks
        """  # noqa: E501
        self._links = links

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, Task):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
