"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The Datasets version 1 API is considred stable and will not be subject to breaking changes.  However, certain endpoints will be [deprecated](https://www.ncbi.nlm.nih.gov/datasets/docs/v1/reference-docs/rest-api/deprecated_apis/), and then sunset as newer versions are published. For some larger downloads, you may want to download a [dehydrated zip archive](https://www.ncbi.nlm.nih.gov/datasets/docs/v1/how-tos/genomes/large-download/), and retrieve the individual data files at a later time.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ncbi.datasets.openapi.api_client import ApiClient, Endpoint as _Endpoint
from ncbi.datasets.openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ncbi.datasets.openapi.model.rpc_status import RpcStatus
from ncbi.datasets.openapi.model.v1_annotation_for_assembly_type import V1AnnotationForAssemblyType
from ncbi.datasets.openapi.model.v1_assembly_dataset_availability import V1AssemblyDatasetAvailability
from ncbi.datasets.openapi.model.v1_assembly_dataset_descriptors_filter_assembly_level import V1AssemblyDatasetDescriptorsFilterAssemblyLevel
from ncbi.datasets.openapi.model.v1_assembly_dataset_descriptors_filter_assembly_source import V1AssemblyDatasetDescriptorsFilterAssemblySource
from ncbi.datasets.openapi.model.v1_assembly_dataset_descriptors_filter_assembly_version import V1AssemblyDatasetDescriptorsFilterAssemblyVersion
from ncbi.datasets.openapi.model.v1_assembly_dataset_request import V1AssemblyDatasetRequest
from ncbi.datasets.openapi.model.v1_assembly_dataset_request_resolution import V1AssemblyDatasetRequestResolution
from ncbi.datasets.openapi.model.v1_assembly_metadata import V1AssemblyMetadata
from ncbi.datasets.openapi.model.v1_assembly_metadata_request import V1AssemblyMetadataRequest
from ncbi.datasets.openapi.model.v1_assembly_metadata_request_content_type import V1AssemblyMetadataRequestContentType
from ncbi.datasets.openapi.model.v1_download_summary import V1DownloadSummary
from ncbi.datasets.openapi.model.v1_organism import V1Organism
from ncbi.datasets.openapi.model.v1_organism_query_request_tax_rank_filter import V1OrganismQueryRequestTaxRankFilter
from ncbi.datasets.openapi.model.v1_sci_name_and_ids import V1SciNameAndIds


class GenomeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.assembly_descriptors_by_accessions_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/accession/{accessions}',
                'operation_id': 'assembly_descriptors_by_accessions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'filters_reference_only',
                    'filters_assembly_source',
                    'filters_has_annotation',
                    'filters_exclude_atypical',
                    'filters_assembly_level',
                    'filters_first_release_date',
                    'filters_last_release_date',
                    'filters_search_text',
                    'page_size',
                    'page_token',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'filters_reference_only':
                        (bool,),
                    'filters_assembly_source':
                        (V1AssemblyDatasetDescriptorsFilterAssemblySource,),
                    'filters_has_annotation':
                        (bool,),
                    'filters_exclude_atypical':
                        (bool,),
                    'filters_assembly_level':
                        ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel],),
                    'filters_first_release_date':
                        (datetime,),
                    'filters_last_release_date':
                        (datetime,),
                    'filters_search_text':
                        ([str],),
                    'page_size':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'filters_reference_only': 'filters.reference_only',
                    'filters_assembly_source': 'filters.assembly_source',
                    'filters_has_annotation': 'filters.has_annotation',
                    'filters_exclude_atypical': 'filters.exclude_atypical',
                    'filters_assembly_level': 'filters.assembly_level',
                    'filters_first_release_date': 'filters.first_release_date',
                    'filters_last_release_date': 'filters.last_release_date',
                    'filters_search_text': 'filters.search_text',
                    'page_size': 'page_size',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'accessions': 'path',
                    'filters_reference_only': 'query',
                    'filters_assembly_source': 'query',
                    'filters_has_annotation': 'query',
                    'filters_exclude_atypical': 'query',
                    'filters_assembly_level': 'query',
                    'filters_first_release_date': 'query',
                    'filters_last_release_date': 'query',
                    'filters_search_text': 'query',
                    'page_size': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'filters_assembly_level': 'multi',
                    'filters_search_text': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.assembly_descriptors_by_bioproject_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/bioproject/{accessions}',
                'operation_id': 'assembly_descriptors_by_bioproject',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'filters_reference_only',
                    'filters_assembly_source',
                    'filters_has_annotation',
                    'filters_exclude_paired_reports',
                    'filters_exclude_atypical',
                    'filters_assembly_version',
                    'filters_assembly_level',
                    'filters_first_release_date',
                    'filters_last_release_date',
                    'filters_search_text',
                    'returned_content',
                    'page_size',
                    'page_token',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'filters_reference_only':
                        (bool,),
                    'filters_assembly_source':
                        (V1AssemblyDatasetDescriptorsFilterAssemblySource,),
                    'filters_has_annotation':
                        (bool,),
                    'filters_exclude_paired_reports':
                        (bool,),
                    'filters_exclude_atypical':
                        (bool,),
                    'filters_assembly_version':
                        (V1AssemblyDatasetDescriptorsFilterAssemblyVersion,),
                    'filters_assembly_level':
                        ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel],),
                    'filters_first_release_date':
                        (datetime,),
                    'filters_last_release_date':
                        (datetime,),
                    'filters_search_text':
                        ([str],),
                    'returned_content':
                        (V1AssemblyMetadataRequestContentType,),
                    'page_size':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'filters_reference_only': 'filters.reference_only',
                    'filters_assembly_source': 'filters.assembly_source',
                    'filters_has_annotation': 'filters.has_annotation',
                    'filters_exclude_paired_reports': 'filters.exclude_paired_reports',
                    'filters_exclude_atypical': 'filters.exclude_atypical',
                    'filters_assembly_version': 'filters.assembly_version',
                    'filters_assembly_level': 'filters.assembly_level',
                    'filters_first_release_date': 'filters.first_release_date',
                    'filters_last_release_date': 'filters.last_release_date',
                    'filters_search_text': 'filters.search_text',
                    'returned_content': 'returned_content',
                    'page_size': 'page_size',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'accessions': 'path',
                    'filters_reference_only': 'query',
                    'filters_assembly_source': 'query',
                    'filters_has_annotation': 'query',
                    'filters_exclude_paired_reports': 'query',
                    'filters_exclude_atypical': 'query',
                    'filters_assembly_version': 'query',
                    'filters_assembly_level': 'query',
                    'filters_first_release_date': 'query',
                    'filters_last_release_date': 'query',
                    'filters_search_text': 'query',
                    'returned_content': 'query',
                    'page_size': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'filters_assembly_level': 'multi',
                    'filters_search_text': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.assembly_descriptors_by_taxon_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/taxon/{taxon}',
                'operation_id': 'assembly_descriptors_by_taxon',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'filters_reference_only',
                    'filters_assembly_source',
                    'filters_has_annotation',
                    'filters_exclude_paired_reports',
                    'filters_exclude_atypical',
                    'filters_assembly_version',
                    'filters_assembly_level',
                    'filters_first_release_date',
                    'filters_last_release_date',
                    'filters_search_text',
                    'tax_exact_match',
                    'returned_content',
                    'page_size',
                    'page_token',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'filters_reference_only':
                        (bool,),
                    'filters_assembly_source':
                        (V1AssemblyDatasetDescriptorsFilterAssemblySource,),
                    'filters_has_annotation':
                        (bool,),
                    'filters_exclude_paired_reports':
                        (bool,),
                    'filters_exclude_atypical':
                        (bool,),
                    'filters_assembly_version':
                        (V1AssemblyDatasetDescriptorsFilterAssemblyVersion,),
                    'filters_assembly_level':
                        ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel],),
                    'filters_first_release_date':
                        (datetime,),
                    'filters_last_release_date':
                        (datetime,),
                    'filters_search_text':
                        ([str],),
                    'tax_exact_match':
                        (bool,),
                    'returned_content':
                        (V1AssemblyMetadataRequestContentType,),
                    'page_size':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'filters_reference_only': 'filters.reference_only',
                    'filters_assembly_source': 'filters.assembly_source',
                    'filters_has_annotation': 'filters.has_annotation',
                    'filters_exclude_paired_reports': 'filters.exclude_paired_reports',
                    'filters_exclude_atypical': 'filters.exclude_atypical',
                    'filters_assembly_version': 'filters.assembly_version',
                    'filters_assembly_level': 'filters.assembly_level',
                    'filters_first_release_date': 'filters.first_release_date',
                    'filters_last_release_date': 'filters.last_release_date',
                    'filters_search_text': 'filters.search_text',
                    'tax_exact_match': 'tax_exact_match',
                    'returned_content': 'returned_content',
                    'page_size': 'page_size',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'taxon': 'path',
                    'filters_reference_only': 'query',
                    'filters_assembly_source': 'query',
                    'filters_has_annotation': 'query',
                    'filters_exclude_paired_reports': 'query',
                    'filters_exclude_atypical': 'query',
                    'filters_assembly_version': 'query',
                    'filters_assembly_level': 'query',
                    'filters_first_release_date': 'query',
                    'filters_last_release_date': 'query',
                    'filters_search_text': 'query',
                    'tax_exact_match': 'query',
                    'returned_content': 'query',
                    'page_size': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'filters_assembly_level': 'multi',
                    'filters_search_text': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.check_assembly_availability_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyDatasetAvailability,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/accession/{accessions}/check',
                'operation_id': 'check_assembly_availability',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                },
                'location_map': {
                    'accessions': 'path',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.check_assembly_availability_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyDatasetAvailability,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/check',
                'operation_id': 'check_assembly_availability_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_assembly_dataset_request',
                ],
                'required': [
                    'v1_assembly_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_assembly_dataset_request':
                        (V1AssemblyDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_assembly_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.download_assembly_package_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/accession/{accessions}/download',
                'operation_id': 'download_assembly_package',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'chromosomes',
                    'exclude_sequence',
                    'include_annotation_type',
                    'hydrated',
                    'filename',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'chromosomes':
                        ([str],),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForAssemblyType],),
                    'hydrated':
                        (V1AssemblyDatasetRequestResolution,),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'chromosomes': 'chromosomes',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                    'hydrated': 'hydrated',
                    'filename': 'filename',
                },
                'location_map': {
                    'accessions': 'path',
                    'chromosomes': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                    'hydrated': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'chromosomes': 'multi',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.download_assembly_package_post_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/download',
                'operation_id': 'download_assembly_package_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_assembly_dataset_request',
                    'filename',
                ],
                'required': [
                    'v1_assembly_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_assembly_dataset_request':
                        (V1AssemblyDatasetRequest,),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'filename': 'filename',
                },
                'location_map': {
                    'v1_assembly_dataset_request': 'body',
                    'filename': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.genome_download_summary_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/accession/{accessions}/download_summary',
                'operation_id': 'genome_download_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'chromosomes',
                    'exclude_sequence',
                    'include_annotation_type',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'chromosomes':
                        ([str],),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForAssemblyType],),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'chromosomes': 'chromosomes',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'accessions': 'path',
                    'chromosomes': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'chromosomes': 'multi',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.genome_download_summary_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/download_summary',
                'operation_id': 'genome_download_summary_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_assembly_dataset_request',
                ],
                'required': [
                    'v1_assembly_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_assembly_dataset_request':
                        (V1AssemblyDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_assembly_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.genome_metadata_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1AssemblyMetadata,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome',
                'operation_id': 'genome_metadata_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_assembly_metadata_request',
                ],
                'required': [
                    'v1_assembly_metadata_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_assembly_metadata_request':
                        (V1AssemblyMetadataRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_assembly_metadata_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.genome_tax_name_query_endpoint = _Endpoint(
            settings={
                'response_type': (V1SciNameAndIds,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/taxon_suggest/{taxon_query}',
                'operation_id': 'genome_tax_name_query',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon_query',
                    'tax_rank_filter',
                ],
                'required': [
                    'taxon_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon_query':
                        (str,),
                    'tax_rank_filter':
                        (V1OrganismQueryRequestTaxRankFilter,),
                },
                'attribute_map': {
                    'taxon_query': 'taxon_query',
                    'tax_rank_filter': 'tax_rank_filter',
                },
                'location_map': {
                    'taxon_query': 'path',
                    'tax_rank_filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.genome_tax_tree_endpoint = _Endpoint(
            settings={
                'response_type': (V1Organism,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/genome/taxon/{taxon}/tree',
                'operation_id': 'genome_tax_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'children_only',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'children_only':
                        (bool,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'children_only': 'children_only',
                },
                'location_map': {
                    'taxon': 'path',
                    'children_only': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def assembly_descriptors_by_accessions(
        self,
        accessions,
        **kwargs
    ):
        """Get genome metadata by accession  # noqa: E501

        Get detailed metadata for assembled genomes by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assembly_descriptors_by_accessions(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]):

        Keyword Args:
            filters_reference_only (bool): If true, only return reference and representative (GCF_ and GCA_) genome assemblies.. [optional] if omitted the server will use the default value of False
            filters_assembly_source (V1AssemblyDatasetDescriptorsFilterAssemblySource): Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies. [optional]
            filters_has_annotation (bool): Return only annotated genome assemblies. [optional] if omitted the server will use the default value of False
            filters_exclude_atypical (bool): If true, exclude atypical genomes, i.e. genomes that have assembly issues or are otherwise atypical. [optional] if omitted the server will use the default value of False
            filters_assembly_level ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel]): Only return genome assemblies that have one of the specified assembly levels. By default, do not filter.. [optional]
            filters_first_release_date (datetime): Only return genome assemblies that were released on or after the specified date By default, do not filter.. [optional]
            filters_last_release_date (datetime): Only return genome assemblies that were released on or before to the specified date By default, do not filter.. [optional]
            filters_search_text ([str]): Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields By default, do not filter. [optional]
            page_size (int): The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.. [optional] if omitted the server will use the default value of 20
            page_token (str): A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.assembly_descriptors_by_accessions_endpoint.call_with_http_info(**kwargs)

    def assembly_descriptors_by_bioproject(
        self,
        accessions,
        **kwargs
    ):
        """Get genome metadata by bioproject accession  # noqa: E501

        Get detailed metadata for assembled genomes by bioproject accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assembly_descriptors_by_bioproject(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]):

        Keyword Args:
            filters_reference_only (bool): If true, only return reference and representative (GCF_ and GCA_) genome assemblies.. [optional] if omitted the server will use the default value of False
            filters_assembly_source (V1AssemblyDatasetDescriptorsFilterAssemblySource): Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies. [optional]
            filters_has_annotation (bool): Return only annotated genome assemblies. [optional] if omitted the server will use the default value of False
            filters_exclude_paired_reports (bool): For paired (GCA/GCF) records, only return the primary record. [optional] if omitted the server will use the default value of False
            filters_exclude_atypical (bool): If true, exclude atypical genomes, i.e. genomes that have assembly issues or are otherwise atypical. [optional] if omitted the server will use the default value of False
            filters_assembly_version (V1AssemblyDatasetDescriptorsFilterAssemblyVersion): Return all assemblies, including replaced and suppressed, or only current assemblies. [optional]
            filters_assembly_level ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel]): Only return genome assemblies that have one of the specified assembly levels. By default, do not filter.. [optional]
            filters_first_release_date (datetime): Only return genome assemblies that were released on or after the specified date By default, do not filter.. [optional]
            filters_last_release_date (datetime): Only return genome assemblies that were released on or before to the specified date By default, do not filter.. [optional]
            filters_search_text ([str]): Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields By default, do not filter. [optional]
            returned_content (V1AssemblyMetadataRequestContentType): Return either assembly accessions, or entire assembly-metadata records. [optional]
            page_size (int): The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.. [optional] if omitted the server will use the default value of 20
            page_token (str): A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.assembly_descriptors_by_bioproject_endpoint.call_with_http_info(**kwargs)

    def assembly_descriptors_by_taxon(
        self,
        taxon,
        **kwargs
    ):
        """Get genome metadata by taxonomic identifier  # noqa: E501

        Get detailed metadata on all assembled genomes for a specified NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assembly_descriptors_by_taxon(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            filters_reference_only (bool): If true, only return reference and representative (GCF_ and GCA_) genome assemblies.. [optional] if omitted the server will use the default value of False
            filters_assembly_source (V1AssemblyDatasetDescriptorsFilterAssemblySource): Return only RefSeq (GCF_) or GenBank (GCA_) genome assemblies. [optional]
            filters_has_annotation (bool): Return only annotated genome assemblies. [optional] if omitted the server will use the default value of False
            filters_exclude_paired_reports (bool): For paired (GCA/GCF) records, only return the primary record. [optional] if omitted the server will use the default value of False
            filters_exclude_atypical (bool): If true, exclude atypical genomes, i.e. genomes that have assembly issues or are otherwise atypical. [optional] if omitted the server will use the default value of False
            filters_assembly_version (V1AssemblyDatasetDescriptorsFilterAssemblyVersion): Return all assemblies, including replaced and suppressed, or only current assemblies. [optional]
            filters_assembly_level ([V1AssemblyDatasetDescriptorsFilterAssemblyLevel]): Only return genome assemblies that have one of the specified assembly levels. By default, do not filter.. [optional]
            filters_first_release_date (datetime): Only return genome assemblies that were released on or after the specified date By default, do not filter.. [optional]
            filters_last_release_date (datetime): Only return genome assemblies that were released on or before to the specified date By default, do not filter.. [optional]
            filters_search_text ([str]): Only return results whose fields contain the specified search terms in their taxon, infraspecific, assembly name or submitter fields By default, do not filter. [optional]
            tax_exact_match (bool): If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.. [optional] if omitted the server will use the default value of False
            returned_content (V1AssemblyMetadataRequestContentType): Return either assembly accessions, or entire assembly-metadata records. [optional]
            page_size (int): The maximum number of genome assemblies to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.. [optional] if omitted the server will use the default value of 20
            page_token (str): A page token is returned from an `AssemblyMetadataRequest` call with more than `page_size` results. Use this token, along with the previous `AssemblyMetadataRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.assembly_descriptors_by_taxon_endpoint.call_with_http_info(**kwargs)

    def check_assembly_availability(
        self,
        accessions,
        **kwargs
    ):
        """Check the validity of genome accessions  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.check_assembly_availability(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): NCBI genome assembly accessions

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyDatasetAvailability
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.check_assembly_availability_endpoint.call_with_http_info(**kwargs)

    def check_assembly_availability_post(
        self,
        v1_assembly_dataset_request,
        **kwargs
    ):
        """Check the validity of many genome accessions in a single request  # noqa: E501

        The 'GET' version of check is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.check_assembly_availability_post(v1_assembly_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_assembly_dataset_request (V1AssemblyDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyDatasetAvailability
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_assembly_dataset_request'] = \
            v1_assembly_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.check_assembly_availability_post_endpoint.call_with_http_info(**kwargs)

    def download_assembly_package(
        self,
        accessions,
        **kwargs
    ):
        """Get a genome dataset by accession  # noqa: E501

        Download a genome dataset including fasta sequence, annotation and a detailed data report by accession.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_assembly_package(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): NCBI genome assembly accessions

        Keyword Args:
            chromosomes ([str]): The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.. [optional]
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForAssemblyType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            hydrated (V1AssemblyDatasetRequestResolution): Set to DATA_REPORT_ONLY, to only retrieve data-reports.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.download_assembly_package_endpoint.call_with_http_info(**kwargs)

    def download_assembly_package_post(
        self,
        v1_assembly_dataset_request,
        **kwargs
    ):
        """Get a genome dataset by post  # noqa: E501

        The 'GET' version of download is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_assembly_package_post(v1_assembly_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_assembly_dataset_request (V1AssemblyDatasetRequest):

        Keyword Args:
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_assembly_dataset_request'] = \
            v1_assembly_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.download_assembly_package_post_endpoint.call_with_http_info(**kwargs)

    def genome_download_summary(
        self,
        accessions,
        **kwargs
    ):
        """Preview genome dataset download  # noqa: E501

        Get a download summary by accession in a JSON output format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.genome_download_summary(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): NCBI genome assembly accessions

        Keyword Args:
            chromosomes ([str]): The default setting is all chromosome. Specify individual chromosome by string (1,2,MT or chr1,chr2.chrMT). Unplaced sequences are treated like their own chromosome ('Un'). The filter only applies to fasta sequence.. [optional]
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForAssemblyType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.genome_download_summary_endpoint.call_with_http_info(**kwargs)

    def genome_download_summary_by_post(
        self,
        v1_assembly_dataset_request,
        **kwargs
    ):
        """Preview genome dataset download by POST  # noqa: E501

        The 'GET' version of download summary is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.genome_download_summary_by_post(v1_assembly_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_assembly_dataset_request (V1AssemblyDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_assembly_dataset_request'] = \
            v1_assembly_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.genome_download_summary_by_post_endpoint.call_with_http_info(**kwargs)

    def genome_metadata_by_post(
        self,
        v1_assembly_metadata_request,
        **kwargs
    ):
        """Get genome metadata by variety of identifiers  # noqa: E501

        Get detailed metadata for assembled genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.genome_metadata_by_post(v1_assembly_metadata_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_assembly_metadata_request (V1AssemblyMetadataRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1AssemblyMetadata
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_assembly_metadata_request'] = \
            v1_assembly_metadata_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.genome_metadata_by_post_endpoint.call_with_http_info(**kwargs)

    def genome_tax_name_query(
        self,
        taxon_query,
        **kwargs
    ):
        """Get a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name  # noqa: E501

        This endpoint retrieves a list of taxonomy names and IDs found in the assembly dataset given a partial taxonomic name of any rank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.genome_tax_name_query(taxon_query, async_req=True)
        >>> result = thread.get()

        Args:
            taxon_query (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            tax_rank_filter (V1OrganismQueryRequestTaxRankFilter): Set the scope of searched tax ranks. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1SciNameAndIds
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon_query'] = \
            taxon_query
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.genome_tax_name_query_endpoint.call_with_http_info(**kwargs)

    def genome_tax_tree(
        self,
        taxon,
        **kwargs
    ):
        """Get a taxonomic subtree by taxonomic identifier  # noqa: E501

        Using a NCBI Taxonomy ID or name (common or scientific) at any rank, get a subtree filtered for species with assembled genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.genome_tax_tree(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            children_only (bool): Only report the children of the requested taxon and not their descendants. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1Organism
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.genome_tax_tree_endpoint.call_with_http_info(**kwargs)

