"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAction = exports.PropsUtil = exports.DeploymentPlan = exports.AttiniDeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class AttiniDeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.AttiniDeploymentPlanStack = AttiniDeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
AttiniDeploymentPlanStack[_a] = { fqn: "@attini/cdk.AttiniDeploymentPlanStack", version: "1.1.0" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "1.1.0" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_c = JSII_RTTI_SYMBOL_1;
PropsUtil[_c] = { fqn: "@attini/cdk.PropsUtil", version: "1.1.0" };
var CfnAction;
(function (CfnAction) {
    CfnAction[CfnAction["DEPLOY"] = 0] = "DEPLOY";
    CfnAction[CfnAction["DELETE"] = 1] = "DELETE";
})(CfnAction = exports.CfnAction || (exports.CfnAction = {}));
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
__exportStar(require("./attini-runner"), exports);
__exportStar(require("./attini-cdk"), exports);
__exportStar(require("./attini-runtime-variables"), exports);
//# sourceMappingURL=data:application/json;base64,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