"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniRunnerJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const attini_task_1 = require("./attini-task");
/**
 * The AttiniRunnerJob is a quick and cost-efficient way to run shell commands using a container.
 */
class AttiniRunnerJob extends attini_task_1.AttiniTask {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.type = 'AttiniRunnerJob';
        this.props = props;
    }
    renderProps() {
        let finalProperties = {
            Commands: this.props.commands,
        };
        if (this.props.environment) {
            finalProperties.Environment = this.props.environment;
        }
        if (this.props.runner) {
            finalProperties.Runner = this.props.runner;
        }
        return { Properties: aws_stepfunctions_1.FieldUtils.renderObject(finalProperties) };
    }
}
exports.AttiniRunnerJob = AttiniRunnerJob;
_a = JSII_RTTI_SYMBOL_1;
AttiniRunnerJob[_a] = { fqn: "@attini/cdk.AttiniRunnerJob", version: "1.1.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0aW5pLXJ1bm5lci1qb2IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXR0aW5pLXJ1bm5lci1qb2IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxRUFBMkQ7QUFFM0QsK0NBQTJDO0FBRTNDOztHQUVHO0FBQ0gsTUFBYSxlQUFnQixTQUFRLHdCQUFVO0lBSTdDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQVUsS0FBMkI7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUQrQixVQUFLLEdBQUwsS0FBSyxDQUFzQjtRQUY3RSxTQUFJLEdBQVcsaUJBQWlCLENBQUM7UUFJL0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUVTLFdBQVc7UUFDbkIsSUFBSSxlQUFlLEdBQXlCO1lBQzFDLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDOUIsQ0FBQztRQUVGLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUU7WUFDMUIsZUFBZSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQztTQUN0RDtRQUNELElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUU7WUFDckIsZUFBZSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM1QztRQUNELE9BQU8sRUFBRSxVQUFVLEVBQUUsOEJBQVUsQ0FBQyxZQUFZLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQztJQUNsRSxDQUFDOztBQXJCSCwwQ0F3QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBGaWVsZFV0aWxzIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBBdHRpbmlUYXNrIH0gZnJvbSAnLi9hdHRpbmktdGFzayc7XG5cbi8qKlxuICogVGhlIEF0dGluaVJ1bm5lckpvYiBpcyBhIHF1aWNrIGFuZCBjb3N0LWVmZmljaWVudCB3YXkgdG8gcnVuIHNoZWxsIGNvbW1hbmRzIHVzaW5nIGEgY29udGFpbmVyLlxuICovXG5leHBvcnQgY2xhc3MgQXR0aW5pUnVubmVySm9iIGV4dGVuZHMgQXR0aW5pVGFzayB7XG5cbiAgdHlwZTogc3RyaW5nID0gJ0F0dGluaVJ1bm5lckpvYic7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSBwcm9wczogQXR0aW5pUnVubmVySm9iUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJQcm9wcygpOiBvYmplY3Qge1xuICAgIGxldCBmaW5hbFByb3BlcnRpZXM6IHsgW2s6IHN0cmluZ106IGFueSB9ID0ge1xuICAgICAgQ29tbWFuZHM6IHRoaXMucHJvcHMuY29tbWFuZHMsXG4gICAgfTtcblxuICAgIGlmICh0aGlzLnByb3BzLmVudmlyb25tZW50KSB7XG4gICAgICBmaW5hbFByb3BlcnRpZXMuRW52aXJvbm1lbnQgPSB0aGlzLnByb3BzLmVudmlyb25tZW50O1xuICAgIH1cbiAgICBpZiAodGhpcy5wcm9wcy5ydW5uZXIpIHtcbiAgICAgIGZpbmFsUHJvcGVydGllcy5SdW5uZXIgPSB0aGlzLnByb3BzLnJ1bm5lcjtcbiAgICB9XG4gICAgcmV0dXJuIHsgUHJvcGVydGllczogRmllbGRVdGlscy5yZW5kZXJPYmplY3QoZmluYWxQcm9wZXJ0aWVzKSB9O1xuICB9XG5cblxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF0dGluaVJ1bm5lckpvYlByb3BzIHtcblxuICAvKipcbiAgICogQSByZWZlcmVuY2UgdG8gYW4ge0BsaW5rIEF0dGluaVJ1bm5lcn0gdG8gdXNlIGZvciBleGVjdXRpbmcgdGhlIGpvYi5cbiAgICogVXNlIHtAbGluayBBdHRpbmlSdW5uZXIucnVubmVyTmFtZX0gdG8gZ2V0IGEgcmVmZXJlbmNlLlxuICAgKlxuICAgKiBJZiBvbWl0dGVkIHRoZSBBdHRpbmkgZGVmYXVsdCBydW5uZXIgd2lsbCBiZSB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgcnVubmVyPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIGxpc3Qgb2Ygc2hlbGwgY29tbWFuZHMgdGhhdCB3aWxsIGJlIGV4ZWN1dGVkIGJ5IHRoZSBSdW5uZXIuXG4gICAqL1xuICByZWFkb25seSBjb21tYW5kczogQXJyYXk8c3RyaW5nPjtcblxuICAvKipcbiAgICogRW52aXJvbm1lbnQgdmFyaWFibGVzIHRoYXQgd2lsbCBiZSBzZXQgaW4gdGhlIHNoZWxsIGZvciB0aGUgcnVubmVyIGpvYi5cbiAgICovXG4gIHJlYWRvbmx5IGVudmlyb25tZW50PzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbn1cbiJdfQ==