from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    BooleanType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class TestScriptAssertSchema:
    """
    TestScript is a resource that specifies a suite of tests against a FHIR server
    implementation to determine compliance against the FHIR specification.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        TestScript is a resource that specifies a suite of tests against a FHIR server
        implementation to determine compliance against the FHIR specification.


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            modifierExtension: May be used to represent additional information that is not part of the basic
        definition of the element, and that modifies the understanding of the element
        that contains it. Usually modifier elements provide negation or qualification.
        In order to make the use of extensions safe and manageable, there is a strict
        set of governance applied to the definition and use of extensions. Though any
        implementer is allowed to define an extension, there is a set of requirements
        that SHALL be met as part of the definition of the extension. Applications
        processing a resource are required to check for modifier extensions.
            label: The label would be used for tracking/logging purposes by test engines.
            description: The description would be used by test engines for tracking and reporting
        purposes.
            direction: The direction to use for the assertion.
            compareToSourceId: Id of fixture used to compare the "sourceId/path" evaluations to.
            compareToSourcePath: XPath or JSONPath expression against fixture used to compare the
        "sourceId/path" evaluations to.
            contentType: The content-type or mime-type to use for RESTful operation in the 'Content-
        Type' header.
            headerField: The HTTP header field name e.g. 'Location'.
            minimumId: The ID of a fixture.  Asserts that the response contains at a minimumId the
        fixture specified by minimumId.
            navigationLinks: Whether or not the test execution performs validation on the bundle navigation
        links.
            operator: The operator type.
            path: The XPath or JSONPath expression to be evaluated against the fixture
        representing the response received from server.
            resource: The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.
            response: okay | created | noContent | notModified | bad | forbidden | notFound |
        methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.
            responseCode: The value of the HTTP response code to be tested.
            sourceId: Fixture to evaluate the XPath/JSONPath expression or the headerField  against.
            validateProfileId: The ID of the Profile to validate against.
            value: The value to compare to.
            warningOnly: Whether or not the test execution will produce a warning only on error for
        this assert.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # direction
        # type = code
        if (
            max_recursion_limit
            and nesting_list.count("TestScriptAssert") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["TestScriptAssert"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth + 1,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element, and that modifies the understanding of the element
                # that contains it. Usually modifier elements provide negation or qualification.
                # In order to make the use of extensions safe and manageable, there is a strict
                # set of governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                StructField(
                    "modifierExtension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth + 1,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The label would be used for tracking/logging purposes by test engines.
                StructField("label", StringType(), True),
                # The description would be used by test engines for tracking and reporting
                # purposes.
                StructField("description", StringType(), True),
                # The direction to use for the assertion.
                StructField("direction", StringType(), True),
                # Id of fixture used to compare the "sourceId/path" evaluations to.
                StructField("compareToSourceId", StringType(), True),
                # XPath or JSONPath expression against fixture used to compare the
                # "sourceId/path" evaluations to.
                StructField("compareToSourcePath", StringType(), True),
                # The content-type or mime-type to use for RESTful operation in the 'Content-
                # Type' header.
                StructField("contentType", StringType(), True),
                # The HTTP header field name e.g. 'Location'.
                StructField("headerField", StringType(), True),
                # The ID of a fixture.  Asserts that the response contains at a minimumId the
                # fixture specified by minimumId.
                StructField("minimumId", StringType(), True),
                # Whether or not the test execution performs validation on the bundle navigation
                # links.
                StructField("navigationLinks", BooleanType(), True),
                # The operator type.
                StructField("operator", StringType(), True),
                # The XPath or JSONPath expression to be evaluated against the fixture
                # representing the response received from server.
                StructField("path", StringType(), True),
                # The type of the resource.  See http://hl7-fhir.github.io/resourcelist.html.
                StructField("resource", StringType(), True),
                # okay | created | noContent | notModified | bad | forbidden | notFound |
                # methodNotAllowed | conflict | gone | preconditionFailed | unprocessable.
                StructField("response", StringType(), True),
                # The value of the HTTP response code to be tested.
                StructField("responseCode", StringType(), True),
                # Fixture to evaluate the XPath/JSONPath expression or the headerField  against.
                StructField(
                    "sourceId",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The ID of the Profile to validate against.
                StructField(
                    "validateProfileId",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The value to compare to.
                StructField("value", StringType(), True),
                # Whether or not the test execution will produce a warning only on error for
                # this assert.
                StructField("warningOnly", BooleanType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
