import os
from os.path import dirname, abspath, isfile, join
from .utils.write_file import write_file
from shutil import copytree, copy
from .files import (
    readme,
    gitignore,
    app,
    env,
    start,
    templates_layout
)

def gen_template(name):
    os.mkdir(name)
    web_path = name + f"/{name}_web"
    api_path = name + f"/{name}_api"
    root = dirname(abspath(__file__))
    static_path = root + "/files/static"
    static_files = [join(static_path, f) for f in os.listdir(static_path) if isfile(join(static_path, f))]
    for f in static_files:
        copy(f, name)
    copytree(static_path + "/web", web_path)
    copytree(static_path + "/api", api_path)
    os.makedirs(api_path + "/blueprints")
    os.makedirs(web_path + "/blueprints")
    write_file(name + "/.gitignore", gitignore(name))
    write_file(name + "/README.md", readme(name))
    write_file(name + "/app.py", app(name))
    write_file(name + "/.env", env(name))
    write_file(name + "/start.py", start(name))
    write_file(name + f"/{name}_web/templates/_layout.html", templates_layout(name))

