"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageFunction = exports.DockerImageCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const code_1 = require("./code");
const function_1 = require("./function");
const handler_1 = require("./handler");
const runtime_1 = require("./runtime");
/**
 * Code property for the DockerImageFunction construct.
 *
 * @stability stable
 */
class DockerImageCode {
    /**
     * Use an existing ECR image as the Lambda code.
     *
     * @param repository the ECR repository that the image is in.
     * @param props properties to further configure the selected image.
     * @stability stable
     */
    static fromEcr(repository, props) {
        return {
            _bind() {
                return new code_1.EcrImageCode(repository, props);
            },
        };
    }
    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     *
     * @param directory the directory from which the asset must be created.
     * @param props properties to further configure the selected image.
     * @stability stable
     */
    static fromImageAsset(directory, props = {}) {
        return {
            _bind() {
                return new code_1.AssetImageCode(directory, props);
            },
        };
    }
}
exports.DockerImageCode = DockerImageCode;
_a = JSII_RTTI_SYMBOL_1;
DockerImageCode[_a] = { fqn: "@aws-cdk/aws-lambda.DockerImageCode", version: "1.107.0" };
/**
 * Create a lambda function where the handler is a docker image.
 *
 * @stability stable
 */
class DockerImageFunction extends function_1.Function {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            handler: handler_1.Handler.FROM_IMAGE,
            runtime: runtime_1.Runtime.FROM_IMAGE,
            code: props.code._bind(),
        });
    }
}
exports.DockerImageFunction = DockerImageFunction;
_b = JSII_RTTI_SYMBOL_1;
DockerImageFunction[_b] = { fqn: "@aws-cdk/aws-lambda.DockerImageFunction", version: "1.107.0" };
//# sourceMappingURL=data:application/json;base64,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