import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CredentialSshPrivateKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the credential store this credential belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#credential_store_id CredentialSshPrivateKey#credential_store_id}
    */
    readonly credentialStoreId: string;
    /**
    * The description of the credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#description CredentialSshPrivateKey#description}
    */
    readonly description?: string;
    /**
    * The name of the credential. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#name CredentialSshPrivateKey#name}
    */
    readonly name?: string;
    /**
    * The private key associated with the credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#private_key CredentialSshPrivateKey#private_key}
    */
    readonly privateKey: string;
    /**
    * The passphrase of the private key associated with the credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#private_key_passphrase CredentialSshPrivateKey#private_key_passphrase}
    */
    readonly privateKeyPassphrase?: string;
    /**
    * The username associated with the credential.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key#username CredentialSshPrivateKey#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key boundary_credential_ssh_private_key}
*/
export declare class CredentialSshPrivateKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_credential_ssh_private_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/credential_ssh_private_key boundary_credential_ssh_private_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CredentialSshPrivateKeyConfig
    */
    constructor(scope: Construct, id: string, config: CredentialSshPrivateKeyConfig);
    private _credentialStoreId?;
    get credentialStoreId(): string;
    set credentialStoreId(value: string);
    get credentialStoreIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    get privateKeyHmac(): string;
    private _privateKeyPassphrase?;
    get privateKeyPassphrase(): string;
    set privateKeyPassphrase(value: string);
    resetPrivateKeyPassphrase(): void;
    get privateKeyPassphraseInput(): string | undefined;
    get privateKeyPassphraseHmac(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
