import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodPasswordConfig extends cdktf.TerraformMetaArguments {
    /**
    * The auth method description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#description AuthMethodPassword#description}
    */
    readonly description?: string;
    /**
    * The minimum login name length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#min_login_name_length AuthMethodPassword#min_login_name_length}
    */
    readonly minLoginNameLength?: number;
    /**
    * The minimum password length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#min_password_length AuthMethodPassword#min_password_length}
    */
    readonly minPasswordLength?: number;
    /**
    * The auth method name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#name AuthMethodPassword#name}
    */
    readonly name?: string;
    /**
    * The scope ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#scope_id AuthMethodPassword#scope_id}
    */
    readonly scopeId: string;
    /**
    * The resource type, hardcoded per resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password#type AuthMethodPassword#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password boundary_auth_method_password}
*/
export declare class AuthMethodPassword extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_auth_method_password";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/auth_method_password boundary_auth_method_password} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodPasswordConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodPasswordConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _minLoginNameLength?;
    get minLoginNameLength(): number;
    set minLoginNameLength(value: number);
    resetMinLoginNameLength(): void;
    get minLoginNameLengthInput(): number | undefined;
    private _minPasswordLength?;
    get minPasswordLength(): number;
    set minPasswordLength(value: number);
    resetMinPasswordLength(): void;
    get minPasswordLengthInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
