import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccountOidcConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID for the auth method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc#auth_method_id AccountOidc#auth_method_id}
    */
    readonly authMethodId: string;
    /**
    * The account description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc#description AccountOidc#description}
    */
    readonly description?: string;
    /**
    * The OIDC issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc#issuer AccountOidc#issuer}
    */
    readonly issuer?: string;
    /**
    * The account name. Defaults to the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc#name AccountOidc#name}
    */
    readonly name?: string;
    /**
    * The OIDC subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc#subject AccountOidc#subject}
    */
    readonly subject?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc boundary_account_oidc}
*/
export declare class AccountOidc extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_account_oidc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/account_oidc boundary_account_oidc} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccountOidcConfig
    */
    constructor(scope: Construct, id: string, config: AccountOidcConfig);
    private _authMethodId?;
    get authMethodId(): string;
    set authMethodId(value: string);
    get authMethodIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
