# Generated by Django 3.2.13 on 2022-10-18 00:18

from django.db import migrations, models
import django.utils.timezone
import jsonfield.fields
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="MemberpressEvents",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "sender",
                    models.URLField(
                        blank=True, help_text="The site referrer. Example: https://wordpress-site.com/mb/webhooks/"
                    ),
                ),
                ("username", models.CharField(help_text="The username provided by memberpress.", max_length=50)),
                (
                    "event",
                    models.CharField(
                        choices=[
                            ("after-cc-expires-reminder", "after-cc-expires-reminder"),
                            ("after-member-signup-reminder", "after-member-signup-reminder"),
                            ("after-signup-abandoned-reminder", "after-signup-abandoned-reminder"),
                            ("after-sub-expires-reminder", "after-sub-expires-reminder"),
                            ("before-cc-expires-reminder", "before-cc-expires-reminder"),
                            ("before-sub-expires-reminder", "before-sub-expires-reminder"),
                            ("before-sub-renews-reminder", "before-sub-renews-reminder"),
                            ("before-sub-trial-ends", "before-sub-trial-ends"),
                            ("login", "login"),
                            ("member-account-updated", "member-account-updated"),
                            ("member-added", "member-added"),
                            ("member-deleted", "member-deleted"),
                            ("member-signup-completed", "member-signup-completed"),
                            ("mpca-course-completed", "mpca-course-completed"),
                            ("mpca-course-started", "mpca-course-started"),
                            ("mpca-lesson-completed", "mpca-lesson-completed"),
                            ("mpca-lesson-started", "mpca-lesson-started"),
                            ("mpca-quiz-attempt-completed", "mpca-quiz-attempt-completed"),
                            ("non-recurring-transaction-completed", "non-recurring-transaction-completed"),
                            ("non-recurring-transaction-expired", "non-recurring-transaction-expired"),
                            ("offline-payment-complete", "offline-payment-complete"),
                            ("offline-payment-pending", "offline-payment-pending"),
                            ("offline-payment-refunded", "offline-payment-refunded"),
                            ("recurring-transaction-completed", "recurring-transaction-completed"),
                            ("recurring-transaction-expired", "recurring-transaction-expired"),
                            ("recurring-transaction-failed", "recurring-transaction-failed"),
                            ("renewal-transaction-completed", "renewal-transaction-completed"),
                            ("sub-account-added", "sub-account-added"),
                            ("sub-account-removed", "sub-account-removed"),
                            ("subscription-created", "subscription-created"),
                            ("subscription-downgraded-to-one-time", "subscription-downgraded-to-one-time"),
                            ("subscription-downgraded-to-recurring", "subscription-downgraded-to-recurring"),
                            ("subscription-downgraded", "subscription-downgraded"),
                            ("subscription-expired", "subscription-expired"),
                            ("subscription-paused", "subscription-paused"),
                            ("subscription-resumed", "subscription-resumed"),
                            ("subscription-stopped", "subscription-stopped"),
                            ("subscription-upgraded-to-one-time", "subscription-upgraded-to-one-time"),
                            ("subscription-upgraded-to-recurring", "subscription-upgraded-to-recurring"),
                            ("subscription-upgraded", "subscription-upgraded"),
                            ("transaction-completed", "transaction-completed"),
                            ("transaction-expired", "transaction-expired"),
                            ("transaction-failed", "transaction-failed"),
                            ("transaction-refunded", "transaction-refunded"),
                            ("unidentified-event", "unidentified-event"),
                        ],
                        help_text="The memberpress event. Examples: recurring-transaction-completed",
                        max_length=50,
                    ),
                ),
                (
                    "event_type",
                    models.CharField(
                        choices=[
                            ("member", "member"),
                            ("membership", "membership"),
                            ("subscription", "subscription"),
                            ("transaction", "transaction"),
                        ],
                        help_text="The type of memberpress event: transaction, subscription, member, membership",
                        max_length=50,
                    ),
                ),
                (
                    "is_valid",
                    models.BooleanField(
                        help_text="True if the json received was validated by memberpress_client. False otherwise."
                    ),
                ),
                (
                    "json",
                    jsonfield.fields.JSONField(
                        blank=True, default={}, help_text="A json dict sent by the webhook event in the request body."
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "memberpress events",
            },
        ),
    ]
