# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, conlist, constr
from lusid_workflow.models.link import Link
from lusid_workflow.models.parameter import Parameter
from lusid_workflow.models.resource_id import ResourceId
from lusid_workflow.models.result_field import ResultField
from lusid_workflow.models.version_info import VersionInfo
from lusid_workflow.models.worker_configuration_response import WorkerConfigurationResponse

class Worker(BaseModel):
    """
    Information about the Worker  # noqa: E501
    """
    id: ResourceId = Field(...)
    display_name: constr(strict=True, min_length=1) = Field(..., alias="displayName", description="Human readable name")
    description: Optional[StrictStr] = Field(None, description="Human readable description")
    worker_configuration: WorkerConfigurationResponse = Field(..., alias="workerConfiguration")
    version: Optional[VersionInfo] = None
    parameters: Optional[conlist(Parameter)] = Field(None, description="The Parameters this Worker accepts or requires.")
    result_fields: Optional[conlist(ResultField)] = Field(None, alias="resultFields", description="The Fields that the Worker results will come back with.")
    links: Optional[conlist(Link)] = None
    __properties = ["id", "displayName", "description", "workerConfiguration", "version", "parameters", "resultFields", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Worker:
        """Create an instance of Worker from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of id
        if self.id:
            _dict['id'] = self.id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of worker_configuration
        if self.worker_configuration:
            _dict['workerConfiguration'] = self.worker_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version
        if self.version:
            _dict['version'] = self.version.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in result_fields (list)
        _items = []
        if self.result_fields:
            for _item in self.result_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['resultFields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        # set to None if result_fields (nullable) is None
        # and __fields_set__ contains the field
        if self.result_fields is None and "result_fields" in self.__fields_set__:
            _dict['resultFields'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Worker:
        """Create an instance of Worker from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Worker.parse_obj(obj)

        _obj = Worker.parse_obj({
            "id": ResourceId.from_dict(obj.get("id")) if obj.get("id") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "worker_configuration": WorkerConfigurationResponse.from_dict(obj.get("workerConfiguration")) if obj.get("workerConfiguration") is not None else None,
            "version": VersionInfo.from_dict(obj.get("version")) if obj.get("version") is not None else None,
            "parameters": [Parameter.from_dict(_item) for _item in obj.get("parameters")] if obj.get("parameters") is not None else None,
            "result_fields": [ResultField.from_dict(_item) for _item in obj.get("resultFields")] if obj.get("resultFields") is not None else None,
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
