# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr, validator
from lusid_workflow.models.field_mapping import FieldMapping
from lusid_workflow.models.resource_id import ResourceId
from lusid_workflow.models.result_matching_pattern import ResultMatchingPattern

class ResultantChildTaskConfiguration(BaseModel):
    """
    Child Task Configuration  # noqa: E501
    """
    result_matching_pattern: Optional[ResultMatchingPattern] = Field(None, alias="resultMatchingPattern")
    task_definition_id: ResourceId = Field(..., alias="taskDefinitionId")
    task_definition_as_at: Optional[datetime] = Field(None, alias="taskDefinitionAsAt", description="TaskDefinition AsAt timestamp")
    initial_trigger: Optional[constr(strict=True, max_length=1024)] = Field(None, alias="initialTrigger", description="The Initial Trigger for automatic start")
    child_task_fields: Dict[str, FieldMapping] = Field(..., alias="childTaskFields", description="Field Mappings")
    map_stacking_key_from: Optional[StrictStr] = Field(None, alias="mapStackingKeyFrom", description="The field to be mapped as the ChildTasks Stacking Key")
    __properties = ["resultMatchingPattern", "taskDefinitionId", "taskDefinitionAsAt", "initialTrigger", "childTaskFields", "mapStackingKeyFrom"]

    @validator('initial_trigger')
    def initial_trigger_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9\-_]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9\-_]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResultantChildTaskConfiguration:
        """Create an instance of ResultantChildTaskConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of result_matching_pattern
        if self.result_matching_pattern:
            _dict['resultMatchingPattern'] = self.result_matching_pattern.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_definition_id
        if self.task_definition_id:
            _dict['taskDefinitionId'] = self.task_definition_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in child_task_fields (dict)
        _field_dict = {}
        if self.child_task_fields:
            for _key in self.child_task_fields:
                if self.child_task_fields[_key]:
                    _field_dict[_key] = self.child_task_fields[_key].to_dict()
            _dict['childTaskFields'] = _field_dict
        # set to None if task_definition_as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.task_definition_as_at is None and "task_definition_as_at" in self.__fields_set__:
            _dict['taskDefinitionAsAt'] = None

        # set to None if initial_trigger (nullable) is None
        # and __fields_set__ contains the field
        if self.initial_trigger is None and "initial_trigger" in self.__fields_set__:
            _dict['initialTrigger'] = None

        # set to None if map_stacking_key_from (nullable) is None
        # and __fields_set__ contains the field
        if self.map_stacking_key_from is None and "map_stacking_key_from" in self.__fields_set__:
            _dict['mapStackingKeyFrom'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResultantChildTaskConfiguration:
        """Create an instance of ResultantChildTaskConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResultantChildTaskConfiguration.parse_obj(obj)

        _obj = ResultantChildTaskConfiguration.parse_obj({
            "result_matching_pattern": ResultMatchingPattern.from_dict(obj.get("resultMatchingPattern")) if obj.get("resultMatchingPattern") is not None else None,
            "task_definition_id": ResourceId.from_dict(obj.get("taskDefinitionId")) if obj.get("taskDefinitionId") is not None else None,
            "task_definition_as_at": obj.get("taskDefinitionAsAt"),
            "initial_trigger": obj.get("initialTrigger"),
            "child_task_fields": dict(
                (_k, FieldMapping.from_dict(_v))
                for _k, _v in obj.get("childTaskFields").items()
            )
            if obj.get("childTaskFields") is not None
            else None,
            "map_stacking_key_from": obj.get("mapStackingKeyFrom")
        })
        return _obj
