# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, constr

class ResultField(BaseModel):
    """
    Defines a Worker Result Field  # noqa: E501
    """
    name: constr(strict=True, min_length=1) = Field(..., description="Name")
    type: constr(strict=True, min_length=1) = Field(..., description="The type of this Parameter")
    display_name: Optional[StrictStr] = Field(None, alias="displayName", description="DisplayName")
    description: Optional[StrictStr] = Field(None, description="Description")
    __properties = ["name", "type", "displayName", "description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResultField:
        """Create an instance of ResultField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResultField:
        """Create an instance of ResultField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResultField.parse_obj(obj)

        _obj = ResultField.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description")
        })
        return _obj
